/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.text.SimpleDateFormat;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Http {
    private static final Logger logger = LoggerFactory.getLogger((String)"pos_http");

    public String httpPostData(String url, String urlvalue, int timeout, boolean isPing) {
        String rev = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String time = System.currentTimeMillis() + "";
        try {
            DefaultHttpClient httpclient = new DefaultHttpClient();
            httpclient.getParams().setParameter("http.connection.timeout", (Object)timeout);
            httpclient.getParams().setParameter("http.socket.timeout", (Object)timeout);
            logger.info("[" + time + "]url=====>" + url + "httpPostData" + urlvalue);
            HttpPost httppost = new HttpPost(url);
            httppost.addHeader("Authorization", "your token");
            httppost.addHeader("User-Agent", "imgfornote");
            httppost.addHeader("Content-Type", "application/json;charset=UTF-8");
            httppost.setEntity((HttpEntity)new StringEntity(urlvalue, "UTF-8"));
            HttpResponse response = httpclient.execute((HttpUriRequest)httppost);
            int code = response.getStatusLine().getStatusCode();
            if (code == 200) {
                rev = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            }
            logger.info("[" + time + "]response=====>" + rev);
            if (isPing) {
                logger.info("[isPing] end");
                return "SUCC";
            }
            return rev;
        }
        catch (ClientProtocolException e) {
            logger.error("[{}]ClientProtocolException:{}", (Object)time, (Object)e);
            return null;
        }
        catch (IOException e) {
            logger.error("[{}]IOException:{}", (Object)time, (Object)e);
            return null;
        }
        catch (Exception e) {
            logger.error("[{}]Exception:{}", (Object)time, (Object)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeGet(String url) throws Exception {
        BufferedReader in = null;
        String content = null;
        try {
            URL urlp = new URL(url);
            URI uri = new URI(urlp.getProtocol(), urlp.getHost(), urlp.getPath(), urlp.getQuery(), null);
            DefaultHttpClient client = new DefaultHttpClient();
            HttpGet request = new HttpGet();
            request.setURI(uri);
            HttpResponse response = client.execute((HttpUriRequest)request);
            in = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), "UTF-8"));
            StringBuffer sb = new StringBuffer("");
            String line = "";
            while ((line = in.readLine()) != null) {
                sb.append(line);
            }
            in.close();
            content = sb.toString();
            return content;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            return content;
        }
    }
}

