/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class HttpClientUtils {
    public static final String DEFAULT_ENCODING = "UTF-8";
    private static final int CONNECTION_TIMEOUT = 30000;
    private static final int RequestTimeout = 30000;
    private static final int SO_TIMEOUT = 30000;

    public static String post(String url, Map<String, String> params) throws IOException {
        HttpPost post = HttpClientUtils.postForm(url, params, DEFAULT_ENCODING);
        return HttpClientUtils.invoke((HttpUriRequest)post);
    }

    public static String post(String url, String encoding, Map<String, String> params) throws IOException {
        HttpPost post = HttpClientUtils.postForm(url, params, encoding);
        return HttpClientUtils.invoke((HttpUriRequest)post);
    }

    public static String get(String url) throws IOException {
        HttpGet get = new HttpGet(url);
        return HttpClientUtils.invoke((HttpUriRequest)get);
    }

    public static String postJson(String url, String jsonReq) throws IOException {
        return HttpClientUtils.postJson(url, DEFAULT_ENCODING, jsonReq);
    }

    public static String postJson(String url, String encoding, String jsonReq) throws IOException {
        return HttpClientUtils.postJson(url, encoding, jsonReq, 30000, 30000);
    }

    public static String postJson(String url, String encoding, String jsonReq, int ctimeOut, int stimeOut) throws IOException {
        HttpPost post = new HttpPost(url);
        StringEntity s = new StringEntity(jsonReq);
        s.setContentEncoding(encoding);
        s.setContentType("application/json");
        post.setEntity((HttpEntity)s);
        post.setConfig(HttpClientUtils.getRequestConfig(ctimeOut, stimeOut));
        return HttpClientUtils.invoke((HttpUriRequest)post);
    }

    public static String postXml(String url, String xmlReq) throws IOException {
        return HttpClientUtils.postXml(url, DEFAULT_ENCODING, xmlReq);
    }

    public static String postXml(String url, String encoding, String xmlReq) throws IOException {
        HttpPost post = new HttpPost(url);
        StringEntity s = new StringEntity(xmlReq);
        s.setContentEncoding(encoding);
        s.setContentType("text/xml");
        post.setEntity((HttpEntity)s);
        return HttpClientUtils.invoke((HttpUriRequest)post);
    }

    private static String invoke(HttpUriRequest httpost) throws IOException {
        CloseableHttpClient client = HttpClients.createDefault();
        CloseableHttpResponse response = client.execute(httpost);
        String body = HttpClientUtils.paseResponse((HttpResponse)response);
        client.close();
        return body;
    }

    private static String paseResponse(HttpResponse response) throws IOException {
        HttpEntity entity = response.getEntity();
        ContentType contentType = ContentType.getOrDefault((HttpEntity)entity);
        String body = EntityUtils.toString((HttpEntity)entity, (Charset)contentType.getCharset());
        if (response.getStatusLine().getStatusCode() < 400) {
            return body;
        }
        throw new IOException("\u8bf7\u6c42\u5f02\u5e38[" + response.getStatusLine().getStatusCode() + "]:" + body);
    }

    private static HttpPost postForm(String url, Map<String, String> params, String encoding) {
        HttpPost httpost = new HttpPost(url);
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        Set<String> keySet = params.keySet();
        for (String key : keySet) {
            nvps.add(new BasicNameValuePair(key, params.get(key)));
        }
        try {
            httpost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return httpost;
    }

    private static RequestConfig getRequestConfig(int connecttimeout, int socketTimeout) {
        return RequestConfig.custom().setConnectTimeout(connecttimeout).setSocketTimeout(socketTimeout).build();
    }
}

