/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.util;

import com.efuture.business.bean.RespBase;
import com.efuture.business.exception.EfutureException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import org.springframework.util.StringUtils;

public class JsonUtil {
    private static ObjectMapper JSON_MAPPER = new ObjectMapper();

    protected JsonUtil() {
    }

    public static <T> String objectToJson(T data) {
        String json = null;
        if (data != null) {
            try {
                json = JSON_MAPPER.writeValueAsString(data);
            }
            catch (Exception var3) {
                throw new EfutureException(new RespBase(-1, "objectToJson method error: " + var3));
            }
        }
        return json;
    }

    public static <T> T jsonToObject(String json, Class<T> cls) {
        Object object = null;
        if (!StringUtils.isEmpty((Object)json) && cls != null) {
            try {
                if (json.startsWith("\"{")) {
                    json = json.replace("\"{", "{").replace("}\"", "}").replace("\\\"", "\"");
                }
                object = JSON_MAPPER.readValue(json, cls);
            }
            catch (Exception var4) {
                throw new EfutureException(new RespBase(-1, "objectToJson method error: " + var4));
            }
        }
        return (T)object;
    }

    public static List<Map<String, Object>> jsonToList(String json) {
        List list = null;
        if (!StringUtils.isEmpty((Object)json)) {
            try {
                if (json.startsWith("\"[")) {
                    json = json.replace("\"[", "[").replace("]\"", "]").replace("\\\"", "\"");
                }
                list = (List)JSON_MAPPER.readValue(json, List.class);
            }
            catch (Exception var3) {
                throw new EfutureException(new RespBase(-1, "objectToJson method error: " + var3));
            }
        }
        return list;
    }

    public static Map<String, Object> jsonToMap(String json) {
        Map maps = null;
        if (!StringUtils.isEmpty((Object)json)) {
            try {
                if (json.startsWith("\"{")) {
                    json = json.replace("\"{", "{").replace("}\"", "}").replace("\\\"", "\"");
                }
                maps = (Map)JSON_MAPPER.readValue(json, Map.class);
            }
            catch (Exception var3) {
                throw new EfutureException(new RespBase(-1, "objectToJson method error: " + var3));
            }
        }
        return maps;
    }
}

