/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.util;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;

public class UUIDUtils {
    private static String hexEncode(byte[] aInput) {
        StringBuilder result = new StringBuilder();
        char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        for (int idx = 0; idx < aInput.length; ++idx) {
            byte b = aInput[idx];
            result.append(digits[(b & 0xF0) >> 4]);
            result.append(digits[b & 0xF]);
        }
        return result.toString();
    }

    private static String buildDigestUUID() throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest salt = MessageDigest.getInstance("SHA-256");
        salt.update(UUID.randomUUID().toString().getBytes("UTF-8"));
        String digest = UUIDUtils.hexEncode(salt.digest());
        return digest;
    }

    private static String buildDigestUUID2() throws NoSuchAlgorithmException {
        SecureRandom prng = SecureRandom.getInstance("SHA1PRNG");
        String randomNum = new Integer(prng.nextInt()).toString();
        MessageDigest sha = MessageDigest.getInstance("SHA-1");
        byte[] result = sha.digest(randomNum.getBytes());
        return UUIDUtils.hexEncode(result);
    }

    private static String buildUUID() {
        UUID uuid = UUID.randomUUID();
        return uuid.toString().replace("-", "");
    }

    public static String buildGuid() {
        return UUIDUtils.buildUUID();
    }

    public static String buildPuid() {
        return UUIDUtils.buildUUID();
    }

    public static String buildFlowNo(String entId, String shopCode, String terminalNo) {
        StringBuffer sb = new StringBuffer();
        sb.append(entId).append(shopCode).append(terminalNo).append(System.currentTimeMillis());
        return sb.toString();
    }

    public static void changeTest(Test1 test) {
        test.setName("mmm");
    }

    public static void changeStr(String str) {
        str = str + "000";
    }

    public static void changeStr(StringBuffer sb) {
        sb.append("333");
    }

    public static void main(String[] args) {
        String str = new String("111");
        UUIDUtils.changeStr(str);
        System.out.println(str);
        StringBuffer sb = new StringBuffer("222");
        UUIDUtils.changeStr(sb);
        System.out.println(sb.toString());
        Test1 test = new Test1();
        test.setName("spring");
        test.setSex("1");
        System.out.println(test);
        test.changeTest(test);
        System.out.println(test);
        System.out.println(test.name);
        UUIDUtils.changeTest(test);
        System.out.println(test);
        System.out.println(test.name);
        double a = 12.33;
        int b = (int)(a * 100.0);
        Integer calcResult = -1;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date saleDate = sdf.parse("2018-07-06 10:35:10");
            Date nowDate = sdf.parse(sdf.format(new Date()));
            System.out.println("1--:" + sdf.format(nowDate));
            System.out.println("2--:" + sdf.format(saleDate));
            if (saleDate.before(nowDate)) {
                System.out.println("before");
            }
            if (saleDate.after(nowDate)) {
                System.out.println("after");
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    static class Money {
        Float money;

        Money() {
        }

        public Float getMoney() {
            return this.money;
        }

        public void setMoney(Float money) {
            this.money = money;
        }
    }

    static final class Test1 {
        String name;
        String sex;

        Test1() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getSex() {
            return this.sex;
        }

        public void setSex(String sex) {
            this.sex = sex;
        }

        public void changeTest(Test1 test) {
            test.setName("ttt");
        }
    }
}

