/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.aspect;

import com.product.model.ServiceSession;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Order(value=5)
@Component
public class RemoteAspect {
    private static final Logger log = LoggerFactory.getLogger(RemoteAspect.class);

    @Pointcut(value="execution(public * com.efuture.*.service.*..*.*(..))")
    public void remote() {
    }

    @Before(value="remote()")
    public void doBefore(JoinPoint joinPoint) throws Throwable {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (null == attributes) {
            return;
        }
        HttpServletRequest request = attributes.getRequest();
        if (joinPoint.getArgs().length > 0) {
            for (Object o : joinPoint.getArgs()) {
                if (o instanceof HttpServletRequest || o instanceof HttpServletResponse || !(o instanceof ServiceSession)) continue;
                ServiceSession serviceSession = (ServiceSession)o;
                request.setAttribute("lang", (Object)serviceSession.getLocale());
            }
        }
    }
}

