/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.autoconfigure;

import com.efuture.business.autoconfigure.HazelcastProperties;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.spring.cache.HazelcastCacheManager;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.cache.interceptor.SimpleKeyGenerator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableCaching
@ConditionalOnProperty(value={"hazelcast.enabled"}, matchIfMissing=false)
@EnableConfigurationProperties(value={HazelcastProperties.class})
public class HazelcastConfiguration {
    private HazelcastInstance hazelcastInstance;
    private CacheManager cacheManager;
    @Autowired
    private HazelcastProperties hazelcastProperties;

    @PreDestroy
    public void destroy() {
        Hazelcast.shutdownAll();
    }

    @Bean
    public CacheManager cacheManager() {
        return new HazelcastCacheManager(this.hazelcastInstance());
    }

    @Bean
    KeyGenerator keyGenerator() {
        return new SimpleKeyGenerator();
    }

    /*
     * Unable to fully structure code
     */
    @Bean
    HazelcastInstance hazelcastInstance() {
        servers = this.hazelcastProperties.getServers();
        if (null != servers && 0 != servers.size()) {
            config = new ClientConfig();
            var3 = servers.iterator();
            block0: while (true) {
                if (!var3.hasNext()) {
                    this.hazelcastInstance = HazelcastClient.newHazelcastClient((ClientConfig)config);
                    return this.hazelcastInstance;
                }
                server = var3.next();
                config.getNetworkConfig().addAddress(new String[]{server});
                config.getNetworkConfig().setConnectionAttemptLimit(this.hazelcastProperties.getConnectionAttemptLimits().intValue());
                config.getNetworkConfig().setConnectionTimeout(this.hazelcastProperties.getTimeout().intValue());
                config.getNetworkConfig().setConnectionAttemptPeriod(this.hazelcastProperties.getConnectionAttemptPeriod().intValue());
                config.getNetworkConfig().setConnectionAttemptLimit(this.hazelcastProperties.getConnectionAttemptLimits().intValue());
                config.setExecutorPoolSize(this.hazelcastProperties.getPoolSize().intValue());
                config.setProperty("hazelcast.socket.keep.alive", "true");
                if (null == this.hazelcastProperties.getProperties()) continue;
                var5 = this.hazelcastProperties.getProperties().entrySet().iterator();
                while (true) {
                    if (var5.hasNext()) ** break;
                    continue block0;
                    entry = var5.next();
                    config.setProperty(entry.getKey(), entry.getValue());
                }
                break;
            }
        }
        this.hazelcastInstance = Hazelcast.newHazelcastInstance();
        return this.hazelcastInstance;
    }
}

