/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.bean;

import java.util.Locale;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.NonNull;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.LocaleResolver;

@Configuration
public class MyLocaleResolver
implements LocaleResolver {
    @Autowired
    private HttpServletRequest request;

    public Locale getLocal() {
        return this.resolveLocale(this.request);
    }

    public Locale resolveLocale(HttpServletRequest httpServletRequest) {
        String language = httpServletRequest.getParameter("lang");
        Locale locale = Locale.getDefault();
        if (!StringUtils.isEmpty((String)language)) {
            String[] s = language.split("-");
            locale = new Locale(s[0], s[1]);
        }
        return locale;
    }

    public void setLocale(@NonNull HttpServletRequest request, @Nullable HttpServletResponse httpServletResponse, @Nullable Locale locale) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
    }
}

