/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.config;

import com.efuture.business.util.HCacheMapUtil;
import com.efuture.business.util.JsonUtil;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import java.security.PrivateKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class HazelcastCache {
    private static final Logger log = LoggerFactory.getLogger(HazelcastCache.class);
    private ApplicationContext context;
    private HazelcastInstance hazelcastInstances;

    @Autowired
    public HazelcastCache(ApplicationContext context) {
        try {
            this.context = context;
            this.hazelcastInstances = (HazelcastInstance)context.getBean("hazelcastInstance");
        }
        catch (Exception e) {
            log.warn("\u4f9d\u8d56\u6ce8\u5165\u672c\u5730\u7f13\u5b58HazelcastInstance \u5931\u8d25 \u786e\u4fdd\u4f60\u662f\u5426\u5f00\u542f\u4f7f\u7528\u672c\u5730\u7f13\u5b58", (Object)e.getMessage());
        }
    }

    public <T> int set(String key, T val, long exptime) {
        String saveValue = "";
        if (!StringUtils.isEmpty(val)) {
            saveValue = JsonUtil.objectToJson(val);
        }
        return HCacheMapUtil.put(this.hazelcastInstances, "POS", key, saveValue, exptime);
    }

    public <T> int set(String key, T val) {
        String saveValue = "";
        if (!StringUtils.isEmpty(val)) {
            saveValue = JsonUtil.objectToJson(val);
        }
        return HCacheMapUtil.put(this.hazelcastInstances, "POS", key, saveValue);
    }

    public <T> T get(String key, Class<T> cls) {
        String jsonStr = HCacheMapUtil.get(this.hazelcastInstances, "POS", key, String.class);
        Object result = null;
        if (!StringUtils.isEmpty((Object)jsonStr)) {
            result = JsonUtil.jsonToObject(jsonStr, cls);
        }
        return (T)(result != null && !result.equals("null") ? result : null);
    }

    public int setStringCache(String key, String val) {
        return HCacheMapUtil.put(this.hazelcastInstances, "POS", key, val);
    }

    public String getStringCache(String key) {
        return HCacheMapUtil.get(this.hazelcastInstances, "POS", key, String.class);
    }

    public void delete(String key) {
        HCacheMapUtil.remove(this.hazelcastInstances, "POS", key);
    }

    public int deleteContains(String subKey) {
        return this.removeContains(this.hazelcastInstances, "POS", subKey);
    }

    private int removeContains(HazelcastInstance hInstance, String namespace, String cacheKey) {
        if (null != hInstance && !StringUtils.isEmpty((Object)namespace) && !StringUtils.isEmpty((Object)cacheKey)) {
            IMap cacheMap = hInstance.getMap(namespace);
            int result = 0;
            for (String key : cacheMap.keySet()) {
                if (!key.contains(cacheKey)) continue;
                cacheMap.remove((Object)key);
                ++result;
            }
            return result;
        }
        return 0;
    }

    public int set(String key, PrivateKey val, int exptime) {
        return HCacheMapUtil.put(this.hazelcastInstances, "POS", key, val, exptime);
    }

    public Object get(String key) {
        Object result = HCacheMapUtil.get(this.hazelcastInstances, "POS", key);
        return result != null && !result.equals("null") ? result : null;
    }
}

