/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.config;

import com.efuture.business.bean.MyLocaleResolver;
import com.efuture.business.util.ServletUtils;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Locale;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Component;

@Component
public class I18nUtil {
    private static final Logger log = LoggerFactory.getLogger(I18nUtil.class);
    @Value(value="${spring.messages.basename:}")
    private String basename;
    private final MyLocaleResolver resolver;
    private static MyLocaleResolver customLocaleResolver;
    private static String path;

    public I18nUtil(MyLocaleResolver resolver) {
        this.resolver = resolver;
    }

    @PostConstruct
    public void init() {
        I18nUtil.setBasename(this.basename);
        I18nUtil.setCustomLocaleResolver(this.resolver);
    }

    public static String getMessage(String code) {
        Locale locale = customLocaleResolver.getLocal();
        return I18nUtil.getMessage(code, null, code, locale);
    }

    public static String getMessage(String code, String message, Object ... args) {
        Locale locale;
        Object langObj;
        String lang;
        if (null == message) {
            message = "";
        }
        String string = lang = (langObj = ServletUtils.getRequest().getAttribute("lang")) == null ? "zh-CN" : langObj.toString();
        if (StringUtils.isBlank((String)lang)) {
            Object lang1 = ServletUtils.getRequest().getAttribute("lang");
            String string2 = lang = lang1 == null ? "zh-CN" : lang1.toString();
        }
        if (StringUtils.isEmpty((String)lang)) {
            locale = Locale.CHINA;
        } else {
            try {
                String[] split = lang.split("-");
                locale = new Locale(split[0], split[1]);
            }
            catch (Exception e) {
                locale = Locale.CHINA;
            }
        }
        return I18nUtil.getMessage(code, args, message, locale);
    }

    public static String getStationLetterMessage(String code, String lang) {
        Locale locale;
        log.info("lang==>{}", (Object)lang);
        if (StringUtils.isEmpty((String)lang)) {
            locale = Locale.CHINA;
        } else {
            try {
                String[] split = lang.split("-");
                locale = new Locale(split[0], split[1]);
            }
            catch (Exception e) {
                locale = Locale.CHINA;
            }
        }
        return I18nUtil.getMessage(code, null, code, locale);
    }

    public static String getMessage(String code, Object[] args, String defaultMessage, Locale locale) {
        String content;
        Object messageSource = null;
        if (!StringUtils.isNotBlank((String)path)) {
            return MessageFormat.format(defaultMessage, args);
        }
        messageSource = path.startsWith("file:") ? new ReloadableResourceBundleMessageSource() : new ResourceBundleMessageSource();
        messageSource.setBasenames(path.split(","));
        messageSource.setDefaultEncoding(StandardCharsets.UTF_8.toString());
        messageSource.setUseCodeAsDefaultMessage(true);
        try {
            content = messageSource.getMessage(code, args, defaultMessage, locale);
        }
        catch (Exception e) {
            content = MessageFormat.format(defaultMessage, args);
        }
        return content;
    }

    public static void setBasename(String basename) {
        path = basename;
    }

    public static void setCustomLocaleResolver(MyLocaleResolver resolver) {
        customLocaleResolver = resolver;
    }
}

