/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.config;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.exception.NacosException;
import com.efuture.business.javaPos.global.GlobalInfo;
import com.efuture.business.util.GetValueForEnv;
import java.io.ByteArrayInputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class NaCosConfig {
    private static final Logger log = LoggerFactory.getLogger(NaCosConfig.class);
    public static String[] dataId = null;
    public static String group = "DEFAULT_GROUP";
    public static String serverAddr = "https://sit-srmp.sjhgo.com";
    public static String userName = "saas";
    public static String passWord = "saas";
    public static String nameSpace = "prd-saas-omp";

    public static String getNaCosConfig(String dataId, String group, String serverAddr, String userName, String passWord, String nameSpace) {
        Properties properties = new Properties();
        String config = "";
        properties.put("serverAddr", serverAddr);
        properties.put("username", userName);
        properties.put("password", passWord);
        properties.put("namespace", nameSpace);
        try {
            ConfigService configService = NacosFactory.createConfigService((Properties)properties);
            config = configService.getConfig(dataId, group, 5000L);
            log.debug("getConfig: {}", (Object)config);
        }
        catch (NacosException e) {
            log.error(e.getMessage(), (Throwable)e);
            e.printStackTrace();
            return "";
        }
        return config;
    }

    public static Properties getNaCosConfigToProperties(String dataId, String group, String serverAddr, String userName, String passWord, String nameSpace) {
        String nacosStr = NaCosConfig.getNaCosConfig(dataId, group, serverAddr, userName, passWord, nameSpace);
        Properties properties = new Properties();
        properties.load(new ByteArrayInputStream(nacosStr.getBytes()));
        return properties;
    }

    public static Properties[] getNaCosConfigToPropertiesList(String[] dataIds, String group, String serverAddr, String userName, String passWord, String nameSpace) {
        Properties[] nacosProperties = new Properties[dataIds.length + 1];
        if (null != dataIds && dataIds.length > 0) {
            for (int i = 0; i < dataIds.length; ++i) {
                String nacosStr = NaCosConfig.getNaCosConfig(dataIds[i], group, serverAddr, userName, passWord, nameSpace);
                Properties properties = new Properties();
                properties.load(new ByteArrayInputStream(nacosStr.getBytes()));
                nacosProperties[i] = properties;
                if (!"pos-process".equals(dataIds[i])) continue;
                GlobalInfo.process = properties;
            }
        }
        return nacosProperties;
    }

    public static void setNacosConfig(Properties properties, Environment environment) {
        properties = GetValueForEnv.getEnv(properties, environment);
        dataId = properties.get("nacos.config.data-ids").toString().split(",");
        group = properties.get("nacos.config.group").toString();
        serverAddr = properties.get("nacos.config.server-addr").toString();
        userName = properties.get("nacos.config.username").toString();
        passWord = properties.get("nacos.config.password").toString();
        nameSpace = properties.get("nacos.config.namespace").toString();
    }

    public static void main(String[] args) {
        String nacosStr = NaCosConfig.getNaCosConfig("pos-process", group, serverAddr, userName, passWord, nameSpace);
        Properties properties = new Properties();
        properties.load(new ByteArrayInputStream(nacosStr.getBytes()));
        System.out.println(JSONObject.toJSONString((Object)properties));
    }
}

