/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.config;

import com.efuture.business.javaPos.global.GlobalInfo;
import com.efuture.business.util.RedisUtil;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import redis.clients.jedis.Connection;
import redis.clients.jedis.JedisPoolConfig;

@Configuration
public class RedisConfig {
    private static final Logger log = LoggerFactory.getLogger(RedisConfig.class);
    @Autowired
    private GlobalInfo globalInfo;

    @Bean
    public JedisPoolConfig jedisPoolConfig() {
        JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
        jedisPoolConfig.setMaxIdle(GlobalInfo.redismaxidle);
        jedisPoolConfig.setMaxTotal(GlobalInfo.redisMaxTotal);
        jedisPoolConfig.setMaxWaitMillis((long)GlobalInfo.redismaxWaitMillis);
        jedisPoolConfig.setMinEvictableIdleTimeMillis((long)GlobalInfo.redisminEvictableIdleTimeMillis);
        jedisPoolConfig.setNumTestsPerEvictionRun(GlobalInfo.redisnumTestsPerEvictionRun);
        jedisPoolConfig.setTimeBetweenEvictionRunsMillis((long)GlobalInfo.redistimeBetweenEvictionRunsMillis);
        jedisPoolConfig.setTestOnBorrow(GlobalInfo.redistestOnBorrow);
        jedisPoolConfig.setTestWhileIdle(GlobalInfo.testWhileIdle);
        jedisPoolConfig.setTestOnReturn(GlobalInfo.redistestOnReturn);
        return jedisPoolConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Bean
    public RedisClusterConfiguration redisClusterConfiguration() {
        if ("cluster".equals(GlobalInfo.redisMode)) {
            RedisClusterConfiguration redisClusterConfiguration = new RedisClusterConfiguration();
            String[] serverArray = GlobalInfo.redisip.split(",");
            HashSet<RedisNode> nodes = new HashSet<RedisNode>();
            for (String ipPort : serverArray) {
                String[] ipAndPort = ipPort.split(":");
                try (Connection connection = new Connection(ipAndPort[0].trim(), Integer.valueOf(ipAndPort[1]).intValue());){
                    connection.connect();
                }
                nodes.add(new RedisNode(ipAndPort[0].trim(), Integer.valueOf(ipAndPort[1]).intValue()));
                log.info("\u6dfb\u52a0\u96c6\u7fa4\u8282\u70b9ip:{},port:{}", (Object)ipAndPort[0].trim(), (Object)Integer.valueOf(ipAndPort[1]));
            }
            redisClusterConfiguration.setClusterNodes(nodes);
            redisClusterConfiguration.setMaxRedirects(GlobalInfo.maxRedirectsac);
            return redisClusterConfiguration;
        }
        return new RedisClusterConfiguration();
    }

    @Bean
    public JedisConnectionFactory JedisConnectionFactory(JedisPoolConfig jedisPoolConfig, RedisClusterConfiguration redisClusterConfiguration) {
        JedisConnectionFactory JedisConnectionFactory2 = null;
        if ("cluster".equals(GlobalInfo.redisMode)) {
            JedisConnectionFactory2 = new JedisConnectionFactory(redisClusterConfiguration, jedisPoolConfig);
            JedisConnectionFactory2.setDatabase(GlobalInfo.database < 0 ? 0 : GlobalInfo.database);
            JedisConnectionFactory2.setPassword(GlobalInfo.pwd);
            JedisConnectionFactory2.setTimeout(GlobalInfo.redispooltimeout);
        } else {
            JedisConnectionFactory2 = new JedisConnectionFactory(jedisPoolConfig);
            JedisConnectionFactory2.setPoolConfig(jedisPoolConfig);
            log.info("globalInfo.redisip: " + GlobalInfo.redisip);
            log.info("globalInfo.redisip: " + GlobalInfo.port);
            JedisConnectionFactory2.setHostName(GlobalInfo.redisip);
            JedisConnectionFactory2.setPort(GlobalInfo.port);
            JedisConnectionFactory2.setDatabase(GlobalInfo.database < 0 ? 0 : GlobalInfo.database);
            JedisConnectionFactory2.setPassword(GlobalInfo.pwd);
            JedisConnectionFactory2.setTimeout(GlobalInfo.redispooltimeout);
        }
        return JedisConnectionFactory2;
    }

    @Bean
    public RedisTemplate<String, Object> functionDomainRedisTemplate(RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate redisTemplate = new RedisTemplate();
        this.initDomainRedisTemplate((RedisTemplate<String, Object>)redisTemplate, redisConnectionFactory);
        return redisTemplate;
    }

    private void initDomainRedisTemplate(RedisTemplate<String, Object> redisTemplate, RedisConnectionFactory factory) {
        StringRedisSerializer stringSerializer = new StringRedisSerializer();
        redisTemplate.setKeySerializer((RedisSerializer)stringSerializer);
        redisTemplate.setValueSerializer((RedisSerializer)stringSerializer);
        redisTemplate.setHashKeySerializer((RedisSerializer)stringSerializer);
        redisTemplate.setHashValueSerializer((RedisSerializer)stringSerializer);
        redisTemplate.setEnableTransactionSupport(true);
        redisTemplate.setConnectionFactory(factory);
    }

    @Bean(name={"redisUtil"})
    public RedisUtil redisUtil(RedisTemplate<String, Object> redisTemplate) {
        RedisUtil redisUtil = new RedisUtil();
        redisUtil.setRedisTemplate(redisTemplate);
        return redisUtil;
    }
}

