/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.config.mss;

import com.efuture.ocp.common.cache.CacheConfig;
import com.efuture.ocp.common.cache.CacheUtils;
import com.efuture.ocp.common.cache.CacheUtilsInMemory;
import com.efuture.ocp.common.language.MessageSourceHelper;
import com.efuture.ocp.common.rest.ServiceVersion;
import com.efuture.ocp.common.rest.userinterface.CloudPortalSessionInit;
import com.efuture.ocp.common.user.UserDataRangeSrv;
import com.efuture.ocp.common.user.UserServiceCloudPortal;
import com.efuture.ocp.common.util.RestClientUtils;
import com.efuture.ocp.common.util.UniqueID;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.core.env.Environment;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;

@Configuration
@ConditionalOnProperty(name={"spring.profiles.active"}, havingValue="localmss")
public class Event_BeanConfiger {
    @Value(value="${efuture.rest.filepath:OBJ:restinfogetfromenv}")
    String config;
    @Value(value="${efuture.rest.poolSize:60}")
    int rest_poolSize;
    @Value(value="${efuture.rest.maxWait:10000}")
    int maxWait;
    @Value(value="${efuture.rest.connectTimeout:200}")
    int connectTimeout;
    @Value(value="${efuture.rest.readTimeout:20000}")
    int readTimeout;
    @Value(value="${efuture.portal.openrange:false}")
    private boolean OPENRANGE;
    @Value(value="${efuture.portal.portalkey:cloud}")
    private String PORTALKEY;
    @Value(value="${efuture.portal.rangeurl:}")
    private String RANGEURL;
    @Autowired
    public Environment env;
    @Autowired
    protected ResourceLoader resourceLoader = new DefaultResourceLoader();

    private String getValue(String prefix, String key, String defaultVal) {
        String val = this.env.getProperty(prefix.concat(key));
        if (val == null || val.isEmpty()) {
            return defaultVal;
        }
        return val;
    }

    @Bean(name={"ServiceVersion"})
    public ServiceVersion serviceVersion() {
        return new ServiceVersion("", "y", "text");
    }

    @Bean(name={"RestUtils"})
    public RestClientUtils RestUtils() {
        RestClientUtils udrs = new RestClientUtils(this.rest_poolSize, (long)this.maxWait, this.config);
        HashMap<String, Integer> clientProp = new HashMap<String, Integer>();
        clientProp.put("connectTimeout", this.connectTimeout);
        clientProp.put("readTimeout", this.readTimeout);
        udrs.setClientProperties(clientProp);
        return udrs;
    }

    @Bean(name={"CacheUtils"})
    public CacheUtils CacheUtils() {
        CacheUtilsInMemory cacheUtils = new CacheUtilsInMemory();
        return cacheUtils;
    }

    @Bean(name={"CacheInMemory"})
    public CacheUtils CacheInMemory() {
        CacheUtilsInMemory cacheUtils = new CacheUtilsInMemory();
        return cacheUtils;
    }

    @Bean(name={"UniqueIDEvent"})
    public UniqueID uniqueID() {
        UniqueID rbm = new UniqueID();
        return rbm;
    }

    @Bean(name={"messageSource"})
    public ResourceBundleMessageSource resourcebundlemessageSource() {
        ResourceBundleMessageSource rbm = new ResourceBundleMessageSource();
        rbm.setDefaultEncoding("UTF-8");
        rbm.setBasename("message");
        return rbm;
    }

    @Bean(name={"messageSourceHelperEvent"})
    public MessageSourceHelper messageSourceHelper() {
        MessageSourceHelper rbm = new MessageSourceHelper();
        rbm.setMessageSource(this.resourcebundlemessageSource());
        return rbm;
    }

    @Bean(name={"UserServerSrv_cloud"})
    public UserServiceCloudPortal UserServerSrv_cloud() {
        UserServiceCloudPortal us = new UserServiceCloudPortal();
        us.setServiceUrl(this.RANGEURL);
        return us;
    }

    @Bean(name={"initSession_cloud"})
    public CloudPortalSessionInit initSession_cloud() {
        return new CloudPortalSessionInit();
    }

    @Bean(name={"UserDataRangeSrv"})
    public UserDataRangeSrv UserDataRangeSrv() {
        UserDataRangeSrv uds = new UserDataRangeSrv();
        UserDataRangeSrv.setOpenrange((boolean)this.OPENRANGE);
        UserDataRangeSrv.setPortalkey((String)this.PORTALKEY);
        return uds;
    }

    public CacheConfig getCacheConfig() {
        String prefix = "efuture.cache.";
        CacheConfig cacheConfig = new CacheConfig();
        cacheConfig.setRedisHost(this.getValue(prefix, "redisHost", "localhost"));
        cacheConfig.setRedisPort(Integer.valueOf(this.getValue(prefix, "redisPort", "6379")).intValue());
        cacheConfig.setRedisMaxActive(Integer.valueOf(this.getValue(prefix, "redisMaxActive", "10")).intValue());
        cacheConfig.setRedisMaxIdle(Integer.valueOf(this.getValue(prefix, "redisMaxIdle", "5")).intValue());
        cacheConfig.setRedisMaxWait(Integer.valueOf(this.getValue(prefix, "redisMaxWait", "5000")).intValue());
        cacheConfig.setRedisTimeout(Integer.valueOf(this.getValue(prefix, "redisTimeout", "5000")).intValue());
        cacheConfig.setRedisTestOnBorrow("true".equalsIgnoreCase(this.getValue(prefix, "redisTestOnBorrow", "true")));
        cacheConfig.setRedisPassword("12345");
        cacheConfig.setRedisDatabase(Integer.valueOf(this.getValue(prefix, "redisDatabase", "0")).intValue());
        return cacheConfig;
    }
}

