/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.config.mss;

import com.efuture.ocp.common.util.BatchInsService;
import com.efuture.omp.event.calc.CommonCalc;
import com.efuture.omp.event.calc.EventRuleUtils;
import com.efuture.omp.event.calc.GainCouponPolicy;
import com.efuture.omp.event.calc.GainPayPolicy;
import com.efuture.omp.event.calc.GainPointPolicy;
import com.efuture.omp.event.calc.GiftPolicy;
import com.efuture.omp.event.calc.LimitCheckPolicy;
import com.efuture.omp.event.calc.LimitCheckPool;
import com.efuture.omp.event.calc.PayDiscountPolicy;
import com.efuture.omp.event.calc.PointExchangePolicy;
import com.efuture.omp.event.calc.UseCouponPolicy;
import com.efuture.omp.event.component.AccntAccessImpl;
import com.efuture.omp.event.component.CouponGainImpl;
import com.efuture.omp.event.component.CouponUseImpl;
import com.efuture.omp.event.component.EventOrderSaveImpl;
import com.efuture.omp.event.component.OrderSaveImpl;
import com.efuture.omp.event.component.PromotionImpl;
import com.efuture.omp.event.component.SaleReturnImpl;
import com.efuture.omp.event.component.ext.AccntAccessNull;
import com.efuture.omp.event.component.ext.CustAccessNull;
import com.efuture.omp.event.entity.calc.CalcConfig;
import com.efuture.omp.event.model.sync.SyncModelDataServiceImpl;
import java.util.Arrays;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@ConditionalOnProperty(name={"spring.profiles.active"}, havingValue="localmss")
public class Event_BizConfiger {
    @Autowired
    public Environment env;
    @Value(value="${efuture.main.storage:}")
    private String mainStorage;

    private String getValue(String prefix, String key, String defaultVal) {
        String val = this.env.getProperty(prefix.concat(key));
        if (val == null || val.isEmpty()) {
            return defaultVal;
        }
        return val;
    }

    @Bean(name={"CalcConfig"})
    public CalcConfig calcConfig() {
        String prefix = "efuture.ompevent.calcconfig.";
        CalcConfig calc = new CalcConfig();
        calc.setAccntService(this.getValue(prefix, "accntservice", null));
        calc.setCustService(this.getValue(prefix, "custservice", null));
        calc.setPointService(this.getValue(prefix, "pointservice", null));
        calc.setRuleFilter(Integer.parseInt(this.getValue(prefix, "rulefilter", "80")));
        calc.setRuleCached(Integer.parseInt(this.getValue(prefix, "rulecached", "0")));
        calc.setSplitCached(Integer.parseInt(this.getValue(prefix, "splitcached", "0")));
        calc.setReturnMode(Integer.parseInt(this.getValue(prefix, "returnmode", "0")));
        calc.setBindVariable(Integer.parseInt(this.getValue(prefix, "bindvariable", "1")));
        calc.setCouponAllot(Integer.parseInt(this.getValue(prefix, "couponallot", "0")));
        calc.setMatchLevel(this.getValue(prefix, "matchlevel", "CATE,GZ"));
        calc.setIscompare(Integer.parseInt(this.getValue(prefix, "iscompare", "1")));
        calc.setIsmatchscd(false);
        calc.setPaybackoricid(this.getValue(prefix, "paybackoricid", "N"));
        calc.setJfbsmode(this.getValue(prefix, "jfbsmode", null));
        calc.setIsaccount(this.getValue(prefix, "isaccount", "0"));
        calc.setConspri(this.getValue(prefix, "conspri", "50,30,30,10,5"));
        calc.setConsscopemode(this.getValue(prefix, "consScopeMode", "Y"));
        calc.setExcByLevel("true".equalsIgnoreCase(this.getValue(prefix, "excbylevel", "false")));
        calc.setOrdertoken(this.getValue(prefix, "ordertoken", ""));
        calc.setMatchDimen(Arrays.asList(this.getValue(prefix, "matchdimen", "").split(",")));
        calc.setPrecisionmode(this.getValue(prefix, "precisionmode", ""));
        calc.setDiscountmode(this.getValue(prefix, "discountmode", "Y"));
        calc.setAeongrantremove(this.getValue(prefix, "aeongrantremove", ""));
        calc.setCalcnofinduserule(this.getValue(prefix, "calcnofinduserule", "N"));
        calc.setCalczszexclude(this.getValue(prefix, "calczszexclude", "N"));
        calc.setItemflag_expetype(this.getValue(prefix, "itemflag_expetype", ""));
        calc.setItemflag_qtyrecalc(this.getValue(prefix, "itemflag_qtyrecalc", ""));
        calc.setItemflag_expptype(this.getValue(prefix, "itemflag_expptype", ""));
        calc.setJfjdmode(this.getValue(prefix, "jfjdmode", "Y"));
        calc.setCondslsort_ptype(this.getValue(prefix, "condslsort_ptype", "97171"));
        return calc;
    }

    @Bean(name={"OrderSave"})
    public OrderSaveImpl orderSave() {
        String prefix = "efuture.ompevent.ordersave.";
        OrderSaveImpl orderSave = new OrderSaveImpl();
        orderSave.setOrderService(this.getValue(prefix, "orderservice", null));
        orderSave.setSendVersion(null);
        orderSave.setStorageOperation_other(this.mainStorage);
        return orderSave;
    }

    @Bean(name={"OrderAdapt"})
    public EventOrderSaveImpl eventOrderSave(@Qualifier(value="CalcConfig") CalcConfig calc) {
        String prefix = "efuture.ompevent.ordersave.";
        EventOrderSaveImpl eventOrderSave = new EventOrderSaveImpl();
        eventOrderSave.setOrderService(this.getValue(prefix, "orderservice", null));
        eventOrderSave.setCalcConfig(calc);
        return eventOrderSave;
    }

    @Bean(name={"GainLimitPool"})
    public LimitCheckPool gainLimitCheckPool() {
        return new LimitCheckPool(1, 10000L);
    }

    @Bean(name={"DiscountLimitPool"})
    public LimitCheckPool discountLimitCheckPool() {
        return new LimitCheckPool(1, 10000L);
    }

    @Bean(name={"LimitCheckPolicy"})
    public LimitCheckPolicy limitCheckPolicy() {
        return new LimitCheckPolicy();
    }

    @Bean(name={"AccntAccessNull"})
    public AccntAccessNull accntAccessNull() {
        return new AccntAccessNull();
    }

    @Bean(name={"CustAccessNull"})
    public CustAccessNull custAccessNull() {
        return new CustAccessNull();
    }

    @Bean(name={"EventRuleUtils"})
    public EventRuleUtils eventRuleUtils(@Qualifier(value="CalcConfig") CalcConfig calc) {
        EventRuleUtils ruleUtils = new EventRuleUtils();
        ruleUtils.setCalcConfig(calc);
        ruleUtils.setStorageOperation_other(this.mainStorage);
        return ruleUtils;
    }

    @Bean(name={"efuture.omp.event.promotion"})
    public PromotionImpl promotion(@Qualifier(value="CalcConfig") CalcConfig calc) {
        PromotionImpl event = new PromotionImpl();
        event.setCalcConfig(calc);
        event.setStorageOperation_other(this.mainStorage);
        return event;
    }

    @Bean(name={"efuture.omp.event.couponuse"})
    public CouponUseImpl couponUse(@Qualifier(value="CalcConfig") CalcConfig calc) {
        CouponUseImpl event = new CouponUseImpl();
        event.setCalcConfig(calc);
        event.setStorageOperation_other(this.mainStorage);
        return event;
    }

    @Bean(name={"efuture.omp.event.coupongain"})
    public CouponGainImpl couponGain(@Qualifier(value="CalcConfig") CalcConfig calc) {
        CouponGainImpl event = new CouponGainImpl();
        event.setCalcConfig(calc);
        event.setStorageOperation_other(this.mainStorage);
        return event;
    }

    @Bean(name={"efuture.omp.event.salereturn"})
    public SaleReturnImpl saleReturn(@Qualifier(value="CalcConfig") CalcConfig calc) {
        SaleReturnImpl event = new SaleReturnImpl();
        event.setCalcConfig(calc);
        event.setStorageOperation_other(this.mainStorage);
        return event;
    }

    @Bean(name={"efuture.omp.event.accntaccess"})
    public AccntAccessImpl accntAccess(@Qualifier(value="CalcConfig") CalcConfig calc) {
        AccntAccessImpl event = new AccntAccessImpl();
        event.setBaseService(this.getValue("efuture.ompevent.accntaccess.", "service", null));
        event.setCalcConfig(calc);
        return event;
    }

    @Bean(name={"PromotionObject"})
    public CommonCalc commonCalc(@Qualifier(value="CalcConfig") CalcConfig calc) {
        CommonCalc event = new CommonCalc();
        event.setCalcConfig(calc);
        return event;
    }

    @Bean(name={"PromotionObject_gift"})
    public GiftPolicy giftPolicy() {
        return new GiftPolicy();
    }

    @Bean(name={"PromotionObject_paygain"})
    public GainPayPolicy gainPayPolicy() {
        return new GainPayPolicy();
    }

    @Bean(name={"PromotionObject_paydiscount"})
    public PayDiscountPolicy payDiscountPolicy() {
        return new PayDiscountPolicy();
    }

    @Bean(name={"PromotionObject_coupongain"})
    public GainCouponPolicy gainCouponPolicy() {
        return new GainCouponPolicy();
    }

    @Bean(name={"PromotionObject_pointgain"})
    public GainPointPolicy gainPointPolicy() {
        return new GainPointPolicy();
    }

    @Bean(name={"PromotionObject_pointgainbase"})
    public GainPointPolicy gainPointBasePolicy() {
        return new GainPointPolicy();
    }

    @Bean(name={"PromotionObject_couponuse"})
    public UseCouponPolicy useCouponPolicy() {
        return new UseCouponPolicy();
    }

    @Bean(name={"PromotionObject_pointuse"})
    public UseCouponPolicy usePointPolicy() {
        return new UseCouponPolicy();
    }

    @Bean(name={"PromotionObject_pointexch"})
    public PointExchangePolicy pointExchangePolicy() {
        return new PointExchangePolicy();
    }

    @Bean(name={"batchinsservice"})
    public BatchInsService batchInsService() {
        return new BatchInsService();
    }

    @Bean(value={"efuture.omp.model.sync"})
    public SyncModelDataServiceImpl syncModelDataService() {
        return new SyncModelDataServiceImpl();
    }
}

