/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.config.mss;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidDataSourceFactory;
import com.efuture.omd.storage.FMybatisTemplate;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

@Configuration
@ConditionalOnProperty(name={"spring.profiles.active"}, havingValue="localmss")
public class Event_DataConfiger {
    private static final Logger log = LoggerFactory.getLogger(Event_DataConfiger.class);
    @Autowired
    public Environment env;
    @Autowired
    protected ResourceLoader resourceLoader = new DefaultResourceLoader();

    private String getValue(String key, String defaultVal) {
        String val = this.env.getProperty(key);
        if (val == null || val.isEmpty()) {
            return defaultVal;
        }
        return val;
    }

    private DataSource getDs(String dbkey) {
        Properties props = new Properties();
        String prestr = "efuture.dataSource." + dbkey;
        props.put("driverClassName", this.env.getProperty(prestr + ".driverClassName"));
        props.put("url", this.env.getProperty(prestr + ".url"));
        props.put("username", this.env.getProperty(prestr + ".username"));
        props.put("password", this.env.getProperty(prestr + ".password"));
        props.put("maxActive", this.getValue(prestr + ".maxActive", "50"));
        props.put("maxWait", this.getValue(prestr + ".maxWaitMillis", "60000"));
        props.put("minIdle", this.getValue(prestr + ".minIdle", "3"));
        props.put("removeAbandoned", this.getValue(prestr + ".removeAbandoned", "true"));
        props.put("removeAbandonedTimeout", this.getValue(prestr + ".removeAbandonedTimeout", "600"));
        props.put("validationQuery", this.env.getProperty(prestr + ".validationQuery"));
        try {
            DruidDataSource datasource = (DruidDataSource)DruidDataSourceFactory.createDataSource((Properties)props);
            datasource.setDbType(this.env.getProperty(prestr + ".dbtype"));
            return datasource;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Bean(name={"transactionManagerEvent"})
    public DataSourceTransactionManager transactionManager() throws Exception {
        DataSource dataSource = this.getDs("ompevent");
        return new DataSourceTransactionManager(dataSource);
    }

    @Bean(name={"sqlSessionFactoryEvent"})
    public SqlSessionFactoryBean onSqlSessionFactoryBeanEvent() {
        SqlSessionFactoryBean service = new SqlSessionFactoryBean();
        DataSource datasource = this.getDs("ompevent");
        String dbtype = ((DruidDataSource)datasource).getDbType();
        Resource resource = this.resourceLoader.getResource("classpath:mybatis-" + dbtype + "-config.xml");
        service.setConfigLocation(resource);
        service.setDataSource(datasource);
        return service;
    }

    @Bean(name={"StorageOperationEvent"})
    public FMybatisTemplate onFMybatisTemplateEvent(@Qualifier(value="sqlSessionFactoryEvent") SqlSessionFactory sqlSessionFactory) {
        return new FMybatisTemplate(sqlSessionFactory, ExecutorType.BATCH);
    }

    @Bean(name={"GlobalStorageOperation"})
    @Qualifier(value="GlobalStorageOperation")
    public FMybatisTemplate onFMybatisTemplateGlobal(@Qualifier(value="sqlSessionFactoryEvent") SqlSessionFactory sqlSessionFactory) {
        return new FMybatisTemplate(sqlSessionFactory, ExecutorType.BATCH);
    }

    @Bean(name={"StorageOperation_task"})
    @Qualifier(value="StorageOperation_task")
    public FMybatisTemplate onFMybatisTemplateTask(@Qualifier(value="sqlSessionFactoryEvent") SqlSessionFactory sqlSessionFactory) {
        return new FMybatisTemplate(sqlSessionFactory, ExecutorType.BATCH);
    }

    @Bean(name={"transactionManagerOrder"})
    public DataSourceTransactionManager transactionManagerOrder() throws Exception {
        DataSource dataSource = this.getDs("omporder");
        return new DataSourceTransactionManager(dataSource);
    }

    @Bean(name={"sqlSessionFactoryOrder"})
    public SqlSessionFactoryBean onSqlSessionFactoryBeanOrder() {
        SqlSessionFactoryBean service = new SqlSessionFactoryBean();
        DataSource dataSource = this.getDs("omporder");
        String dbtype = ((DruidDataSource)dataSource).getDbType();
        Resource resource = this.resourceLoader.getResource("classpath:mybatis-" + dbtype + "-config.xml");
        service.setConfigLocation(resource);
        service.setDataSource(dataSource);
        return service;
    }

    @Bean(name={"StorageOperationByOrder"})
    public FMybatisTemplate onFMybatisTemplateOrder(@Qualifier(value="sqlSessionFactoryOrder") SqlSessionFactory sqlSessionFactory) {
        return new FMybatisTemplate(sqlSessionFactory, ExecutorType.BATCH);
    }
}

