/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.interceptor;

import com.alibaba.fastjson.JSON;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.RespBase;
import com.efuture.business.exception.EfutureException;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

@Component
public class EfutureExceptionHandler
implements HandlerExceptionResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(EfutureExceptionHandler.class);

    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        response.addHeader("Content-Type", "application/json;charset=UTF-8");
        StringBuffer requestURL = request.getRequestURL();
        if (request.getQueryString() != null) {
            requestURL.append("?").append(request.getQueryString());
        }
        String completeURL = requestURL.toString();
        if (!(ex instanceof EfutureException)) {
            LOGGER.error("url:{},referer:{} exception", new Object[]{completeURL, request.getHeader("referer"), ex});
        } else {
            EfutureException responseBody = (EfutureException)ex;
            if (responseBody.getRespCode() == 1004) {
                LOGGER.error("url:{},referer:{} exception: TrueMeException code:{}, msg:{}, param:{}, paramObj:{}", new Object[]{completeURL, request.getHeader("referer"), responseBody.getRespCode(), responseBody.getRestDesc(), responseBody.getParam(), responseBody.getParamObj()});
            } else {
                LOGGER.error("url:{},referer:{} exception: TrueMeException code:{}, msg:{}, param:{}, paramObj:{}", new Object[]{completeURL, request.getHeader("referer"), responseBody.getRespCode(), responseBody.getRestDesc(), responseBody.getParam(), responseBody.getParamObj(), responseBody});
            }
        }
        ResponseBody responseBody1 = (ResponseBody)((HandlerMethod)handler).getMethodAnnotation(ResponseBody.class);
        Class<?> returnType = ((HandlerMethod)handler).getMethod().getReturnType();
        if (responseBody1 != null && returnType != byte[].class) {
            RespBase<Object> modelAndView1;
            Object modelAndView = null;
            if (ex instanceof RuntimeException) {
                new RespBase(Code.HESSION_TIME_OUT);
            }
            if (ex instanceof EfutureException) {
                EfutureException e = (EfutureException)ex;
                modelAndView1 = new RespBase<Object>(e.getRespCode(), e.getRestDesc(), e.getParamObj(), "");
            } else {
                modelAndView1 = new RespBase(Code.SYSTEM_ERROR);
            }
            try {
                response.getWriter().write(JSON.toJSONString(modelAndView1));
            }
            catch (IOException var11) {
                LOGGER.error("GlobalExceptionHandler write cause IOException", (Throwable)var11);
            }
            return new ModelAndView();
        }
        ModelAndView modelAndView = new ModelAndView("error/error");
        if (ex instanceof EfutureException) {
            modelAndView.addObject("errorCode", (Object)((EfutureException)ex).getRespCode());
            modelAndView.addObject("errorMsg", (Object)((EfutureException)ex).getRestDesc());
        } else {
            modelAndView.addObject("errorMsg", (Object)ex.getMessage());
        }
        return modelAndView;
    }
}

