/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.javaPos.commonkit;

import java.io.UnsupportedEncodingException;

public class ManipulateByte {
    public static byte[] getCharBytes(char data) {
        byte[] bytes = new byte[]{(byte)data};
        return bytes;
    }

    public static byte[] getChar2Bytes(char data) {
        byte[] bytes = new byte[]{(byte)data, (byte)(data >> 8)};
        return bytes;
    }

    public static byte[] getStringBytes(String data) {
        return ManipulateByte.getStringBytes(data, 0, '\u0000');
    }

    public static byte[] getStringBytes(String data, int endIndex) {
        return ManipulateByte.getStringBytes(data, endIndex, '\u0000');
    }

    public static byte[] getStringBytes(String data, int endIndex, char fillChr) {
        return ManipulateByte.getStringBytes(data, 0, endIndex, fillChr);
    }

    public static byte[] getStringBytes(String data, int startIndex, int endIndex) {
        return ManipulateByte.getStringBytes(data, startIndex, endIndex, '\u0000');
    }

    public static byte[] getStringBytes(String encoding, String data, int startIndex, int endIndex) throws UnsupportedEncodingException {
        return ManipulateByte.getStringBytes(encoding, data, startIndex, endIndex, '\u0000');
    }

    public static byte[] getStringBytes(String data, int startIndex, int endIndex, char fillChr) {
        int i;
        if (data == null) {
            data = "";
        }
        byte[] byt = data.getBytes();
        if (endIndex <= 0) {
            return byt;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (endIndex <= startIndex) {
            return new byte[0];
        }
        int j = 0;
        if (byt.length > endIndex) {
            byte[] bytRet = new byte[endIndex - startIndex];
            for (i = startIndex; i < endIndex; ++i) {
                bytRet[j] = byt[i];
                ++j;
            }
            return bytRet;
        }
        if (byt.length < endIndex) {
            byte bytChr = ManipulateByte.getCharBytes(fillChr)[0];
            byte[] bytRet = new byte[endIndex - startIndex];
            while (i < endIndex) {
                bytRet[j] = i < byt.length ? byt[i] : bytChr;
                ++j;
                ++i;
            }
            return bytRet;
        }
        return byt;
    }

    public static byte[] getStringBytes(String encoding, String data, int startIndex, int endIndex, char fillChr) throws UnsupportedEncodingException {
        int i;
        if (data == null) {
            data = "";
        }
        byte[] byt = data.getBytes(encoding);
        if (endIndex <= 0) {
            return byt;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (endIndex <= startIndex) {
            return new byte[0];
        }
        int j = 0;
        if (byt.length >= endIndex) {
            byte[] bytRet = new byte[endIndex - startIndex];
            for (i = startIndex; i < endIndex; ++i) {
                bytRet[j] = byt[i];
                ++j;
            }
            return bytRet;
        }
        if (byt.length < endIndex) {
            byte bytChr = ManipulateByte.getCharBytes(fillChr)[0];
            byte[] bytRet = new byte[endIndex - startIndex];
            while (i < endIndex) {
                bytRet[j] = i < byt.length ? byt[i] : bytChr;
                ++j;
                ++i;
            }
            return bytRet;
        }
        return byt;
    }

    public static byte[] getShortBytes(short data) {
        byte[] bytes = new byte[]{(byte)(data & 0xFF), (byte)((data & 0xFF00) >> 8)};
        return bytes;
    }

    public static byte[] getIntBytes(int data) {
        byte[] bytes = new byte[]{(byte)(data & 0xFF), (byte)((data & 0xFF00) >> 8), (byte)((data & 0xFF0000) >> 16), (byte)((data & 0xFF000000) >> 24)};
        return bytes;
    }

    public static byte[] getFloatBytes(float data) {
        int intBits = Float.floatToIntBits(data);
        return ManipulateByte.getIntBytes(intBits);
    }

    public static byte[] getLong4Bytes(long data) {
        byte[] bytes = new byte[]{(byte)(data & 0xFFL), (byte)((data & 0xFF00L) >> 8), (byte)((data & 0xFF0000L) >> 16), (byte)((data & 0xFFFFFFFFFF000000L) >> 24)};
        return bytes;
    }

    public static byte[] getLong8Bytes(long data) {
        byte[] bytes = new byte[]{(byte)(data & 0xFFL), (byte)(data >> 8 & 0xFFL), (byte)(data >> 16 & 0xFFL), (byte)(data >> 24 & 0xFFL), (byte)(data >> 32 & 0xFFL), (byte)(data >> 40 & 0xFFL), (byte)(data >> 48 & 0xFFL), (byte)(data >> 56 & 0xFFL)};
        return bytes;
    }

    public static byte[] getDoubleBytes(double data) {
        long intBits = Double.doubleToLongBits(data);
        return ManipulateByte.getLong8Bytes(intBits);
    }

    public static short getShort(byte[] bytes) {
        return (short)(0xFF & bytes[0] | 0xFF00 & bytes[1] << 8);
    }

    public static int getInt(byte[] bytes) {
        return 0xFF & bytes[0] | 0xFF00 & bytes[1] << 8 | 0xFF0000 & bytes[2] << 16 | 0xFF000000 & bytes[3] << 24;
    }

    public static long getLong4(byte[] bytes) {
        return 0xFF & bytes[0] | 0xFF00 & bytes[1] << 8 | 0xFF0000 & bytes[2] << 16 | 0xFF000000 & bytes[3] << 24;
    }

    public static long getLong8(byte[] bytes) {
        return 0xFFL & (long)bytes[0] | 0xFF00L & (long)bytes[1] << 8 | 0xFF0000L & (long)bytes[2] << 16 | 0xFF000000L & (long)bytes[3] << 24 | 0xFF00000000L & (long)bytes[4] << 32 | 0xFF0000000000L & (long)bytes[5] << 40 | 0xFF000000000000L & (long)bytes[6] << 48 | 0xFF00000000000000L & (long)bytes[7] << 56;
    }

    public static double getDouble(byte[] bytes) {
        long l = ManipulateByte.getLong8(bytes);
        return Double.longBitsToDouble(l);
    }

    public static float getFloat(byte[] bytes) {
        return Float.intBitsToFloat(ManipulateByte.getInt(bytes));
    }

    public static char getChar(byte[] bytes) {
        return (char)(0xFF & bytes[0]);
    }

    public static char getChar2(byte[] bytes) {
        return (char)(0xFF & bytes[0] | 0xFF00 & bytes[1] << 8);
    }

    public static String getString(byte[] byt) {
        try {
            return ManipulateByte.getString(byt, "GBK");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }

    public static String getString(byte[] byt, String charsetName) {
        try {
            return ManipulateByte.getString(byt, charsetName, '\u0000', ' ');
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }

    public static String getString(byte[] byt, String charsetName, char replaceChr, char replaceNewChr) {
        try {
            return new String(byt, charsetName).replace(replaceChr, replaceNewChr);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }
}

