/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.javaPos.commonkit;

import com.efuture.business.javaPos.commonkit.Convert;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;

public class ManipulatePrecision {
    private static final int DEF_DIV_SCALE = 10;
    public static String[][] registerFunction = new String[][]{{"1", "\u91d1\u5361\u5de5\u7a0b"}, {"2", "\u53cc\u5c4f\u5e7f\u544a"}, {"4", ""}, {"8", ""}, {"16", ""}};
    public static final int REGBANK = 1;
    public static final int REGMOVIE = 2;
    public static final int REGFUNC1 = 4;
    public static final int REGFUNC2 = 8;
    public static final int REGFUNC3 = 16;
    static final String gs_key_para = "Bvp01CeFM234H5ljZhiG6rstDu789abnxIfPgQcEdOqyTwNJmWXUYKLkozARSV";

    public static double add(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.add(b2).doubleValue();
    }

    public static double sub(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.subtract(b2).doubleValue();
    }

    public static int doubleToInt(double dou1, double dou2) {
        BigDecimal big1 = new BigDecimal(dou1).setScale(2, 4);
        BigDecimal big2 = new BigDecimal(dou2);
        return big1.multiply(big2).intValue();
    }

    public static double mul(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.multiply(b2).doubleValue();
    }

    public static double div(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.divide(b2, 10, 4).doubleValue();
    }

    public static double mul(double v1, double v2, int scale) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.multiply(b2).setScale(scale, 4).doubleValue();
    }

    public static double mod(double v1, double v2) {
        if (v2 == 0.0) {
            return v1;
        }
        double a = ManipulatePrecision.div(v1, v2);
        int b = (int)a;
        double c = ManipulatePrecision.mul(b, v2);
        return ManipulatePrecision.sub(Math.abs(v1), Math.abs(c));
    }

    public static int doubleCompare(double f1, double f2, int dec) {
        float f = 1.0f;
        for (int i = 0; i <= dec; ++i) {
            f = (float)((double)f / 10.0);
        }
        if (Math.abs((f1 = ManipulatePrecision.doubleConvert(f1, dec, 1)) - (f2 = ManipulatePrecision.doubleConvert(f2, dec, 1))) <= (double)f) {
            return 0;
        }
        if (f1 > f2) {
            return 1;
        }
        return -1;
    }

    public static int stringCompare(String s1, String s2, int dec) {
        float f = 1.0f;
        for (int i = 0; i <= dec; ++i) {
            f = (float)((double)f / 10.0);
        }
        double f1 = Convert.toDouble(s1);
        double f2 = Convert.toDouble(s2);
        if (Math.abs((f1 = ManipulatePrecision.doubleConvert(f1, dec, 1)) - (f2 = ManipulatePrecision.doubleConvert(f2, dec, 1))) <= (double)f) {
            return 0;
        }
        if (f1 > f2) {
            return 1;
        }
        return -1;
    }

    public static int getDoubleSign(double f) {
        return ManipulatePrecision.doubleCompare(f, 0.0, 2) >= 0 ? 1 : -1;
    }

    public static int getDoubleScale(double f) {
        int i = 0;
        double d;
        while ((d = f * Math.pow(10.0, i)) != (double)((long)d)) {
            ++i;
        }
        return i;
    }

    public static String doubleToString(double value) {
        return ManipulatePrecision.doubleToString(value, 2, 1, false, 0);
    }

    public static String doubleToString(double value, int dec, int flag) {
        return ManipulatePrecision.doubleToString(value, dec, flag, false, 0);
    }

    public static String doubleToString(double value, int dec, int flag, boolean subdec) {
        return ManipulatePrecision.doubleToString(value, dec, flag, subdec, 0);
    }

    public static String getXMLItem(String input, String point) {
        int len = point.length();
        int start = input.indexOf("<" + point + ">");
        int end = input.indexOf("</" + point + ">");
        if (start >= 0 && end >= 0) {
            return input.substring(start + len + 2, end);
        }
        return null;
    }

    public static String doubleToString(double value, int dec, int flag, boolean subdec, int rightwidth) {
        StringBuffer sb = new StringBuffer("0");
        if (dec > 0) {
            sb.append(".");
        }
        for (int i = 0; i < dec; ++i) {
            sb.append("0");
        }
        DecimalFormat df = new DecimalFormat(sb.toString());
        String s = df.format(ManipulatePrecision.doubleConvert(value, dec, flag));
        if (subdec) {
            while (s.charAt(s.length() - 1) == '0' || s.charAt(s.length() - 1) == '.') {
                if (s.charAt(s.length() - 1) == '.') {
                    s = s.substring(0, s.length() - 1);
                    break;
                }
                s = s.substring(0, s.length() - 1);
            }
        }
        if (rightwidth > 0) {
            s = Convert.increaseCharForward(s, rightwidth);
        }
        return s;
    }

    public static int integerDiv(double f1, double f2) {
        int num;
        double fz = Math.abs(f1);
        double fm = Math.abs(f2);
        if (fm == 0.0) {
            fm = 1.0;
        }
        if (ManipulatePrecision.doubleCompare(fm * (double)(num = (int)ManipulatePrecision.doubleConvert(fz / fm)), fz, 2) > 0) {
            --num;
        }
        if (num < 0) {
            num = 0;
        }
        return num;
    }

    public static double doubleConvert(double f) {
        return ManipulatePrecision.doubleConvert(f, 2, 1);
    }

    public static double doubleConvert(double f, int dec, int flag, boolean r) {
        return ManipulatePrecision.doubleConvert(f, dec, flag, r, 0.0);
    }

    public static double doubleConvert(double f, int dec, int flag, boolean r, double pre) {
        try {
            if (flag == 1) {
                double d = f;
                if (!r) {
                    d = ManipulatePrecision.doubleConvert(d, dec + 2, 1, true);
                }
                d = ManipulatePrecision.mul(d, Math.pow(10.0, dec));
                return (double)Math.round(d) / Math.pow(10.0, dec);
            }
            if (flag == 0) {
                double d = Math.abs(f);
                if (!r) {
                    d = ManipulatePrecision.doubleConvert(d, dec + 2, 1, true);
                }
                d = ManipulatePrecision.mul(d, Math.pow(10.0, dec));
                return Math.floor(d) / (Math.pow(10.0, dec) * (double)(f < 0.0 ? -1 : 1));
            }
            if (flag == 2) {
                double num;
                double d = f;
                if (!r) {
                    d = ManipulatePrecision.doubleConvert(d, dec + 2, 1, true);
                }
                if ((num = (double)Math.round(d = ManipulatePrecision.mul(d, Math.pow(10.0, dec)))) > d) {
                    return (double)Math.round(ManipulatePrecision.mul(d, 10.0)) / Math.pow(10.0, dec + 1);
                }
                return (double)Math.round(d) / Math.pow(10.0, dec);
            }
            if (flag == 3) {
                double num;
                double d = f;
                if (!r) {
                    d = ManipulatePrecision.doubleConvert(d, dec + 2, 1, true);
                }
                if ((num = (double)Math.round(d = ManipulatePrecision.mul(d, Math.pow(10.0, dec)))) < d) {
                    return (double)Math.round(ManipulatePrecision.mul(d, 10.0)) / Math.pow(10.0, dec + 1);
                }
                return (double)Math.round(d) / Math.pow(10.0, dec);
            }
            if (flag == 4) {
                double d = f;
                if (!r) {
                    d = ManipulatePrecision.doubleConvert(d, dec + 2, 1, true);
                }
                return pre * (double)((int)ManipulatePrecision.div(d, pre));
            }
            if (flag == 5) {
                double d = f;
                if (!r) {
                    d = ManipulatePrecision.doubleConvert(d, dec + 2, 1, true);
                }
                int i = (int)ManipulatePrecision.div(d, pre);
                double v1 = ManipulatePrecision.mod(d, pre);
                if (ManipulatePrecision.doubleCompare(v1, 0.0, 2) > 0) {
                    ++i;
                }
                return (double)i * pre;
            }
            return f;
        }
        catch (Exception ex) {
            return 0.0;
        }
    }

    public static double roundDecimal(double number) {
        BigDecimal bd = BigDecimal.valueOf(number);
        String numberStr = String.format("%.2f", number);
        int lastDigit = numberStr.charAt(numberStr.length() - 1) - 48;
        if (lastDigit >= 0 && lastDigit <= 2) {
            BigDecimal truncated = bd.setScale(1, RoundingMode.DOWN);
            number = truncated.doubleValue();
        } else if (lastDigit >= 3 && lastDigit <= 7) {
            BigDecimal truncated = bd.setScale(1, RoundingMode.DOWN).add(BigDecimal.valueOf(0.05));
            number = truncated.doubleValue();
        } else {
            BigDecimal truncated = bd.setScale(1, RoundingMode.UP);
            number = truncated.doubleValue();
        }
        return number;
    }

    public static double doubleConvert(double f, int dec, int flag) {
        return ManipulatePrecision.doubleConvert(f, dec, flag, false);
    }

    public static boolean checkRegisterFunction(String regcode, int func) {
        if (regcode == null || regcode.length() < 29) {
            return false;
        }
        int seqno = Convert.toInt(ManipulatePrecision.getRegisterCodeSeqno(regcode).substring(0, 2));
        if (seqno < 32) {
            return true;
        }
        seqno &= 0xFFFFFFDF;
        return (seqno &= func) > 0;
    }

    public static String getRegisterCode(String cust, String mkt, String seq, String keys) {
        StringBuffer reg = new StringBuffer();
        long Num1 = 0L;
        long Num2 = 0L;
        long Num3 = 0L;
        long Num4 = 0L;
        Object key = keys.length() < 4 ? "0000".substring(0, 4 - keys.length()) + keys : keys.substring(0, 4);
        key = ((String)key).toUpperCase();
        int keysum = ((String)key).charAt(0) + ((String)key).charAt(1) + ((String)key).charAt(2) + ((String)key).charAt(3);
        Object strseq = seq.length() < 5 ? "00000".substring(0, 5 - seq.length()) + seq : seq.substring(0, 5);
        strseq = ((String)strseq).toUpperCase();
        String user = cust + mkt + (String)strseq;
        int len = user.length();
        int keylen = ((String)key).length();
        if (len > 0) {
            int i;
            int j = 1;
            for (i = 1; i <= len; ++i) {
                int k;
                if (keylen <= 0) {
                    k = 0;
                } else {
                    k = ((String)key).charAt(j - 1) * keysum;
                    if (++j > keylen) {
                        j = 1;
                    }
                }
                Num1 = (Num1 + (long)(user.charAt(i - 1) * i * i * (i * user.charAt(i - 1) + 1)) + (long)(k * keylen * j)) % 100000L;
                Num2 = (Num2 * (long)i + (long)(user.charAt(i - 1) * i) + (long)(k * keylen * j)) % 100000L;
                Num3 = (Num2 + Num1 + (long)(user.charAt(i - 1) * i + 1) + (long)(k * keylen * j)) % 100000L;
                Num4 = (Num3 + Num2 + Num1 + (long)(user.charAt(i - 1) * i) + (long)(k * keylen * j)) % 100000L;
            }
            char[] sn = new char[20];
            for (i = 0; i < 5; ++i) {
                sn[i] = (char)((Num1 + 31L + (long)(i * i * i) + (long)len) % 128L);
            }
            for (i = 5; i < 10; ++i) {
                sn[i] = (char)((Num2 + 31L + (long)(i * i * i) + (long)len) % 128L);
            }
            for (i = 10; i < 15; ++i) {
                sn[i] = (char)((Num3 + 31L + (long)(i * i * i) + (long)len) % 128L);
            }
            for (i = 15; i < 20; ++i) {
                sn[i] = (char)((Num4 + 31L + (long)(i * i * i) + (long)len) % 128L);
            }
            for (i = 0; i < 20; ++i) {
                while (!(sn[i] >= '0' && sn[i] <= '9' || sn[i] >= 'A' && sn[i] <= 'Z')) {
                    sn[i] = (char)((sn[i] + 31 + 7 * i) % 128);
                }
            }
            reg = reg.append(sn);
            reg = reg.insert(5, "-");
            reg = reg.insert(11, "-");
            reg = reg.insert(17, "-");
            reg.setCharAt(2, ((String)key).charAt(0));
            reg.setCharAt(8, ((String)key).charAt(1));
            reg.setCharAt(14, ((String)key).charAt(2));
            reg.setCharAt(20, ((String)key).charAt(3));
            reg.append("-" + (String)strseq);
        }
        return reg.toString();
    }

    public static String getRegisterCodeKey(String regcode) {
        char[] key = new char[4];
        if (regcode == null || regcode.length() < 29) {
            return "";
        }
        key[0] = regcode.charAt(2);
        key[1] = regcode.charAt(8);
        key[2] = regcode.charAt(14);
        key[3] = regcode.charAt(20);
        return String.valueOf(key);
    }

    public static String getRegisterCodeSeqno(String regcode) {
        if (regcode == null || regcode.length() < 29) {
            return "";
        }
        return regcode.substring(24, 29);
    }

    public static String EncodeString(String strCode, String strKey) {
        int i;
        StringBuffer strEncode = null;
        StringBuffer strTemp = null;
        if (strCode == null) {
            return null;
        }
        strEncode = new StringBuffer();
        strTemp = new StringBuffer();
        int j = 0;
        for (i = 0; i < strCode.length(); ++i) {
            j += (i + 1) * strCode.charAt(i);
        }
        String codeKey = ManipulatePrecision.getRegisterCode(strCode, String.valueOf(j), "99999", strKey).substring(0, 23).replaceAll("-", "");
        strTemp.append(strCode);
        i = 0;
        j = 0;
        while (j < 20 && j < strCode.length()) {
            strTemp.insert(i, codeKey.charAt(j));
            ++j;
            i += 2;
        }
        strCode = strTemp.toString();
        j = 1;
        int keylen = strKey.length();
        strEncode.delete(0, strEncode.length());
        strTemp.delete(0, strTemp.length());
        for (i = 0; i < strCode.length(); ++i) {
            int key;
            char k;
            if (keylen <= 0) {
                k = '\u0000';
            } else {
                k = strKey.charAt(j - 1);
                if (++j > keylen) {
                    j = 1;
                }
            }
            char c = strCode.charAt(i);
            if (c < '\u0100') {
                int pre = i % 2 == 0 ? c % 16 : c / 16;
                if (pre == 0) {
                    pre = 1;
                    strTemp.append('1');
                } else {
                    strTemp.append(Integer.toString(c, 16).charAt((i + 1) % 2));
                }
                key = pre * c + (k + keylen * j) % 4;
                strTemp.append(gs_key_para.charAt(key / 62));
                strTemp.append(gs_key_para.charAt(key % 62));
                continue;
            }
            strTemp.append('G');
            key = (c + (k + keylen * j) % 256) / 256;
            strTemp.append(gs_key_para.charAt(key / 62));
            strTemp.append(gs_key_para.charAt(key % 62));
            key = (c + (k + keylen * j) % 256) % 256;
            strTemp.append(gs_key_para.charAt(key / 62));
            strTemp.append(gs_key_para.charAt(key % 62));
        }
        for (i = 0; i < strTemp.length(); ++i) {
            if ((i + 1) % 2 != 0) continue;
            strEncode.append(strTemp.charAt(i));
        }
        for (i = 0; i < strTemp.length(); ++i) {
            if ((i + 1) % 2 == 0) continue;
            strEncode.append(strTemp.charAt(i));
        }
        return strEncode.toString();
    }

    public static String DecodeString(String strCode, String strKey) {
        int i;
        if (strCode == null) {
            return null;
        }
        int j = 1;
        int keylen = strKey.length();
        StringBuffer strDecode = new StringBuffer();
        StringBuffer strTemp = new StringBuffer();
        for (i = 0; i < strCode.length() / 2; ++i) {
            strTemp.append(strCode.charAt(strCode.length() / 2 + i));
            strTemp.append(strCode.charAt(i));
        }
        if (strTemp.length() < strCode.length()) {
            strTemp.append(strCode.charAt(strCode.length() / 2 + i));
        }
        for (i = 0; i < strTemp.length(); i += 3) {
            int n;
            int key;
            char k;
            if (keylen <= 0) {
                k = '\u0000';
            } else {
                k = strKey.charAt(j - 1);
                if (++j > keylen) {
                    j = 1;
                }
            }
            char c = strTemp.substring(i, i + 1).toUpperCase().charAt(0);
            if (c >= '0' && c <= 'F') {
                int pre = Integer.parseInt(String.valueOf(c), 16);
                key = 0;
                if (i + 1 >= strTemp.length()) {
                    return strDecode.toString();
                }
                c = strTemp.substring(i + 1, i + 2).charAt(0);
                for (n = 0; n < 62; ++n) {
                    if (gs_key_para.charAt(n) != c) continue;
                    key += n * 62;
                    break;
                }
                if (i + 2 >= strTemp.length()) {
                    return strDecode.toString();
                }
                c = strTemp.substring(i + 2, i + 3).charAt(0);
                for (n = 0; n < 62; ++n) {
                    if (gs_key_para.charAt(n) != c) continue;
                    key += n;
                    break;
                }
                if (pre <= 0) {
                    return strDecode.toString();
                }
                c = (char)((key - (k + keylen * j) % 4) / pre);
                strDecode.append(c);
                continue;
            }
            key = 0;
            if (i + 1 >= strTemp.length()) {
                return strDecode.toString();
            }
            c = strTemp.substring(i + 1, i + 2).charAt(0);
            for (n = 0; n < 62; ++n) {
                if (gs_key_para.charAt(n) != c) continue;
                key += n * 62;
                break;
            }
            if (i + 2 >= strTemp.length()) {
                return strDecode.toString();
            }
            c = strTemp.substring(i + 2, i + 3).charAt(0);
            for (n = 0; n < 62; ++n) {
                if (gs_key_para.charAt(n) != c) continue;
                key += n;
                break;
            }
            key *= 256;
            if (i + 3 >= strTemp.length()) {
                return strDecode.toString();
            }
            c = strTemp.substring(i + 3, i + 4).charAt(0);
            for (n = 0; n < 62; ++n) {
                if (gs_key_para.charAt(n) != c) continue;
                key += n * 62;
                break;
            }
            if (i + 4 >= strTemp.length()) {
                return strDecode.toString();
            }
            c = strTemp.substring(i + 4, i + 5).charAt(0);
            for (n = 0; n < 62; ++n) {
                if (gs_key_para.charAt(n) != c) continue;
                key += n;
                break;
            }
            i += 2;
            c = (char)(key - (k + keylen * j) % 256);
            strDecode.append(c);
        }
        i = strDecode.length() / 2;
        for (j = 0; j < 20 && j < i; ++j) {
            strDecode.deleteCharAt(j);
        }
        return strDecode.toString();
    }

    public static String getEncrypt(String s1) {
        int len = s1.length();
        int k = 0;
        boolean signal = false;
        byte[] s2 = new byte[s1.length()];
        Object passwd = "";
        if (s1 == null || "".equals(s1)) {
            return "";
        }
        for (int i = 0; i < len; ++i) {
            k = 255 - s1.charAt(i);
            for (int j = 0; j < len - i; ++j) {
                k = 2 * k % 256 + k / 128;
            }
            passwd = (String)passwd + "," + k;
            s2[i] = (byte)k;
            if (signal) {
                signal = false;
                continue;
            }
            if (k <= 127) continue;
            signal = true;
        }
        try {
            passwd = ((String)passwd).substring(1);
            return passwd;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getFloatConverChinese(double value) {
        String strnum = ManipulatePrecision.doubleToString(value);
        String strCheck = null;
        String strFen = null;
        String strDW = null;
        String strNum = null;
        Object strBig = null;
        Object strNow = null;
        String strBear = "";
        if (strnum == null || "".equals(strnum.trim()) || value == 0.0) {
            return "\u96f6\u5143\u6574";
        }
        double d = 0.0;
        try {
            d = Double.parseDouble(strnum);
        }
        catch (Exception ex) {
            return "\u6570\u636e" + value + "\u975e\u6cd5\uff01";
        }
        strCheck = value + ".";
        int dot = strCheck.indexOf(".");
        if (dot > 12) {
            return "\u6570\u636e" + value + "\u8fc7\u5927\uff0c\u65e0\u6cd5\u5904\u7406\uff01";
        }
        try {
            int i = 0;
            strBig = "";
            strDW = "";
            strNum = "";
            long intFen = (long)ManipulatePrecision.mul(d, 100.0);
            if (strnum.charAt(0) == '-') {
                strBear = "\u8d1f";
                strFen = String.valueOf(intFen).substring(1);
            } else {
                strFen = String.valueOf(intFen);
            }
            for (int lenIntFen = strFen.length(); lenIntFen != 0; --lenIntFen) {
                switch (++i) {
                    case 1: {
                        strDW = "\u5206";
                        break;
                    }
                    case 2: {
                        strDW = "\u89d2";
                        break;
                    }
                    case 3: {
                        strDW = "\u5143";
                        break;
                    }
                    case 4: {
                        strDW = "\u62fe";
                        break;
                    }
                    case 5: {
                        strDW = "\u4f70";
                        break;
                    }
                    case 6: {
                        strDW = "\u4edf";
                        break;
                    }
                    case 7: {
                        strDW = "\u4e07";
                        break;
                    }
                    case 8: {
                        strDW = "\u62fe";
                        break;
                    }
                    case 9: {
                        strDW = "\u4f70";
                        break;
                    }
                    case 10: {
                        strDW = "\u4edf";
                        break;
                    }
                    case 11: {
                        strDW = "\u4ebf";
                        break;
                    }
                    case 12: {
                        strDW = "\u62fe";
                        break;
                    }
                    case 13: {
                        strDW = "\u4f70";
                        break;
                    }
                    case 14: {
                        strDW = "\u4edf";
                    }
                }
                switch (strFen.charAt(lenIntFen - 1)) {
                    case '1': {
                        strNum = "\u58f9";
                        break;
                    }
                    case '2': {
                        strNum = "\u8d30";
                        break;
                    }
                    case '3': {
                        strNum = "\u53c1";
                        break;
                    }
                    case '4': {
                        strNum = "\u8086";
                        break;
                    }
                    case '5': {
                        strNum = "\u4f0d";
                        break;
                    }
                    case '6': {
                        strNum = "\u9646";
                        break;
                    }
                    case '7': {
                        strNum = "\u67d2";
                        break;
                    }
                    case '8': {
                        strNum = "\u634c";
                        break;
                    }
                    case '9': {
                        strNum = "\u7396";
                        break;
                    }
                    case '0': {
                        strNum = "\u96f6";
                    }
                }
                strNow = strBig;
                if (i == 1 && strFen.charAt(lenIntFen - 1) == '0') {
                    strBig = "\u6574";
                } else if (i == 2 && strFen.charAt(lenIntFen - 1) == '0') {
                    if (!"\u6574".equals(strBig)) {
                        strBig = "\u96f6" + (String)strBig;
                    }
                } else if (i == 3 && strFen.charAt(lenIntFen - 1) == '0') {
                    strBig = "\u5143" + (String)strBig;
                } else if (i < 7 && i > 3 && strFen.charAt(lenIntFen - 1) == '0' && ((String)strNow).charAt(0) != '\u96f6' && ((String)strNow).charAt(0) != '\u5143') {
                    strBig = "\u96f6" + (String)strBig;
                } else if (!(i < 7 && i > 3 && strFen.charAt(lenIntFen - 1) == '0' && ((String)strNow).charAt(0) == '\u96f6' || i < 7 && i > 3 && strFen.charAt(lenIntFen - 1) == '0' && ((String)strNow).charAt(0) == '\u5143')) {
                    if (i == 7 && strFen.charAt(lenIntFen - 1) == '0') {
                        strBig = "\u4e07" + (String)strBig;
                    } else if (i < 11 && i > 7 && strFen.charAt(lenIntFen - 1) == '0' && ((String)strNow).charAt(0) != '\u96f6' && ((String)strNow).charAt(0) != '\u4e07') {
                        strBig = "\u96f6" + (String)strBig;
                    } else if (!(i < 11 && i > 7 && strFen.charAt(lenIntFen - 1) == '0' && ((String)strNow).charAt(0) == '\u4e07' || i < 11 && i > 7 && strFen.charAt(lenIntFen - 1) == '0' && ((String)strNow).charAt(0) == '\u96f6')) {
                        if (i < 11 && i > 8 && strFen.charAt(lenIntFen - 1) == '0' && ((String)strNow).charAt(0) == '\u4e07' && ((String)strNow).charAt(2) == '\u4edf') {
                            strBig = strNum + strDW + "\u4e07\u96f6" + ((String)strBig).substring(1, ((String)strBig).length());
                        } else if (i == 11) {
                            strBig = strFen.charAt(lenIntFen - 1) == '0' && ((String)strNow).charAt(0) == '\u4e07' && ((String)strNow).charAt(2) == '\u4edf' ? "\u4ebf\u96f6" + ((String)strBig).substring(1, ((String)strBig).length()) : (strFen.charAt(lenIntFen - 1) == '0' && ((String)strNow).charAt(0) == '\u4e07' && ((String)strNow).charAt(2) != '\u4edf' ? "\u4ebf" + ((String)strBig).substring(1, ((String)strBig).length()) : (((String)strNow).charAt(0) == '\u4e07' && ((String)strNow).charAt(2) == '\u4edf' ? strNum + strDW + "\u96f6" + ((String)strBig).substring(1, ((String)strBig).length()) : (((String)strNow).charAt(0) == '\u4e07' && ((String)strNow).charAt(2) != '\u4edf' ? strNum + strDW + ((String)strBig).substring(1, ((String)strBig).length()) : strNum + strDW + (String)strBig)));
                        } else if (i < 15 && i > 11 && strFen.charAt(lenIntFen - 1) == '0' && ((String)strNow).charAt(0) != '\u96f6' && ((String)strNow).charAt(0) != '\u4ebf') {
                            strBig = "\u96f6" + (String)strBig;
                        } else if (!(i < 15 && i > 11 && strFen.charAt(lenIntFen - 1) == '0' && ((String)strNow).charAt(0) == '\u4ebf' || i < 15 && i > 11 && strFen.charAt(lenIntFen - 1) == '0' && ((String)strNow).charAt(0) == '\u96f6')) {
                            strBig = i < 15 && i > 11 && strFen.charAt(lenIntFen - 1) != '0' && ((String)strNow).charAt(0) == '\u96f6' && ((String)strNow).charAt(1) == '\u4ebf' && ((String)strNow).charAt(3) != '\u4edf' ? strNum + strDW + ((String)strBig).substring(1, ((String)strBig).length()) : (i < 15 && i > 11 && strFen.charAt(lenIntFen - 1) != '0' && ((String)strNow).charAt(0) == '\u96f6' && ((String)strNow).charAt(1) == '\u4ebf' && ((String)strNow).charAt(3) == '\u4edf' ? strNum + strDW + "\u4ebf\u96f6" + ((String)strBig).substring(2, ((String)strBig).length()) : strNum + strDW + (String)strBig);
                        }
                    }
                }
                strFen = strFen.substring(0, lenIntFen - 1);
            }
            if ("\u8d1f".equals(strBear)) {
                strBig = strBear + (String)strBig;
            }
            return strBig;
        }
        catch (Exception exx) {
            exx.printStackTrace();
            return "";
        }
    }

    public static String getRandom() {
        String crcstr = String.valueOf(Math.round(Math.random() * 1000.0));
        if (crcstr.length() > 3) {
            return crcstr.substring(0, 3);
        }
        return Convert.increaseCharForward(crcstr, '0', 3);
    }

    public static String getFilterNumberNoStr(String str) {
        Object str1 = "";
        for (int i = 0; i < str.length(); ++i) {
            if (!ManipulatePrecision.isNumber(String.valueOf(str.charAt(i)))) continue;
            str1 = (String)str1 + str.charAt(i);
        }
        return str1;
    }

    public static boolean isNumber(String str) {
        try {
            return str.matches("^(-?\\d+)(\\d+)?$");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean isDoubleOrNumber(String str) {
        try {
            return str.matches("^(-?\\d+)(\\.\\d+)?$");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static double getDetailOverFlow(double allMoney, String precisionMode) {
        double result = allMoney;
        try {
            char type = precisionMode.charAt(0);
            switch (type) {
                case '0': {
                    result = ManipulatePrecision.doubleConvert(allMoney, 2, 1);
                    break;
                }
                case '1': {
                    result = ManipulatePrecision.doubleConvert(allMoney, 1, 1);
                    break;
                }
                case '2': {
                    result = ManipulatePrecision.doubleConvert(allMoney, 1, 0);
                    break;
                }
                case '3': {
                    result = ManipulatePrecision.doubleConvert(allMoney, 0, 1);
                    break;
                }
                case '4': {
                    result = ManipulatePrecision.doubleConvert(allMoney, 0, 0);
                    break;
                }
                case '5': {
                    result = ManipulatePrecision.doubleConvert(allMoney + 0.09, 1, 0);
                    break;
                }
                case '6': {
                    result = ManipulatePrecision.doubleConvert(allMoney + 0.9, 0, 0);
                    break;
                }
                case '7': {
                    result = ManipulatePrecision.doubleConvert(allMoney - 0.01, 1, 1);
                    break;
                }
                case '8': {
                    result = ManipulatePrecision.doubleConvert(allMoney - 0.1, 0, 1);
                    break;
                }
                case '9': {
                    result = ManipulatePrecision.doubleConvert(allMoney - 0.001, 2, 1);
                    break;
                }
                case 'A': {
                    result = ManipulatePrecision.doubleConvert(allMoney, 2, 0);
                    break;
                }
                case 'B': {
                    result = ManipulatePrecision.doubleConvert(allMoney + 0.009, 2, 0);
                    break;
                }
                case 'C': {
                    result = ManipulatePrecision.doubleConvert(allMoney, 1, 2);
                    break;
                }
                case 'D': {
                    result = ManipulatePrecision.doubleConvert(allMoney, 1, 3);
                    break;
                }
                case 'E': {
                    result = ManipulatePrecision.doubleConvert(allMoney, 2, 4, false, 100.0);
                    break;
                }
                case 'F': {
                    result = ManipulatePrecision.doubleConvert(allMoney, 2, 5, false, 100.0);
                    break;
                }
                case 'G': {
                    result = ManipulatePrecision.doubleConvert(allMoney, 2, 4, false, 500.0);
                    break;
                }
                case 'H': {
                    result = ManipulatePrecision.doubleConvert(allMoney, 2, 5, false, 500.0);
                    break;
                }
                case 'I': {
                    result = ManipulatePrecision.doubleConvert(allMoney, 2, 4, false, 0.05);
                    break;
                }
                case 'J': {
                    result = ManipulatePrecision.doubleConvert(allMoney, 2, 5, false, 0.05);
                    break;
                }
                case 'K': {
                    result = ManipulatePrecision.doubleConvert(allMoney, -2, 1, false);
                    break;
                }
                case 'L': {
                    result = ManipulatePrecision.roundDecimal(allMoney);
                }
            }
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return result;
        }
    }

    public static double getMoneyByPrecision(double amount, String prcutMode, String precision, boolean isTh) {
        int mode = "0".equals(precision) ? 2 : ManipulatePrecision.getDoubleScale(Double.valueOf(precision));
        double money = 0.0;
        char type = prcutMode.charAt(0);
        if (type == 'Y') {
            money = ManipulatePrecision.doubleConvert(amount, mode, 0);
        } else if (type == 'N') {
            money = ManipulatePrecision.doubleConvert(amount, mode, 1);
        } else if (type == 'E' || type == 'G' || type == 'I') {
            if (isTh) {
                if (type == 'E') {
                    money = ManipulatePrecision.getDetailOverFlow(amount, "F");
                } else if (type == 'G') {
                    money = ManipulatePrecision.getDetailOverFlow(amount, "H");
                } else if (type == 'I') {
                    money = ManipulatePrecision.getDetailOverFlow(amount, "J");
                }
            } else {
                money = ManipulatePrecision.getDetailOverFlow(amount, prcutMode);
            }
        } else {
            money = ManipulatePrecision.getDetailOverFlow(amount, prcutMode);
        }
        return money;
    }

    public static double getMoneyByPrecision(double amount, String prcutMode, String precision) {
        return ManipulatePrecision.getMoneyByPrecision(amount, prcutMode, precision, false);
    }

    public static boolean isIntegerForDouble(double obj) {
        double eps = 1.0E-10;
        return obj - Math.floor(obj) < eps;
    }
}

