/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.javaPos.commonkit;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.ModeDetailsVo;
import com.efuture.business.bean.SellType;
import com.efuture.business.bean.YPopStatusType;
import com.efuture.business.exception.EfutureException;
import com.efuture.business.javaPos.commonkit.Convert;
import com.efuture.business.javaPos.commonkit.CountZZK;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.javaPos.commonkit.ManipulateStr;
import com.efuture.business.javaPos.commonkit.PosLogicCompoment;
import com.efuture.business.javaPos.commonkit.beantransfer.CouponTransfer;
import com.efuture.business.javaPos.commonkit.beantransfer.GiftTransfer;
import com.efuture.business.javaPos.commonkit.beantransfer.GoodsTransfer;
import com.efuture.business.javaPos.commonkit.beantransfer.PaymentTransfer;
import com.efuture.business.javaPos.struct.AnalyzeBarcodeDef;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.ConsumersData;
import com.efuture.business.javaPos.struct.Coupon;
import com.efuture.business.javaPos.struct.CouponConditions;
import com.efuture.business.javaPos.struct.CouponGain;
import com.efuture.business.javaPos.struct.CouponProperty;
import com.efuture.business.javaPos.struct.CouponUse;
import com.efuture.business.javaPos.struct.DzcGoodsDetail;
import com.efuture.business.javaPos.struct.Gift;
import com.efuture.business.javaPos.struct.GiftsGroup;
import com.efuture.business.javaPos.struct.Goods;
import com.efuture.business.javaPos.struct.OperUser;
import com.efuture.business.javaPos.struct.Order;
import com.efuture.business.javaPos.struct.PayMode;
import com.efuture.business.javaPos.struct.Payment;
import com.efuture.business.javaPos.struct.PaymentForPos;
import com.efuture.business.javaPos.struct.PaymentMode;
import com.efuture.business.javaPos.struct.PopDetail;
import com.efuture.business.javaPos.struct.mainDataCentre.GoodsInfo;
import com.efuture.business.javaPos.struct.posManager.response.QueryAeonCouponOut;
import com.efuture.business.javaPos.struct.promotionCentre.SellCoupon;
import com.efuture.business.javaPos.struct.promotionCentre.SellCouponReverse;
import com.efuture.business.javaPos.struct.promotionCentre.SellDetail;
import com.efuture.business.javaPos.struct.promotionCentre.SellExceptPay;
import com.efuture.business.javaPos.struct.promotionCentre.SellPayment;
import com.efuture.business.javaPos.struct.promotionCentre.SellPopDetail;
import com.efuture.business.javaPos.struct.promotionCentre.request.RemovePayIn;
import com.efuture.business.javaPos.struct.promotionCentre.response.CalSaleReturnOut;
import com.efuture.business.javaPos.struct.promotionCentre.response.CalcOut;
import com.efuture.business.javaPos.struct.promotionCentre.response.CalcsingleOut;
import com.efuture.business.javaPos.struct.promotionCentre.response.ConfirmAffirmreturnOut;
import com.efuture.business.javaPos.struct.promotionCentre.response.CouponGainCalcOut;
import com.efuture.business.model.Elecscalecoderule;
import com.efuture.business.model.Syspara;
import com.efuture.business.util.CastUtil;
import com.efuture.business.util.DataExchageUtils;
import com.efuture.business.util.ENAUtil;
import com.efuture.business.util.PayModeUtils;
import com.efuture.business.util.RedisUtil;
import com.efuture.business.util.UUIDUtils;
import com.efuture.business.util.UniqueID;
import com.product.model.ServiceSession;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class PosLogicCompomentImpl
implements PosLogicCompoment {
    private static final Logger log = LoggerFactory.getLogger(PosLogicCompomentImpl.class);
    @Autowired
    public RedisUtil redisUtil;
    @Autowired
    public GoodsTransfer goodsTransfer;
    @Autowired
    public GiftTransfer giftTransfer;
    @Autowired
    public CouponTransfer couponTransfer;
    @Autowired
    public PaymentTransfer paymentTransfer;

    @Override
    public DzcGoodsDetail analyzeBarcode(String inputBarcode, List<Elecscalecoderule> elecCodeRules, int mmdddays, int ddhhdays, String mode) {
        Object code = null;
        double price = 0.0;
        double quantity = 0.0;
        String exp = null;
        DzcGoodsDetail dzcDetail = new DzcGoodsDetail();
        dzcDetail.setRetCode(0);
        try {
            int j;
            int i;
            Elecscalecoderule rule = null;
            for (i = 0; i < elecCodeRules.size(); ++i) {
                rule = elecCodeRules.get(i);
                int location = rule.getIdentifierPos();
                int length = inputBarcode.length();
                if (location > 0 && rule.getCodePos() > 0 && rule.getAmountPos() >= 0 && rule.getNumberPos() >= 0 && rule.getValidDatePos() >= 0 && location <= length && rule.getBarCodeLen() <= length && location + rule.getIdentifierLen() <= length && rule.getAmountPos() + rule.getAmountLen() <= length && rule.getCodePos() + rule.getCodeLen() <= length && rule.getNumberPos() + rule.getNumberLen() <= length && rule.getValidDatePos() + rule.getValidDateLen() <= length && inputBarcode.trim().length() == rule.getBarCodeLen().intValue() && inputBarcode.substring(location - 1, location + rule.getIdentifierLen() - 1).trim().equals(rule.getIdentifier().toString())) break;
            }
            if (i >= elecCodeRules.size()) {
                return dzcDetail;
            }
            code = inputBarcode.substring(rule.getCodePos() - 1, rule.getCodePos() + rule.getCodeLen() - 1);
            if (rule.getAmountLen() > 0) {
                j = rule.getAmountLen() - rule.getAmtDecimalPlace();
                StringBuffer sb = new StringBuffer();
                sb.append(inputBarcode.substring(rule.getAmountPos() - 1, rule.getAmountPos() + j - 1));
                sb.append(".");
                sb.append(inputBarcode.substring(rule.getAmountPos() + j - 1, rule.getAmountPos() + rule.getAmountLen() - 1));
                price = ManipulatePrecision.doubleConvert(Double.parseDouble(sb.toString()), 2, 1);
                if ("1".equals(mode)) {
                    if ("29".equals(rule.getIdentifier()) && ((String)code).length() == 4) {
                        code = "99" + (String)code;
                    }
                    code = CastUtil.castAeonGoodsCode((String)code);
                } else if ("2".equals(mode)) {
                    code = CastUtil.castCNAeonGoodsCode((String)code);
                }
            } else {
                price = 0.0;
            }
            String oriDzcmsl = "";
            if (rule.getNumberLen() > 0) {
                j = rule.getNumberLen() - rule.getNumDecimalPlace();
                StringBuffer sb = new StringBuffer();
                sb.append(inputBarcode.substring(rule.getNumberPos() - 1, rule.getNumberPos() + j - 1));
                sb.append(".");
                sb.append(inputBarcode.substring(rule.getNumberPos() + j - 1, rule.getNumberPos() + rule.getNumberLen() - 1));
                oriDzcmsl = sb.toString().replace(".", "");
                quantity = ManipulatePrecision.doubleConvert(Double.parseDouble(sb.toString()), 4, 1);
            } else {
                quantity = 0.0;
            }
            if (price <= 0.0 && quantity <= 0.0 && !this.zeroQty()) {
                return dzcDetail;
            }
            exp = rule.getValidDateLen() > 0 ? inputBarcode.substring(rule.getValidDatePos(), rule.getValidDatePos() + rule.getValidDateLen() - 1) : "";
            dzcDetail.setRetCode(1);
            if (exp.length() > 0) {
                dzcDetail.setRetCode(2);
                if ("1".equals(rule.getValidIdentifier())) {
                    LocalDate today = LocalDate.now();
                    LocalDate todayforCalc = today.plusDays(mmdddays);
                    todayforCalc = todayforCalc.minusDays(1L);
                    LocalDate expdate = LocalDate.of(today.getYear(), Integer.parseInt(exp.substring(0, 2)), Integer.parseInt(exp.substring(2)));
                    DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                    if (todayforCalc.getYear() != today.getYear()) {
                        if (!expdate.isBefore(today) || !todayforCalc.isBefore(expdate)) {
                            dzcDetail.setRetCode(1);
                            exp = expdate.format(df).toString();
                        }
                    } else if (!expdate.isBefore(today) && !todayforCalc.isBefore(expdate)) {
                        dzcDetail.setRetCode(1);
                        exp = expdate.format(df).toString();
                    }
                } else if ("2".equals(rule.getValidIdentifier())) {
                    LocalDateTime nowTime = LocalDateTime.now();
                    LocalDateTime nowTimeForCalc = LocalDateTime.of(nowTime.getYear(), nowTime.getMonth(), nowTime.getDayOfMonth(), nowTime.getHour(), 59);
                    nowTimeForCalc = nowTimeForCalc.plusDays(ddhhdays);
                    nowTimeForCalc = nowTimeForCalc.minusDays(1L);
                    LocalDateTime expTime = LocalDateTime.of(nowTime.getYear(), nowTime.getMonth(), Integer.parseInt(exp.substring(0, 2)), Integer.parseInt(exp.substring(2)), 59);
                    DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
                    if (nowTimeForCalc.getMonth() != nowTime.getMonth()) {
                        if (!expTime.isBefore(nowTime) || !nowTimeForCalc.isBefore(expTime)) {
                            dzcDetail.setRetCode(1);
                            exp = expTime.format(df).toString();
                        }
                    } else if (!expTime.isBefore(nowTime)) {
                        dzcDetail.setRetCode(1);
                        exp = expTime.format(df).toString();
                    }
                }
            }
            if ("4".equals(mode)) {
                code = ((String)code).replaceFirst("^0*", "");
            } else if ("5".equals(mode)) {
                code = inputBarcode.substring(0, 7) + "00000";
            } else if ("6".equals(mode)) {
                String neaCode = inputBarcode.substring(0, 7) + "00000";
                code = ENAUtil.EAN13_AddBarcodeCheckbit(neaCode);
            }
            dzcDetail.setInputBarcode(inputBarcode);
            dzcDetail.setCode((String)code);
            dzcDetail.setDzcmsl(quantity);
            dzcDetail.setDzcmjg(price);
            dzcDetail.setExpTime(exp);
            dzcDetail.setOriDzcmsl(oriDzcmsl);
            return dzcDetail;
        }
        catch (Exception e) {
            e.printStackTrace();
            return dzcDetail;
        }
    }

    protected boolean zeroQty() {
        return false;
    }

    protected boolean returnEscaleEditFlag(CacheModel cacheModel, Goods sg) {
        return false;
    }

    @Override
    public CacheModel addStampCodeGood(CacheModel cacheModel, String stampCode) {
        Goods good = new Goods();
        good.setFlowNo(cacheModel.getFlowNo());
        good.setFlowId(cacheModel.getGoodsList().size() + 1);
        good.setGoodsCode(stampCode);
        good.setGoodsNo(stampCode);
        good.setCategoryCode("00");
        good.setBarNo(stampCode);
        good.setSaleSpec(" ");
        good.setSaleUnit("\u4e2a");
        good.setFlag("9");
        good.setAssistantId("");
        good.setGoodsName("\u5370\u82b1\u7801");
        good.setEnFname("StampCode");
        good.setSaleUnit("");
        good.setOrgCode(cacheModel.getOrder().getShopCode());
        good.setQty(1.0);
        good.setGoodsType("97");
        good.setCategoryCode("");
        good.setListPrice(0.0);
        good.setSaleAmount(0.0);
        good.setSaleValue(0.0);
        good.setGuid(UUIDUtils.buildGuid());
        good.setPopDetailsInfo(new ArrayList<PopDetail>());
        good.setPrcutMode("0");
        cacheModel.getGoodsList().add(good);
        this.calcOrderAmount(cacheModel);
        return cacheModel;
    }

    @Override
    public CacheModel addStampCodeGood(CacheModel cacheModel, String stampCode, int flowid) {
        Goods good = new Goods();
        good.setFlowNo(cacheModel.getFlowNo());
        good.setFlowId(flowid);
        good.setGoodsCode(stampCode);
        good.setGoodsNo(stampCode);
        good.setCategoryCode("00");
        good.setBarNo(stampCode);
        good.setSaleSpec(" ");
        good.setSaleUnit("\u4e2a");
        good.setFlag("9");
        good.setAssistantId("");
        good.setGoodsName("\u5370\u82b1\u7801");
        good.setEnFname("StampCode");
        good.setSaleUnit("");
        good.setOrgCode(cacheModel.getOrder().getShopCode());
        good.setQty(1.0);
        good.setGoodsType("97");
        good.setCategoryCode("");
        good.setListPrice(0.0);
        good.setSaleAmount(0.0);
        good.setSaleValue(0.0);
        good.setGuid(UUIDUtils.buildGuid());
        good.setPopDetailsInfo(new ArrayList<PopDetail>());
        good.setPrcutMode("0");
        cacheModel.getGoodsList().add(good);
        this.calcOrderAmount(cacheModel);
        return cacheModel;
    }

    @Override
    public Goods calcGoodsAmount(GoodsInfo sg, String assistantId, boolean isdzcm, double dzcmsl, double dzcmjg, String eleMode, String originalBarNo, double qty, boolean isHaveQty, int popMode) {
        double quantity = qty;
        double allprice = 0.0;
        double dzcprice = 0.0;
        double dzcmjgzk = 0.0;
        double price = sg.getSalePrice();
        double origPrice = sg.getSalePrice();
        if (sg.getEscaleFlag() == 1 && !isdzcm && !isHaveQty) {
            return null;
        }
        if (isdzcm) {
            if (sg.getEWCCodeNum() > 0.0 && sg.getEWCCodeAmount() <= 0.0) {
                double jg;
                if (sg.getPartsNum() <= 0.0) {
                    sg.setPartsNum(1.0);
                }
                quantity = ManipulatePrecision.doubleConvert(dzcmsl / sg.getPartsNum(), 4, 1);
                price = ManipulatePrecision.doubleConvert(sg.getSalePrice(), 2, 1);
                allprice = quantity * price;
                dzcprice = 1.0;
                allprice = ManipulatePrecision.doubleConvert(allprice, 3, 0);
                if (ManipulatePrecision.doubleCompare(allprice = ManipulatePrecision.doubleConvert(allprice, 2, 1), jg = ManipulatePrecision.getDetailOverFlow(allprice, sg.getPrcutMode()), 2) != 0) {
                    dzcmjgzk = ManipulatePrecision.sub(allprice, jg);
                }
            } else if (sg.getEWCCodeNum() <= 0.0 && sg.getEWCCodeAmount() > 0.0) {
                if (sg.getSalePrice() <= 0.0 || "1".equals(eleMode) || "2".equals(eleMode)) {
                    quantity = 1.0;
                    allprice = price = dzcmjg;
                    sg.setSalePrice(price);
                    dzcprice = 1.0;
                } else {
                    quantity = ManipulatePrecision.doubleConvert(dzcmjg / sg.getSalePrice(), 4, 1);
                    price = sg.getSalePrice();
                    allprice = dzcmjg;
                    dzcprice = 2.0;
                }
            } else if (sg.getEWCCodeNum() > 0.0 && sg.getEWCCodeAmount() > 0.0) {
                if (sg.getPartsNum() <= 0.0) {
                    sg.setPartsNum(1.0);
                }
                quantity = ManipulatePrecision.doubleConvert(dzcmsl / sg.getPartsNum(), 4, 1);
                allprice = dzcmjg;
                log.info("salePrice=" + sg.getSalePrice() + "quantity=" + quantity + "allprice=" + allprice);
                sg.setSalePrice(ManipulatePrecision.doubleConvert(dzcmjg / (dzcmsl / sg.getPartsNum()), 2, 1));
                price = sg.getSalePrice();
            }
        }
        if (!this.checkFindGoodsAllowSale(sg, quantity, isdzcm, dzcmsl, dzcmjg, isHaveQty)) {
            return null;
        }
        Goods saleGoodsDef = this.goodsInfo2Goods(sg, assistantId, quantity, price, allprice, isdzcm, dzcmjgzk, dzcmsl, dzcmjg, originalBarNo, origPrice, popMode);
        saleGoodsDef = this.calcGoodsAmount(saleGoodsDef);
        return saleGoodsDef;
    }

    @Override
    public boolean checkSyjRange(CacheModel cacheModel, GoodsInfo goodsInfo) {
        String[] codes;
        if (null == cacheModel.getSyjgroup()) {
            return true;
        }
        if (StringUtils.isBlank((String)cacheModel.getSyjgroup().getSourceitem())) {
            return true;
        }
        if ("ALL".equals(cacheModel.getSyjgroup().getSourceitem())) {
            return true;
        }
        if ("0".equals(cacheModel.getSyjgroup().getSourceitem())) {
            return true;
        }
        for (String code : codes = cacheModel.getSyjgroup().getSourceitem().split(",")) {
            if ("1".equals(cacheModel.getSyjgroup().getSourcetype())) {
                if (!goodsInfo.getCategoryCode().equals(code)) continue;
                return true;
            }
            if ("2".equals(cacheModel.getSyjgroup().getSourcetype())) {
                if (!goodsInfo.getOrgCode().equals(code)) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    @Override
    public Goods calcGoodsAmount(Goods saleGoodsDef) {
        double dzcmjgzk = 0.0;
        if (saleGoodsDef.getDzcDiscountValue() > 0.0) {
            dzcmjgzk = saleGoodsDef.getDzcDiscountValue();
        }
        this.clearAllDicountonGoods(saleGoodsDef);
        if (dzcmjgzk > 0.0) {
            saleGoodsDef.setDzcDiscountValue(dzcmjgzk);
        }
        saleGoodsDef.setAdjustDiscountValue(this.getAdjustDiscount(saleGoodsDef));
        saleGoodsDef.setTotalDiscountValue(CountZZK.getZZK(saleGoodsDef));
        saleGoodsDef.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(saleGoodsDef.getTotalDiscountValue() - saleGoodsDef.getNoDisAmountValue()));
        saleGoodsDef.setSaleAmount(saleGoodsDef.getSaleValue() - saleGoodsDef.getTotalDiscountValue());
        saleGoodsDef.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(saleGoodsDef.getTotalDiscountValue() - saleGoodsDef.getNoDisAmountValue()));
        return saleGoodsDef;
    }

    @Override
    public CacheModel calcGoodsRebateByAmount(CacheModel cacheModel, int flow_id, String accreditNo, double discountAmount) {
        return this.calcGoodsRebateByAmount(cacheModel, flow_id, accreditNo, discountAmount, 0, true, false);
    }

    @Override
    public CacheModel calcGoodsRebateByAmount(CacheModel cacheModel, int flow_id, String accreditNo, double discountAmount, int mode) {
        return this.calcGoodsRebateByAmount(cacheModel, flow_id, accreditNo, discountAmount, mode, true, false);
    }

    @Override
    public CacheModel calcGoodsRebateByAmount(CacheModel cacheModel, int flow_id, String accreditNo, double discountAmount, int mode, boolean isZero, boolean isCheck) {
        if (null != cacheModel.getOrder().getOriginTerminalNo() && null != cacheModel.getOrder().getOriginTerminalSno()) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("20165");
            cacheModel.setErrMsg("\u6307\u5b9a\u5c0f\u7968\u9000\u8d27\u4e0d\u5141\u8bb8\u6298\u6263");
            return cacheModel;
        }
        if (discountAmount < 0.0) {
            return cacheModel;
        }
        if (ManipulatePrecision.doubleCompare(discountAmount, 0.0, 2) < 0) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("20169");
            cacheModel.setErrMsg("\u6298\u8ba9\u91d1\u989d\u4e0d\u5141\u8bb8\u5c0f\u4e8e0");
            return cacheModel;
        }
        Goods sg = cacheModel.getGoodsList().get(flow_id - 1);
        String flag = sg.getFlag();
        double disAmount = 0.0;
        if (mode == 1) {
            disAmount = discountAmount;
            discountAmount = ManipulatePrecision.doubleConvert(sg.getSaleAmount() + sg.getTempZrDiscount() + sg.getTempZzrDiscount() + sg.getTempZzkDiscount() - discountAmount);
        }
        if (flag.equals("0") || sg.getMinDiscount() * 100.0 >= 100.0 || !StringUtils.isBlank((String)sg.getSGoodsSno()) || 1 == cacheModel.getOrder().getSysPara().getAdjustMode() && sg.getPopDiscountValue() > 0.0) {
            cacheModel.setErrMsg("\u8be5\u5546\u54c1\u4e0d\u5141\u8bb8\u6253\u6298");
            cacheModel.setErrCode("20181");
            cacheModel.setCalcResult(-1);
            return cacheModel;
        }
        OperUser curGrant = cacheModel.getCurGrant();
        if (!isCheck && null != cacheModel.getCurTempGrant() && StringUtils.isNotEmpty((String)cacheModel.getCurTempGrant().getGh())) {
            curGrant = cacheModel.getCurTempGrant();
        }
        String obj = this.redisUtil.get("business:initialize:cacheid:" + cacheModel.getOrder().getShopCode() + cacheModel.getOrder().getTerminalNo());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj.toString(), ModeDetailsVo.class);
        List<Syspara> syspara = modeDetailsVo.getSyspara();
        String grantMode = ModeDetailsVo.getSysParaValue(syspara, "SQMS");
        if (isCheck && !this.checkGoodsGrantRange(sg, curGrant.getGrantgzs(), grantMode)) {
            cacheModel.setErrCode("1000");
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("20182");
            cacheModel.setErrMsg("\u5f53\u524d\u6388\u6743\u65e0\u6cd5\u5bf9\u8be5\u5546\u54c1\u8fdb\u884c\u6253\u6298");
            return cacheModel;
        }
        if (!this.checkVipzk(curGrant, sg)) {
            cacheModel.setErrCode("20180");
            cacheModel.setCalcResult(-1);
            cacheModel.setErrMsg("\u5f53\u524d\u6388\u6743\u65e0\u6cd5\u5bf9\u9ec4\u7801\u5546\u54c1\u8fdb\u884c\u6253\u6298");
            return cacheModel;
        }
        sg = cacheModel.getGoodsList().get(flow_id - 1);
        Goods oldsg = (Goods)sg.clone();
        if (ManipulatePrecision.doubleCompare(discountAmount, 0.0, 2) == 0) {
            sg.setDiscAmount(0.0);
            sg.setTempZrDiscount(0.0);
            sg.setTempZkl(100.0);
            sg.setAdjustDiscountValue(this.getAdjustDiscount(sg));
            sg.setTotalDiscountValue(CountZZK.getNoPrcutZZK(sg));
            sg.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sg.getTotalDiscountValue() - sg.getNoDisAmountValue()));
            sg.setSaleAmount(sg.getSaleValue() - sg.getTotalDiscountValue());
            cacheModel.getGoodsList().set(flow_id - 1, sg);
            this.calcOrderAmount(cacheModel);
            if (cacheModel.getOrder().getTempZzk() != 0.0) {
                cacheModel = this.calcOrderRebateByRate(cacheModel, accreditNo, 0.0);
            }
            if (cacheModel.getOrder().getTempZzr() != 0.0) {
                cacheModel = this.calcOrderRebateByAmount(cacheModel, accreditNo, 0.0);
            }
            return cacheModel;
        }
        if (isCheck && curGrant.getPrivdpzkl() <= 0.0) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("20149");
            cacheModel.setErrMsg("\u5f53\u524d\u4eba\u5458\u65e0\u6253\u6298\u6743\u9650");
            return cacheModel;
        }
        String precisionMode = DataExchageUtils.exchangePrecisionMode(sg.getPrcutMode());
        try {
            double MaxDiscountRate = 1.0 - sg.getMinDiscount();
            double MaxDiscountAmount = ManipulatePrecision.getDetailOverFlow(MaxDiscountRate * sg.getSaleValue(), precisionMode);
            double tempZrAmount = MaxDiscountAmount - CountZZK.getNoPrcutZZK(sg) + sg.getTempZrDiscount() + sg.getTempZzkDiscount() + sg.getTempZzrDiscount();
            tempZrAmount = ManipulatePrecision.getDetailOverFlow(tempZrAmount, precisionMode);
            if (tempZrAmount < 0.0) {
                tempZrAmount = 0.0;
            }
            boolean isExceed = false;
            if (1 != mode && 2 == cacheModel.getOrder().getSysPara().getAdjustMode()) {
                if (discountAmount > MaxDiscountAmount) {
                    if (!isZero) {
                        isExceed = true;
                        tempZrAmount = MaxDiscountAmount;
                    }
                    discountAmount = tempZrAmount;
                }
            } else if (discountAmount > tempZrAmount) {
                if (!isZero) {
                    isExceed = true;
                }
                discountAmount = tempZrAmount;
            }
            if (isExceed) {
                cacheModel.setErrCode("20183");
                cacheModel.setErrMsg(String.valueOf(tempZrAmount));
                cacheModel.setCalcResult(-1);
                cacheModel.getGoodsList().set(flow_id - 1, oldsg);
                return cacheModel;
            }
            if (isCheck) {
                double GrantDiscountRate = ManipulatePrecision.doubleConvert(curGrant.getPrivdpzkl() / 100.0, 2, 1);
                if (MaxDiscountRate > GrantDiscountRate) {
                    MaxDiscountRate = GrantDiscountRate;
                }
                MaxDiscountAmount = ManipulatePrecision.getDetailOverFlow(MaxDiscountRate * sg.getSaleValue(), precisionMode);
                tempZrAmount = MaxDiscountAmount - CountZZK.getNoPrcutZZK(sg) + sg.getTempZrDiscount() + sg.getTempZzkDiscount() + sg.getTempZzrDiscount();
                if (discountAmount > (tempZrAmount = ManipulatePrecision.getDetailOverFlow(tempZrAmount, precisionMode))) {
                    discountAmount = tempZrAmount;
                    cacheModel.setErrCode("20184");
                    cacheModel.setErrMsg(String.valueOf(curGrant.getPrivdpzkl()));
                    cacheModel.setCalcResult(-1);
                    cacheModel.getGoodsList().set(flow_id - 1, oldsg);
                    return cacheModel;
                }
            }
            discountAmount = ManipulatePrecision.getDetailOverFlow(discountAmount, precisionMode);
            sg.setTempZrDiscount(discountAmount);
            sg.setAdjustDiscountValue(this.getAdjustDiscount(sg));
            sg.setDiscAmount(disAmount);
            if (CountZZK.getNoPrcutZZK(sg) > MaxDiscountAmount) {
                sg.setTempZrDiscount(sg.getTempZrDiscount() - CountZZK.getNoPrcutZZK(sg) + MaxDiscountAmount);
                sg.setTempZrDiscount(ManipulatePrecision.getDetailOverFlow(sg.getTempZrDiscount(), precisionMode));
            }
            if (sg.getTempZrDiscount() < 0.0) {
                sg.setTempZrDiscount(0.0);
            }
            sg.setAdjustDiscountValue(this.getAdjustDiscount(sg));
            sg.setTotalDiscountValue(CountZZK.getNoPrcutZZK(sg));
            sg.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sg.getTotalDiscountValue() - sg.getNoDisAmountValue()));
            sg.setSaleAmount(sg.getSaleValue() - sg.getTotalDiscountValue());
            if (isCheck) {
                cacheModel.getOrder().setTerminalOperatorAuthzCardNo(accreditNo);
            }
            cacheModel.getGoodsList().set(flow_id - 1, sg);
            if (!"2".equals(cacheModel.getOrder().getSysPara().getOrderDiscSeq())) {
                if (cacheModel.getOrder().getTempZzk() > 0.0) {
                    cacheModel = this.calcOrderRebateByRate(cacheModel, accreditNo, 0.0);
                }
                if (cacheModel.getOrder().getTempZzr() > 0.0) {
                    cacheModel = this.calcOrderRebateByAmount(cacheModel, accreditNo, 0.0);
                }
            }
            cacheModel.setCalcResult(0);
            cacheModel.setErrMsg("");
            this.calcOrderAmount(cacheModel);
            if (isCheck && sg.getTempZrDiscount() == 0.0) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrCode("20185");
                cacheModel.setErrMsg("\u7279\u4ef7\u5546\u54c1\u4e0d\u5141\u8bb8\u6253\u6298");
                cacheModel.getGoodsList().set(flow_id - 1, oldsg);
                return cacheModel;
            }
            if (isCheck) {
                cacheModel = this.addMarketzk(cacheModel, flow_id);
            }
            return cacheModel;
        }
        catch (Exception e) {
            e.printStackTrace();
            cacheModel.getGoodsList().set(flow_id - 1, oldsg);
            return cacheModel;
        }
    }

    @Override
    public CacheModel calcGoodsRebateByRate(CacheModel cacheModel, int flow_id, String accreditNo, double discountRate) {
        return this.calcGoodsRebateByRate(cacheModel, flow_id, accreditNo, discountRate, false);
    }

    @Override
    public CacheModel calcGoodsRebateByRate(CacheModel cacheModel, int flow_id, String accreditNo, double discountRate, boolean isCheck) {
        log.info("\u5355\u54c1\u6298\u6263discountRate={}", (Object)discountRate);
        if (null != cacheModel.getOrder().getOriginTerminalNo() && null != cacheModel.getOrder().getOriginTerminalSno()) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("20165");
            cacheModel.setErrMsg("\u6307\u5b9a\u5c0f\u7968\u9000\u8d27\u4e0d\u5141\u8bb8\u6298\u6263");
            return cacheModel;
        }
        if (ManipulatePrecision.doubleCompare(discountRate, 0.0, 2) < 0) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("20186");
            cacheModel.setErrMsg("\u6298\u6263\u7387\u8d85\u8fc7100%\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
            return cacheModel;
        }
        Goods sg = cacheModel.getGoodsList().get(flow_id - 1);
        String flag = sg.getFlag();
        if (flag.equals("0") || sg.getMinDiscount() * 100.0 >= 100.0 || StringUtils.isNotBlank((String)sg.getSGoodsSno()) || 1 == cacheModel.getOrder().getSysPara().getAdjustMode() && sg.getPopDiscountValue() > 0.0) {
            cacheModel.setErrMsg("\u8be5\u5546\u54c1\u4e0d\u5141\u8bb8\u6253\u6298");
            cacheModel.setErrCode("20181");
            cacheModel.setCalcResult(-1);
            return cacheModel;
        }
        OperUser curGrant = cacheModel.getCurGrant();
        if (!isCheck && null != cacheModel.getCurTempGrant() && StringUtils.isNotEmpty((String)cacheModel.getCurTempGrant().getGh())) {
            curGrant = cacheModel.getCurTempGrant();
        }
        String obj = this.redisUtil.get("business:initialize:cacheid:" + cacheModel.getOrder().getShopCode() + cacheModel.getOrder().getTerminalNo());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj.toString(), ModeDetailsVo.class);
        List<Syspara> syspara = modeDetailsVo.getSyspara();
        String grantMode = ModeDetailsVo.getSysParaValue(syspara, "SQMS");
        if (isCheck && !this.checkGoodsGrantRange(sg, curGrant.getGrantgzs(), grantMode)) {
            cacheModel.setErrCode("20179");
            cacheModel.setCalcResult(-1);
            cacheModel.setErrMsg("\u5f53\u524d\u6388\u6743\u8303\u56f4\u65e0\u6cd5\u5bf9\u8be5\u5546\u54c1\u8fdb\u884c\u6253\u6298");
            return cacheModel;
        }
        if (!this.checkVipzk(curGrant, sg)) {
            cacheModel.setErrCode("20180");
            cacheModel.setCalcResult(-1);
            cacheModel.setErrMsg("\u5f53\u524d\u6388\u6743\u65e0\u6cd5\u5bf9\u9ec4\u7801\u5546\u54c1\u8fdb\u884c\u6253\u6298");
            return cacheModel;
        }
        sg = cacheModel.getGoodsList().get(flow_id - 1);
        Goods oldsg = sg.deepClone();
        double tempZr = oldsg.getTempZrDiscount();
        if (ManipulatePrecision.doubleCompare(discountRate, 0.0, 2) <= 0) {
            sg.setTempZkDiscount(0.0);
            sg.setAdjustDiscountValue(this.getAdjustDiscount(sg));
            sg.setTotalDiscountValue(CountZZK.getNoPrcutZZK(sg));
            sg.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sg.getTotalDiscountValue() - sg.getNoDisAmountValue()));
            sg.setSaleAmount(sg.getSaleValue() - sg.getTotalDiscountValue());
            sg.setTempZkl(100.0);
            cacheModel.getGoodsList().set(flow_id - 1, sg);
            this.calcOrderAmount(cacheModel);
            if (cacheModel.getOrder().getTempZzk() != 0.0) {
                cacheModel = this.calcOrderRebateByRate(cacheModel, accreditNo, 0.0);
            }
            if (cacheModel.getOrder().getTempZzr() != 0.0) {
                cacheModel = this.calcOrderRebateByAmount(cacheModel, accreditNo, 0.0);
            }
            return cacheModel;
        }
        if (isCheck && curGrant.getPrivdpzkl() <= 0.0) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("20149");
            cacheModel.setErrMsg("\u5f53\u524d\u4eba\u5458\u65e0\u6253\u6298\u6743\u9650");
            return cacheModel;
        }
        String precisionMode = DataExchageUtils.exchangePrecisionMode(sg.getPrcutMode());
        try {
            sg.setTempZrDiscount(0.0);
            sg.setTempZkDiscount(0.0);
            sg.setTempZzkDiscount(0.0);
            sg.setTempZzrDiscount(0.0);
            sg.setAdjustDiscountValue(this.getAdjustDiscount(sg));
            double maxDiscount = ManipulatePrecision.getDetailOverFlow((1.0 - sg.getMinDiscount()) * (sg.getSaleValue() - CountZZK.getNoPrcutZZK(sg)), precisionMode);
            sg.setTempZkDiscount(maxDiscount);
            sg.setAdjustDiscountValue(this.getAdjustDiscount(sg));
            if (CountZZK.getNoPrcutZZK(sg) > ManipulatePrecision.getDetailOverFlow(sg.getSaleValue() * (1.0 - sg.getMinDiscount()), precisionMode)) {
                sg.setTempZkDiscount(sg.getTempZkDiscount() - CountZZK.getNoPrcutZZK(sg) + ManipulatePrecision.getDetailOverFlow(sg.getSaleValue() * (1.0 - sg.getMinDiscount()), precisionMode));
                sg.setTempZkDiscount(ManipulatePrecision.getDetailOverFlow(sg.getTempZkDiscount(), precisionMode));
            }
            if (sg.getTempZkDiscount() < 0.0) {
                sg.setTempZkDiscount(0.0);
            }
            sg.setAdjustDiscountValue(this.getAdjustDiscount(sg));
            double MaxDiscountRate = sg.getTempZkDiscount() / (sg.getSaleValue() - CountZZK.getNoPrcutZZK(sg) + sg.getTempZkDiscount());
            MaxDiscountRate = ManipulatePrecision.doubleConvert((1.0 - MaxDiscountRate) * 100.0, 2, 1);
            boolean isExceed = false;
            if (2 == cacheModel.getOrder().getSysPara().getAdjustMode()) {
                if (ManipulatePrecision.doubleCompare(sg.getMinDiscount() * 100.0, 100.0 - discountRate, 2) > 0) {
                    isExceed = true;
                    MaxDiscountRate = ManipulatePrecision.doubleConvert(sg.getMinDiscount() * 100.0);
                }
            } else if (ManipulatePrecision.doubleCompare(MaxDiscountRate, 100.0 - discountRate, 2) > 0) {
                isExceed = true;
            }
            log.info("isExceed=====>" + isExceed);
            if (isExceed) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrCode("20177");
                cacheModel.setErrMsg(String.valueOf(MaxDiscountRate));
                cacheModel.getGoodsList().set(flow_id - 1, oldsg);
                return cacheModel;
            }
            log.info("isCheck=====>" + isCheck);
            if (isCheck && ManipulatePrecision.doubleCompare(curGrant.getPrivdpzkl(), discountRate, 2) < 0) {
                cacheModel.setErrCode("20178");
                cacheModel.setCalcResult(-1);
                cacheModel.setErrMsg(String.valueOf(curGrant.getCardno()));
                cacheModel.getGoodsList().set(flow_id - 1, oldsg);
                return cacheModel;
            }
            sg.setTempZkDiscount(0.0);
            sg.setAdjustDiscountValue(this.getAdjustDiscount(sg));
            if (2 == cacheModel.getOrder().getSysPara().getAdjustMode()) {
                sg.setTempZkDiscount(ManipulatePrecision.getDetailOverFlow(discountRate / 100.0 * sg.getSaleValue() - CountZZK.getNoPrcutZZK(sg), precisionMode));
            } else {
                sg.setTempZkDiscount(ManipulatePrecision.getDetailOverFlow(discountRate / 100.0 * (sg.getSaleValue() - CountZZK.getNoPrcutZZK(sg)), precisionMode));
            }
            sg.setAdjustDiscountValue(this.getAdjustDiscount(sg));
            log.info("discountRate=\u3010{}\u3011,getNoPrcutZZK=\u3010{}\u3011.salevalue=\u3010{}\u3011,MaxDiscountRate = \u3010{}\u3011", new Object[]{discountRate, CountZZK.getNoPrcutZZK(sg), sg.getSaleValue(), MaxDiscountRate});
            double maxtempDisc = 0.0;
            maxtempDisc = 2 == cacheModel.getOrder().getSysPara().getAdjustMode() ? ManipulatePrecision.getDetailOverFlow(sg.getSaleValue() * (1.0 - sg.getMinDiscount()), precisionMode) : ManipulatePrecision.getDetailOverFlow(sg.getSaleValue() * (100.0 - MaxDiscountRate) / 100.0, precisionMode);
            if (CountZZK.getNoPrcutZZK(sg) > maxtempDisc) {
                sg.setTempZkDiscount(ManipulatePrecision.getDetailOverFlow(sg.getTempZkDiscount() - CountZZK.getNoPrcutZZK(sg) + maxtempDisc, precisionMode));
            }
            if (sg.getTempZkDiscount() < 0.0) {
                sg.setTempZkDiscount(0.0);
            }
            sg.setAdjustDiscountValue(this.getAdjustDiscount(sg));
            sg.setTotalDiscountValue(CountZZK.getNoPrcutZZK(sg));
            sg.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sg.getTotalDiscountValue() - sg.getNoDisAmountValue()));
            sg.setSaleAmount(sg.getSaleValue() - sg.getTotalDiscountValue());
            if (sg.getTempZkDiscount() > 0.0) {
                sg.setTempZkl(ManipulatePrecision.doubleConvert(discountRate, 2, 1));
            }
            if (isCheck) {
                cacheModel.getOrder().setTerminalOperatorAuthzCardNo(accreditNo);
            }
            cacheModel.getGoodsList().set(flow_id - 1, sg);
            if (tempZr > 0.0) {
                cacheModel = this.calcGoodsRebateByAmount(cacheModel, flow_id, accreditNo, tempZr);
            } else if (!"2".equals(cacheModel.getOrder().getSysPara().getOrderDiscSeq())) {
                if (cacheModel.getOrder().getTempZzk() != 0.0) {
                    cacheModel = this.calcOrderRebateByRate(cacheModel, accreditNo, 0.0);
                }
                if (cacheModel.getOrder().getTempZzr() != 0.0) {
                    cacheModel = this.calcOrderRebateByAmount(cacheModel, accreditNo, 0.0);
                }
            }
            cacheModel.setCalcResult(0);
            cacheModel.setErrMsg("");
            this.calcOrderAmount(cacheModel);
            if (isCheck && sg.getTempZkDiscount() == 0.0) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrCode("20185");
                cacheModel.setErrMsg("\u7279\u4ef7\u5546\u54c1\u4e0d\u5141\u8bb8\u6253\u6298");
                cacheModel.getGoodsList().set(flow_id - 1, oldsg);
                return cacheModel;
            }
            if (isCheck) {
                cacheModel = this.addMarketzk(cacheModel, flow_id);
            }
            return cacheModel;
        }
        catch (Exception e) {
            e.printStackTrace();
            cacheModel.getGoodsList().set(flow_id - 1, oldsg);
            return cacheModel;
        }
    }

    @Override
    public CacheModel calcOrderRebateByRate(CacheModel cacheModel, String accreditNo, double discountRate) {
        return this.calcOrderRebateByRate(cacheModel, accreditNo, discountRate, false);
    }

    @Override
    public CacheModel calcOrderRebateByRate(CacheModel cacheModel, String accreditNo, double discountRate, boolean isCheck) {
        log.info("\u6574\u5355\u6298\u6263discountRate={}", (Object)discountRate);
        if (null != cacheModel.getCurGrant()) {
            // empty if block
        }
        if (cacheModel.getGoodsList().size() <= 0) {
            return cacheModel;
        }
        if (discountRate < 0.0) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("20164");
            cacheModel.setErrMsg("\u6298\u6263\u7387\u4e0d\u5141\u8bb8\u4e3a\u8d1f\u503c");
            return cacheModel;
        }
        if (null != cacheModel.getOrder().getOriginTerminalNo() && null != cacheModel.getOrder().getOriginTerminalSno()) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("20165");
            cacheModel.setErrMsg("\u6307\u5b9a\u5c0f\u7968\u9000\u8d27\u4e0d\u5141\u8bb8\u6298\u6263");
            return cacheModel;
        }
        OperUser curGrant = cacheModel.getCurGrant();
        if (!isCheck && null != cacheModel.getCurTempGrant() && StringUtils.isNotEmpty((String)cacheModel.getCurTempGrant().getGh())) {
            curGrant = cacheModel.getCurTempGrant();
        }
        if (ManipulatePrecision.doubleCompare(discountRate, 0.0, 2) <= 0) {
            log.info("\u53d6\u6d88\u624b\u5de5\u6298\u6263!!!!!!!!!!");
            for (int i = 0; i < cacheModel.getGoodsList().size(); ++i) {
                Goods sg = cacheModel.getGoodsList().get(i);
                sg.setTempZzkDiscount(0.0);
                sg.setAdjustDiscountValue(this.getAdjustDiscount(sg));
                sg.setTotalDiscountValue(CountZZK.getNoPrcutZZK(sg));
                sg.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sg.getTotalDiscountValue() - sg.getNoDisAmountValue()));
                sg.setSaleAmount(sg.getSaleValue() - sg.getTotalDiscountValue());
            }
            cacheModel.getOrder().setTempZzk(0.0);
            this.calcOrderAmount(cacheModel);
            return cacheModel;
        }
        if (isCheck && curGrant.getPrivzpzkl() <= 0.0) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("20149");
            cacheModel.setErrMsg("\u5f53\u524d\u4eba\u5458\u65e0\u6253\u6298\u6743\u9650");
            return cacheModel;
        }
        for (int i = 0; i < cacheModel.getGoodsList().size(); ++i) {
            Goods sg = cacheModel.getGoodsList().get(i);
            if (!(sg.getTempZzrDiscount() > 0.0)) continue;
            sg.setTempZzrDiscount(0.0);
            sg.setAdjustDiscountValue(this.getAdjustDiscount(sg));
            sg.setTotalDiscountValue(CountZZK.getNoPrcutZZK(sg));
            sg.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sg.getTotalDiscountValue() - sg.getNoDisAmountValue()));
        }
        boolean haveRebate = false;
        boolean realHaveRebate = false;
        double maxDiscount = 0.0;
        double tempDiscount = 0.0;
        double lastDiscount = 0.0;
        double totalSaleAmount = 0.0;
        double tempZzkAmount = 0.0;
        double tempAdjustDiscount = 0.0;
        double totalSaleValue = 0.0;
        int lastRowNo = -1;
        String precisionMode = "0";
        ArrayList<Integer> matchRows = new ArrayList<Integer>();
        String obj = this.redisUtil.get("business:initialize:cacheid:" + cacheModel.getOrder().getShopCode() + cacheModel.getOrder().getTerminalNo());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        List<Syspara> syspara = modeDetailsVo.getSyspara();
        String grantMode = ModeDetailsVo.getSysParaValue(syspara, "SQMS");
        for (int i = 0; i < cacheModel.getGoodsList().size(); ++i) {
            Goods sg = cacheModel.getGoodsList().get(i);
            String flag = sg.getFlag();
            precisionMode = DataExchageUtils.exchangePrecisionMode(sg.getPrcutMode());
            if (flag.equals("0") || "9".equals(flag) || sg.getMinDiscount() * 100.0 >= 100.0 || StringUtils.isNotBlank((String)sg.getSGoodsSno())) continue;
            if (!(!isCheck && sg.getIsZzk() || this.checkGoodsGrantRange(sg, curGrant.getGrantgzs(), grantMode))) {
                realHaveRebate = true;
                continue;
            }
            if (!this.checkVipzk(curGrant, sg)) {
                realHaveRebate = true;
                continue;
            }
            if (1 == cacheModel.getOrder().getSysPara().getAdjustMode() && sg.getPopDiscountValue() > 0.0) continue;
            double sMaxDiscount = ManipulatePrecision.getDetailOverFlow((1.0 - sg.getMinDiscount()) * sg.getSaleValue(), precisionMode);
            if (ManipulatePrecision.doubleCompare(sg.getTotalDiscountValue() - sg.getTempZzkDiscount(), sMaxDiscount, 2) >= 0) continue;
            haveRebate = true;
            sg.setIsZzk(true);
            matchRows.add(i);
            precisionMode = DataExchageUtils.exchangePrecisionMode(sg.getPrcutMode());
            maxDiscount += sMaxDiscount;
            tempDiscount += sg.getTotalDiscountValue();
            tempAdjustDiscount += sg.getAdjustDiscountValue();
            tempZzkAmount += sg.getTempZzkDiscount();
            totalSaleAmount = totalSaleAmount + sg.getSaleValue() - sg.getTotalDiscountValue();
            totalSaleValue += sg.getSaleValue();
            if (!(sMaxDiscount - sg.getTotalDiscountValue() + sg.getTempZzkDiscount() >= lastDiscount)) continue;
            lastDiscount = sMaxDiscount - sg.getTotalDiscountValue() + sg.getTempZzkDiscount();
            lastRowNo = i;
        }
        if (!haveRebate) {
            if (realHaveRebate) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrCode("20149");
                cacheModel.setErrMsg("\u5f53\u524d\u4eba\u5458\u65e0\u6253\u6298\u6743\u9650");
                return cacheModel;
            }
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("20166");
            cacheModel.setErrMsg("\u5f53\u524d\u4eba\u5458\u65e0\u53ef\u6253\u6298\u5546\u54c1");
            return cacheModel;
        }
        double maxDiscountRate = 0.0;
        maxDiscountRate = 2 == cacheModel.getOrder().getSysPara().getAdjustMode() ? maxDiscount / totalSaleValue : (maxDiscount - tempDiscount + tempZzkAmount) / (totalSaleAmount + tempZzkAmount);
        if (maxDiscountRate < 0.0) {
            maxDiscountRate = 0.0;
        }
        if (ManipulatePrecision.doubleCompare(maxDiscountRate = ManipulatePrecision.doubleConvert((1.0 - maxDiscountRate) * 100.0, 2, 1), 100.0 - discountRate, 2) > 0) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("20167");
            cacheModel.setErrMsg(String.valueOf(maxDiscountRate));
            return cacheModel;
        }
        if (isCheck && ManipulatePrecision.doubleCompare(curGrant.getPrivzpzkl(), discountRate, 2) < 0) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("20168");
            cacheModel.setErrMsg(String.valueOf(curGrant.getCardno()));
            return cacheModel;
        }
        for (int i = 0; i < cacheModel.getGoodsList().size(); ++i) {
            Goods sg = cacheModel.getGoodsList().get(i);
            sg.setTempZzkDiscount(0.0);
            sg.setTempZzrDiscount(0.0);
            sg.setAdjustDiscountValue(this.getAdjustDiscount(sg));
            sg.setTotalDiscountValue(CountZZK.getNoPrcutZZK(sg));
            sg.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sg.getTotalDiscountValue() - sg.getNoDisAmountValue()));
        }
        this.calcOrderAmount(cacheModel);
        precisionMode = DataExchageUtils.exchangePrecisionMode(cacheModel.getOrder().getPrecisionMode());
        if (1 == cacheModel.getOrder().getSysPara().getZdms()) {
            Iterator i = matchRows.iterator();
            while (i.hasNext()) {
                int i2 = (Integer)i.next();
                Goods sg = cacheModel.getGoodsList().get(i2);
                precisionMode = DataExchageUtils.exchangePrecisionMode(sg.getPrcutMode());
                double maxzzk = ManipulatePrecision.getDetailOverFlow((1.0 - sg.getMinDiscount()) * sg.getSaleValue(), precisionMode);
                log.info("maxDiscount\u6298\u6263" + maxDiscount + ",tempDiscount\u6298\u6263" + tempDiscount + ",tempZzkAmount\u6298\u6263" + tempZzkAmount + ",maxzzk\u6298\u6263" + maxzzk + ",totaldiscount\u6298\u6263" + sg.getTotalDiscountValue());
                if (2 == cacheModel.getOrder().getSysPara().getAdjustMode()) {
                    sg.setTempZzkDiscount(ManipulatePrecision.getDetailOverFlow(sg.getSaleValue() * discountRate / 100.0 - sg.getTotalDiscountValue() + sg.getTempZkDiscount() + sg.getTempZrDiscount(), precisionMode));
                } else {
                    sg.setTempZzkDiscount(ManipulatePrecision.getDetailOverFlow((sg.getSaleValue() - sg.getTotalDiscountValue()) * discountRate / 100.0, precisionMode));
                }
                if (sg.getTempZzkDiscount() < 0.0) {
                    sg.setTempZzkDiscount(0.0);
                }
                sg.setAdjustDiscountValue(this.getAdjustDiscount(sg));
                sg.setTotalDiscountValue(CountZZK.getNoPrcutZZK(sg));
                if (ManipulatePrecision.doubleCompare(sg.getTotalDiscountValue(), maxzzk, 2) > 0) {
                    sg.setTempZzkDiscount(ManipulatePrecision.getDetailOverFlow(sg.getTempZzkDiscount() - sg.getTotalDiscountValue() + maxzzk, precisionMode));
                }
                if (sg.getTempZzkDiscount() < 0.0) {
                    sg.setTempZzkDiscount(0.0);
                }
                sg.setAdjustDiscountValue(this.getAdjustDiscount(sg));
                sg.setTotalDiscountValue(CountZZK.getNoPrcutZZK(sg));
                sg.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sg.getTotalDiscountValue() - sg.getNoDisAmountValue()));
                sg.setSaleAmount(sg.getSaleValue() - sg.getTotalDiscountValue());
            }
        } else {
            double maxzzk;
            double finalDiscountAmount = 0.0;
            finalDiscountAmount = 2 == cacheModel.getOrder().getSysPara().getAdjustMode() ? ManipulatePrecision.getDetailOverFlow(discountRate / 100.0 * totalSaleValue - tempDiscount + tempZzkAmount, precisionMode) : ManipulatePrecision.getDetailOverFlow(discountRate / 100.0 * (totalSaleAmount + tempZzkAmount), precisionMode);
            log.info("\u6700\u7ec8\u6298\u6263" + finalDiscountAmount);
            double allotAmount = 0.0;
            Iterator iterator = matchRows.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                Goods sg = cacheModel.getGoodsList().get(i);
                if (i == lastRowNo) continue;
                precisionMode = DataExchageUtils.exchangePrecisionMode(sg.getPrcutMode());
                maxzzk = ManipulatePrecision.getDetailOverFlow((1.0 - sg.getMinDiscount()) * sg.getSaleValue(), precisionMode);
                log.info("maxDiscount\u6298\u6263" + maxDiscount + ",tempDiscount\u6298\u6263" + tempDiscount + ",tempZzkAmount\u6298\u6263" + tempZzkAmount + ",maxzzk\u6298\u6263" + maxzzk + ",totaldiscount\u6298\u6263" + sg.getTotalDiscountValue());
                sg.setTempZzkDiscount(ManipulatePrecision.getDetailOverFlow(finalDiscountAmount / (maxDiscount - tempDiscount + tempZzkAmount) * (maxzzk - sg.getTotalDiscountValue() + sg.getTempZzkDiscount()), precisionMode));
                if (sg.getTempZzkDiscount() < 0.0) {
                    sg.setTempZzkDiscount(0.0);
                }
                sg.setAdjustDiscountValue(this.getAdjustDiscount(sg));
                sg.setTotalDiscountValue(CountZZK.getNoPrcutZZK(sg));
                if (ManipulatePrecision.doubleCompare(sg.getTotalDiscountValue(), maxzzk, 2) > 0) {
                    sg.setTempZzkDiscount(ManipulatePrecision.getDetailOverFlow(sg.getTempZzkDiscount() - sg.getTotalDiscountValue() + maxzzk, precisionMode));
                }
                if (sg.getTempZzkDiscount() < 0.0) {
                    sg.setTempZzkDiscount(0.0);
                }
                sg.setAdjustDiscountValue(this.getAdjustDiscount(sg));
                sg.setTotalDiscountValue(CountZZK.getNoPrcutZZK(sg));
                sg.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sg.getTotalDiscountValue() - sg.getNoDisAmountValue()));
                sg.setSaleAmount(sg.getSaleValue() - sg.getTotalDiscountValue());
                allotAmount += sg.getTempZzkDiscount();
            }
            if (lastRowNo >= 0) {
                Goods sg = cacheModel.getGoodsList().get(lastRowNo);
                precisionMode = DataExchageUtils.exchangePrecisionMode(sg.getPrcutMode());
                sg.setTempZzkDiscount(ManipulatePrecision.getDetailOverFlow(finalDiscountAmount - allotAmount, precisionMode));
                double ftzk = ManipulatePrecision.doubleConvert(finalDiscountAmount - allotAmount);
                log.info("\u5206\u644a\u6298\u6263" + ftzk + ",lastRowNo" + lastRowNo);
                sg.setAdjustDiscountValue(this.getAdjustDiscount(sg));
                maxzzk = ManipulatePrecision.getDetailOverFlow((1.0 - sg.getMinDiscount()) * sg.getSaleValue(), precisionMode);
                if (ManipulatePrecision.doubleCompare(sg.getTotalDiscountValue(), maxzzk, 2) > 0) {
                    sg.setTempZzkDiscount(ManipulatePrecision.getDetailOverFlow(sg.getTempZzkDiscount() - sg.getTotalDiscountValue() + maxzzk, precisionMode));
                }
                if (sg.getTempZzkDiscount() < 0.0) {
                    sg.setTempZzkDiscount(0.0);
                }
                sg.setAdjustDiscountValue(this.getAdjustDiscount(sg));
                sg.setTotalDiscountValue(CountZZK.getNoPrcutZZK(sg));
                sg.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sg.getTotalDiscountValue() - sg.getNoDisAmountValue()));
                sg.setSaleAmount(sg.getSaleValue() - sg.getTotalDiscountValue());
            }
        }
        if (isCheck) {
            cacheModel.getOrder().setTotalDiscAuthzCardNo(accreditNo);
        }
        cacheModel.getOrder().setTempZzk(ManipulatePrecision.doubleConvert(discountRate));
        cacheModel.getOrder().setTempZzr(0.0);
        this.calcOrderAmount(cacheModel);
        if (isCheck) {
            cacheModel = this.addMarketzk(cacheModel);
        }
        return cacheModel;
    }

    @Override
    public CacheModel calcOrderRebateByAmount(CacheModel cacheModel, String accreditNo, double discountAmount) {
        return this.calcOrderRebateByAmount(cacheModel, accreditNo, discountAmount, 0, false);
    }

    @Override
    public CacheModel calcOrderRebateByAmountMode1(CacheModel cacheModel, String accreditNo, double discountAmount) {
        return this.calcOrderRebateByAmount(cacheModel, accreditNo, discountAmount, 1, false);
    }

    @Override
    public CacheModel calcOrderRebateByAmount(CacheModel cacheModel, String accreditNo, double discountAmount, int mode, boolean isCheck) {
        try {
            if (cacheModel.getGoodsList().size() <= 0) {
                return cacheModel;
            }
            if (null != cacheModel.getOrder().getOriginTerminalNo() && null != cacheModel.getOrder().getOriginTerminalSno()) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrCode("20165");
                cacheModel.setErrMsg("\u6307\u5b9a\u5c0f\u7968\u9000\u8d27\u4e0d\u5141\u8bb8\u6298\u6263");
                return cacheModel;
            }
            if (ManipulatePrecision.doubleCompare(discountAmount, 0.0, 2) < 0) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrCode("20169");
                cacheModel.setErrMsg("\u6298\u8ba9\u91d1\u989d\u4e0d\u5141\u8bb8\u5c0f\u4e8e0");
                return cacheModel;
            }
            if (mode == 1) {
                discountAmount = ManipulatePrecision.doubleConvert(cacheModel.getOrder().getSaleValue() - cacheModel.getOrder().getTotalDiscountValue() + cacheModel.getOrder().getTempZzr() - discountAmount);
            } else if (2 == cacheModel.getOrder().getSysPara().getAdjustMode() && (discountAmount = ManipulatePrecision.doubleConvert(discountAmount - cacheModel.getOrder().getTotalDiscountValue() + cacheModel.getOrder().getTempZzr())) < 0.0) {
                discountAmount = 0.0;
            }
            OperUser curGrant = cacheModel.getCurGrant();
            if (!isCheck && null != cacheModel.getCurTempGrant() && StringUtils.isNotEmpty((String)cacheModel.getCurTempGrant().getGh())) {
                curGrant = cacheModel.getCurTempGrant();
            }
            if (discountAmount < 0.0) {
                cacheModel.setCalcResult(-1);
                return cacheModel;
            }
            log.info("discountAmount1:\u3010{}\u3011", (Object)discountAmount);
            if (ManipulatePrecision.doubleCompare(discountAmount, 0.0, 2) == 0) {
                for (int i = 0; i < cacheModel.getGoodsList().size(); ++i) {
                    Goods sg = cacheModel.getGoodsList().get(i);
                    sg.setTempZzrDiscount(0.0);
                    sg.setIsZzr(false);
                    sg.setAdjustDiscountValue(this.getAdjustDiscount(sg));
                    sg.setTotalDiscountValue(CountZZK.getNoPrcutZZK(sg));
                    sg.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sg.getTotalDiscountValue() - sg.getNoDisAmountValue()));
                    sg.setSaleAmount(sg.getSaleValue() - sg.getTotalDiscountValue());
                }
                cacheModel.getOrder().setTempZzr(0.0);
                this.calcOrderAmount(cacheModel);
                return cacheModel;
            }
            if (isCheck && curGrant.getPrivzpzkl() <= 0.0) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrCode("20149");
                cacheModel.setErrMsg("\u5f53\u524d\u4eba\u5458\u65e0\u6253\u6298\u6743\u9650");
                return cacheModel;
            }
            String precisionMode = "0";
            ArrayList<Integer> matchRows = new ArrayList<Integer>();
            double totalDiscount = 0.0;
            double realTotalAllowDiscount = 0.0;
            double totalAllowDiscount = 0.0;
            double totalOldZzrDiscount = 0.0;
            double totalOldZzkDiscount = 0.0;
            double lastDiscount = 0.0;
            double totalOldDiscount = 0.0;
            double totalSaleValue = 0.0;
            int lastRowNo = 0;
            for (int i = 0; i < cacheModel.getGoodsList().size(); ++i) {
                Goods sg = cacheModel.getGoodsList().get(i);
                String flag = sg.getFlag();
                if (flag.equals("0") || "9".equals(flag) || sg.getMinDiscount() * 100.0 >= 100.0) continue;
                precisionMode = DataExchageUtils.exchangePrecisionMode(sg.getPrcutMode());
                String obj = this.redisUtil.get("business:initialize:cacheid:" + cacheModel.getOrder().getShopCode() + cacheModel.getOrder().getTerminalNo());
                ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj.toString(), ModeDetailsVo.class);
                List<Syspara> syspara = modeDetailsVo.getSyspara();
                String grantMode = ModeDetailsVo.getSysParaValue(syspara, "SQMS");
                double tempAllowDiscount = ManipulatePrecision.getDetailOverFlow((1.0 - sg.getMinDiscount()) * sg.getSaleValue(), precisionMode);
                if (isCheck) {
                    realTotalAllowDiscount += tempAllowDiscount;
                    if (!this.checkGoodsGrantRange(sg, curGrant.getGrantgzs(), grantMode)) {
                        continue;
                    }
                } else {
                    if (!sg.getIsZzr() && !this.checkGoodsGrantRange(sg, curGrant.getGrantgzs(), grantMode) || 1 == cacheModel.getOrder().getSysPara().getAdjustMode() && sg.getPopDiscountValue() > 0.0 || ManipulatePrecision.doubleCompare(sg.getTotalDiscountValue(), tempAllowDiscount, 2) >= 0) continue;
                    realTotalAllowDiscount += tempAllowDiscount;
                }
                if (!this.checkVipzk(curGrant, sg)) continue;
                sg.setIsZzr(true);
                matchRows.add(i);
                totalAllowDiscount += tempAllowDiscount;
                totalOldZzrDiscount += sg.getTempZzrDiscount();
                totalOldZzkDiscount += sg.getTempZzkDiscount();
                totalOldDiscount += sg.getTotalDiscountValue();
                totalSaleValue += sg.getSaleValue();
                double maxAdjustDiscount = 0.0;
                maxAdjustDiscount = ManipulatePrecision.getDetailOverFlow((1.0 - sg.getMinDiscount()) * sg.getSaleValue() - sg.getTotalDiscountValue() + sg.getTempZzrDiscount(), precisionMode);
                if (ManipulatePrecision.doubleCompare(maxAdjustDiscount, 0.0, 2) < 0) {
                    maxAdjustDiscount = 0.0;
                }
                totalDiscount += maxAdjustDiscount;
                if (!(maxAdjustDiscount >= lastDiscount)) continue;
                lastDiscount = maxAdjustDiscount;
                lastRowNo = i;
            }
            if (realTotalAllowDiscount <= 0.0) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrCode("20170");
                cacheModel.setErrMsg("\u5168\u5355\u6ca1\u6709\u53ef\u6298\u8ba9\u91d1\u989d");
                return cacheModel;
            }
            if (totalAllowDiscount <= 0.0) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrCode("20171");
                cacheModel.setErrMsg(curGrant.getCardno());
                return cacheModel;
            }
            double tempDiscountAmount = totalDiscount;
            if (tempDiscountAmount < 0.0) {
                tempDiscountAmount = 0.0;
                cacheModel.setCalcResult(-1);
                cacheModel.setErrCode("20172");
                cacheModel.setErrMsg("\u672c\u5355\u53ef\u6253\u6298\u91d1\u989d\u4e3a0");
                return cacheModel;
            }
            log.info("discountAmount:\u3010{}\u3011,tempDiscountAmount:\u3010{}\u3011", (Object)discountAmount, (Object)tempDiscountAmount);
            boolean isExceed = false;
            if (discountAmount > tempDiscountAmount) {
                isExceed = true;
            }
            if (isExceed) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrCode("20173");
                cacheModel.setErrMsg(String.valueOf(tempDiscountAmount));
                return cacheModel;
            }
            String orderPrecisionMode = DataExchageUtils.exchangePrecisionMode(cacheModel.getOrder().getPrecisionMode());
            double maxDiscountAmount = ManipulatePrecision.getDetailOverFlow(curGrant.getPrivzpzkl() / 100.0 * (cacheModel.getOrder().getSaleValue() - cacheModel.getOrder().getTotalDiscountValue() + totalOldZzrDiscount), orderPrecisionMode);
            if (isCheck && ManipulatePrecision.doubleCompare(discountAmount, maxDiscountAmount, 2) > 0) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrCode("20174");
                cacheModel.setErrMsg(curGrant.getCardno());
                return cacheModel;
            }
            double allotAmount = discountAmount;
            Iterator iterator = matchRows.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                log.info("matchRows" + i);
                Goods sg = cacheModel.getGoodsList().get(i);
                precisionMode = DataExchageUtils.exchangePrecisionMode(sg.getPrcutMode());
                double maxzzr = ManipulatePrecision.getDetailOverFlow((1.0 - sg.getMinDiscount()) * sg.getSaleValue(), precisionMode);
                log.info("maxzzr" + maxzzr + "discountAmount" + discountAmount + ",totalDiscount" + totalDiscount);
                if (i == lastRowNo) continue;
                sg.setTempZzrDiscount(ManipulatePrecision.getDetailOverFlow(discountAmount * (maxzzr - sg.getTotalDiscountValue() + sg.getTempZzrDiscount()) / totalDiscount, precisionMode));
                if (sg.getTempZzrDiscount() < 0.0) {
                    sg.setTempZzrDiscount(0.0);
                }
                sg.setAdjustDiscountValue(this.getAdjustDiscount(sg));
                if (ManipulatePrecision.doubleCompare(CountZZK.getNoPrcutZZK(sg), maxzzr, 2) > 0) {
                    sg.setTempZzrDiscount(ManipulatePrecision.getDetailOverFlow(sg.getTempZzrDiscount() - CountZZK.getNoPrcutZZK(sg) + maxzzr, precisionMode));
                }
                if (sg.getTempZzrDiscount() < 0.0) {
                    sg.setTempZzrDiscount(0.0);
                }
                allotAmount -= sg.getTempZzrDiscount();
                sg.setAdjustDiscountValue(this.getAdjustDiscount(sg));
                sg.setTotalDiscountValue(CountZZK.getNoPrcutZZK(sg));
                sg.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sg.getTotalDiscountValue() - sg.getNoDisAmountValue()));
                sg.setSaleAmount(sg.getSaleValue() - sg.getTotalDiscountValue());
                cacheModel.getGoodsList().set(i, sg);
            }
            log.info("allotAmount" + allotAmount);
            if (allotAmount > 0.0) {
                Goods sg = cacheModel.getGoodsList().get(lastRowNo);
                precisionMode = DataExchageUtils.exchangePrecisionMode(sg.getPrcutMode());
                sg.setTempZzrDiscount(ManipulatePrecision.getDetailOverFlow(allotAmount, precisionMode));
                if (sg.getTempZzrDiscount() > lastDiscount) {
                    sg.setTempZzrDiscount(sg.getAdjustDiscountValue() - CountZZK.getNoPrcutZZK(sg) - lastDiscount);
                    sg.setTempZzrDiscount(ManipulatePrecision.getDetailOverFlow(sg.getTempZzrDiscount(), precisionMode));
                }
                if (sg.getTempZzrDiscount() < 0.0) {
                    sg.setTempZzrDiscount(0.0);
                }
                sg.setAdjustDiscountValue(this.getAdjustDiscount(sg));
                sg.setTotalDiscountValue(CountZZK.getNoPrcutZZK(sg));
                sg.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sg.getTotalDiscountValue() - sg.getNoDisAmountValue()));
                sg.setSaleAmount(sg.getSaleValue() - sg.getTotalDiscountValue());
            }
            if (isCheck) {
                cacheModel.getOrder().setTotalDiscAuthzCardNo(accreditNo);
            }
            cacheModel.getOrder().setTempZzr(discountAmount);
            this.calcOrderAmount(cacheModel);
            if (isCheck) {
                cacheModel = this.addMarketzk(cacheModel);
            }
            return cacheModel;
        }
        catch (Exception e) {
            log.info("\u6574\u5355\u6298\u6263\u5f02\u5e38", (Throwable)e);
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("20175");
            cacheModel.setErrMsg("\u8ba1\u7b97\u6574\u5355\u6298\u8ba9\u91d1\u989d\u5f02\u5e38");
            return cacheModel;
        }
    }

    @Override
    public CacheModel editGoodsQty(CacheModel cacheModel, int flow_id, String accreditNo, double qty) {
        if (qty <= 0.0) {
            return cacheModel;
        }
        if (StringUtils.isNotBlank((String)cacheModel.getOrder().getOriginTerminalNo()) && StringUtils.isNotBlank((String)cacheModel.getOrder().getOriginTerminalSno())) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("20176");
            cacheModel.setErrMsg("\u6307\u5b9a\u5c0f\u7968\u9000\u8d27\u4e0d\u5141\u8bb8\u4fee\u6539\u5546\u54c1\u6570\u91cf");
            return cacheModel;
        }
        Goods sg = cacheModel.getGoodsList().get(flow_id - 1);
        if (null == sg) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("20148");
            cacheModel.setErrMsg("\u67e5\u4e0d\u5230\u5546\u54c1\u4fe1\u606f");
            return cacheModel;
        }
        if (sg.getEscaleFlag().equals("Y") && !this.checkEscaleEditFlag(sg)) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("20140");
            cacheModel.setErrMsg("\u7535\u5b50\u79e4\u5546\u54c1\u4e0d\u5141\u8bb8\u4fee\u6539\u6570\u91cf");
            return cacheModel;
        }
        if (sg.getBarcodeDiscount() > 0.0 && sg.getEscaleFlag().equals("Y")) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("20141");
            cacheModel.setErrMsg("\u91d1\u989d\u7801\u5546\u54c1\u4e0d\u5141\u8bb8\u4fee\u6539\u6570\u91cf");
            return cacheModel;
        }
        if (sg.getFlag().equals("0")) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("20142");
            cacheModel.setErrMsg("\u8d60\u54c1\u4e0d\u5141\u8bb8\u4fee\u6539\u6570\u91cf");
            return cacheModel;
        }
        if (sg.getControlFlag()) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("20143");
            cacheModel.setErrMsg("\u7ba1\u5236\u5546\u54c1\u4e0d\u5141\u8bb8\u4fee\u6539\u6570\u91cf");
            return cacheModel;
        }
        Goods oldsg = sg.deepClone();
        double tempzr = sg.getTempZrDiscount();
        double tempzkl = sg.getTempZkl();
        double discamount = sg.getDiscAmount();
        log.info("tempzkl" + tempzkl + ",tempzr" + tempzr + ",discamount" + discamount);
        String precisionMode = DataExchageUtils.exchangePrecisionMode(sg.getPrcutMode());
        try {
            if (null == sg.getSGoodsSno() || sg.getSGoodsSno().length() <= 0) {
                double oldQty = sg.getQty();
                double newQty = qty;
                sg.setQty(newQty);
                sg.setSaleValue(newQty * sg.getSalePrice());
                sg.setTempZkDiscount(0.0);
                sg.setTempZrDiscount(0.0);
                sg.setTempZzkDiscount(0.0);
                sg.setTempZzrDiscount(0.0);
                sg.setPopDiscountValue(0.0);
                sg.setDiscAmount(0.0);
                if (null != sg.getPopDetailsInfo()) {
                    sg.getPopDetailsInfo().clear();
                }
                sg.setFixedDiscountValue(ManipulatePrecision.getDetailOverFlow(ManipulatePrecision.mul(ManipulatePrecision.div(sg.getFixedDiscountValue(), oldQty), newQty), precisionMode));
                if (sg.getBarcodeDiscount() > 0.0) {
                    if (sg.getDisMode() == 1) {
                        if (ManipulatePrecision.doubleCompare(sg.getDisValue(), sg.getSalePrice(), 2) >= 0) {
                            sg.setBarcodeDiscount(sg.getSaleAmount());
                        } else {
                            sg.setBarcodeDiscount(ManipulatePrecision.getDetailOverFlow(sg.getDisValue() * sg.getQty(), precisionMode));
                        }
                    } else if (sg.getDisMode() == 2) {
                        if (ManipulatePrecision.doubleCompare(sg.getDisValue(), 100.0, 2) < 0) {
                            sg.setBarcodeDiscount(ManipulatePrecision.getDetailOverFlow(sg.getSaleValue() * sg.getDisValue(), precisionMode));
                        }
                    } else if (sg.getDisMode() == 3) {
                        if (ManipulatePrecision.doubleCompare(sg.getSaleValue(), 0.0, 2) == 0) {
                            sg.setSaleValue(ManipulatePrecision.getDetailOverFlow(sg.getDisValue() * sg.getQty(), sg.getPrcutMode()));
                            sg.setBarcodeDiscount(0.0);
                        } else if (ManipulatePrecision.doubleCompare(sg.getSalePrice(), sg.getDisValue(), 2) > 0) {
                            if (2 == cacheModel.getPopMode() || 1 == cacheModel.getPopMode()) {
                                sg.setBarcodeDiscount(ManipulatePrecision.getDetailOverFlow(sg.getSalePrice() - sg.getDisValue(), precisionMode));
                            } else {
                                sg.setBarcodeDiscount(ManipulatePrecision.getDetailOverFlow((sg.getSalePrice() - sg.getDisValue()) * sg.getQty(), precisionMode));
                            }
                        }
                    }
                }
                sg = this.converDiscount(sg, cacheModel);
                sg.setAdjustDiscountValue(ManipulatePrecision.getDetailOverFlow(this.getAdjustDiscount(sg), precisionMode));
                sg.setTotalDiscountValue(CountZZK.getNoPrcutZZK(sg));
                sg.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sg.getTotalDiscountValue() - sg.getNoDisAmountValue()));
                sg.setSaleAmount(ManipulatePrecision.getDetailOverFlow(sg.getSaleValue() - sg.getTotalDiscountValue(), sg.getPrcutMode()));
                cacheModel.getOrder().setTerminalOperatorAuthzCardNo(accreditNo);
                this.calcOrderAmount(cacheModel);
            } else {
                int num;
                List<Goods> goodslist = cacheModel.getGoodsList();
                int newnum = num = goodslist.size();
                for (int i = 0; i < num; ++i) {
                    Goods sGoods = goodslist.get(i);
                    if (null == sGoods.getSGoodsSno() || !sGoods.getSGoodsSno().equals(oldsg.getSGoodsSno())) continue;
                    double newQty = qty;
                    sGoods.setQty(newQty);
                    sGoods.setSaleValue(ManipulatePrecision.getDetailOverFlow(newQty * sGoods.getSalePrice(), precisionMode));
                    sGoods.setTempZkDiscount(0.0);
                    sGoods.setTempZzkDiscount(0.0);
                    sGoods.setTempZzrDiscount(0.0);
                    sGoods.setPopDiscountValue(0.0);
                    if (sGoods.getPopDetailsInfo() != null) {
                        sGoods.getPopDetailsInfo().clear();
                    }
                    sGoods.setAdjustDiscountValue(ManipulatePrecision.getDetailOverFlow(this.getAdjustDiscount(sGoods), precisionMode));
                    sGoods.setTotalDiscountValue(CountZZK.getNoPrcutZZK(sGoods));
                    sGoods.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sGoods.getTotalDiscountValue() - sGoods.getNoDisAmountValue()));
                    sGoods.setSaleAmount(ManipulatePrecision.getDetailOverFlow(sg.getSaleValue() - sGoods.getTotalDiscountValue(), precisionMode));
                    cacheModel.getOrder().setTerminalOperatorAuthzCardNo(accreditNo);
                    cacheModel.getGoodsList().add(sGoods);
                    ++newnum;
                    this.calcOrderAmount(cacheModel);
                }
            }
            return cacheModel;
        }
        catch (Exception e) {
            e.printStackTrace();
            cacheModel.getGoodsList().set(flow_id - 1, oldsg);
            return cacheModel;
        }
    }

    public Goods converDiscount(Goods sg, CacheModel cacheModel) {
        return sg;
    }

    @Override
    public CacheModel delOneGoods(CacheModel cacheModel, String accreditNo, int flow_id) {
        Goods sg = cacheModel.getGoodsList().get(flow_id - 1);
        if (null == sg) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("20148");
            cacheModel.setErrMsg("\u67e5\u4e0d\u5230\u5546\u54c1\u4fe1\u606f");
            return cacheModel;
        }
        cacheModel.getOrder().setTerminalOperatorAuthzCardNo(accreditNo);
        cacheModel.getGoodsList().remove(flow_id - 1);
        for (int i = flow_id - 1; i < cacheModel.getGoodsList().size(); ++i) {
            cacheModel.getGoodsList().get(i).setFlowId(i + 1);
        }
        this.calcOrderAmount(cacheModel);
        return cacheModel;
    }

    @Override
    public CacheModel editGoodsPrice(CacheModel cacheModel, int flow_id, String accreditNo, double price) {
        Goods sg = cacheModel.getGoodsList().get(flow_id - 1);
        if (null == sg) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("20148");
            cacheModel.setErrMsg("\u67e5\u4e0d\u5230\u5546\u54c1\u4fe1\u606f");
            return cacheModel;
        }
        if (!SellType.ISBACK(cacheModel.getOrder().getOrderType())) {
            if (!(null != cacheModel.getCurGrant().getPrivgj() && "Y".equals(cacheModel.getCurGrant().getPrivgj()) || this.noPriceEdit(sg))) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrCode("20160");
                cacheModel.setErrMsg("\u5f53\u524d\u4eba\u5458\u65e0\u6539\u4ef7\u6743\u9650");
                return cacheModel;
            }
        } else if (StringUtils.isNotBlank((String)cacheModel.getOrder().getOriginTerminalSno())) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("20150");
            cacheModel.setErrMsg("\u6307\u5b9a\u5c0f\u7968\u9000\u8d27\u4e0d\u5141\u8bb8\u6539\u4ef7");
            return cacheModel;
        }
        if (price < 0.0) {
            return cacheModel;
        }
        if (null != cacheModel.getOrder().getOriginTerminalNo() && null != cacheModel.getOrder().getOriginTerminalSno()) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("20161");
            cacheModel.setErrMsg("\u6307\u5b9a\u5c0f\u7968\u9000\u8d27\u4e0d\u5141\u8bb8\u4fee\u6539\u5546\u54c1\u4ef7\u683c");
            return cacheModel;
        }
        if (sg.getEscaleFlag().equals("Y") && !this.returnEscaleEditFlag(cacheModel, sg)) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("20151");
            cacheModel.setErrMsg("\u7535\u5b50\u79e4\u5546\u54c1\u4e0d\u5141\u8bb8\u4fee\u6539\u4ef7\u683c");
            return cacheModel;
        }
        if (sg.getFlag().equals("0")) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("20152");
            cacheModel.setErrMsg("\u8d60\u54c1\u4e0d\u5141\u8bb8\u4fee\u6539\u4ef7\u683c");
            return cacheModel;
        }
        if (null != sg.getSGoodsSno() && sg.getSGoodsSno().length() > 0) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("20153");
            cacheModel.setErrMsg("\u5957\u9910\u5546\u54c1\u4e0d\u5141\u8bb8\u4fee\u6539\u4ef7\u683c");
            return cacheModel;
        }
        String obj = this.redisUtil.get("business:initialize:cacheid:" + cacheModel.getOrder().getShopCode() + cacheModel.getOrder().getTerminalNo());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj.toString(), ModeDetailsVo.class);
        List<Syspara> syspara = modeDetailsVo.getSyspara();
        String grantMode = ModeDetailsVo.getSysParaValue(syspara, "SQMS");
        if (!(SellType.ISBACK(cacheModel.getOrder().getOrderType()) || this.checkGoodsGrantRange(sg, cacheModel.getCurGrant().getGrantgzs(), grantMode) || this.noPriceEdit(sg))) {
            cacheModel.setErrCode("20162");
            cacheModel.setCalcResult(-1);
            cacheModel.setErrMsg("\u5f53\u524d\u6388\u6743\u8303\u56f4\u4e0d\u5141\u8bb8\u4fee\u6539\u5546\u54c1\u4ef7\u683c");
            return cacheModel;
        }
        sg = cacheModel.getGoodsList().get(flow_id - 1);
        Goods oldsg = (Goods)sg.clone();
        String precisionMode = DataExchageUtils.exchangePrecisionMode(sg.getPrcutMode());
        try {
            double newPrice = ManipulatePrecision.getDetailOverFlow(price, sg.getPrcutMode());
            if (null != sg.getGoodsType() && !sg.getGoodsType().equals("P") && !sg.getGoodsType().equals("Z") && !sg.getGoodsType().equals("15") && newPrice <= 0.0) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrCode("20156");
                cacheModel.setErrMsg("\u8be5\u5546\u54c1\u4ef7\u683c\u5fc5\u987b\u5927\u4e8e0");
                return cacheModel;
            }
            if (newPrice < sg.getMinSalePrice()) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrCode("20157");
                cacheModel.setErrMsg(ManipulatePrecision.doubleToString(sg.getMinSalePrice()));
                return cacheModel;
            }
            if (!(SellType.ISBACK(cacheModel.getOrder().getOrderType()) && StringUtils.isBlank((String)cacheModel.getOrder().getOriginTerminalSno()) || !(newPrice < sg.getListPrice() * cacheModel.getCurGrant().getAdjustLow()) && !(newPrice > sg.getListPrice() * cacheModel.getCurGrant().getAdjustUpper()) || this.noPriceEdit(sg))) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrCode("20163");
                cacheModel.setErrMsg(ManipulatePrecision.doubleToString(cacheModel.getCurGrant().getAdjustLow()) + "~" + ManipulatePrecision.doubleToString(cacheModel.getCurGrant().getAdjustUpper()));
                return cacheModel;
            }
            sg.setSalePrice(ManipulatePrecision.getDetailOverFlow(newPrice, sg.getPrcutMode()));
            if (!"Y".equals(sg.getEscaleFlag()) || "Y".equals(sg.getEscaleFlag()) && this.returnEscaleEditFlag(cacheModel, sg)) {
                sg.setSaleValue(ManipulatePrecision.getDetailOverFlow(sg.getQty() * sg.getSalePrice(), precisionMode));
            } else {
                sg.setQty(ManipulatePrecision.doubleConvert(sg.getEWCCodeAmount() / sg.getSalePrice(), 4, 1));
                sg.setQtyrecalc(0);
                sg.setSaleValue(sg.getEWCCodeAmount());
                sg.setPopDiscountValue(0.0);
            }
            sg.setTempZkl(100.0);
            sg.setDiscAmount(0.0);
            sg.setTempZkDiscount(0.0);
            sg.setTempZrDiscount(0.0);
            sg.setTempZzkDiscount(0.0);
            sg.setTempZzrDiscount(0.0);
            sg.setFixedDiscountValue(0.0);
            sg.setAdjustDiscountValue(this.getAdjustDiscount(sg));
            sg.setPopDiscountValue(0.0);
            sg.getPopDetailsInfo().clear();
            sg.setTotalDiscountValue(CountZZK.getZZK(sg));
            sg.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sg.getTotalDiscountValue() - sg.getNoDisAmountValue()));
            sg.setSaleAmount(sg.getSaleValue() - sg.getTotalDiscountValue());
            cacheModel.getGoodsList().set(flow_id - 1, sg);
            cacheModel.getOrder().setTerminalOperatorAuthzCardNo(accreditNo);
            this.calcOrderAmount(cacheModel);
            return cacheModel;
        }
        catch (Exception e) {
            e.printStackTrace();
            cacheModel.getGoodsList().set(flow_id - 1, oldsg);
            return cacheModel;
        }
    }

    @Override
    public CacheModel fixGoodsPrice(CacheModel cacheModel, int flow_id, String accreditNo, double price) {
        Goods sg = cacheModel.getGoodsList().get(flow_id - 1);
        if (null == sg) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("20148");
            cacheModel.setErrMsg("\u67e5\u4e0d\u5230\u5546\u54c1\u4fe1\u606f");
            return cacheModel;
        }
        if (!SellType.ISBACK(cacheModel.getOrder().getOrderType())) {
            if (cacheModel.getCurGrant().getPrivdpzkl() <= 0.0) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrCode("20149");
                cacheModel.setErrMsg("\u5f53\u524d\u4eba\u5458\u65e0\u6253\u6298\u6743\u9650");
                return cacheModel;
            }
        } else if (StringUtils.isNotBlank((String)cacheModel.getOrder().getOriginTerminalSno())) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("20150");
            cacheModel.setErrMsg("\u6307\u5b9a\u5c0f\u7968\u9000\u8d27\u4e0d\u5141\u8bb8\u6539\u4ef7");
            return cacheModel;
        }
        if (price < 0.0) {
            return cacheModel;
        }
        if (sg.getEscaleFlag().equals("Y")) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("20151");
            cacheModel.setErrMsg("\u7535\u5b50\u79e4\u5546\u54c1\u4e0d\u5141\u8bb8\u4fee\u6539\u4ef7\u683c");
            return cacheModel;
        }
        if (sg.getFlag().equals("0")) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("20152");
            cacheModel.setErrMsg("\u8d60\u54c1\u4e0d\u5141\u8bb8\u4fee\u6539\u4ef7\u683c");
            return cacheModel;
        }
        if (StringUtils.isNotBlank((String)sg.getSGoodsSno())) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("20153");
            cacheModel.setErrMsg("\u5957\u9910\u5546\u54c1\u4e0d\u5141\u8bb8\u4fee\u6539\u4ef7\u683c");
            return cacheModel;
        }
        String obj = this.redisUtil.get("business:initialize:cacheid:" + cacheModel.getOrder().getShopCode() + cacheModel.getOrder().getTerminalNo());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj.toString(), ModeDetailsVo.class);
        List<Syspara> syspara = modeDetailsVo.getSyspara();
        String grantMode = ModeDetailsVo.getSysParaValue(syspara, "SQMS");
        if (!this.checkGoodsGrantRange(sg, cacheModel.getCurGrant().getGrantgzs(), grantMode)) {
            cacheModel.setErrCode("20154");
            cacheModel.setCalcResult(-1);
            cacheModel.setErrMsg("\u5f53\u524d\u6388\u6743\u65e0\u6cd5\u5bf9\u8be5\u5546\u54c1\u8fdb\u884c\u6253\u6298");
            return cacheModel;
        }
        if (ManipulatePrecision.doubleCompare(price, sg.getSalePrice(), 2) > 0) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("20155");
            cacheModel.setErrMsg("\u4e00\u53e3\u4ef7\u540e\u4ef7\u683c\u4e0d\u80fd\u9ad8\u4e8e\u539f\u96f6\u552e\u4ef7");
            return cacheModel;
        }
        sg = cacheModel.getGoodsList().get(flow_id - 1);
        Goods oldsg = (Goods)sg.clone();
        String precisionMode = DataExchageUtils.exchangePrecisionMode(sg.getPrcutMode());
        try {
            double MaxDiscountRate = 1.0 - sg.getMinDiscount();
            double GrantDiscountRate = ManipulatePrecision.doubleConvert(cacheModel.getCurGrant().getPrivdpzkl() / 100.0, 2, 1);
            boolean isGrantRate = false;
            if (MaxDiscountRate > GrantDiscountRate) {
                MaxDiscountRate = GrantDiscountRate;
                isGrantRate = true;
            }
            double MaxDiscountAmount = ManipulatePrecision.getDetailOverFlow(MaxDiscountRate * sg.getSaleValue(), precisionMode);
            MaxDiscountAmount = MaxDiscountAmount - sg.getTotalDiscountValue() + sg.getAdjustDiscountValue() - sg.getBarcodeDiscount();
            double newPrice = ManipulatePrecision.getDetailOverFlow(price, sg.getPrcutMode());
            if (null != sg.getGoodsType() && !sg.getGoodsType().equals("P") && !sg.getGoodsType().equals("Z") && !sg.getGoodsType().equals("15") && newPrice <= 0.0) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrCode("20156");
                cacheModel.setErrMsg("\u8be5\u5546\u54c1\u4ef7\u683c\u5fc5\u987b\u5927\u4e8e0");
                return cacheModel;
            }
            if (newPrice < sg.getMinSalePrice()) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrCode("20157");
                cacheModel.setErrMsg(ManipulatePrecision.doubleToString(sg.getMinSalePrice()));
                return cacheModel;
            }
            sg.setSaleValue(ManipulatePrecision.getDetailOverFlow(sg.getQty() * sg.getSalePrice(), precisionMode));
            sg.setTempZkl(100.0);
            sg.setTempZkDiscount(0.0);
            sg.setTempZrDiscount(0.0);
            sg.setTempZzkDiscount(0.0);
            sg.setTempZzrDiscount(0.0);
            sg.setFixedDiscountValue(0.0);
            sg.setAdjustDiscountValue(this.getAdjustDiscount(sg));
            sg.setTotalDiscountValue(CountZZK.getZZK(sg));
            sg.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sg.getTotalDiscountValue() - sg.getNoDisAmountValue()));
            sg.setSaleAmount(sg.getSaleValue() - sg.getTotalDiscountValue());
            sg.setFixedDiscountValue(ManipulatePrecision.getDetailOverFlow(sg.getSaleAmount() - newPrice * sg.getQty(), precisionMode));
            if (sg.getFixedDiscountValue() > MaxDiscountAmount) {
                if (isGrantRate) {
                    cacheModel.setErrCode("20158");
                    cacheModel.setErrMsg(100.0 - cacheModel.getCurGrant().getPrivdpzkl() + "%");
                } else {
                    cacheModel.setErrCode("20159");
                    cacheModel.setErrMsg(String.valueOf(MaxDiscountAmount));
                }
                cacheModel.setCalcResult(-1);
                cacheModel.getGoodsList().set(flow_id - 1, oldsg);
                return cacheModel;
            }
            sg.setAdjustDiscountValue(this.getAdjustDiscount(sg));
            sg.setTotalDiscountValue(CountZZK.getZZK(sg));
            sg.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sg.getTotalDiscountValue() - sg.getNoDisAmountValue()));
            sg.setSaleAmount(sg.getSaleValue() - sg.getTotalDiscountValue());
            cacheModel.getGoodsList().set(flow_id - 1, sg);
            cacheModel.getOrder().setTerminalOperatorAuthzCardNo(accreditNo);
            cacheModel = this.addMarketzk(cacheModel, flow_id);
            this.calcOrderAmount(cacheModel);
            return cacheModel;
        }
        catch (Exception e) {
            e.printStackTrace();
            cacheModel.getGoodsList().set(flow_id - 1, oldsg);
            return cacheModel;
        }
    }

    @Override
    public CacheModel CalcAeonOldCoupon(CacheModel cacheModel, QueryAeonCouponOut coupon) {
        try {
            boolean isHaveCust = false;
            LocalDate fromDate = LocalDate.parse(coupon.getCouponDetailModel().getFromDate(), DateTimeFormatter.BASIC_ISO_DATE);
            LocalDate toDate = LocalDate.parse(coupon.getCouponDetailModel().getToDate(), DateTimeFormatter.BASIC_ISO_DATE);
            LocalDate nowDate = LocalDate.now();
            if (nowDate.isBefore(fromDate) || nowDate.isAfter(toDate)) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrMsg("\u8be5\u4f18\u60e0\u5238\u4e0d\u5728\u6709\u6548\u671f\u5185");
                return cacheModel;
            }
            Object memoStr = "";
            double matchAmount = 0.0;
            double maxMatchAmount = 0.0;
            ArrayList<Integer> matchRows = new ArrayList<Integer>();
            int maxMatchRow = 0;
            block2: for (int i = 0; i < cacheModel.getGoodsList().size(); ++i) {
                Goods g = cacheModel.getGoodsList().get(i);
                if (g.getGoodsCode().equals(coupon.getCouponDetailModel().getCoupon()) || StringUtils.isBlank((String)g.getCategoryCode()) && StringUtils.isBlank((String)g.getArtCode())) continue;
                String artCode = g.getArtCode();
                if (cacheModel.getOrder().getSysPara().getBarCodeMode() != 2) {
                    artCode = g.getCategoryCode();
                }
                for (String category : coupon.getCouponCodes()) {
                    if (Long.parseLong(category) != Long.parseLong(artCode)) continue;
                    matchRows.add(i);
                    matchAmount = ManipulatePrecision.doubleConvert(matchAmount + g.getSaleAmount(), 2, 1);
                    if (!(g.getSaleAmount() >= maxMatchAmount)) continue block2;
                    maxMatchAmount = g.getSaleAmount();
                    maxMatchRow = i;
                    continue block2;
                }
            }
            double purchaseAmount = 0.0;
            double memberPurchaseAmount = 0.0;
            purchaseAmount = ManipulatePrecision.doubleConvert(coupon.getCouponDetailModel().getNormalPurchaseAmount() / 100.0, 2, 1);
            memberPurchaseAmount = ManipulatePrecision.doubleConvert(coupon.getCouponDetailModel().getJcardPurchaseAmount() / 100.0, 2, 1);
            if (null == cacheModel.getOrder().getConsumersData() || StringUtils.isBlank((String)cacheModel.getOrder().getConsumersData().getConsumersType())) {
                if (matchAmount < purchaseAmount) {
                    cacheModel.setCalcResult(-1);
                    cacheModel.setErrMsg("\u8ba2\u5355\u5546\u54c1\u4e0d\u6ee1\u8db3\u7528\u5238\u95e8\u574e\uff0c\u8fd8\u5dee" + ManipulatePrecision.doubleConvert(coupon.getCouponDetailModel().getNormalPurchaseAmount() / 100.0 - matchAmount, 2, 1) + "\u5143");
                    return cacheModel;
                }
            } else {
                isHaveCust = true;
                if (matchAmount < memberPurchaseAmount) {
                    cacheModel.setCalcResult(-1);
                    cacheModel.setErrMsg("\u8ba2\u5355\u5546\u54c1\u4e0d\u6ee1\u8db3\u7528\u5238\u95e8\u574e\uff0c\u8fd8\u5dee" + ManipulatePrecision.doubleConvert(coupon.getCouponDetailModel().getJcardPurchaseAmount() / 100.0 - matchAmount, 2, 1) + "\u5143");
                    return cacheModel;
                }
            }
            memoStr = (String)memoStr + purchaseAmount + "@" + memberPurchaseAmount;
            double discountAmount = 0.0;
            double discountValue = 0.0;
            double memberDiscountValue = 0.0;
            if (coupon.getCouponDetailModel().getDiscountFlag().equals("A")) {
                memberDiscountValue = ManipulatePrecision.getDetailOverFlow(coupon.getCouponDetailModel().getJcardDiscountValue() / 100.0, "B");
                discountValue = ManipulatePrecision.getDetailOverFlow(coupon.getCouponDetailModel().getNormalDiscountValue() / 100.0, "B");
                discountAmount = isHaveCust ? memberDiscountValue : discountValue;
                memoStr = (String)memoStr + ",A," + discountValue + "@" + memberDiscountValue;
            } else if (coupon.getCouponDetailModel().getDiscountFlag().equals("R")) {
                double discountRate = 0.0;
                memberDiscountValue = ManipulatePrecision.doubleConvert(coupon.getCouponDetailModel().getJcardDiscountValue() / 100.0, 2, 1);
                discountValue = ManipulatePrecision.doubleConvert(coupon.getCouponDetailModel().getNormalDiscountValue() / 100.0, 2, 1);
                discountRate = isHaveCust ? memberDiscountValue : discountValue;
                discountAmount = ManipulatePrecision.getDetailOverFlow(matchAmount * discountRate / 100.0, "B");
                memoStr = (String)memoStr + ",R," + discountValue + "@" + memberDiscountValue;
            }
            if (discountAmount <= 0.0) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrMsg("\u8be5\u4f18\u60e0\u5238\u672a\u4ea7\u751f\u4f18\u60e0\u91d1\u989d");
                return cacheModel;
            }
            if (discountAmount > matchAmount) {
                discountAmount = matchAmount;
            }
            double lastDiscountAmount = discountAmount;
            Iterator iterator = matchRows.iterator();
            while (iterator.hasNext()) {
                int matchRow;
                int i = matchRow = ((Integer)iterator.next()).intValue();
                if (matchRow == maxMatchRow) continue;
                Goods g = cacheModel.getGoodsList().get(i);
                double yhAmount = ManipulatePrecision.getDetailOverFlow(discountAmount * g.getSaleAmount() / matchAmount, "B");
                g.setPopDiscountValue(ManipulatePrecision.doubleConvert(g.getPopDiscountValue() + yhAmount, 2, 1));
                lastDiscountAmount -= yhAmount;
                g.setTotalDiscountValue(CountZZK.getZZK(g));
                g.setSaleAmount(ManipulatePrecision.doubleConvert(g.getSaleValue() - g.getTotalDiscountValue()));
                g.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(g.getTotalDiscountValue() - g.getNoDisAmountValue()));
                PopDetail pop = new PopDetail();
                pop.setPopPolicyGroup(YPopStatusType.pop_policy_group_aeoncoupon);
                pop.setPopDescribe(coupon.getCouponDetailModel().getDescription());
                pop.setPopMemo(coupon.getCouponDetailModel().getCoupon());
                pop.setDiscountAmount(yhAmount);
                pop.setPopMode("0");
                g.getPopDetailsInfo().add(pop);
            }
            if (lastDiscountAmount > 0.0) {
                Goods g = cacheModel.getGoodsList().get(maxMatchRow);
                lastDiscountAmount = ManipulatePrecision.getDetailOverFlow(lastDiscountAmount, "B");
                g.setPopDiscountValue(ManipulatePrecision.doubleConvert(g.getPopDiscountValue() + lastDiscountAmount, 2, 1));
                g.setTotalDiscountValue(CountZZK.getZZK(g));
                g.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(g.getTotalDiscountValue() - g.getNoDisAmountValue()));
                g.setSaleAmount(g.getSaleValue() - g.getTotalDiscountValue());
                PopDetail pop = new PopDetail();
                pop.setPopPolicyGroup(YPopStatusType.pop_policy_group_aeoncoupon);
                pop.setPopDescribe(coupon.getCouponDetailModel().getDescription());
                pop.setPopMemo(coupon.getCouponDetailModel().getCoupon());
                pop.setDiscountAmount(lastDiscountAmount);
                pop.setPopMode("0");
                g.getPopDetailsInfo().add(pop);
            }
            Goods couponGoods = new Goods();
            couponGoods.setGuid(UUIDUtils.buildGuid());
            couponGoods.setFlowId(cacheModel.getGoodsList().size() + 1);
            couponGoods.setGoodsCode(coupon.getCouponDetailModel().getCoupon());
            couponGoods.setGoodsName(coupon.getCouponDetailModel().getDescription());
            couponGoods.setBarNo(couponGoods.getGoodsCode());
            couponGoods.setSalePrice(0.0);
            couponGoods.setGoodsType("99");
            couponGoods.setGoodsNo(couponGoods.getGoodsCode());
            couponGoods.setQty(1.0);
            couponGoods.setSaleValue(0.0);
            couponGoods.setSaleAmount(0.0);
            couponGoods.setEscaleFlag("N");
            couponGoods.setCategoryCode("");
            couponGoods.setTempCategory("");
            couponGoods.setArtCode("");
            couponGoods.setPrcutMode("A");
            couponGoods.setRemark((String)memoStr + "," + coupon.getCouponDetailModel().getDescription());
            cacheModel.getGoodsList().add(couponGoods);
            this.calcOrderAmount(cacheModel);
            this.calcPayBalance(cacheModel);
            return cacheModel;
        }
        catch (Exception e) {
            e.printStackTrace();
            cacheModel.setCalcResult(-1);
            cacheModel.setErrMsg("\u8ba1\u7b97\u4f18\u60e0\u5238\u53d1\u751f\u9519\u8bef");
            return cacheModel;
        }
    }

    @Override
    public CacheModel CalcAeonPrivilegeCoupon(CacheModel cacheModel, QueryAeonCouponOut coupon, String code1, String code2) {
        try {
            boolean isHaveCust = false;
            LocalDate fromDate = LocalDate.parse(coupon.getCouponDetailModel().getFromDate(), DateTimeFormatter.BASIC_ISO_DATE);
            LocalDate toDate = LocalDate.parse(coupon.getCouponDetailModel().getToDate(), DateTimeFormatter.BASIC_ISO_DATE);
            LocalDate nowDate = LocalDate.now();
            if (nowDate.isBefore(fromDate) || nowDate.isAfter(toDate)) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrMsg("\u8be5\u4f18\u60e0\u5238\u4e0d\u5728\u6709\u6548\u671f\u5185");
                return cacheModel;
            }
            Object memoStr = "";
            double matchAmount = 0.0;
            double maxMatchAmount = 0.0;
            ArrayList<Integer> matchRows = new ArrayList<Integer>();
            int maxMatchRow = 0;
            block2: for (int i = 0; i < cacheModel.getGoodsList().size(); ++i) {
                Goods g = cacheModel.getGoodsList().get(i);
                if (g.getGoodsCode().equals(coupon.getCouponDetailModel().getCoupon()) || StringUtils.isBlank((String)g.getCategoryCode()) && StringUtils.isBlank((String)g.getArtCode())) continue;
                String artCode = g.getArtCode();
                if (cacheModel.getOrder().getSysPara().getBarCodeMode() != 2) {
                    artCode = g.getCategoryCode();
                }
                for (String category : coupon.getCouponCodes()) {
                    if (Long.parseLong(category) != Long.parseLong(artCode)) continue;
                    matchRows.add(i);
                    matchAmount = ManipulatePrecision.doubleConvert(matchAmount + g.getSaleAmount(), 2, 1);
                    if (!(g.getSaleAmount() >= maxMatchAmount)) continue block2;
                    maxMatchAmount = g.getSaleAmount();
                    maxMatchRow = i;
                    continue block2;
                }
            }
            double purchaseAmount = 0.0;
            double memberPurchaseAmount = 0.0;
            purchaseAmount = ManipulatePrecision.doubleConvert(coupon.getCouponDetailModel().getNormalPurchaseAmount() / 100.0, 2, 1);
            memberPurchaseAmount = ManipulatePrecision.doubleConvert(coupon.getCouponDetailModel().getJcardPurchaseAmount() / 100.0, 2, 1);
            if (null == cacheModel.getOrder().getConsumersData() || StringUtils.isBlank((String)cacheModel.getOrder().getConsumersData().getConsumersType())) {
                if (matchAmount < purchaseAmount) {
                    cacheModel.setCalcResult(-1);
                    cacheModel.setErrMsg("\u8ba2\u5355\u5546\u54c1\u4e0d\u6ee1\u8db3\u7528\u5238\u95e8\u574e\uff0c\u8fd8\u5dee" + ManipulatePrecision.doubleConvert(coupon.getCouponDetailModel().getNormalPurchaseAmount() / 100.0 - matchAmount, 2, 1) + "\u5143");
                    return cacheModel;
                }
            } else {
                isHaveCust = true;
                if (matchAmount < memberPurchaseAmount) {
                    cacheModel.setCalcResult(-1);
                    cacheModel.setErrMsg("\u8ba2\u5355\u5546\u54c1\u4e0d\u6ee1\u8db3\u7528\u5238\u95e8\u574e\uff0c\u8fd8\u5dee" + ManipulatePrecision.doubleConvert(coupon.getCouponDetailModel().getJcardPurchaseAmount() / 100.0 - matchAmount, 2, 1) + "\u5143");
                    return cacheModel;
                }
            }
            memoStr = (String)memoStr + purchaseAmount + "@" + memberPurchaseAmount;
            double discountAmount = 0.0;
            double discountValue = 0.0;
            double memberDiscountValue = 0.0;
            if (coupon.getCouponDetailModel().getDiscountFlag().equals("A")) {
                discountValue = ManipulatePrecision.getDetailOverFlow(coupon.getCouponDetailModel().getJcardDiscountValue() / 100.0, "0");
                memberDiscountValue = ManipulatePrecision.getDetailOverFlow(coupon.getCouponDetailModel().getNormalDiscountValue() / 100.0, "0");
                discountAmount = isHaveCust ? discountValue : memberDiscountValue;
                memoStr = (String)memoStr + ",A," + discountValue + "@" + memberDiscountValue;
            } else if (coupon.getCouponDetailModel().getDiscountFlag().equals("R")) {
                memberDiscountValue = ManipulatePrecision.doubleConvert(coupon.getCouponDetailModel().getJcardDiscountValue() / 100.0, 2, 1);
                discountValue = ManipulatePrecision.doubleConvert(coupon.getCouponDetailModel().getNormalDiscountValue() / 100.0, 2, 1);
                discountAmount = isHaveCust ? ManipulatePrecision.getDetailOverFlow(matchAmount * memberDiscountValue / 100.0, "B") : ManipulatePrecision.getDetailOverFlow(matchAmount * discountValue, "B");
                memoStr = (String)memoStr + ",R," + discountValue + "@" + memberDiscountValue;
            }
            if (discountAmount <= 0.0) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrMsg("\u8be5\u4f18\u60e0\u5238\u672a\u4ea7\u751f\u4f18\u60e0\u91d1\u989d");
                return cacheModel;
            }
            if (discountAmount > matchAmount) {
                discountAmount = matchAmount;
            }
            double lastDiscountAmount = discountAmount;
            Iterator iterator = matchRows.iterator();
            while (iterator.hasNext()) {
                int matchRow = (Integer)iterator.next();
                if (matchRow == maxMatchRow) continue;
                int i = matchRow;
                Goods g = cacheModel.getGoodsList().get(i);
                double yhAmount = ManipulatePrecision.getDetailOverFlow(discountAmount * g.getSaleAmount() / matchAmount, "B");
                g.setPopDiscountValue(ManipulatePrecision.doubleConvert(g.getPopDiscountValue() + yhAmount, 2, 1));
                lastDiscountAmount -= yhAmount;
                g.setTotalDiscountValue(CountZZK.getZZK(g));
                g.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(g.getTotalDiscountValue() - g.getNoDisAmountValue()));
                g.setSaleAmount(g.getSaleValue() - g.getTotalDiscountValue());
                PopDetail pop = new PopDetail();
                pop.setPopPolicyGroup(YPopStatusType.pop_policy_group_aeoncoupon);
                pop.setPopDescribe(coupon.getCouponDetailModel().getDescription() + "|" + code1 + "|" + code2);
                pop.setPopMemo(coupon.getCouponDetailModel().getCoupon());
                pop.setDiscountAmount(yhAmount);
                pop.setPopMode("0");
                g.getPopDetailsInfo().add(pop);
            }
            if (lastDiscountAmount > 0.0) {
                Goods g = cacheModel.getGoodsList().get(maxMatchRow);
                lastDiscountAmount = ManipulatePrecision.getDetailOverFlow(lastDiscountAmount, "B");
                g.setPopDiscountValue(ManipulatePrecision.doubleConvert(g.getPopDiscountValue() + lastDiscountAmount, 2, 1));
                g.setTotalDiscountValue(CountZZK.getZZK(g));
                g.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(g.getTotalDiscountValue() - g.getNoDisAmountValue()));
                g.setSaleAmount(g.getSaleValue() - g.getTotalDiscountValue());
                PopDetail pop = new PopDetail();
                pop.setPopPolicyGroup(YPopStatusType.pop_policy_group_aeoncoupon);
                pop.setPopDescribe(coupon.getCouponDetailModel().getDescription() + "|" + code1 + "|" + code2);
                pop.setPopMemo(coupon.getCouponDetailModel().getCoupon());
                pop.setDiscountAmount(lastDiscountAmount);
                pop.setPopMode("0");
                g.getPopDetailsInfo().add(pop);
            }
            Goods couponGoods = new Goods();
            couponGoods.setGuid(UUIDUtils.buildGuid());
            couponGoods.setFlowId(cacheModel.getGoodsList().size() + 1);
            couponGoods.setGoodsCode(coupon.getCouponDetailModel().getCoupon());
            couponGoods.setGoodsName("\u5168\u65e5\u901a\u5238");
            couponGoods.setBarNo(code1);
            couponGoods.setGoodsNo(code2);
            couponGoods.setSalePrice(0.0);
            couponGoods.setGoodsType("98");
            couponGoods.setGoodsNo(couponGoods.getGoodsCode());
            couponGoods.setQty(1.0);
            couponGoods.setSaleValue(0.0);
            couponGoods.setSaleAmount(0.0);
            couponGoods.setEscaleFlag("N");
            couponGoods.setCategoryCode("");
            couponGoods.setPrcutMode("A");
            couponGoods.setRemark((String)memoStr + "," + coupon.getCouponDetailModel().getDescription() + "|" + code1 + "|" + code2);
            couponGoods.setTempCategory("");
            couponGoods.setArtCode("");
            cacheModel.getGoodsList().add(couponGoods);
            this.calcOrderAmount(cacheModel);
            return cacheModel;
        }
        catch (Exception e) {
            e.printStackTrace();
            cacheModel.setCalcResult(-1);
            cacheModel.setErrMsg("\u8ba1\u7b97\u4f18\u60e0\u5238\u53d1\u751f\u9519\u8bef");
            return cacheModel;
        }
    }

    @Override
    public CacheModel delAeonOldCoupon(CacheModel cacheModel, String couponCode) {
        for (Goods sg : cacheModel.getGoodsList()) {
            if (null == sg || null == sg.getPopDetailsInfo()) continue;
            for (int i = 0; i < sg.getPopDetailsInfo().size(); ++i) {
                PopDetail pop = sg.getPopDetailsInfo().get(i);
                if (null == pop || !YPopStatusType.pop_policy_group_aeoncoupon.equals(pop.getPopPolicyGroup()) || !pop.getPopMemo().equals(couponCode)) continue;
                sg.setPopDiscountValue(ManipulatePrecision.doubleConvert(sg.getPopDiscountValue() - pop.getDiscountAmount(), 2, 1));
                sg.getPopDetailsInfo().remove(pop);
                --i;
            }
            sg.setTotalDiscountValue(CountZZK.getZZK(sg));
            sg.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sg.getTotalDiscountValue() - sg.getNoDisAmountValue()));
            sg.setSaleAmount(sg.getSaleValue() - sg.getTotalDiscountValue());
        }
        this.calcOrderAmount(cacheModel);
        cacheModel.setGoodsList(this.sortGoodsList(cacheModel.getGoodsList()));
        return cacheModel;
    }

    @Override
    public Goods calcGoodsAmountAfterPromotion(Goods saleGoodsDef) {
        String precisionMode = saleGoodsDef.getPrcutMode();
        saleGoodsDef.setTotalDiscountValue(CountZZK.getNoPrcutZZK(saleGoodsDef));
        saleGoodsDef.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(saleGoodsDef.getTotalDiscountValue() - saleGoodsDef.getNoDisAmountValue()));
        saleGoodsDef.setSaleAmount(ManipulatePrecision.sub(saleGoodsDef.getSaleValue(), saleGoodsDef.getTotalDiscountValue()));
        return saleGoodsDef;
    }

    @Override
    public CacheModel calcOrderAmountAfterPopSave(CacheModel cacheModel) {
        Goods saleGoods = null;
        boolean sign = true;
        Order saleOrder = cacheModel.getOrder();
        List<Goods> goodslist = cacheModel.getGoodsList();
        saleOrder.setOughtPay(0.0);
        saleOrder.setSaleValue(0.0);
        saleOrder.setRealSaleValue(0.0);
        saleOrder.setTotalDiscountValue(0.0);
        saleOrder.setRealTotalDiscountValue(0.0);
        saleOrder.setMemberDiscAmount(0.0);
        saleOrder.setCouponDiscAmount(0.0);
        saleOrder.setPreferentialDiscAmount(0.0);
        saleOrder.setTemporaryDiscAmount(0.0);
        saleOrder.setMealDiscAmount(0.0);
        saleOrder.setNoDiscountValue(0.0);
        saleOrder.setQty(0);
        double oughtPay = 0.0;
        double saleValue = 0.0;
        double totalDiscountValue = 0.0;
        double noDiscountValue = 0.0;
        double memberDiscAmount = 0.0;
        double preferentialDiscAmount = 0.0;
        double temporaryDiscAmount = 0.0;
        double mealDiscountAmout = 0.0;
        double couponDiscountAmount = 0.0;
        int totalNum = 0;
        for (int i = 0; i < goodslist.size(); ++i) {
            saleGoods = goodslist.get(i);
            if (saleGoods.getIsNoBackGift()) continue;
            this.calcGoodsAmountAfterPromotion(saleGoods);
            int Qty = (int)saleGoods.getQty();
            if ("Y".equals(saleGoods.getEscaleFlag()) && !this.checkEscaleEditFlag(saleGoods)) {
                Qty = 1;
            }
            if ((double)((int)saleGoods.getQty()) != saleGoods.getQty()) {
                Qty = 1;
            }
            if (!"97".equals(saleGoods.getGoodsType())) {
                totalNum += Qty;
            }
            saleValue = ManipulatePrecision.doubleConvert(saleValue + saleGoods.getSaleValue() * (double)sign, 2, 1);
            totalDiscountValue = ManipulatePrecision.doubleConvert(totalDiscountValue + saleGoods.getTotalDiscountValue() * (double)sign, 2, 1);
            memberDiscAmount = ManipulatePrecision.doubleConvert(memberDiscAmount + saleGoods.getCustomDiscountValue() * (double)sign, 2, 1);
            preferentialDiscAmount = ManipulatePrecision.doubleConvert(preferentialDiscAmount + saleGoods.getPopDiscountValue() * (double)sign, 2, 1);
            temporaryDiscAmount = ManipulatePrecision.doubleConvert(temporaryDiscAmount + saleGoods.getAdjustDiscountValue() * (double)sign, 2, 1);
            mealDiscountAmout = ManipulatePrecision.doubleConvert(mealDiscountAmout + saleGoods.getMealDiscountValue() * (double)sign, 2, 1);
            couponDiscountAmount = ManipulatePrecision.doubleConvert(couponDiscountAmount + saleGoods.getCouponValue() * (double)sign, 2, 1);
            noDiscountValue = ManipulatePrecision.doubleConvert(noDiscountValue + saleGoods.getNoDisAmountValue() * (double)sign, 2, 1);
        }
        oughtPay = saleValue - totalDiscountValue;
        double realOughtPay = ManipulatePrecision.getDetailOverFlow(oughtPay, saleOrder.getPrecisionMode());
        if (("E".equals(saleOrder.getPrecisionMode()) || "G".equals(saleOrder.getPrecisionMode())) && SellType.ISBACK(saleOrder.getOrderType())) {
            realOughtPay = ManipulatePrecision.getDetailOverFlow(oughtPay, "4");
        }
        saleOrder.setOughtPay(realOughtPay);
        saleOrder.setSaleValue(saleValue);
        saleOrder.setTotalDiscountValue(totalDiscountValue);
        saleOrder.setMemberDiscAmount(memberDiscAmount);
        saleOrder.setPreferentialDiscAmount(preferentialDiscAmount);
        saleOrder.setTemporaryDiscAmount(temporaryDiscAmount);
        saleOrder.setCouponDiscAmount(couponDiscountAmount);
        saleOrder.setNoDiscountValue(noDiscountValue);
        saleOrder.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(totalDiscountValue - noDiscountValue));
        saleOrder.setRealSaleValue(ManipulatePrecision.doubleConvert(saleValue - noDiscountValue));
        saleOrder.setQty(totalNum);
        this.getNewRateAmtForOrder(saleOrder);
        cacheModel.setOrder(saleOrder);
        return cacheModel;
    }

    @Override
    public CacheModel refreshAfterOrderSaveR10(CacheModel cacheModel, CouponGainCalcOut promotionOut) {
        try {
            if (null == cacheModel || null == promotionOut) {
                return cacheModel;
            }
            log.info("refreshAfterOrderSave1");
            cacheModel.getOrder().setSeqNo(promotionOut.getCalcBillid());
            if (null != promotionOut.getCoupons() && promotionOut.getCoupons().size() > 0) {
                for (int i = 0; i < promotionOut.getCoupons().size(); ++i) {
                    SellCoupon c = promotionOut.getCoupons().get(i);
                    if (null == c) continue;
                    if (cacheModel.getOrder().getCouponDetails() == null) {
                        cacheModel.getOrder().setCouponDetails(new ArrayList<Coupon>());
                    }
                    cacheModel.getOrder().getCouponDetails().add(this.couponTransfer.transferCoupon(c));
                }
            }
            log.info("refreshAfterOrderSave2");
            List<SellDetail> listGoods = null;
            if (null != promotionOut.getBillDetail() && null != promotionOut.getBillDetail().getSellDetails()) {
                listGoods = promotionOut.getBillDetail().getSellDetails();
            }
            log.info("refreshAfterOrderSave3");
            if (null != listGoods) {
                for (int i = 0; i < listGoods.size(); ++i) {
                    Goods goods2 = cacheModel.getGoodsList().get(i);
                    goods2 = this.goodsTransfer.transferGoods(listGoods.get(i), goods2, "0", cacheModel.getOrder().getSysPara().getCalcPriceType(), true, true, StringUtils.isNotBlank((String)cacheModel.getOrder().getOriginTerminalSno()));
                    goods2.setAdjustDiscountValue(this.getAdjustDiscount(goods2));
                    goods2.setTotalDiscountValue(CountZZK.getNoPrcutZZK(goods2));
                    goods2.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(goods2.getRealTotalDiscountValue() - goods2.getNoDisAmountValue()));
                    goods2.setRealSalePrice(ManipulatePrecision.doubleConvert(goods2.getSalePrice() - goods2.getNoDisAmountValue() / goods2.getQty()));
                    cacheModel.getGoodsList().set(i, goods2);
                }
            }
            if (null != promotionOut.getBillDetail().getSellPayments()) {
                log.info("promotionOut.getBillDetail().getSellPayments()==\u300b{}", (Object)JSONArray.toJSONString(promotionOut.getBillDetail().getSellPayments()));
                for (int i = 0; i < promotionOut.getBillDetail().getSellPayments().size(); ++i) {
                    Payment sp;
                    SellPayment sellPayment = promotionOut.getBillDetail().getSellPayments().get(i);
                    if (null == sellPayment) continue;
                    for (int j = 0; !(j >= cacheModel.getPayments().size() || null != (sp = cacheModel.getPayments().get(j)).getRownoId() && sp.getRownoId().equals(sellPayment.getRowNoId())); ++j) {
                        log.info("refreshAfterOrderSave4.1.1====>{}", (Object)JSONObject.toJSONString((Object)sp));
                        log.info("refreshAfterOrderSave4.1.2====>{}", (Object)JSONObject.toJSONString((Object)sellPayment));
                        if (!sp.getPayCode().equals(sellPayment.getPaycode()) || !StringUtils.isBlank((String)sp.getRownoId()) || !sp.getPuid().equals(sellPayment.getRowNoId())) continue;
                        sp.setRownoId(sellPayment.getRowNoId());
                        cacheModel.getPayments().set(j, sp);
                    }
                }
            }
            if ("4".equals(cacheModel.getOrder().getOrderType()) && null != cacheModel.getPayments() && cacheModel.getPayments().size() > 0) {
                block6: for (Payment payment : cacheModel.getPayments()) {
                    if (!StringUtils.isNotBlank((String)payment.getPayNo())) continue;
                    String rownoid = payment.getRownoId();
                    block7: for (int i = 0; i < cacheModel.getGoodsList().size(); ++i) {
                        Goods g = cacheModel.getGoodsList().get(i);
                        if (null == g.getCouponUses() || g.getCouponUses().size() <= 0) continue;
                        for (int j = 0; j < g.getCouponUses().size(); ++j) {
                            CouponUse c = g.getCouponUses().get(j);
                            if (null != c.getCouponGroup() && rownoid.equals(c.getRownoId()) && "A02".equals(c.getCouponGroup())) {
                                if (StringUtils.isNotBlank((String)c.getCouponNo())) continue block6;
                                c.setCouponNo(payment.getPayNo());
                                cacheModel.getGoodsList().get(i).getCouponUses().set(j, c);
                                continue block7;
                            }
                            if (rownoid.equals(c.getRownoId())) {
                                log.info(">>>>>>>>>c.getRownoId()=>{}", (Object)c.getRownoId());
                                c.setPayRowNo(payment.getRowno());
                            }
                            log.info("CouponUse[{}]==>{}", (Object)j, (Object)JSONObject.toJSONString((Object)c));
                        }
                    }
                }
            }
            double revenuePoint = cacheModel.getOrder().getThisTimePoint();
            log.info("\u9500\u552e\u83b7\u5f97\u79ef\u5206\uff0c\u65e0\u5c0f\u7968\u6263\u56de\u79ef\u5206\u8ba1\u7b97\uff1a" + revenuePoint);
            cacheModel.getOrder().setThisTimePoint(revenuePoint);
            log.info("ThisTimePoint" + cacheModel.getOrder().getThisTimePoint());
            cacheModel = this.calcOrderAmountAfterPopSave(cacheModel);
            return cacheModel;
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public CacheModel refreshAfterOrderSave(CacheModel cacheModel, CouponGainCalcOut promotionOut) {
        try {
            if (null == cacheModel || null == promotionOut) {
                return cacheModel;
            }
            log.info("refreshAfterOrderSave1");
            cacheModel.getOrder().setSeqNo(promotionOut.getCalcBillid());
            if (null != promotionOut.getCoupons() && promotionOut.getCoupons().size() > 0) {
                for (int i = 0; i < promotionOut.getCoupons().size(); ++i) {
                    SellCoupon c = promotionOut.getCoupons().get(i);
                    if (null == c) continue;
                    if (cacheModel.getOrder().getCouponDetails() == null) {
                        cacheModel.getOrder().setCouponDetails(new ArrayList<Coupon>());
                    }
                    cacheModel.getOrder().getCouponDetails().add(this.couponTransfer.transferCoupon(c));
                }
            }
            log.info("refreshAfterOrderSave2");
            List<SellDetail> listGoods = null;
            if (null != promotionOut.getBillDetail() && null != promotionOut.getBillDetail().getSellDetails()) {
                listGoods = promotionOut.getBillDetail().getSellDetails();
            }
            log.info("refreshAfterOrderSave3");
            if (null != listGoods) {
                for (int i = 0; i < listGoods.size(); ++i) {
                    Goods goods2 = cacheModel.getGoodsList().get(i);
                    goods2 = this.goodsTransfer.transferGoods(listGoods.get(i), goods2, "0", cacheModel.getOrder().getSysPara().getCalcPriceType(), true, true, StringUtils.isNotBlank((String)cacheModel.getOrder().getOriginTerminalSno()));
                    goods2.setAdjustDiscountValue(this.getAdjustDiscount(goods2));
                    goods2.setTotalDiscountValue(CountZZK.getNoPrcutZZK(goods2));
                    goods2.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(goods2.getRealTotalDiscountValue() - goods2.getNoDisAmountValue()));
                    goods2.setRealSalePrice(ManipulatePrecision.doubleConvert(goods2.getSalePrice() - goods2.getNoDisAmountValue() / goods2.getQty()));
                    cacheModel.getGoodsList().set(i, goods2);
                }
            }
            if (null != promotionOut.getBillDetail().getSellPayments()) {
                log.info("promotionOut.getBillDetail().getSellPayments()==\u300b{}", (Object)JSONArray.toJSONString(promotionOut.getBillDetail().getSellPayments()));
                for (int i = 0; i < promotionOut.getBillDetail().getSellPayments().size(); ++i) {
                    Payment sp;
                    SellPayment sellPayment = promotionOut.getBillDetail().getSellPayments().get(i);
                    if (null == sellPayment) continue;
                    for (int j = 0; !(j >= cacheModel.getPayments().size() || null != (sp = cacheModel.getPayments().get(j)).getRownoId() && sp.getRownoId().equals(sellPayment.getRowNoId())); ++j) {
                        log.info("refreshAfterOrderSave4.1.1====>{}", (Object)JSONObject.toJSONString((Object)sp));
                        log.info("refreshAfterOrderSave4.1.2====>{}", (Object)JSONObject.toJSONString((Object)sellPayment));
                        if (!sp.getPayCode().equals(sellPayment.getPaycode()) || !StringUtils.isBlank((String)sp.getRownoId()) || !sp.getPuid().equals(sellPayment.getRowNoId())) continue;
                        sp.setRownoId(sellPayment.getRowNoId());
                        cacheModel.getPayments().set(j, sp);
                    }
                }
            }
            if ("4".equals(cacheModel.getOrder().getOrderType()) && null != cacheModel.getPayments() && cacheModel.getPayments().size() > 0) {
                block6: for (Payment payment : cacheModel.getPayments()) {
                    if (!StringUtils.isNotBlank((String)payment.getPayNo())) continue;
                    String rownoid = payment.getRownoId();
                    block7: for (int i = 0; i < cacheModel.getGoodsList().size(); ++i) {
                        Goods g = cacheModel.getGoodsList().get(i);
                        if (null == g.getCouponUses() || g.getCouponUses().size() <= 0) continue;
                        for (int j = 0; j < g.getCouponUses().size(); ++j) {
                            CouponUse c = g.getCouponUses().get(j);
                            if (null != c.getCouponGroup() && rownoid.equals(c.getRownoId()) && "A02".equals(c.getCouponGroup())) {
                                if (StringUtils.isNotBlank((String)c.getCouponNo())) continue block6;
                                c.setCouponNo(payment.getPayNo());
                                cacheModel.getGoodsList().get(i).getCouponUses().set(j, c);
                                continue block7;
                            }
                            if (rownoid.equals(c.getRownoId())) {
                                log.info(">>>>>>>>>c.getRownoId()=>{}", (Object)c.getRownoId());
                                c.setPayRowNo(payment.getRowno());
                            }
                            log.info("CouponUse[{}]==>{}", (Object)j, (Object)JSONObject.toJSONString((Object)c));
                        }
                    }
                }
            }
            double revenuePoint = this.getRevenuePoint(promotionOut, cacheModel.getOrder());
            log.info("\u9500\u552e\u83b7\u5f97\u79ef\u5206\uff0c\u65e0\u5c0f\u7968\u6263\u56de\u79ef\u5206\u8ba1\u7b97\uff1a" + revenuePoint);
            cacheModel.getOrder().setThisTimePoint(revenuePoint);
            log.info("ThisTimePoint" + cacheModel.getOrder().getThisTimePoint());
            cacheModel = this.calcOrderAmountAfterPopSave(cacheModel);
            return cacheModel;
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public double getRevenuePoint(CouponGainCalcOut couponGainCalcOut, Order order) {
        double memberPoints = 0.0;
        List<SellCoupon> sellCoupons = null;
        sellCoupons = couponGainCalcOut.getCoupons();
        if (CollectionUtils.isNotEmpty(sellCoupons)) {
            for (SellCoupon sellCoupon : sellCoupons) {
                if (!"01".equals(sellCoupon.getCouponGroup())) continue;
                memberPoints = ManipulatePrecision.add(memberPoints, sellCoupon.getAmount());
            }
        }
        return ManipulatePrecision.getDetailOverFlow(memberPoints, "0");
    }

    @Override
    public void calcOrderAmount(CacheModel cacheModel) {
        Goods saleGoods = null;
        boolean sign = true;
        Order saleOrder = cacheModel.getOrder();
        List<Goods> goodslist = cacheModel.getGoodsList();
        saleOrder.setOughtPay(0.0);
        saleOrder.setRoundUpOverageValue(0.0);
        saleOrder.setSaleValue(0.0);
        saleOrder.setRealSaleValue(0.0);
        saleOrder.setTotalDiscountValue(0.0);
        saleOrder.setStudentCardDiscountValue(0.0);
        saleOrder.setRealTotalDiscountValue(0.0);
        saleOrder.setMemberDiscAmount(0.0);
        saleOrder.setCouponDiscAmount(0.0);
        saleOrder.setPreferentialDiscAmount(0.0);
        saleOrder.setTemporaryDiscAmount(0.0);
        saleOrder.setMealDiscAmount(0.0);
        saleOrder.setNoDiscountValue(0.0);
        saleOrder.setQty(0);
        saleOrder.setTempRandomDiscount(0.0);
        double oughtPay = 0.0;
        double saleValue = 0.0;
        double totalDiscountValue = 0.0;
        double noDiscountValue = 0.0;
        double noDiscountValueDzc = 0.0;
        double memberDiscAmount = 0.0;
        double preferentialDiscAmount = 0.0;
        double temporaryDiscAmount = 0.0;
        double mealDiscountAmout = 0.0;
        double couponDiscountAmount = 0.0;
        double studentCardDiscountValue = 0.0;
        double tempRandomDiscount = 0.0;
        int totalNum = 0;
        for (int i = 0; i < goodslist.size(); ++i) {
            saleGoods = goodslist.get(i);
            if (saleGoods.getIsNoBackGift()) continue;
            this.calcGoodsAmountAfterPromotion(saleGoods);
            int Qty = (int)saleGoods.getQty();
            if ("Y".equals(saleGoods.getEscaleFlag()) && !this.checkEscaleEditFlag(saleGoods)) {
                Qty = 1;
            }
            if ((double)((int)saleGoods.getQty()) != saleGoods.getQty()) {
                Qty = 1;
            }
            if (!"97".equals(saleGoods.getGoodsType())) {
                totalNum += Qty;
            }
            saleValue = ManipulatePrecision.doubleConvert(saleValue + saleGoods.getSaleValue() * (double)sign, 2, 1);
            totalDiscountValue = ManipulatePrecision.doubleConvert(totalDiscountValue + saleGoods.getTotalDiscountValue() * (double)sign, 2, 1);
            memberDiscAmount = ManipulatePrecision.doubleConvert(memberDiscAmount + saleGoods.getCustomDiscountValue() * (double)sign, 2, 1);
            preferentialDiscAmount = ManipulatePrecision.doubleConvert(preferentialDiscAmount + saleGoods.getPopDiscountValue() * (double)sign, 2, 1);
            temporaryDiscAmount = ManipulatePrecision.doubleConvert(temporaryDiscAmount + saleGoods.getAdjustDiscountValue() * (double)sign, 2, 1);
            mealDiscountAmout = ManipulatePrecision.doubleConvert(mealDiscountAmout + saleGoods.getMealDiscountValue() * (double)sign, 2, 1);
            couponDiscountAmount = ManipulatePrecision.doubleConvert(couponDiscountAmount + saleGoods.getCouponValue() * (double)sign, 2, 1);
            noDiscountValue = ManipulatePrecision.doubleConvert(noDiscountValue + saleGoods.getNoDisAmountValue() * (double)sign, 2, 1);
            if ("Y".equals(saleGoods.getEscaleFlag())) {
                noDiscountValueDzc = ManipulatePrecision.doubleConvert(noDiscountValueDzc + saleGoods.getNoDisAmountValue() * (double)sign, 2, 1);
            }
            studentCardDiscountValue = ManipulatePrecision.doubleConvert(studentCardDiscountValue + saleGoods.getStudentCardDiscountValue() * (double)sign, 2, 1);
            tempRandomDiscount = ManipulatePrecision.doubleConvert(tempRandomDiscount + saleGoods.getTempRandomDiscount() * (double)sign, 2, 1);
        }
        oughtPay = saleValue - totalDiscountValue;
        double realOughtPay = ManipulatePrecision.getDetailOverFlow(oughtPay, saleOrder.getPrecisionMode());
        if (("E".equals(saleOrder.getPrecisionMode()) || "G".equals(saleOrder.getPrecisionMode())) && SellType.ISBACK(saleOrder.getOrderType())) {
            realOughtPay = ManipulatePrecision.getDetailOverFlow(oughtPay, "4");
        }
        log.info("\u6c47\u603b\u8ba2\u5355\u660e\u7ec6 \uff1aoughtPay:" + oughtPay + "  realOughtPay:" + realOughtPay);
        saleOrder.setOughtPay(realOughtPay);
        saleOrder.setRoundUpOverageValue(ManipulatePrecision.doubleConvert(saleValue - totalDiscountValue - realOughtPay));
        saleOrder.setSaleValue(saleValue);
        saleOrder.setTotalDiscountValue(totalDiscountValue);
        saleOrder.setMemberDiscAmount(memberDiscAmount);
        saleOrder.setPreferentialDiscAmount(preferentialDiscAmount);
        saleOrder.setTemporaryDiscAmount(temporaryDiscAmount);
        saleOrder.setCouponDiscAmount(couponDiscountAmount);
        saleOrder.setNoDiscountValue(noDiscountValue);
        saleOrder.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(totalDiscountValue - noDiscountValue));
        saleOrder.setRealTotalDiscountValueDzc(ManipulatePrecision.doubleConvert(totalDiscountValue - noDiscountValueDzc));
        saleOrder.setRealSaleValue(ManipulatePrecision.doubleConvert(saleValue - noDiscountValue));
        saleOrder.setRealSaleValueDzc(ManipulatePrecision.doubleConvert(saleValue - noDiscountValueDzc));
        saleOrder.setQty(totalNum);
        saleOrder.setStudentCardDiscountValue(studentCardDiscountValue);
        saleOrder.setTempRandomDiscount(tempRandomDiscount);
        double existPay = 0.0;
        if (null != cacheModel.getPayments() && cacheModel.getPayments().size() > 0) {
            for (Payment p : cacheModel.getPayments()) {
                if ("2".equals(p.getFlag())) {
                    existPay = ManipulatePrecision.doubleConvert(existPay - p.getMoney() + p.getOverage(), 2, 1);
                    continue;
                }
                existPay = ManipulatePrecision.doubleConvert(existPay + p.getMoney() - p.getOverage(), 2, 1);
            }
        }
        if (ManipulatePrecision.doubleCompare(existPay, saleOrder.getOughtPay(), 2) > 0) {
            saleOrder.setOughtPay(existPay);
            saleOrder.setRoundUpOverageValue(0.0);
            saleOrder.setRemainValue(0.0);
        } else {
            saleOrder.setRemainValue(saleOrder.getOughtPay());
            saleOrder.setRoundUpOverageValue(ManipulatePrecision.doubleConvert(ManipulatePrecision.sub(oughtPay, realOughtPay)));
        }
        this.getNewRateAmtForOrder(saleOrder);
    }

    @Override
    public Goods clearAllDicountonGoods(Goods saleGoodsDef) {
        saleGoodsDef.setCouponValue(0.0);
        saleGoodsDef.setAdjustDiscountValue(0.0);
        saleGoodsDef.setTotalDiscountValue(0.0);
        saleGoodsDef.setRealTotalDiscountValue(0.0);
        saleGoodsDef.setCustomDiscountValue(0.0);
        saleGoodsDef.setPayDiscountValue(0.0);
        saleGoodsDef.setTempZkDiscount(0.0);
        saleGoodsDef.setTempZrDiscount(0.0);
        saleGoodsDef.setTempZzkDiscount(0.0);
        saleGoodsDef.setTempZzrDiscount(0.0);
        saleGoodsDef.setBarcodeDiscount(0.0);
        saleGoodsDef.setFixedDiscountValue(0.0);
        saleGoodsDef.setDzcDiscountValue(0.0);
        saleGoodsDef.setStudentCardDiscountValue(0.0);
        saleGoodsDef.setNoDisAmountValue(0.0);
        return saleGoodsDef;
    }

    @Override
    public Goods calcCustRebate(Goods saleGoodsDef) {
        return saleGoodsDef;
    }

    @Override
    public Goods calcBatchRebate(Goods saleGoodsDef) {
        return saleGoodsDef;
    }

    @Override
    public double getAdjustDiscount(Goods saleGoodsDef) {
        double adjustDiscount = ManipulatePrecision.doubleConvert(saleGoodsDef.getTempZkDiscount() + saleGoodsDef.getTempZrDiscount() + saleGoodsDef.getTempZzkDiscount() + saleGoodsDef.getTempZzrDiscount() + saleGoodsDef.getBarcodeDiscount() + saleGoodsDef.getFixedDiscountValue() + saleGoodsDef.getDzcDiscountValue(), 2, 1);
        return adjustDiscount;
    }

    @Override
    public String getSysParaValue(String mktCode, String code) {
        return "";
    }

    @Override
    public Goods goodsInfo2Goods(GoodsInfo goodsInfo, String yyyh, double quantity, double price, double allprice, boolean dzcm, double dzcmjgzk, double dzcmsl, double dzcmjg, String originalBarNo, double origPrice, int popMode) {
        Goods goods = new Goods();
        BeanUtils.copyProperties((Object)goodsInfo, (Object)goods);
        goods.setAssistantId("");
        if (StringUtils.isNotBlank((String)yyyh)) {
            goods.setAssistantId(yyyh);
        }
        goods.setTempZkl(100.0);
        goods.setGoodsCode(goodsInfo.getGoodsCode());
        goods.setBarNo(goodsInfo.getBarNo());
        goods.setGoodsNo(originalBarNo);
        goods.setGoodsName(goodsInfo.getGoodsName());
        goods.setGoodsType(goodsInfo.getGoodsType());
        goods.setMainBarcodeFlag(goodsInfo.getMainBarcodeFlag());
        goods.setSaleSpec(goodsInfo.getSaleSpec());
        goods.setSaleUnit(goodsInfo.getPartsUnit());
        goods.setListPrice(origPrice);
        goods.setSalePrice(ManipulatePrecision.getDetailOverFlow(origPrice, goodsInfo.getPrcutMode()));
        if (0.0 == goods.getSalePrice()) {
            goods.setSalePrice(ManipulatePrecision.getDetailOverFlow(goodsInfo.getSalePrice(), goodsInfo.getPrcutMode()));
        }
        goods.setRealSalePrice(price);
        goods.setQty(quantity);
        goods.setQuantityRecalc(quantity);
        goods.setOrgCode(goodsInfo.getOrgCode());
        goods.setCategoryCode(goodsInfo.getCategoryCode());
        goods.setIsfresh(goodsInfo.getIsfresh());
        goods.setGoodsUid(goodsInfo.getGoodsUid());
        goods.setBrandCode(goodsInfo.getBrandCode());
        goods.setBrandName(goodsInfo.getBrandName());
        goods.setSaleUnit(goodsInfo.getPartsUnit());
        goods.setPartsNum(goodsInfo.getPartsNum());
        goods.setMemberPrice(goodsInfo.getMemberPrice());
        goods.setWholeSalePrice(goodsInfo.getWholeSalePrice());
        goods.setPcs(goodsInfo.getPcs());
        goods.setColdTransFlag(goodsInfo.getColdTransFlag());
        goods.setProcessFlag(goodsInfo.getProcessFlag());
        goods.setVenderCode(goodsInfo.getVenderCode());
        goods.setArtCode(goodsInfo.getArtCode());
        goods.setTempCategory(goodsInfo.getCategoryCode());
        goods.setIsExcessSale(goodsInfo.getIsExcessSale());
        goods.setIsWeight(goodsInfo.getIsdetachable() ? "Y" : "N");
        goods.setSkuId(goodsInfo.getSkuId());
        goods.setColourCode(goodsInfo.getColourCode());
        goods.setColourName(goodsInfo.getColourName());
        goods.setSizeCode(goodsInfo.getSizeCode());
        goods.setSizeName(goodsInfo.getSizeName());
        if (goodsInfo.getEscaleFlag() == 0) {
            goods.setEscaleFlag("N");
        } else {
            goods.setEscaleFlag("Y");
        }
        if (dzcm) {
            goods.setEscaleFlag("Y");
        }
        goods.setMinDiscount(goodsInfo.getMinDiscount());
        goods.setMinSalePrice(goodsInfo.getMinSalePrice());
        goods.setPrimeCost(goodsInfo.getPrimeCost());
        goods.setRemark(goodsInfo.getRemark());
        goods.setImageUrl(goodsInfo.getImageUrl());
        goods.setEnFname(goodsInfo.getEnSname());
        goods.setPrcutMode(goodsInfo.getPrcutMode());
        if (null == goods.getPrcutMode() || "".equals(goods.getPrcutMode())) {
            goods.setPrcutMode("0");
        }
        goods.setCouponValue(0.0);
        goods.setPopDiscountValue(0.0);
        goods.setAdjustDiscountValue(0.0);
        goods.setTotalDiscountValue(0.0);
        goods.setRealTotalDiscountValue(0.0);
        goods.setCustomDiscountValue(0.0);
        goods.setPayDiscountValue(0.0);
        goods.setDzcDiscountValue(0.0);
        goods.setTempZkDiscount(0.0);
        goods.setTempZrDiscount(0.0);
        goods.setTempZzkDiscount(0.0);
        goods.setTempZzrDiscount(0.0);
        goods.setNoDisAmountValue(0.0);
        goods.setSsgid("" + goodsInfo.getSsgid());
        if (dzcm) {
            goods.setSaleValue(ManipulatePrecision.getDetailOverFlow(allprice, goods.getPrcutMode()));
            goods.setFlag("1");
            goods.setDzcDiscountValue(dzcmjgzk);
            if (4 == popMode) {
                double salevalue = ManipulatePrecision.getDetailOverFlow(goods.getSalePrice() * goods.getQty(), goods.getPrcutMode());
                goods.setSaleValue(salevalue);
                goods.setSaleAmount(allprice);
                goods.setDzcDiscountValue(ManipulatePrecision.doubleConvert(salevalue - allprice));
                goods.setAdjustDiscountValue(goods.getDzcDiscountValue());
                goods.setTotalDiscountValue(goods.getDzcDiscountValue());
            }
            goods.setEWCCodeAmount(dzcmjg);
            goods.setEWCCodeNum(dzcmsl);
        } else {
            goods.setSaleValue(ManipulatePrecision.getDetailOverFlow(goods.getSalePrice() * goods.getQty(), goods.getPrcutMode()));
        }
        goods.setSaleAmount(ManipulatePrecision.getDetailOverFlow(goods.getSaleValue() - goods.getTotalDiscountValue(), goods.getPrcutMode()));
        goods.setPopDetailsInfo(new ArrayList<PopDetail>());
        goods.setCouponGains(new ArrayList<CouponGain>());
        goods.setCouponUses(new ArrayList<CouponUse>());
        goods.setRecycleFee(goodsInfo.getRecycleFee());
        goods.setControlFlag(goodsInfo.getControlFlag());
        goods.setLicense(goodsInfo.getLicense());
        goods.setGoodsDesc(goodsInfo.getGoodsDesc());
        goods.setStallCode(goodsInfo.getStallCode());
        if (StringUtils.isNotBlank((String)goodsInfo.getSeason()) && !"0".equals(goodsInfo.getSeason())) {
            goods.setSeason(goodsInfo.getSeason());
        }
        goods.setGoodsStatus(goodsInfo.getGoodsStatus());
        goods.setGbmanamode(goodsInfo.getGbmanamode());
        goods.setPrtDuplFlag(goodsInfo.getPrtDuplFlag());
        goods.setOutputTax(goodsInfo.getOutputTax());
        goods.setParentGoodsCode(goodsInfo.getParentGoodsCode());
        goods.setBulkPrice(goodsInfo.getBulkPrice());
        goods.setDiscountFlag(goodsInfo.getDiscountFlag());
        goods.setNoPricing(goodsInfo.getNoPricing());
        goods.setShareDiscount1(goodsInfo.getShareDiscount1());
        goods.setShareDiscount2(goodsInfo.getShareDiscount2());
        goods.setContractCode(goodsInfo.getContractCode());
        goods.setOrgName(goodsInfo.getOrgName());
        goods.setBrandName(goodsInfo.getBrandName());
        goods.setCategoryName(goodsInfo.getCategoryName());
        goods.setArtNo(goodsInfo.getArtNo());
        return goods;
    }

    @Override
    public double getConvertPrice(double jg, int precision) {
        return ManipulatePrecision.doubleConvert(jg, precision, 1);
    }

    @Override
    public boolean checkFindGoodsAllowSale(GoodsInfo sg, double quantity, boolean isdzcm, double dzcmsl, double dzcmjg, boolean isHaveQty) {
        return !(isdzcm ? sg.getEscaleFlag() == 1 && dzcmsl > 0.0 && ManipulatePrecision.doubleCompare(ManipulatePrecision.doubleConvert(dzcmsl / sg.getPartsNum(), 4, 1), quantity, 4) != 0 : sg.getEscaleFlag() == 1 && !isHaveQty);
    }

    @Override
    public CacheModel calcResponsePopSingle(CacheModel cacheModel, CalcsingleOut promotionOut, int flowid) {
        try {
            if (null == promotionOut) {
                return null;
            }
            if (null == promotionOut.getCalcBillid() || null == promotionOut.getBillDetail().getSellDetails()) {
                return null;
            }
            if (null == cacheModel.getOrder().getSeqNo() || "".equals(cacheModel.getOrder().getSeqNo())) {
                cacheModel.getOrder().setSeqNo(promotionOut.getCalcBillid());
            }
            List<SellDetail> listGoods = null;
            if (null != promotionOut.getBillDetail() && null != promotionOut.getBillDetail().getSellDetails()) {
                listGoods = promotionOut.getBillDetail().getSellDetails();
            }
            Goods sg = cacheModel.getGoodsList().get(flowid - 1);
            int qtyRecalcFlag = sg.getQtyrecalc();
            this.goodsTransfer.transferGoods(listGoods.get(0), sg, promotionOut.getCalcResult(), cacheModel.getOrder().getSysPara().getCalcPriceType(), true, false, false);
            if (qtyRecalcFlag != sg.getQtyrecalc()) {
                cacheModel.setErrCode("1111");
            }
            sg.setAdjustDiscountValue(this.getAdjustDiscount(sg));
            sg.setTotalDiscountValue(CountZZK.getNoPrcutZZK(sg));
            sg.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sg.getTotalDiscountValue() - sg.getNoDisAmountValue()));
            sg.setRealSalePrice(ManipulatePrecision.doubleConvert(sg.getSalePrice() - sg.getNoDisAmountValue() / sg.getQty()));
            sg.setSaleAmount(sg.getSaleValue() - sg.getTotalDiscountValue());
            sg.setCalcMode(this.transSingleCalcMode(sg, cacheModel.getOrder().getCalcMarketingMode(), promotionOut.getCalcResult()));
            if (sg.getDisValue() > 0.0) {
                sg = this.calcGoodsBarcodeDiscAfterSingle(sg, sg.getDisMode(), sg.getDisValue(), sg.getDiscType());
            }
            cacheModel.getGoodsList().set(flowid - 1, sg);
            this.calcOrderAmount(cacheModel);
            return cacheModel;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public CacheModel calcResponsePopSingleAll(CacheModel cacheModel, CalcsingleOut promotionOut, boolean needCalcDisc) {
        try {
            if (null == promotionOut) {
                return cacheModel;
            }
            if (null == promotionOut.getCalcBillid() || null == promotionOut.getBillDetail().getSellDetails()) {
                return cacheModel;
            }
            List<SellDetail> listGoods = null;
            if (null != promotionOut.getBillDetail() && null != promotionOut.getBillDetail().getSellDetails()) {
                listGoods = promotionOut.getBillDetail().getSellDetails();
            }
            boolean isRefreshQty = false;
            for (int i = 0; i < cacheModel.getGoodsList().size(); ++i) {
                Goods sg = cacheModel.getGoodsList().get(i).deepClone();
                double beforeNoDisc = sg.getNoDisAmountValue();
                int qtyRecalcFlag = sg.getQtyrecalc();
                double tempZzr = sg.getTempZzrDiscount();
                double tempZzk = sg.getTempZzkDiscount();
                this.goodsTransfer.transferGoods(listGoods.get(i), sg, promotionOut.getCalcResult(), cacheModel.getOrder().getSysPara().getCalcPriceType(), true, false, false);
                if (!isRefreshQty && qtyRecalcFlag != sg.getQtyrecalc() || sg.getQtyrecalc() == 1 && StringUtils.isBlank((String)cacheModel.getOrder().getSeqNo())) {
                    isRefreshQty = true;
                    cacheModel.setErrCode("1111");
                }
                double rate = sg.getTempZkl();
                double zrAmount = sg.getTempZrDiscount();
                double discamount = sg.getDiscAmount();
                double fixDiscount = sg.getFixedDiscountValue();
                log.info("zrAmount:" + discamount + "discamount:" + zrAmount + "fixDiscount:" + fixDiscount);
                sg.setAdjustDiscountValue(this.getAdjustDiscount(sg));
                sg.setTotalDiscountValue(CountZZK.getNoPrcutZZK(sg));
                sg.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sg.getTotalDiscountValue() - sg.getNoDisAmountValue()));
                sg.setRealSalePrice(ManipulatePrecision.doubleConvert(sg.getSalePrice() - sg.getNoDisAmountValue() / sg.getQty()));
                sg.setSaleAmount(sg.getSaleValue() - sg.getTotalDiscountValue());
                sg.setCalcMode(this.transSingleCalcMode(sg, cacheModel.getOrder().getCalcMarketingMode(), promotionOut.getCalcResult()));
                if (sg.getDisValue() > 0.0) {
                    sg = this.calcGoodsBarcodeDiscAfterSingle(sg, sg.getDisMode(), sg.getDisValue(), sg.getDiscType());
                }
                cacheModel.getGoodsList().set(i, sg);
                if (needCalcDisc) {
                    if (rate < 100.0) {
                        cacheModel = this.calcGoodsRebateByRate(cacheModel, sg.getFlowId(), cacheModel.getOrder().getTerminalOperatorAuthzCardNo(), rate);
                    } else if (zrAmount > 0.0) {
                        cacheModel = discamount > 0.0 ? this.calcGoodsRebateByAmount(cacheModel, sg.getFlowId(), cacheModel.getOrder().getTerminalOperatorAuthzCardNo(), discamount, 1) : this.calcGoodsRebateByAmount(cacheModel, sg.getFlowId(), cacheModel.getOrder().getTerminalOperatorAuthzCardNo(), zrAmount);
                    }
                }
                if (!"2".equals(cacheModel.getOrder().getSysPara().getOrderDiscSeq())) continue;
                if (tempZzk > 0.0) {
                    cacheModel.getGoodsList().get(i).setTempZzkDiscount(tempZzk);
                }
                if (!(tempZzr > 0.0)) continue;
                cacheModel.getGoodsList().get(i).setTempZzrDiscount(tempZzr);
            }
            cacheModel.getOrder().setSeqNo(promotionOut.getCalcBillid());
            this.calcOrderAmount(cacheModel);
            return cacheModel;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public CacheModel calcResponsePopOrder(CacheModel cacheModel, CalcOut promotionOut, String calcMode, boolean isCalcGifts, ServiceSession session) {
        try {
            double totalJf = 0.0;
            if (null == promotionOut) {
                cacheModel.setCalcResult(-1);
                return cacheModel;
            }
            cacheModel.getNeedCopType().clear();
            int iRet = Convert.toInt(promotionOut.getCalcResult());
            if (isCalcGifts) {
                int i;
                if (null != cacheModel.getPayments() && cacheModel.getPayments().size() > 0) {
                    for (i = 0; i < cacheModel.getPayments().size(); ++i) {
                        if (!cacheModel.getPayments().get(i).getPayName().equals("\u652f\u4ed8\u6298\u6263")) continue;
                        cacheModel.getPayments().remove(i);
                        --i;
                    }
                }
                if (("0".equals(calcMode) || "2".equals(calcMode) || "3".equals(calcMode)) && null != promotionOut.getBillDetail() && null != promotionOut.getBillDetail().getSellPayments()) {
                    for (i = 0; i < promotionOut.getBillDetail().getSellPayments().size(); ++i) {
                        SellPayment p = promotionOut.getBillDetail().getSellPayments().get(i);
                        if (null == p) continue;
                        boolean exist = false;
                        for (Payment pay : cacheModel.getPayments()) {
                            if (!p.getRowNoId().equals(pay.getRownoId())) continue;
                            exist = true;
                            break;
                        }
                        if (exist) continue;
                        cacheModel.getPopPayments().add((SellPayment)p.clone());
                        Payment pay = new Payment();
                        pay = this.paymentTransfer.SellPaymentToPayment(p, pay);
                        String obj = this.redisUtil.get("business:initialize:cacheid:" + cacheModel.getOrder().getShopCode() + cacheModel.getOrder().getTerminalNo());
                        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj.toString(), ModeDetailsVo.class);
                        List<Syspara> sysparaOut = modeDetailsVo.getSyspara();
                        String paraValue = "";
                        String payCode = "0666";
                        paraValue = ModeDetailsVo.getSysParaValue(sysparaOut, "KHTH");
                        payCode = ModeDetailsVo.getSysParaValue(sysparaOut, "Q3");
                        if (StringUtils.isBlank((String)payCode)) {
                            payCode = "0666";
                        }
                        String thMode = "Y";
                        if (StringUtils.isNotBlank((String)paraValue)) {
                            thMode = paraValue;
                        }
                        PaymentMode model = null;
                        if (obj != null) {
                            JSONObject jsonObject = JSONObject.parseObject((String)obj);
                            model = PayModeUtils.getPayMode(p.getPaycode(), jsonObject);
                        }
                        log.info("model:{},thMode:{},payCode:{},ppaycode", new Object[]{model, thMode, payCode, p.getPaycode()});
                        if (null != model) {
                            pay.setPayName(model.getName());
                        } else if ("Y".equals(thMode) && payCode.equals(p.getPaycode())) {
                            pay.setPayMemo("YKH");
                            pay.setPayType("FQKH");
                        } else {
                            cacheModel.setCalcResult(-1);
                            cacheModel.setErrCode("50003");
                            cacheModel.setErrMsg("\u79ef\u5206\u6362\u8d2d\u652f\u4ed8\u65b9\u5f0f\u914d\u7f6e\u9519\u8bef");
                            return cacheModel;
                        }
                        if ("JFXF".equals(pay.getCouponType())) {
                            pay.setPayMemo("YJFHG");
                            pay.setIsCoupon("Y");
                        }
                        pay.setPuid(pay.getRownoId());
                        pay.setIsDirectDel(false);
                        pay.setIsAutoDelOnly(true);
                        pay.setRowno(cacheModel.getPayments().size() + 1);
                        cacheModel.getPayments().add(pay);
                    }
                }
            }
            if (null == cacheModel.getGiftsGroup()) {
                cacheModel.setGiftsGroup(new ArrayList<GiftsGroup>());
            }
            List<GiftsGroup> giftGroupList = cacheModel.getGiftsGroup();
            boolean isNeedOutGiftsInfo = true;
            if (StringUtils.isNotBlank((String)cacheModel.getOrder().getOutSideGiftsInfo())) {
                isNeedOutGiftsInfo = false;
            }
            if (null != promotionOut.getGifts() && promotionOut.getGifts().size() > 0) {
                giftGroupList = new ArrayList<GiftsGroup>();
                for (int i = 0; i < promotionOut.getGifts().size(); ++i) {
                    Gift gift = null;
                    gift = this.giftTransfer.transferGift(promotionOut.getGifts().get(i));
                    if (null == gift) continue;
                    if (null == gift.getExtjjg() || !gift.getExtjjg().equals("Y") && !gift.getExtjjg().equals("M")) {
                        if (giftGroupList.size() == 0) {
                            GiftsGroup giftGroup = new GiftsGroup();
                            giftGroup.setGiftGroup(new ArrayList<Gift>());
                            giftGroup.getGiftGroup().add(gift);
                            giftGroup.setGroupId(1);
                            giftGroupList.add(giftGroup);
                            continue;
                        }
                        boolean isOld = false;
                        for (int j = 0; j < giftGroupList.size(); ++j) {
                            Gift existGift = giftGroupList.get(j).getGiftGroup().get(0);
                            if (!(existGift.getGroup() + existGift.getGroupSelect()).equals(gift.getGroup() + gift.getGroupSelect())) continue;
                            giftGroupList.get(j).getGiftGroup().add(gift);
                            isOld = true;
                            break;
                        }
                        if (isOld) continue;
                        GiftsGroup giftGroup = new GiftsGroup();
                        giftGroup.setGiftGroup(new ArrayList<Gift>());
                        giftGroup.getGiftGroup().add(gift);
                        giftGroup.setGroupId(giftGroupList.size() + 1);
                        giftGroupList.add(giftGroup);
                        continue;
                    }
                    if (!gift.getExtjjg().equals("Y") || !isNeedOutGiftsInfo) continue;
                    Object outSideGiftsInfo = "";
                    if (null != cacheModel.getOrder().getOutSideGiftsInfo()) {
                        outSideGiftsInfo = cacheModel.getOrder().getOutSideGiftsInfo();
                    }
                    if (gift.getMode().equals("0")) {
                        double qty;
                        double d = qty = gift.getLimitQty() > gift.getMaxQty() ? gift.getMaxQty() : gift.getLimitQty();
                        outSideGiftsInfo = ((String)outSideGiftsInfo).length() == 0 ? "\u672c\u7b14\u6709\u573a\u5916\u6ee1\u8d60," + gift.getName() + ",\u6570\u91cf" + qty : (String)outSideGiftsInfo + "|\u672c\u7b14\u6709\u573a\u5916\u6ee1\u8d60," + gift.getName() + ",\u6570\u91cf" + qty;
                    } else if (gift.getMode().equals("1")) {
                        outSideGiftsInfo = ((String)outSideGiftsInfo).length() == 0 ? "\u672c\u7b14\u6709\u573a\u5916\u6362\u8d2d,\u89c4\u5219:" + gift.getName() : (String)outSideGiftsInfo + "|\u672c\u7b14\u6709\u573a\u5916\u6362\u8d2d,\u89c4\u5219:" + gift.getName();
                    }
                    cacheModel.getOrder().setOutSideGiftsInfo((String)outSideGiftsInfo);
                }
                cacheModel.setGiftsGroup(giftGroupList);
            }
            boolean isNeedExceptPay = false;
            if (null != promotionOut.getExceptPays() && !cacheModel.getOrder().isDepositSale()) {
                String obj = this.redisUtil.get("business:initialize:cacheid:" + cacheModel.getOrder().getShopCode() + cacheModel.getOrder().getTerminalNo());
                for (int i = 0; i < promotionOut.getExceptPays().size(); ++i) {
                    String exceptPayCode;
                    SellExceptPay exceptPay = promotionOut.getExceptPays().get(i);
                    String excepttype = this.getResultType(exceptPay);
                    PaymentMode model = null;
                    if (YPopStatusType.order_pay_except.equals(excepttype)) {
                        exceptPayCode = exceptPay.getPayCode();
                        if (obj != null) {
                            JSONObject jsonObject = JSONObject.parseObject((String)obj);
                            model = PayModeUtils.getPayMode(exceptPayCode, jsonObject);
                        }
                        if (null == model) continue;
                        cacheModel.getLimitedPayDetails().add(this.paymentTransfer.transferExceptPay(promotionOut.getExceptPays().get(i)));
                        boolean flag = true;
                        for (String paycode : cacheModel.getLimitedPayCodes()) {
                            if (!paycode.equals(exceptPayCode)) continue;
                            flag = false;
                            break;
                        }
                        if (!flag || !isCalcGifts) continue;
                        cacheModel.getLimitedPayCodes().add(exceptPay.getPayCode());
                        continue;
                    }
                    if (!YPopStatusType.order_pay_zszk.equals(excepttype)) continue;
                    isNeedExceptPay = true;
                    exceptPayCode = exceptPay.getPayCode();
                    if (obj != null) {
                        JSONObject jsonObject = JSONObject.parseObject((String)obj);
                        model = PayModeUtils.getPayMode(exceptPayCode, jsonObject);
                    }
                    if (null == model) continue;
                    cacheModel.getExceptPayDetails().add(this.paymentTransfer.transferExceptPay(promotionOut.getExceptPays().get(i)));
                }
            }
            if (null != promotionOut.getBillDetail() && -1 == (cacheModel = this.refreshGoodsListAfterOrder(cacheModel, promotionOut.getBillDetail().getSellDetails(), promotionOut.getCalcResult(), calcMode, cacheModel.getOrder().getSysPara().getCalcPriceType(), true, false)).getCalcResult()) {
                return cacheModel;
            }
            boolean isdelete = false;
            if (!(!isCalcGifts || iRet != 0 || null != cacheModel.getGiftsGroup() && cacheModel.getGiftsGroup().size() != 0 || null != cacheModel.getExceptPayDetails() && cacheModel.getExceptPayDetails().size() != 0)) {
                int i;
                for (i = 0; i < cacheModel.getGoodsList().size(); ++i) {
                    Goods sg = cacheModel.getGoodsList().get(i);
                    if (null == sg.getYhmiscanuse() || !sg.getYhmiscanuse().equals("N")) continue;
                    for (int j = 0; j < cacheModel.getPayments().size(); ++j) {
                        Payment sp = cacheModel.getPayments().get(j);
                        if (null == sp.getCouponType() || !sp.getCouponType().equals(sg.getGoodsCode())) continue;
                        cacheModel.getPayments().remove(j);
                    }
                    cacheModel.getGoodsList().remove(i);
                    --i;
                    isdelete = true;
                }
                if (isdelete) {
                    iRet = -999;
                    cacheModel.setCalcResult(iRet);
                    cacheModel.setGoodsList(this.sortGoodsList(cacheModel.getGoodsList()));
                    this.calcOrderAmount(cacheModel);
                    return cacheModel;
                }
                if (!(null == cacheModel.getTempSalePayments() || cacheModel.getTempSalePayments().size() <= 0 || calcMode.equals("5") || "6".equals(calcMode) || "7".equals(calcMode))) {
                    for (i = 0; i < cacheModel.getTempSalePayments().size(); ++i) {
                        Payment sp = cacheModel.getTempSalePayments().get(i);
                        if (null != sp.getPayName() && (sp.getPayName().startsWith("\u5370\u82b1\u5238") || sp.getPayName().startsWith("\u652f\u4ed8\u6298\u6263") || this.isLimitedPayCode(sp.getPayCode(), cacheModel.getLimitedPayCodes()))) continue;
                        if ("2".equalsIgnoreCase(sp.getPopFlag())) {
                            sp.setPuid(String.valueOf(UniqueID.getUniqueID()));
                            sp.setTerminalSno(cacheModel.getOrder().getTerminalSno());
                            sp.setTerminalNo(cacheModel.getOrder().getTerminalNo());
                            sp.setIsAutoDelOnly(true);
                            sp.setFlag("1");
                            sp.setRowno(cacheModel.getPayments().size() + 1);
                            cacheModel.getPayments().add(sp);
                            continue;
                        }
                        if (!"0".equalsIgnoreCase(sp.getPopFlag())) continue;
                        sp.setPuid(String.valueOf(UniqueID.getUniqueID()));
                        sp.setRownoId(sp.getPuid());
                        sp.setTerminalSno(cacheModel.getOrder().getTerminalSno());
                        sp.setTerminalNo(cacheModel.getOrder().getTerminalNo());
                        sp.setIsAutoDelOnly(true);
                        sp.setFlag("1");
                        sp.setRowno(cacheModel.getPayments().size() + 1);
                        cacheModel.getPayments().add(sp);
                    }
                }
            }
            cacheModel.setCalcResult(iRet);
            this.calcOrderAmount(cacheModel);
            this.calcPayBalance(cacheModel);
            if (isNeedExceptPay && promotionOut.getBillDetail().getFactPay() > 0.0) {
                cacheModel.getOrder().setOughtPay(ManipulatePrecision.mul(cacheModel.getOrder().getOughtPay(), promotionOut.getBillDetail().getFactPay()));
                cacheModel.getOrder().setRemainValue(ManipulatePrecision.mul(cacheModel.getOrder().getRemainValue(), promotionOut.getBillDetail().getFactPay()));
            }
            this.getNewRateAmtForOrder(cacheModel.getOrder());
            return cacheModel;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            cacheModel.setCalcResult(-1);
            return cacheModel;
        }
    }

    @Override
    public CacheModel calcOrderAfterCheckReturnMode0(CacheModel cacheModel, CalSaleReturnOut promotionOut, String noYpopCodes, ServiceSession session) {
        if (null == promotionOut) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrMsg("\u9000\u8d27\u6263\u56de\u65e0\u6570\u636e");
            return cacheModel;
        }
        if (null == promotionOut.getBillDetail() || null == promotionOut.getBillDetail().getSellDetails()) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrMsg("\u9000\u8d27\u6263\u56de\u65e0\u8ba2\u5355\u6570\u636e");
            return cacheModel;
        }
        if (StringUtils.isNotBlank((String)promotionOut.getBillDetail().getConsumersId())) {
            if (null == cacheModel.getOrder().getConsumersData()) {
                cacheModel.getOrder().setConsumersData(new ConsumersData());
            }
            cacheModel.getOrder().getConsumersData().setConsumersCard(promotionOut.getBillDetail().getConsumersCardNo());
            cacheModel.getOrder().getConsumersData().setConsumersId(promotionOut.getBillDetail().getConsumersId());
            cacheModel.getOrder().getConsumersData().setConsumersType(promotionOut.getBillDetail().getConsumersType());
        }
        cacheModel.clearOrderlist();
        cacheModel.setRemainRefundAmount(0.0);
        int inNum = cacheModel.getGoodsList().size();
        int outNum = promotionOut.getBillDetail().getSellDetails().size();
        String obj = this.redisUtil.get("business:initialize:cacheid:" + cacheModel.getOrder().getShopCode() + cacheModel.getOrder().getTerminalNo());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj.toString(), ModeDetailsVo.class);
        if (!"2".equals(cacheModel.getOrder().getOrderType())) {
            Goods sg;
            SellDetail g;
            int i;
            for (i = 0; i < inNum; ++i) {
                g = promotionOut.getBillDetail().getSellDetails().get(i);
                sg = cacheModel.getGoodsList().get(i);
                sg = this.goodsTransfer.transferGoods(g, sg, "0", cacheModel.getOrder().getSysPara().getCalcPriceType(), true, true, true);
                sg.setAdjustDiscountValue(this.getAdjustDiscount(sg));
                sg.setTotalDiscountValue(CountZZK.getNoPrcutZZK(sg));
                sg.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sg.getTotalDiscountValue() - sg.getNoDisAmountValue()));
                sg.setRealSalePrice(ManipulatePrecision.doubleConvert(sg.getSalePrice() - sg.getNoDisAmountValue() / sg.getQty()));
                cacheModel.getGoodsList().set(i, sg);
            }
            this.calcOrderAmount(cacheModel);
            if (outNum > inNum) {
                for (i = inNum; i < outNum; ++i) {
                    g = promotionOut.getBillDetail().getSellDetails().get(i);
                    sg = this.goodsTransfer.BillDetailToRefundGiftGoods(g, cacheModel.getOrder().getPrecisionMode());
                    sg.setTotalDiscountValue(CountZZK.getZZK(sg));
                    sg.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sg.getTotalDiscountValue() - sg.getNoDisAmountValue()));
                    sg.setSaleAmount(sg.getSaleValue() - sg.getTotalDiscountValue());
                    cacheModel.getRefundGiftList().add(sg);
                }
            }
            if (cacheModel.getPayments().size() > 0) {
                if (cacheModel.getOrder().isDepositSale() && !cacheModel.getOrder().isTailMoneyPay()) {
                    String wkPayCode = "";
                    List<Syspara> sysparaOut = modeDetailsVo.getSyspara();
                    String paraValue = "";
                    paraValue = ModeDetailsVo.getSysParaValue(sysparaOut, "WKFS");
                    if (StringUtils.isNotBlank((String)paraValue)) {
                        wkPayCode = paraValue.trim();
                        for (int i2 = 0; i2 < cacheModel.getPayments().size(); ++i2) {
                            Payment p = cacheModel.getPayments().get(i2);
                            if (p.getPayCode().equals(wkPayCode)) continue;
                            cacheModel.getPayments().remove(i2);
                            --i2;
                        }
                    }
                } else {
                    cacheModel.getPayments().clear();
                }
            }
            if (cacheModel.getTempSalePayments().size() > 0) {
                cacheModel.getTempSalePayments().clear();
            }
            if (cacheModel.getPopPayments().size() > 0) {
                cacheModel.getPopPayments().clear();
            }
            if (cacheModel.getDeductedCoupons().size() > 0) {
                cacheModel.getDeductedCoupons().clear();
            }
        }
        double remainRefundAmount = 0.0;
        remainRefundAmount = ManipulatePrecision.doubleConvert(promotionOut.getBillDetail().getDeduct() + promotionOut.getBillDetail().getRefund() + promotionOut.getBillDetail().getCompensate(), 2, 1);
        cacheModel.setRemainRefundAmount(remainRefundAmount);
        RemovePayIn removePayIn = new RemovePayIn();
        ArrayList<String> rowNoIdList = new ArrayList<String>();
        if ("2".equals(cacheModel.getOrder().getOrderType()) && promotionOut.getBillDetail().getCouponReverse().size() > 0) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrMsg("\u5b58\u5728\u6263\u56de\u4e0d\u5141\u8bb8\u7ea2\u51b2");
            return cacheModel;
        }
        for (int i = 0; i < promotionOut.getBillDetail().getCouponReverse().size(); ++i) {
            SellCouponReverse couponReverse = (SellCouponReverse)promotionOut.getBillDetail().getCouponReverse().get(i).clone();
            couponReverse.setIsReverse(false);
            couponReverse.setRemainAmount(couponReverse.getAmount());
            couponReverse.setQty(1);
            boolean isAdd = true;
            for (SellCouponReverse couponReverseTemp : cacheModel.getDeductedCoupons()) {
                if (!couponReverseTemp.getCouponType().equals(couponReverse.getCouponType()) || !couponReverseTemp.getCouponGroup().equals(couponReverse.getCouponGroup())) continue;
                couponReverseTemp.setQty(couponReverseTemp.getQty() + 1);
                couponReverseTemp.setMoney(ManipulatePrecision.add(couponReverseTemp.getMoney(), couponReverse.getMoney()));
                couponReverseTemp.setRemainAmount(ManipulatePrecision.add(couponReverseTemp.getRemainAmount(), couponReverse.getAmount()));
                isAdd = false;
            }
            if (!isAdd) continue;
            cacheModel.getDeductedCoupons().add(couponReverse);
        }
        if (!(null != promotionOut.getBillDetail().getSellPayments() && promotionOut.getBillDetail().getSellPayments().size() > 0 || null != cacheModel.getRefundGiftList() && cacheModel.getRefundGiftList().size() > 0 || null != cacheModel.getDeductedCoupons() && cacheModel.getDeductedCoupons().size() > 0)) {
            cacheModel.setCalcResult(0);
            return cacheModel;
        }
        PaymentMode model = null;
        double khAmount = 0.0;
        for (int i = 0; i < promotionOut.getBillDetail().getSellPayments().size(); ++i) {
            Payment p;
            SellPayment sellPayment = promotionOut.getBillDetail().getSellPayments().get(i);
            if (!"1".equals(sellPayment.getFlag()) && !"2".equals(sellPayment.getFlag()) && !"4".equals(sellPayment.getFlag())) continue;
            khAmount = ManipulatePrecision.sub(ManipulatePrecision.add(khAmount, sellPayment.getMoney()), sellPayment.getOverage());
            SellPayment pays = (SellPayment)sellPayment.clone();
            cacheModel.getPopPayments().add(pays);
            Payment porg = this.paymentTransfer.transferPayment(pays);
            if (porg.getPayName().contains("(")) {
                porg.setPayName(porg.getPayName().substring(0, porg.getPayName().indexOf("(")));
            }
            if (StringUtils.isNotBlank((String)porg.getCouponType())) {
                if (obj != null) {
                    JSONObject jsonObject = JSONObject.parseObject((String)obj);
                    model = PayModeUtils.getPayMode(porg.getPayCode(), jsonObject);
                }
                if (null != model) {
                    porg.setPayType(model.getPaytype());
                    porg.setPayName(model.getName());
                }
            }
            if (ManipulatePrecision.doubleCompare(khAmount, cacheModel.getOrder().getRemainValue(), 2) > 0) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrMsg("\u6263\u56de\u8d85\u51fa\u9000\u8d27\u91d1\u989d\u4e0d\u5141\u8bb8\u9000\u8d27");
                return cacheModel;
            }
            if ((StringUtils.isBlank((String)porg.getPayNo()) || "0".equals(porg.getPayNo())) && StringUtils.isNotBlank((String)porg.getConsumersId()) && !"DK".equals(pays.getPayType())) {
                porg.setPayNo(porg.getConsumersId());
            }
            if (porg.getPayCode().equals("0706")) {
                cacheModel.getTempSalePayments().add(porg);
            }
            if (null == (p = (Payment)porg.clone()).getPayNo()) {
                p.setPayNo("");
            }
            p.setFlag("1");
            p.setPaymentSource("NY");
            p.setRowno(cacheModel.getPayments().size() + 1);
            p.setIsAutoDelOnly(true);
            p.setIsDirectDel(false);
            p.setPayType(porg.getPayType());
            if ("JFXF".equals(porg.getCouponType())) {
                if ("DK".equals(pays.getPayType())) {
                    p.setPayMemo("YJFHG");
                } else {
                    p.setPayMemo("YJFXF");
                }
            }
            if (p.getPayCode().equals("0706")) {
                removePayIn.setCalcBillid(promotionOut.getCalcBilid());
                removePayIn.setChannelId(cacheModel.getOrder().getChannel());
                rowNoIdList.add(p.getRownoId());
                continue;
            }
            cacheModel.getPayments().add(p);
        }
        this.calcOrderAmount(cacheModel);
        return cacheModel;
    }

    @Override
    public CacheModel calcOrderAfterCheckReturnMode2(CacheModel cacheModel, String autoBackPayCode, String thMode) {
        this.calcOrderAmount(cacheModel);
        return cacheModel;
    }

    @Override
    public CacheModel calcOrderAfterCheckReturnMode1(CacheModel cacheModel, List<Gift> choiceGifts, String autoBackPayCode, String giftMode, String thMode) {
        int i;
        if (null == giftMode || giftMode.length() == 0) {
            giftMode = "0";
        }
        if (null != choiceGifts && choiceGifts.size() > 0) {
            block0: for (int i2 = 0; i2 < choiceGifts.size(); ++i2) {
                String guid = choiceGifts.get(i2).getGuid();
                double qty = choiceGifts.get(i2).getQty();
                for (int j = 0; j < cacheModel.getRefundGiftList().size(); ++j) {
                    Goods oldsg = cacheModel.getRefundGiftList().get(j);
                    if (!guid.equals(oldsg.getGuid())) continue;
                    if (!(qty > oldsg.getQty())) continue block0;
                    cacheModel.setCalcResult(-1);
                    cacheModel.setErrMsg("\u8d60\u54c1\u9009\u62e9\u6570\u91cf\u5927\u4e8e\u539f\u5355\u6570\u91cf\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
                    return cacheModel;
                }
            }
        }
        double zpkhAmount = 0.0;
        boolean isAllRefund = true;
        if (null != cacheModel.getRefundGiftList() && cacheModel.getRefundGiftList().size() > 0) {
            for (i = 0; i < cacheModel.getRefundGiftList().size(); ++i) {
                boolean isHaveChoice = false;
                if (null != choiceGifts && choiceGifts.size() > 0) {
                    for (int j = 0; j < choiceGifts.size(); ++j) {
                        String guid = choiceGifts.get(j).getGuid();
                        double qty = choiceGifts.get(j).getQty();
                        Goods oldsg = cacheModel.getRefundGiftList().get(i);
                        log.info("\u539f\u5546\u54c1==>{}", (Object)JSONObject.toJSONString((Object)oldsg));
                        if (!guid.equals(oldsg.getGuid())) continue;
                        if (qty < oldsg.getQty()) {
                            if (isAllRefund) {
                                isAllRefund = false;
                            }
                            if (null != oldsg.getPopDetails() && oldsg.getPopDetails().size() > 0) {
                                oldsg.setPopDetails(new ArrayList<PopDetail>());
                            }
                            newsg = (Goods)oldsg.clone();
                            double oldqty = oldsg.getQty();
                            newsg.setQty(ManipulatePrecision.sub(oldsg.getQty(), qty));
                            newsg.setIsNoBackGift(true);
                            oldsg.setQty(qty);
                            log.info("\u539f\u6570\u91cf==>{},\u9009\u62e9\u6570\u91cf==>{},\u6700\u65b0\u6570\u91cf==>{}", new Object[]{oldqty, qty, newsg.getQty()});
                            oldsg.setSaleValue(ManipulatePrecision.doubleConvert(ManipulatePrecision.mul(ManipulatePrecision.div(oldsg.getSaleValue(), oldqty), qty), 2, 1));
                            oldsg.setCustomDiscountValue(ManipulatePrecision.doubleConvert(ManipulatePrecision.mul(ManipulatePrecision.div(oldsg.getCustomDiscountValue(), oldqty), qty), 2, 1));
                            oldsg.setMealDiscountValue(ManipulatePrecision.doubleConvert(ManipulatePrecision.mul(ManipulatePrecision.div(oldsg.getMealDiscountValue(), oldqty), qty), 2, 1));
                            oldsg.setAdjustDiscountValue(ManipulatePrecision.doubleConvert(ManipulatePrecision.mul(ManipulatePrecision.div(oldsg.getAdjustDiscountValue(), oldqty), qty), 2, 1));
                            oldsg.setCouponValue(ManipulatePrecision.doubleConvert(ManipulatePrecision.mul(ManipulatePrecision.div(oldsg.getCouponValue(), oldqty), qty), 2, 1));
                            oldsg.setPayDiscountValue(ManipulatePrecision.doubleConvert(ManipulatePrecision.mul(ManipulatePrecision.div(oldsg.getPayDiscountValue(), oldqty), qty), 2, 1));
                            oldsg.setPopDiscountValue(ManipulatePrecision.doubleConvert(ManipulatePrecision.mul(ManipulatePrecision.div(oldsg.getPopDiscountValue(), oldqty), qty), 2, 1));
                            oldsg.setTotalDiscountValue(ManipulatePrecision.doubleConvert(ManipulatePrecision.mul(ManipulatePrecision.div(CountZZK.getZZK(oldsg), oldqty), qty), 2, 1));
                            oldsg.setSaleAmount(oldsg.getSaleValue() - oldsg.getTotalDiscountValue());
                            newsg.setSaleValue(ManipulatePrecision.doubleConvert(ManipulatePrecision.mul(ManipulatePrecision.div(newsg.getSaleValue(), oldqty), newsg.getQty()), 2, 1));
                            newsg.setCustomDiscountValue(ManipulatePrecision.doubleConvert(ManipulatePrecision.mul(ManipulatePrecision.div(newsg.getCustomDiscountValue(), oldqty), newsg.getQty()), 2, 1));
                            newsg.setMealDiscountValue(ManipulatePrecision.doubleConvert(ManipulatePrecision.mul(ManipulatePrecision.div(newsg.getMealDiscountValue(), oldqty), newsg.getQty()), 2, 1));
                            newsg.setAdjustDiscountValue(ManipulatePrecision.doubleConvert(ManipulatePrecision.mul(ManipulatePrecision.div(newsg.getAdjustDiscountValue(), oldqty), newsg.getQty()), 2, 1));
                            newsg.setCouponValue(ManipulatePrecision.doubleConvert(ManipulatePrecision.mul(ManipulatePrecision.div(newsg.getCouponValue(), oldqty), newsg.getQty()), 2, 1));
                            newsg.setPayDiscountValue(ManipulatePrecision.doubleConvert(ManipulatePrecision.mul(ManipulatePrecision.div(newsg.getPayDiscountValue(), oldqty), newsg.getQty()), 2, 1));
                            newsg.setPopDiscountValue(ManipulatePrecision.doubleConvert(ManipulatePrecision.mul(ManipulatePrecision.div(newsg.getPopDiscountValue(), oldqty), qty), 2, 1));
                            double zzk = CountZZK.getZZK(newsg);
                            log.info("newsg \u603b\u6298\u6263==>{},getPopDiscountValue==>{}", (Object)zzk, (Object)newsg.getPopDiscountValue());
                            newsg.setTotalDiscountValue(zzk);
                            log.info("\u90e8\u5206\u9000\u8d27\u8d60\u54c1\u603b\u6298\u6263==>{}", (Object)newsg.getTotalDiscountValue());
                            newsg.setSaleAmount(ManipulatePrecision.doubleConvert(newsg.getSaleValue() - newsg.getTotalDiscountValue()));
                            log.info("oldgs==>{}", (Object)JSONObject.toJSONString((Object)oldsg));
                            log.info("newsg==>{}", (Object)JSONObject.toJSONString((Object)newsg));
                            if ("0".equals(giftMode)) {
                                zpkhAmount = ManipulatePrecision.add(zpkhAmount, newsg.getSaleValue());
                            }
                            oldsg.setFlowId(cacheModel.getGoodsList().size() + 1);
                            oldsg.setGuid(UUIDUtils.buildGuid());
                            cacheModel.getGoodsList().add(oldsg);
                            newsg.setFlowId(cacheModel.getGoodsList().size() + 1);
                            newsg.setGuid(UUIDUtils.buildGuid());
                            cacheModel.getGoodsList().add(newsg);
                        } else {
                            newsg = (Goods)oldsg.clone();
                            if (null != oldsg.getPopDetails() && oldsg.getPopDetails().size() > 0) {
                                newsg.setPopDetails(new ArrayList<PopDetail>());
                                for (PopDetail p : oldsg.getPopDetails()) {
                                    newsg.getPopDetails().add((PopDetail)p.clone());
                                }
                            }
                            newsg.setFlowId(cacheModel.getGoodsList().size() + 1);
                            cacheModel.getGoodsList().add(newsg);
                        }
                        isHaveChoice = true;
                        break;
                    }
                } else {
                    isAllRefund = false;
                }
                if (isHaveChoice) continue;
                Goods newsg = cacheModel.getRefundGiftList().get(i).deepClone();
                if (null != newsg.getPopDetails()) {
                    newsg.setPopDetails(new ArrayList<PopDetail>());
                }
                if ("0".equals(giftMode)) {
                    log.info("\u672a\u9000\u8d60\u54c1saleAmount\uff1a" + newsg.getSaleAmount());
                    zpkhAmount = ManipulatePrecision.add(zpkhAmount, newsg.getSaleValue());
                }
                newsg.setIsNoBackGift(true);
                newsg.setFlowId(cacheModel.getGoodsList().size() + 1);
                newsg.setGuid(UUIDUtils.buildGuid());
                cacheModel.getGoodsList().add(newsg);
            }
            cacheModel.getRefundGiftList().clear();
        }
        if (null != cacheModel.getPayments() && cacheModel.getPayments().size() > 0) {
            for (i = 0; i < cacheModel.getPayments().size(); ++i) {
                Payment p = cacheModel.getPayments().get(i);
                if (!"0666".equals(p.getPayCode()) || !"GIFT".equals(p.getPayType())) continue;
                cacheModel.getTempSalePayments().add((Payment)p.clone());
                cacheModel.getPayments().remove(p);
                --i;
            }
        }
        if (zpkhAmount > 0.0) {
            if (thMode.equals("N")) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrMsg("\u672c\u7b14\u8ba2\u5355\u5b58\u5728\u6263\u56de\u4e0d\u5141\u8bb8\u9000\u8d27");
                return cacheModel;
            }
            if (ManipulatePrecision.doubleCompare(zpkhAmount, cacheModel.getOrder().getRemainValue(), 2) > 0) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrMsg("\u8d60\u54c1\u6263\u56de\u8d85\u51fa\u9000\u8d27\u91d1\u989d\u4e0d\u5141\u8bb8\u9000\u8d27");
                return cacheModel;
            }
            Payment sp = new Payment();
            sp.setPayCode(autoBackPayCode);
            sp.setPayName("\u8d60\u54c1\u6263\u56de");
            sp.setAmount(zpkhAmount);
            sp.setMoney(sp.getAmount());
            sp.setRate(1.0);
            sp.setFlag("1");
            sp.setPuid(String.valueOf(UniqueID.getUniqueID()));
            sp.setRownoId(sp.getPuid());
            sp.setIsAutoDelOnly(true);
            sp.setIsAllowCharge("N");
            sp.setIsOverage("N");
            sp.setRowno(cacheModel.getPayments().size() + 1);
            cacheModel.getPayments().add(sp);
            this.calcPayBalance(cacheModel);
        }
        return cacheModel;
    }

    @Override
    public CacheModel calcOrderAfterAffirmReturn(CacheModel cacheModel, ConfirmAffirmreturnOut promotionOut) {
        try {
            int i;
            if (null == promotionOut || null == promotionOut.getBillDetail() || null == promotionOut.getBillDetail().getSellDetails()) {
                cacheModel.setErrMsg("\u8fd4\u56de\u6570\u636e\u4e0d\u5408\u6cd5");
                cacheModel.setCalcResult(-1);
            }
            List<SellDetail> listGoods = null;
            listGoods = promotionOut.getBillDetail().getSellDetails();
            String obj = this.redisUtil.get("business:initialize:cacheid:" + cacheModel.getOrder().getShopCode() + cacheModel.getOrder().getTerminalNo());
            if (null != listGoods) {
                for (i = 0; i < listGoods.size(); ++i) {
                    SellDetail g = listGoods.get(i);
                    Goods sg = cacheModel.getGoodsList().get(i);
                    boolean needYpopzke = false;
                    if (StringUtils.isNotBlank((String)cacheModel.getOrder().getOriginIdSheetNo())) {
                        needYpopzke = true;
                    }
                    sg = this.goodsTransfer.transferGoods(g, sg, "0", cacheModel.getOrder().getSysPara().getCalcPriceType(), needYpopzke, false, true);
                    sg.setCalcMode(this.transSingleCalcMode(sg, cacheModel.getOrder().getCalcMarketingMode(), "0"));
                    sg.setAdjustDiscountValue(this.getAdjustDiscount(sg));
                    sg.setTotalDiscountValue(CountZZK.getNoPrcutZZK(sg));
                    sg.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sg.getTotalDiscountValue() - sg.getNoDisAmountValue()));
                    sg.setRealSalePrice(ManipulatePrecision.doubleConvert(sg.getSalePrice() - sg.getNoDisAmountValue() / sg.getQty()));
                }
            }
            if (null != promotionOut.getBillDetail().getSellPayments()) {
                Payment sp;
                int j;
                SellPayment p;
                for (i = 0; i < cacheModel.getPayments().size(); ++i) {
                    Payment sp2 = cacheModel.getPayments().get(i);
                    if (null == sp2 || null == sp2.getPaymentSource() || sp2.getPaymentSource().length() < 3 || sp2.getPaymentSource().charAt(2) != 'Y' || promotionOut.getBillDetail().getSellPayments().size() < sp2.getPromotionRetrunRowNo() || null != sp2.getRownoId() && !"".equals(sp2.getRownoId())) continue;
                    SellPayment p2 = promotionOut.getBillDetail().getSellPayments().get(sp2.getPromotionRetrunRowNo());
                    if (!sp2.getPayCode().equals(p2.getPaycode()) || sp2.getPromotionRetrunRowNo() != p2.getRowNo()) continue;
                    sp2.setRownoId(p2.getRowNoId());
                    cacheModel.getPayments().set(i, sp2);
                }
                for (i = 0; i < promotionOut.getBillDetail().getSellPayments().size(); ++i) {
                    p = promotionOut.getBillDetail().getSellPayments().get(i);
                    boolean isUsed = false;
                    for (j = 0; j < cacheModel.getPayments().size(); ++j) {
                        sp = cacheModel.getPayments().get(j);
                        if (StringUtils.isNotBlank((String)sp.getRownoId())) {
                            if (!sp.getRownoId().equals(p.getRowNoId())) continue;
                            isUsed = true;
                            break;
                        }
                        if (!sp.getPayCode().equals(p.getPaycode()) || !sp.getPayType().equals(p.getPayType()) || null != sp.getRownoId() && !"".equals(sp.getRownoId()) || !StringUtils.isNotBlank((String)cacheModel.getOrder().getOriginTerminalSno())) continue;
                        sp.setRownoId(p.getRowNoId());
                        isUsed = true;
                        break;
                    }
                    if (!isUsed) continue;
                }
                for (i = 0; i < promotionOut.getBillDetail().getSellPayments().size(); ++i) {
                    p = promotionOut.getBillDetail().getSellPayments().get(i);
                    boolean isUsed = false;
                    for (j = 0; j < cacheModel.getTempSalePayments().size(); ++j) {
                        sp = cacheModel.getTempSalePayments().get(j);
                        if (StringUtils.isNotBlank((String)sp.getRownoId())) {
                            if (!sp.getRownoId().equals(p.getRowNoId())) continue;
                            isUsed = true;
                            break;
                        }
                        if (!sp.getPayCode().equals(p.getPaycode()) || !sp.getPayType().equals(p.getPayType()) || !StringUtils.isNotBlank((String)sp.getRownoId()) || !StringUtils.isNotBlank((String)cacheModel.getOrder().getOriginTerminalSno())) continue;
                        sp.setRownoId(p.getRowNoId());
                        isUsed = true;
                        break;
                    }
                    if (!isUsed) continue;
                }
            }
            return cacheModel;
        }
        catch (Exception e) {
            e.printStackTrace();
            cacheModel.setErrMsg("\u8fd4\u56de\u6570\u636e\u4e0d\u5408\u6cd5");
            cacheModel.setCalcResult(-1);
            return cacheModel;
        }
    }

    @Override
    public CacheModel calcAdjustDiscAfterOrder(CacheModel cacheModel) {
        Object ErrMsg = "";
        double tempZzk = cacheModel.getOrder().getTempZzk();
        double tempZzr = cacheModel.getOrder().getTempZzr();
        if (ManipulatePrecision.doubleCompare(tempZzk, 0.0, 2) > 0 && -1 == (cacheModel = this.calcOrderRebateByRate(cacheModel, cacheModel.getCurGrant().getGh(), tempZzk)).getCalcResult()) {
            ErrMsg = (String)ErrMsg + cacheModel.getErrMsg() + "|";
        }
        if (ManipulatePrecision.doubleCompare(tempZzr, 0.0, 2) > 0) {
            double discountAMount = tempZzr;
            if (discountAMount > cacheModel.getOrder().getOughtPay() - cacheModel.getOrder().getExistPay()) {
                discountAMount = ManipulatePrecision.getDetailOverFlow(cacheModel.getOrder().getOughtPay() - cacheModel.getOrder().getExistPay(), "B");
            }
            if (-1 == (cacheModel = this.calcOrderRebateByAmount(cacheModel, cacheModel.getCurGrant().getGh(), discountAMount)).getCalcResult()) {
                ErrMsg = (String)ErrMsg + cacheModel.getErrMsg() + "|";
            }
        }
        cacheModel.setCalcResult(0);
        cacheModel.setErrMsg((String)ErrMsg);
        return cacheModel;
    }

    @Override
    public CacheModel calcAdjustDiscAfterOrder(CacheModel cacheModel, String couponCode, String memoStr) {
        ArrayList<Integer> matchRows = new ArrayList<Integer>();
        double discountAmount = 0.0;
        double matchAmount = 0.0;
        double maxMatchAmount = 0.0;
        int maxMatchRow = 0;
        String[] couponInfo = memoStr.split(",");
        double purchaseAmount = Double.valueOf(couponInfo[0].split("@")[0]);
        double memberPurchaseAmount = Double.valueOf(couponInfo[0].split("@")[1]);
        String couponType = couponInfo[1];
        double discountValue = Double.valueOf(couponInfo[2].split("@")[0]);
        double memberDiscountValue = Double.valueOf(couponInfo[2].split("@")[1]);
        String popDescribe = couponInfo[3];
        for (int i = 0; i < cacheModel.getGoodsList().size(); ++i) {
            Goods sg = cacheModel.getGoodsList().get(i);
            boolean isHaveCouponPop = false;
            double tempCouponAmount = 0.0;
            if ("98".equals(sg.getGoodsType()) || "99".equals(sg.getGoodsType()) || null == sg.getTempPopDetails() || sg.getTempPopDetails().size() == 0) continue;
            for (int j = 0; j < sg.getTempPopDetails().size(); ++j) {
                PopDetail pop = sg.getTempPopDetails().get(j);
                if (!YPopStatusType.pop_policy_group_aeoncoupon.equals(pop.getPopPolicyGroup()) || !couponCode.equals(pop.getPopMemo())) continue;
                tempCouponAmount = ManipulatePrecision.getDetailOverFlow(tempCouponAmount + pop.getDiscountAmount(), "0");
                isHaveCouponPop = true;
                sg.getTempPopDetails().remove(j);
                --j;
                break;
            }
            if (!isHaveCouponPop) continue;
            matchRows.add(i);
            matchAmount = ManipulatePrecision.getDetailOverFlow(matchAmount + sg.getSaleAmount(), "0");
            if (!(sg.getSaleAmount() > maxMatchAmount)) continue;
            maxMatchAmount = sg.getSaleAmount();
            maxMatchRow = i;
        }
        log.info("\u7528\u5238\u95e8\u574e\u3010{}\u3011,\u5339\u914d\u91d1\u989d\u3010{}\u3011", (Object)memberPurchaseAmount, (Object)matchAmount);
        boolean isHaveCust = false;
        isHaveCust = null != cacheModel.getOrder().getConsumersData() && !StringUtils.isNotBlank((String)cacheModel.getOrder().getConsumersData().getConsumersType());
        if (isHaveCust) {
            if (matchAmount < memberPurchaseAmount) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrMsg("\u8d2d\u4e70\u5546\u54c1\u672a\u8fbe\u5230\u5238" + couponCode + "\u4f18\u60e0\u6761\u4ef6,\u8fd8\u5dee" + ManipulatePrecision.getDetailOverFlow(memberPurchaseAmount - matchAmount, "0") + "\u5143");
                return cacheModel;
            }
        } else if (matchAmount < purchaseAmount) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrMsg("\u8d2d\u4e70\u5546\u54c1\u672a\u8fbe\u5230\u5238" + couponCode + "\u4f18\u60e0\u6761\u4ef6,\u8fd8\u5dee" + ManipulatePrecision.getDetailOverFlow(purchaseAmount - matchAmount, "0") + "\u5143");
            return cacheModel;
        }
        if ("A".equals(couponType)) {
            discountAmount = isHaveCust ? memberDiscountValue : discountValue;
            if (discountAmount > matchAmount) {
                discountAmount = matchAmount;
            }
        } else {
            if (isHaveCust) {
                discountValue = memberDiscountValue;
            }
            discountAmount = ManipulatePrecision.getDetailOverFlow(matchAmount * discountValue / 100.0, "B");
        }
        if (discountAmount <= 0.0) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrMsg("\u5238" + couponCode + "\u4f18\u60e0\u91d1\u989d\u4e3a0");
            return cacheModel;
        }
        if (discountAmount > cacheModel.getOrder().getOughtPay() - cacheModel.getOrder().getExistPay()) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrMsg("\u5238" + couponCode + "\u65e0\u6cd5\u4f7f\u7528");
            return cacheModel;
        }
        double lastDiscountAmount = discountAmount;
        Iterator tempCouponAmount = matchRows.iterator();
        while (tempCouponAmount.hasNext()) {
            int matchRow = (Integer)tempCouponAmount.next();
            if (matchRow == maxMatchRow) continue;
            int i = matchRow;
            Goods g = cacheModel.getGoodsList().get(i);
            double yhAmount = ManipulatePrecision.getDetailOverFlow(discountAmount * g.getSaleAmount() / matchAmount, "B");
            g.setPopDiscountValue(ManipulatePrecision.getDetailOverFlow(g.getPopDiscountValue() + yhAmount, "B"));
            lastDiscountAmount -= yhAmount;
            g.setTotalDiscountValue(CountZZK.getZZK(g));
            g.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(g.getTotalDiscountValue() - g.getNoDisAmountValue()));
            g.setSaleAmount(g.getSaleValue() - g.getTotalDiscountValue());
            PopDetail pop = new PopDetail();
            pop.setPopPolicyGroup(YPopStatusType.pop_policy_group_aeoncoupon);
            pop.setPopDescribe(popDescribe);
            pop.setPopMemo(couponCode);
            pop.setDiscountAmount(yhAmount);
            pop.setPopMode("0");
            g.getPopDetailsInfo().add(pop);
        }
        if (lastDiscountAmount > 0.0) {
            Goods g = cacheModel.getGoodsList().get(maxMatchRow);
            lastDiscountAmount = ManipulatePrecision.doubleConvert(lastDiscountAmount, 2, 1);
            g.setPopDiscountValue(ManipulatePrecision.doubleConvert(g.getPopDiscountValue() + lastDiscountAmount, 2, 1));
            g.setTotalDiscountValue(CountZZK.getZZK(g));
            g.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(g.getTotalDiscountValue() - g.getNoDisAmountValue()));
            g.setSaleAmount(g.getSaleValue() - g.getTotalDiscountValue());
            PopDetail pop = new PopDetail();
            pop.setPopPolicyGroup(YPopStatusType.pop_policy_group_aeoncoupon);
            pop.setPopDescribe(popDescribe);
            pop.setPopMemo(couponCode);
            pop.setDiscountAmount(lastDiscountAmount);
            pop.setPopMode("0");
            g.getPopDetailsInfo().add(pop);
        }
        this.calcOrderAmount(cacheModel);
        return cacheModel;
    }

    @Override
    public String transSingleCalcMode(Goods good, String calcModeIn, String calcModeOut) {
        block5: {
            try {
                if (null != good) {
                    if (ManipulateStr.readIndexChar(calcModeIn, 0) == '1' && ManipulateStr.readIndexChar(calcModeOut, 0) == '0') {
                        return "1";
                    }
                    if (!"0".equals(good.getCalcMode()) && !"1".equals(good.getCalcMode())) {
                        return "0";
                    }
                    break block5;
                }
                return "0";
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return "0";
    }

    @Override
    public CacheModel CalcOrderAfterCheckReturnMode0(CacheModel cacheModel, CalSaleReturnOut calSaleReturnOut, String notYpopPayCodes, ServiceSession session) {
        return null;
    }

    @Override
    public String getSingleCalcMode(CacheModel cacheModel, int goodsIndex, String cmdtype) {
        String calcMode = "0";
        if (YPopStatusType.cmdtype_calcsinglepop.equalsIgnoreCase(cmdtype)) {
            if (null == cacheModel || null == cacheModel.getGoodsList() || cacheModel.getGoodsList().size() <= 0) {
                return "0";
            }
            if (goodsIndex >= 0) {
                return String.valueOf(cacheModel.getGoodsList().get(goodsIndex - 1).getCalcMode());
            }
            for (int i = 0; i < cacheModel.getGoodsList().size(); ++i) {
                Goods g = cacheModel.getGoodsList().get(i);
                if (null == g || !"1".equals(g.getCalcMode())) continue;
                return "1";
            }
        } else {
            if (YPopStatusType.cmdtype_calcorderpop.equalsIgnoreCase(cmdtype)) {
                if (null != cacheModel.getTempSalePayments() && cacheModel.getTempSalePayments().size() > 0) {
                    cacheModel.getOrder().setCalcMarketingMode("3");
                    return "3";
                }
                if (StringUtils.isBlank((String)cacheModel.getErrCode())) {
                    return "0";
                }
                return cacheModel.getOrder().getCalcMarketingMode();
            }
            if (YPopStatusType.cmdtype_ordersave.equalsIgnoreCase(cmdtype)) {
                return cacheModel.getOrder().getCalcMarketingMode();
            }
        }
        return calcMode;
    }

    @Override
    public double calcOrderOughtPay(double OughtPay, String precisionMode) {
        double saleyfje = ManipulatePrecision.getDetailOverFlow(OughtPay, precisionMode);
        return saleyfje;
    }

    @Override
    public CacheModel refreshGoodsListAfterOrder(CacheModel cacheModel, List<SellDetail> sellDetails, String calcResult, String calcMode, List<String> noDisPopTypes, boolean needYpopzke, boolean needGrant) {
        if (null == sellDetails || sellDetails.size() <= 0) {
            return cacheModel;
        }
        boolean isRefreshQty = false;
        int j = 0;
        for (int i = 0; i < sellDetails.size(); ++i) {
            int qtyRecalcFlag;
            if (cacheModel.getGoodsList().size() <= i) continue;
            SellDetail popGoods = sellDetails.get(i);
            Goods sg = cacheModel.getGoodsList().get(i);
            if ("0".equals(calcMode) && "YS1".equals(cacheModel.getOrder().getOrderType()) && null != popGoods.getSellPopDetails()) {
                for (SellPopDetail sellPopDetail : popGoods.getSellPopDetails()) {
                    if ("0".equals(sellPopDetail.getPopMode()) && sellPopDetail.getPopLimitOverage() > 0.0) {
                        cacheModel.setCalcResult(-1);
                        cacheModel.setErrMsg("\u9884\u552e\u5546\u54c1" + sg.getGoodsCode() + "\u8d85\u51fa\u9884\u552e\u9650\u91cf" + sellPopDetail.getPopLimitOverage() + "\u4e2a\uff0c\u8bf7\u4fee\u6539\u6570\u91cf");
                        return cacheModel;
                    }
                    if (!"1".equals(sellPopDetail.getPopMode()) || !(sellPopDetail.getPopLimitOverage() > 0.0)) continue;
                    cacheModel.setCalcResult(-1);
                    cacheModel.setErrMsg("\u9884\u552e\u5546\u54c1" + sg.getGoodsCode() + "\u9884\u552e\u9650\u91cf\u5df2\u7528\u5b8c\uff0c\u4e0d\u5141\u8bb8\u9500\u552e");
                    return cacheModel;
                }
            }
            if ((qtyRecalcFlag = sg.getQtyrecalc()) != (sg = this.goodsTransfer.transferGoods(popGoods, sg, calcResult, noDisPopTypes, needYpopzke, needGrant, false)).getQtyrecalc() && !isRefreshQty) {
                isRefreshQty = true;
                cacheModel.setErrCode("1111");
            }
            if (sg == null) continue;
            sg.setAdjustDiscountValue(this.getAdjustDiscount(sg));
            sg.setTotalDiscountValue(CountZZK.getNoPrcutZZK(sg));
            sg.setSaleAmount(sg.getSaleValue() - sg.getTotalDiscountValue());
            sg.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sg.getTotalDiscountValue() - sg.getNoDisAmountValue()));
            sg.setRealSalePrice(ManipulatePrecision.doubleConvert(sg.getSalePrice() - sg.getNoDisAmountValue() / sg.getQty()));
            boolean isAddCondition = true;
            for (CouponConditions c : cacheModel.getNeedCopType()) {
                if (sg.getGoodsCode().equals(c.getGoodsCode())) {
                    c.setQty(ManipulatePrecision.add(c.getQty(), sg.getQty()));
                    isAddCondition = false;
                    break;
                }
                if (c.getCouponProperty().size() <= 0) continue;
                c.setGoodsCode(sg.getGoodsCode());
                c.setQty(sg.getQty());
                cacheModel.getNeedCopType().add(c);
            }
            if (isAddCondition) {
                CouponConditions c = new CouponConditions();
                c.setCouponProperty(new ArrayList<CouponProperty>());
                for (PopDetail pop : sg.getPopDetailsInfo()) {
                    if (!YPopStatusType.pop_policy_group_needCoupon.equals(pop.getPopPolicyGroup())) continue;
                    boolean isAdd = true;
                    CouponProperty cp = new CouponProperty();
                    cp.setCouponType(pop.getPopPolicyMemo());
                    cp.setGoodsQty(CastUtil.castDouble(pop.getPopPolicySymbol()));
                    if (ManipulatePrecision.doubleCompare(cp.getGoodsQty(), 0.0, 2) <= 0) {
                        cp.setGoodsQty(1.0);
                    }
                    c.getCouponProperty().add(cp);
                }
                if (c.getCouponProperty().size() > 0) {
                    c.setGoodsCode(sg.getGoodsCode());
                    c.setQty(sg.getQty());
                    cacheModel.getNeedCopType().add(c);
                }
            }
            cacheModel.getGoodsList().set(j, sg);
            ++j;
        }
        return cacheModel;
    }

    @Override
    public boolean isLimitedPayCode(String payCode, List<String> limitedPayCodes) {
        if (null == payCode || null == limitedPayCodes || limitedPayCodes.size() <= 0) {
            return false;
        }
        for (int i = 0; i < limitedPayCodes.size(); ++i) {
            if (!payCode.equals(limitedPayCodes.get(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isExceptPayCode(String payCode, List<String> exceptPayCodes) {
        if (null == payCode || null == exceptPayCodes || exceptPayCodes.size() <= 0) {
            return false;
        }
        for (int i = 0; i < exceptPayCodes.size(); ++i) {
            if (!payCode.equals(exceptPayCodes.get(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getResultType(SellExceptPay except_pays) {
        if (except_pays == null) {
            return null;
        }
        if (YPopStatusType.order_pay_except.equalsIgnoreCase(except_pays.getMode())) {
            return YPopStatusType.order_pay_except;
        }
        if (YPopStatusType.order_pay_zszk.equalsIgnoreCase(except_pays.getMode())) {
            return YPopStatusType.order_pay_zszk;
        }
        return null;
    }

    @Override
    public CacheModel calcPayBalance(CacheModel order) {
        this.calcBalance(order);
        Order saleOrder = order.getOrder();
        double existPay = saleOrder.getExistPay();
        double balance = this.calcOrderOughtPay(saleOrder.getRemainValue(), order.getOrder().getPrecisionMode());
        if (ManipulatePrecision.doubleCompare(balance, 0.0, 2) == 0 && balance != saleOrder.getRemainValue()) {
            double overageValue = ManipulatePrecision.getDetailOverFlow(balance - saleOrder.getRemainValue(), "9");
            boolean isMatchOverage = false;
            for (int i = order.getPayments().size() - 1; i >= 0; --i) {
                Payment pay = order.getPayments().get(i);
                if (!"Y".equals(pay.getIsOverage())) continue;
                pay.setOverage(overageValue);
                isMatchOverage = true;
                break;
            }
            if (!isMatchOverage) {
                order.setCalcResult(-1);
                order.setErrMsg("\u8ba2\u5355\u652f\u4ed8\u884c\u4e0d\u652f\u6301\u627e\u96f6\u6216\u8005\u6ea2\u4f59.");
                return order;
            }
            this.calcBalance(order);
        }
        saleOrder.setExistPay(existPay);
        return order;
    }

    @Override
    public CacheModel calcBalance(CacheModel cacheModel) {
        this.calcOrderAmount(cacheModel);
        Order saleOrder = cacheModel.getOrder();
        List<Payment> payments = cacheModel.getPayments();
        double payAmount = 0.0;
        double overage = 0.0;
        double changeValue = 0.0;
        for (Payment payment : payments) {
            if ("1".equals(payment.getFlag())) {
                payAmount += payment.getMoney();
                overage += payment.getOverage();
                continue;
            }
            if (!"2".equals(payment.getFlag())) continue;
            changeValue += payment.getMoney();
        }
        double salezlexception = overage;
        double balance = saleOrder.getOughtPay() - payAmount + overage;
        if (balance < 0.0) {
            balance = 0.0;
        }
        saleOrder.setExistPay(ManipulatePrecision.doubleConvert(payAmount, 2, 1));
        saleOrder.setOverageValue(salezlexception);
        saleOrder.setRemainValue(ManipulatePrecision.doubleConvert(balance, 2, 1));
        saleOrder.setChangeValue(changeValue);
        this.getNewRateAmtForOrder(saleOrder);
        cacheModel.setOrder(saleOrder);
        log.info(" \u8ba1\u7b97\u8ba2\u5355\u4ed8\u6b3e\u4f59\u989d :existPay = {} overage={} changeValue={} remainValue={}", new Object[]{payAmount, overage, changeValue, balance});
        return cacheModel;
    }

    @Override
    public CacheModel calcPayAmout(CacheModel cacheModel, Payment payment) {
        cacheModel.setCalcResult(0);
        cacheModel = this.calcBalance(cacheModel);
        boolean isTh = SellType.ISBACK(cacheModel.getOrder().getOrderType());
        double amount = ManipulatePrecision.getMoneyByPrecision(payment.getAmount(), payment.getPrcutMode(), payment.getPrecision(), isTh);
        payment.setAmount(amount);
        double balance = cacheModel.getOrder().getRemainValue();
        if (balance == 0.0 && ManipulatePrecision.getMoneyByPrecision(payment.getAmount() - balance, payment.getPrcutMode(), payment.getPrecision(), isTh) > 0.0) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrMsg("\u8ba2\u5355\u652f\u4ed8\u5df2\u7ecf\u8db3\u591f\uff0c\u4e0d\u9700\u8981\u518d\u652f\u4ed8");
            log.info("\u8ba2\u5355\u652f\u4ed8\u5df2\u7ecf\u8db3\u591f\uff0c\u4e0d\u9700\u8981\u518d\u652f\u4ed8");
            throw new EfutureException(Code.CODE_50145.getRespBase(new Object[0]));
        }
        double money = ManipulatePrecision.mul(payment.getAmount(), payment.getRate(), 2);
        double changeValue = 0.0;
        double existPay = cacheModel.getOrder().getExistPay();
        double overage = cacheModel.getOrder().getOverageValue();
        log.info("\u8ba1\u7b97\u4ed8\u6b3e\u91d1\u989d \uff1amoney\u3010{}\u3011,balance\u3010{}\u3011,oughtPay\u3010{}\u3011,existPay\u3010{}\u3011", new Object[]{money, balance, cacheModel.getOrder().getOughtPay(), existPay});
        boolean isContinue = true;
        double zlmin = 0.1;
        String obj = this.redisUtil.get("business:initialize:cacheid:" + cacheModel.getOrder().getShopCode() + cacheModel.getOrder().getTerminalNo());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        String zxzl = modeDetailsVo.getSysparaValue("ZLMIN");
        if (StringUtils.isNotBlank((String)zxzl) && Double.parseDouble(zxzl) > 0.0) {
            zlmin = Double.parseDouble(zxzl);
        }
        if (money - balance > 0.0) {
            double remainValue;
            String prcutMode = DataExchageUtils.exchangePrecisionMode(cacheModel.getPayMode().getRoundType());
            if (ManipulatePrecision.doubleCompare(ManipulatePrecision.getMoneyByPrecision(money - balance, prcutMode, cacheModel.getPayMode().getRoundPrecision(), !isTh), zlmin, 2) >= 0 && "Y".equalsIgnoreCase(payment.getIsAllowCharge())) {
                log.info("\u8fdb\u5165\u627e\u96f6");
                changeValue = money - balance;
                if ("E".equals(payment.getPrcutMode()) || "G".equals(payment.getPrcutMode()) || "I".equals(payment.getPrcutMode()) || "L".equals(payment.getPrcutMode())) {
                    if (!isTh) {
                        if ("E".equals(payment.getPrcutMode())) {
                            changeValue = ManipulatePrecision.getDetailOverFlow(money - balance, "F");
                        } else if ("G".equals(payment.getPrcutMode())) {
                            changeValue = ManipulatePrecision.getDetailOverFlow(money - balance, "H");
                        } else if ("I".equals(payment.getPrcutMode())) {
                            changeValue = ManipulatePrecision.getDetailOverFlow(money - balance, "J");
                        } else if ("L".equals(payment.getPrcutMode())) {
                            changeValue = money - ManipulatePrecision.getDetailOverFlow(balance, payment.getPrcutMode());
                        }
                    } else {
                        changeValue = ManipulatePrecision.getDetailOverFlow(money - balance, payment.getPrcutMode());
                    }
                }
                log.info("changeValue:" + changeValue);
                Payment changePayment = this.createChangePayment(changeValue, payment, cacheModel);
                if (0.0 != cacheModel.getOrder().getSysPara().getMaxChangeValue() && changePayment.getMoney() > cacheModel.getOrder().getSysPara().getMaxChangeValue()) {
                    cacheModel.setCalcResult(-1);
                    cacheModel.setErrMsg("\u627e\u96f6\u91d1\u989d[" + changePayment.getMoney() + "]\u8d85\u8fc7\u6700\u5927\u627e\u96f6\u91d1\u989d[" + cacheModel.getOrder().getSysPara().getMaxChangeValue() + "]");
                    return cacheModel;
                }
                payment.setMoney(ManipulatePrecision.doubleConvert(money, 2, 1));
                double pOvrerage = ManipulatePrecision.sub(payment.getMoney(), balance + changeValue);
                payment.setOverage(ManipulatePrecision.getDetailOverFlow(pOvrerage, "0"));
                payment.setRoundUpOverageValue(ManipulatePrecision.sub(pOvrerage, payment.getOverage()));
                existPay = ManipulatePrecision.add(existPay, payment.getMoney());
                overage = ManipulatePrecision.add(overage, payment.getOverage());
                cacheModel.getPayments().add(payment);
                if (changePayment.getMoney() > 0.0) {
                    cacheModel.getPayments().add(changePayment);
                    changeValue = changePayment.getMoney();
                }
                cacheModel.getOrder().setOverageValue(overage);
                remainValue = 0.0;
            } else if ("Y".equalsIgnoreCase(payment.getIsOverage())) {
                payment.setMoney(ManipulatePrecision.doubleConvert(money, 2, 1));
                double pOvrerage = ManipulatePrecision.sub(payment.getMoney(), balance);
                payment.setOverage(ManipulatePrecision.getDetailOverFlow(pOvrerage, "0"));
                payment.setRoundUpOverageValue(ManipulatePrecision.sub(pOvrerage, payment.getOverage()));
                changeValue = 0.0;
                remainValue = 0.0;
                cacheModel.getPayments().add(payment);
                existPay = ManipulatePrecision.add(existPay, payment.getMoney());
                overage = ManipulatePrecision.add(overage, payment.getOverage());
            } else {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrMsg("\u8ba2\u5355\u652f\u4ed8\u884c\u4e0d\u652f\u6301\u627e\u96f6\u6216\u8005\u6ea2\u4f59");
                log.info("\u8ba2\u5355\u652f\u4ed8\u884c\u4e0d\u652f\u6301\u627e\u96f6\u6216\u8005\u6ea2\u4f59");
                throw new EfutureException(Code.CODE_50146.getRespBase(new Object[0]));
            }
            cacheModel.getOrder().setChangeValue(changeValue);
            cacheModel.getOrder().setRemainValue(remainValue);
            cacheModel.getOrder().setExistPay(this.calcOrderOughtPay(existPay, payment.getPrecision()));
            cacheModel.getOrder().setOverageValue(ManipulatePrecision.doubleConvert(overage += ManipulatePrecision.sub(cacheModel.getOrder().getExistPay(), existPay), 2, 1));
            if (ManipulatePrecision.doubleCompare(cacheModel.getOrder().getExistPay() - cacheModel.getOrder().getChangeValue(), cacheModel.getOrder().getOughtPay() + cacheModel.getOrder().getOverageValue(), 2) != 0) {
                cacheModel.getOrder().setPayOverageValue(cacheModel.getOrder().getExistPay() - cacheModel.getOrder().getChangeValue() - cacheModel.getOrder().getOughtPay() - cacheModel.getOrder().getOverageValue());
                cacheModel.getOrder().setOverageValue(cacheModel.getOrder().getExistPay() - cacheModel.getOrder().getChangeValue() - cacheModel.getOrder().getOughtPay());
            } else {
                cacheModel.getOrder().setPayOverageValue(0.0);
            }
            isContinue = false;
        } else if (ManipulatePrecision.doubleConvert(balance - money) < Double.parseDouble(payment.getPrecision()) && (!"E".equals(payment.getPrcutMode()) && !"G".equals(payment.getPrcutMode()) || !isTh)) {
            double remainValue = 0.0;
            changeValue = 0.0;
            payment.setMoney(ManipulatePrecision.doubleConvert(money, 2, 1));
            double poverage = ManipulatePrecision.sub(payment.getMoney(), balance);
            existPay = ManipulatePrecision.add(existPay, payment.getMoney());
            boolean isOverageEnd = false;
            if ("Y".equalsIgnoreCase(payment.getIsOverage())) {
                payment.setOverage(ManipulatePrecision.getDetailOverFlow(poverage, "0"));
                payment.setRoundUpOverageValue(ManipulatePrecision.sub(poverage, payment.getOverage()));
                overage += payment.getOverage();
                isOverageEnd = true;
            } else {
                payment.setOverage(0.0);
                payment.setRoundUpOverageValue(0.0);
                for (int i = cacheModel.getPayments().size() - 1; i >= 0; --i) {
                    Payment pay = cacheModel.getPayments().get(i);
                    if (!"Y".equals(pay.getIsOverage())) continue;
                    pay.setOverage(ManipulatePrecision.getDetailOverFlow(poverage, "0"));
                    pay.setRoundUpOverageValue(ManipulatePrecision.sub(poverage, pay.getOverage()));
                    overage += pay.getOverage();
                    isOverageEnd = true;
                    cacheModel.getPayments().set(i, pay);
                    break;
                }
            }
            if (isOverageEnd) {
                cacheModel.getPayments().add(payment);
                cacheModel.getOrder().setExistPay(existPay);
                cacheModel.getOrder().setOverageValue(ManipulatePrecision.doubleConvert(overage, 2, 1));
                cacheModel.getOrder().setChangeValue(changeValue);
                cacheModel.getOrder().setRemainValue(remainValue);
                if (ManipulatePrecision.doubleCompare(cacheModel.getOrder().getExistPay() - cacheModel.getOrder().getChangeValue(), cacheModel.getOrder().getOughtPay() + cacheModel.getOrder().getOverageValue(), 2) != 0) {
                    cacheModel.getOrder().setPayOverageValue(cacheModel.getOrder().getExistPay() - cacheModel.getOrder().getChangeValue() - cacheModel.getOrder().getOughtPay() - cacheModel.getOrder().getOverageValue());
                    cacheModel.getOrder().setOverageValue(cacheModel.getOrder().getExistPay() - cacheModel.getOrder().getChangeValue() - cacheModel.getOrder().getOughtPay());
                } else {
                    cacheModel.getOrder().setPayOverageValue(0.0);
                }
                isContinue = false;
            }
        }
        if (isContinue) {
            changeValue = 0.0;
            payment.setMoney(ManipulatePrecision.doubleConvert(money, 2, 1));
            payment.setOverage(0.0);
            payment.setRoundUpOverageValue(0.0);
            cacheModel.getPayments().add(payment);
            cacheModel = this.calcPayBalance(cacheModel);
            log.info("remainValue\u3010{}\u3011", (Object)cacheModel.getOrder().getRemainValue());
            if ("Y".equals(payment.getIsOverage()) && ManipulatePrecision.doubleCompare(cacheModel.getOrder().getRemainValue(), 0.0, 2) > 0 && ManipulatePrecision.doubleCompare(ManipulatePrecision.getMoneyByPrecision(cacheModel.getOrder().getRemainValue(), payment.getPrcutMode(), payment.getPrecision(), isTh), 0.0, 2) == 0) {
                log.info("setOverage");
                cacheModel.getPayments().get(cacheModel.getPayments().size() - 1).setOverage(-cacheModel.getOrder().getRemainValue());
                cacheModel = this.calcPayBalance(cacheModel);
            }
        }
        this.getNewRateAmtForOrder(cacheModel.getOrder());
        return cacheModel;
    }

    @Override
    public Payment createChangePayment(double changeValue, Payment payment, CacheModel cacheModel) {
        PayMode payMode = cacheModel.getPayMode();
        Payment p = new Payment();
        p.setFlag("2");
        p.setPuid(String.valueOf(UniqueID.getUniqueID()));
        p.setRownoId(p.getPuid());
        p.setRowno(payment.getRowno() + 1);
        p.setRownoId("");
        p.setPayCode(payMode.getPayCode());
        if (payMode.getPayName().matches("[a-zA-Z0-9]+")) {
            p.setPayName(payMode.getPayName() + " Change");
        } else {
            p.setPayName(payMode.getPayName() + " \u627e\u96f6");
        }
        if (0.0 == payMode.getRate()) {
            p.setRate(1.0);
        } else {
            p.setRate(payMode.getRate());
        }
        p.setChargeRate(payMode.getRate());
        p.setTerminalNo(cacheModel.getOrder().getTerminalNo());
        p.setTerminalSno(cacheModel.getOrder().getTerminalSno());
        p.setPayType(payMode.getPayType());
        p.setPrcutMode(payMode.getRoundType());
        p.setPrecision(payMode.getRoundPrecision());
        String prcutMode = DataExchageUtils.exchangePrecisionMode(p.getPrcutMode());
        p.setAmount(ManipulatePrecision.getMoneyByPrecision(changeValue, prcutMode, p.getPrecision()));
        p.setMoney(ManipulatePrecision.getMoneyByPrecision(changeValue, prcutMode, p.getPrecision()));
        p.setOverage(0.0);
        p.setRoundUpOverageValue(0.0);
        return p;
    }

    @Override
    public CacheModel calcDeletePay(CacheModel cacheModel) {
        List<Payment> payments = cacheModel.getPayments();
        PaymentForPos p = null;
        int zlRowNo = 0;
        int j = 1;
        for (int i = 0; i < payments.size(); ++i) {
            if (payments.get(i).getFlag().equals("2")) {
                p = payments.get(i);
                zlRowNo = i;
                continue;
            }
            payments.get(i).setRowno(j);
            ++j;
        }
        if (p == null) {
            this.calcPayBalance(cacheModel);
            return cacheModel;
        }
        payments.remove(zlRowNo);
        p.setFlag("1");
        ((Payment)p).setRowno(payments.size() + 1);
        cacheModel.setPayments(payments);
        cacheModel = this.calcPayBalance(cacheModel);
        this.calcPayBalance(cacheModel);
        return cacheModel;
    }

    @Override
    public boolean isNoYpopPay(String noYpopPayCodes, String paycode) {
        if (StringUtils.isBlank((String)noYpopPayCodes)) {
            return false;
        }
        return noYpopPayCodes.contains(paycode);
    }

    @Override
    public boolean isNoYpopPay(List<String> limitedPayCodes, String paycode) {
        if (null == limitedPayCodes || limitedPayCodes.size() == 0) {
            return false;
        }
        for (String str : limitedPayCodes) {
            if (!str.equals(paycode)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Payment> getCouponPayments(List<Payment> payments) {
        if (null == payments || payments.size() == 0) {
            return null;
        }
        ArrayList<Payment> list = new ArrayList<Payment>();
        for (Payment payment : payments) {
            if (!"Y".equalsIgnoreCase(payment.getIsCoupon())) continue;
            list.add(payment);
        }
        return list;
    }

    @Override
    public boolean checkBalance(CacheModel cacheModel) {
        Order saleOrder = cacheModel.getOrder();
        List<Goods> goodsList = cacheModel.getGoodsList();
        if (saleOrder.getSaleValue() == 0.0) {
            saleOrder.setSaleValue(ManipulatePrecision.doubleConvert(saleOrder.getOughtPay() + saleOrder.getTotalDiscountValue(), 2, 1));
        }
        if (ManipulatePrecision.doubleCompare(saleOrder.getOughtPay(), this.calcOrderOughtPay(saleOrder.getSaleValue() - saleOrder.getTotalDiscountValue(), saleOrder.getPrecisionMode()), 2) != 0) {
            cacheModel.setErrMsg("\u4ea4\u6613\u4e3b\u5355\u6570\u636e\u76f8\u4e92\u4e0d\u5e73!\n\n\u5e94\u6536\u91d1\u989d = " + ManipulatePrecision.doubleToString(saleOrder.getOughtPay()) + "\n\u5408\u8ba1\u91d1\u989d - \u5408\u8ba1\u6298\u6263 = " + this.calcOrderOughtPay(saleOrder.getSaleValue() - saleOrder.getTotalDiscountValue(), saleOrder.getPrecisionMode()));
            return false;
        }
        if (ManipulatePrecision.doubleCompare(saleOrder.getTotalDiscountValue(), saleOrder.getPreferentialDiscAmount() + saleOrder.getMemberDiscAmount() + saleOrder.getTemporaryDiscAmount() + saleOrder.getCouponDiscAmount(), 2) != 0) {
            cacheModel.setErrMsg("\u4ea4\u6613\u4e3b\u5355\u6570\u636e\u76f8\u4e92\u4e0d\u5e73!\n\n\u5408\u8ba1\u6298\u6263 = " + ManipulatePrecision.doubleToString(saleOrder.getTotalDiscountValue()) + "\n\u6298\u6263\u660e\u7ec6  = " + ManipulatePrecision.doubleToString(saleOrder.getPreferentialDiscAmount() + saleOrder.getMemberDiscAmount() + saleOrder.getTemporaryDiscAmount()));
            return false;
        }
        double amount = 0.0;
        for (int i = 0; i < goodsList.size(); ++i) {
            Goods goods = goodsList.get(i);
            if ("0".equals(goods.getFlag())) continue;
            if (goods.getQty() == 0.0 || goods.getQty() < 0.0) {
                cacheModel.setErrMsg("\u7b2c" + (i + 1) + "\u884c\u5546\u54c1 [" + goods.getGoodsCode() + "] \u6570\u91cf\u4e0d\u5408\u6cd5\n\u8bf7\u4fee\u6539\u6b64\u884c\u5546\u54c1\u6570\u91cf\u6216\u8005\u5220\u9664\u6b64\u5546\u54c1\u540e\u91cd\u65b0\u5f55\u5165");
                return false;
            }
            amount += ManipulatePrecision.doubleConvert(goods.getSaleAmount(), 2, 1);
        }
        amount = this.calcOrderOughtPay(amount, saleOrder.getPrecisionMode());
        if (ManipulatePrecision.doubleCompare(saleOrder.getOughtPay(), amount, 2) != 0) {
            cacheModel.setErrMsg("\u4ea4\u6613\u4e3b\u5355\u548c\u5546\u54c1\u660e\u7ec6\u4e0d\u5e73!\n\n\u4e3b\u5355\u5e94\u6536\u91d1\u989d  = " + ManipulatePrecision.doubleToString(saleOrder.getOughtPay()) + "\n\u5546\u54c1\u5408\u8ba1\u91d1\u989d  = " + ManipulatePrecision.doubleToString(amount));
            return false;
        }
        return true;
    }

    @Override
    public boolean checkOrder(CacheModel cacheModel) {
        Order saleOrder = cacheModel.getOrder();
        List<Payment> payments = cacheModel.getPayments();
        if (saleOrder.getSaleValue() == 0.0) {
            saleOrder.setSaleValue(ManipulatePrecision.doubleConvert(saleOrder.getOughtPay() + saleOrder.getTotalDiscountValue(), 2, 1));
        }
        if (payments.size() > 0 && ManipulatePrecision.doubleCompare(saleOrder.getExistPay() - saleOrder.getChangeValue(), saleOrder.getOughtPay() - saleOrder.getRoundUpOverageValue() + saleOrder.getOverageValue(), 2) != 0) {
            cacheModel.setErrMsg("\u4ea4\u6613\u4e3b\u5355\u6570\u636e\u76f8\u4e92\u4e0d\u5e73!\n\n\u5b9e\u9645\u4ed8\u6b3e - \u627e\u96f6  = " + ManipulatePrecision.doubleToString(saleOrder.getExistPay() - saleOrder.getChangeValue()) + "\n\u5e94\u6536\u91d1\u989d + \u635f\u6ea2   = " + ManipulatePrecision.doubleToString(saleOrder.getOughtPay() - saleOrder.getRoundUpOverageValue() + saleOrder.getOverageValue()));
            return false;
        }
        double amount = 0.0;
        double changeValue = 0.0;
        for (int i = 0; i < payments.size(); ++i) {
            Payment payment = payments.get(i);
            if ("2".equals(payment.getFlag())) {
                changeValue += payment.getMoney();
                continue;
            }
            if ("3".equals(payment.getFlag())) continue;
            amount += payment.getMoney();
        }
        if (ManipulatePrecision.doubleCompare(this.calcOrderOughtPay(saleOrder.getExistPay(), saleOrder.getPrecisionMode()), this.calcOrderOughtPay(amount, saleOrder.getPrecisionMode()), 2) != 0) {
            cacheModel.setErrMsg("\u4ea4\u6613\u4e3b\u5355\u548c\u4ed8\u6b3e\u660e\u7ec6\u4e0d\u5e73!\n\n\u4e3b\u5355\u5b9e\u9645\u4ed8\u6b3e = " + ManipulatePrecision.doubleToString(this.calcOrderOughtPay(saleOrder.getExistPay(), saleOrder.getPrecisionMode())) + "\n\u4ed8\u6b3e\u5408\u8ba1\u91d1\u989d  = " + ManipulatePrecision.doubleToString(this.calcOrderOughtPay(amount, saleOrder.getPrecisionMode())));
            return false;
        }
        return true;
    }

    @Override
    public double calcPopDiscountAmount(CacheModel cacheModel) {
        double discountAmount = 0.0;
        List<Goods> goodsList = cacheModel.getGoodsList();
        for (Goods g : goodsList) {
            discountAmount += g.getPopDiscountValue();
        }
        return discountAmount;
    }

    @Override
    public boolean jYPopDiscountAmount(double discountAmount, CacheModel cacheModel) {
        double newdiscountAmount = this.calcPopDiscountAmount(cacheModel);
        return ManipulatePrecision.doubleCompare(discountAmount, newdiscountAmount, 2) == 0;
    }

    @Override
    public CacheModel deletePopDetail(CacheModel cacheModel) {
        List<Goods> goodsList = cacheModel.getGoodsList();
        for (Goods g : goodsList) {
            if (null == g.getPopDetailsInfo() || 0 == g.getPopDetailsInfo().size()) continue;
            ArrayList<PopDetail> popDetails = new ArrayList<PopDetail>();
            for (PopDetail p : g.getPopDetailsInfo()) {
                if (!p.getPopPolicyGroup().equals(YPopStatusType.pop_policy_group_grant_goods) && !p.getPopPolicyGroup().equals(YPopStatusType.pop_policy_group_grant_order) && !p.getPopPolicyGroup().equals(YPopStatusType.pop_policy_group_erpvip)) continue;
                popDetails.add(p);
            }
            g.getPopDetailsInfo().clear();
            g.setPopDetailsInfo(popDetails);
        }
        cacheModel.setGoodsList(goodsList);
        return cacheModel;
    }

    @Override
    public CacheModel clearGoodsPop(CacheModel cacheModel) {
        List<Goods> goodsList = cacheModel.getGoodsList();
        for (int i = 0; i < goodsList.size(); ++i) {
            Goods g = goodsList.get(0);
            if ("9".equals(g.getFlag())) {
                goodsList.remove(i);
                --i;
                continue;
            }
            if (g.getPopDetailsInfo() == null || g.getPopDetailsInfo().size() == 0) continue;
            g.setFlowId(i + 1);
            g.getPopDetailsInfo().clear();
            g.setAdjustDiscountValue(0.0);
            g.setCouponValue(0.0);
            g.setPopDiscountValue(0.0);
            g.setAdjustDiscountValue(0.0);
            g.setTotalDiscountValue(0.0);
            g.setRealTotalDiscountValue(0.0);
            g.setCustomDiscountValue(0.0);
            g.setPayDiscountValue(0.0);
            g.setGiftTempAmount(0.0);
            g.setTempZkDiscount(0.0);
            g.setTempZrDiscount(0.0);
            g.setTempZzkDiscount(0.0);
            g.setTempZzrDiscount(0.0);
            g.setTempZkl(100.0);
            goodsList.set(i, g);
        }
        cacheModel.getOrder().setTempZzk(0.0);
        cacheModel.getOrder().setTempZzr(0.0);
        cacheModel.setGoodsList(goodsList);
        this.calcOrderAmount(cacheModel);
        return cacheModel;
    }

    @Override
    public String getNewSGoodsSno(CacheModel cacheModel) {
        String nowSGoodsSnoString = "";
        if (null == cacheModel.getGoodsList() || cacheModel.getGoodsList().size() == 0) {
            return "1";
        }
        int i = cacheModel.getGoodsList().size();
        for (int j = i - 1; j > 0; --j) {
            Goods good = cacheModel.getGoodsList().get(j);
            if (!StringUtils.isNotBlank((String)good.getSGoodsSno())) continue;
            nowSGoodsSnoString = good.getSGoodsSno();
            break;
        }
        if (nowSGoodsSnoString.length() <= 0) {
            return "1";
        }
        int sno = Integer.valueOf(nowSGoodsSnoString);
        return String.valueOf(++sno);
    }

    @Override
    public boolean checkGoodsGrantRange(Goods good, List grantStr, String mode) {
        if (StringUtils.isBlank((String)mode)) {
            mode = "3";
        }
        if ("1".equals(mode)) {
            if ("%".equals(good.getOrgCode())) {
                return true;
            }
            return null == grantStr || grantStr.size() <= 0 || grantStr.get(0).equals("ALL") || grantStr.get(0).equals("0") || !StringUtils.isNotEmpty((String)good.getOrgCode()) || grantStr.contains(good.getOrgCode());
        }
        if ("3".equals(mode)) {
            if ("0".equals(good.getCategoryCode())) {
                return true;
            }
            return null == grantStr || grantStr.size() <= 0 || grantStr.get(0).equals("ALL") || grantStr.get(0).equals("0") || !StringUtils.isNotEmpty((String)good.getCategoryCode()) || grantStr.contains(good.getCategoryCode());
        }
        return true;
    }

    @Override
    public CacheModel calcAmcPoints(CacheModel cacheModel, Payment payment) {
        cacheModel.setCalcResult(0);
        payment.setMoney(cacheModel.getOrder().getOughtPay());
        payment.setOverage(0.0);
        payment.setRoundUpOverageValue(0.0);
        double rate = payment.getMoney() / payment.getAmount();
        rate = ManipulatePrecision.doubleConvert(rate, 4, 1);
        payment.setRate(rate);
        cacheModel.getPayments().add(payment);
        cacheModel.getOrder().setExistPay(cacheModel.getOrder().getOughtPay());
        cacheModel.getOrder().setOverageValue(0.0);
        cacheModel.getOrder().setChangeValue(0.0);
        cacheModel.getOrder().setRemainValue(0.0);
        return cacheModel;
    }

    @Override
    public CacheModel refreshTerminalSno(CacheModel cacheModel, String newTerminalSno) {
        cacheModel.getOrder().setTerminalSno(newTerminalSno);
        if (cacheModel.getPayments().size() > 0) {
            for (Payment p : cacheModel.getPayments()) {
                p.setTerminalSno(newTerminalSno);
            }
        }
        return cacheModel;
    }

    @Override
    public CacheModel removeZzr(CacheModel cacheModel) {
        for (int i = 0; i < cacheModel.getGoodsList().size(); ++i) {
            Goods sg = cacheModel.getGoodsList().get(i);
            if (!(sg.getTempZzrDiscount() > 0.0)) continue;
            sg.setTempZzrDiscount(0.0);
            sg.setAdjustDiscountValue(this.getAdjustDiscount(sg));
            sg.setTotalDiscountValue(CountZZK.getZZK(sg));
            sg.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sg.getTotalDiscountValue() - sg.getNoDisAmountValue()));
            sg.setSaleAmount(sg.getSaleValue() - sg.getTotalDiscountValue());
        }
        this.calcOrderAmount(cacheModel);
        return cacheModel;
    }

    @Override
    public CacheModel removeAeonCouponPopDetail(CacheModel cacheModel) {
        for (int i = 0; i < cacheModel.getGoodsList().size(); ++i) {
            Goods sg = cacheModel.getGoodsList().get(i);
            sg.setTempPopDetails(new ArrayList<PopDetail>());
            if (null == sg.getPopDetailsInfo() || sg.getPopDetailsInfo().size() <= 0) continue;
            boolean isNeedCalc = false;
            for (int j = 0; j < sg.getPopDetailsInfo().size(); ++j) {
                PopDetail p = sg.getPopDetailsInfo().get(j);
                if (!YPopStatusType.pop_policy_group_aeoncoupon.equals(p.getPopPolicyGroup())) continue;
                sg.getTempPopDetails().add((PopDetail)p.clone());
                sg.getPopDetailsInfo().remove(j);
                sg.setPopDiscountValue(ManipulatePrecision.doubleConvert(sg.getPopDiscountValue() - p.getDiscountAmount(), 2, 1));
                --j;
                isNeedCalc = true;
            }
            if (!isNeedCalc) continue;
            sg.setTotalDiscountValue(CountZZK.getZZK(sg));
            sg.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sg.getTotalDiscountValue() - sg.getNoDisAmountValue()));
            sg.setSaleAmount(sg.getSaleValue() - sg.getTotalDiscountValue());
        }
        this.calcOrderAmount(cacheModel);
        return cacheModel;
    }

    @Override
    public AnalyzeBarcodeDef analyzeCodeInfo(int codeMode, String barNo, String calcMode) {
        AnalyzeBarcodeDef out = new AnalyzeBarcodeDef();
        String barCodeNo = barNo;
        out.setOriginalBarNo(barCodeNo);
        out.setBarNo(barCodeNo);
        out.setBarNoMode(codeMode);
        out.setPriceMode(0);
        if (codeMode == 2 || codeMode == 3) {
            out.setPriceMode(2);
            if (barCodeNo.length() == 24 && barCodeNo.startsWith("92")) {
                if (barCodeNo.charAt(3) - 48 != Convert.convertProfitPriceCheckNum(barCodeNo.substring(4, 10))) {
                    out.setValidate(false);
                    return out;
                }
                if (Convert.convertProfitCheckNum(barCodeNo) != barCodeNo.charAt(barNo.length() - 1) - 48) {
                    out.setValidate(false);
                    return out;
                }
                char flag = barCodeNo.charAt(2);
                if (flag == '1') {
                    out.setDisMode(1);
                } else if (flag == '2') {
                    out.setDisMode(2);
                } else if (flag == '3') {
                    out.setDisMode(3);
                }
                out.setDisValue(ManipulatePrecision.doubleConvert(CastUtil.castDouble(barCodeNo.substring(4, 10)) / 100.0, 2, 1));
                out.setBarNo(barCodeNo.substring(10, 23));
                barCodeNo = barCodeNo.substring(10, 23);
            }
            if (codeMode == 2) {
                codeMode = 1;
            }
        }
        if (codeMode == 1) {
            if (barCodeNo.length() == 12) {
                out.setBarNo("0" + barCodeNo);
                out.setIsNeedFindDzc(false);
            } else if (barCodeNo.length() == 13 && barCodeNo.startsWith("210")) {
                out.setBarNo(CastUtil.castAeonGoodsCode(barCodeNo));
                out.setIsNeedFindDzc(false);
            } else if (barCodeNo.length() == 4) {
                out.setBarNo(CastUtil.castAeonGoodsCode("99" + barCodeNo));
                if (!"2".equals(calcMode)) {
                    out.setPriceMode(1);
                }
            } else if (barCodeNo.length() == 5) {
                out.setBarNo(CastUtil.castAeonGoodsCode(barCodeNo));
                if (!"2".equals(calcMode)) {
                    out.setPriceMode(1);
                }
            } else if (barCodeNo.length() == 7) {
                out.setBarNo(barCodeNo.replaceFirst("^0*", ""));
            }
        }
        return out;
    }

    @Override
    public boolean checkGzRange(GoodsInfo goods, String mode, String gzInfo) {
        try {
            String[] gzStr;
            if ("N".equals(mode)) {
                return true;
            }
            if (StringUtils.isBlank((String)gzInfo)) {
                return true;
            }
            for (String gz : gzStr = gzInfo.split(",")) {
                if (!gz.equals(goods.getOrgCode())) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean checkYyyRange(OperUser operuser, String mode, String gzInfo) {
        try {
            if (StringUtils.isBlank((String)operuser.getCardno())) {
                return true;
            }
            if (StringUtils.isBlank((String)operuser.getYyygz())) {
                return true;
            }
            if ("N".equals(mode) || "A".equals(mode)) {
                return true;
            }
            String[] yyygzInfo = operuser.getYyygz().split(",");
            if (0 == yyygzInfo.length) {
                return true;
            }
            if ("Y".equals(mode)) {
                String[] gzStr;
                if (StringUtils.isBlank((String)gzInfo)) {
                    return false;
                }
                for (String gz : gzStr = gzInfo.split(",")) {
                    for (String yyygz : yyygzInfo) {
                        if (!gz.equals(yyygz)) continue;
                        return true;
                    }
                }
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void reducePoints(CacheModel cacheModel, ServiceSession session) {
        cacheModel.getOrder().setTotalPoint(cacheModel.getOrder().getConsumersData().getPoint() + cacheModel.getOrder().getThisTimeUsedPoint() - cacheModel.getOrder().getThisTimePoint());
        cacheModel.getOrder().setGivePointFlag(1);
    }

    @Override
    public void givePoints(CacheModel cacheModel, ServiceSession session) {
        cacheModel.getOrder().setTotalPoint(cacheModel.getOrder().getConsumersData().getPoint() - cacheModel.getOrder().getThisTimeUsedPoint() + cacheModel.getOrder().getThisTimePoint());
        cacheModel.getOrder().setGivePointFlag(1);
    }

    @Override
    public Goods calcGoodsBarcodeDiscBeforeSingle(Goods goods, int disMode, double disValue, String discType) {
        if ("0".equals(discType)) {
            if (disMode == 1) {
                if (ManipulatePrecision.doubleCompare(disValue, goods.getSaleAmount(), 2) >= 0) {
                    goods.setBarcodeDiscount(goods.getSaleAmount());
                } else {
                    goods.setBarcodeDiscount(disValue);
                }
            } else if (disMode == 2) {
                String precisionMode = DataExchageUtils.exchangePrecisionMode(goods.getPrcutMode());
                if (ManipulatePrecision.doubleCompare(disValue, 100.0, 2) > 0) {
                    return goods;
                }
                goods.setBarcodeDiscount(ManipulatePrecision.getDetailOverFlow(goods.getSaleAmount() * disValue, precisionMode));
            } else if (disMode == 3) {
                if (ManipulatePrecision.doubleCompare(goods.getSaleAmount(), 0.0, 2) == 0) {
                    goods.setSaleValue(ManipulatePrecision.getDetailOverFlow(disValue, goods.getPrcutMode()));
                } else if (ManipulatePrecision.doubleCompare(goods.getSaleAmount(), disValue, 2) > 0) {
                    String precisionMode = DataExchageUtils.exchangePrecisionMode(goods.getPrcutMode());
                    goods.setBarcodeDiscount(ManipulatePrecision.getDetailOverFlow(goods.getSaleAmount() - disValue, precisionMode));
                }
            }
            goods.setAdjustDiscountValue(this.getAdjustDiscount(goods));
            goods.setTotalDiscountValue(CountZZK.getZZK(goods));
            goods.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(goods.getTotalDiscountValue() - goods.getNoDisAmountValue()));
            goods.setSaleAmount(goods.getSaleValue() - goods.getTotalDiscountValue());
            goods.setDisMode(disMode);
            goods.setDisValue(disValue);
            goods.setDiscType(discType);
            return goods;
        }
        if ("1".equals(discType)) {
            if (disMode == 1 || disMode == 2) {
                return goods;
            }
            if (disMode == 3) {
                if (ManipulatePrecision.doubleCompare(goods.getSaleAmount(), 0.0, 2) == 0) {
                    goods.setSaleValue(ManipulatePrecision.getDetailOverFlow(disValue, goods.getPrcutMode()));
                } else if (ManipulatePrecision.doubleCompare(goods.getSaleAmount(), disValue, 2) > 0) {
                    String precisionMode = DataExchageUtils.exchangePrecisionMode(goods.getPrcutMode());
                    goods.setBarcodeDiscount(ManipulatePrecision.getDetailOverFlow(goods.getSaleAmount() - disValue, precisionMode));
                }
            }
            goods.setAdjustDiscountValue(this.getAdjustDiscount(goods));
            goods.setTotalDiscountValue(CountZZK.getZZK(goods));
            goods.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(goods.getTotalDiscountValue() - goods.getNoDisAmountValue()));
            goods.setSaleAmount(goods.getSaleValue() - goods.getTotalDiscountValue());
            goods.setDisMode(disMode);
            goods.setDisValue(disValue);
            goods.setDiscType(discType);
            return goods;
        }
        return goods;
    }

    @Override
    public Goods calcCustRebateByZkl(Goods goods, double zkl) {
        String precisionMode = DataExchageUtils.exchangePrecisionMode(goods.getPrcutMode());
        double customDiscount = ManipulatePrecision.getDetailOverFlow(goods.getSaleAmount() * ManipulatePrecision.doubleConvert(1.0 - zkl), precisionMode);
        goods.setCustomDiscountValue(customDiscount);
        goods.setTotalDiscountValue(CountZZK.getZZK(goods));
        goods.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(goods.getTotalDiscountValue() - goods.getNoDisAmountValue()));
        goods.setSaleAmount(goods.getSaleValue() - goods.getTotalDiscountValue());
        goods.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(goods.getTotalDiscountValue() - goods.getNoDisAmountValue()));
        return goods;
    }

    @Override
    public Goods calcGoodsBarcodeDiscAfterSingle(Goods goods, int disMode, double disValue, String discType) {
        if ("0".equals(discType)) {
            return goods;
        }
        if ("1".equals(discType)) {
            if (disMode == 1) {
                if (ManipulatePrecision.doubleCompare(disValue, goods.getSaleValue(), 2) >= 0) {
                    goods.setBarcodeDiscount(goods.getSaleValue());
                } else {
                    goods.setBarcodeDiscount(disValue);
                }
            } else if (disMode == 2) {
                String precisionMode = DataExchageUtils.exchangePrecisionMode(goods.getPrcutMode());
                if (ManipulatePrecision.doubleCompare(disValue, 100.0, 2) > 0) {
                    return goods;
                }
                goods.setBarcodeDiscount(ManipulatePrecision.getDetailOverFlow(goods.getSaleValue() * disValue, precisionMode));
            } else if (disMode == 3) {
                return goods;
            }
            goods.setAdjustDiscountValue(this.getAdjustDiscount(goods));
            goods.setTotalDiscountValue(CountZZK.getZZK(goods));
            goods.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(goods.getTotalDiscountValue() - goods.getNoDisAmountValue()));
            goods.setSaleAmount(goods.getSaleValue() - goods.getTotalDiscountValue());
            goods.setDisMode(disMode);
            goods.setDisValue(disValue);
            goods.setDiscType(discType);
            return goods;
        }
        return goods;
    }

    @Override
    public CacheModel addGiftsPrice(CacheModel cacheModel, List<Goods> giftsHaveNoPriceIn) {
        List<Goods> giftsHavePrice = cacheModel.getChoiceGiftsHavePrice();
        List<Goods> giftsHaveNoPrice = cacheModel.getChoiceGiftsHaveNoPrice();
        block0: for (Goods good : giftsHaveNoPriceIn) {
            for (Goods goodTemp : giftsHaveNoPrice) {
                if (!goodTemp.getGuid().equals(good.getGuid())) continue;
                Goods newsg = (Goods)goodTemp.clone();
                newsg.setPopDetailsInfo(new ArrayList<PopDetail>());
                for (PopDetail pop : goodTemp.getPopDetailsInfo()) {
                    PopDetail newPop = (PopDetail)pop.clone();
                    newsg.getPopDetailsInfo().add(newPop);
                }
                newsg.setSalePrice(good.getSalePrice());
                newsg.setSaleValue(ManipulatePrecision.doubleConvert(newsg.getQty() * newsg.getSalePrice(), 2, 1));
                newsg.setSaleAmount(newsg.getSaleValue());
                giftsHavePrice.add(newsg);
                continue block0;
            }
        }
        if (giftsHavePrice.size() > 0) {
            int flowId = cacheModel.getGoodsList().size() + 1;
            for (Goods good : giftsHavePrice) {
                good.setFlowId(flowId);
                cacheModel.getGoodsList().add(good);
                ++flowId;
            }
        }
        cacheModel.getChoiceGiftsHaveNoPrice().clear();
        cacheModel.getChoiceGiftsHavePrice().clear();
        this.calcOrderAmount(cacheModel);
        return cacheModel;
    }

    @Override
    public List<Goods> sortGoodsList(List<Goods> goodsList) {
        goodsList.sort(new Comparator<Goods>(){

            @Override
            public int compare(Goods o1, Goods o2) {
                if (o1.getFlowId() < o2.getFlowId()) {
                    return -1;
                }
                return 0;
            }
        });
        int size = goodsList.size();
        for (int i = 0; i < size; ++i) {
            goodsList.get(i).setFlowId(i + 1);
        }
        return goodsList;
    }

    @Override
    public CacheModel addMarketzk(CacheModel cacheModel, int flow_id) {
        List<Goods> goodsList = cacheModel.getGoodsList();
        Goods goods = goodsList.get(flow_id - 1);
        double marketzk = 0.0;
        if (!goods.isHandmadeFlag()) {
            marketzk = null != cacheModel.getCurGrant() ? cacheModel.getCurGrant().getMarketzk() : cacheModel.getCurSyyInfo().getMarketzk();
            goods.setFdmode("3");
            goods.setFdzkfd(ManipulatePrecision.doubleConvert(marketzk / 100.0, 4, 1));
        }
        goods.setHandmadeNumber(cacheModel.getCurGrant().getGh());
        cacheModel.getGoodsList().set(flow_id - 1, goods);
        return cacheModel;
    }

    @Override
    public CacheModel addMarketzk(CacheModel cacheModel) {
        double marketzk = 0.0;
        marketzk = null != cacheModel.getCurGrant() ? cacheModel.getCurGrant().getMarketzk() : cacheModel.getCurSyyInfo().getMarketzk();
        List<Goods> goodsList = cacheModel.getGoodsList();
        if (null != goodsList && goodsList.size() > 0) {
            for (Goods g : goodsList) {
                if (g.isHandmadeFlag() || ManipulatePrecision.doubleCompare(g.getFdzkfd(), 0.0, 2) > 0) continue;
                g.setFdmode("3");
                g.setFdzkfd(ManipulatePrecision.doubleConvert(marketzk / 100.0, 4, 1));
            }
        }
        cacheModel.setGoodsList(goodsList);
        return cacheModel;
    }

    @Override
    public boolean checkVipzk(OperUser operUser, Goods good) {
        String novipzk = operUser.getNovipzk();
        return !StringUtils.isNotBlank((String)novipzk) || !"N".equals(novipzk) || !StringUtils.isNotBlank((String)good.getDiscountFlag()) || !"1".equals(good.getDiscountFlag());
    }

    @Override
    public CacheModel calcTailPayment(CacheModel cacheModel) {
        if (!cacheModel.getOrder().isDepositSale()) {
            return cacheModel;
        }
        if (ManipulatePrecision.doubleCompare(cacheModel.getOrder().getDepositValue(), 0.0, 2) > 0 && ManipulatePrecision.doubleCompare(cacheModel.getOrder().getExistPay(), cacheModel.getOrder().getDepositValue(), 2) >= 0) {
            return cacheModel;
        }
        String payCode = "";
        String obj = this.redisUtil.get("business:initialize:cacheid:" + cacheModel.getOrder().getShopCode() + cacheModel.getOrder().getTerminalNo());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj.toString(), ModeDetailsVo.class);
        List<Syspara> sysparaOut = modeDetailsVo.getSyspara();
        String paraValue = "";
        paraValue = ModeDetailsVo.getSysParaValue(sysparaOut, "WKFS");
        payCode = paraValue.trim();
        if (null == payCode || payCode.length() == 0) {
            return cacheModel;
        }
        Payment sp = new Payment();
        sp.setPayCode(payCode);
        sp.setPuid(String.valueOf(UniqueID.getUniqueID()));
        sp.setPayName("\u5c3e\u6b3e\u652f\u4ed8");
        sp.setOriginSheetNo(cacheModel.getOrder().getOriginIdSheetNo());
        sp.setAmount(ManipulatePrecision.doubleConvert(cacheModel.getOrder().getOughtPay() - cacheModel.getOrder().getDepositValue(), 2, 1));
        sp.setMoney(sp.getAmount());
        sp.setRate(1.0);
        sp.setFlag("1");
        sp.setPayType("6");
        sp.setIsAutoDelOnly(true);
        sp.setIsDirectDel(false);
        sp.setRowno(cacheModel.getPayments().size() + 1);
        cacheModel.getPayments().add(sp);
        this.calcOrderAmount(cacheModel);
        this.calcPayBalance(cacheModel);
        return cacheModel;
    }

    @Override
    public double getNewRateAmt(double amount, List<Syspara> sysParaList) {
        String[] hlms = null;
        double newRateAmt = 0.0;
        if (sysParaList.size() != 0) {
            for (int i = 0; i < sysParaList.size(); ++i) {
                Syspara sys = sysParaList.get(i);
                if (!sys.getCode().equals("HLMS")) continue;
                hlms = sys.getParavalue().split("\\|");
                break;
            }
        }
        double rate = 1.0;
        String jdms = "";
        String rateMode = "";
        String isOpenRateMode = "";
        if (null != hlms) {
            rate = Double.parseDouble((String)hlms[0]);
            rateMode = hlms[1];
            isOpenRateMode = hlms[2];
            jdms = hlms[5];
        }
        if ("D".equals(rateMode)) {
            newRateAmt = ManipulatePrecision.div(amount, rate);
        } else if ("M".equals(rateMode)) {
            newRateAmt = ManipulatePrecision.mul(amount, rate);
        }
        if (StringUtils.isNotEmpty((String)jdms)) {
            newRateAmt = ManipulatePrecision.getDetailOverFlow(newRateAmt, jdms);
        }
        return newRateAmt;
    }

    @Override
    public void getNewRateAmtForOrder(Order saleOrder) {
        String obj = this.redisUtil.get("business:initialize:cacheid:" + saleOrder.getShopCode() + saleOrder.getTerminalNo());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj.toString(), ModeDetailsVo.class);
        List<Syspara> sysParaList = modeDetailsVo.getSyspara();
        saleOrder.setNewRateExistPay(this.getNewRateAmt(saleOrder.getExistPay(), sysParaList));
        saleOrder.setNewRateOughtPay(this.getNewRateAmt(saleOrder.getOughtPay(), sysParaList));
        double reAmt = saleOrder.getNewRateOughtPay() - saleOrder.getNewRateExistPay();
        if (reAmt > 0.0) {
            saleOrder.setNewRateRemainValue(reAmt);
        } else {
            saleOrder.setNewRateRemainValue(0.0);
        }
        saleOrder.setNewRateSaleValue(this.getNewRateAmt(saleOrder.getSaleValue(), sysParaList));
        saleOrder.setNewRateTotalDiscountValue(this.getNewRateAmt(saleOrder.getTotalDiscountValue(), sysParaList));
    }

    public static void main(String[] args) {
        double i1 = ManipulatePrecision.getMoneyByPrecision(0.009999999999999787, "I", "0.05", false);
        System.out.println(i1);
        int i = ManipulatePrecision.doubleCompare(i1, 0.01, 2);
        System.out.println(i);
        System.out.println(ManipulatePrecision.getDetailOverFlow(4.01, "J"));
        System.out.println(ManipulatePrecision.getMoneyByPrecision(0.05, "I", "0.05"));
        System.out.println(ManipulatePrecision.doubleCompare(ManipulatePrecision.getMoneyByPrecision(0.009999999999999787, "I", "0.05", false), 0.05, 2) >= 0);
    }

    @Override
    public boolean checkEscaleEditFlag(Goods sg) {
        return false;
    }

    @Override
    public boolean checkEscaleEditFlagForDetail(JSONObject obj) {
        return false;
    }

    @Override
    public boolean noPriceEdit(Goods sg) {
        return false;
    }
}

