/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.javaPos.commonkit.beantransfer;

import com.alibaba.fastjson.JSONObject;
import com.efuture.business.bean.SellType;
import com.efuture.business.bean.YPopStatusType;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.javaPos.commonkit.beantransfer.CalcTransfer;
import com.efuture.business.javaPos.commonkit.beantransfer.CouponTransfer;
import com.efuture.business.javaPos.commonkit.beantransfer.GiftTransfer;
import com.efuture.business.javaPos.commonkit.beantransfer.GoodsTransfer;
import com.efuture.business.javaPos.commonkit.beantransfer.OrderTransfer;
import com.efuture.business.javaPos.commonkit.beantransfer.PaymentTransfer;
import com.efuture.business.javaPos.commonkit.beantransfer.PopdetailTransfer;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.ConsumersData;
import com.efuture.business.javaPos.struct.CouponUse;
import com.efuture.business.javaPos.struct.Goods;
import com.efuture.business.javaPos.struct.Order;
import com.efuture.business.javaPos.struct.Payment;
import com.efuture.business.javaPos.struct.PopDetail;
import com.efuture.business.javaPos.struct.mainDataCentre.GoodsInfo;
import com.efuture.business.javaPos.struct.mainDataCentre.request.GetGoodsDetailIn;
import com.efuture.business.javaPos.struct.mainDataCentre.response.GetGoodsDetailOut;
import com.efuture.business.javaPos.struct.promotionCentre.BillDetail;
import com.efuture.business.javaPos.struct.promotionCentre.BillDetailSimple;
import com.efuture.business.javaPos.struct.promotionCentre.SellConsData;
import com.efuture.business.javaPos.struct.promotionCentre.SellCouponUse;
import com.efuture.business.javaPos.struct.promotionCentre.SellDetail;
import com.efuture.business.javaPos.struct.promotionCentre.SellPayment;
import com.efuture.business.javaPos.struct.promotionCentre.SellPopDetail;
import com.efuture.business.javaPos.struct.promotionCentre.request.CalSaleReturnIn;
import com.efuture.business.javaPos.struct.promotionCentre.request.CalcIn;
import com.efuture.business.javaPos.struct.promotionCentre.request.CalcSimpleTagIn;
import com.efuture.business.javaPos.struct.promotionCentre.request.CalcsingleIn;
import com.efuture.business.javaPos.struct.promotionCentre.request.CouponGainCalcIn;
import com.efuture.business.javaPos.struct.promotionCentre.request.CouponPayIn;
import com.efuture.business.javaPos.struct.promotionCentre.request.CouponuseGetOnlineIn;
import com.efuture.business.javaPos.struct.promotionCentre.request.PointsPayIn;
import com.efuture.business.javaPos.struct.request.AddBatchGoodsIn;
import com.efuture.business.javaPos.struct.request.AddQrCodeTicketIn;
import com.efuture.business.javaPos.struct.request.CouponQueryIn;
import com.efuture.business.javaPos.struct.request.QueryGoodIn;
import com.efuture.business.javaPos.struct.request.SkuSearchIn;
import com.efuture.business.util.DataExchageUtils;
import com.efuture.business.util.UniqueID;
import com.product.model.ServiceSession;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class CalcTransferImpl
implements CalcTransfer {
    private static final Logger log = LoggerFactory.getLogger(CalcTransferImpl.class);
    @Autowired
    public OrderTransfer orderTransfer;
    @Autowired
    public GoodsTransfer goodsTransfer;
    @Autowired
    public PaymentTransfer paymentTransfer;
    @Autowired
    public PopdetailTransfer popdetailTransfer;
    @Autowired
    public CouponTransfer couponTransfer;
    @Autowired
    public GiftTransfer giftTransfer;

    @Override
    public CalcIn calcfromCacheModel(CacheModel cacheModel, boolean isNewCalcId, boolean isRemoveAdjustDisc) {
        return this.calcfromCacheModel(cacheModel, isNewCalcId, isRemoveAdjustDisc, false);
    }

    @Override
    public CalcIn calcfromCacheModel(CacheModel cacheModel, boolean isNewCalcId, boolean isRemoveAdjustDisc, boolean isNeedPopDetail) {
        return this.calcfromCacheModel(cacheModel, isNewCalcId, isRemoveAdjustDisc, isNeedPopDetail, false);
    }

    @Override
    public CalcIn calcfromCacheModel(CacheModel cacheModel, boolean isNewCalcId, boolean isRemoveAdjustDisc, boolean isNeedPopDetail, boolean isPrecision) {
        CalcIn calcIn = new CalcIn();
        Order order = cacheModel.getOrder();
        calcIn.setCalcMode(order.getCalcMarketingMode());
        calcIn.setCalcBillid(order.getSeqNo());
        calcIn.setBillDetail(this.orderTransfer.transferBillDetail(order));
        List<SellPayment> pays = this.paymentTransfer.transferSellPayment(cacheModel.getPayments(), SellType.ISBACK(order.getOrderType()));
        if (pays == null) {
            pays = new ArrayList<SellPayment>();
        }
        if (null == calcIn.getBillDetail().getSellPayments()) {
            calcIn.getBillDetail().setSellPayments(new ArrayList<SellPayment>());
        }
        calcIn.getBillDetail().setSellPayments(pays);
        ArrayList<SellDetail> sellDetails = new ArrayList<SellDetail>();
        for (Goods goods : cacheModel.getGoodsList()) {
            SellDetail sellDetail = this.goodsToSellDetail(goods, order, isRemoveAdjustDisc, isNewCalcId, isNeedPopDetail, isPrecision);
            sellDetails.add(sellDetail);
        }
        if (null == calcIn.getBillDetail().getSellDetails()) {
            calcIn.getBillDetail().setSellDetails(new ArrayList<SellDetail>());
        }
        calcIn.getBillDetail().setSellDetails(sellDetails);
        return calcIn;
    }

    @Override
    public SellDetail goodsToSellDetail(Goods goods, Order order, boolean isRemoveAdjustDisc, boolean isNewCalcId, boolean isNeedPopDetail) {
        return this.goodsToSellDetail(goods, order, isRemoveAdjustDisc, isNewCalcId, isNeedPopDetail, false);
    }

    @Override
    public SellDetail goodsToSellDetail(Goods goods, Order order, boolean isRemoveAdjustDisc, boolean isNewCalcId, boolean isNeedPopDetail, boolean isPrecision) {
        SellDetail sellDetail = this.goodsTransfer.transferSellDetail(goods, order, isRemoveAdjustDisc, isNewCalcId, isNeedPopDetail, isPrecision);
        sellDetail.setCouponGains(this.couponTransfer.transferSellCouponGain(goods.getCouponGains()));
        return sellDetail;
    }

    @Override
    public CalcSimpleTagIn calcSimpleTagInTransfer(QueryGoodIn queryGoodIn, Goods goods) {
        BillDetailSimple billDetailSimple = new BillDetailSimple();
        SimpleDateFormat format = new SimpleDateFormat("YYYY-MM-dd HH:mm:ss");
        billDetailSimple.setChannel(queryGoodIn.getChannel());
        billDetailSimple.setSaleDate(format.format(new Date()));
        billDetailSimple.setMarket(queryGoodIn.getShopCode());
        ArrayList<SellDetail> sellDetails = new ArrayList<SellDetail>();
        SellDetail sellDetail = new SellDetail();
        sellDetail.setManaUnit(queryGoodIn.getErpCode());
        sellDetail.setGz(goods.getOrgCode());
        sellDetail.setMarket(queryGoodIn.getShopCode());
        sellDetail.setContract(queryGoodIn.getShopCode());
        sellDetail.setItemCode(goods.getGoodsCode());
        sellDetail.setItemName(goods.getGoodsName());
        sellDetail.setBarcode(goods.getBarNo());
        sellDetail.setUnitcode(goods.getSaleUnit());
        sellDetail.setFactor(goods.getPartsNum());
        sellDetail.setBrand(goods.getBrandCode());
        sellDetail.setCategory(goods.getCategoryCode());
        sellDetail.setQty(goods.getQty());
        sellDetail.setPrice(goods.getSalePrice());
        sellDetail.setListAmount(goods.getSaleValue());
        sellDetail.setTotalDiscount(goods.getTotalDiscountValue());
        sellDetail.setSaleAmount(goods.getSaleAmount());
        sellDetail.setSupplier(goods.getVenderId());
        sellDetails.add(sellDetail);
        billDetailSimple.setSellDetails(sellDetails);
        billDetailSimple.setConsumersType("01");
        CalcSimpleTagIn calcSimpleTagIn = new CalcSimpleTagIn();
        calcSimpleTagIn.setBillDetail(billDetailSimple);
        return calcSimpleTagIn;
    }

    @Override
    public CalcSimpleTagIn calcSimpleTagInTransfer(SkuSearchIn skuQueryIn, Goods goods) {
        BillDetailSimple billDetailSimple = new BillDetailSimple();
        SimpleDateFormat format = new SimpleDateFormat("YYYY-MM-dd HH:mm:ss");
        billDetailSimple.setChannel("" + skuQueryIn.getChannel());
        billDetailSimple.setSaleDate(format.format(new Date()));
        ArrayList<SellDetail> sellDetails = new ArrayList<SellDetail>();
        SellDetail sellDetail = new SellDetail();
        sellDetail.setManaUnit(skuQueryIn.getErpCode());
        sellDetail.setGz(goods.getOrgCode());
        sellDetail.setMarket(skuQueryIn.getShopCode());
        sellDetail.setContract(skuQueryIn.getShopCode());
        sellDetail.setItemCode(goods.getGoodsCode());
        sellDetail.setItemName(goods.getGoodsName());
        sellDetail.setBarcode(goods.getBarNo());
        sellDetail.setUnitcode(goods.getSaleUnit());
        sellDetail.setFactor(goods.getPartsNum());
        sellDetail.setBrand(goods.getBrandCode());
        sellDetail.setCategory(goods.getCategoryCode());
        sellDetail.setQty(goods.getQty());
        sellDetail.setPrice(goods.getSalePrice());
        sellDetail.setListAmount(goods.getSaleValue());
        sellDetail.setTotalDiscount(goods.getTotalDiscountValue());
        sellDetail.setSaleAmount(goods.getSaleAmount());
        sellDetail.setSupplier(goods.getVenderId());
        sellDetails.add(sellDetail);
        billDetailSimple.setSellDetails(sellDetails);
        billDetailSimple.setConsumersType("01");
        CalcSimpleTagIn calcSimpleTagIn = new CalcSimpleTagIn();
        calcSimpleTagIn.setBillDetail(billDetailSimple);
        return calcSimpleTagIn;
    }

    @Override
    public CalcsingleIn calcsingleInBuild(Goods goods, SkuSearchIn skuSearchIn) {
        CalcsingleIn calcsingleIn = new CalcsingleIn();
        calcsingleIn.setCalcMode("0");
        BillDetail billDetail = new BillDetail();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        billDetail.setChannel("" + skuSearchIn.getChannel());
        billDetail.setSaleDate(format.format(new Date()));
        billDetail.setTermInvoiceNo(1L);
        billDetail.setMarket(skuSearchIn.getShopCode());
        billDetail.setTermNo(skuSearchIn.getTerminalNo());
        ArrayList<SellDetail> sellDetails = new ArrayList<SellDetail>();
        SellDetail sellDetail = new SellDetail();
        sellDetail.setRowNo(goods.getFlowId());
        sellDetail.setFlag(goods.getFlag());
        if (null != goods.getSGoodsSno() && goods.getSGoodsSno().length() > 0) {
            sellDetail.setFlag("3");
        }
        sellDetail.setKlm(goods.getKlm());
        sellDetail.setOriginalRowNo(1);
        sellDetail.setGz(goods.getOrgCode());
        sellDetail.setMarket(skuSearchIn.getShopCode());
        sellDetail.setContract(skuSearchIn.getShopCode());
        sellDetail.setItemCode(goods.getGoodsCode());
        sellDetail.setItemName(goods.getGoodsName());
        sellDetail.setBarcode(goods.getBarNo());
        sellDetail.setUnitcode(goods.getSaleUnit());
        sellDetail.setFactor(goods.getPartsNum());
        sellDetail.setBrand(goods.getBrandCode());
        sellDetail.setCategory(goods.getCategoryCode());
        sellDetail.setQty(goods.getQty());
        sellDetail.setPrice(goods.getSalePrice());
        sellDetail.setListAmount(goods.getSaleValue());
        sellDetail.setTotalDiscount(goods.getAdjustDiscountValue());
        sellDetail.setSaleAmount(goods.getSaleAmount());
        sellDetail.setNojf(goods.getNojf());
        sellDetail.setManaUnit(skuSearchIn.getErpCode());
        sellDetail.setSupplier(goods.getVenderId());
        sellDetails.add(sellDetail);
        billDetail.setSellDetails(sellDetails);
        calcsingleIn.setBillDetail(billDetail);
        return calcsingleIn;
    }

    @Override
    public CalcsingleIn calcsingleInBuild(GoodsInfo goods, GetGoodsDetailIn skuSearchIn) {
        CalcsingleIn calcsingleIn = new CalcsingleIn();
        calcsingleIn.setCalcMode("0");
        BillDetail billDetail = new BillDetail();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        billDetail.setChannel(skuSearchIn.getChannel());
        billDetail.setSaleDate(format.format(new Date()));
        billDetail.setTermInvoiceNo(1L);
        billDetail.setMarket(skuSearchIn.getShopCode());
        billDetail.setTermNo(skuSearchIn.getTerminalNo());
        billDetail.setConsumersType("01");
        ArrayList<SellDetail> sellDetails = new ArrayList<SellDetail>();
        SellDetail sellDetail = new SellDetail();
        sellDetail.setRowNo(1);
        sellDetail.setFlag("1");
        if ("9".equals(goods.getGoodsType())) {
            sellDetail.setFlag("3");
        }
        sellDetail.setKlm(goods.getKlm());
        sellDetail.setOriginalRowNo(1);
        sellDetail.setGz(goods.getOrgCode());
        sellDetail.setMarket(skuSearchIn.getShopCode());
        sellDetail.setContract(skuSearchIn.getShopCode());
        sellDetail.setItemCode(goods.getGoodsCode());
        sellDetail.setItemName(goods.getGoodsName());
        sellDetail.setBarcode(goods.getBarNo());
        sellDetail.setUnitcode(goods.getPartsUnit());
        sellDetail.setFactor(goods.getPartsNum());
        sellDetail.setBrand(goods.getBrandId());
        sellDetail.setCategory(goods.getCategoryCode());
        sellDetail.setQty(1.0);
        sellDetail.setPrice(goods.getSalePrice());
        sellDetail.setListAmount(goods.getSalePrice());
        sellDetail.setSaleAmount(goods.getSalePrice());
        sellDetail.setManaUnit(skuSearchIn.getErpCode());
        sellDetail.setSupplier(goods.getVenderId());
        sellDetails.add(sellDetail);
        billDetail.setSellDetails(sellDetails);
        calcsingleIn.setBillDetail(billDetail);
        return calcsingleIn;
    }

    @Override
    public CalcsingleIn calcsingleInBuild(Goods goods, QueryGoodIn queryGoodIn, int ypopDzcMode) {
        CalcsingleIn calcsingleIn = new CalcsingleIn();
        calcsingleIn.setCalcMode("0");
        BillDetail billDetail = new BillDetail();
        if (StringUtils.isNotBlank((String)queryGoodIn.getDate())) {
            billDetail.setSaleDate(queryGoodIn.getDate());
        } else {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            billDetail.setSaleDate(format.format(new Date()));
        }
        billDetail.setChannel(queryGoodIn.getChannel());
        billDetail.setTermInvoiceNo(1L);
        billDetail.setMarket(queryGoodIn.getShopCode());
        billDetail.setTermNo(queryGoodIn.getTerminalNo());
        billDetail.setManaUnit(queryGoodIn.getErpCode());
        ArrayList<SellDetail> sellDetails = new ArrayList<SellDetail>();
        SellDetail sellDetail = new SellDetail();
        sellDetail.setRowNo(goods.getFlowId());
        sellDetail.setFlag(goods.getFlag());
        if (null != goods.getSGoodsSno() && goods.getSGoodsSno().length() > 0) {
            sellDetail.setFlag("3");
        }
        if ("Y".equals(goods.getEscaleFlag())) {
            if (0 == ypopDzcMode) {
                sellDetail.setFlag("1");
            }
            if (1 == ypopDzcMode) {
                sellDetail.setFlag("4");
            } else if (2 == ypopDzcMode) {
                sellDetail.setFlag("4");
                if (goods.getEWCCodeAmount() > 0.0 && goods.getEWCCodeNum() <= 0.0) {
                    sellDetail.setFlag("E");
                }
            }
        }
        sellDetail.setKlm(goods.getKlm());
        sellDetail.setOriginalRowNo(1);
        sellDetail.setGz(goods.getOrgCode());
        sellDetail.setMarket(queryGoodIn.getShopCode());
        sellDetail.setContract(queryGoodIn.getShopCode());
        sellDetail.setItemCode(goods.getGoodsCode());
        sellDetail.setItemName(goods.getGoodsName());
        sellDetail.setBarcode(goods.getBarNo());
        sellDetail.setUnitcode(goods.getGoodsUid());
        sellDetail.setFactor(goods.getPartsNum());
        sellDetail.setBrand(goods.getBrandCode());
        sellDetail.setCategory(goods.getCategoryCode());
        sellDetail.setQty(goods.getQty());
        sellDetail.setPrice(goods.getSalePrice());
        sellDetail.setListAmount(goods.getSaleValue());
        sellDetail.setTotalDiscount(goods.getTotalDiscountValue());
        sellDetail.setSaleAmount(goods.getSaleAmount());
        sellDetail.setNojf(goods.getNojf());
        sellDetail.setManaUnit(queryGoodIn.getErpCode());
        sellDetail.setCounter(goods.getSeason());
        sellDetail.setSupplier(goods.getVenderCode());
        sellDetails.add(sellDetail);
        billDetail.setSellDetails(sellDetails);
        calcsingleIn.setBillDetail(billDetail);
        return calcsingleIn;
    }

    @Override
    public CalcsingleIn buildAddGoodsCalc(ServiceSession session, AddBatchGoodsIn in, GetGoodsDetailOut goodsDetail, String consumersId, String qty) {
        GoodsInfo goodsInfo = goodsDetail.getGoods().get(0);
        CalcsingleIn calcsingleIn = new CalcsingleIn();
        calcsingleIn.setCalcMode(in.getCalcMode());
        BillDetail billDetail = new BillDetail();
        billDetail.setConsumersCardNo(consumersId);
        billDetail.setConsumersId(in.getConsumersId());
        billDetail.setConsumersType(in.getConsumersType());
        SellConsData sellConsData = new SellConsData();
        ArrayList<String> consumersGrps = new ArrayList<String>();
        consumersGrps.add(in.getConsumersTrgs());
        sellConsData.setConsumersGrps(consumersGrps);
        billDetail.setConsumersData(sellConsData);
        billDetail.setBillNo(in.getFlowNo());
        ArrayList<SellDetail> sellDetails = new ArrayList<SellDetail>();
        SellDetail sellDetail = new SellDetail();
        sellDetail.setQty(new Integer(qty).intValue());
        sellDetail.setPrice(goodsInfo.getSalePrice());
        sellDetail.setBarcode(goodsInfo.getBarNo());
        sellDetail.setMarket(in.getShopCode());
        sellDetails.add(sellDetail);
        billDetail.setSellDetails(sellDetails);
        calcsingleIn.setBillDetail(billDetail);
        return calcsingleIn;
    }

    @Override
    public CalcsingleIn buildGetSaleGoodsInfoCalc(ServiceSession session, String calcMode, Goods goods, Order order, boolean isRefreshBillId, boolean isNeedPopDetail) {
        CalcsingleIn calcsingleIn = new CalcsingleIn();
        calcsingleIn.setCalcMode(calcMode);
        BillDetail billDetail = this.orderTransfer.transferBillDetail(order);
        ArrayList<SellDetail> sellDetails = new ArrayList<SellDetail>();
        SellDetail transferSellDetail = this.transferSellDetail(goods, order, false, isNeedPopDetail);
        sellDetails.add(transferSellDetail);
        if (!isRefreshBillId) {
            calcsingleIn.setCalcBillid(order.getSeqNo());
        }
        billDetail.setSellDetails(sellDetails);
        calcsingleIn.setBillDetail(billDetail);
        return calcsingleIn;
    }

    @Override
    public CalcsingleIn buildGetSaleGoodsInfoCalc(ServiceSession session, String calcMode, Goods goods, Order order, boolean isRefreshBillId) {
        return this.buildGetSaleGoodsInfoCalc(session, calcMode, goods, order, isRefreshBillId, false);
    }

    @Override
    public CalcsingleIn buildAddBatchGoodsCalc(ServiceSession session, List<Goods> goodsList, Order order) {
        CalcsingleIn calcsingleIn = new CalcsingleIn();
        calcsingleIn.setCalcMode("0");
        BillDetail billDetail = this.orderTransfer.transferBillDetail(order);
        ArrayList<SellDetail> sellDetails = new ArrayList<SellDetail>();
        for (Goods goods : goodsList) {
            SellDetail transferSellDetail = this.goodsTransfer.transferSellDetail(goods, order, true, false);
            sellDetails.add(transferSellDetail);
        }
        billDetail.setSellDetails(sellDetails);
        calcsingleIn.setBillDetail(billDetail);
        calcsingleIn.setCalcBillid("");
        return calcsingleIn;
    }

    @Override
    public CalcsingleIn memberLoginCreateCalcsingleIn(Order order, List<Goods> goodsList, boolean isnewCalc) {
        return this.memberLoginCreateCalcsingleIn(order, goodsList, isnewCalc, true);
    }

    @Override
    public CalcsingleIn memberLoginCreateCalcsingleIn(Order order, List<Goods> goodsList, boolean isnewCalc, boolean isMember) {
        CalcsingleIn calcsingleIn = new CalcsingleIn();
        BillDetail billDetail = this.orderTransfer.transferBillDetail(order);
        List<SellDetail> sellDetails = this.goodsTransfer.transferSellDetail(goodsList, order, true, isnewCalc, isMember);
        for (Goods goods : goodsList) {
            for (int i = 0; i < sellDetails.size(); ++i) {
                SellDetail sellDetail = sellDetails.get(i);
                if (goods.getFlowId() != sellDetail.getRowNo()) continue;
                if (null != sellDetail.getSellPopDetails()) {
                    List<SellPopDetail> sellPopDetails = this.popdetailTransfer.transferSellPopDetail(goods.getPopDetailsInfo(), order, goods);
                    if (null == sellPopDetails) continue;
                    sellDetail.getSellPopDetails().addAll(sellPopDetails);
                    continue;
                }
                sellDetail.setSellPopDetails(this.popdetailTransfer.transferSellPopDetail(goods.getPopDetailsInfo(), order, goods));
            }
        }
        billDetail.setSellDetails(sellDetails);
        calcsingleIn.setBillDetail(billDetail);
        calcsingleIn.setCalcMode(order.getCalcMarketingMode());
        calcsingleIn.setCalcBillid(order.getSeqNo());
        calcsingleIn.setCalcMode("0");
        calcsingleIn.setCalcBillid(null);
        return calcsingleIn;
    }

    @Override
    public CalSaleReturnIn calSaleReturnInBuild(CacheModel cacheModel, String refundCalcMode, boolean isNewCalc) {
        CalSaleReturnIn calSaleReturnIn = new CalSaleReturnIn();
        Order order = cacheModel.getOrder();
        List<Goods> goodsList = cacheModel.getGoodsList();
        calSaleReturnIn.setCalcMode("0");
        BillDetail billDetail = this.orderTransfer.transferBillDetail(order);
        billDetail.setReturnMode(refundCalcMode);
        billDetail.setSellDetails(this.goodsTransfer.transferSellDetail(goodsList, order, false, false));
        if (!isNewCalc) {
            calSaleReturnIn.setCalcBillid(cacheModel.getOrder().getSeqNo());
        }
        calSaleReturnIn.setBillDetail(billDetail);
        return calSaleReturnIn;
    }

    @Override
    public CouponPayIn transferAddQrCodeIn(CacheModel cacheModel, AddQrCodeTicketIn addQrCodeIn) {
        CouponPayIn couponPayIn = new CouponPayIn();
        Order order = cacheModel.getOrder();
        List<Goods> goods = cacheModel.getGoodsList();
        List<Payment> payments = cacheModel.getPayments();
        couponPayIn.setAccntNo(addQrCodeIn.getQrCode());
        couponPayIn.setCalcBillid(order.getSeqNo());
        couponPayIn.setChannelId(cacheModel.getOrder().getChannel());
        couponPayIn.setConsumersId(addQrCodeIn.getConsumersId());
        couponPayIn.setConsumersType(addQrCodeIn.getConsumersType());
        couponPayIn.setPayCode(addQrCodeIn.getPayCode());
        couponPayIn.setCouponGroup("02,05");
        couponPayIn.setRownoid(UniqueID.getUniqueID(cacheModel.getOrder().getTerminalSno()));
        if (addQrCodeIn.getAmount() > 0.0) {
            couponPayIn.setPayje(addQrCodeIn.getAmount());
        }
        if ("3".equals(addQrCodeIn.getScene())) {
            couponPayIn.setStatus("8");
        }
        BillDetail billDetail = this.orderTransfer.transferBillDetail(order);
        billDetail.setSellDetails(this.goodsTransfer.transferSellDetail(goods, order, false, false));
        billDetail.setSellPayments(this.paymentTransfer.transferSellPayment(payments, SellType.ISBACK(order.getOrderType())));
        if (billDetail.getSellPayments() == null) {
            billDetail.setSellPayments(new ArrayList<SellPayment>());
        }
        double changePay = 0.0;
        for (Payment payment : payments) {
            if (!payment.getFlag().trim().equals("2")) continue;
            changePay += payment.getMoney();
        }
        billDetail.setChangePay(changePay);
        billDetail.setConsumersType(addQrCodeIn.getConsumersType());
        billDetail.setConsumersCardNo(addQrCodeIn.getConsumersCard());
        SellConsData consumersData = new SellConsData();
        consumersData.setConsumersGrps(addQrCodeIn.getConsumersTrgs());
        billDetail.setConsumersData(consumersData);
        couponPayIn.setBillDetail(billDetail);
        return couponPayIn;
    }

    @Override
    public CouponuseGetOnlineIn transferCouponGetIn(CacheModel cacheModel, CouponQueryIn couponQueryIn) {
        List<SellPayment> sellPayments;
        Order order = cacheModel.getOrder();
        List<Payment> payments = cacheModel.getPayments();
        CouponuseGetOnlineIn couponuseGetOnlineIn = new CouponuseGetOnlineIn();
        couponuseGetOnlineIn.setCalcBillid(cacheModel.getOrder().getSeqNo());
        couponuseGetOnlineIn.setChannelId(cacheModel.getOrder().getChannel());
        couponuseGetOnlineIn.setConsumersId(couponQueryIn.getConsumersId());
        couponuseGetOnlineIn.setCouponGroup(couponQueryIn.getCouponGroup());
        couponuseGetOnlineIn.setDistinct(couponQueryIn.getDistinct());
        couponuseGetOnlineIn.setPayCode(couponQueryIn.getPayCode());
        if (!SellType.ISSALE(cacheModel.getOrder().getOrderType())) {
            couponuseGetOnlineIn.setStatus("7");
        }
        if (null == (sellPayments = this.paymentTransfer.transferSellPayment(payments, SellType.ISBACK(order.getOrderType())))) {
            sellPayments = new ArrayList<SellPayment>();
        }
        couponuseGetOnlineIn.setSellPayments(sellPayments);
        return couponuseGetOnlineIn;
    }

    @Override
    public CouponuseGetOnlineIn transferCouponGetIn2(CouponQueryIn couponQueryIn) {
        CouponuseGetOnlineIn couponuseGetOnlineIn = new CouponuseGetOnlineIn();
        couponuseGetOnlineIn.setCalcBillid("");
        couponuseGetOnlineIn.setChannelId(couponQueryIn.getChannel());
        couponuseGetOnlineIn.setConsumersId(couponQueryIn.getConsumersId());
        couponuseGetOnlineIn.setCouponGroup(couponQueryIn.getCouponGroup());
        couponuseGetOnlineIn.setDistinct(couponQueryIn.getDistinct());
        return couponuseGetOnlineIn;
    }

    @Override
    public CouponuseGetOnlineIn transferCouponGetIn(CacheModel cacheModel, AddQrCodeTicketIn in) {
        List<SellPayment> sellPayments;
        List<Payment> payments = cacheModel.getPayments();
        CouponuseGetOnlineIn couponuseGetOnlineIn = new CouponuseGetOnlineIn();
        couponuseGetOnlineIn.setCalcBillid(cacheModel.getOrder().getSeqNo());
        couponuseGetOnlineIn.setChannelId(cacheModel.getOrder().getChannel());
        couponuseGetOnlineIn.setConsumersId(in.getConsumersId());
        couponuseGetOnlineIn.setCouponGroup("02,05");
        couponuseGetOnlineIn.setConsumersId(in.getQrCode());
        couponuseGetOnlineIn.setPayCode(in.getPayCode());
        if (!SellType.ISSALE(cacheModel.getOrder().getOrderType())) {
            couponuseGetOnlineIn.setStatus("7");
        }
        if (null == (sellPayments = this.paymentTransfer.transferSellPayment(payments, SellType.ISBACK(cacheModel.getOrder().getOrderType())))) {
            sellPayments = new ArrayList<SellPayment>();
        }
        couponuseGetOnlineIn.setSellPayments(sellPayments);
        return couponuseGetOnlineIn;
    }

    @Override
    public PointsPayIn transferPointsPayIn(CacheModel cacheModel, PointsPayIn pointsPayIn) {
        PointsPayIn pointsPayIn1 = new PointsPayIn();
        Order order = cacheModel.getOrder();
        ConsumersData member = order.getConsumersData();
        List<Goods> goods = cacheModel.getGoodsList();
        List<Payment> payments = cacheModel.getPayments();
        pointsPayIn1.setAccntNo(pointsPayIn.getAccntNo());
        pointsPayIn1.setCalcBillid(order.getSeqNo());
        pointsPayIn1.setChannelId(cacheModel.getOrder().getChannel());
        pointsPayIn1.setConsumersId(member.getConsumersId());
        pointsPayIn1.setPayCode(pointsPayIn.getPayCode());
        pointsPayIn1.setPayje(pointsPayIn.getPayje());
        pointsPayIn1.setConsumersId(member.getConsumersId());
        pointsPayIn1.setCouponGroup("01");
        BillDetail billDetail = this.orderTransfer.transferBillDetail(order);
        billDetail.setSellDetails(this.goodsTransfer.transferSellDetail(goods, order, false, false));
        billDetail.setSellPayments(this.paymentTransfer.transferSellPayment(payments, SellType.ISBACK(order.getOrderType())));
        if (billDetail.getSellPayments() == null) {
            billDetail.setSellPayments(new ArrayList<SellPayment>());
        }
        double changePay = 0.0;
        for (Payment payment : payments) {
            if (!payment.getFlag().trim().equals("2")) continue;
            changePay += payment.getMoney();
        }
        billDetail.setChangePay(changePay);
        billDetail.setConsumersType(member.getConsumersType());
        billDetail.setConsumersCardNo(member.getConsumersCard());
        pointsPayIn1.setBillDetail(billDetail);
        return pointsPayIn1;
    }

    @Override
    public CouponGainCalcIn couponGainCalcInFromCacheModel(CacheModel cacheModel) {
        return this.couponGainCalcInFromCacheModel(cacheModel, false);
    }

    @Override
    public CouponGainCalcIn couponGainCalcInFromCacheModel(CacheModel cacheModel, boolean isNeedPop) {
        CouponGainCalcIn couponGainCalcIn = new CouponGainCalcIn();
        Order order = cacheModel.getOrder();
        cacheModel.getOrder().setCalcMarketingMode("0");
        couponGainCalcIn.setCalcMode(cacheModel.getOrder().getCalcMarketingMode());
        if (SellType.ISEXERCISE(cacheModel.getOrder().getOrderType())) {
            couponGainCalcIn.setCalcMode("PRE");
        }
        couponGainCalcIn.setCalcBillid(order.getSeqNo());
        couponGainCalcIn.setBillDetail(this.orderTransfer.transferBillDetail(order));
        ArrayList<SellDetail> sellDetails = new ArrayList<SellDetail>();
        for (Goods goods : cacheModel.getGoodsList()) {
            SellDetail sellDetail = this.goodsToSellDetail(goods, order, isNeedPop);
            sellDetails.add(sellDetail);
        }
        couponGainCalcIn.getBillDetail().setSellDetails(sellDetails);
        if (!SellType.ISBACK(order.getOrderType()) || SellType.ISBACK(order.getOrderType()) && StringUtils.isBlank((String)order.getOriginTerminalSno())) {
            couponGainCalcIn.getBillDetail().setSellPayments(this.paymentTransfer.transferSellPayment(cacheModel.getPayments(), SellType.ISBACK(order.getOrderType())));
        } else {
            couponGainCalcIn.getBillDetail().setSellPayments(this.paymentTransfer.transferSellPaymentForReturn(cacheModel));
        }
        return couponGainCalcIn;
    }

    @Override
    public SellDetail goodsToSellDetail(Goods goods, Order order, boolean isneedpopdetail) {
        SellDetail sellDetail = this.goodsTransfer.transferSellDetail(goods, order, false, false, isneedpopdetail, false);
        return sellDetail;
    }

    @Override
    public SellDetail transferSellDetail(Goods goods, Order order, boolean isRemoveAdjustDisc, boolean isNewCalcId) {
        return this.goodsTransfer.transferSellDetail(goods, order, isRemoveAdjustDisc, isNewCalcId, false);
    }

    @Override
    public SellDetail transferSellDetail(Goods goods, Order order, boolean isRemoveAdjustDisc, boolean isNewCalcId, boolean isNeedPopDetail) {
        return this.goodsTransfer.transferSellDetail(goods, order, isRemoveAdjustDisc, isNewCalcId, false, false);
    }

    @Override
    public SellDetail transferSellDetail(Goods goods, Order order, boolean isRemoveAdjustDisc, boolean isNewCalcId, boolean isNeedPopDetail, boolean isPrecision) {
        log.info("transferSellDetail  goods==>{}", (Object)JSONObject.toJSONString((Object)goods));
        goods.setTempPopDetails(new ArrayList<PopDetail>());
        SellDetail sellDetail = new SellDetail();
        sellDetail.setRowNo(goods.getFlowId());
        sellDetail.setFlag(goods.getFlag());
        if (StringUtils.isNotBlank((String)goods.getSGoodsSno())) {
            sellDetail.setFlag("3");
        }
        sellDetail.setKlm(goods.getSeason());
        sellDetail.setOriginalBillNo(order.getOriginSeqNo());
        if (goods.getOriginalFlowId() != null) {
            sellDetail.setOriginalRowNo(goods.getOriginalFlowId());
        }
        sellDetail.setGz(goods.getOrgCode());
        sellDetail.setMarket(order.getShopCode());
        sellDetail.setContract(goods.getContractCode());
        sellDetail.setItemCode(goods.getGoodsCode());
        sellDetail.setItemName(goods.getGoodsName());
        sellDetail.setBarcode(goods.getBarNo());
        sellDetail.setUnitcode(goods.getGoodsUid());
        sellDetail.setFactor(goods.getPartsNum());
        sellDetail.setBrand(goods.getBrandCode());
        sellDetail.setCategory(goods.getCategoryCode());
        sellDetail.setQty(goods.getQty());
        sellDetail.setPrice(goods.getSalePrice());
        sellDetail.setListAmount(goods.getSaleValue());
        sellDetail.setTotalDiscount(goods.getTotalDiscountValue());
        sellDetail.setSaleAmount(goods.getSaleAmount());
        sellDetail.setNojf(goods.getNojf());
        sellDetail.setManaUnit(order.getErpCode());
        sellDetail.setCounter(goods.getSeason());
        sellDetail.setSupplier(goods.getVenderCode());
        sellDetail.setQtyrecalc(goods.getQtyrecalc());
        if (!isNewCalcId) {
            sellDetail.setQtyrecalcAmount(goods.getQtyrecalcAmount());
            sellDetail.setQtyrecalcEvtid(goods.getQtyrecalcEvtid());
        }
        if (goods.getIsNoBackGift()) {
            sellDetail.setPopTag("Y");
            sellDetail.setFlag("0");
        }
        if (StringUtils.isNotBlank((String)order.getStaffCardNo())) {
            sellDetail.setPopTag("S");
        }
        if ("32".equals(goods.getGoodsType())) {
            sellDetail.setPopTag("M");
        }
        if (order.getHasGroupBuy()) {
            sellDetail.setPopTag("G");
        }
        if ("YS1".equals(order.getOrderType())) {
            sellDetail.setPopTag("PRESALE");
        }
        if (StringUtils.isNotBlank((String)goods.getDiscountFlag()) && ("0".equals(goods.getDiscountFlag()) || "1".equals(goods.getDiscountFlag()))) {
            sellDetail.setPopTag(goods.getDiscountFlag());
        }
        if (SellType.NOPOP(order.getOrderType())) {
            sellDetail.setFlag("Z");
        }
        if ("Z1".equals(order.getOrderType()) || "Z2".equals(order.getOrderType())) {
            sellDetail.setFlag("J");
        }
        if (3 == order.getPopMode()) {
            sellDetail.setFlag("J");
        }
        if (4 == order.getPopMode()) {
            sellDetail.setFlag("Z");
        }
        if (null != order.getConsumersData() && "MOHO".equals(order.getConsumersData().getConsumersType())) {
            sellDetail.setFlag("Z");
        }
        if ("Y".equals(goods.getEscaleFlag())) {
            if (0 == order.getSysPara().getYpopDzcMode()) {
                sellDetail.setFlag("1");
            }
            if (1 == order.getSysPara().getYpopDzcMode()) {
                sellDetail.setFlag("4");
            } else if (2 == order.getSysPara().getYpopDzcMode() || 3 == order.getSysPara().getYpopDzcMode()) {
                sellDetail.setFlag("1");
                if (goods.getEWCCodeAmount() > 0.0 && goods.getEWCCodeNum() <= 0.0) {
                    sellDetail.setFlag("E");
                    if (isNewCalcId) {
                        sellDetail.setQty(goods.getQuantityRecalc());
                        sellDetail.setSaleAmount(goods.getEWCCodeAmount());
                        sellDetail.setQtyrecalc(0);
                    }
                    if (ManipulatePrecision.doubleCompare(goods.getListPrice(), 0.0, 2) == 0) {
                        sellDetail.setFlag("Y");
                    }
                } else if (goods.getEWCCodeAmount() > 0.0 && goods.getEWCCodeNum() > 0.0) {
                    sellDetail.setFlag("5");
                    sellDetail.setQty(goods.getEWCCodeNum());
                    sellDetail.setListAmount(goods.getEWCCodeAmount());
                    sellDetail.setPrice(goods.getListPrice());
                    sellDetail.setQtyrecalcAmount(goods.getEWCCodeAmount());
                    if (3 == order.getSysPara().getYpopDzcMode()) {
                        sellDetail.setIsdzc("P");
                        if (3 == order.getPopMode()) {
                            sellDetail.setIsdzc("Z");
                        }
                        if (ManipulatePrecision.doubleCompare(goods.getListPrice(), 0.0, 2) > 0) {
                            if (goods.getSalePrice() > goods.getListPrice()) {
                                sellDetail.setListAmount(ManipulatePrecision.doubleConvert(goods.getListPrice() * goods.getEWCCodeNum()));
                                sellDetail.setQtyrecalcAmount(sellDetail.getListAmount());
                            }
                        } else {
                            sellDetail.setPrice(goods.getSalePrice());
                        }
                    }
                }
            }
        }
        if (order.getPopMode() == 3) {
            sellDetail.setFlag("J");
        }
        if (StringUtils.isNotBlank((String)goods.getPopFlag()) && !"7".equals(goods.getFlag())) {
            sellDetail.setFlag(goods.getPopFlag());
        }
        if (SellType.NOPOP(order.getOrderType()) && !SellType.ISEXERCISE(order.getOrderType())) {
            sellDetail.setFlag("Z");
        }
        if (null != order.getConsumersData() && StringUtils.isNotBlank((String)order.getConsumersData().getLoginMode()) && "2".equals(order.getConsumersData().getLoginMode())) {
            sellDetail.setFlag("T");
        }
        boolean isSpecifyBack = false;
        boolean isHaveBarcodeDisc = false;
        if (SellType.ISBACK(order.getOrderType()) && StringUtils.isNotBlank((String)order.getOriginTerminalSno())) {
            isSpecifyBack = true;
        }
        if ("E".equals(sellDetail.getFlag()) && !isSpecifyBack && ManipulatePrecision.doubleCompare(order.getRemainValue(), 0.0, 2) > 0) {
            sellDetail.setListAmount(goods.getEWCCodeAmount());
        }
        if ("2".equals(goods.getGoodsType())) {
            sellDetail.setCounter(goods.getParentGoodsCode());
        }
        if (order.getStaffSale()) {
            if (goods.getTempZzkDiscount() == 0.0 && goods.getTempZzrDiscount() == 0.0 && goods.getTempZrDiscount() == 0.0 && goods.getTempZkDiscount() == 0.0) {
                sellDetail.setKlm("STAFF");
                goods.setKlm("STAFF");
            } else {
                goods.setKlm("");
            }
        } else {
            goods.setKlm("");
        }
        if (!isSpecifyBack) {
            if (null != goods.getPopDetailsInfo() && goods.getPopDetailsInfo().size() > 0) {
                if (null == sellDetail.getSellPopDetails()) {
                    sellDetail.setSellPopDetails(new ArrayList<SellPopDetail>());
                }
                for (PopDetail popDetail : goods.getPopDetailsInfo()) {
                    if (isRemoveAdjustDisc && YPopStatusType.pop_policy_group_grant_goods.equals(popDetail.getPopPolicyGroup())) continue;
                    if (YPopStatusType.pop_policy_group_barcode_discA.equals(popDetail.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_barcode_discB.equals(popDetail.getPopPolicyGroup())) {
                        if (isNewCalcId) {
                            // empty if block
                        }
                        isHaveBarcodeDisc = true;
                    } else if (isNewCalcId && !isNeedPopDetail) continue;
                    sellDetail.getSellPopDetails().add(this.popdetailTransfer.transferSellPopDetail(popDetail, order, goods));
                }
            }
        } else if (SellType.ISBACK(order.getOrderType()) && goods.getFlag().equals("0") && null != goods.getPopDetailsInfo() && goods.getPopDetailsInfo().size() > 0) {
            if (null == sellDetail.getSellPopDetails()) {
                sellDetail.setSellPopDetails(new ArrayList<SellPopDetail>());
            }
            for (PopDetail popDetail : goods.getPopDetailsInfo()) {
                sellDetail.getSellPopDetails().add(this.popdetailTransfer.transferSellPopDetail(popDetail, order, goods));
            }
        }
        if (null != goods.getOutCouponUses() && goods.getOutCouponUses().size() > 0) {
            if (null == sellDetail.getCouponUses()) {
                sellDetail.setCouponUses(new ArrayList<SellCouponUse>());
            }
            for (CouponUse couponUse : goods.getOutCouponUses()) {
                sellDetail.getCouponUses().add(this.couponTransfer.transferSellCouponUse(couponUse));
            }
        }
        if (ManipulatePrecision.doubleConvert(goods.getTotalDiscountValue() - goods.getPopDiscountValue(), 2, 1) > 0.0) {
            if (null == sellDetail.getSellPopDetails()) {
                sellDetail.setSellPopDetails(new ArrayList<SellPopDetail>());
            }
            if (SellType.ISSALE(order.getOrderType()) || null == order.getOriginIdSheetNo() || order.getOriginIdSheetNo().equals("")) {
                SellPopDetail sellPopDetail;
                if (!isRemoveAdjustDisc) {
                    if (ManipulatePrecision.doubleCompare(goods.getTempZzkDiscount(), 0.0, 2) > 0) {
                        sellPopDetail = new SellPopDetail();
                        sellPopDetail.setPopEventBillId("0");
                        sellPopDetail.setDiscountAmount(ManipulatePrecision.doubleConvert(goods.getTempZzkDiscount(), 6, 1));
                        sellPopDetail.setPopMode("0");
                        sellPopDetail.setPopPolicyGroup(YPopStatusType.pop_policy_group_grant_order);
                        sellPopDetail.setPopDescribe("[" + order.getSysPara().getZpRateDes() + order.getTempZzk() + "%]");
                        sellPopDetail.setPopMemo("PRE:0");
                        if (StringUtils.isNotBlank((String)goods.getFdmode())) {
                            sellPopDetail.setPopMemo("fdmode:" + goods.getFdmode() + ",fdzkfd:" + goods.getFdzkfd());
                        }
                        sellPopDetail.setPopPolicyType(YPopStatusType.pop_type_order);
                        sellPopDetail.setRowNo(goods.getFlowId());
                        sellDetail.getSellPopDetails().add(sellPopDetail);
                    }
                    if (ManipulatePrecision.doubleCompare(goods.getTempZzrDiscount(), 0.0, 2) > 0) {
                        sellPopDetail = new SellPopDetail();
                        sellPopDetail.setPopEventBillId("0");
                        sellPopDetail.setDiscountAmount(ManipulatePrecision.doubleConvert(goods.getTempZzrDiscount(), 6, 1));
                        sellPopDetail.setPopMode("0");
                        sellPopDetail.setPopPolicyGroup(YPopStatusType.pop_policy_group_grant_order);
                        sellPopDetail.setPopDescribe("[" + order.getSysPara().getZpAmountDes() + "]");
                        sellPopDetail.setPopMemo("PRE:0");
                        if (StringUtils.isNotBlank((String)goods.getFdmode())) {
                            sellPopDetail.setPopMemo("fdmode:" + goods.getFdmode() + ",fdzkfd:" + goods.getFdzkfd());
                        }
                        sellPopDetail.setPopPolicyType(YPopStatusType.pop_type_order);
                        sellPopDetail.setRowNo(goods.getFlowId());
                        sellDetail.getSellPopDetails().add(sellPopDetail);
                    }
                } else {
                    String precisionMode = DataExchageUtils.exchangePrecisionMode(goods.getPrcutMode());
                    sellDetail.setTotalDiscount(ManipulatePrecision.getDetailOverFlow(sellDetail.getTotalDiscount() - goods.getTempZzkDiscount() - goods.getTempZzrDiscount(), precisionMode));
                    sellDetail.setSaleAmount(ManipulatePrecision.getDetailOverFlow(sellDetail.getSaleAmount() + goods.getTempZzkDiscount() + goods.getTempZzrDiscount(), goods.getPrcutMode()));
                    if (!"2".equals(order.getSysPara().getOrderDiscSeq())) {
                        goods.setTempZzkDiscount(0.0);
                        goods.setTempZzrDiscount(0.0);
                        double d = ManipulatePrecision.getDetailOverFlow(goods.getTempZkDiscount() + goods.getTempZrDiscount() + goods.getTempZzkDiscount() + goods.getTempZzrDiscount() + goods.getBarcodeDiscount() + goods.getFixedDiscountValue(), precisionMode);
                        goods.setAdjustDiscountValue(d);
                    }
                }
                if (ManipulatePrecision.doubleCompare(goods.getFixedDiscountValue(), 0.0, 2) > 0) {
                    sellPopDetail = new SellPopDetail();
                    sellPopDetail.setPopEventBillId("0");
                    sellPopDetail.setDiscountAmount(ManipulatePrecision.doubleConvert(goods.getFixedDiscountValue(), 6, 1));
                    sellPopDetail.setPopMode("0");
                    sellPopDetail.setPopPolicyGroup(YPopStatusType.pop_policy_group_grant_goods);
                    sellPopDetail.setPopPolicyType(YPopStatusType.pop_type_goods);
                    sellPopDetail.setPopDescribe("[" + order.getSysPara().getDpAmountDes() + "]");
                    sellPopDetail.setPopMemo("PRE:0");
                    if (StringUtils.isNotBlank((String)goods.getFdmode())) {
                        sellPopDetail.setPopMemo("fdmode:" + goods.getFdmode() + ",fdresult:" + goods.getFdresult() + ",popzkfd:" + goods.getPopzkfd());
                    }
                    sellPopDetail.setRowNo(goods.getFlowId());
                    sellDetail.getSellPopDetails().add(sellPopDetail);
                }
                if (!isHaveBarcodeDisc && ManipulatePrecision.doubleCompare(goods.getBarcodeDiscount(), 0.0, 2) > 0) {
                    sellPopDetail = new SellPopDetail();
                    sellPopDetail.setPopEventBillId("0");
                    sellPopDetail.setDiscountAmount(ManipulatePrecision.doubleConvert(goods.getBarcodeDiscount(), 6, 1));
                    sellPopDetail.setPopMode("0");
                    sellPopDetail.setPopDescribe(order.getSysPara().getBarCodeDes());
                    sellPopDetail.setRowNo(goods.getFlowId());
                    if (goods.getDisMode() == 3) {
                        sellPopDetail.setPrcMode("6");
                        sellPopDetail.setPopPolicyGroup(YPopStatusType.pop_policy_group_barcode_discA);
                        sellPopDetail.setPopPolicyType(YPopStatusType.pop_type_barcodeA);
                        sellPopDetail.setPopDescribe("[" + order.getSysPara().getBarCodeDes() + "]");
                    } else if (goods.getDisMode() == 1) {
                        sellPopDetail.setPrcMode("6");
                        sellPopDetail.setPopPolicyGroup(YPopStatusType.pop_policy_group_barcode_discB);
                        sellPopDetail.setPopPolicyType(YPopStatusType.pop_type_barcodeB);
                    } else if (goods.getDisMode() == 2) {
                        sellPopDetail.setDiscountAmount(0.0);
                        sellPopDetail.setPrcMode("5");
                        sellPopDetail.setPopPolicyGroup(YPopStatusType.pop_policy_group_barcode_discB);
                        sellPopDetail.setPopEventType(YPopStatusType.pop_type_barcodeB);
                        sellPopDetail.setDiscountRate(ManipulatePrecision.doubleConvert(1.0 - goods.getDisValue()));
                    }
                    if (StringUtils.isNotBlank((String)goods.getFdmode())) {
                        sellPopDetail.setPopPolicyGroup(YPopStatusType.pop_policy_group_barcode_discB);
                        sellPopDetail.setPopMemo("fdmode:" + goods.getFdmode() + ",fdzkfd:" + goods.getVipfdzkfd());
                    }
                    sellDetail.getSellPopDetails().add(sellPopDetail);
                }
                if (ManipulatePrecision.doubleCompare(goods.getTempZkDiscount(), 0.0, 2) > 0) {
                    sellPopDetail = new SellPopDetail();
                    sellPopDetail.setPopEventBillId("0");
                    sellPopDetail.setDiscountAmount(ManipulatePrecision.doubleConvert(goods.getTempZkDiscount(), 6, 1));
                    sellPopDetail.setPopMode("0");
                    sellPopDetail.setPopPolicyGroup(YPopStatusType.pop_policy_group_grant_goods);
                    sellPopDetail.setPopDescribe("[" + order.getSysPara().getDpRateDes() + goods.getTempZkl() + "%]");
                    sellPopDetail.setPopMemo("PRE:0");
                    if (StringUtils.isNotBlank((String)goods.getFdmode())) {
                        sellPopDetail.setPopMemo("fdmode:" + goods.getFdmode() + ",fdzkfd:" + goods.getFdzkfd());
                    }
                    sellPopDetail.setPopPolicyType(YPopStatusType.pop_type_goods);
                    sellPopDetail.setRowNo(goods.getFlowId());
                    sellDetail.getSellPopDetails().add(sellPopDetail);
                }
                if (ManipulatePrecision.doubleCompare(goods.getTempZrDiscount(), 0.0, 2) > 0) {
                    sellPopDetail = new SellPopDetail();
                    sellPopDetail.setPopEventBillId("0");
                    sellPopDetail.setDiscountAmount(ManipulatePrecision.doubleConvert(goods.getTempZrDiscount(), 6, 1));
                    sellPopDetail.setPopMode("0");
                    sellPopDetail.setPopPolicyGroup(YPopStatusType.pop_policy_group_grant_goods);
                    sellPopDetail.setPopDescribe("[" + order.getSysPara().getDpAmountDes() + "]");
                    sellPopDetail.setPopMemo("PRE:0");
                    if (StringUtils.isNotBlank((String)goods.getFdmode())) {
                        sellPopDetail.setPopMemo("fdmode:" + goods.getFdmode() + ",fdzkfd:" + goods.getFdzkfd());
                    }
                    sellPopDetail.setPopPolicyType(YPopStatusType.pop_type_goods);
                    sellPopDetail.setRowNo(goods.getFlowId());
                    sellDetail.getSellPopDetails().add(sellPopDetail);
                }
                if (goods.getCustomDiscountValue() > 0.0) {
                    sellPopDetail = new SellPopDetail();
                    sellPopDetail.setPopEventBillId("0");
                    sellPopDetail.setDiscountAmount(ManipulatePrecision.doubleConvert(goods.getCustomDiscountValue(), 6, 1));
                    sellPopDetail.setPopMode("0");
                    sellPopDetail.setPopPolicyGroup(YPopStatusType.pop_policy_group_grant_goods);
                    sellPopDetail.setPopPolicyType(YPopStatusType.pop_ghcard_goods);
                    sellPopDetail.setPopMemo("PRE:0");
                    sellPopDetail.setRowNo(goods.getFlowId());
                    sellPopDetail.setPopDescribe("\u5de5\u4f1a\u6298\u6263");
                    sellDetail.getSellPopDetails().add(sellPopDetail);
                }
                if (goods.getMealDiscountValue() > 0.0) {
                    sellPopDetail = new SellPopDetail();
                    sellPopDetail.setPopEventBillId("0");
                    sellPopDetail.setDiscountAmount(ManipulatePrecision.doubleConvert(goods.getMealDiscountValue(), 6, 1));
                    sellPopDetail.setPopMode("0");
                    sellPopDetail.setPopPolicyGroup(YPopStatusType.pop_policy_group_grant_goods);
                    sellPopDetail.setPopMemo("PRE:1");
                    sellPopDetail.setRowNo(goods.getFlowId());
                    sellDetail.getSellPopDetails().add(sellPopDetail);
                }
                if (goods.getStudentCardDiscountValue() > 0.0) {
                    sellPopDetail = new SellPopDetail();
                    sellPopDetail.setPopEventBillId("0");
                    sellPopDetail.setDiscountAmount(ManipulatePrecision.doubleConvert(goods.getStudentCardDiscountValue(), 6, 1));
                    sellPopDetail.setPopMode("0");
                    sellPopDetail.setPopPolicyGroup(YPopStatusType.pop_policy_group_aeoncoupon);
                    sellPopDetail.setPopDescribe("[" + order.getSysPara().getXzkDes() + goods.getStudentCardDiscountValue() + "$]");
                    sellPopDetail.setPopMemo("PRE:1");
                    sellPopDetail.setRowNo(goods.getFlowId());
                    sellDetail.getSellPopDetails().add(sellPopDetail);
                }
            }
        }
        sellDetail.setOriginalBillNo(order.getOriginFlowNo());
        if (goods.getOriginalFlowId() != null) {
            sellDetail.setOriginalRowNo(goods.getOriginalFlowId());
        }
        return sellDetail;
    }
}

