/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.javaPos.commonkit.beantransfer;

import com.efuture.business.javaPos.commonkit.beantransfer.CouponTransfer;
import com.efuture.business.javaPos.struct.Coupon;
import com.efuture.business.javaPos.struct.CouponGain;
import com.efuture.business.javaPos.struct.CouponUse;
import com.efuture.business.javaPos.struct.Order;
import com.efuture.business.javaPos.struct.orderCentre.OrdersGainModel;
import com.efuture.business.javaPos.struct.orderCentre.OrdersUseCouponModel;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrderGainDetailModel;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrderGainModel;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrderUseCouponModel;
import com.efuture.business.javaPos.struct.promotionCentre.SellCoupon;
import com.efuture.business.javaPos.struct.promotionCentre.SellCouponGain;
import com.efuture.business.javaPos.struct.promotionCentre.SellCouponUse;
import com.efuture.business.util.BeanCopierUtils;
import com.efuture.business.util.CastUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CouponTransferImpl
implements CouponTransfer {
    private static final Logger log = LoggerFactory.getLogger(CouponTransferImpl.class);

    @Override
    public SellCoupon transferSellCoupon(Coupon coupon) {
        SellCoupon sellCoupon = new SellCoupon();
        sellCoupon.setCouponName(coupon.getCouponName());
        sellCoupon.setFaceValue(coupon.getFaceValue());
        sellCoupon.setMode(coupon.getMode());
        sellCoupon.setCouponGroup(coupon.getCouponGroup());
        sellCoupon.setCouponType(coupon.getCouponType());
        sellCoupon.setCouponNeedPwd(coupon.getCouponNeedPwd());
        sellCoupon.setCouponEventScd(coupon.getCouponEventScd());
        sellCoupon.setCouponPolicyId(coupon.getCouponPolicyId());
        sellCoupon.setCouponIsCash(coupon.getCouponIsCash());
        sellCoupon.setCouponMutex(coupon.getCouponMutex());
        sellCoupon.setPayCode(coupon.getPayCode());
        sellCoupon.setAccount(coupon.getAccount());
        sellCoupon.setAvailable(coupon.getAvailable());
        sellCoupon.setBalance(coupon.getBalance());
        sellCoupon.setLimit(coupon.getLimit());
        sellCoupon.setRate(coupon.getRate());
        sellCoupon.setPointExchange(coupon.getPointExchange());
        sellCoupon.setPointExchangeMoney(coupon.getPointExchangeMoney());
        sellCoupon.setEffDate(coupon.getEffDate());
        sellCoupon.setDescribe(coupon.getDescribe());
        sellCoupon.setSrcAccntno(coupon.getSrcAcctno());
        sellCoupon.setCashCost(coupon.getCashCost());
        sellCoupon.setConsumersId(coupon.getConsumersId());
        sellCoupon.setAmount(coupon.getAmount());
        sellCoupon.setCouponclass(coupon.getCouponclass());
        sellCoupon.setMedia(coupon.getMedia());
        return sellCoupon;
    }

    @Override
    public Coupon transferCoupon(SellCoupon sellCoupon) {
        Coupon coupon = new Coupon();
        BeanCopierUtils.copyProperties(sellCoupon, coupon);
        coupon.setMode(sellCoupon.getMode());
        coupon.setCouponGroup(sellCoupon.getCouponGroup());
        coupon.setCouponType(sellCoupon.getCouponType());
        coupon.setCouponName(sellCoupon.getCouponName());
        coupon.setCouponclass(sellCoupon.getCouponclass());
        coupon.setDescribe(sellCoupon.getUsageRule());
        coupon.setAccount(sellCoupon.getAccount());
        coupon.setFaceValue(sellCoupon.getFaceValue());
        coupon.setAmount(sellCoupon.getAmount());
        coupon.setEffDate(sellCoupon.getEffDate());
        coupon.setExpDate(sellCoupon.getExpDate());
        coupon.setEventId(sellCoupon.getGainEventId());
        coupon.setPolicyId(sellCoupon.getGainPolicyId());
        coupon.setCouponNeedPwd(sellCoupon.getCouponNeedPwd());
        coupon.setCouponEventScd(sellCoupon.getCouponEventScd());
        coupon.setCouponPolicyId(sellCoupon.getCouponPolicyId());
        coupon.setCouponIsCash(sellCoupon.getCouponIsCash());
        coupon.setCouponMutex(sellCoupon.getCouponMutex());
        coupon.setPayCode(sellCoupon.getPayCode());
        coupon.setAvailable(sellCoupon.getAvailable());
        coupon.setBalance(sellCoupon.getBalance());
        coupon.setLimit(sellCoupon.getLimit());
        coupon.setRate(sellCoupon.getRate());
        coupon.setPointExchange(sellCoupon.getPointExchange());
        coupon.setPointExchangeMoney(sellCoupon.getPointExchangeMoney());
        coupon.setSrcAcctno(sellCoupon.getSrcAccntno());
        coupon.setCashCost(sellCoupon.getCashCost());
        coupon.setConsumersId(sellCoupon.getConsumersId());
        coupon.setMedia(sellCoupon.getMedia());
        return coupon;
    }

    @Override
    public SaleOrderGainModel transferSaleOrderGainModel(Coupon coupon) {
        SaleOrderGainModel saleOrderGain = new SaleOrderGainModel();
        saleOrderGain.setCouponName(coupon.getCouponName());
        saleOrderGain.setFaceValue(BigDecimal.valueOf(coupon.getFaceValue()));
        saleOrderGain.setCouponGroup(coupon.getCouponGroup());
        saleOrderGain.setCouponType(coupon.getCouponType());
        saleOrderGain.setEffDate(coupon.getEffDate());
        saleOrderGain.setExpDate(coupon.getExpDate());
        saleOrderGain.setAmount(BigDecimal.valueOf(coupon.getAmount()));
        saleOrderGain.setCouponClass(coupon.getCouponclass());
        saleOrderGain.setEventId(coupon.getEventId());
        saleOrderGain.setPolicyId(coupon.getPolicyId());
        saleOrderGain.setMedia(coupon.getMedia());
        saleOrderGain.setCouponAccount(coupon.getAccount());
        return saleOrderGain;
    }

    @Override
    public List<SaleOrderGainModel> transferSaleOrderGainModel(List<Coupon> coupons) {
        if (coupons == null || coupons.size() == 0) {
            return new ArrayList<SaleOrderGainModel>();
        }
        ArrayList<SaleOrderGainModel> saleOrderGains = new ArrayList<SaleOrderGainModel>();
        for (Coupon coupon : coupons) {
            SaleOrderGainModel saleOrderGain = this.transferSaleOrderGainModel(coupon);
            saleOrderGains.add(saleOrderGain);
        }
        return saleOrderGains;
    }

    @Override
    public Coupon transferCoupon2(OrdersGainModel saleOrderGain) {
        Coupon coupon = new Coupon();
        coupon.setCouponType(saleOrderGain.getCouponType());
        coupon.setEventId(saleOrderGain.getEventId());
        coupon.setCouponclass(saleOrderGain.getCouponClass());
        coupon.setMedia(saleOrderGain.getMedia());
        coupon.setCouponName(saleOrderGain.getCouponName());
        coupon.setAccount(saleOrderGain.getCouponAccount());
        coupon.setExpDate(saleOrderGain.getExpDate());
        coupon.setCouponGroup(saleOrderGain.getCouponGroup());
        coupon.setAmount(CastUtil.castDouble(saleOrderGain.getAmount()));
        coupon.setFaceValue(CastUtil.castDouble(saleOrderGain.getFaceValue()));
        coupon.setPolicyId(saleOrderGain.getPolicyId());
        coupon.setEffDate(saleOrderGain.getEffDate());
        return coupon;
    }

    @Override
    public List<Coupon> transferCoupon(List<SellCoupon> sellCoupons) {
        ArrayList<Coupon> coupons = new ArrayList<Coupon>();
        if (sellCoupons == null || sellCoupons.size() == 0) {
            return coupons;
        }
        for (SellCoupon sellCoupon : sellCoupons) {
            Coupon coupon = this.transferCoupon(sellCoupon);
            coupons.add(coupon);
        }
        return coupons;
    }

    @Override
    public List<Coupon> transferCoupon3(List<SaleOrderGainModel> saleOrderGains) {
        if (saleOrderGains == null || saleOrderGains.size() == 0) {
            return null;
        }
        ArrayList<Coupon> coupons = new ArrayList<Coupon>();
        for (SaleOrderGainModel saleOrderGain : saleOrderGains) {
            Coupon coupon = this.transferCoupon2(saleOrderGain);
            coupons.add(coupon);
        }
        return coupons;
    }

    @Override
    public List<Coupon> transferCoupon4(List<OrdersGainModel> saleOrderGains) {
        if (saleOrderGains == null || saleOrderGains.size() == 0) {
            return null;
        }
        ArrayList<Coupon> coupons = new ArrayList<Coupon>();
        for (OrdersGainModel saleOrderGain : saleOrderGains) {
            Coupon coupon = this.transferCoupon2(saleOrderGain);
            coupons.add(coupon);
        }
        return coupons;
    }

    @Override
    public Coupon transferCoupon2(SaleOrderGainModel saleOrderGain) {
        Coupon coupon = new Coupon();
        coupon.setCouponType(saleOrderGain.getCouponType());
        coupon.setEventId(saleOrderGain.getEventId());
        coupon.setCouponclass(saleOrderGain.getCouponClass());
        coupon.setMedia(saleOrderGain.getMedia());
        coupon.setCouponName(saleOrderGain.getCouponName());
        coupon.setAccount(saleOrderGain.getCouponAccount());
        coupon.setExpDate(saleOrderGain.getExpDate());
        coupon.setCouponGroup(saleOrderGain.getCouponGroup());
        coupon.setAmount(CastUtil.castDouble(saleOrderGain.getAmount()));
        coupon.setFaceValue(CastUtil.castDouble(saleOrderGain.getFaceValue()));
        coupon.setPolicyId(saleOrderGain.getPolicyId());
        coupon.setEffDate(saleOrderGain.getEffDate());
        return coupon;
    }

    @Override
    public boolean isAeonStamp(Coupon coupon) {
        return null != coupon.getCouponGroup() && null != coupon.getCouponType() && coupon.getCouponGroup().equals("07") && coupon.getCouponType().equals("0701");
    }

    @Override
    public boolean isHaveAeonStamp(List<Coupon> couponGains) {
        for (Coupon coupon : couponGains) {
            if (null == coupon.getCouponGroup() || null == coupon.getCouponType() || !coupon.getCouponGroup().equals("07") || !coupon.getCouponType().equals("0701")) continue;
            return true;
        }
        return false;
    }

    @Override
    public CouponGain transferCouponGain(SellCouponGain sellCouponGain, int goodsRow) {
        CouponGain couponGain = new CouponGain();
        couponGain.setEventId(sellCouponGain.getGainEventId());
        couponGain.setPolicyId(sellCouponGain.getPolicyId());
        couponGain.setCouponGroup(sellCouponGain.getCouponGroup());
        couponGain.setCouponType(sellCouponGain.getCouponType());
        couponGain.setAmount(sellCouponGain.getAmount());
        couponGain.setTerminalNo(sellCouponGain.getTerminalNo());
        couponGain.setTerminalSno(sellCouponGain.getTerminalSno());
        couponGain.setRowNo(goodsRow);
        couponGain.setCouponClass(sellCouponGain.getCouponClass());
        couponGain.setCouponAccount(sellCouponGain.getCouponAccount());
        couponGain.setCouponName(sellCouponGain.getCouponName());
        return couponGain;
    }

    @Override
    public List<SaleOrderGainDetailModel> transferSaleOrderGainModel(List<CouponGain> couponGains, int goodsRowNo, String shopCode) {
        if (couponGains == null || couponGains.size() == 0) {
            return new ArrayList<SaleOrderGainDetailModel>();
        }
        ArrayList<SaleOrderGainDetailModel> saleOrderGains = new ArrayList<SaleOrderGainDetailModel>();
        for (CouponGain couponGain : couponGains) {
            saleOrderGains.add(this.transferSaleOrderGainModel(couponGain, goodsRowNo, shopCode));
        }
        return saleOrderGains;
    }

    @Override
    public SaleOrderGainDetailModel transferSaleOrderGainModel(CouponGain c, int goodsRowNo, String shopCode) {
        SaleOrderGainDetailModel s = new SaleOrderGainDetailModel();
        s.setRowNo(goodsRowNo);
        s.setCouponType(c.getCouponType());
        s.setCouponClass(c.getCouponClass());
        s.setCouponGroup(c.getCouponGroup());
        s.setAmount(BigDecimal.valueOf(c.getAmount()));
        s.setEventId(c.getEventId());
        s.setPolicyId(c.getPolicyId());
        s.setCouponAccount(c.getCouponAccount());
        s.setCouponName(c.getCouponName());
        s.setShopCode(shopCode);
        return s;
    }

    @Override
    public List<SellCouponGain> transferSellCouponGain(List<CouponGain> couponGains) {
        if (couponGains == null || couponGains.size() == 0) {
            return null;
        }
        ArrayList<SellCouponGain> sellCouponGains = new ArrayList<SellCouponGain>();
        for (CouponGain couponGain : couponGains) {
            SellCouponGain sellCouponGain = this.transferSellCouponGain(couponGain);
            sellCouponGains.add(sellCouponGain);
        }
        return sellCouponGains;
    }

    @Override
    public SellCouponGain transferSellCouponGain(CouponGain couponGain) {
        SellCouponGain sellCouponGain = new SellCouponGain();
        sellCouponGain.setEventId(couponGain.getEventId());
        sellCouponGain.setPolicyId(couponGain.getPolicyId());
        sellCouponGain.setCouponGroup(couponGain.getCouponGroup());
        sellCouponGain.setCouponType(couponGain.getCouponType());
        sellCouponGain.setAmount(couponGain.getAmount());
        sellCouponGain.setTerminalNo(couponGain.getTerminalNo());
        sellCouponGain.setTerminalSno(couponGain.getTerminalSno());
        sellCouponGain.setRowNo(couponGain.getRowNo());
        sellCouponGain.setCouponClass(couponGain.getCouponClass());
        return sellCouponGain;
    }

    @Override
    public SellCouponUse transferSellCouponUse(CouponUse c) {
        SellCouponUse use = new SellCouponUse();
        use.setPayRowNo(c.getPayRowNo());
        use.setCouponGroup(c.getCouponGroup());
        use.setCouponType(c.getCouponType());
        use.setAmount(c.getAmount());
        use.setOriAmount(c.getOriAmount());
        use.setEventId(c.getEventId());
        use.setPolicyId(c.getPolicyId());
        use.setPayCode(c.getPayCode());
        use.setCouponClass(c.getCouponNo());
        use.setEntId(c.getEntId());
        use.setTerminalNo(c.getTerminalNo());
        use.setTerminalSno(c.getTerminalSno());
        use.setGoodsRowNo(c.getGoodsRowNo());
        use.setKhflag(c.getKhFlag());
        use.setRownoId(c.getRownoId());
        if (!Double.isNaN(c.getCashCost())) {
            use.setCashCost(c.getCashCost());
        }
        return use;
    }

    @Override
    public CouponUse transferCouponUse(SellCouponUse c) {
        CouponUse use = new CouponUse();
        use.setPayRowNo(c.getPayRowNo());
        use.setCouponGroup(c.getCouponGroup());
        use.setCouponType(c.getCouponType());
        use.setAmount(c.getAmount());
        use.setOriAmount(c.getOriAmount());
        use.setEventId(c.getEventId());
        use.setPolicyId(c.getPolicyId());
        use.setPayCode(c.getPayCode());
        use.setCouponClass(c.getCouponClass());
        use.setEntId(c.getEntId());
        use.setTerminalNo(c.getTerminalNo());
        use.setTerminalSno(c.getTerminalSno());
        use.setGoodsRowNo(c.getGoodsRowNo());
        use.setKhFlag(c.getKhflag());
        use.setRownoId(c.getRownoId());
        use.setCouponNo(c.getCouponClass());
        if (!Double.isNaN(c.getCashCost())) {
            use.setCashCost(c.getCashCost());
        }
        return use;
    }

    @Override
    public OrdersUseCouponModel transferOrdersUseCouponModel(CouponUse c) {
        OrdersUseCouponModel s = new OrdersUseCouponModel();
        s.setRowNo(c.getGoodsRowNo());
        s.setRowNoId(CastUtil.castLong(c.getRownoId()));
        s.setPayCode(c.getPayCode());
        s.setPayRowNo(Long.valueOf(c.getPayRowNo()));
        s.setCouponType(c.getCouponType());
        s.setCouponGroup(c.getCouponGroup());
        s.setCouponClass(c.getCouponClass());
        s.setAmount(BigDecimal.valueOf(c.getAmount()));
        s.setOriginalMount(BigDecimal.valueOf(c.getOriAmount()));
        s.setEventId(c.getEventId());
        s.setPolicyId(c.getPolicyId());
        s.setKhFlag(c.getKhFlag());
        s.setCouponNo(c.getCouponNo());
        if (!Double.isNaN(c.getCashCost())) {
            s.setCouponCost(BigDecimal.valueOf(c.getCashCost()));
        }
        return s;
    }

    @Override
    public CouponUse transferCouponUse3(OrdersUseCouponModel saleOrderUseCoupon, Order saleOrder) {
        CouponUse couponUse = new CouponUse();
        couponUse.setCouponNo(saleOrderUseCoupon.getCouponNo());
        couponUse.setPayRowNo(saleOrderUseCoupon.getPayRowNo().intValue());
        couponUse.setCouponGroup(saleOrderUseCoupon.getCouponGroup());
        couponUse.setCouponType(saleOrderUseCoupon.getCouponType());
        couponUse.setAmount(saleOrderUseCoupon.getAmount().doubleValue());
        couponUse.setOriAmount(saleOrderUseCoupon.getOriginalMount().doubleValue());
        couponUse.setEventId(saleOrderUseCoupon.getEventId());
        couponUse.setPolicyId(saleOrderUseCoupon.getPolicyId());
        couponUse.setPayCode(saleOrderUseCoupon.getPayCode());
        couponUse.setCouponClass(saleOrderUseCoupon.getCouponClass());
        couponUse.setEventId(saleOrderUseCoupon.getEventId());
        couponUse.setGoodsRowNo(saleOrderUseCoupon.getRowNo());
        couponUse.setKhFlag(saleOrderUseCoupon.getKhFlag());
        couponUse.setRownoId(saleOrderUseCoupon.getRowNoId().toString());
        if (saleOrder != null) {
            couponUse.setTerminalNo(saleOrder.getTerminalNo());
            couponUse.setTerminalSno(saleOrder.getTerminalSno());
        }
        if (saleOrderUseCoupon.getCouponCost() != null) {
            couponUse.setCashCost(saleOrderUseCoupon.getCouponCost().doubleValue());
        }
        return couponUse;
    }

    @Override
    public List<SellCouponUse> transferSellCouponUse(List<CouponUse> couponUses) {
        if (couponUses == null || couponUses.size() == 0) {
            return null;
        }
        ArrayList<SellCouponUse> sellCouponUses = new ArrayList<SellCouponUse>();
        for (CouponUse couponUse : couponUses) {
            SellCouponUse sellCouponUse = this.transferSellCouponUse(couponUse);
            sellCouponUses.add(sellCouponUse);
        }
        return sellCouponUses;
    }

    @Override
    public List<CouponUse> transferCouponUse(List<SellCouponUse> sellCouponUses) {
        if (sellCouponUses == null || sellCouponUses.size() == 0) {
            return null;
        }
        ArrayList<CouponUse> couponUses = new ArrayList<CouponUse>();
        for (SellCouponUse sellCouponUse : sellCouponUses) {
            CouponUse couponUse = this.transferCouponUse(sellCouponUse);
            couponUses.add(couponUse);
        }
        return couponUses;
    }

    @Override
    public List<OrdersUseCouponModel> transferOrdersUseCouponModel(List<CouponUse> couponUses) {
        if (couponUses == null || couponUses.size() == 0) {
            return new ArrayList<OrdersUseCouponModel>();
        }
        ArrayList<OrdersUseCouponModel> saleOrderUseCoupons = new ArrayList<OrdersUseCouponModel>();
        for (CouponUse couponUse : couponUses) {
            OrdersUseCouponModel saleOrderUseCoupon = this.transferOrdersUseCouponModel(couponUse);
            saleOrderUseCoupons.add(saleOrderUseCoupon);
        }
        return saleOrderUseCoupons;
    }

    @Override
    public List<SaleOrderUseCouponModel> transferSaleOrderUseCouponModel(List<CouponUse> couponUses, int goodsRowNo, String shopCode) {
        if (couponUses == null || couponUses.size() == 0) {
            return new ArrayList<SaleOrderUseCouponModel>();
        }
        ArrayList<SaleOrderUseCouponModel> saleOrderUseCoupons = new ArrayList<SaleOrderUseCouponModel>();
        for (CouponUse couponUse : couponUses) {
            saleOrderUseCoupons.add(this.transferSaleOrderUseCouponModel(couponUse, goodsRowNo, shopCode));
        }
        return saleOrderUseCoupons;
    }

    @Override
    public SaleOrderUseCouponModel transferSaleOrderUseCouponModel(CouponUse c, int goodsRowNo, String shopCode) {
        SaleOrderUseCouponModel s = new SaleOrderUseCouponModel();
        s.setRowNo(goodsRowNo);
        s.setRowNoId(CastUtil.castLong(c.getRownoId()));
        s.setPayCode(c.getPayCode());
        s.setPayRowNo(Long.valueOf(c.getPayRowNo()));
        s.setCouponType(c.getCouponType());
        s.setCouponGroup(c.getCouponGroup());
        s.setCouponClass(c.getCouponClass());
        s.setAmount(BigDecimal.valueOf(c.getAmount()));
        s.setOriginalMount(BigDecimal.valueOf(c.getOriAmount()));
        s.setEventId(c.getEventId());
        s.setPolicyId(c.getPolicyId());
        s.setKhFlag(c.getKhFlag());
        s.setShopCode(shopCode);
        s.setCouponNo(c.getCouponNo());
        if (!Double.isNaN(c.getCashCost())) {
            s.setCouponCost(BigDecimal.valueOf(c.getCashCost()));
        }
        return s;
    }

    @Override
    public List<Coupon> transferToCoupon(List<SellCoupon> couponUses) {
        List<Coupon> coupons = this.transferCoupon(couponUses);
        return coupons;
    }
}

