/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.javaPos.commonkit.beantransfer;

import com.alibaba.fastjson.JSON;
import com.efuture.business.bean.SellType;
import com.efuture.business.bean.YPopStatusType;
import com.efuture.business.javaPos.commonkit.Convert;
import com.efuture.business.javaPos.commonkit.CountZZK;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.javaPos.commonkit.ManipulateStr;
import com.efuture.business.javaPos.commonkit.beantransfer.CouponTransfer;
import com.efuture.business.javaPos.commonkit.beantransfer.GoodsTransfer;
import com.efuture.business.javaPos.commonkit.beantransfer.PopdetailTransfer;
import com.efuture.business.javaPos.struct.CouponGain;
import com.efuture.business.javaPos.struct.CouponUse;
import com.efuture.business.javaPos.struct.Goods;
import com.efuture.business.javaPos.struct.GoodsForPos;
import com.efuture.business.javaPos.struct.GoodsInfoForApp;
import com.efuture.business.javaPos.struct.Order;
import com.efuture.business.javaPos.struct.PopDetail;
import com.efuture.business.javaPos.struct.PopGain;
import com.efuture.business.javaPos.struct.PopReverse;
import com.efuture.business.javaPos.struct.PopUse;
import com.efuture.business.javaPos.struct.mainDataCentre.CategoryProperty;
import com.efuture.business.javaPos.struct.mainDataCentre.GoodsInfo;
import com.efuture.business.javaPos.struct.orderCentre.OrdersDetailModel;
import com.efuture.business.javaPos.struct.orderCentre.OrdersGainDetailModel;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrderDetailModel;
import com.efuture.business.javaPos.struct.promotionCentre.SellCouponGain;
import com.efuture.business.javaPos.struct.promotionCentre.SellCouponUse;
import com.efuture.business.javaPos.struct.promotionCentre.SellDetail;
import com.efuture.business.javaPos.struct.promotionCentre.SellPopDetail;
import com.efuture.business.util.BeanCopierUtils;
import com.efuture.business.util.CastUtil;
import com.efuture.business.util.DataExchageUtils;
import com.efuture.business.util.UUIDUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class GoodsTransferImpl
implements GoodsTransfer {
    private static final Logger log = LoggerFactory.getLogger(GoodsTransferImpl.class);
    @Autowired
    public CouponTransfer couponTransfer;
    @Autowired
    public PopdetailTransfer popdetailTransfer;

    @Override
    public Goods transferGoods(SellDetail sellDetail, Goods good, String calcResult, List<String> noDisPopTypes, boolean needYpopzke, boolean needGrant, boolean isSpecifyBack) {
        try {
            boolean hasErpVipPop = false;
            Object preline = "";
            if (null == sellDetail || null == good) {
                return null;
            }
            good.setYhmiscanuse("");
            good.setNoDisAmountValue(0.0);
            if (good.getFlag().equals("9")) {
                if (!"Y".equals(sellDetail.getYhMiscanUse())) {
                    good.setYhmiscanuse("N");
                } else {
                    good.setGoodsName(sellDetail.getItemName());
                }
            }
            if (StringUtils.isBlank((String)good.getTempName())) {
                good.setTempName(good.getGoodsName());
            } else {
                good.setGoodsName(good.getTempName());
            }
            if (needYpopzke) {
                good.setPopDiscountValue(ManipulatePrecision.doubleConvert(sellDetail.getTotalDiscount(), 2, 1));
            }
            good.setNojf(sellDetail.getNojf());
            good.setPopFlag(sellDetail.getFlag());
            good.setBarcodeDiscount(0.0);
            good.setKlm(sellDetail.getKlm());
            if (good.getQtyrecalc() != 0 && sellDetail.getQtyrecalc() == 0 || sellDetail.getQtyrecalc() != 0) {
                good.setQty(sellDetail.getQty());
                good.setSalePrice(sellDetail.getPrice());
                good.setSaleValue(sellDetail.getListAmount());
            }
            if ("5".equals(sellDetail.getFlag())) {
                good.setSalePrice(sellDetail.getPrice());
                good.setSaleValue(sellDetail.getListAmount());
            }
            good.setQtyrecalc(sellDetail.getQtyrecalc());
            good.setQtyrecalcAmount(sellDetail.getQtyrecalcAmount());
            good.setQtyrecalcEvtid(sellDetail.getQtyrecalcEvtid());
            if (good.getPopDetailsInfo() != null) {
                good.getPopDetailsInfo().clear();
            }
            if (good.getCouponUses() != null) {
                good.getCouponUses().clear();
            }
            if (good.getCouponGains() != null) {
                good.getCouponGains().clear();
            }
            double noDisAmout = 0.0;
            good.setIsJFHG(false);
            good.setBarcodeDiscount(0.0);
            if (null != sellDetail.getSellPopDetails() && sellDetail.getSellPopDetails().size() > 0) {
                double tempDiscount = 0.0;
                double adjustDiscount = 0.0;
                double custDiscount = 0.0;
                for (int i = 0; i < sellDetail.getSellPopDetails().size(); ++i) {
                    SellPopDetail pop = sellDetail.getSellPopDetails().get(i);
                    if (null == pop || "X".equals(pop.getPopFlag())) continue;
                    if (!good.getIsJFHG() && YPopStatusType.pop_type_jfhg.equals(pop.getPopEventType())) {
                        good.setIsJFHG(true);
                    }
                    if (this.checkAddPop(pop)) continue;
                    if (!(null == pop.getPopPolicyGroup() || pop.getPopPolicyGroup().equals(YPopStatusType.pop_policy_group_grant_order) || pop.getPopPolicyGroup().equals(YPopStatusType.pop_policy_group_grant_goods) || pop.getPopPolicyGroup().equals(YPopStatusType.pop_policy_group_erpvip) || pop.getPopPolicyGroup().equals(YPopStatusType.pop_policy_group_barcode_discA) || pop.getPopPolicyGroup().equals(YPopStatusType.pop_policy_group_barcode_discB) || pop.getPopPolicyGroup().equals(YPopStatusType.pop_policy_group_aeoncoupon) || pop.getPopPolicyGroup().equals(YPopStatusType.pop_policy_group_vip_disc))) {
                        if (ManipulateStr.readIndexChar(calcResult, 0) == '1') {
                            if (null == good.getPopDetailsInfo()) {
                                good.setPopDetailsInfo(new ArrayList<PopDetail>());
                            }
                            good.getPopDetailsInfo().add(this.popdetailTransfer.transferPopDetail2(pop));
                            continue;
                        }
                        if (null == good.getPopDetailsInfo()) {
                            good.setPopDetailsInfo(new ArrayList<PopDetail>());
                        }
                        good.getPopDetailsInfo().add(this.popdetailTransfer.transferPopDetail2(pop));
                        if (!(YPopStatusType.pop_policy_group_grant_order.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_grant_goods.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_erpvip.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_barcode_discA.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_barcode_discB.equals(pop.getPopPolicyGroup()))) {
                            tempDiscount += pop.getDiscountAmount();
                        }
                        if (null != noDisPopTypes && !noDisPopTypes.isEmpty() && StringUtils.isNotBlank((String)pop.getPopPolicyType()) && noDisPopTypes.indexOf(pop.getPopPolicyType()) != -1) {
                            noDisAmout += pop.getDiscountAmount();
                        }
                        if (StringUtils.isNotBlank((String)pop.getPopPolicySymbol())) {
                            preline = (String)preline + pop.getPopPolicySymbol();
                        }
                        if (!pop.getPopPolicyGroup().equalsIgnoreCase(YPopStatusType.pop_policy_group_random) || !pop.getPopMode().equalsIgnoreCase("0")) continue;
                        good.setTempRandomDiscount(pop.getDiscountAmount());
                        continue;
                    }
                    if (!pop.getPopPolicyGroup().equals(YPopStatusType.pop_policy_group_grant_order) && !pop.getPopPolicyGroup().equals(YPopStatusType.pop_policy_group_grant_goods) && !pop.getPopPolicyGroup().equals(YPopStatusType.pop_policy_group_erpvip) && !pop.getPopPolicyGroup().equals(YPopStatusType.pop_policy_group_aeoncoupon) && !pop.getPopPolicyGroup().equals(YPopStatusType.pop_policy_group_vip_disc) && !pop.getPopPolicyGroup().equals(YPopStatusType.pop_policy_group_barcode_discB) && !pop.getPopPolicyGroup().equals(YPopStatusType.pop_policy_group_barcode_discA)) continue;
                    hasErpVipPop = true;
                    if (needGrant) {
                        if (YPopStatusType.pop_policy_group_grant_order.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_grant_goods.equals(pop.getPopPolicyGroup())) {
                            if (YPopStatusType.pop_ghcard_goods.equals(pop.getPopPolicyType())) {
                                custDiscount = ManipulatePrecision.doubleConvert(custDiscount + pop.getDiscountAmount());
                            } else {
                                adjustDiscount = ManipulatePrecision.doubleConvert(adjustDiscount + pop.getDiscountAmount());
                            }
                        }
                        if (YPopStatusType.pop_policy_group_barcode_discA.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_barcode_discB.equals(pop.getPopPolicyGroup())) {
                            good.setBarcodeDiscount(ManipulatePrecision.doubleConvert(good.getBarcodeDiscount() + pop.getDiscountAmount(), 2, 1));
                        }
                        if (null == good.getPopDetailsInfo()) {
                            good.setPopDetailsInfo(new ArrayList<PopDetail>());
                        }
                        good.getPopDetailsInfo().add(this.popdetailTransfer.transferPopDetail2(pop));
                        if (null == pop.getPopPolicySymbol() || "".equals(pop.getPopPolicySymbol())) continue;
                        preline = (String)preline + pop.getPopPolicySymbol();
                        continue;
                    }
                    if (!YPopStatusType.pop_policy_group_barcode_discB.equals(pop.getPopPolicyGroup()) && !YPopStatusType.pop_policy_group_barcode_discA.equals(pop.getPopPolicyGroup())) continue;
                    good.getPopDetailsInfo().add(this.popdetailTransfer.transferPopDetail2(pop));
                    good.setBarcodeDiscount(ManipulatePrecision.doubleConvert(good.getBarcodeDiscount() + pop.getDiscountAmount(), 2, 1));
                }
                if (needGrant && isSpecifyBack) {
                    good.setAdjustDiscountValue(adjustDiscount);
                    good.setCustomDiscountValue(custDiscount);
                    good.setTempZrDiscount(adjustDiscount);
                }
                if (needYpopzke) {
                    good.setPopDiscountValue(ManipulatePrecision.doubleConvert(tempDiscount, 2, 1));
                }
            }
            good.setNoDisAmountValue(noDisAmout);
            if (!hasErpVipPop) {
                good.setCustomDiscountValue(0.0);
            }
            if (null != sellDetail.getCouponUses() && sellDetail.getCouponUses().size() > 0) {
                for (int i = 0; i < sellDetail.getCouponUses().size(); ++i) {
                    CouponUse couponuse;
                    SellCouponUse use = sellDetail.getCouponUses().get(i);
                    if (null == good.getCouponUses()) {
                        good.setCouponUses(new ArrayList<CouponUse>());
                    }
                    if (null == (couponuse = this.couponTransfer.transferCouponUse(use))) continue;
                    couponuse.setGoodsRowNo(good.getFlowId());
                    good.getCouponUses().add(couponuse);
                }
            }
            if (null != sellDetail.getCouponGains() && sellDetail.getCouponGains().size() > 0) {
                for (int i = 0; i < sellDetail.getCouponGains().size(); ++i) {
                    SellCouponGain gain = sellDetail.getCouponGains().get(i);
                    if (null == good.getCouponGains()) {
                        good.setCouponGains(new ArrayList<CouponGain>());
                    }
                    good.getCouponGains().add(this.couponTransfer.transferCouponGain(gain, good.getFlowId()));
                }
            }
            if (!isSpecifyBack && StringUtils.isNotBlank((String)preline)) {
                good.setGoodsName("(" + (String)preline + ")" + good.getGoodsName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return good;
    }

    public boolean checkAddPop(SellPopDetail pop) {
        return false;
    }

    @Override
    public SellDetail transferSellDetail(Goods goods, Order order, boolean isRemoveAdjustDisc, boolean isNewCalcId) {
        return this.transferSellDetail(goods, order, isRemoveAdjustDisc, isNewCalcId, false);
    }

    @Override
    public SellDetail transferSellDetail(Goods goods, Order order, boolean isRemoveAdjustDisc, boolean isNewCalcId, boolean isNeedPopDetail) {
        return this.transferSellDetail(goods, order, isRemoveAdjustDisc, isNewCalcId, false, false);
    }

    @Override
    public SellDetail transferSellDetail(Goods goods, Order order, boolean isRemoveAdjustDisc, boolean isNewCalcId, boolean isNeedPopDetail, boolean isPrecision) {
        goods.setTempPopDetails(new ArrayList<PopDetail>());
        SellDetail sellDetail = new SellDetail();
        sellDetail.setRowNo(goods.getFlowId());
        sellDetail.setFlag(goods.getFlag());
        if (StringUtils.isNotBlank((String)goods.getSGoodsSno())) {
            sellDetail.setFlag("3");
        }
        sellDetail.setKlm(goods.getSeason());
        sellDetail.setOriginalBillNo(order.getOriginSeqNo());
        if (goods.getOriginalFlowId() != null) {
            sellDetail.setOriginalRowNo(goods.getOriginalFlowId());
        }
        sellDetail.setGz(goods.getOrgCode());
        sellDetail.setMarket(order.getShopCode());
        sellDetail.setContract(goods.getContractCode());
        sellDetail.setItemCode(goods.getGoodsCode());
        sellDetail.setItemName(goods.getGoodsName());
        sellDetail.setBarcode(goods.getBarNo());
        sellDetail.setUnitcode(goods.getGoodsUid());
        sellDetail.setFactor(goods.getPartsNum());
        sellDetail.setBrand(goods.getBrandCode());
        sellDetail.setCategory(goods.getCategoryCode());
        sellDetail.setQty(goods.getQty());
        sellDetail.setPrice(goods.getSalePrice());
        sellDetail.setListAmount(goods.getSaleValue());
        sellDetail.setTotalDiscount(goods.getTotalDiscountValue());
        sellDetail.setSaleAmount(goods.getSaleAmount());
        sellDetail.setNojf(goods.getNojf());
        sellDetail.setManaUnit(order.getErpCode());
        sellDetail.setCounter(goods.getSeason());
        sellDetail.setSupplier(goods.getVenderCode());
        sellDetail.setQtyrecalc(goods.getQtyrecalc());
        if (!isNewCalcId) {
            sellDetail.setQtyrecalcAmount(goods.getQtyrecalcAmount());
            sellDetail.setQtyrecalcEvtid(goods.getQtyrecalcEvtid());
        }
        if (goods.getIsNoBackGift()) {
            sellDetail.setPopTag("Y");
            sellDetail.setFlag("0");
        }
        if (StringUtils.isNotBlank((String)order.getStaffCardNo())) {
            sellDetail.setPopTag("S");
        }
        if ("32".equals(goods.getGoodsType())) {
            sellDetail.setPopTag("M");
        }
        if (order.getHasGroupBuy()) {
            sellDetail.setPopTag("G");
        }
        if ("YS1".equals(order.getOrderType())) {
            sellDetail.setPopTag("PRESALE");
        }
        if (StringUtils.isNotBlank((String)goods.getDiscountFlag()) && ("0".equals(goods.getDiscountFlag()) || "1".equals(goods.getDiscountFlag()))) {
            sellDetail.setPopTag(goods.getDiscountFlag());
        }
        if (SellType.NOPOP(order.getOrderType())) {
            sellDetail.setFlag("Z");
        }
        if ("Z1".equals(order.getOrderType()) || "Z2".equals(order.getOrderType())) {
            sellDetail.setFlag("J");
        }
        if (3 == order.getPopMode()) {
            sellDetail.setFlag("J");
        }
        if (4 == order.getPopMode()) {
            sellDetail.setFlag("Z");
        }
        if (null != order.getConsumersData() && "MOHO".equals(order.getConsumersData().getConsumersType())) {
            sellDetail.setFlag("Z");
        }
        if ("Y".equals(goods.getEscaleFlag())) {
            if (0 == order.getSysPara().getYpopDzcMode()) {
                sellDetail.setFlag("1");
            }
            if (1 == order.getSysPara().getYpopDzcMode()) {
                sellDetail.setFlag("4");
            } else if (2 == order.getSysPara().getYpopDzcMode() || 3 == order.getSysPara().getYpopDzcMode()) {
                sellDetail.setFlag("1");
                if (goods.getEWCCodeAmount() > 0.0 && goods.getEWCCodeNum() <= 0.0) {
                    sellDetail.setFlag("E");
                    if (isNewCalcId) {
                        sellDetail.setQty(goods.getQuantityRecalc());
                        sellDetail.setSaleAmount(goods.getEWCCodeAmount());
                        sellDetail.setQtyrecalc(0);
                    }
                    if (ManipulatePrecision.doubleCompare(goods.getListPrice(), 0.0, 2) == 0) {
                        sellDetail.setFlag("Y");
                    }
                } else if (goods.getEWCCodeAmount() > 0.0 && goods.getEWCCodeNum() > 0.0) {
                    sellDetail.setFlag("5");
                    sellDetail.setQty(goods.getEWCCodeNum());
                    sellDetail.setListAmount(goods.getEWCCodeAmount());
                    sellDetail.setPrice(goods.getListPrice());
                    sellDetail.setQtyrecalcAmount(goods.getEWCCodeAmount());
                    if (3 == order.getSysPara().getYpopDzcMode()) {
                        sellDetail.setIsdzc("P");
                        if (3 == order.getPopMode()) {
                            sellDetail.setIsdzc("Z");
                        }
                        if (ManipulatePrecision.doubleCompare(goods.getListPrice(), 0.0, 2) > 0) {
                            if (goods.getSalePrice() > goods.getListPrice()) {
                                sellDetail.setListAmount(ManipulatePrecision.doubleConvert(goods.getListPrice() * goods.getEWCCodeNum()));
                                sellDetail.setQtyrecalcAmount(sellDetail.getListAmount());
                            }
                        } else {
                            sellDetail.setPrice(goods.getSalePrice());
                        }
                    }
                }
            }
        }
        if (order.getPopMode() == 3) {
            sellDetail.setFlag("J");
        }
        if (StringUtils.isNotBlank((String)goods.getPopFlag()) && !"7".equals(goods.getFlag())) {
            sellDetail.setFlag(goods.getPopFlag());
        }
        if (SellType.NOPOP(order.getOrderType()) && !SellType.ISEXERCISE(order.getOrderType())) {
            sellDetail.setFlag("Z");
        }
        if (null != order.getConsumersData() && StringUtils.isNotBlank((String)order.getConsumersData().getLoginMode()) && "2".equals(order.getConsumersData().getLoginMode())) {
            sellDetail.setFlag("T");
        }
        boolean isSpecifyBack = false;
        boolean isHaveBarcodeDisc = false;
        if (SellType.ISBACK(order.getOrderType()) && StringUtils.isNotBlank((String)order.getOriginTerminalSno())) {
            isSpecifyBack = true;
        }
        if ("E".equals(sellDetail.getFlag()) && !isSpecifyBack && ManipulatePrecision.doubleCompare(order.getRemainValue(), 0.0, 2) > 0) {
            sellDetail.setListAmount(goods.getEWCCodeAmount());
        }
        if ("2".equals(goods.getGoodsType())) {
            sellDetail.setCounter(goods.getParentGoodsCode());
        }
        if (order.getStaffSale()) {
            if (goods.getTempZzkDiscount() == 0.0 && goods.getTempZzrDiscount() == 0.0 && goods.getTempZrDiscount() == 0.0 && goods.getTempZkDiscount() == 0.0) {
                sellDetail.setKlm("STAFF");
                goods.setKlm("STAFF");
            } else {
                goods.setKlm("");
            }
        } else {
            goods.setKlm("");
        }
        if (!isSpecifyBack) {
            if (null != goods.getPopDetailsInfo() && goods.getPopDetailsInfo().size() > 0) {
                if (null == sellDetail.getSellPopDetails()) {
                    sellDetail.setSellPopDetails(new ArrayList<SellPopDetail>());
                }
                for (PopDetail popDetail : goods.getPopDetailsInfo()) {
                    if (isRemoveAdjustDisc && YPopStatusType.pop_policy_group_grant_goods.equals(popDetail.getPopPolicyGroup())) continue;
                    if (YPopStatusType.pop_policy_group_barcode_discA.equals(popDetail.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_barcode_discB.equals(popDetail.getPopPolicyGroup())) {
                        if (isNewCalcId) {
                            // empty if block
                        }
                        isHaveBarcodeDisc = true;
                    } else if (isNewCalcId && !isNeedPopDetail) continue;
                    sellDetail.getSellPopDetails().add(this.popdetailTransfer.transferSellPopDetail(popDetail, order, goods));
                }
            }
        } else if (SellType.ISBACK(order.getOrderType()) && goods.getFlag().equals("0") && null != goods.getPopDetailsInfo() && goods.getPopDetailsInfo().size() > 0) {
            if (null == sellDetail.getSellPopDetails()) {
                sellDetail.setSellPopDetails(new ArrayList<SellPopDetail>());
            }
            for (PopDetail popDetail : goods.getPopDetailsInfo()) {
                sellDetail.getSellPopDetails().add(this.popdetailTransfer.transferSellPopDetail(popDetail, order, goods));
            }
        }
        if (null != goods.getOutCouponUses() && goods.getOutCouponUses().size() > 0) {
            if (null == sellDetail.getCouponUses()) {
                sellDetail.setCouponUses(new ArrayList<SellCouponUse>());
            }
            for (CouponUse couponUse : goods.getOutCouponUses()) {
                sellDetail.getCouponUses().add(this.couponTransfer.transferSellCouponUse(couponUse));
            }
        }
        if (ManipulatePrecision.doubleConvert(goods.getTotalDiscountValue() - goods.getPopDiscountValue(), 2, 1) > 0.0) {
            if (null == sellDetail.getSellPopDetails()) {
                sellDetail.setSellPopDetails(new ArrayList<SellPopDetail>());
            }
            if (SellType.ISSALE(order.getOrderType()) || null == order.getOriginIdSheetNo() || order.getOriginIdSheetNo().equals("")) {
                SellPopDetail sellPopDetail;
                if (!isRemoveAdjustDisc) {
                    if (ManipulatePrecision.doubleCompare(goods.getTempZzkDiscount(), 0.0, 2) > 0) {
                        sellPopDetail = new SellPopDetail();
                        sellPopDetail.setPopEventBillId("0");
                        sellPopDetail.setDiscountAmount(ManipulatePrecision.doubleConvert(goods.getTempZzkDiscount(), 6, 1));
                        sellPopDetail.setPopMode("0");
                        sellPopDetail.setPopPolicyGroup(this.getGrantOrderYPopStatusType());
                        sellPopDetail.setPopDescribe("[" + order.getSysPara().getZpRateDes() + order.getTempZzk() + "%]");
                        sellPopDetail.setPopMemo("PRE:0");
                        if (StringUtils.isNotBlank((String)goods.getFdmode())) {
                            sellPopDetail.setPopMemo("fdmode:" + goods.getFdmode() + ",fdzkfd:" + goods.getFdzkfd());
                        }
                        sellPopDetail.setPopPolicyType(YPopStatusType.pop_type_order);
                        sellPopDetail.setRowNo(goods.getFlowId());
                        sellDetail.getSellPopDetails().add(sellPopDetail);
                    }
                    if (ManipulatePrecision.doubleCompare(goods.getTempZzrDiscount(), 0.0, 2) > 0) {
                        sellPopDetail = new SellPopDetail();
                        sellPopDetail.setPopEventBillId("0");
                        sellPopDetail.setDiscountAmount(ManipulatePrecision.doubleConvert(goods.getTempZzrDiscount(), 6, 1));
                        sellPopDetail.setPopMode("0");
                        sellPopDetail.setPopPolicyGroup(this.getGrantOrderYPopStatusType());
                        sellPopDetail.setPopDescribe("[" + order.getSysPara().getZpAmountDes() + "]");
                        sellPopDetail.setPopMemo("PRE:0");
                        if (StringUtils.isNotBlank((String)goods.getFdmode())) {
                            sellPopDetail.setPopMemo("fdmode:" + goods.getFdmode() + ",fdzkfd:" + goods.getFdzkfd());
                        }
                        sellPopDetail.setPopPolicyType(YPopStatusType.pop_type_order);
                        sellPopDetail.setRowNo(goods.getFlowId());
                        sellDetail.getSellPopDetails().add(sellPopDetail);
                    }
                } else {
                    String precisionMode = DataExchageUtils.exchangePrecisionMode(goods.getPrcutMode());
                    sellDetail.setTotalDiscount(ManipulatePrecision.getDetailOverFlow(sellDetail.getTotalDiscount() - goods.getTempZzkDiscount() - goods.getTempZzrDiscount(), precisionMode));
                    sellDetail.setSaleAmount(ManipulatePrecision.getDetailOverFlow(sellDetail.getSaleAmount() + goods.getTempZzkDiscount() + goods.getTempZzrDiscount(), goods.getPrcutMode()));
                    if (!"2".equals(order.getSysPara().getOrderDiscSeq())) {
                        goods.setTempZzkDiscount(0.0);
                        goods.setTempZzrDiscount(0.0);
                        double d = ManipulatePrecision.getDetailOverFlow(goods.getTempZkDiscount() + goods.getTempZrDiscount() + goods.getTempZzkDiscount() + goods.getTempZzrDiscount() + goods.getBarcodeDiscount() + goods.getFixedDiscountValue(), precisionMode);
                        goods.setAdjustDiscountValue(d);
                    }
                }
                if (ManipulatePrecision.doubleCompare(goods.getFixedDiscountValue(), 0.0, 2) > 0) {
                    sellPopDetail = new SellPopDetail();
                    sellPopDetail.setPopEventBillId("0");
                    sellPopDetail.setDiscountAmount(ManipulatePrecision.doubleConvert(goods.getFixedDiscountValue(), 6, 1));
                    sellPopDetail.setPopMode("0");
                    sellPopDetail.setPopPolicyGroup(YPopStatusType.pop_policy_group_grant_goods);
                    sellPopDetail.setPopPolicyType(YPopStatusType.pop_type_goods);
                    sellPopDetail.setPopDescribe("[" + order.getSysPara().getDpAmountDes() + "]");
                    sellPopDetail.setPopMemo("PRE:0");
                    if (StringUtils.isNotBlank((String)goods.getFdmode())) {
                        sellPopDetail.setPopMemo("fdmode:" + goods.getFdmode() + ",fdresult:" + goods.getFdresult() + ",popzkfd:" + goods.getPopzkfd());
                    }
                    sellPopDetail.setRowNo(goods.getFlowId());
                    sellDetail.getSellPopDetails().add(sellPopDetail);
                }
                if (!isHaveBarcodeDisc && ManipulatePrecision.doubleCompare(goods.getBarcodeDiscount(), 0.0, 2) > 0) {
                    sellPopDetail = new SellPopDetail();
                    sellPopDetail.setPopEventBillId("0");
                    sellPopDetail.setDiscountAmount(ManipulatePrecision.doubleConvert(goods.getBarcodeDiscount(), 6, 1));
                    sellPopDetail.setPopMode("0");
                    sellPopDetail.setPopDescribe(order.getSysPara().getBarCodeDes());
                    sellPopDetail.setRowNo(goods.getFlowId());
                    if (goods.getDisMode() == 3) {
                        sellPopDetail.setPrcMode("6");
                        sellPopDetail.setPopPolicyGroup(YPopStatusType.pop_policy_group_barcode_discA);
                        sellPopDetail.setPopPolicyType(YPopStatusType.pop_type_barcodeA);
                        sellPopDetail.setPopDescribe("[" + order.getSysPara().getBarCodeDes() + "]");
                    } else if (goods.getDisMode() == 1) {
                        sellPopDetail.setPrcMode("6");
                        sellPopDetail.setPopPolicyGroup(YPopStatusType.pop_policy_group_barcode_discB);
                        sellPopDetail.setPopPolicyType(YPopStatusType.pop_type_barcodeB);
                    } else if (goods.getDisMode() == 2) {
                        sellPopDetail.setDiscountAmount(0.0);
                        sellPopDetail.setPrcMode("5");
                        sellPopDetail.setPopPolicyGroup(YPopStatusType.pop_policy_group_barcode_discB);
                        sellPopDetail.setPopEventType(YPopStatusType.pop_type_barcodeB);
                        sellPopDetail.setDiscountRate(ManipulatePrecision.doubleConvert(1.0 - goods.getDisValue()));
                    }
                    if (StringUtils.isNotBlank((String)goods.getFdmode())) {
                        sellPopDetail.setPopPolicyGroup(YPopStatusType.pop_policy_group_barcode_discB);
                        sellPopDetail.setPopMemo("fdmode:" + goods.getFdmode() + ",fdzkfd:" + goods.getVipfdzkfd());
                    }
                    sellDetail.getSellPopDetails().add(sellPopDetail);
                }
                if (ManipulatePrecision.doubleCompare(goods.getTempZkDiscount(), 0.0, 2) > 0) {
                    sellPopDetail = new SellPopDetail();
                    sellPopDetail.setPopEventBillId("0");
                    sellPopDetail.setDiscountAmount(ManipulatePrecision.doubleConvert(goods.getTempZkDiscount(), 6, 1));
                    sellPopDetail.setPopMode("0");
                    sellPopDetail.setPopPolicyGroup(YPopStatusType.pop_policy_group_grant_goods);
                    sellPopDetail.setPopDescribe("[" + order.getSysPara().getDpRateDes() + goods.getTempZkl() + "%]");
                    sellPopDetail.setPopMemo("PRE:0");
                    if (StringUtils.isNotBlank((String)goods.getFdmode())) {
                        sellPopDetail.setPopMemo("fdmode:" + goods.getFdmode() + ",fdzkfd:" + goods.getFdzkfd());
                    }
                    sellPopDetail.setPopPolicyType(YPopStatusType.pop_type_goods);
                    sellPopDetail.setRowNo(goods.getFlowId());
                    sellDetail.getSellPopDetails().add(sellPopDetail);
                }
                if (ManipulatePrecision.doubleCompare(goods.getTempZrDiscount(), 0.0, 2) > 0) {
                    sellPopDetail = new SellPopDetail();
                    sellPopDetail.setPopEventBillId("0");
                    sellPopDetail.setDiscountAmount(ManipulatePrecision.doubleConvert(goods.getTempZrDiscount(), 6, 1));
                    sellPopDetail.setPopMode("0");
                    sellPopDetail.setPopPolicyGroup(YPopStatusType.pop_policy_group_grant_goods);
                    sellPopDetail.setPopDescribe("[" + order.getSysPara().getDpAmountDes() + "]");
                    sellPopDetail.setPopMemo("PRE:0");
                    if (StringUtils.isNotBlank((String)goods.getFdmode())) {
                        sellPopDetail.setPopMemo("fdmode:" + goods.getFdmode() + ",fdzkfd:" + goods.getFdzkfd());
                    }
                    sellPopDetail.setPopPolicyType(YPopStatusType.pop_type_goods);
                    sellPopDetail.setRowNo(goods.getFlowId());
                    sellDetail.getSellPopDetails().add(sellPopDetail);
                }
                if (goods.getCustomDiscountValue() > 0.0) {
                    sellPopDetail = new SellPopDetail();
                    sellPopDetail.setPopEventBillId("0");
                    sellPopDetail.setDiscountAmount(ManipulatePrecision.doubleConvert(goods.getCustomDiscountValue(), 6, 1));
                    sellPopDetail.setPopMode("0");
                    sellPopDetail.setPopPolicyGroup(YPopStatusType.pop_policy_group_grant_goods);
                    sellPopDetail.setPopPolicyType(YPopStatusType.pop_ghcard_goods);
                    sellPopDetail.setPopMemo("PRE:0");
                    sellPopDetail.setRowNo(goods.getFlowId());
                    sellPopDetail.setPopDescribe("\u5de5\u4f1a\u6298\u6263");
                    sellDetail.getSellPopDetails().add(sellPopDetail);
                }
                if (goods.getMealDiscountValue() > 0.0) {
                    sellPopDetail = new SellPopDetail();
                    sellPopDetail.setPopEventBillId("0");
                    sellPopDetail.setDiscountAmount(ManipulatePrecision.doubleConvert(goods.getMealDiscountValue(), 6, 1));
                    sellPopDetail.setPopMode("0");
                    sellPopDetail.setPopPolicyGroup(YPopStatusType.pop_policy_group_grant_goods);
                    sellPopDetail.setPopMemo("PRE:1");
                    sellPopDetail.setRowNo(goods.getFlowId());
                    sellDetail.getSellPopDetails().add(sellPopDetail);
                }
                if (goods.getStudentCardDiscountValue() > 0.0) {
                    sellPopDetail = new SellPopDetail();
                    sellPopDetail.setPopEventBillId("0");
                    sellPopDetail.setDiscountAmount(ManipulatePrecision.doubleConvert(goods.getStudentCardDiscountValue(), 6, 1));
                    sellPopDetail.setPopMode("0");
                    sellPopDetail.setPopPolicyGroup(YPopStatusType.pop_policy_group_aeoncoupon);
                    sellPopDetail.setPopDescribe("[" + order.getSysPara().getXzkDes() + goods.getStudentCardDiscountValue() + "$]");
                    sellPopDetail.setPopMemo("PRE:1");
                    sellPopDetail.setRowNo(goods.getFlowId());
                    sellDetail.getSellPopDetails().add(sellPopDetail);
                }
            }
        }
        sellDetail.setOriginalBillNo(order.getOriginFlowNo());
        if (goods.getOriginalFlowId() != null) {
            sellDetail.setOriginalRowNo(goods.getOriginalFlowId());
        }
        if (goods.getOriginalFlowId() == null || goods.getOriginalFlowId() == 0) {
            sellDetail.setOriginalRowNo(goods.getFlowId());
        }
        return sellDetail;
    }

    @Override
    public OrdersDetailModel transferOrdersDetailModel(Goods g) {
        OrdersDetailModel d = new OrdersDetailModel();
        d.setBonusPointAmount(BigDecimal.valueOf(g.getBonusPointAmount()));
        d.setScanCode(g.getGoodsNo());
        d.setAssistantId(g.getAssistantId());
        d.setSaleSpec(g.getSaleSpec());
        d.setCabinetGroup(g.getOrgCode());
        d.setGoodsName(g.getGoodsName());
        d.setEnFname(g.getEnFname());
        d.setRowNo(g.getFlowId());
        d.setGoodsCode(g.getGoodsCode());
        d.setBarNo(g.getBarNo());
        d.setBrandCode(g.getBrandCode());
        d.setGoodsUid(g.getGoodsUid());
        d.setCategoryCode(g.getCategoryCode());
        d.setKlm(g.getKlm());
        d.setGoodType(g.getGoodsType());
        d.setGoodsFlag(g.getFlag());
        d.setPopTag(g.getPopFlag());
        d.setSalePrice(BigDecimal.valueOf(g.getSalePrice()));
        d.setListPrice(BigDecimal.valueOf(g.getListPrice()));
        if (d.getListPrice().compareTo(BigDecimal.ZERO) == 0) {
            d.setListPrice(d.getSalePrice());
        }
        d.setPartsNum(g.getPartsNum());
        d.setQty(g.getQty());
        d.setSaleUnit(g.getSaleUnit());
        d.setSaleValue(BigDecimal.valueOf(g.getSaleValue()));
        d.setCouponValue(BigDecimal.valueOf(g.getCouponValue()));
        d.setPopDiscountValue(BigDecimal.valueOf(ManipulatePrecision.doubleConvert(g.getPopDiscountValue() - g.getNoDisAmountValue(), 2, 1)));
        d.setAdjustDiscountValue(BigDecimal.valueOf(ManipulatePrecision.doubleConvert(g.getAdjustDiscountValue(), 2, 1)));
        d.setPayDiscountValue(BigDecimal.valueOf(g.getNoDisAmountValue()));
        d.setTotalDiscountValue(BigDecimal.valueOf(g.getTotalDiscountValue()));
        d.setCustomDiscountValue(BigDecimal.valueOf(g.getCustomDiscountValue()));
        d.setSaleAmount(BigDecimal.valueOf(g.getSaleAmount()));
        d.setWeight(g.getWeight());
        d.setWeighGood(this.transferWeighGood(g.getEscaleFlag()));
        d.setSsgid(Long.valueOf(g.getSsgid()));
        d.setSmGoodsSno(g.getSGoodsSno());
        d.setSmGoodsCode(g.getSGoodsCode());
        d.setCategoryPropertys(JSON.toJSONString(g.getCategoryPropertys()));
        d.setVenderCode(g.getVenderCode());
        if (g.getEWCCodeNum() > 0.0) {
            d.setCopies(1);
        } else {
            d.setCopies((int)g.getQty());
        }
        d.setStallCode(g.getStallCode());
        d.setAllowReturnCopies(CastUtil.castDouble(g.getAllowReturnCopies()));
        d.setMealDiscountValue(BigDecimal.valueOf(g.getMealDiscountValue()));
        d.setEatWay(g.getEatWay());
        d.setStallCode(g.getStallCode());
        d.setControlFlag(g.getControlFlag());
        d.setLicense(g.getLicense());
        d.setPrtDuplFlag(g.getPrtDuplFlag());
        d.setPrcutMode(g.getPrcutMode());
        d.setGoodsDesc(g.getGoodsDesc());
        d.setContractCode(g.getBackPrintNo());
        d.setProcessFlag(g.getProcessFlag());
        d.setRemark(g.getRemark());
        d.setEBillFlowNo(g.getEBillFlowNo());
        return d;
    }

    @Override
    public boolean transferWeighGood(String escaleFlag) {
        return "Y".equals(escaleFlag);
    }

    @Override
    public Goods transferGoods2(OrdersDetailModel g) {
        Goods goods = new Goods();
        goods.setGuid(UUIDUtils.buildGuid());
        goods = this.SaleOrderDetailToGoods(goods, g);
        goods.setPopDetailsInfo(new ArrayList<PopDetail>());
        return goods;
    }

    @Override
    public Goods transferGoods2(SaleOrderDetailModel g) {
        Goods goods = new Goods();
        goods.setGuid(UUIDUtils.buildGuid());
        goods = this.SaleOrderDetailToGoods(goods, g);
        goods.setPopDetailsInfo(new ArrayList<PopDetail>());
        return goods;
    }

    @Override
    public Goods SaleOrderDetailToGoods(Goods goods, OrdersDetailModel sod) {
        String extendFt10;
        goods.setBonusPointAmount(CastUtil.castDouble(sod.getBonusPointAmount()));
        goods.setOrgCode(sod.getCabinetGroup());
        goods.setGoodsName(sod.getGoodsName());
        goods.setEnFname(sod.getEnFname());
        goods.setEnSname(sod.getEnSname());
        goods.setFlowId(sod.getRowNo());
        goods.setGoodsCode(sod.getGoodsCode());
        goods.setGoodsNo(sod.getScanCode());
        goods.setBarNo(sod.getBarNo());
        goods.setBrandCode(sod.getBrandCode());
        goods.setCategoryCode(sod.getCategoryCode());
        goods.setGoodsUid(sod.getGoodsUid());
        goods.setKlm(sod.getKlm());
        goods.setSkuId(sod.getSpuCode());
        goods.setSaleSpec(sod.getSaleSpec());
        goods.setGoodsType(sod.getGoodType());
        goods.setFlag(sod.getGoodsFlag());
        goods.setPopFlag(sod.getPopTag());
        goods.setSalePrice(CastUtil.castDouble(sod.getSalePrice()));
        goods.setListPrice(CastUtil.castDouble(sod.getListPrice()));
        goods.setPartsNum(sod.getPartsNum());
        goods.setQty(sod.getQty());
        goods.setSaleUnit(sod.getSaleUnit());
        goods.setCouponValue(CastUtil.castDouble(sod.getCouponValue()));
        goods.setPopDiscountValue(ManipulatePrecision.doubleConvert(CastUtil.castDouble(sod.getPopDiscountValue()) + CastUtil.castDouble(sod.getPayDiscountValue())));
        goods.setAdjustDiscountValue(CastUtil.castDouble(sod.getAdjustDiscountValue()));
        goods.setNoDisAmountValue(CastUtil.castDouble(sod.getPayDiscountValue()));
        goods.setTotalDiscountValue(ManipulatePrecision.doubleConvert(CastUtil.castDouble(sod.getTotalDiscountValue())));
        goods.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(goods.getTotalDiscountValue() - goods.getNoDisAmountValue()));
        goods.setCustomDiscountValue(CastUtil.castDouble(sod.getCustomDiscountValue()));
        goods.setSaleAmount(CastUtil.castDouble(sod.getSaleAmount()));
        goods.setRealSalePrice(ManipulatePrecision.doubleConvert(goods.getSalePrice() - goods.getNoDisAmountValue() / goods.getQty()));
        goods.setVenderId(sod.getVenderCode());
        goods.setWeight(sod.getWeight());
        goods.setEscaleFlag(sod.getWeighGood() != false ? "Y" : "N");
        goods.setSsgid("" + sod.getSsgid());
        goods.setSGoodsSno(sod.getSmGoodsSno());
        goods.setSGoodsCode(sod.getSmGoodsCode());
        goods.setPrtDuplFlag(sod.getPrtDuplFlag());
        goods.setStallCode(sod.getStallCode());
        goods.setAllowReturnCopies(CastUtil.castDouble(sod.getAllowReturnCopies()));
        goods.setMealDiscountValue(CastUtil.castDouble(sod.getMealDiscountValue()));
        goods.setPopDetailsInfo(new ArrayList<PopDetail>());
        goods.setCouponUses(new ArrayList<CouponUse>());
        goods.setCouponGains(new ArrayList<CouponGain>());
        goods.setPrcutMode(sod.getPrcutMode());
        goods.setLicense(sod.getLicense());
        goods.setGoodsDesc(sod.getGoodsDesc());
        double saleValue = ManipulatePrecision.doubleConvert(CastUtil.castDouble(sod.getTotalDiscountValue()) + CastUtil.castDouble(sod.getSaleAmount()), 2, 1);
        goods.setSaleValue(saleValue);
        if ("Y".equals(goods.getEscaleFlag())) {
            goods.setEWCCodeAmount(ManipulatePrecision.sub(goods.getSaleValue(), goods.getNoDisAmountValue()));
        }
        goods.setBackPrintNo(sod.getContractCode());
        goods.setEatWay(sod.getEatWay());
        goods.setProcessFlag(sod.getProcessFlag());
        goods.setVenderCode(sod.getVenderCode());
        goods.setAssistantId(sod.getAssistantId());
        goods.setWlScDate(sod.getWlScDate());
        goods.setWlCode(sod.getWlCode());
        goods.setWlBatch(sod.getWlBatch());
        goods.setWlBottleCode(sod.getContractCode());
        goods.setRemark(sod.getRemark());
        goods.setEBillFlowNo(sod.getEBillFlowNo());
        goods.setHandmadeNumber(sod.getHandmadeNumber());
        if (null != sod.getHandmadeFalg()) {
            goods.setHandmadeFlag(sod.getHandmadeFalg());
        }
        goods.setFdzkfd(CastUtil.castDouble(sod.getHandmadeRate()));
        String extendFt9 = sod.getExtendFt9();
        if (StringUtils.isNotBlank((String)extendFt9)) {
            String[] printDetails = extendFt9.split("\\|");
            goods.setArtNo(printDetails[0]);
            goods.setSizeName(printDetails[1]);
            goods.setOrgName(printDetails[2]);
        }
        if (StringUtils.isNotBlank((String)(extendFt10 = sod.getExtendFt10()))) {
            String[] printDetails = extendFt10.split("\\|");
            goods.setCategoryName(printDetails[0]);
            goods.setBrandName(printDetails[1]);
        }
        goods.setExtendFt2(sod.getExtendFt2());
        goods.setExtendFt3(sod.getExtendFt3());
        goods.setMemo(sod.getExtendFt4());
        goods.setOutputTax(CastUtil.castDouble(sod.getExtendFt5()));
        return goods;
    }

    @Override
    public String transEscaleFlag(boolean weighGood) {
        if (weighGood) {
            return "Y";
        }
        return "N";
    }

    @Override
    public List<SellDetail> transferSellDetail(List<Goods> goodses, Order order, boolean isRemoveAdjustDisc, boolean isNewCalcId) {
        return this.transferSellDetail(goodses, order, isRemoveAdjustDisc, isNewCalcId, false);
    }

    @Override
    public List<SellDetail> transferSellDetail(List<Goods> goodses, Order order, boolean isRemoveAdjustDisc, boolean isNewCalcId, boolean isMember) {
        if (goodses == null || goodses.size() == 0) {
            return null;
        }
        ArrayList<SellDetail> sellDetails = new ArrayList<SellDetail>();
        for (Goods goods : goodses) {
            double tempzk = goods.getTempZkDiscount();
            double tempzr = goods.getTempZrDiscount();
            if (isMember) {
                goods.setTempZkDiscount(0.0);
                goods.setTempZrDiscount(0.0);
            }
            SellDetail sellDetail = this.transferSellDetail(goods, order, isRemoveAdjustDisc, isNewCalcId);
            sellDetails.add(sellDetail);
            if (!isMember) continue;
            goods.setTempZkDiscount(tempzk);
            goods.setTempZrDiscount(tempzr);
        }
        return sellDetails;
    }

    @Override
    public Goods findGoods(String guid, List<Goods> goodsList) {
        Goods result = null;
        for (Goods goods : goodsList) {
            if (!guid.equals(goods.getGuid())) continue;
            result = goods;
            break;
        }
        return result;
    }

    @Override
    public List<Goods> findGoodsByGoodsNo(String goodsNo, List<Goods> goodsList) {
        ArrayList<Goods> matchList = new ArrayList<Goods>();
        for (int i = goodsList.size() - 1; i >= 0; --i) {
            Goods goods = goodsList.get(i);
            if (!goodsNo.equals(goods.getGoodsNo()) || !StringUtils.isBlank((String)goods.getEBillFlowNo())) continue;
            matchList.add(goods);
        }
        return matchList;
    }

    @Override
    public void transferGoodsInfoToGoods(GoodsInfo goodsInfo, Goods goods, double qty) {
        BeanUtils.copyProperties((Object)goodsInfo, (Object)goods);
        goods.setRecycleFee(goodsInfo.getRecycleFee());
        goods.setControlFlag(goodsInfo.getControlFlag());
        goods.setOrgCode(goodsInfo.getOrgCode());
        goods.setCategoryCode(goodsInfo.getCategoryCode());
        goods.setCategoryCode(goodsInfo.getCategoryCode());
        goods.setArtCode(goodsInfo.getArtCode());
        goods.setIsfresh(goodsInfo.getIsfresh());
        goods.setBrandCode(goodsInfo.getBrandCode());
        goods.setBrandCode(goodsInfo.getBrandCode());
        goods.setGoodsUid(goodsInfo.getGuCode());
        goods.setBrandName(goodsInfo.getBrandName());
        goods.setSaleUnit(goodsInfo.getPartsUnit());
        goods.setPartsNum(goodsInfo.getPartsNum());
        goods.setMainBarcodeFlag(goodsInfo.getMainBarcodeFlag());
        goods.setPcs(goodsInfo.getPcs());
        if (goodsInfo.getEscaleFlag() == 0) {
            goods.setEscaleFlag("N");
        } else {
            goods.setEscaleFlag(goodsInfo.getEscaleFlag() == 1 ? "Y" : "N");
        }
        goods.setMinDiscount(goodsInfo.getMinDiscount());
        goods.setMinSalePrice(ManipulatePrecision.getDetailOverFlow(goodsInfo.getMinSalePrice(), goodsInfo.getPrcutMode()));
        goods.setRemark(goodsInfo.getRemark());
        goods.setImageUrl(goodsInfo.getImageUrl());
        goods.setEnFname(goodsInfo.getEnFname());
        goods.setPrimeCost(goodsInfo.getPrimeCost());
        goods.setGoodsName(goodsInfo.getGoodsName());
        goods.setGoodsType(goodsInfo.getGoodsType());
        goods.setBarNo(goodsInfo.getBarNo());
        goods.setGoodsCode(goodsInfo.getGoodsCode());
        goods.setListPrice(goodsInfo.getSalePrice());
        goods.setSalePrice(ManipulatePrecision.getDetailOverFlow(goodsInfo.getSalePrice(), goodsInfo.getPrcutMode()));
        goods.setRealSalePrice(goodsInfo.getSalePrice());
        goods.setMemberPrice(goodsInfo.getMemberPrice());
        goods.setBulkPrice(goodsInfo.getBulkPrice());
        goods.setWholeSalePrice(goodsInfo.getWholeSalePrice());
        goods.setOutputTax(goodsInfo.getOutputTax());
        goods.setSkuId(goodsInfo.getSkuId());
        if (StringUtils.isNotBlank((String)goodsInfo.getSeason()) && !"0".equals(goodsInfo.getSeason())) {
            goods.setSeason(goodsInfo.getSeason());
        }
        goods.setQty(qty);
        goods.setSaleValue(ManipulatePrecision.doubleConvert(goods.getSalePrice() * goods.getQty(), 2, 1));
        goods.setSaleAmount(goods.getSaleValue() - goods.getTotalDiscountValue());
        goods.setSsgid("" + goodsInfo.getSsgid());
        goods.setControlFlag(goodsInfo.getControlFlag());
        goods.setCategoryPropertys(goodsInfo.getCategoryPropertys());
        goods.setRecycleFee(goodsInfo.getRecycleFee());
        goods.setPrtDuplFlag(goodsInfo.getPrtDuplFlag());
        goods.setSsgid("" + goodsInfo.getSsgid());
        goods.setProcessFlag(goodsInfo.getProcessFlag());
        goods.setTempCategory(goodsInfo.getCategoryCode());
        goods.setVenderCode(goodsInfo.getVenderCode());
        goods.setPrcutMode(goodsInfo.getPrcutMode());
        goods.setGoodsStatus(goodsInfo.getGoodsStatus());
        goods.setGbmanamode(goodsInfo.getGbmanamode());
        goods.setSaleSpec(goodsInfo.getSaleSpec());
        goods.setIsExcessSale(goodsInfo.getIsExcessSale());
        goods.setColourCode(goodsInfo.getColourCode());
        goods.setColourName(goodsInfo.getColourName());
        goods.setSizeCode(goodsInfo.getSizeCode());
        goods.setSizeName(goodsInfo.getSizeName());
        goods.setParentGoodsCode(goodsInfo.getParentGoodsCode());
        goods.setIsWeight(goodsInfo.getIsdetachable() ? "Y" : "N");
        goods.setOrgName(goodsInfo.getOrgName());
        goods.setBrandName(goodsInfo.getBrandName());
        goods.setCategoryName(goodsInfo.getCategoryName());
        goods.setArtNo(goodsInfo.getArtNo());
        goods.setMachineCode(goodsInfo.getMachineCode());
        goods.setOperateFlag(goodsInfo.getOperateFlag());
        goods.setJdcouponAmount(goodsInfo.getJdcouponAmount());
    }

    @Override
    public List<Goods> transferGoodsList(List<GoodsInfo> goodsInfoList) {
        ArrayList<Goods> goodsList = new ArrayList<Goods>();
        for (GoodsInfo goodsInfo : goodsInfoList) {
            Goods goods = new Goods();
            this.transferGoodsInfoToGoods(goodsInfo, goods, 1.0);
            goodsList.add(goods);
        }
        return goodsList;
    }

    @Override
    public List<Goods> transferGoodsList(List<GoodsInfo> goodsInfoList, String goodsNo) {
        ArrayList<Goods> goodsList = new ArrayList<Goods>();
        for (GoodsInfo goodsInfo : goodsInfoList) {
            Goods goods = new Goods();
            this.transferGoodsInfoToGoods(goodsInfo, goods, 1.0);
            goods.setGoodsNo(goodsNo);
            goodsList.add(goods);
        }
        return goodsList;
    }

    @Override
    public List<Goods> delMealGoods(String sGoodsSno, List<Goods> goodsList) {
        for (int i = 0; i < goodsList.size(); ++i) {
            Goods goods = goodsList.get(i);
            if (!sGoodsSno.equals(goods.getSGoodsSno())) continue;
            goodsList.remove(i);
            --i;
        }
        return goodsList;
    }

    @Override
    public List<GoodsForPos> transferGoodsToPosGoodsListForSave(List<Goods> goodsList, List<String> calcPriceType, boolean editDescribe) {
        ArrayList<GoodsForPos> list = new ArrayList<GoodsForPos>();
        for (Goods sg : goodsList) {
            if (sg.getIsNoBackGift()) continue;
            list.add(this.transferGoodsToPosGoods(sg, calcPriceType, editDescribe));
        }
        return list;
    }

    @Override
    public List<GoodsForPos> transferGoodsToPosGoodsList(List<Goods> goodsList, List<String> calcPriceType, boolean editDescribe) {
        ArrayList<GoodsForPos> list = new ArrayList<GoodsForPos>();
        if (null != goodsList) {
            for (Goods sg : goodsList) {
                if (sg.getIsNoBackGift()) continue;
                list.add(this.transferGoodsToPosGoods(this.removeSinglePopDetails(sg), calcPriceType, editDescribe));
            }
        }
        return list;
    }

    @Override
    public List<GoodsForPos> transferGoodsToPosGoodsListSingle(List<Goods> goodsList, List<String> calcPriceType, boolean isback) {
        ArrayList<GoodsForPos> list = new ArrayList<GoodsForPos>();
        if (null != goodsList) {
            for (Goods sg : goodsList) {
                if (sg.getIsNoBackGift()) continue;
                list.add(this.transferGoodsToPosGoods(this.removeSinglePopDetails(sg), calcPriceType, true, isback));
            }
        }
        return list;
    }

    @Override
    public List<GoodsForPos> transferGoodsToPosGoodsListSingle(List<Goods> goodsList, List<String> calcPriceType) {
        return this.transferGoodsToPosGoodsListSingle(goodsList, calcPriceType, false);
    }

    @Override
    public List<GoodsForPos> transferReturnGoodsToPosGoodsListSingle(List<Goods> goodsList, List<String> calcPriceType) {
        ArrayList<GoodsForPos> list = new ArrayList<GoodsForPos>();
        if (null != goodsList) {
            for (Goods sg : goodsList) {
                if (sg.getIsNoBackGift()) continue;
                list.add(this.transferGoodsToNoAdjustPosGoods(this.removeSinglePopDetails(sg), calcPriceType, true));
            }
        }
        return list;
    }

    @Override
    public Goods deepClone(Goods goods) {
        try {
            Goods newsg = new Goods();
            newsg = (Goods)goods.clone();
            if (null != goods.getPopDetailsInfo() && goods.getPopDetailsInfo().size() > 0) {
                newsg.setPopDetailsInfo(new ArrayList<PopDetail>());
                for (PopDetail pop : goods.getPopDetailsInfo()) {
                    PopDetail newPop = new PopDetail();
                    newPop = (PopDetail)pop.clone();
                    newsg.getPopDetailsInfo().add(newPop);
                }
            }
            if (null != goods.getCouponUses() && goods.getCouponUses().size() > 0) {
                newsg.setCouponUses(new ArrayList<CouponUse>());
                for (CouponUse couponUse : goods.getCouponUses()) {
                    CouponUse newCouponUse = (CouponUse)couponUse.clone();
                    newsg.getCouponUses().add(newCouponUse);
                }
            }
            if (null != goods.getCouponGains() && goods.getCouponGains().size() > 0) {
                newsg.setCouponGains(new ArrayList<CouponGain>());
                for (CouponGain couponGain : goods.getCouponGains()) {
                    CouponGain newCouponGain = (CouponGain)couponGain.clone();
                    newsg.getCouponGains().add(newCouponGain);
                }
            }
            if (null != goods.getCategoryPropertys() && goods.getCategoryPropertys().size() > 0) {
                newsg.setCategoryPropertys(new ArrayList<CategoryProperty>());
                for (CategoryProperty property : goods.getCategoryPropertys()) {
                    CategoryProperty newProperty = (CategoryProperty)property.clone();
                    newsg.getCategoryPropertys().add(newProperty);
                }
            }
            return newsg;
        }
        catch (Exception e) {
            e.printStackTrace();
            return goods;
        }
    }

    @Override
    public Goods deepCloneWithOutPopInfo(Goods goods) {
        try {
            Goods newsg = new Goods();
            newsg = (Goods)this.clone();
            newsg.setPopDetailsInfo(new ArrayList<PopDetail>());
            newsg.setCouponUses(new ArrayList<CouponUse>());
            newsg.setCouponGains(new ArrayList<CouponGain>());
            if (null != goods.getCategoryPropertys() && goods.getCategoryPropertys().size() > 0) {
                newsg.setCategoryPropertys(new ArrayList<CategoryProperty>());
                for (CategoryProperty property : goods.getCategoryPropertys()) {
                    CategoryProperty newProperty = (CategoryProperty)property.clone();
                    newsg.getCategoryPropertys().add(newProperty);
                }
            }
            newsg.setCategoryPropertys(new ArrayList<CategoryProperty>());
            return newsg;
        }
        catch (Exception e) {
            e.printStackTrace();
            return goods;
        }
    }

    @Override
    public Goods removeConditionPopDetails(Goods orsg, List<String> calcPriceType) {
        if (null == orsg.getPopDetailsInfo() || orsg.getPopDetailsInfo().size() == 0) {
            return orsg;
        }
        Goods sg = orsg.deepClone();
        ArrayList<PopDetail> popDetails = new ArrayList<PopDetail>();
        for (int i = 0; i < sg.getPopDetailsInfo().size(); ++i) {
            PopDetail pop = sg.getPopDetailsInfo().get(i);
            if (!"0".equals(pop.getPopMode()) || null != pop.getPopPolicyType() && null != calcPriceType && calcPriceType.indexOf(pop.getPopPolicyType()) != -1 || YPopStatusType.pop_policy_group_point.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_pointbase.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_pointuse.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_needCoupon.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_couponuse.equals(pop.getPopPolicyGroup()) || null == pop.getPopPolicyGroup()) continue;
            if (YPopStatusType.pop_policy_group_barcode_discA.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_barcode_discB.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_vip.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_prefe.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_grant_goods.equals(pop.getPopPolicyGroup())) {
                popDetails.add((PopDetail)pop.clone());
                continue;
            }
            if (YPopStatusType.pop_policy_group_grant_order.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_gift.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_promotion.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_discount.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_vipe.equals(pop.getPopPolicyGroup())) {
                popDetails.add((PopDetail)pop.clone());
                continue;
            }
            if (!YPopStatusType.pop_policy_group_aeoncoupon.equals(pop.getPopPolicyGroup()) && !YPopStatusType.pop_policy_group_pointEx.equals(pop.getPopPolicyGroup()) && !YPopStatusType.pop_policy_group_paydisc.equals(pop.getPopPolicyGroup())) continue;
            popDetails.add((PopDetail)pop.clone());
        }
        sg.setPopDetailsInfo(popDetails);
        return sg;
    }

    @Override
    public Goods removeSinglePopDetails(Goods sg) {
        if (null == sg.getPopDetailsInfo() || sg.getPopDetailsInfo().size() == 0) {
            return sg;
        }
        Goods newsg = sg.deepClone();
        for (int i = 0; i < newsg.getPopDetailsInfo().size(); ++i) {
            PopDetail pop = newsg.getPopDetailsInfo().get(i);
            if (null == pop.getPopPolicyGroup()) continue;
            if (YPopStatusType.pop_policy_group_point.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_pointbase.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_grant_goods.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_grant_order.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_pointuse.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_couponuse.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_aeoncoupon.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_barcode_discA.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_barcode_discB.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_needCoupon.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_share.equals(pop.getPopPolicyGroup())) {
                newsg.getPopDetailsInfo().remove(i);
                --i;
                continue;
            }
            if (YPopStatusType.pop_type_cwmz.equals(pop.getPopPolicyType())) {
                newsg.getPopDetailsInfo().remove(i);
                --i;
                continue;
            }
            if (!StringUtils.isNotBlank((String)pop.getPopEventType()) || pop.getPopEventType().indexOf("_coupon_") <= 0) continue;
            newsg.getPopDetailsInfo().remove(i);
            --i;
        }
        return newsg;
    }

    @Override
    public GoodsForPos transferGoodsToPosGoods(Goods sg, List<String> calcPriceType, boolean editDescribe) {
        return this.transferGoodsToPosGoods(sg, calcPriceType, editDescribe, false);
    }

    @Override
    public GoodsForPos transferGoodsToPosGoods(Goods sg, List<String> calcPriceType, boolean editDescribe, boolean isBack) {
        GoodsForPos g = new GoodsForPos();
        BeanCopierUtils.copyProperties(sg, g);
        if (isBack && g.getAllowReturnCopies() < g.getQty()) {
            g.setSaleValue(ManipulatePrecision.doubleConvert(g.getSaleValue() * g.getAllowReturnCopies() / g.getQty()));
            g.setCouponValue(ManipulatePrecision.doubleConvert(g.getCouponValue() * g.getAllowReturnCopies() / g.getQty()));
            g.setPopDiscountValue(ManipulatePrecision.doubleConvert(g.getPopDiscountValue() * g.getAllowReturnCopies() / g.getQty()));
            g.setAdjustDiscountValue(ManipulatePrecision.doubleConvert(g.getAdjustDiscountValue() * g.getAllowReturnCopies() / g.getQty()));
            g.setCustomDiscountValue(ManipulatePrecision.doubleConvert(g.getCustomDiscountValue() * g.getAllowReturnCopies() / g.getQty()));
            g.setMealDiscountValue(ManipulatePrecision.doubleConvert(g.getMealDiscountValue() * g.getAllowReturnCopies() / g.getQty()));
            g.setPayDiscountValue(ManipulatePrecision.doubleConvert(g.getPayDiscountValue() * g.getAllowReturnCopies() / g.getQty()));
            g.setStudentCardDiscountValue(ManipulatePrecision.doubleConvert(g.getStudentCardDiscountValue() * g.getAllowReturnCopies() / g.getQty()));
            g.setTotalDiscountValue(ManipulatePrecision.doubleConvert(g.getTotalDiscountValue() * g.getAllowReturnCopies() / g.getQty()));
            g.setSaleAmount(ManipulatePrecision.doubleConvert(g.getSaleValue() - g.getTotalDiscountValue()));
        }
        ArrayList<PopDetail> pops = new ArrayList<PopDetail>();
        List<PopDetail> popDetails = sg.getPopDetailsInfo();
        if (null != popDetails && popDetails.size() > 0) {
            for (PopDetail pop : popDetails) {
                PopDetail popInfo = new PopDetail();
                BeanCopierUtils.copyProperties(pop, popInfo);
                if (isBack && g.getAllowReturnCopies() < g.getQty()) {
                    popInfo.setDiscountAmount(ManipulatePrecision.doubleConvert(popInfo.getDiscountAmount() * g.getAllowReturnCopies() / g.getQty()));
                }
                if (editDescribe && StringUtils.isNotBlank((String)popInfo.getPopDescribe())) {
                    popInfo.setPopDescribe(popInfo.getPopDescribe().split("]")[0] + "]");
                }
                if (null != calcPriceType && !calcPriceType.isEmpty() && calcPriceType.indexOf(pop.getPopPolicyType()) != -1) {
                    popInfo.setPopPrint("0");
                }
                pops.add(popInfo);
            }
        }
        g.setPopDetails(pops);
        return g;
    }

    @Override
    public GoodsForPos transferGoodsToNoAdjustPosGoods(Goods sg, List<String> calcPriceType, boolean editDescribe) {
        GoodsForPos g = new GoodsForPos();
        BeanCopierUtils.copyProperties(sg, g);
        ArrayList<PopDetail> pops = new ArrayList<PopDetail>();
        List<PopDetail> popDetails = sg.getPopDetailsInfo();
        if (null != popDetails && popDetails.size() > 0) {
            for (PopDetail pop : popDetails) {
                if (null != calcPriceType && !calcPriceType.isEmpty() && calcPriceType.indexOf(pop.getPopPolicyType()) != -1 || YPopStatusType.pop_policy_group_grant_goods.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_barcode_discA.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_barcode_discB.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_aeoncoupon.equals(pop.getPopPolicyGroup())) continue;
                PopDetail popInfo = new PopDetail();
                BeanCopierUtils.copyProperties(pop, popInfo);
                if (editDescribe && StringUtils.isNotBlank((String)popInfo.getPopDescribe())) {
                    popInfo.setPopDescribe(popInfo.getPopDescribe().split("]")[0] + "]");
                }
                pops.add(popInfo);
            }
        }
        g.setPopDetails(pops);
        return g;
    }

    @Override
    public Goods delZeroPop(Goods sg) {
        try {
            if (null != sg.getPopDetailsInfo()) {
                for (int i = 0; i < sg.getPopDetailsInfo().size(); ++i) {
                    PopDetail pop = sg.getPopDetailsInfo().get(i);
                    if (ManipulatePrecision.doubleCompare(pop.getDiscountAmount(), 0.0, 2) != 0) continue;
                    sg.getPopDetailsInfo().remove(i);
                    --i;
                }
            }
            return sg;
        }
        catch (Exception e) {
            e.printStackTrace();
            return sg;
        }
    }

    @Override
    public List<Goods> combineSameGoods(List<Goods> goodslist) {
        return this.combineSameGoods(goodslist, true);
    }

    @Override
    public List<Goods> combineSameGoods(List<Goods> goodslist, boolean checkGoodsType) {
        ArrayList<Goods> newGoodsList = new ArrayList<Goods>();
        String hhguid = "";
        for (Goods salegoods : goodslist) {
            String goodsType = salegoods.getGoodsType();
            if (!checkGoodsType) {
                goodsType = "0";
            }
            if (null == salegoods.getPopDetailsInfo()) {
                salegoods.setPopDetailsInfo(new ArrayList<PopDetail>());
            }
            if (null == salegoods.getCouponUses()) {
                salegoods.setCouponUses(new ArrayList<CouponUse>());
            }
            if (null == salegoods.getCouponGains()) {
                salegoods.setCouponGains(new ArrayList<CouponGain>());
            }
            if (null == salegoods.getCategoryPropertys()) {
                salegoods.setCategoryPropertys(new ArrayList<CategoryProperty>());
            }
            boolean isMerge = false;
            if (!"0".equals(goodsType) || ManipulatePrecision.doubleCompare(salegoods.getBarcodeDiscount(), 0.0, 2) > 0 || salegoods.getTempZrDiscount() > 0.0 || salegoods.getFixedDiscountValue() > 0.0 || "Y".equals(salegoods.getEscaleFlag()) || salegoods.getEWCCodeNum() > 0.0 || salegoods.getEWCCodeAmount() > 0.0 || StringUtils.isNotBlank((String)salegoods.getEBillFlowNo()) || (double)((int)salegoods.getQty()) != salegoods.getQty()) {
                Goods tempSg = salegoods.deepClone();
                newGoodsList.add(Goods.delZeroPop(tempSg));
                continue;
            }
            for (Goods newSg : newGoodsList) {
                String goodsType1 = newSg.getGoodsType();
                if (!checkGoodsType) {
                    goodsType1 = "0";
                }
                if (!"0".equals(goodsType1) || newSg.getTempZrDiscount() != 0.0 || newSg.getFixedDiscountValue() != 0.0 || (!StringUtils.isEmpty((String)salegoods.getAssistantId()) || !StringUtils.isEmpty((String)newSg.getAssistantId())) && (!StringUtils.isNotEmpty((String)salegoods.getAssistantId()) || !salegoods.getAssistantId().equals(newSg.getAssistantId())) || !salegoods.getGoodsNo().equals(newSg.getGoodsNo()) || ManipulatePrecision.doubleCompare(salegoods.getSalePrice(), newSg.getSalePrice(), 2) != 0 || !salegoods.getFlag().equals(newSg.getFlag()) || (!StringUtils.isEmpty((String)salegoods.getPopFlag()) || !StringUtils.isEmpty((String)newSg.getPopFlag())) && (!StringUtils.isNotEmpty((String)salegoods.getPopFlag()) || !StringUtils.isNotEmpty((String)newSg.getPopFlag()) || !salegoods.getPopFlag().equals(newSg.getPopFlag())) || (!StringUtils.isEmpty((String)salegoods.getOrgCode()) || !StringUtils.isEmpty((String)newSg.getOrgCode())) && (!StringUtils.isNotEmpty((String)salegoods.getOrgCode()) || !salegoods.getOrgCode().equals(newSg.getOrgCode())) || ManipulatePrecision.doubleCompare(salegoods.getTempZkl(), newSg.getTempZkl(), 2) != 0 || !Convert.isListEqual(salegoods.getCategoryPropertys(), newSg.getCategoryPropertys())) continue;
                String precisionMode = DataExchageUtils.exchangePrecisionMode(salegoods.getPrcutMode());
                newSg.setSaleValue(ManipulatePrecision.getDetailOverFlow(newSg.getSaleValue() + salegoods.getSaleValue(), salegoods.getPrcutMode()));
                newSg.setTempZkDiscount(ManipulatePrecision.getDetailOverFlow(newSg.getTempZkDiscount() + salegoods.getTempZkDiscount(), "0"));
                newSg.setBarcodeDiscount(ManipulatePrecision.getDetailOverFlow(newSg.getBarcodeDiscount() + salegoods.getBarcodeDiscount(), "0"));
                newSg.setTempZrDiscount(ManipulatePrecision.getDetailOverFlow(newSg.getTempZrDiscount() + salegoods.getTempZrDiscount(), "0"));
                newSg.setTempZzkDiscount(ManipulatePrecision.getDetailOverFlow(newSg.getTempZzkDiscount() + salegoods.getTempZzkDiscount(), "0"));
                newSg.setTempZzrDiscount(ManipulatePrecision.getDetailOverFlow(newSg.getTempZzrDiscount() + salegoods.getTempZzrDiscount(), "0"));
                newSg.setFixedDiscountValue(ManipulatePrecision.getDetailOverFlow(newSg.getFixedDiscountValue() + salegoods.getFixedDiscountValue(), "0"));
                newSg.setCouponValue(ManipulatePrecision.getDetailOverFlow(newSg.getCouponValue() + salegoods.getCouponValue(), "0"));
                newSg.setPopDiscountValue(ManipulatePrecision.getDetailOverFlow(newSg.getPopDiscountValue() + salegoods.getPopDiscountValue(), "0"));
                newSg.setBarcodeDiscount(ManipulatePrecision.getDetailOverFlow(newSg.getBarcodeDiscount() + salegoods.getBarcodeDiscount(), "0"));
                newSg.setAdjustDiscountValue(ManipulatePrecision.getDetailOverFlow(newSg.getAdjustDiscountValue() + salegoods.getAdjustDiscountValue(), "0"));
                newSg.setCustomDiscountValue(ManipulatePrecision.getDetailOverFlow(newSg.getCustomDiscountValue() + salegoods.getCustomDiscountValue(), "0"));
                newSg.setPayDiscountValue(ManipulatePrecision.getDetailOverFlow(newSg.getPayDiscountValue() + salegoods.getPayDiscountValue(), "0"));
                newSg.setMealDiscountValue(ManipulatePrecision.getDetailOverFlow(newSg.getMealDiscountValue() + salegoods.getMealDiscountValue(), "0"));
                newSg.setQty(ManipulatePrecision.getDetailOverFlow(newSg.getQty() + salegoods.getQty(), "0"));
                newSg.setTotalDiscountValue(CountZZK.getNoPrcutZZK(newSg));
                newSg.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(newSg.getTotalDiscountValue() - newSg.getNoDisAmountValue()));
                newSg.setSaleAmount(newSg.getSaleValue() - newSg.getTotalDiscountValue());
                if (null != salegoods.getPopDetails()) {
                    for (PopDetail pop : salegoods.getPopDetailsInfo()) {
                        boolean popIsMerged = false;
                        if (ManipulatePrecision.doubleCompare(pop.getDiscountAmount(), 0.0, 2) == 0 || null == pop.getPopPolicyGroup()) continue;
                        for (PopDetail newPop : newSg.getPopDetailsInfo()) {
                            if (YPopStatusType.pop_policy_group_aeoncoupon.equals(pop.getPopPolicyGroup())) {
                                if (!YPopStatusType.pop_policy_group_aeoncoupon.equals(newPop.getPopPolicyGroup()) || !pop.getPopMemo().equals(newPop.getPopMemo())) continue;
                                newPop.setDiscountAmount(ManipulatePrecision.getDetailOverFlow(newPop.getDiscountAmount() + pop.getDiscountAmount(), precisionMode));
                                popIsMerged = true;
                                break;
                            }
                            if (YPopStatusType.pop_policy_group_grant_goods.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_grant_order.equals(pop.getPopPolicyGroup())) {
                                if (!pop.getPopDescribe().equals(newPop.getPopDescribe())) continue;
                                newPop.setDiscountAmount(ManipulatePrecision.getDetailOverFlow(newPop.getDiscountAmount() + pop.getDiscountAmount(), precisionMode));
                                popIsMerged = true;
                                break;
                            }
                            if (pop.getPopEventId() != newPop.getPopEventId()) continue;
                            newPop.setDiscountAmount(ManipulatePrecision.getDetailOverFlow(newPop.getDiscountAmount() + pop.getDiscountAmount(), precisionMode));
                            popIsMerged = true;
                            break;
                        }
                        if (popIsMerged) continue;
                        newSg.getPopDetailsInfo().add(pop);
                    }
                }
                hhguid = newSg.getGuid();
                isMerge = true;
                break;
            }
            if (isMerge) continue;
            newGoodsList.add(salegoods);
        }
        List<Goods> goods = this.sortGoodsList(newGoodsList);
        goods = this.combineToTop(goods, hhguid);
        return goods;
    }

    public List<Goods> combineToTop(List<Goods> goods, String hhguid) {
        return goods;
    }

    @Override
    public Goods BillDetailToRefundGiftGoods(SellDetail g, String prcutMode) {
        Goods sg = new Goods();
        sg.setPrcutMode(prcutMode);
        sg.setGuid(UUIDUtils.buildGuid());
        sg.setBarNo(g.getBarcode());
        sg.setBrandCode(g.getBrand());
        sg.setCategoryCode(g.getCategory());
        sg.setTempCategory(g.getCategory());
        sg.setArtCode("");
        sg.setPartsNum(g.getFactor());
        sg.setFlag(g.getFlag().substring(0, 1));
        if (g.getFlag().equals("4")) {
            sg.setEscaleFlag("Y");
            sg.setFlag("0");
        } else if (g.getFlag().equals("0")) {
            sg.setFlag("0");
            sg.setEscaleFlag("N");
        } else {
            sg.setFlag("0");
            sg.setEscaleFlag("N");
        }
        sg.setGoodsCode(g.getItemCode());
        sg.setGoodsName(g.getItemName());
        sg.setOriginalFlowId(g.getOriginalRowNo());
        sg.setSaleAmount(g.getSaleAmount());
        sg.setQty(g.getQty());
        sg.setFlowId(g.getRowNo());
        sg.setSaleUnit(g.getUnitcode());
        sg.setTotalDiscountValue(g.getTotalDiscount());
        sg.setSaleValue(g.getListAmount());
        sg.setOrgCode(g.getGz());
        sg.setVenderId(g.getSupplier());
        sg.setKlm(g.getKlm());
        sg.setPopDiscountValue(sg.getTotalDiscountValue());
        sg.setSalePrice(g.getPrice());
        sg.setGoodsType("0");
        sg = this.transferGoods(g, sg, "0", null, true, true, true);
        sg.setPopDetailsInfo(new ArrayList<PopDetail>());
        for (SellPopDetail pop : g.getSellPopDetails()) {
            sg.getPopDetailsInfo().add(this.popdetailTransfer.transferPopDetail2(pop));
        }
        sg.setCalcMode("0");
        sg.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sg.getRealTotalDiscountValue() - sg.getNoDisAmountValue()));
        sg.setPopGains(PopGain.sellGainListToPopGainList(g.getCGains()));
        sg.setPopUses(PopUse.sellUseListToPopUseList(g.getCUses()));
        sg.setPopReverses(PopReverse.sellReverseListToPopReverseList(g.getReverse()));
        return sg;
    }

    @Override
    public CouponGain transferCouponGain(OrdersGainDetailModel ordersGainDetail) {
        CouponGain couponGain = new CouponGain();
        couponGain.setAmount(ordersGainDetail.getAmount().doubleValue());
        couponGain.setCouponClass(ordersGainDetail.getCouponClass());
        couponGain.setCouponGroup(ordersGainDetail.getCouponGroup());
        couponGain.setCouponType(ordersGainDetail.getCouponType());
        couponGain.setPolicyId(ordersGainDetail.getPolicyId());
        couponGain.setEventId(ordersGainDetail.getEventId());
        return couponGain;
    }

    @Override
    public List<Goods> sortGoodsList(List<Goods> goodsList) {
        goodsList.sort(new Comparator<Goods>(){

            @Override
            public int compare(Goods o1, Goods o2) {
                if (o1.getFlowId() < o2.getFlowId()) {
                    return -1;
                }
                return 0;
            }
        });
        int size = goodsList.size();
        for (int i = 0; i < size; ++i) {
            goodsList.get(i).setFlowId(i + 1);
        }
        return goodsList;
    }

    @Override
    public List<GoodsForPos> transferGoodsToPosGoodsList(List<Goods> goodsList) {
        ArrayList<GoodsForPos> list = new ArrayList<GoodsForPos>();
        for (Goods sg : goodsList) {
            if (sg.getIsNoBackGift()) continue;
            list.add(this.transferGoodsToPosGoods(this.removeSinglePopDetails(sg)));
        }
        return list;
    }

    @Override
    public GoodsForPos transferGoodsToPosGoods(Goods sg) {
        GoodsForPos ofp = new GoodsForPos();
        BeanCopierUtils.copyProperties(sg, ofp);
        ArrayList<PopDetail> pops = new ArrayList<PopDetail>();
        List<PopDetail> popDetails = sg.getPopDetailsInfo();
        if (null != popDetails && popDetails.size() > 0) {
            for (PopDetail pop : popDetails) {
                if (StringUtils.isNotBlank((String)pop.getPopEventType()) && pop.getPopEventType().indexOf("_coupon_") > 0) continue;
                PopDetail popTarget = new PopDetail();
                BeanCopierUtils.copyProperties(pop, popTarget);
                pops.add(popTarget);
            }
        }
        ofp.setPopDetails(pops);
        return ofp;
    }

    @Override
    public List<Goods> transferPosGoodsToGoodsList(List<GoodsForPos> goodsList) {
        ArrayList<Goods> list = new ArrayList<Goods>();
        for (GoodsForPos sg : goodsList) {
            Goods goods = this.transferPosGoodsToGoods(sg);
            list.add(goods);
        }
        return list;
    }

    @Override
    public Goods transferPosGoodsToGoods(GoodsForPos sg) {
        Goods goods = new Goods();
        BeanCopierUtils.copyProperties(sg, goods);
        ArrayList<PopDetail> pops = new ArrayList<PopDetail>();
        List<PopDetail> popDetails = sg.getPopDetails();
        if (null != popDetails && popDetails.size() > 0) {
            for (PopDetail pop : popDetails) {
                if (StringUtils.isNotBlank((String)pop.getPopEventType()) && pop.getPopEventType().indexOf("_coupon_") > 0) continue;
                PopDetail popTarget = new PopDetail();
                BeanCopierUtils.copyProperties(pop, popTarget);
                pops.add(popTarget);
            }
        }
        goods.setPopDetailsInfo(pops);
        return goods;
    }

    @Override
    public List<GoodsForPos> transferGoodsToPosGoodsListSingle(List<Goods> goodsList) {
        ArrayList<GoodsForPos> list = new ArrayList<GoodsForPos>();
        for (Goods sg : goodsList) {
            if (sg.getIsNoBackGift()) continue;
            list.add(this.transferGoodsToPosGoods(this.removeSinglePopDetails(sg)));
        }
        return list;
    }

    @Override
    public SaleOrderDetailModel transferSaleOrderDetailModel(Goods g) {
        SaleOrderDetailModel d = new SaleOrderDetailModel();
        d.setAssistantId(g.getAssistantId());
        d.setSaleSpec(g.getSaleSpec());
        d.setCabinetGroup(g.getOrgCode());
        d.setSkuName(g.getGoodsName());
        d.setEngName(g.getEngName());
        d.setRowNo(g.getFlowId());
        d.setItemCode(g.getGoodsCode());
        d.setBarCode(g.getBarNo());
        d.setSpuCode(g.getSkuId());
        d.setBrandCode(g.getBrandCode());
        d.setGoodsUid(g.getGoodsUid());
        d.setCatCode(g.getCategoryCode());
        d.setKlm(g.getKlm());
        d.setEnFname(g.getEnFname());
        d.setEnSname(g.getEnSname());
        d.setGoodType(g.getGoodsType());
        d.setGoodsFlag(g.getFlag());
        d.setPopTag(g.getPopFlag());
        d.setSalePrice(BigDecimal.valueOf(g.getSalePrice()));
        d.setListPrice(BigDecimal.valueOf(g.getListPrice()));
        if (d.getListPrice().compareTo(BigDecimal.ZERO) == 0) {
            d.setListPrice(d.getSalePrice());
        }
        d.setFactor(g.getPartsNum());
        d.setQty(g.getQty());
        d.setUnitCode(g.getSaleUnit());
        d.setSaleValue(BigDecimal.valueOf(g.getSaleValue()));
        d.setCouponValue(BigDecimal.valueOf(g.getCouponValue()));
        d.setPopDiscountValue(BigDecimal.valueOf(ManipulatePrecision.doubleConvert(g.getPopDiscountValue() - g.getNoDisAmountValue(), 2, 1)));
        d.setAdjustDiscountValue(BigDecimal.valueOf(ManipulatePrecision.doubleConvert(g.getAdjustDiscountValue(), 2, 1)));
        d.setPayDiscountValue(BigDecimal.valueOf(g.getNoDisAmountValue()));
        d.setTotalDiscountValue(BigDecimal.valueOf(g.getTotalDiscountValue()));
        d.setCustomDiscountValue(BigDecimal.valueOf(g.getCustomDiscountValue()));
        d.setStudentCardDiscountValue(BigDecimal.valueOf(g.getStudentCardDiscountValue()));
        d.setSaleAmount(BigDecimal.valueOf(g.getSaleAmount()));
        d.setVenderCode(g.getVenderId());
        d.setWeight(g.getWeight());
        d.setWeighGood(this.transferWeighGood(g.getEscaleFlag()));
        d.setGoodsId(CastUtil.castLong(g.getGoodsId()));
        d.setSmGoodsSno(g.getSGoodsSno());
        d.setSmGoodsCode(g.getSGoodsCode());
        d.setSmGoodProperty(JSON.toJSONString(g.getCategoryPropertys()));
        d.setVenderCode(g.getVenderCode());
        if (g.getEWCCodeNum() > 0.0 || g.getEWCCodeAmount() > 0.0) {
            d.setCopies(1);
        } else {
            d.setCopies((int)g.getQty());
        }
        if (d.getCopies() == 0) {
            d.setCopies(1);
        }
        d.setStallCode(g.getStallCode());
        d.setAllowReturnCopies(CastUtil.castDouble(g.getAllowReturnCopies()));
        d.setMealDiscountValue(BigDecimal.valueOf(g.getMealDiscountValue()));
        d.setEatWay(g.getEatWay());
        d.setStallCode(g.getStallCode());
        d.setControlGood(g.getControlFlag());
        d.setLicense(g.getLicense());
        d.setPrtDuplFlag(g.getPrtDuplFlag());
        d.setPrcutMode(g.getPrcutMode());
        d.setGoodsDesc(g.getGoodsDesc());
        d.setColdGood(g.getColdGood());
        d.setContractCode(g.getContractCode());
        d.setProcessFlag(g.getProcessFlag());
        d.setOriginalProductCode(g.getGoodsNo());
        d.setBonusPointAmount(BigDecimal.valueOf(g.getBonusPointAmount()));
        d.setScanCode(g.getGoodsNo());
        d.setRemark(g.getRemark());
        d.setWlBatch(g.getWlBatch());
        d.setWlCode(g.getWlCode());
        d.setWlScDate(g.getWlScDate());
        if (StringUtils.isNotBlank((String)g.getWlBottleCode())) {
            d.setContractCode(g.getWlBottleCode());
        }
        d.setEBillFlowNo(g.getEBillFlowNo());
        d.setHandmadeNumber(g.getHandmadeNumber());
        d.setHandmadeFalg(g.isHandmadeFlag());
        if (g.isHandmadeFlag()) {
            d.setHandmadeRate(g.getFdzkfd());
        }
        d.setBarcodeDiscount(BigDecimal.valueOf(g.getBarcodeDiscount()));
        if (StringUtils.isNotBlank((String)g.getOrgName()) && StringUtils.isNotBlank((String)g.getCategoryName())) {
            String extendFt9 = StringUtils.defaultIfBlank((String)g.getArtNo(), (String)"\u65e0") + "|" + StringUtils.defaultIfBlank((String)g.getSizeName(), (String)"\u65e0") + "|" + StringUtils.defaultIfBlank((String)g.getOrgName(), (String)"\u65e0");
            d.setExtendFt9(extendFt9);
            String extendFt10 = StringUtils.defaultIfBlank((String)g.getCategoryName(), (String)"\u65e0") + "|" + StringUtils.defaultIfBlank((String)g.getBrandName(), (String)"\u65e0");
            d.setExtendFt10(extendFt10);
        }
        d.setRemark(g.getRemark());
        d.setExtendFt2(g.getExtendFt2());
        d.setExtendFt3(g.getExtendFt3());
        if (StringUtils.isNotEmpty((String)g.getMachineCode())) {
            d.setExtendFt4(g.getMemo());
        }
        d.setExtendFt5(String.valueOf(g.getOutputTax()));
        return d;
    }

    @Override
    public Goods removeConditionPopDetails(Goods orsg) {
        if (null == orsg.getPopDetailsInfo() || orsg.getPopDetailsInfo().size() == 0) {
            return orsg;
        }
        Goods sg = orsg.deepClone();
        ArrayList<PopDetail> dzcPopList = new ArrayList<PopDetail>();
        ArrayList<PopDetail> barCodePopList = new ArrayList<PopDetail>();
        ArrayList<PopDetail> vipPopList = new ArrayList<PopDetail>();
        ArrayList<PopDetail> prefeList = new ArrayList<PopDetail>();
        ArrayList<PopDetail> singleList = new ArrayList<PopDetail>();
        ArrayList<PopDetail> giftList = new ArrayList<PopDetail>();
        ArrayList<PopDetail> promotionList = new ArrayList<PopDetail>();
        ArrayList<PopDetail> discountList = new ArrayList<PopDetail>();
        ArrayList<PopDetail> vipeList = new ArrayList<PopDetail>();
        ArrayList<PopDetail> aeonCouponList = new ArrayList<PopDetail>();
        ArrayList<PopDetail> orderList = new ArrayList<PopDetail>();
        ArrayList<PopDetail> pointExList = new ArrayList<PopDetail>();
        ArrayList<PopDetail> payDiscList = new ArrayList<PopDetail>();
        for (int i = 0; i < sg.getPopDetailsInfo().size(); ++i) {
            String[] descrbe;
            PopDetail pop = sg.getPopDetailsInfo().get(i);
            if (!"0".equals(pop.getPopMode()) || null == pop.getPopPolicyGroup()) continue;
            if (pop.getPopPolicyGroup().equals(YPopStatusType.pop_policy_group_dzcpop)) {
                pop.setPopDescribe(pop.getPopDescribe() + " ");
                dzcPopList.add((PopDetail)pop.clone());
                continue;
            }
            if (pop.getPopPolicyGroup().equals(YPopStatusType.pop_policy_group_barcode_disc)) {
                pop.setPopDescribe(pop.getPopDescribe() + " ");
                barCodePopList.add((PopDetail)pop.clone());
                continue;
            }
            if (pop.getPopPolicyGroup().equals(YPopStatusType.pop_policy_group_vip)) {
                pop.setPopDescribe(pop.getPopDescribe() + " ");
                vipPopList.add((PopDetail)pop.clone());
                continue;
            }
            if (pop.getPopPolicyGroup().equals(YPopStatusType.pop_policy_group_prefe)) {
                pop.setPopDescribe(pop.getPopDescribe() + " ");
                prefeList.add((PopDetail)pop.clone());
                continue;
            }
            if (YPopStatusType.pop_policy_group_pointbase.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_overage.equals(pop.getPopPolicyGroup())) continue;
            if (YPopStatusType.pop_policy_group_grant_goods.equals(pop.getPopPolicyGroup())) {
                singleList.add((PopDetail)pop.clone());
                continue;
            }
            if (YPopStatusType.pop_policy_group_grant_order.equals(pop.getPopPolicyGroup())) {
                orderList.add((PopDetail)pop.clone());
                continue;
            }
            if (pop.getPopPolicyGroup().equals(YPopStatusType.pop_policy_group_gift)) {
                pop.setPopDescribe(pop.getPopDescribe() + " ");
                giftList.add((PopDetail)pop.clone());
                continue;
            }
            if (pop.getPopPolicyGroup().equals(YPopStatusType.pop_policy_group_promotion)) {
                pop.setPopDescribe(pop.getPopDescribe() + " ");
                promotionList.add((PopDetail)pop.clone());
                continue;
            }
            if (pop.getPopPolicyGroup().equals(YPopStatusType.pop_policy_group_discount)) {
                pop.setPopDescribe(pop.getPopDescribe() + " ");
                discountList.add((PopDetail)pop.clone());
                continue;
            }
            if (pop.getPopPolicyGroup().equals(YPopStatusType.pop_policy_group_vipe)) {
                pop.setPopDescribe(pop.getPopDescribe() + " ");
                vipeList.add((PopDetail)pop.clone());
                continue;
            }
            if (YPopStatusType.pop_policy_group_aeoncoupon.equals(pop.getPopPolicyGroup())) {
                pop.setPopDescribe(pop.getPopDescribe() + " ");
                aeonCouponList.add((PopDetail)pop.clone());
                continue;
            }
            if (YPopStatusType.pop_policy_group_pointEx.equals(pop.getPopPolicyGroup())) {
                descrbe = pop.getPopDescribe().split("[|]");
                pop.setPopDescribe(descrbe[0] + " ");
                pop.setDiscountAmount(0.0);
                pointExList.add((PopDetail)pop.clone());
                continue;
            }
            if (!YPopStatusType.pop_policy_group_paydisc.equals(pop.getPopPolicyGroup())) continue;
            descrbe = pop.getPopDescribe().split("[|]");
            pop.setPopDescribe(descrbe[0] + " ");
            pop.setDiscountAmount(0.0);
            payDiscList.add((PopDetail)pop.clone());
        }
        dzcPopList.addAll(barCodePopList);
        dzcPopList.addAll(prefeList);
        dzcPopList.addAll(vipPopList);
        dzcPopList.addAll(singleList);
        dzcPopList.addAll(promotionList);
        dzcPopList.addAll(giftList);
        dzcPopList.addAll(discountList);
        dzcPopList.addAll(vipeList);
        dzcPopList.addAll(pointExList);
        dzcPopList.addAll(aeonCouponList);
        dzcPopList.addAll(orderList);
        dzcPopList.addAll(payDiscList);
        sg.setPopDetailsInfo(dzcPopList);
        return sg;
    }

    @Override
    public Goods SaleOrderDetailToGoods(Goods goods, SaleOrderDetailModel sod) {
        goods.setOrgCode(sod.getCabinetGroup());
        goods.setGoodsName(sod.getSkuName());
        goods.setEngName(sod.getEngName());
        goods.setFlowId(sod.getRowNo());
        goods.setGoodsCode(sod.getItemCode());
        goods.setGoodsNo(sod.getScanCode());
        goods.setBarNo(sod.getBarCode());
        goods.setBrandCode(sod.getBrandCode());
        goods.setCategoryCode(sod.getCatCode());
        goods.setGoodsUid(sod.getGoodsUid());
        goods.setKlm(sod.getKlm());
        goods.setSaleSpec(sod.getSaleSpec());
        goods.setGoodsType(sod.getGoodType());
        goods.setFlag(sod.getGoodsFlag());
        goods.setPopFlag(sod.getPopTag());
        goods.setSalePrice(CastUtil.castDouble(sod.getSalePrice()));
        goods.setListPrice(CastUtil.castDouble(sod.getListPrice()));
        goods.setPartsNum(sod.getFactor());
        goods.setQty(sod.getQty());
        goods.setSaleUnit(sod.getUnitCode());
        goods.setCouponValue(CastUtil.castDouble(sod.getCouponValue()));
        goods.setPopDiscountValue(CastUtil.castDouble(sod.getPopDiscountValue()));
        goods.setAdjustDiscountValue(CastUtil.castDouble(sod.getAdjustDiscountValue()));
        goods.setTotalDiscountValue(CastUtil.castDouble(sod.getTotalDiscountValue()));
        goods.setCustomDiscountValue(CastUtil.castDouble(sod.getCustomDiscountValue()));
        goods.setStudentCardDiscountValue(CastUtil.castDouble(sod.getStudentCardDiscountValue()));
        goods.setSaleAmount(CastUtil.castDouble(sod.getSaleAmount()));
        goods.setVenderId(sod.getVenderCode());
        goods.setWeight(sod.getWeight());
        goods.setEscaleFlag(this.transEscaleFlag(sod.getWeighGood()));
        goods.setGoodsId(String.valueOf(sod.getGoodsId()));
        goods.setSGoodsSno(sod.getSmGoodsSno());
        goods.setSGoodsCode(sod.getSmGoodsCode());
        goods.setCategoryPropertys(JSON.parseArray((String)sod.getSmGoodProperty(), CategoryProperty.class));
        goods.setStallCode(sod.getStallCode());
        goods.setAllowReturnCopies(CastUtil.castDouble(sod.getAllowReturnCopies()));
        goods.setMealDiscountValue(CastUtil.castDouble(sod.getMealDiscountValue()));
        goods.setPopDetailsInfo(new ArrayList<PopDetail>());
        goods.setCouponUses(new ArrayList<CouponUse>());
        goods.setCouponGains(new ArrayList<CouponGain>());
        goods.setPrcutMode(sod.getPrcutMode());
        goods.setLicense(sod.getLicense());
        goods.setControlFlag(sod.getControlGood());
        goods.setGoodsDesc(sod.getGoodsDesc());
        double saleValue = ManipulatePrecision.doubleConvert(CastUtil.castDouble(sod.getTotalDiscountValue()) + CastUtil.castDouble(sod.getSaleAmount()), 2, 1);
        goods.setSaleValue(saleValue);
        goods.setBackPrintNo(sod.getContractCode());
        goods.setEatWay(sod.getEatWay());
        goods.setProcessFlag(sod.getProcessFlag());
        goods.setVenderCode(sod.getVenderCode());
        goods.setAssistantId(sod.getAssistantId());
        goods.setWlScDate(sod.getWlScDate());
        goods.setWlBatch(sod.getWlBatch());
        goods.setWlCode(sod.getWlCode());
        goods.setWlBottleCode(sod.getContractCode());
        goods.setRemark(sod.getRemark());
        goods.setEBillFlowNo(sod.getEBillFlowNo());
        return goods;
    }

    @Override
    public GoodsInfoForApp transferGoodsInfoToGoods(GoodsInfo goodsInfo, double qty) {
        GoodsInfoForApp goods = new GoodsInfoForApp();
        goods.setControlFlag(goodsInfo.getControlFlag());
        goods.setCategoryCode(goodsInfo.getCategoryCode());
        goods.setArtCode(goodsInfo.getArtCode());
        goods.setBrandId(goodsInfo.getBrandId());
        goods.setBrandName(goodsInfo.getBrandName());
        goods.setPartsUnit(goodsInfo.getPartsUnit());
        goods.setPartsNum(goodsInfo.getPartsNum());
        goods.setRemark(goodsInfo.getRemark());
        goods.setImageUrl(goodsInfo.getImageUrl());
        goods.setEnFName(goodsInfo.getEnFname());
        goods.setGoodsName(goodsInfo.getGoodsName());
        goods.setGoodsType(goodsInfo.getGoodsType());
        goods.setBarNo(goodsInfo.getBarNo());
        goods.setGoodsCode(goodsInfo.getGoodsCode());
        goods.setSalePrice(goodsInfo.getSalePrice());
        goods.setVenderCode(goodsInfo.getVenderCode());
        goods.setUpdownStatus("1");
        goods.setPriceMode(goodsInfo.getPriceMode());
        return goods;
    }

    public String getGrantOrderYPopStatusType() {
        return YPopStatusType.pop_policy_group_grant_order;
    }
}

