/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.javaPos.commonkit.beantransfer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.bean.SellType;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.javaPos.commonkit.PosLogicCompoment;
import com.efuture.business.javaPos.commonkit.beantransfer.CouponTransfer;
import com.efuture.business.javaPos.commonkit.beantransfer.GoodsTransfer;
import com.efuture.business.javaPos.commonkit.beantransfer.OrderTransfer;
import com.efuture.business.javaPos.commonkit.beantransfer.PaymentTransfer;
import com.efuture.business.javaPos.commonkit.beantransfer.PopdetailTransfer;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.ConsumersData;
import com.efuture.business.javaPos.struct.Coupon;
import com.efuture.business.javaPos.struct.CouponOutDef;
import com.efuture.business.javaPos.struct.ExceptPay;
import com.efuture.business.javaPos.struct.Goods;
import com.efuture.business.javaPos.struct.GoodsForPos;
import com.efuture.business.javaPos.struct.Order;
import com.efuture.business.javaPos.struct.OrderForPos;
import com.efuture.business.javaPos.struct.OrderGains;
import com.efuture.business.javaPos.struct.PaymentForPos;
import com.efuture.business.javaPos.struct.SaleOrderStateEnum;
import com.efuture.business.javaPos.struct.UploadErpEnum;
import com.efuture.business.javaPos.struct.orderCentre.OrdersDetailModel;
import com.efuture.business.javaPos.struct.orderCentre.OrdersMemberModel;
import com.efuture.business.javaPos.struct.orderCentre.OrdersModel;
import com.efuture.business.javaPos.struct.orderCentre.OrdersModel4Pos;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrderDetailModel;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrderDetailPopModel;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrderGainDetailModel;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrderUseCouponModel;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrders;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrdersExtModel;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrdersMemberModel;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrdersModel;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrders_WSLF;
import com.efuture.business.javaPos.struct.promotionCentre.BillDetail;
import com.efuture.business.javaPos.struct.promotionCentre.SellConsData;
import com.efuture.business.javaPos.struct.request.GetOrdersIn;
import com.efuture.business.javaPos.struct.response.GetOrdersOutDef;
import com.efuture.business.util.BeanCopierUtils;
import com.efuture.business.util.CastUtil;
import com.efuture.business.util.DataExchageUtils;
import com.efuture.business.util.TimeZoneUtil;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class OrderTransferImpl
implements OrderTransfer {
    @Autowired
    public GoodsTransfer goodsTransfer;
    @Autowired
    public CouponTransfer couponTransfer;
    @Autowired
    public PaymentTransfer paymentTransfer;
    @Autowired
    public PopdetailTransfer popdetailTransfer;
    @Autowired(required=false)
    private PosLogicCompoment posLogicCompoment;
    @Value(value="${localcache.enabled}")
    private Boolean localcache;

    @Override
    public BillDetail transferBillDetail(Order order) {
        BillDetail billDetail = new BillDetail();
        ConsumersData consumer = order.getConsumersData();
        if (null != consumer && (StringUtils.isNotBlank((String)consumer.getConsumersCard()) || StringUtils.isNotBlank((String)consumer.getConsumersId()))) {
            if (StringUtils.isNotBlank((String)consumer.getConsumersId())) {
                billDetail.setConsumersId(consumer.getConsumersId());
            }
            if (StringUtils.isNotBlank((String)consumer.getConsumersCard())) {
                billDetail.setConsumersCardNo(consumer.getConsumersCard());
            }
            if (StringUtils.isNotBlank((String)consumer.getConsumersType())) {
                billDetail.setConsumersType(consumer.getConsumersType());
            }
            SellConsData sellConsData = new SellConsData();
            if (null != consumer.getConsumersTrgs() && consumer.getConsumersTrgs().size() > 0) {
                sellConsData.setConsumersGrps(consumer.getConsumersTrgs());
            }
            if (StringUtils.isNotBlank((String)consumer.getConsumers_isfl())) {
                sellConsData.setConsumersIsfl(consumer.getConsumers_isfl());
            }
            if (StringUtils.isNotBlank((String)consumer.getConsumers_isjf())) {
                sellConsData.setConsumersIsjf(consumer.getConsumers_isjf());
            }
            if (StringUtils.isNotBlank((String)consumer.getConsumers_xfdate())) {
                sellConsData.setConsumersXfdate(consumer.getConsumers_xfdate());
            }
            if (StringUtils.isNotBlank((String)consumer.getConsumersType())) {
                sellConsData.setConsumersType(consumer.getConsumersType());
            }
            if (StringUtils.isNotBlank((String)consumer.getConsumers_birthday())) {
                sellConsData.setConsumersBirthday(consumer.getConsumers_birthday());
            }
            billDetail.setConsumersData(sellConsData);
            if ("GRP".equals(sellConsData.getConsumersType())) {
                billDetail.setPromotionType("0010");
            }
        }
        if (null != order.getConsumersData() && StringUtils.isNotBlank((String)order.getConsumersData().getGrantCard())) {
            billDetail.setGrantCardNo(order.getConsumersData().getGrantCard());
        }
        if (StringUtils.isNotBlank((String)order.getOriginSeqNo()) && "OFFLINE".equals(billDetail.getConsumersId())) {
            billDetail.setConsumersId("");
            billDetail.setConsumersType("");
            billDetail.setConsumersData(null);
        }
        billDetail.setManaUnit(order.getErpCode());
        billDetail.setBillNo(order.getYpopBillNo());
        billDetail.setTermOperator(order.getTerminalOperator());
        billDetail.setOughtPay(order.getOughtPay());
        billDetail.setSswrOverage(-ManipulatePrecision.doubleConvert(order.getRoundUpOverageValue(), 4, 1));
        billDetail.setFactPay(order.getExistPay());
        billDetail.setChangePay(order.getChangeValue());
        billDetail.setFactOverage(order.getOverageValue() + order.getPayOverageValue());
        billDetail.setChannel(order.getChannel());
        if (StringUtils.isNotBlank((String)order.getOriginChannel())) {
            billDetail.setChannel(order.getOriginChannel());
        }
        billDetail.setMarket(order.getShopCode());
        billDetail.setTermNo(order.getTerminalNo());
        billDetail.setSaleDate(order.getSaleDate());
        if (StringUtils.isNotBlank((String)order.getRealBillDate())) {
            billDetail.setSaleDate(order.getRealBillDate());
        }
        billDetail.setTermInvoiceNo(CastUtil.castLong(order.getTerminalSno()));
        billDetail.setInvoiceType(DataExchageUtils.getDjlb(order.getOrderType()));
        billDetail.setOriginalBillNo(order.getOriginFlowNo());
        if (order.getOrderType().equals("4")) {
            billDetail.setOriginalMode("CANUSE");
        }
        return billDetail;
    }

    @Override
    public SaleOrders toSaleOrder(Order order) {
        SaleOrders saleOrders = new SaleOrders();
        SaleOrdersModel saleOrder = new SaleOrdersModel();
        SaleOrdersMemberModel saleOrdersMember = new SaleOrdersMemberModel();
        ConsumersData consumer = order.getConsumersData();
        saleOrder.setTimeZone(order.getTimeZone());
        Date nowTime = TimeZoneUtil.ConvertTimeByTimeZone(new Date(), order.getTimeZone(), this.localcache);
        if (null != order.getConsumersData() && (StringUtils.isNotBlank((String)order.getConsumersData().getConsumersCard()) || StringUtils.isNotBlank((String)order.getConsumersData().getGrantCard()))) {
            saleOrder.setConsumersId(consumer.getConsumersId());
            saleOrder.setCusCode(consumer.getConsumersCard());
            saleOrdersMember.setCusClass(consumer.getConsumersType());
            saleOrdersMember.setMemberNameChinese(consumer.getConsumersCName());
            saleOrdersMember.setBonusPointLastDay(new BigDecimal(consumer.getPoint()));
            saleOrdersMember.setUserMobile(consumer.getMobile());
            saleOrdersMember.setCid(consumer.getConsumersId());
            saleOrdersMember.setCusCode(consumer.getConsumersCard());
            saleOrdersMember.setCusLevelName(consumer.getConsumersCardName());
            saleOrdersMember.setCusLevel(consumer.getConsumersLevel());
            saleOrdersMember.setMemberActionSno(consumer.getMemberActionSno());
            saleOrdersMember.setUnavailablePointDate(order.getUnavailablePointDate());
            saleOrdersMember.setUnavailablePoint(new Double(order.getUnavailablePoint()));
            saleOrdersMember.setThisTimeGivePoint(order.getThisTimePoint());
            saleOrdersMember.setThisTimeUsedPoint(order.getThisTimeUsedPoint());
            saleOrdersMember.setThisTimeUsablePoint(order.getTotalPoint());
            saleOrdersMember.setLastTimeUsablePoint(consumer.getPoint());
            saleOrdersMember.setMembershipExpireDate(consumer.getConsumersCardExp());
            saleOrdersMember.setUserRemark(consumer.getCustType());
            if (StringUtils.isBlank((String)saleOrdersMember.getCusCode()) && null != order.getConsumersData() && StringUtils.isNotBlank((String)order.getConsumersData().getGrantCard())) {
                saleOrder.setCusCode(order.getConsumersData().getGrantCard());
                saleOrdersMember.setCusCode(order.getConsumersData().getGrantCard());
            }
            saleOrdersMember.setShopCode(order.getShopCode());
            saleOrdersMember.setJfkh(order.getPointCardNo());
            saleOrdersMember.setTrackNo(order.getTrackNo());
            saleOrdersMember.setStaffCardNo(order.getStaffCardNo());
            saleOrdersMember.setStaffCardType(order.getStaffType());
            saleOrdersMember.setMemberActionSno(order.getMemberActionSno());
            saleOrdersMember.setPhysicalStamp(BigDecimal.valueOf(order.getPhysicalStamp()));
            saleOrdersMember.setElectronicStamp(BigDecimal.valueOf(order.getElectronicStamp()));
            saleOrdersMember.setCreateDate(nowTime);
        } else {
            saleOrdersMember = null;
        }
        saleOrder.setOrderShift(order.getScheduleCode());
        saleOrder.setEntId(order.getEntId());
        saleOrder.setChannel(order.getChannel());
        saleOrder.setChannelSheetNo(order.getYpopBillNo());
        saleOrder.setBusCompany(order.getErpCode());
        saleOrder.setTerminalNo(order.getTerminalNo());
        saleOrder.setTerminalSno(order.getTerminalSno());
        saleOrder.setTerminalOperator(order.getTerminalOperator());
        saleOrder.setSaleMarket(order.getShopName());
        saleOrder.setSaleMarketCode(order.getShopCode());
        saleOrder.setTotalDiscountValue(BigDecimal.valueOf(order.getTotalDiscountValue()));
        saleOrder.setAdjustDiscountValue(BigDecimal.valueOf(order.getTemporaryDiscAmount()));
        saleOrder.setCustomDiscountValue(BigDecimal.valueOf(order.getMemberDiscAmount()));
        saleOrder.setPopDiscountValue(BigDecimal.valueOf(order.getPreferentialDiscAmount() - order.getNoDiscountValue()));
        saleOrder.setStudentCardDiscountValue(BigDecimal.valueOf(order.getStudentCardDiscountValue()));
        saleOrder.setOverageValue(BigDecimal.valueOf(order.getOverageValue()));
        saleOrder.setSheetTypeCode(order.getOrderType());
        saleOrder.setFactPay(BigDecimal.valueOf(order.getExistPay()));
        saleOrder.setOughtPay(BigDecimal.valueOf(ManipulatePrecision.doubleConvert(order.getOughtPay() + order.getRoundUpOverageValue())));
        saleOrder.setOriginalPay(BigDecimal.valueOf(order.getSaleValue()));
        saleOrder.setPayState(order.getPayState());
        saleOrder.setUploadErp(UploadErpEnum.DSC.getCode());
        saleOrder.setThsq(order.getRefundAuthzCardNo());
        saleOrder.setGhsq(order.getTerminalOperatorAuthzCardNo());
        saleOrder.setHysq(order.getMemberAuthzCardNo());
        saleOrder.setSqkh(order.getTotalDiscAuthzCardNo());
        saleOrder.setCalcBillId(order.getSeqNo());
        saleOrder.setPayDiscountValue(BigDecimal.valueOf(order.getNoDiscountValue()));
        saleOrder.setHasBackPrint(order.isHasBackPrint());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        saleOrder.setCreateDate(nowTime);
        try {
            if (null == order.getSaleDate() || "".equals(order.getSaleDate())) {
                saleOrder.setSaleDate(nowTime);
            } else {
                Date d = sdf.parse(order.getSaleDate());
                saleOrder.setSaleDate(d);
            }
            if (null == order.getPayDate() || "".equals(order.getPayDate())) {
                saleOrder.setPayDate(nowTime);
            } else {
                Date date = sdf.parse(order.getPayDate());
                saleOrder.setPayDate(date);
            }
            if (null != order.getRealBillDate()) {
                Date real = sdf.parse(order.getRealBillDate());
                saleOrder.setBillDate(real);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        saleOrder.setOrderState(SaleOrderStateEnum.YWC.getCode());
        saleOrder.setMealDiscountValue(BigDecimal.valueOf(order.getMealDiscAmount()));
        if (order.getLogisticsMode() == 0) {
            order.setLogisticsMode(7);
        }
        saleOrder.setLogisticsMode(order.getLogisticsMode());
        saleOrder.setLogisticsStoreCode(order.getReserveLocation());
        saleOrder.setChangeValue(BigDecimal.valueOf(order.getChangeValue()));
        saleOrder.setRoundUpOverageValue(BigDecimal.valueOf(order.getRoundUpOverageValue()));
        saleOrder.setStaffNo(order.getStaffNo());
        saleOrder.setStaffShopping(order.getStaffSale());
        saleOrder.setCallerRemark(order.getOutSideGiftsInfo());
        saleOrder.setColdStorage(order.getColdStorage());
        saleOrder.setPosId(order.getFlowNo());
        saleOrder.setDepositSale(order.isDepositSale());
        saleOrder.setTailMoneyPay(order.isTailMoneyPay());
        saleOrder.setBuyerReturnBankcard(CastUtil.castString(order.getPrintMode()));
        if (SellType.ISBACK(order.getOrderType())) {
            saleOrder.setOrderState(SaleOrderStateEnum.T_YWC.getCode());
            saleOrder.setSourceNo(order.getOriginIdSheetNo());
            saleOrder.setBuyerReturnReasonCode(CastUtil.castInt(order.getReason()));
            saleOrder.setReturnAmount(BigDecimal.valueOf(ManipulatePrecision.sub(order.getSaleValue(), order.getTotalDiscountValue())));
            saleOrder.setReturnMarket(order.getOriginShopName());
            saleOrder.setReturnMarketCode(order.getOriginShopCode());
            if (null == saleOrder.getReturnMarketCode()) {
                saleOrder.setReturnMarketCode(order.getShopCode());
                saleOrder.setReturnMarket(order.getShopName());
            }
            saleOrder.setBillSubType(1);
        }
        if ("5".equals(order.getOrderType())) {
            saleOrder.setSourceNo(order.getOriginIdSheetNo());
        }
        SaleOrdersExtModel orderExt = new SaleOrdersExtModel();
        orderExt.setReceiverMobile(order.getReceiverMobile());
        orderExt.setReceiverName(order.getReceiverName());
        orderExt.setReceiverPhone(order.getReceiverPhone());
        orderExt.setInvoiceTitle(order.getInvoiceTitle());
        orderExt.setReceiverDistrict(order.getReceiverDistrict());
        orderExt.setReceiverStreet(order.getReceiverStreet());
        orderExt.setReceiverAddress(order.getReceiverAddress());
        orderExt.setShopCode(order.getShopCode());
        orderExt.setCreateDate(nowTime);
        orderExt.setGivePointFlag(order.getGivePointFlag());
        orderExt.setReturnCouponFlag(order.getReturnCouponFlag());
        orderExt.setReturnPointFlag(order.getReturnPointFlag());
        orderExt.setScanGoodOperator(order.getScanGoodOperator());
        orderExt.setGroupBuyNumber(order.getGroupBuyNumber());
        orderExt.setGroupBuyerName(order.getGroupBuyerName());
        orderExt.setGroupBuyerCode(order.getGroupBuyerCode());
        orderExt.setGroupBuyManager(order.getGroupBuyManager());
        orderExt.setGroupBuyManagerName(order.getGroupBuyManagerName());
        try {
            orderExt.setCreateDate(saleOrder.getSaleDate());
            if (StringUtils.isNotBlank((String)order.getScanSubmitTime()) && StringUtils.isNotBlank((String)order.getSaleExtractTime())) {
                Date d = sdf.parse(order.getScanSubmitTime());
                Date d1 = sdf.parse(order.getSaleExtractTime());
                orderExt.setScanSubmitTime(d);
                orderExt.setSaleExtractTime(d1);
            } else {
                orderExt.setScanSubmitTime(saleOrder.getSaleDate());
                orderExt.setSaleExtractTime(saleOrder.getSaleDate());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        saleOrder.setCorporationCode(order.getOrgId());
        saleOrder.setStaffCardNo(order.getStaffCardNo());
        saleOrder.setStaffCardType(order.getStaffType());
        saleOrder.setHasGroupBuy(order.getHasGroupBuy());
        saleOrder.setExtendFt2(order.getExtendFt2());
        saleOrder.setExtendFt3(order.getExtendFt3());
        saleOrder.setExtendFt4(order.getExtendFt4());
        saleOrder.setExtendFt5(order.getExtendFt5());
        saleOrder.setExtendFt6(order.getExtendFt6());
        saleOrder.setExtendFt7(order.getExtendFt7());
        saleOrder.setExtendFt8(order.getOriginTerminalSno());
        saleOrder.setExtendFt9(order.getOriginTerminalNo());
        if (order.getOrderType().equals("h") || order.getOrderType().equals("i")) {
            saleOrder.setCorporationCode(order.getCorporationcode());
            saleOrder.setCallerRemark(order.getCallerremark());
        }
        saleOrder.setHasEbill(order.getHasEbill());
        saleOrder.setExtendFt1(order.getExtendFt1());
        saleOrders.setSaleOrders(saleOrder);
        saleOrders.setSaleOrdersExt(orderExt);
        saleOrders.setSaleOrdersMember(saleOrdersMember);
        return saleOrders;
    }

    @Override
    public Order transferRetrunOrder(SaleOrders saleOrders, Order order, String orderType) {
        SaleOrdersModel saleOrder = saleOrders.getSaleOrders();
        order.setOrderType(orderType);
        order.setOriginChannel(saleOrder.getChannel());
        order.setOriginIdSheetNo(saleOrder.getOrderNo());
        if (null != saleOrders.getSaleOrdersExt() && null != saleOrders.getSaleOrdersExt().getInvoiceTitle() && saleOrders.getSaleOrdersExt().getInvoiceTitle().length() > 0) {
            order.setOriginInvoiceTitle(saleOrders.getSaleOrdersExt().getInvoiceTitle());
        }
        order.setOriginReserveLocation(saleOrder.getLogisticsStoreCode());
        order.setOriginTerminalNo(saleOrder.getTerminalNo());
        order.setOriginTerminalSno(saleOrder.getTerminalSno());
        order.setOriginTerminalOperator(saleOrder.getTerminalOperator());
        order.setOriginFlowNo(saleOrder.getChannelSheetNo());
        order.setOriginOrderState(saleOrder.getOrderState());
        order.setOriginSeqNo(saleOrder.getCalcBillId());
        order.setReturnShopCode(saleOrder.getSaleMarketCode());
        order.setReturnShopName(saleOrder.getSaleMarket());
        order.setShopName(order.getShopName());
        order.setShopCode(order.getShopCode());
        order.setShopId(order.getShopId());
        order.setSaleDate(saleOrder.getSaleDate().toString());
        order.setEntId(saleOrder.getEntId());
        order.setErpCode(saleOrder.getBusCompany());
        ConsumersData cust = new ConsumersData();
        if (null != saleOrder.getConsumersId()) {
            cust.setConsumersId(saleOrder.getConsumersId());
        }
        if (null != saleOrders.getSaleOrdersMember().getCusClass()) {
            cust.setConsumersType(saleOrders.getSaleOrdersMember().getCusClass());
        }
        if (null != saleOrder.getCusCode()) {
            cust.setConsumersCard(saleOrder.getCusCode());
        }
        if (null != saleOrders.getSaleOrdersMember().getMemberNameChinese()) {
            cust.setConsumersCName(saleOrders.getSaleOrdersMember().getMemberNameChinese());
        }
        if (null != saleOrders.getSaleOrdersMember().getRemark()) {
            cust.setConsumersLevel(saleOrders.getSaleOrdersMember().getRemark());
        }
        if (null != saleOrders.getSaleOrdersMember().getBonusPointLastDay()) {
            cust.setPoint(saleOrders.getSaleOrdersMember().getBonusPointLastDay().doubleValue());
        }
        if (null != saleOrders.getSaleOrdersMember().getUserRemark()) {
            cust.setCustType(saleOrders.getSaleOrdersMember().getUserRemark());
        }
        if (null != saleOrders.getSaleOrdersMember()) {
            cust.setPoint(CastUtil.castDouble(saleOrders.getSaleOrdersMember().getBonusPointLastDay()));
        }
        order.setConsumersData(cust);
        order.setTotalDiscountValue(CastUtil.castDouble(saleOrder.getTotalDiscountValue()));
        order.setMemberDiscAmount(CastUtil.castDouble(saleOrder.getCustomDiscountValue()));
        order.setPreferentialDiscAmount(CastUtil.castDouble(saleOrder.getPopDiscountValue()));
        order.setOverageValue(CastUtil.castDouble(saleOrder.getOverageValue()));
        order.setChangeValue(CastUtil.castDouble(saleOrder.getChangeValue()));
        order.setRoundUpOverageValue(CastUtil.castDouble(saleOrder.getRoundUpOverageValue()));
        order.setExistPay(CastUtil.castDouble(saleOrder.getFactPay()));
        order.setOughtPay(CastUtil.castDouble(saleOrder.getOughtPay()));
        order.setPayState(saleOrder.getPayState());
        order.setPointCardNo(saleOrders.getSaleOrdersMember().getJfkh());
        order.setRefundAuthzCardNo(saleOrder.getThsq());
        order.setTerminalOperatorAuthzCardNo(saleOrder.getGhsq());
        order.setMemberAuthzCardNo(saleOrder.getHysq());
        order.setTotalDiscAuthzCardNo(saleOrder.getSqkh());
        order.setSeqNo(saleOrder.getCalcBillId());
        order.setTrackNo(saleOrders.getSaleOrdersMember().getTrackNo());
        order.setStaffCardNo(saleOrders.getSaleOrdersMember().getStaffCardNo());
        order.setStaffType(saleOrders.getSaleOrdersMember().getStaffCardType());
        order.setStaffNo(saleOrder.getStaffNo());
        order.setStaffSale(saleOrder.getStaffShopping());
        if (saleOrder.getStaffNo() != null) {
            order.setStaffLogin(true);
        }
        order.setLogisticsMode(saleOrder.getLogisticsMode());
        if (null != saleOrders.getSaleOrdersExt()) {
            order.setReceiverName(saleOrders.getSaleOrdersExt().getReceiverName());
            order.setReceiverMobile(saleOrders.getSaleOrdersExt().getReceiverMobile());
            order.setReceiverPhone(saleOrders.getSaleOrdersExt().getReceiverPhone());
        }
        if (null != saleOrder.getHasEbill()) {
            order.setHasEbill(saleOrder.getHasEbill());
        }
        order.setExtendFt2(saleOrder.getExtendFt2());
        order.setExtendFt3(saleOrder.getExtendFt3());
        order.setCallerremark(saleOrder.getCallerRemark());
        order.setCorporationcode(saleOrder.getCorporationCode());
        order.setExtendFt1(saleOrder.getExtendFt1());
        return order;
    }

    @Override
    public OrderForPos toReturnOrderForPos(CacheModel cacheModel) {
        Order order = cacheModel.getOrder();
        if (null == order.getConsumersData() || StringUtils.isBlank((String)order.getConsumersData().getConsumersCard())) {
            order.setConsumersData(null);
        }
        OrderForPos ofp = new OrderForPos();
        BeanCopierUtils.copyProperties(order, ofp);
        List<GoodsForPos> goodListPops = this.goodsTransfer.transferGoodsToPosGoodsListSingle(cacheModel.getReturnGoodsList(), cacheModel.getOrder().getSysPara().getCalcPriceType());
        ofp.setGoodsList(goodListPops);
        ofp.setSalePayments(this.paymentTransfer.transferPosPaymentList(cacheModel.getPayments()));
        if (null != cacheModel.getOrder().getDelGoods() && !StringUtils.isBlank((String)cacheModel.getOrder().getDelGoods().getBarNo())) {
            ofp.setDelGood(cacheModel.getOrder().getDelGoods());
        }
        return ofp;
    }

    @Override
    public OrderForPos toOrderForPos(CacheModel cacheModel) {
        Order order = cacheModel.getOrder();
        OrderForPos ofp = new OrderForPos();
        BeanCopierUtils.copyProperties(order, ofp);
        ofp.setDeductedCoupons(cacheModel.getDeductedCoupons());
        ofp.setReverseCoupons(cacheModel.getReverseCoupons());
        ofp.setIsAllReturn(cacheModel.getOrder().getIsAllReturn());
        List<GoodsForPos> goodListPops = this.goodsTransfer.transferGoodsToPosGoodsList(cacheModel.getGoodsList());
        ofp.setGoodsList(goodListPops);
        List<PaymentForPos> payListPos = this.paymentTransfer.transferPaymentsToPosPaymentsList(cacheModel.getPayments());
        ofp.getSalePayments().addAll(payListPos);
        ofp.setExceptPays(this.paymentTransfer.transferExceptPayForPosList(cacheModel.getExceptPayDetails()));
        ofp.setLimitedPays(cacheModel.getLimitedPayDetails());
        if (ofp.getLimitedPays().size() > 1) {
            ofp.setLimitedPays(ofp.getLimitedPays().stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<ExceptPay>(Comparator.comparing(ExceptPay::getPayCode))), ArrayList::new)));
        }
        ofp.getNeedCopType().addAll(cacheModel.getNeedCopType());
        return ofp;
    }

    @Override
    public CacheModel posOrdertoOrder(OrderForPos orderForPos, CacheModel cacheModel) {
        Order order = cacheModel.getOrder();
        BeanCopierUtils.copyProperties(orderForPos, order);
        List<Goods> goodsList = this.goodsTransfer.transferPosGoodsToGoodsList(orderForPos.getGoodsList());
        cacheModel.setGoodsList(goodsList);
        cacheModel.setOrder(order);
        return cacheModel;
    }

    @Override
    public OrderForPos toOrderForPosSingle(CacheModel cacheModel) {
        Order order = cacheModel.getOrder();
        OrderForPos ofp = new OrderForPos();
        BeanCopierUtils.copyProperties(order, ofp);
        if (cacheModel.getOrder().getAllowEditGoods()) {
            goodListPops = this.goodsTransfer.transferGoodsToPosGoodsListSingle(cacheModel.getGoodsList());
            ofp.getGoodsList().addAll(goodListPops);
        } else {
            goodListPops = this.goodsTransfer.transferGoodsToPosGoodsListSingle(cacheModel.getGoodsList());
            ofp.getGoodsList().addAll(goodListPops);
        }
        List<PaymentForPos> payListPos = this.paymentTransfer.transferPaymentsToPosPaymentsList(cacheModel.getPayments());
        ofp.getSalePayments().addAll(payListPos);
        if (cacheModel.getOrder().getDeletedGoods() != null && cacheModel.getOrder().getDeletedGoods().size() > 0) {
            ofp.setDeletedGoods(cacheModel.getOrder().getDeletedGoods());
        }
        ofp.getNeedCopType().addAll(cacheModel.getNeedCopType());
        ofp.setExceptPays(this.paymentTransfer.transferExceptPayForPosList(cacheModel.getExceptPayDetails()));
        ofp.setLimitedPays(cacheModel.getLimitedPayDetails());
        if (ofp.getLimitedPays().size() > 1) {
            ofp.setLimitedPays(ofp.getLimitedPays().stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<ExceptPay>(Comparator.comparing(ExceptPay::getPayCode))), ArrayList::new)));
        }
        return ofp;
    }

    @Override
    public OrderForPos toOrderForPosOrderSave(CacheModel cacheModel, List<Goods> printGoods) {
        Order order = cacheModel.getOrder();
        OrderForPos ofp = new OrderForPos();
        BeanCopierUtils.copyProperties(order, ofp);
        List<GoodsForPos> goodListPops = this.goodsTransfer.transferGoodsToPosGoodsListForSave(printGoods, cacheModel.getOrder().getSysPara().getCalcPriceType(), true);
        ofp.getGoodsList().addAll(goodListPops);
        List<PaymentForPos> payListPos = this.paymentTransfer.transferPaymentsToPosPaymentsList(cacheModel.getPayments());
        ofp.setSalePayments(payListPos);
        if ("5".equals(order.getOrderType())) {
            List<PaymentForPos> oripayListPos = this.paymentTransfer.transferPaymentsToPosPaymentsList(cacheModel.getReturnPayments());
            oripayListPos.addAll(payListPos);
            ofp.setSalePayments(oripayListPos);
        }
        return ofp;
    }

    @Override
    public OrderForPos toGoodsForChoice(List<Goods> choiceList) {
        OrderForPos ofp = new OrderForPos();
        ArrayList<Goods> goodListPops = new ArrayList<Goods>();
        for (Goods goods : choiceList) {
            goodListPops.add(this.goodsTransfer.removeSinglePopDetails(goods));
        }
        ofp.getGoodsList().addAll(goodListPops);
        return ofp;
    }

    @Override
    public OrderForPos toOrderForReturnQuery(CacheModel cacheModel) {
        Order order = cacheModel.getOrder();
        OrderForPos ofp = new OrderForPos();
        BeanCopierUtils.copyProperties(order, ofp);
        List<GoodsForPos> goodListPops = this.goodsTransfer.transferGoodsToPosGoodsListSingle(cacheModel.getReturnGoodsList(), cacheModel.getOrder().getSysPara().getCalcPriceType(), true);
        ofp.getGoodsList().addAll(goodListPops);
        if (!CollectionUtils.isEmpty(cacheModel.getReturnPayments())) {
            List<PaymentForPos> payListPos = this.paymentTransfer.transferPaymentsToPosPaymentsList(cacheModel.getReturnPayments());
            ofp.getSalePayments().addAll(payListPos);
        }
        return ofp;
    }

    @Override
    public OrderForPos toOrderForNoTerminalSno(CacheModel cacheModel) {
        Order order = cacheModel.getOrder();
        OrderForPos ofp = new OrderForPos();
        BeanCopierUtils.copyProperties(order, ofp);
        List<GoodsForPos> goodListPops = this.goodsTransfer.transferGoodsToPosGoodsListSingle(cacheModel.getGoodsList(), cacheModel.getOrder().getSysPara().getCalcPriceType());
        ofp.getGoodsList().addAll(goodListPops);
        return ofp;
    }

    @Override
    public OrderForPos toOrderForPos(SaleOrders saleOrders) {
        SaleOrdersModel saleOrder = saleOrders.getSaleOrders();
        List<SaleOrderDetailModel> saleOrderDetails = saleOrders.getSaleOrderDetail();
        OrderForPos order = new OrderForPos();
        SaleOrdersMemberModel saleOrdersMember = saleOrders.getSaleOrdersMember();
        order.setEntId(saleOrder.getEntId());
        order.setChannel(saleOrder.getChannel());
        order.setFlowNo(saleOrder.getChannelSheetNo());
        order.setErpCode(saleOrder.getBusCompany());
        ConsumersData cust = new ConsumersData();
        cust.setConsumersId(saleOrder.getConsumersId());
        cust.setConsumersType(saleOrdersMember.getCusClass());
        cust.setConsumersCard(saleOrder.getCusCode());
        order.setConsumersData(cust);
        order.setTerminalNo(saleOrder.getTerminalNo());
        order.setTerminalSno(saleOrder.getTerminalSno());
        order.setTerminalOperator(saleOrder.getTerminalOperator());
        order.setShopId(Long.parseLong(saleOrder.getSaleMarketCode()));
        order.setShopName(saleOrder.getSaleMarket());
        order.setShopCode(saleOrder.getSaleMarketCode());
        order.setTotalDiscountValue(CastUtil.castDouble(saleOrder.getTotalDiscountValue()));
        order.setMemberDiscAmount(CastUtil.castDouble(saleOrder.getCustomDiscountValue()));
        order.setPreferentialDiscAmount(CastUtil.castDouble(saleOrder.getPopDiscountValue()));
        order.setOverageValue(CastUtil.castDouble(saleOrder.getOverageValue()));
        order.setOrderType(saleOrder.getSheetTypeCode());
        order.setExistPay(CastUtil.castDouble(saleOrder.getFactPay()));
        order.setOughtPay(CastUtil.castDouble(saleOrder.getOughtPay()));
        order.setPayState(saleOrder.getPayState());
        order.setPointCardNo(saleOrdersMember.getJfkh());
        order.setRefundAuthzCardNo(saleOrder.getThsq());
        order.setTerminalOperatorAuthzCardNo(saleOrder.getGhsq());
        order.setMemberAuthzCardNo(saleOrder.getHysq());
        order.setTotalDiscAuthzCardNo(saleOrder.getSqkh());
        order.setSeqNo(saleOrder.getCalcBillId());
        order.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(CastUtil.castDouble(saleOrder.getTotalDiscountValue().subtract(saleOrder.getPayDiscountValue()))));
        order.setRealSaleValue(ManipulatePrecision.doubleConvert(CastUtil.castDouble(saleOrder.getTotalDiscountValue().add(saleOrder.getOughtPay()).subtract(saleOrder.getPayDiscountValue()))));
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            order.setSaleDate(sdf.format(saleOrder.getSaleDate()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        order.setIdSheetNo(saleOrder.getOrderNo());
        order.setChangeValue(CastUtil.castDouble(saleOrder.getChangeValue()));
        order.setRoundUpOverageValue(CastUtil.castDouble(saleOrder.getRoundUpOverageValue()));
        int sumqty = 0;
        if (null != saleOrderDetails && saleOrderDetails.size() > 0) {
            for (SaleOrderDetailModel saleOrderDetail : saleOrderDetails) {
                if ("97".equals(saleOrderDetail.getGoodType())) continue;
                if (saleOrderDetail.getWeighGood().booleanValue() && !this.posLogicCompoment.checkEscaleEditFlagForDetail((JSONObject)JSON.toJSON((Object)saleOrderDetail))) {
                    ++sumqty;
                    continue;
                }
                sumqty = (int)((double)sumqty + saleOrderDetail.getQty());
            }
        }
        order.setQty(sumqty);
        order.setExtendFt2(saleOrder.getExtendFt2());
        order.setExtendFt3(saleOrder.getExtendFt3());
        order.setCorporationcode(saleOrder.getCorporationCode());
        order.setCallerremark(saleOrder.getCallerRemark());
        order.setExtendFt1(saleOrder.getExtendFt1());
        return order;
    }

    @Override
    public OrderForPos toOrderForPos(SaleOrders_WSLF saleOrders) {
        OrdersModel4Pos saleOrder = saleOrders.getOrders();
        List<OrdersDetailModel> saleOrderDetails = saleOrders.getOrdersDetail();
        OrderForPos order = new OrderForPos();
        OrdersMemberModel saleOrdersMember = saleOrders.getOrdersMember();
        order.setStaffCardNo(saleOrder.getStaffCardNo());
        order.setStaffType(saleOrder.getStaffCardType());
        order.setStaffNo(saleOrder.getStaffNo());
        order.setStaffSale(saleOrder.getStaffShopping());
        if (saleOrder.getStaffNo() != null) {
            order.setStaffLogin(true);
        }
        order.setEntId(saleOrder.getEntId());
        order.setChannel(saleOrder.getChannel());
        order.setFlowNo(saleOrder.getChannelSheetNo());
        order.setPosId(saleOrder.getPosId());
        order.setErpCode(saleOrder.getErpCode());
        ConsumersData cust = new ConsumersData();
        if (null != saleOrdersMember) {
            if ("1".equals(saleOrdersMember.getCusProperty())) {
                cust.setIsMami(true);
            } else {
                cust.setIsMami(false);
            }
            order.setUnavailablePoint(CastUtil.castDouble(saleOrdersMember.getUnavailablePoint()));
            order.setUnavailablePointDate(saleOrdersMember.getUnavailablePointDate());
            order.setThisTimePoint(CastUtil.castDouble(saleOrdersMember.getThisTimeGivePoint()));
            order.setThisTimeUsedPoint(CastUtil.castDouble(saleOrdersMember.getThisTimeUsedPoint()));
            order.setTotalPoint(CastUtil.castDouble(saleOrdersMember.getThisTimeUsablePoint()));
            cust.setPoint(CastUtil.castDouble(saleOrdersMember.getLastTimeUsablePoint()));
            cust.setConsumersCardExp(saleOrdersMember.getMembershipExpireDate());
            cust.setConsumersId(saleOrder.getCid());
            cust.setConsumersType(saleOrdersMember.getCusClass());
            cust.setConsumersCard(saleOrder.getCusCode());
            cust.setCustType(saleOrdersMember.getUserRemark());
            order.setPointCardNo(saleOrdersMember.getJfkh());
        }
        order.setConsumersData(cust);
        order.setTerminalNo(saleOrder.getTerminalNo());
        order.setTerminalSno(saleOrder.getTerminalSno());
        order.setTerminalOperator(saleOrder.getTerminalOperator());
        order.setShopName(saleOrder.getBusiTakeMarket());
        order.setShopCode(saleOrder.getBusiTakeMarketCode());
        order.setTotalDiscountValue(ManipulatePrecision.doubleConvert(CastUtil.castDouble(saleOrder.getTotalDiscountValue())));
        order.setMemberDiscAmount(CastUtil.castDouble(saleOrder.getCustomDiscountValue()));
        order.setPreferentialDiscAmount(CastUtil.castDouble(saleOrder.getPopDiscountValue()));
        order.setOverageValue(CastUtil.castDouble(saleOrder.getOverageValue()));
        order.setOrderType(saleOrder.getOrderType());
        order.setExistPay(CastUtil.castDouble(saleOrder.getFactPay()));
        order.setOughtPay(CastUtil.castDouble(saleOrder.getOughtPay()));
        order.setPayState(saleOrder.getPayState());
        order.setRefundAuthzCardNo(saleOrder.getThsq());
        order.setTerminalOperatorAuthzCardNo(saleOrder.getGhsq());
        order.setMemberAuthzCardNo(saleOrder.getHysq());
        order.setTotalDiscAuthzCardNo(saleOrder.getSqkh());
        order.setSeqNo(saleOrder.getCalcBillId());
        order.setSaleValue(ManipulatePrecision.add(order.getOughtPay(), order.getTotalDiscountValue()));
        order.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(CastUtil.castDouble(saleOrder.getTotalDiscountValue().subtract(saleOrder.getPayDiscountValue()))));
        order.setRealSaleValue(ManipulatePrecision.doubleConvert(CastUtil.castDouble(saleOrder.getTotalDiscountValue().add(saleOrder.getOughtPay()).subtract(saleOrder.getPayDiscountValue()))));
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            order.setSaleDate(sdf.format(saleOrder.getSaleDate()));
            if (null != saleOrder.getOriginSaleDate()) {
                order.setOriginSaleDate(sdf.format(saleOrder.getOriginSaleDate()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        order.setOriginTerminalNo(saleOrder.getExtendFt9());
        order.setOriginTerminalSno(saleOrder.getExtendFt8());
        order.setOriginShopCode(saleOrder.getOriginMarketCode());
        order.setOriginShopName(saleOrder.getOriginMarket());
        order.setIdSheetNo(saleOrder.getSheetNo());
        order.setChangeValue(CastUtil.castDouble(saleOrder.getChangeValue()));
        order.setRoundUpOverageValue(CastUtil.castDouble(saleOrder.getRoundUpOverageValue()));
        if (null != saleOrder.getHasGroupBuy()) {
            order.setHasGroupBuy(saleOrder.getHasGroupBuy());
        }
        if (null != saleOrder.getHasEbill()) {
            order.setHasEbill(saleOrder.getHasEbill());
        }
        int sumqty = 0;
        if (null != saleOrderDetails && saleOrderDetails.size() > 0) {
            for (OrdersDetailModel saleOrderDetail : saleOrderDetails) {
                if ("97".equals(saleOrderDetail.getGoodType())) continue;
                if (saleOrderDetail.getWeighGood().booleanValue() && !this.posLogicCompoment.checkEscaleEditFlagForDetail((JSONObject)JSON.toJSON((Object)saleOrderDetail))) {
                    ++sumqty;
                    continue;
                }
                sumqty = (int)((double)sumqty + saleOrderDetail.getQty());
            }
        }
        order.setQty(sumqty);
        order.setExtendFt2(saleOrder.getExtendFt2());
        order.setExtendFt1(saleOrder.getExtendFt1());
        order.setExtendFt4(saleOrder.getExtendFt4());
        order.setTailMoneyPay(saleOrder.isTailMoneyPay());
        order.setDepositSale(saleOrder.isDepositSale());
        order.setExtendFt5(saleOrder.getExtendFt5());
        order.setExtendFt6(saleOrder.getExtendFt6());
        order.setExtendFt7(saleOrder.getExtendFt7());
        return order;
    }

    @Override
    public Order posOrderToGroupOrder(Order order, OrderForPos orderForPos) {
        order.setStaffCardNo(orderForPos.getStaffCardNo());
        order.setStaffNo(orderForPos.getStaffNo());
        order.setEntId(orderForPos.getEntId());
        order.setOughtPay(orderForPos.getOughtPay());
        order.setQty(orderForPos.getQty());
        order.setRealSaleValue(orderForPos.getRealSaleValue());
        order.setRealSaleValueDzc(orderForPos.getRealSaleValueDzc());
        order.setRealTotalDiscountValue(orderForPos.getRealTotalDiscountValue());
        order.setRealTotalDiscountValueDzc(orderForPos.getRealTotalDiscountValueDzc());
        order.setRemainValue(orderForPos.getRemainValue());
        order.setGroupBuyNumber(orderForPos.getGroupBuyNumber());
        order.setGroupBuyerCode(orderForPos.getGroupBuyerCode());
        order.setGroupBuyerName(orderForPos.getGroupBuyerName());
        order.setGroupBuyManager(orderForPos.getGroupBuyManager());
        order.setGroupBuyManagerName(orderForPos.getGroupBuyManagerName());
        order.setAllowPayCodes(orderForPos.getAllowPayCodes());
        order.setSaleDate(orderForPos.getSaleDate());
        order.setSaleValue(orderForPos.getSaleValue());
        order.setSeqNo(orderForPos.getSeqNo());
        order.setTempRandomDiscount(orderForPos.getTempRandomDiscount());
        order.setTempRandomDiscount(orderForPos.getTempRandomDiscount());
        order.setTempZzk(orderForPos.getTempZzk());
        order.setTempZzr(orderForPos.getTempZzr());
        order.setTemporaryDiscAmount(orderForPos.getTemporaryDiscAmount());
        order.setThisTimePoint(orderForPos.getThisTimePoint());
        order.setThisTimeUsedPoint(orderForPos.getThisTimeUsedPoint());
        order.setTotalDiscAuthzCardShare(orderForPos.getTotalDiscAuthzCardShare());
        order.setTotalDiscountValue(orderForPos.getTotalDiscountValue());
        order.setTotalPoint(orderForPos.getTotalPoint());
        order.setUnavailablePoint(orderForPos.getUnavailablePoint());
        order.setYpopBillNo(order.getFlowNo());
        return order;
    }

    @Override
    public OrderGains convertOrderGains(List<Coupon> couponGains) {
        return this.convertOrderGains(couponGains, false);
    }

    @Override
    public OrderGains convertOrderGains(List<Coupon> couponGains, boolean isReprint) {
        if (null == couponGains || couponGains.size() == 0) {
            return null;
        }
        OrderGains orderGain = new OrderGains();
        ArrayList<CouponOutDef> tempCoupons = new ArrayList<CouponOutDef>();
        double experience = 0.0;
        double points = 0.0;
        for (int i = 0; i < couponGains.size(); ++i) {
            Coupon couponTemp = couponGains.get(i);
            if ("01".equals(couponTemp.getCouponGroup())) {
                points = ManipulatePrecision.add(points, couponTemp.getAmount());
                continue;
            }
            if ("04".equals(couponTemp.getCouponGroup())) {
                experience = ManipulatePrecision.add(experience, couponTemp.getAmount());
                continue;
            }
            if (!"01".equals(couponTemp.getCouponGroup()) && !"02".equals(couponTemp.getCouponGroup()) && !"05".equals(couponTemp.getCouponGroup()) && !"07".equals(couponTemp.getCouponGroup()) || ManipulatePrecision.doubleCompare(0.0, couponTemp.getAmount(), 2) == 0 || isReprint) continue;
            CouponOutDef couponOutTemp = new CouponOutDef();
            BeanUtils.copyProperties((Object)couponTemp, (Object)couponOutTemp);
            couponOutTemp.setQty(1.0);
            if ("07".equals(couponTemp.getCouponGroup())) {
                couponOutTemp.setCouponGroup("01");
            } else if ("04".equals(couponTemp.getCouponclass()) || "02".equals(couponTemp.getCouponGroup()) && couponTemp.getCouponType().startsWith("DC")) {
                couponOutTemp.setCouponGroup("04");
            }
            tempCoupons.add(couponOutTemp);
        }
        orderGain.setOrderCouponGains(tempCoupons);
        orderGain.setExperience(experience);
        orderGain.setPoints(points);
        return orderGain;
    }

    @Override
    public SaleOrders saleOrdersFromCacheModel(CacheModel cacheModel) {
        Order order = cacheModel.getOrder();
        boolean isCold = true;
        for (Goods g : cacheModel.getGoodsList()) {
            if (g.getColdGood()) continue;
            isCold = false;
            break;
        }
        if (isCold) {
            order.setColdStorage(true);
        }
        SaleOrders saleOrder = this.toSaleOrder(order);
        saleOrder = this.gainSaleOrderDetailAndSaleOrderDetailPop(saleOrder, cacheModel.getGoodsList(), order);
        saleOrder.setSaleOrderPay(this.paymentTransfer.transferSaleOrderPayModel(cacheModel.getPayments(), order));
        saleOrder = this.gainSaleOrderGainDetailAndSaleOrderUseCoupon(saleOrder, cacheModel.getGoodsList(), order.getShopCode());
        if (null != order.getCouponDetails() && order.getCouponDetails().size() > 0) {
            saleOrder.setSaleOrderGain(this.couponTransfer.transferSaleOrderGainModel(order.getCouponDetails()));
        }
        return saleOrder;
    }

    @Override
    public SaleOrders gainSaleOrderDetailAndSaleOrderDetailPop(SaleOrders saleOrder, List<Goods> goodsList, Order order) {
        ArrayList<SaleOrderDetailModel> details = new ArrayList<SaleOrderDetailModel>();
        ArrayList<SaleOrderDetailPopModel> pops = new ArrayList<SaleOrderDetailPopModel>();
        boolean hasDuplFlag = false;
        if (goodsList == null || goodsList.size() == 0) {
            return saleOrder;
        }
        BigDecimal totalDiscount = BigDecimal.ZERO;
        for (Goods g : goodsList) {
            if (g.getIsNoBackGift()) continue;
            SaleOrderDetailModel d = this.goodsTransfer.transferSaleOrderDetailModel(g);
            Date nowTime = TimeZoneUtil.ConvertTimeByTimeZone(new Date(), order.getTimeZone(), this.localcache);
            d.setCreateDate(nowTime);
            totalDiscount = totalDiscount.add(BigDecimal.valueOf(g.getTotalDiscountValue()));
            d.setShopCode(order.getShopCode());
            if (SellType.ISBACK(saleOrder.getSaleOrders().getSheetTypeCode())) {
                d.setOldRowNo(g.getOriginalFlowId());
            }
            details.add(d);
            List<SaleOrderDetailPopModel> dPops = this.popdetailTransfer.transferSaleOrderDetailPopModel(g, g.getPopDetailsInfo(), order.getShopCode());
            if (dPops == null || dPops.size() <= 0) continue;
            pops.addAll(dPops);
        }
        saleOrder.getSaleOrders().setTotalDiscountValue(totalDiscount);
        if (details.size() > 0) {
            saleOrder.setSaleOrderDetail(details);
        }
        if (pops.size() > 0) {
            saleOrder.setSaleOrderDetailPop(pops);
        }
        return saleOrder;
    }

    @Override
    public SaleOrders gainSaleOrderGainDetailAndSaleOrderUseCoupon(SaleOrders saleOrder, List<Goods> goodsList, String shopCode) {
        if (goodsList == null || goodsList.size() == 0) {
            return saleOrder;
        }
        ArrayList<SaleOrderGainDetailModel> couponGains = new ArrayList<SaleOrderGainDetailModel>();
        ArrayList<SaleOrderUseCouponModel> couponUses = new ArrayList<SaleOrderUseCouponModel>();
        for (Goods g : goodsList) {
            if (g.getCouponGains() != null && g.getCouponGains().size() > 0) {
                couponGains.addAll(this.couponTransfer.transferSaleOrderGainModel(g.getCouponGains(), g.getFlowId(), shopCode));
            }
            if (g.getCouponUses() == null || g.getCouponUses().size() <= 0) continue;
            couponUses.addAll(this.couponTransfer.transferSaleOrderUseCouponModel(g.getCouponUses(), g.getFlowId(), shopCode));
        }
        if (couponGains.size() > 0) {
            saleOrder.setSaleOrderGainDetail(couponGains);
        }
        if (couponUses.size() > 0) {
            saleOrder.setSaleOrderUseCoupon(couponUses);
        }
        return saleOrder;
    }

    @Override
    public GetOrdersOutDef transferOrderToGetOrdersOut(GetOrdersIn getOrdersIn, List<OrdersModel> orders1, int total_results1) {
        GetOrdersOutDef getOrdersOut = new GetOrdersOutDef();
        getOrdersOut.setOrders(new ArrayList<GetOrdersOutDef.GetOrderInfo>());
        List<OrdersModel> orders = orders1;
        if (orders.size() > 0) {
            for (OrdersModel order : orders) {
                GetOrdersOutDef.GetOrderInfo getOrdersInfo = new GetOrdersOutDef.GetOrderInfo();
                getOrdersInfo.setTerminalNo(order.getTerminalNo());
                getOrdersInfo.setErpCode(order.getErpCode());
                getOrdersInfo.setShopCode(getOrdersIn.getShopCode());
                getOrdersInfo.setShopName(order.getBusiTakeMarket());
                SimpleDateFormat s = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                try {
                    getOrdersInfo.setSaleDate(s.format(order.getSaleDate()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                getOrdersInfo.setTerminalOperator(order.getTerminalOperator());
                getOrdersInfo.setTerminalSno(order.getTerminalSno());
                getOrdersInfo.setOrderType(order.getOrderType());
                getOrdersInfo.setChannel(order.getChannel());
                getOrdersInfo.setOughtPay(order.getOughtPay().doubleValue());
                getOrdersInfo.setExistPay(order.getFactPay().doubleValue());
                getOrdersInfo.setOverageValue(order.getOverageValue().doubleValue());
                getOrdersInfo.setQty(order.getQty() != null ? order.getQty() : 0.0);
                getOrdersInfo.setTotalDiscountValue(order.getTotalDiscountValue().doubleValue());
                getOrdersInfo.setConsumersCard(order.getCusCode());
                getOrdersInfo.setPosId(order.getPosId());
                getOrdersOut.getOrders().add(getOrdersInfo);
            }
        }
        getOrdersOut.setTotalResults(total_results1);
        return getOrdersOut;
    }

    @Override
    public Order transferRetrunOrder(SaleOrders_WSLF saleOrders, Order order, String orderType) {
        OrdersModel4Pos saleOrder = saleOrders.getOrders();
        order.setOrderType(orderType);
        order.setOriginChannel(saleOrder.getChannel());
        order.setOriginIdSheetNo(saleOrder.getSheetNo());
        if (null != saleOrders.getOrdersExt() && null != saleOrders.getOrdersExt().getInvoiceTitle() && saleOrders.getOrdersExt().getInvoiceTitle().length() > 0) {
            order.setOriginInvoiceTitle(saleOrders.getOrdersExt().getInvoiceTitle());
        }
        order.setOriginTerminalNo(saleOrder.getTerminalNo());
        order.setOriginTerminalSno(saleOrder.getTerminalSno());
        order.setOriginTerminalOperator(saleOrder.getTerminalOperator());
        order.setOriginFlowNo(saleOrder.getChannelSheetNo());
        order.setOriginOrderState(saleOrder.getOrderState());
        order.setOriginSeqNo(saleOrder.getCalcBillId());
        order.setExtendFt3(saleOrder.getExtendFt3());
        order.setCorporationcode(saleOrder.getCorporationCode());
        order.setCallerremark(saleOrder.getCallerRemark());
        order.setOriginPosId(saleOrder.getPosId());
        order.setOriginShopCode(saleOrder.getBusiTakeMarketCode());
        order.setOriginShopName(saleOrder.getBusiTakeMarket());
        order.setShopName(order.getShopName());
        order.setShopCode(order.getShopCode());
        order.setShopId(order.getShopId());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            String nowDateTime = TimeZoneUtil.ConvertTimeByTimeZone1(new Date(), order.getTimeZone(), this.localcache);
            if (StringUtils.isBlank((String)nowDateTime)) {
                nowDateTime = sdf.format(new Date());
            }
            order.setSaleDate(nowDateTime);
            if (null != saleOrder.getSaleDate()) {
                String originSaleDate = sdf.format(saleOrder.getSaleDate());
                order.setOriginSaleDate(originSaleDate);
            }
        }
        catch (Exception nowDateTime) {
            // empty catch block
        }
        order.setEntId(saleOrder.getEntId());
        order.setErpCode(saleOrder.getErpCode());
        if (null != saleOrder.getHasGroupBuy()) {
            order.setHasGroupBuy(saleOrder.getHasGroupBuy());
        }
        order.setDepositSale(saleOrder.isDepositSale());
        order.setTailMoneyPay(saleOrder.isTailMoneyPay());
        ConsumersData cust = new ConsumersData();
        if (null != saleOrders.getOrdersMember()) {
            OrdersMemberModel ordersMember = saleOrders.getOrdersMember();
            cust.setConsumersId(ordersMember.getCid());
            cust.setConsumersType(ordersMember.getCusClass());
            cust.setConsumersCardName(ordersMember.getCusLevelName());
            cust.setConsumersCName(ordersMember.getMemberNameChinese());
            cust.setConsumersLevel(ordersMember.getCusLevel());
            cust.setConsumersCard(ordersMember.getCusCode());
            cust.setMemberActionSno(ordersMember.getMemberActionSno());
            cust.setConsumersCardExp(ordersMember.getMembershipExpireDate());
            if ("1".equals(ordersMember.getCusProperty())) {
                cust.setIsMami(true);
            } else {
                cust.setIsMami(false);
            }
            cust.setCustType(ordersMember.getUserRemark());
            cust.setConsumersCardNOECP(ordersMember.getTrackNo());
            order.setUnavailablePoint(CastUtil.castDouble(ordersMember.getUnavailablePoint()));
            order.setUnavailablePointDate(ordersMember.getUnavailablePointDate());
            order.setTrackNo(saleOrders.getOrdersMember().getTrackNo());
            order.setPointCardNo(saleOrders.getOrdersMember().getJfkh());
        }
        order.setConsumersData(cust);
        order.setTotalDiscountValue(CastUtil.castDouble(saleOrder.getTotalDiscountValue()));
        order.setTemporaryDiscAmount(CastUtil.castDouble(saleOrder.getAdjustDiscountValue()));
        order.setMemberDiscAmount(CastUtil.castDouble(saleOrder.getCustomDiscountValue()));
        order.setPreferentialDiscAmount(ManipulatePrecision.doubleConvert(CastUtil.castDouble(saleOrder.getPopDiscountValue()) + CastUtil.castDouble(saleOrder.getPayDiscountValue())));
        order.setNoDiscountValue(CastUtil.castDouble(saleOrder.getPayDiscountValue()));
        order.setOverageValue(CastUtil.castDouble(saleOrder.getOverageValue()));
        order.setChangeValue(CastUtil.castDouble(saleOrder.getChangeValue()));
        order.setRoundUpOverageValue(CastUtil.castDouble(saleOrder.getRoundUpOverageValue()));
        order.setExistPay(CastUtil.castDouble(saleOrder.getFactPay()));
        order.setOughtPay(ManipulatePrecision.doubleConvert(CastUtil.castDouble(saleOrder.getOughtPay()) - order.getRoundUpOverageValue()));
        order.setPayState(saleOrder.getPayState());
        order.setRefundAuthzCardNo(saleOrder.getThsq());
        order.setTerminalOperatorAuthzCardNo(saleOrder.getGhsq());
        order.setMemberAuthzCardNo(saleOrder.getHysq());
        order.setTotalDiscAuthzCardNo(saleOrder.getSqkh());
        order.setSeqNo(saleOrder.getCalcBillId());
        order.setStaffCardNo(saleOrder.getStaffCardNo());
        order.setStaffType(saleOrder.getStaffCardType());
        order.setStaffNo(saleOrder.getStaffNo());
        order.setStaffSale(saleOrder.getStaffShopping());
        order.setLogisticsMode(saleOrder.getLogisticsMode());
        if (null != saleOrder.getHasEbill()) {
            order.setHasEbill(saleOrder.getHasEbill());
        }
        order.setExtendFt2(saleOrder.getExtendFt2());
        order.setExtendFt3(saleOrder.getExtendFt3());
        order.setCorporationcode(saleOrder.getCorporationCode());
        order.setCallerremark(saleOrder.getCallerRemark());
        if (null != saleOrders.getOrdersExt()) {
            order.setReceiverName(saleOrders.getOrdersExt().getReceiverName());
            order.setReceiverMobile(saleOrders.getOrdersExt().getReceiverMobile());
            order.setReceiverPhone(saleOrders.getOrdersExt().getReceiverPhone());
            order.setOriginReserveLocation(saleOrders.getOrdersExt().getOfcMarketCode());
            order.setScanGoodOperator(saleOrders.getOrdersExt().getScanGoodOperator());
            order.setSaleExtractTime(saleOrders.getOrdersExt().getSaleExtractTime().toString());
            order.setGroupBuyNumber(saleOrders.getOrdersExt().getGroupBuyNumber());
            order.setGroupBuyerName(saleOrders.getOrdersExt().getGroupBuyerName());
            order.setGroupBuyerCode(saleOrders.getOrdersExt().getGroupBuyerCode());
            order.setGroupBuyManager(saleOrders.getOrdersExt().getGroupBuyManager());
            order.setGroupBuyManagerName(saleOrders.getOrdersExt().getGroupBuyManagerName());
        }
        return order;
    }
}

