/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.javaPos.commonkit.beantransfer;

import com.alibaba.fastjson.JSONObject;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.javaPos.commonkit.beantransfer.CouponTransfer;
import com.efuture.business.javaPos.commonkit.beantransfer.PaymentTransfer;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.ExceptPay;
import com.efuture.business.javaPos.struct.ExceptPayForPos;
import com.efuture.business.javaPos.struct.Order;
import com.efuture.business.javaPos.struct.Payment;
import com.efuture.business.javaPos.struct.PaymentForPos;
import com.efuture.business.javaPos.struct.YpopCrdInfo;
import com.efuture.business.javaPos.struct.orderCentre.OrdersPayModel;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrderPayModel;
import com.efuture.business.javaPos.struct.promotionCentre.SellCoupon;
import com.efuture.business.javaPos.struct.promotionCentre.SellExceptPay;
import com.efuture.business.javaPos.struct.promotionCentre.SellPayment;
import com.efuture.business.javaPos.struct.response.AddQrCodeOut;
import com.efuture.business.util.BeanCopierUtils;
import com.efuture.business.util.CastUtil;
import com.efuture.business.util.DataExchageUtils;
import com.efuture.business.util.TimeZoneUtil;
import com.efuture.business.util.UniqueID;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class PaymentTransferImpl
implements PaymentTransfer {
    private static final Logger log = LoggerFactory.getLogger(PaymentTransferImpl.class);
    @Autowired
    public CouponTransfer couponTransfer;
    @Value(value="${localcache.enabled}")
    private Boolean localcache;

    @Override
    public List<SaleOrderPayModel> transferSaleOrderPayModel(List<Payment> payments, Order order) {
        if (payments == null || payments.size() == 0) {
            return null;
        }
        ArrayList<SaleOrderPayModel> saleOrderPays = new ArrayList<SaleOrderPayModel>();
        for (Payment payment : payments) {
            SaleOrderPayModel saleOrderPay = this.transferSaleOrderPayModel(payment);
            saleOrderPay.setShopCode(order.getShopCode());
            Date nowTime = TimeZoneUtil.ConvertTimeByTimeZone(new Date(), order.getTimeZone(), this.localcache);
            saleOrderPay.setCreateDate(nowTime);
            saleOrderPays.add(saleOrderPay);
        }
        return saleOrderPays;
    }

    @Override
    public SaleOrderPayModel transferSaleOrderPayModel(Payment payment) {
        SaleOrderPayModel saleOrderPay = new SaleOrderPayModel();
        saleOrderPay.setCouponEventId(payment.getCouponEventId());
        saleOrderPay.setMoney(BigDecimal.valueOf(payment.getMoney()));
        saleOrderPay.setRate(payment.getRate());
        saleOrderPay.setCopType(payment.getCouponType());
        saleOrderPay.setPayName(payment.getPayName());
        saleOrderPay.setMerchantId(payment.getMisMerchantId());
        saleOrderPay.setTerminalId(payment.getMisTerminalId());
        saleOrderPay.setPayMemo(payment.getPayMemo());
        saleOrderPay.setOverage(BigDecimal.valueOf(payment.getOverage()));
        saleOrderPay.setCouponPolicyId(payment.getCouponPolicyId());
        saleOrderPay.setPayType(payment.getPayType());
        saleOrderPay.setCouponTraceSeqno("" + payment.getCouponTraceSeqno());
        saleOrderPay.setFlag(CastUtil.castInt(payment.getFlag()));
        saleOrderPay.setCouponGroup(payment.getCouponGroup());
        saleOrderPay.setCouponBalance(BigDecimal.valueOf(payment.getCouponBalance()));
        saleOrderPay.setPayCode(payment.getPayCode());
        saleOrderPay.setAmount(BigDecimal.valueOf(payment.getAmount()));
        if (StringUtils.isNotEmpty((String)payment.getAdditionalData()) && StringUtils.isNotEmpty((String)payment.getDeliveryMemoNumber())) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("newRateAmt", (Object)payment.getAdditionalData());
            jsonObject.put("newRate", (Object)payment.getDeliveryMemoNumber());
            saleOrderPay.setExtMemo(jsonObject.toJSONString());
        }
        if (null != payment.getPayNo() && payment.getPayNo().length() > 100) {
            saleOrderPay.setPayNo(payment.getPayNo().substring(0, 100));
        } else {
            saleOrderPay.setPayNo(payment.getPayNo());
        }
        if (null != payment.getRefCode() && payment.getRefCode().length() > 100) {
            saleOrderPay.setRefCode(payment.getRefCode().substring(0, 100));
        } else {
            saleOrderPay.setRefCode(payment.getRefCode());
        }
        if (null != payment.getAuthCode() && payment.getAuthCode().length() > 100) {
            saleOrderPay.setAuthCode(payment.getAuthCode().substring(0, 100));
        } else {
            saleOrderPay.setAuthCode(payment.getAuthCode());
        }
        if (null != payment.getOriginSheetNo()) {
            saleOrderPay.setOriginSheetNo(payment.getOriginSheetNo());
        }
        saleOrderPay.setCouponEventScd(payment.getCouponEventScd());
        saleOrderPay.setRowNo(Long.valueOf(payment.getRowno()));
        saleOrderPay.setBatchNo(payment.getBatchNo());
        saleOrderPay.setTrace(payment.getTrace());
        saleOrderPay.setConsumersId(CastUtil.castLong(payment.getConsumersId()));
        saleOrderPay.setCouponIsClass(payment.getCouponIsCash());
        saleOrderPay.setRowNoId(payment.getRownoId());
        saleOrderPay.setDxtype(payment.getDxtype());
        saleOrderPay.setCashCost(BigDecimal.valueOf(payment.getCashCost()));
        saleOrderPay.setRoundUpOverageValue(BigDecimal.valueOf(payment.getRoundUpOverageValue()));
        saleOrderPay.setExpiryDate(payment.getExpiryDate());
        saleOrderPay.setInstallmentTerms(payment.getInstallmentTerms());
        saleOrderPay.setFirstInstallmentAmount(BigDecimal.valueOf(payment.getFirstInstallmentAmount()));
        saleOrderPay.setFirstPaymentDueDate(payment.getFirstPaymentDueDate());
        saleOrderPay.setFinalPyamentDueDate(payment.getFinalPyamentDueDate());
        saleOrderPay.setPosEntryMode(payment.getPosEntryMode());
        saleOrderPay.setDeliveryMemoNumber(payment.getDeliveryMemoNumber());
        saleOrderPay.setTrackData(payment.getTrackData());
        saleOrderPay.setDescription(payment.getDescription());
        saleOrderPay.setMonthlyInstallment(BigDecimal.valueOf(payment.getMonthlyInstallment()));
        saleOrderPay.setMerchantDiscountValue(BigDecimal.valueOf(payment.getMerchantDiscountValue()));
        saleOrderPay.setPayChannelDiscountValue(BigDecimal.valueOf(payment.getPayChannelDiscountValue()));
        saleOrderPay.setDiscountValue(BigDecimal.valueOf(payment.getDiscountValue()));
        if (null != payment.getBankName() && payment.getBankName().length() > 0) {
            saleOrderPay.setPayName(payment.getBankName());
        }
        if (null != payment.getBankType() && payment.getBankType().length() > 0) {
            saleOrderPay.setPayMemo(payment.getBankType());
        }
        if (StringUtils.isBlank((String)saleOrderPay.getPayMemo())) {
            saleOrderPay.setPayMemo(payment.getMemo());
        }
        saleOrderPay.setPopPayMemo(payment.getPopPayMemo());
        saleOrderPay.setInvoiceFlag(payment.getInvoiceFlag() ? 1 : 0);
        if (null != payment.getAppType()) {
            saleOrderPay.setAppType(payment.getAppType());
        }
        if (StringUtils.isNotBlank((String)payment.getExtMemo())) {
            saleOrderPay.setExtMemo(payment.getExtMemo());
        }
        saleOrderPay.setCusName(payment.getCusName());
        return saleOrderPay;
    }

    @Override
    public SellPayment transferSellPayment(Payment payment) {
        SellPayment sellPayment = new SellPayment();
        sellPayment.setRowNo(payment.getRowno());
        if (StringUtils.isNotBlank((String)payment.getPopFlag())) {
            sellPayment.setFlag(payment.getPopFlag());
        } else {
            sellPayment.setFlag("2");
        }
        sellPayment.setPayType(payment.getPayType());
        if (StringUtils.isNotBlank((String)payment.getCopType())) {
            sellPayment.setPayType(payment.getCopType());
        }
        sellPayment.setPaycode(payment.getPayCode());
        sellPayment.setPayName(payment.getPayName());
        sellPayment.setCopType(payment.getCouponType());
        if (null != payment.getPayNo() && payment.getPayNo().length() > 100) {
            sellPayment.setPayNo(payment.getPayNo().substring(0, 100));
        } else {
            sellPayment.setPayNo(payment.getPayNo());
        }
        sellPayment.setPayMemo(payment.getMemo());
        sellPayment.setRate(payment.getRate());
        sellPayment.setAmount(payment.getAmount());
        sellPayment.setMoney(payment.getMoney());
        sellPayment.setOverage(payment.getOverage());
        sellPayment.setConsumersId(payment.getConsumersId());
        sellPayment.setCouponGroup(payment.getCouponGroup());
        sellPayment.setCouponEventScd(payment.getCouponEventScd());
        sellPayment.setCouponEventId(payment.getCouponEventId());
        sellPayment.setCouponPolicyId(payment.getCouponPolicyId());
        sellPayment.setCouponMutex(payment.getCouponMutex());
        sellPayment.setCouponPayToken(payment.getCouponPayToken());
        sellPayment.setCouponTraceSeqNo(payment.getCouponTraceSeqno());
        sellPayment.setCouponBalance(payment.getCouponBalance());
        sellPayment.setOverPay(payment.getOverPay());
        sellPayment.setCouponIsCash(payment.getCouponIsCash());
        sellPayment.setCashCost(payment.getCashCost());
        if (StringUtils.isEmpty((String)payment.getRownoId())) {
            sellPayment.setRowNoId(payment.getPuid());
        } else {
            sellPayment.setRowNoId(payment.getRownoId());
        }
        sellPayment.setDxtype(payment.getDxtype());
        sellPayment.setRemainCharge(payment.getRemainCharge());
        sellPayment.setAlreadyAllot(payment.getAlreadyAllot());
        if ("05".equals(sellPayment.getCouponGroup())) {
            sellPayment.setPayMoney(sellPayment.getMoney());
            sellPayment.setAmount(payment.getYcouponAmount());
        }
        return sellPayment;
    }

    @Override
    public Payment SellPaymentToPayment(SellPayment s, Payment p) {
        BeanUtils.copyProperties((Object)s, (Object)p);
        p.setRowno(s.getRowNo());
        p.setFlag(DataExchageUtils.getSalePayFlag(s.getFlag()));
        p.setPopFlag(s.getFlag());
        p.setPayType(s.getPayType());
        p.setPayCode(s.getPaycode());
        p.setPayName(s.getPayName());
        p.setCouponType(s.getCopType());
        if (StringUtils.isBlank((String)p.getPrecision())) {
            p.setPrecision("0");
        }
        if (StringUtils.isBlank((String)p.getPrcutMode())) {
            p.setPrcutMode("0");
        }
        p.setPayNo(s.getPayNo());
        p.setMemo(s.getPayMemo());
        p.setRate(s.getRate());
        if ("05".equals(s.getCouponGroup())) {
            p.setAmount(s.getPayMoney());
            p.setMoney(s.getPayMoney());
        } else {
            p.setAmount(s.getAmount());
            p.setMoney(s.getMoney());
        }
        p.setOverage(s.getOverage());
        p.setConsumersId(s.getConsumersId());
        p.setCouponGroup(s.getCouponGroup());
        p.setCouponEventScd(s.getCouponEventScd());
        p.setCouponEventId(s.getCouponEventId());
        p.setCouponPolicyId(s.getCouponPolicyId());
        p.setCouponMutex(s.getCouponMutex());
        p.setCouponPayToken(s.getCouponPayToken());
        p.setCouponTraceSeqno(s.getCouponTraceSeqNo());
        p.setOverPay(s.getOverPay());
        p.setCouponIsCash(s.getCouponIsCash());
        p.setCashCost(s.getCashCost());
        p.setRownoId(s.getRowNoId());
        p.setRemainCharge(s.getRemainCharge());
        p.setDxtype(s.getDxtype());
        p.setAlreadyAllot(s.getAlreadyAllot());
        p.setBillrate(s.getBillrate());
        p.setInstallmentTerms(s.getBillrate());
        if (s.getPayType().equals("BATCH")) {
            p.setBatchNo(s.getPayNo());
        }
        if ("05".equals(p.getCouponGroup())) {
            p.setYcouponAmount(s.getAmount());
        }
        if (null == p.getPayName()) {
            p.setPayName("");
        }
        return p;
    }

    @Override
    public OrdersPayModel transferOrdersPayModel(Payment payment) {
        OrdersPayModel saleOrderPay = new OrdersPayModel();
        saleOrderPay.setCouponEventId(payment.getCouponEventId());
        saleOrderPay.setMoney(BigDecimal.valueOf(payment.getMoney()));
        saleOrderPay.setRate(payment.getRate());
        saleOrderPay.setCopType(payment.getCouponType());
        saleOrderPay.setPayName(payment.getPayName());
        saleOrderPay.setMerchantId(payment.getMisMerchantId());
        saleOrderPay.setTerminalId(payment.getMisTerminalId());
        saleOrderPay.setPayMemo(payment.getPayMemo());
        saleOrderPay.setOverage(BigDecimal.valueOf(payment.getOverage()));
        saleOrderPay.setCouponPolicyId(payment.getCouponPolicyId());
        saleOrderPay.setPayType(payment.getPayType());
        saleOrderPay.setCouponTraceSeqno("" + payment.getCouponTraceSeqno());
        saleOrderPay.setFlag(CastUtil.castInt(payment.getFlag()));
        saleOrderPay.setCouponGroup(payment.getCouponGroup());
        saleOrderPay.setCouponBalance(BigDecimal.valueOf(payment.getCouponBalance()));
        saleOrderPay.setPayCode(payment.getPayCode());
        saleOrderPay.setAmount(BigDecimal.valueOf(payment.getAmount()));
        saleOrderPay.setDiscountValue(BigDecimal.valueOf(payment.getDiscountValue()));
        saleOrderPay.setPayChannelDiscountValue(BigDecimal.valueOf(payment.getPayChannelDiscountValue()));
        saleOrderPay.setMerchantDiscountValue(BigDecimal.valueOf(payment.getMerchantDiscountValue()));
        saleOrderPay.setInvoiceFlag(payment.getInvoiceFlag() ? 1 : 0);
        if (null != payment.getPayNo() && payment.getPayNo().length() > 100) {
            saleOrderPay.setPayNo(payment.getPayNo().substring(0, 100));
        } else {
            saleOrderPay.setPayNo(payment.getPayNo());
        }
        if (null != payment.getRefCode() && payment.getRefCode().length() > 100) {
            saleOrderPay.setRefCode(payment.getRefCode().substring(0, 100));
        } else {
            saleOrderPay.setRefCode(payment.getRefCode());
        }
        if (null != payment.getAuthCode() && payment.getAuthCode().length() > 100) {
            saleOrderPay.setAuthCode(payment.getAuthCode().substring(0, 100));
        } else {
            saleOrderPay.setAuthCode(payment.getAuthCode());
        }
        if (null != payment.getOriginSheetNo()) {
            saleOrderPay.setOriginSheetNo(payment.getOriginSheetNo());
        }
        saleOrderPay.setCouponEventScd(payment.getCouponEventScd());
        saleOrderPay.setRowNo(Long.valueOf(payment.getRowno()));
        saleOrderPay.setBatchNo(payment.getBatchNo());
        saleOrderPay.setTrace(payment.getTrace());
        saleOrderPay.setConsumersId(CastUtil.castLong(payment.getConsumersId()));
        saleOrderPay.setCouponIsClass(payment.getCouponIsCash());
        saleOrderPay.setDxtype(payment.getDxtype());
        saleOrderPay.setCashCost(BigDecimal.valueOf(payment.getCashCost()));
        saleOrderPay.setRoundUpOverageValue(BigDecimal.valueOf(payment.getRoundUpOverageValue()));
        saleOrderPay.setExpiryDate(payment.getExpiryDate());
        saleOrderPay.setInstallmentTerms(payment.getInstallmentTerms());
        saleOrderPay.setFirstInstallmentAmount(BigDecimal.valueOf(payment.getFirstInstallmentAmount()));
        saleOrderPay.setFirstPaymentDueDate(payment.getFirstPaymentDueDate());
        saleOrderPay.setFinalPyamentDueDate(payment.getFinalPyamentDueDate());
        saleOrderPay.setPosEntryMode(payment.getPosEntryMode());
        saleOrderPay.setDeliveryMemoNumber(payment.getDeliveryMemoNumber());
        saleOrderPay.setTrackData(payment.getTrackData());
        saleOrderPay.setDescription(payment.getDescription());
        saleOrderPay.setMonthlyInstallment(BigDecimal.valueOf(payment.getMonthlyInstallment()));
        if (null != payment.getBankName() && payment.getBankName().length() > 0) {
            saleOrderPay.setPayName(payment.getBankName());
        }
        if (null != payment.getBankType() && payment.getBankType().length() > 0) {
            saleOrderPay.setPayMemo(payment.getBankType());
        }
        return saleOrderPay;
    }

    @Override
    public Payment transferPayment2(OrdersPayModel saleOrderPay) {
        Payment p = new Payment();
        p.setPuid(String.valueOf(UniqueID.getUniqueID()));
        p.setRownoId(p.getPuid());
        return this.SaleOrderPayToPayment(saleOrderPay, p);
    }

    @Override
    public Payment SaleOrderPayToPayment(OrdersPayModel saleOrderPay, Payment p) {
        p.setCouponEventId(saleOrderPay.getCouponEventId());
        p.setMoney(CastUtil.castDouble(saleOrderPay.getMoney()));
        p.setRate(saleOrderPay.getRate());
        p.setCouponType(saleOrderPay.getCopType());
        p.setPayName(saleOrderPay.getPayName());
        p.setMisMerchantId(saleOrderPay.getMerchantId());
        p.setPayMemo(saleOrderPay.getPayMemo());
        p.setOverage(CastUtil.castDouble(saleOrderPay.getOverage()));
        p.setCouponPolicyId(saleOrderPay.getCouponPolicyId());
        p.setPayType(saleOrderPay.getPayType());
        p.setCouponTraceSeqno(CastUtil.castLong(saleOrderPay.getCouponTraceSeqno()));
        p.setFlag(String.valueOf(saleOrderPay.getFlag()));
        p.setCouponGroup(saleOrderPay.getCouponGroup());
        p.setCouponBalance(CastUtil.castDouble(saleOrderPay.getCouponBalance()));
        p.setPayCode(saleOrderPay.getPayCode());
        p.setAmount(CastUtil.castDouble(saleOrderPay.getAmount()));
        p.setPayNo(saleOrderPay.getPayNo());
        p.setCouponEventScd(saleOrderPay.getCouponEventScd());
        p.setRowno(saleOrderPay.getRowNo().intValue());
        p.setBatchNo(saleOrderPay.getBatchNo());
        p.setRefCode(saleOrderPay.getRefCode());
        p.setTrace(saleOrderPay.getTrace());
        p.setConsumersId(String.valueOf(saleOrderPay.getConsumersId()));
        p.setCouponIsCash(saleOrderPay.getCouponIsClass());
        p.setDxtype(saleOrderPay.getDxtype());
        p.setCashCost(CastUtil.castDouble(saleOrderPay.getCashCost()));
        p.setMisTerminalId(saleOrderPay.getTerminalId());
        p.setBatchNo(saleOrderPay.getBatchNo());
        p.setAuthCode(saleOrderPay.getAuthCode());
        p.setCouponType(saleOrderPay.getCopType());
        p.setRoundUpOverageValue(CastUtil.castDouble(saleOrderPay.getRoundUpOverageValue()));
        p.setOverPay(0.0);
        p.setExpiryDate(saleOrderPay.getExpiryDate());
        p.setInstallmentTerms(saleOrderPay.getInstallmentTerms());
        p.setFirstInstallmentAmount(CastUtil.castDouble(saleOrderPay.getFirstInstallmentAmount()));
        p.setFirstPaymentDueDate(saleOrderPay.getFirstPaymentDueDate());
        p.setFinalPyamentDueDate(saleOrderPay.getFinalPyamentDueDate());
        p.setPosEntryMode(saleOrderPay.getPosEntryMode());
        p.setDeliveryMemoNumber(saleOrderPay.getDeliveryMemoNumber());
        p.setTrackData(saleOrderPay.getTrackData());
        p.setDescription(saleOrderPay.getDescription());
        p.setMonthlyInstallment(CastUtil.castDouble(saleOrderPay.getMonthlyInstallment()));
        p.setMerchantDiscountValue(CastUtil.castDouble(saleOrderPay.getMerchantDiscountValue()));
        p.setDiscountValue(CastUtil.castDouble(saleOrderPay.getDiscountValue()));
        p.setPayChannelDiscountValue(CastUtil.castDouble(saleOrderPay.getPayChannelDiscountValue()));
        p.setMemo(saleOrderPay.getPayMemo());
        return p;
    }

    @Override
    public List<SellPayment> transferSellPayment(List<Payment> payments, boolean isBack) {
        if (payments == null || payments.size() == 0) {
            return null;
        }
        ArrayList<SellPayment> sellPayments = new ArrayList<SellPayment>();
        boolean needMinus = false;
        for (int i = 0; i < payments.size(); ++i) {
            Payment payment = payments.get(i);
            if (payment.getMerchantDiscountValue() > 0.0 || payment.getPayChannelDiscountValue() > 0.0) {
                Payment p = (Payment)payment.clone();
                p.setAmount(ManipulatePrecision.doubleConvert(p.getMoney() - p.getMerchantDiscountValue() - p.getPayChannelDiscountValue()));
                p.setMoney(p.getAmount());
                p.setRate(1.0);
                SellPayment sellPayment = this.transferSellPayment(p);
                sellPayments.add(sellPayment);
                if (payment.getMerchantDiscountValue() > 0.0) {
                    p.setAmount(p.getMerchantDiscountValue());
                    p.setMoney(p.getAmount());
                    p.setRate(1.0);
                    p.setCouponType("MERCHANTDISCOUNT");
                    p.setPuid(p.getPuid() + "1");
                    p.setRownoId(p.getRownoId() + "1");
                    p.setRowno(payments.size() + 1);
                    sellPayment = this.transferSellPayment(p);
                    sellPayments.add(sellPayment);
                }
                if (!(payment.getPayChannelDiscountValue() > 0.0)) continue;
                p.setAmount(p.getPayChannelDiscountValue());
                p.setMoney(p.getAmount());
                p.setRate(1.0);
                p.setCouponType("PLATFORMDISCOUNT");
                p.setPuid(p.getPuid() + "2");
                p.setRownoId(p.getRownoId() + "2");
                p.setRowno(payments.size() + 2);
                sellPayment = this.transferSellPayment(p);
                sellPayments.add(sellPayment);
                continue;
            }
            if (!"2".equals(payment.getFlag())) {
                SellPayment sellPayment = this.transferSellPayment(payment);
                if (needMinus) {
                    sellPayment.setAmount(ManipulatePrecision.doubleConvert(sellPayment.getAmount() - payments.get(i - 1).getAmount()));
                    sellPayment.setMoney(ManipulatePrecision.doubleConvert(sellPayment.getMoney() - payments.get(i - 1).getMoney()));
                    needMinus = false;
                }
                sellPayments.add(sellPayment);
                continue;
            }
            needMinus = true;
        }
        return sellPayments;
    }

    @Override
    public List<SellPayment> transferSellPaymentForReturn(CacheModel cacheModel) {
        Payment paymentTemp;
        int j;
        SellPayment sellPayment;
        if (null == cacheModel) {
            return null;
        }
        if (null == cacheModel.getOrder()) {
            return null;
        }
        ArrayList<SellPayment> sellPayments = new ArrayList<SellPayment>();
        int reverseCouponsRowNo = -1;
        if (null != cacheModel.getReverseCoupons() && cacheModel.getReverseCoupons().size() > 0) {
            reverseCouponsRowNo = cacheModel.getReverseCoupons().get(0).getRowno();
        }
        for (int i = 0; i < cacheModel.getPayments().size(); ++i) {
            Payment payment = cacheModel.getPayments().get(i);
            if (reverseCouponsRowNo > 0 && i == reverseCouponsRowNo - 1) {
                for (int j2 = 0; j2 < cacheModel.getReverseCoupons().size(); ++j2) {
                    Payment paymentTemp2 = cacheModel.getReverseCoupons().get(j2);
                    SellPayment sellPayment2 = this.transferSellPayment(paymentTemp2);
                    sellPayments.add(sellPayment2);
                }
                reverseCouponsRowNo = -1;
            }
            sellPayment = this.transferSellPayment(payment);
            sellPayments.add(sellPayment);
        }
        if (reverseCouponsRowNo > 0) {
            for (j = 0; j < cacheModel.getReverseCoupons().size(); ++j) {
                paymentTemp = cacheModel.getReverseCoupons().get(j);
                sellPayment = this.transferSellPayment(paymentTemp);
                sellPayments.add(sellPayment);
            }
            reverseCouponsRowNo = -1;
        }
        if (cacheModel.getTempSalePayments().size() > 0) {
            for (j = 0; j < cacheModel.getTempSalePayments().size(); ++j) {
                paymentTemp = cacheModel.getTempSalePayments().get(j);
                sellPayment = this.transferSellPayment(paymentTemp);
                sellPayments.add(sellPayment);
            }
        }
        return sellPayments;
    }

    @Override
    public Payment transferPayment(SellPayment s) {
        Payment p = new Payment();
        p.setPuid(String.valueOf(UniqueID.getUniqueID()));
        return this.SellPaymentToPayment(s, p);
    }

    @Override
    public List<Payment> transferPayment(List<SellPayment> sellPayments) {
        return this.transferPayment(sellPayments, false);
    }

    @Override
    public List<Payment> transferPayment(List<SellPayment> sellPayments, boolean isPay) {
        if (sellPayments == null || sellPayments.size() == 0) {
            return null;
        }
        ArrayList<Payment> payments = new ArrayList<Payment>();
        log.info("isPay:" + isPay);
        for (SellPayment sellPayment : sellPayments) {
            Payment payment = this.transferPayment(sellPayment);
            log.info("payment.getCouponGroup():" + payment.getCouponGroup());
            if ("05".equals(payment.getCouponGroup())) {
                payment.setYcouponAmount(sellPayment.getAmount());
                if (isPay) {
                    payment.setMoney(sellPayment.getPayMoney());
                    payment.setAmount(sellPayment.getPayMoney());
                    payment.setRate(1.0);
                } else {
                    payment.setMoney(sellPayment.getAmount());
                    payment.setAmount(sellPayment.getAmount());
                    payment.setRate(1.0);
                }
            }
            payments.add(payment);
        }
        log.info("payments====\u300b" + JSONObject.toJSONString(payments));
        return payments;
    }

    @Override
    public List<PaymentForPos> transferPosPaymentList(List<Payment> payments) {
        if (payments == null || payments.size() == 0) {
            return new ArrayList<PaymentForPos>(1);
        }
        ArrayList<PaymentForPos> paymentsForPos = new ArrayList<PaymentForPos>();
        for (Payment payment : payments) {
            PaymentForPos paymentForPos = new PaymentForPos();
            BeanCopierUtils.copyProperties(payment, paymentForPos);
            paymentsForPos.add(paymentForPos);
        }
        return paymentsForPos;
    }

    @Override
    public List<OrdersPayModel> transferOrdersPayModel(List<Payment> payments) {
        if (payments == null || payments.size() == 0) {
            return null;
        }
        ArrayList<OrdersPayModel> saleOrderPays = new ArrayList<OrdersPayModel>();
        for (Payment payment : payments) {
            OrdersPayModel saleOrderPay = this.transferOrdersPayModel(payment);
            saleOrderPays.add(saleOrderPay);
        }
        return saleOrderPays;
    }

    @Override
    public List<Payment> transferPayment3(List<SaleOrderPayModel> saleOrderPays) {
        if (saleOrderPays == null || saleOrderPays.size() == 0) {
            return null;
        }
        ArrayList<Payment> payments = new ArrayList<Payment>();
        for (SaleOrderPayModel saleOrderPay : saleOrderPays) {
            Payment payment = this.transferPayment2(saleOrderPay);
            payments.add(payment);
        }
        return payments;
    }

    @Override
    public Payment transferPayment2(SaleOrderPayModel saleOrderPay) {
        Payment p = new Payment();
        p.setPuid(String.valueOf(UniqueID.getUniqueID()));
        return this.SaleOrderPayToPayment(saleOrderPay, p);
    }

    @Override
    public List<PaymentForPos> transferPaymentsToPosPaymentsList(List<Payment> pays) {
        ArrayList<PaymentForPos> list = new ArrayList<PaymentForPos>();
        for (Payment pay : pays) {
            list.add(this.transferPaymentsToPosPaymentsList(pay));
        }
        return list;
    }

    @Override
    public PaymentForPos transferPaymentsToPosPaymentsList(Payment pay) {
        PaymentForPos ofp = new PaymentForPos();
        BeanCopierUtils.copyProperties(pay, ofp);
        if (StringUtils.isBlank((String)ofp.getPayNo()) && StringUtils.isNotBlank((String)pay.getConsumersId()) && !"JFXF".equals(pay.getCopType())) {
            ofp.setPayNo(pay.getConsumersId());
        }
        return ofp;
    }

    @Override
    public Payment SaleOrderPayToPayment(SaleOrderPayModel saleOrderPay, Payment p) {
        p.setCouponEventId(saleOrderPay.getCouponEventId());
        p.setMoney(CastUtil.castDouble(saleOrderPay.getMoney()));
        p.setRate(saleOrderPay.getRate());
        p.setCopType(saleOrderPay.getCopType());
        p.setPayName(saleOrderPay.getPayName());
        p.setMisMerchantId(saleOrderPay.getMerchantId());
        p.setPayMemo(saleOrderPay.getPayMemo());
        p.setOverage(CastUtil.castDouble(saleOrderPay.getOverage()));
        p.setCouponPolicyId(saleOrderPay.getCouponPolicyId());
        p.setPayType(saleOrderPay.getPayType());
        p.setCouponTraceSeqno(CastUtil.castLong(saleOrderPay.getCouponTraceSeqno()));
        p.setFlag(String.valueOf(saleOrderPay.getFlag()));
        p.setCouponGroup(saleOrderPay.getCouponGroup());
        p.setCouponBalance(CastUtil.castDouble(saleOrderPay.getCouponBalance()));
        p.setPayCode(saleOrderPay.getPayCode());
        p.setAmount(CastUtil.castDouble(saleOrderPay.getAmount()));
        p.setPayNo(saleOrderPay.getPayNo());
        p.setCouponEventScd(saleOrderPay.getCouponEventScd());
        p.setRowno(saleOrderPay.getRowNo().intValue());
        p.setBatchNo(saleOrderPay.getBatchNo());
        p.setRefCode(saleOrderPay.getRefCode());
        p.setTrace(saleOrderPay.getTrace());
        p.setConsumersId(String.valueOf(saleOrderPay.getConsumersId()));
        p.setCouponIsCash(saleOrderPay.getCouponIsClass());
        p.setDxtype(saleOrderPay.getDxtype());
        p.setCashCost(CastUtil.castDouble(saleOrderPay.getCashCost()));
        p.setMisTerminalId(saleOrderPay.getTerminalId());
        p.setBatchNo(saleOrderPay.getBatchNo());
        p.setAuthCode(saleOrderPay.getAuthCode());
        p.setCouponType(saleOrderPay.getCopType());
        p.setRoundUpOverageValue(CastUtil.castDouble(saleOrderPay.getRoundUpOverageValue()));
        p.setOverPay(0.0);
        p.setExpiryDate(saleOrderPay.getExpiryDate());
        p.setInstallmentTerms(saleOrderPay.getInstallmentTerms());
        p.setFirstInstallmentAmount(CastUtil.castDouble(saleOrderPay.getFirstInstallmentAmount()));
        p.setFirstPaymentDueDate(saleOrderPay.getFirstPaymentDueDate());
        p.setFinalPyamentDueDate(saleOrderPay.getFinalPyamentDueDate());
        p.setPosEntryMode(saleOrderPay.getPosEntryMode());
        p.setDeliveryMemoNumber(saleOrderPay.getDeliveryMemoNumber());
        p.setTrackData(saleOrderPay.getTrackData());
        p.setDescription(saleOrderPay.getDescription());
        p.setMonthlyInstallment(CastUtil.castDouble(saleOrderPay.getMonthlyInstallment()));
        return p;
    }

    @Override
    public ExceptPay transferExceptPay(SellExceptPay sellExceptPay) {
        ExceptPay pay = new ExceptPay();
        pay.setMode(sellExceptPay.getMode());
        pay.setDescribe(sellExceptPay.getDescribe());
        pay.setPopMode(sellExceptPay.getPopMode());
        pay.setPopzkl(sellExceptPay.getPopZkl());
        pay.setPayType(sellExceptPay.getPayType());
        pay.setPayCode(sellExceptPay.getPayCode());
        pay.setPayName(sellExceptPay.getPayName());
        pay.setCopType(sellExceptPay.getCopType());
        pay.setEventId(sellExceptPay.getEventId());
        pay.setPolicyId(sellExceptPay.getPolicyId());
        pay.setCrdLocation(sellExceptPay.getCrdLocation());
        pay.setCrdLength(sellExceptPay.getCrdLength());
        pay.setCrdBegin(sellExceptPay.getCrdBegin());
        pay.setCrdEnd(sellExceptPay.getCrdEnd());
        pay.setMemo(sellExceptPay.getMemo());
        return pay;
    }

    @Override
    public ExceptPayForPos transferExceptPayForPos(ExceptPay exceptPay) {
        ExceptPayForPos pay = new ExceptPayForPos();
        pay.setMode(exceptPay.getMode());
        pay.setDescribe(exceptPay.getDescribe());
        pay.setPopMode(exceptPay.getPopMode());
        pay.setPopzkl(exceptPay.getPopzkl());
        pay.setPayType(exceptPay.getPayType());
        pay.setPayCode(exceptPay.getPayCode());
        pay.setPayName(exceptPay.getPayName());
        pay.setCopType(exceptPay.getCopType());
        pay.setEventId(exceptPay.getEventId());
        pay.setPolicyId(exceptPay.getPolicyId());
        YpopCrdInfo crdInfo = new YpopCrdInfo();
        crdInfo.setCrdLocation(exceptPay.getCrdLocation());
        crdInfo.setCrdLength(exceptPay.getCrdLength());
        crdInfo.setCrdBegin(exceptPay.getCrdBegin());
        crdInfo.setCrdEnd(exceptPay.getCrdEnd());
        crdInfo.setMemo(exceptPay.getMemo());
        pay.setCrdInfo(new ArrayList<YpopCrdInfo>());
        pay.getCrdInfo().add(crdInfo);
        return pay;
    }

    @Override
    public YpopCrdInfo transferYpopCrdInfo(ExceptPay exceptPay) {
        YpopCrdInfo crdInfo = new YpopCrdInfo();
        crdInfo.setCrdLocation(exceptPay.getCrdLocation());
        crdInfo.setCrdLength(exceptPay.getCrdLength());
        crdInfo.setCrdBegin(exceptPay.getCrdBegin());
        crdInfo.setCrdEnd(exceptPay.getCrdEnd());
        crdInfo.setMemo(exceptPay.getMemo());
        return crdInfo;
    }

    @Override
    public List<ExceptPayForPos> transferExceptPayForPosList(List<ExceptPay> exceptPays) {
        ArrayList<ExceptPayForPos> exceptPayForPosList = new ArrayList<ExceptPayForPos>();
        for (ExceptPay pay : exceptPays) {
            boolean isAdd = false;
            for (ExceptPayForPos payForPos : exceptPayForPosList) {
                if (pay.getEventId() != payForPos.getEventId() || !pay.getPayCode().equals(payForPos.getPayCode())) continue;
                payForPos.getCrdInfo().add(this.transferYpopCrdInfo(pay));
                isAdd = true;
                break;
            }
            if (isAdd) continue;
            exceptPayForPosList.add(this.transferExceptPayForPos(pay));
        }
        return exceptPayForPosList;
    }

    @Override
    public AddQrCodeOut transferToAddQrCodeOut(List<SellPayment> sellPayments, List<SellCoupon> couponUses, boolean isPay) {
        AddQrCodeOut addQrCodeOut = new AddQrCodeOut();
        addQrCodeOut.setSellPayment(this.transferPayment(sellPayments, isPay));
        addQrCodeOut.setSellCoupon(this.couponTransfer.transferCoupon(couponUses));
        return addQrCodeOut;
    }
}

