/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.javaPos.commonkit.beantransfer.localize;

import com.efuture.business.bean.SellType;
import com.efuture.business.bean.YPopStatusType;
import com.efuture.business.javaPos.commonkit.Convert;
import com.efuture.business.javaPos.commonkit.CountZZK;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.javaPos.commonkit.ManipulateStr;
import com.efuture.business.javaPos.commonkit.beantransfer.GoodsTransferImpl;
import com.efuture.business.javaPos.struct.CouponGain;
import com.efuture.business.javaPos.struct.CouponUse;
import com.efuture.business.javaPos.struct.Goods;
import com.efuture.business.javaPos.struct.Order;
import com.efuture.business.javaPos.struct.PopDetail;
import com.efuture.business.javaPos.struct.mainDataCentre.CategoryProperty;
import com.efuture.business.javaPos.struct.mainDataCentre.GoodsInfo;
import com.efuture.business.javaPos.struct.promotionCentre.SellCouponGain;
import com.efuture.business.javaPos.struct.promotionCentre.SellCouponUse;
import com.efuture.business.javaPos.struct.promotionCentre.SellDetail;
import com.efuture.business.javaPos.struct.promotionCentre.SellPopDetail;
import com.efuture.business.util.DataExchageUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class GoodsTransferImpl_SJGW
extends GoodsTransferImpl {
    private static final Logger log = LoggerFactory.getLogger(GoodsTransferImpl_SJGW.class);

    @Override
    public List<Goods> combineToTop(List<Goods> goods, String hhguid) {
        int index = 0;
        if (StringUtils.isNotEmpty((String)hhguid)) {
            int i;
            for (i = 0; i < goods.size(); ++i) {
                if (!hhguid.equals(goods.get(i).getGuid())) continue;
                index = i;
            }
            Collections.swap(goods, index, goods.size() - 1);
            for (i = 0; i < goods.size(); ++i) {
                goods.get(i).setFlowId(i + 1);
            }
        }
        return goods;
    }

    @Override
    public SellDetail transferSellDetail(Goods goods, Order order, boolean isRemoveAdjustDisc, boolean isNewCalcId, boolean isNeedPopDetail, boolean isPrecision) {
        goods.setTempPopDetails(new ArrayList<PopDetail>());
        SellDetail sellDetail = new SellDetail();
        sellDetail.setRowNo(goods.getFlowId());
        sellDetail.setFlag(goods.getFlag());
        if (StringUtils.isNotBlank((String)goods.getSGoodsSno())) {
            sellDetail.setFlag("3");
        }
        sellDetail.setKlm(goods.getSeason());
        sellDetail.setOriginalBillNo(order.getOriginSeqNo());
        if (goods.getOriginalFlowId() != null) {
            sellDetail.setOriginalRowNo(goods.getOriginalFlowId());
        }
        log.info(">>>>>>>>>>sellDetail.setOriginalRowNo==>{}", (Object)sellDetail.getOriginalRowNo());
        sellDetail.setGz(goods.getOrgCode());
        sellDetail.setMarket(order.getShopCode());
        sellDetail.setContract(goods.getContractCode());
        sellDetail.setItemCode(goods.getGoodsCode());
        sellDetail.setItemName(goods.getGoodsName());
        sellDetail.setBarcode(goods.getBarNo());
        sellDetail.setUnitcode(goods.getGoodsUid());
        sellDetail.setFactor(goods.getPartsNum());
        sellDetail.setBrand(goods.getBrandCode());
        sellDetail.setCategory(goods.getCategoryCode());
        sellDetail.setQty(goods.getQty());
        sellDetail.setPrice(goods.getSalePrice());
        sellDetail.setListAmount(goods.getSaleValue());
        sellDetail.setTotalDiscount(goods.getTotalDiscountValue());
        sellDetail.setSaleAmount(goods.getSaleAmount());
        sellDetail.setNojf(goods.getNojf());
        sellDetail.setManaUnit(order.getErpCode());
        sellDetail.setCounter(goods.getSeason());
        sellDetail.setSupplier(goods.getVenderCode());
        sellDetail.setQtyrecalc(goods.getQtyrecalc());
        if (!isNewCalcId) {
            sellDetail.setQtyrecalcAmount(goods.getQtyrecalcAmount());
            sellDetail.setQtyrecalcEvtid(goods.getQtyrecalcEvtid());
        }
        if (goods.getIsNoBackGift()) {
            sellDetail.setPopTag("Y");
            sellDetail.setFlag("0");
        }
        if (StringUtils.isNotBlank((String)order.getStaffCardNo())) {
            sellDetail.setPopTag("S");
        }
        if ("32".equals(goods.getGoodsType())) {
            sellDetail.setPopTag("M");
        }
        if (order.getHasGroupBuy()) {
            sellDetail.setPopTag("G");
        }
        if ("YS1".equals(order.getOrderType())) {
            sellDetail.setPopTag("PRESALE");
        }
        if (StringUtils.isNotBlank((String)goods.getDiscountFlag()) && ("0".equals(goods.getDiscountFlag()) || "1".equals(goods.getDiscountFlag()))) {
            sellDetail.setPopTag(goods.getDiscountFlag());
        }
        if (SellType.NOPOP(order.getOrderType())) {
            sellDetail.setFlag("Z");
        }
        if ("Z1".equals(order.getOrderType()) || "Z2".equals(order.getOrderType())) {
            sellDetail.setFlag("J");
        }
        if (3 == order.getPopMode()) {
            sellDetail.setFlag("J");
        }
        if (4 == order.getPopMode()) {
            sellDetail.setFlag("Z");
        }
        if (null != order.getConsumersData() && "MOHO".equals(order.getConsumersData().getConsumersType())) {
            sellDetail.setFlag("Z");
        }
        if ("Y".equals(goods.getEscaleFlag())) {
            if (0 == order.getSysPara().getYpopDzcMode()) {
                sellDetail.setFlag("1");
            }
            if (1 == order.getSysPara().getYpopDzcMode()) {
                sellDetail.setFlag("4");
            } else if (2 == order.getSysPara().getYpopDzcMode() || 3 == order.getSysPara().getYpopDzcMode()) {
                sellDetail.setFlag("1");
                if (goods.getEWCCodeAmount() > 0.0 && goods.getEWCCodeNum() <= 0.0) {
                    sellDetail.setFlag("E");
                    if (isNewCalcId) {
                        sellDetail.setQty(goods.getQuantityRecalc());
                        sellDetail.setSaleAmount(goods.getEWCCodeAmount());
                        sellDetail.setQtyrecalc(0);
                    }
                    if (ManipulatePrecision.doubleCompare(goods.getListPrice(), 0.0, 2) == 0) {
                        sellDetail.setFlag("Y");
                    }
                } else if (goods.getEWCCodeAmount() > 0.0 && goods.getEWCCodeNum() > 0.0) {
                    sellDetail.setFlag("5");
                    sellDetail.setQty(goods.getEWCCodeNum());
                    sellDetail.setListAmount(goods.getEWCCodeAmount());
                    sellDetail.setPrice(goods.getListPrice());
                    sellDetail.setQtyrecalcAmount(goods.getEWCCodeAmount());
                    if (3 == order.getSysPara().getYpopDzcMode()) {
                        sellDetail.setIsdzc("P");
                        if (3 == order.getPopMode()) {
                            sellDetail.setIsdzc("Z");
                        }
                        if (ManipulatePrecision.doubleCompare(goods.getListPrice(), 0.0, 2) > 0) {
                            if (goods.getSalePrice() > goods.getListPrice()) {
                                sellDetail.setListAmount(ManipulatePrecision.doubleConvert(goods.getListPrice() * goods.getEWCCodeNum()));
                                sellDetail.setQtyrecalcAmount(sellDetail.getListAmount());
                            }
                        } else {
                            sellDetail.setPrice(goods.getSalePrice());
                        }
                    }
                }
            }
        }
        if (order.getPopMode() == 3) {
            sellDetail.setFlag("J");
        }
        if (StringUtils.isNotBlank((String)goods.getPopFlag()) && !"7".equals(goods.getFlag())) {
            sellDetail.setFlag(goods.getPopFlag());
        }
        if (SellType.NOPOP(order.getOrderType()) && !SellType.ISEXERCISE(order.getOrderType())) {
            sellDetail.setFlag("Z");
        }
        if (null != order.getConsumersData() && StringUtils.isNotBlank((String)order.getConsumersData().getLoginMode()) && "2".equals(order.getConsumersData().getLoginMode())) {
            sellDetail.setFlag("T");
        }
        boolean isSpecifyBack = false;
        boolean isHaveBarcodeDisc = false;
        if (SellType.ISBACK(order.getOrderType()) && StringUtils.isNotBlank((String)order.getOriginTerminalSno())) {
            isSpecifyBack = true;
        }
        if ("E".equals(sellDetail.getFlag()) && !isSpecifyBack && ManipulatePrecision.doubleCompare(order.getRemainValue(), 0.0, 2) > 0) {
            sellDetail.setListAmount(goods.getEWCCodeAmount());
        }
        if ("2".equals(goods.getGoodsType())) {
            sellDetail.setCounter(goods.getParentGoodsCode());
        }
        if (order.getStaffSale()) {
            if (goods.getTempZzkDiscount() == 0.0 && goods.getTempZzrDiscount() == 0.0 && goods.getTempZrDiscount() == 0.0 && goods.getTempZkDiscount() == 0.0) {
                sellDetail.setKlm("STAFF");
                goods.setKlm("STAFF");
            } else {
                goods.setKlm("");
            }
        } else {
            goods.setKlm("");
        }
        if (!isSpecifyBack) {
            if (null != goods.getPopDetailsInfo() && goods.getPopDetailsInfo().size() > 0) {
                if (null == sellDetail.getSellPopDetails()) {
                    sellDetail.setSellPopDetails(new ArrayList<SellPopDetail>());
                }
                for (PopDetail popDetail : goods.getPopDetailsInfo()) {
                    if (isRemoveAdjustDisc && YPopStatusType.pop_policy_group_grant_goods.equals(popDetail.getPopPolicyGroup())) continue;
                    if (YPopStatusType.pop_policy_group_barcode_discA.equals(popDetail.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_barcode_discB.equals(popDetail.getPopPolicyGroup())) {
                        if (isNewCalcId) {
                            // empty if block
                        }
                        isHaveBarcodeDisc = true;
                    } else if (isNewCalcId && !isNeedPopDetail) continue;
                    sellDetail.getSellPopDetails().add(this.popdetailTransfer.transferSellPopDetail(popDetail, order, goods));
                }
            }
        } else if (SellType.ISBACK(order.getOrderType()) && goods.getFlag().equals("0") && null != goods.getPopDetailsInfo() && goods.getPopDetailsInfo().size() > 0) {
            if (null == sellDetail.getSellPopDetails()) {
                sellDetail.setSellPopDetails(new ArrayList<SellPopDetail>());
            }
            for (PopDetail popDetail : goods.getPopDetailsInfo()) {
                sellDetail.getSellPopDetails().add(this.popdetailTransfer.transferSellPopDetail(popDetail, order, goods));
            }
        }
        if (null != goods.getOutCouponUses() && goods.getOutCouponUses().size() > 0) {
            if (null == sellDetail.getCouponUses()) {
                sellDetail.setCouponUses(new ArrayList<SellCouponUse>());
            }
            for (CouponUse couponUse : goods.getOutCouponUses()) {
                sellDetail.getCouponUses().add(this.couponTransfer.transferSellCouponUse(couponUse));
            }
        }
        if (ManipulatePrecision.doubleConvert(goods.getTotalDiscountValue() - goods.getPopDiscountValue(), 2, 1) > 0.0 || goods.getDisZkl() > 0.0) {
            if (null == sellDetail.getSellPopDetails()) {
                sellDetail.setSellPopDetails(new ArrayList<SellPopDetail>());
            }
            if (SellType.ISSALE(order.getOrderType()) || null == order.getOriginIdSheetNo() || order.getOriginIdSheetNo().equals("")) {
                SellPopDetail sellPopDetail;
                if (!isRemoveAdjustDisc) {
                    if (ManipulatePrecision.doubleCompare(goods.getTempZzkDiscount(), 0.0, 2) > 0) {
                        sellPopDetail = new SellPopDetail();
                        sellPopDetail.setPopEventBillId("0");
                        sellPopDetail.setDiscountAmount(ManipulatePrecision.doubleConvert(goods.getTempZzkDiscount(), 6, 1));
                        sellPopDetail.setPopMode("0");
                        sellPopDetail.setPopPolicyGroup(YPopStatusType.pop_policy_group_grant_order);
                        sellPopDetail.setPopDescribe("[" + order.getSysPara().getZpRateDes() + order.getTempZzk() + "%]");
                        sellPopDetail.setPopMemo("PRE:0");
                        if (StringUtils.isNotBlank((String)goods.getFdmode())) {
                            sellPopDetail.setPopMemo("fdmode:" + goods.getFdmode() + ",fdzkfd:" + goods.getFdzkfd());
                        }
                        sellPopDetail.setPopPolicyType(YPopStatusType.pop_type_order);
                        sellPopDetail.setRowNo(goods.getFlowId());
                        sellDetail.getSellPopDetails().add(sellPopDetail);
                    }
                    if (ManipulatePrecision.doubleCompare(goods.getTempZzrDiscount(), 0.0, 2) > 0) {
                        sellPopDetail = new SellPopDetail();
                        sellPopDetail.setPopEventBillId("0");
                        sellPopDetail.setDiscountAmount(ManipulatePrecision.doubleConvert(goods.getTempZzrDiscount(), 6, 1));
                        sellPopDetail.setPopMode("0");
                        sellPopDetail.setPopPolicyGroup(YPopStatusType.pop_policy_group_grant_order);
                        sellPopDetail.setPopDescribe("[" + order.getSysPara().getZpAmountDes() + "]");
                        sellPopDetail.setPopMemo("PRE:0");
                        if (StringUtils.isNotBlank((String)goods.getFdmode())) {
                            sellPopDetail.setPopMemo("fdmode:" + goods.getFdmode() + ",fdzkfd:" + goods.getFdzkfd());
                        }
                        sellPopDetail.setPopPolicyType(YPopStatusType.pop_type_order);
                        sellPopDetail.setRowNo(goods.getFlowId());
                        sellDetail.getSellPopDetails().add(sellPopDetail);
                    }
                } else {
                    String precisionMode = DataExchageUtils.exchangePrecisionMode(goods.getPrcutMode());
                    sellDetail.setTotalDiscount(ManipulatePrecision.getDetailOverFlow(sellDetail.getTotalDiscount() - goods.getTempZzkDiscount() - goods.getTempZzrDiscount(), precisionMode));
                    sellDetail.setSaleAmount(ManipulatePrecision.getDetailOverFlow(sellDetail.getSaleAmount() + goods.getTempZzkDiscount() + goods.getTempZzrDiscount(), goods.getPrcutMode()));
                    if (!"2".equals(order.getSysPara().getOrderDiscSeq())) {
                        goods.setTempZzkDiscount(0.0);
                        goods.setTempZzrDiscount(0.0);
                        double d = ManipulatePrecision.getDetailOverFlow(goods.getTempZkDiscount() + goods.getTempZrDiscount() + goods.getTempZzkDiscount() + goods.getTempZzrDiscount() + goods.getBarcodeDiscount() + goods.getFixedDiscountValue(), precisionMode);
                        goods.setAdjustDiscountValue(d);
                    }
                }
                if (ManipulatePrecision.doubleCompare(goods.getFixedDiscountValue(), 0.0, 2) > 0) {
                    sellPopDetail = new SellPopDetail();
                    sellPopDetail.setPopEventBillId("0");
                    sellPopDetail.setDiscountAmount(ManipulatePrecision.doubleConvert(goods.getFixedDiscountValue(), 6, 1));
                    sellPopDetail.setPopMode("0");
                    sellPopDetail.setPopPolicyGroup(YPopStatusType.pop_policy_group_grant_goods);
                    sellPopDetail.setPopPolicyType(YPopStatusType.pop_type_goods);
                    sellPopDetail.setPopDescribe("[" + order.getSysPara().getDpAmountDes() + "]");
                    sellPopDetail.setPopMemo("PRE:0");
                    if (StringUtils.isNotBlank((String)goods.getFdmode())) {
                        sellPopDetail.setPopMemo("fdmode:" + goods.getFdmode() + ",fdresult:" + goods.getFdresult() + ",popzkfd:" + goods.getPopzkfd());
                    }
                    sellPopDetail.setRowNo(goods.getFlowId());
                    sellDetail.getSellPopDetails().add(sellPopDetail);
                }
                if (!isHaveBarcodeDisc && (ManipulatePrecision.doubleCompare(goods.getBarcodeDiscount(), 0.0, 2) > 0 || goods.getDisZkl() > 0.0)) {
                    sellPopDetail = new SellPopDetail();
                    sellPopDetail.setPopEventBillId("0");
                    sellPopDetail.setDiscountAmount(ManipulatePrecision.doubleConvert(goods.getBarcodeDiscount(), 6, 1));
                    sellPopDetail.setPopMode("0");
                    sellPopDetail.setPopDescribe(order.getSysPara().getBarCodeDes());
                    sellPopDetail.setRowNo(goods.getFlowId());
                    if (goods.getDisMode() == 3) {
                        sellPopDetail.setPrcMode("6");
                        sellPopDetail.setPopPolicyGroup(YPopStatusType.pop_policy_group_barcode_discA);
                        sellPopDetail.setPopPolicyType(YPopStatusType.pop_type_barcodeA);
                        sellPopDetail.setPopDescribe("[" + order.getSysPara().getBarCodeDes() + "]");
                    } else if (goods.getDisMode() == 1) {
                        sellPopDetail.setPrcMode("6");
                        sellPopDetail.setPopPolicyGroup(YPopStatusType.pop_policy_group_barcode_discB);
                        sellPopDetail.setPopPolicyType(YPopStatusType.pop_type_barcodeB);
                    } else if (goods.getDisMode() == 2) {
                        sellPopDetail.setDiscountAmount(0.0);
                        sellPopDetail.setPrcMode("5");
                        sellPopDetail.setPopPolicyGroup(YPopStatusType.pop_policy_group_barcode_discB);
                        sellPopDetail.setPopPolicyType(YPopStatusType.pop_type_barcodeB);
                        sellPopDetail.setDiscountRate(ManipulatePrecision.doubleConvert(goods.getDisValue()));
                        sellPopDetail.setPopDescribe("[\u6761\u7801\u6298\u6263]");
                    }
                    if (StringUtils.isNotBlank((String)goods.getFdmode())) {
                        sellPopDetail.setPopPolicyGroup(YPopStatusType.pop_policy_group_barcode_discB);
                        sellPopDetail.setPopMemo("fdmode:" + goods.getFdmode() + ",fdzkfd:" + goods.getVipfdzkfd());
                    }
                    sellDetail.getSellPopDetails().add(sellPopDetail);
                }
                if (ManipulatePrecision.doubleCompare(goods.getTempZkDiscount(), 0.0, 2) > 0) {
                    sellPopDetail = new SellPopDetail();
                    sellPopDetail.setPopEventBillId("0");
                    sellPopDetail.setDiscountAmount(ManipulatePrecision.doubleConvert(goods.getTempZkDiscount(), 6, 1));
                    sellPopDetail.setPopMode("0");
                    sellPopDetail.setPopPolicyGroup(YPopStatusType.pop_policy_group_grant_goods);
                    sellPopDetail.setPopDescribe("[" + order.getSysPara().getDpRateDes() + goods.getTempZkl() + "%]");
                    sellPopDetail.setPopMemo("PRE:0");
                    if (StringUtils.isNotBlank((String)goods.getFdmode())) {
                        sellPopDetail.setPopMemo("fdmode:" + goods.getFdmode() + ",fdzkfd:" + goods.getFdzkfd());
                    }
                    sellPopDetail.setPopPolicyType(YPopStatusType.pop_type_goods);
                    sellPopDetail.setRowNo(goods.getFlowId());
                    sellDetail.getSellPopDetails().add(sellPopDetail);
                }
                if (ManipulatePrecision.doubleCompare(goods.getTempZrDiscount(), 0.0, 2) > 0) {
                    sellPopDetail = new SellPopDetail();
                    sellPopDetail.setPopEventBillId("0");
                    sellPopDetail.setDiscountAmount(ManipulatePrecision.doubleConvert(goods.getTempZrDiscount(), 6, 1));
                    sellPopDetail.setPopMode("0");
                    sellPopDetail.setPopPolicyGroup(YPopStatusType.pop_policy_group_grant_goods);
                    sellPopDetail.setPopDescribe("[" + order.getSysPara().getDpAmountDes() + "]");
                    sellPopDetail.setPopMemo("PRE:0");
                    if (StringUtils.isNotBlank((String)goods.getFdmode())) {
                        sellPopDetail.setPopMemo("fdmode:" + goods.getFdmode() + ",fdzkfd:" + goods.getFdzkfd());
                    }
                    sellPopDetail.setPopPolicyType(YPopStatusType.pop_type_goods);
                    sellPopDetail.setRowNo(goods.getFlowId());
                    sellDetail.getSellPopDetails().add(sellPopDetail);
                }
                if (!isHaveBarcodeDisc && goods.getCustomDiscountValue() > 0.0) {
                    sellPopDetail = new SellPopDetail();
                    sellPopDetail.setPopEventBillId("0");
                    sellPopDetail.setDiscountAmount(ManipulatePrecision.doubleConvert(goods.getCustomDiscountValue(), 6, 1));
                    sellPopDetail.setPopMode("0");
                    sellPopDetail.setPrcMode("6");
                    sellPopDetail.setPopPolicyGroup(YPopStatusType.pop_policy_group_barcode_discA);
                    sellPopDetail.setPopPolicyType(YPopStatusType.pop_type_barcodeA);
                    sellPopDetail.setPopDescribe("[" + order.getSysPara().getBarCodeDes() + "]");
                    sellPopDetail.setRowNo(goods.getFlowId());
                    sellDetail.getSellPopDetails().add(sellPopDetail);
                }
                if (goods.getMealDiscountValue() > 0.0) {
                    sellPopDetail = new SellPopDetail();
                    sellPopDetail.setPopEventBillId("0");
                    sellPopDetail.setDiscountAmount(ManipulatePrecision.doubleConvert(goods.getMealDiscountValue(), 6, 1));
                    sellPopDetail.setPopMode("0");
                    sellPopDetail.setPopPolicyGroup(YPopStatusType.pop_policy_group_grant_goods);
                    sellPopDetail.setPopMemo("PRE:1");
                    sellPopDetail.setRowNo(goods.getFlowId());
                    sellDetail.getSellPopDetails().add(sellPopDetail);
                }
                if (goods.getStudentCardDiscountValue() > 0.0) {
                    sellPopDetail = new SellPopDetail();
                    sellPopDetail.setPopEventBillId("0");
                    sellPopDetail.setDiscountAmount(ManipulatePrecision.doubleConvert(goods.getStudentCardDiscountValue(), 6, 1));
                    sellPopDetail.setPopMode("0");
                    sellPopDetail.setPopPolicyGroup(YPopStatusType.pop_policy_group_aeoncoupon);
                    sellPopDetail.setPopDescribe("[" + order.getSysPara().getXzkDes() + goods.getStudentCardDiscountValue() + "$]");
                    sellPopDetail.setPopMemo("PRE:1");
                    sellPopDetail.setRowNo(goods.getFlowId());
                    sellDetail.getSellPopDetails().add(sellPopDetail);
                }
            }
        }
        sellDetail.setOriginalBillNo(order.getOriginFlowNo());
        if (goods.getOriginalFlowId() != null) {
            sellDetail.setOriginalRowNo(goods.getOriginalFlowId());
        }
        if (goods.getOriginalFlowId() == null || goods.getOriginalFlowId() == 0) {
            sellDetail.setOriginalRowNo(goods.getFlowId());
        }
        return sellDetail;
    }

    @Override
    public List<Goods> combineSameGoods(List<Goods> goodslist, boolean checkGoodsType) {
        ArrayList<Goods> newGoodsList = new ArrayList<Goods>();
        String hhguid = "";
        for (Goods salegoods : goodslist) {
            String goodsType = salegoods.getGoodsType();
            if (!checkGoodsType) {
                goodsType = "0";
            }
            if (null == salegoods.getPopDetailsInfo()) {
                salegoods.setPopDetailsInfo(new ArrayList<PopDetail>());
            }
            if (null == salegoods.getCouponUses()) {
                salegoods.setCouponUses(new ArrayList<CouponUse>());
            }
            if (null == salegoods.getCouponGains()) {
                salegoods.setCouponGains(new ArrayList<CouponGain>());
            }
            if (null == salegoods.getCategoryPropertys()) {
                salegoods.setCategoryPropertys(new ArrayList<CategoryProperty>());
            }
            boolean isMerge = false;
            if (!"0".equals(goodsType) || ManipulatePrecision.doubleCompare(salegoods.getBarcodeDiscount(), 0.0, 2) > 0 || salegoods.getTempZrDiscount() > 0.0 || salegoods.getFixedDiscountValue() > 0.0 || "Y".equals(salegoods.getEscaleFlag()) && !"3".equals(salegoods.getGbdzcmlx()) || StringUtils.isNotBlank((String)salegoods.getEBillFlowNo()) || (double)((int)salegoods.getQty()) != salegoods.getQty()) {
                Goods tempSg = salegoods.deepClone();
                newGoodsList.add(Goods.delZeroPop(tempSg));
                continue;
            }
            for (Goods newSg : newGoodsList) {
                String goodsType1 = newSg.getGoodsType();
                if (!checkGoodsType) {
                    goodsType1 = "0";
                }
                if (!"0".equals(goodsType1) || newSg.getTempZrDiscount() != 0.0 || newSg.getFixedDiscountValue() != 0.0 || (!StringUtils.isEmpty((String)salegoods.getAssistantId()) || !StringUtils.isEmpty((String)newSg.getAssistantId())) && (!StringUtils.isNotEmpty((String)salegoods.getAssistantId()) || !salegoods.getAssistantId().equals(newSg.getAssistantId())) || !salegoods.getGoodsNo().equals(newSg.getGoodsNo()) || ManipulatePrecision.doubleCompare(salegoods.getSalePrice(), newSg.getSalePrice(), 2) != 0 || !salegoods.getFlag().equals(newSg.getFlag()) || (!StringUtils.isEmpty((String)salegoods.getPopFlag()) || !StringUtils.isEmpty((String)newSg.getPopFlag())) && (!StringUtils.isNotEmpty((String)salegoods.getPopFlag()) || !StringUtils.isNotEmpty((String)newSg.getPopFlag()) || !salegoods.getPopFlag().equals(newSg.getPopFlag())) || (!StringUtils.isEmpty((String)salegoods.getOrgCode()) || !StringUtils.isEmpty((String)newSg.getOrgCode())) && (!StringUtils.isNotEmpty((String)salegoods.getOrgCode()) || !salegoods.getOrgCode().equals(newSg.getOrgCode())) || ManipulatePrecision.doubleCompare(salegoods.getTempZkl(), newSg.getTempZkl(), 2) != 0 || !Convert.isListEqual(salegoods.getCategoryPropertys(), newSg.getCategoryPropertys()) || salegoods.getGoodsNo().startsWith("Z")) continue;
                String precisionMode = DataExchageUtils.exchangePrecisionMode(salegoods.getPrcutMode());
                newSg.setSaleValue(ManipulatePrecision.getDetailOverFlow(newSg.getSaleValue() + salegoods.getSaleValue(), salegoods.getPrcutMode()));
                newSg.setTempZkDiscount(ManipulatePrecision.getDetailOverFlow(newSg.getTempZkDiscount() + salegoods.getTempZkDiscount(), "0"));
                newSg.setBarcodeDiscount(ManipulatePrecision.getDetailOverFlow(newSg.getBarcodeDiscount() + salegoods.getBarcodeDiscount(), "0"));
                newSg.setTempZrDiscount(ManipulatePrecision.getDetailOverFlow(newSg.getTempZrDiscount() + salegoods.getTempZrDiscount(), "0"));
                newSg.setTempZzkDiscount(ManipulatePrecision.getDetailOverFlow(newSg.getTempZzkDiscount() + salegoods.getTempZzkDiscount(), "0"));
                newSg.setTempZzrDiscount(ManipulatePrecision.getDetailOverFlow(newSg.getTempZzrDiscount() + salegoods.getTempZzrDiscount(), "0"));
                newSg.setFixedDiscountValue(ManipulatePrecision.getDetailOverFlow(newSg.getFixedDiscountValue() + salegoods.getFixedDiscountValue(), "0"));
                newSg.setCouponValue(ManipulatePrecision.getDetailOverFlow(newSg.getCouponValue() + salegoods.getCouponValue(), "0"));
                newSg.setPopDiscountValue(ManipulatePrecision.getDetailOverFlow(newSg.getPopDiscountValue() + salegoods.getPopDiscountValue(), "0"));
                newSg.setBarcodeDiscount(ManipulatePrecision.getDetailOverFlow(newSg.getBarcodeDiscount() + salegoods.getBarcodeDiscount(), "0"));
                newSg.setAdjustDiscountValue(ManipulatePrecision.getDetailOverFlow(newSg.getAdjustDiscountValue() + salegoods.getAdjustDiscountValue(), "0"));
                newSg.setCustomDiscountValue(ManipulatePrecision.getDetailOverFlow(newSg.getCustomDiscountValue() + salegoods.getCustomDiscountValue(), "0"));
                newSg.setPayDiscountValue(ManipulatePrecision.getDetailOverFlow(newSg.getPayDiscountValue() + salegoods.getPayDiscountValue(), "0"));
                newSg.setMealDiscountValue(ManipulatePrecision.getDetailOverFlow(newSg.getMealDiscountValue() + salegoods.getMealDiscountValue(), "0"));
                newSg.setQty(ManipulatePrecision.getDetailOverFlow(newSg.getQty() + salegoods.getQty(), "0"));
                newSg.setTotalDiscountValue(CountZZK.getNoPrcutZZK(newSg));
                newSg.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(newSg.getTotalDiscountValue() - newSg.getNoDisAmountValue()));
                newSg.setSaleAmount(newSg.getSaleValue() - newSg.getTotalDiscountValue());
                if (null != salegoods.getPopDetails()) {
                    for (PopDetail pop : salegoods.getPopDetailsInfo()) {
                        boolean popIsMerged = false;
                        if (ManipulatePrecision.doubleCompare(pop.getDiscountAmount(), 0.0, 2) == 0 || null == pop.getPopPolicyGroup()) continue;
                        for (PopDetail newPop : newSg.getPopDetailsInfo()) {
                            if (YPopStatusType.pop_policy_group_aeoncoupon.equals(pop.getPopPolicyGroup())) {
                                if (!YPopStatusType.pop_policy_group_aeoncoupon.equals(newPop.getPopPolicyGroup()) || !pop.getPopMemo().equals(newPop.getPopMemo())) continue;
                                newPop.setDiscountAmount(ManipulatePrecision.getDetailOverFlow(newPop.getDiscountAmount() + pop.getDiscountAmount(), precisionMode));
                                popIsMerged = true;
                                break;
                            }
                            if (YPopStatusType.pop_policy_group_grant_goods.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_grant_order.equals(pop.getPopPolicyGroup())) {
                                if (!pop.getPopDescribe().equals(newPop.getPopDescribe())) continue;
                                newPop.setDiscountAmount(ManipulatePrecision.getDetailOverFlow(newPop.getDiscountAmount() + pop.getDiscountAmount(), precisionMode));
                                popIsMerged = true;
                                break;
                            }
                            if (pop.getPopEventId() != newPop.getPopEventId()) continue;
                            newPop.setDiscountAmount(ManipulatePrecision.getDetailOverFlow(newPop.getDiscountAmount() + pop.getDiscountAmount(), precisionMode));
                            popIsMerged = true;
                            break;
                        }
                        if (popIsMerged) continue;
                        newSg.getPopDetailsInfo().add(pop);
                    }
                }
                hhguid = newSg.getGuid();
                isMerge = true;
                break;
            }
            if (isMerge) continue;
            newGoodsList.add(salegoods);
        }
        List<Goods> goods = super.sortGoodsList(newGoodsList);
        goods = this.combineToTop(goods, hhguid);
        return goods;
    }

    @Override
    public void transferGoodsInfoToGoods(GoodsInfo goodsInfo, Goods goods, double qty) {
        BeanUtils.copyProperties((Object)goodsInfo, (Object)goods);
        goods.setRecycleFee(goodsInfo.getRecycleFee());
        goods.setControlFlag(goodsInfo.getControlFlag());
        goods.setOrgCode(goodsInfo.getOrgCode());
        goods.setCategoryCode(goodsInfo.getCategoryCode());
        goods.setCategoryCode(goodsInfo.getCategoryCode());
        goods.setArtCode(goodsInfo.getArtCode());
        goods.setIsfresh(goodsInfo.getIsfresh());
        goods.setBrandCode(goodsInfo.getBrandCode());
        goods.setBrandCode(goodsInfo.getBrandCode());
        goods.setGoodsUid(goodsInfo.getGuCode());
        goods.setBrandName(goodsInfo.getBrandName());
        goods.setSaleUnit(goodsInfo.getPartsUnit());
        goods.setPartsNum(goodsInfo.getPartsNum());
        goods.setMainBarcodeFlag(goodsInfo.getMainBarcodeFlag());
        goods.setPcs(goodsInfo.getPcs());
        if (goodsInfo.getEscaleFlag() == 0) {
            goods.setEscaleFlag("N");
        } else {
            goods.setEscaleFlag(goodsInfo.getEscaleFlag() == 1 ? "Y" : "N");
        }
        goods.setMinDiscount(goodsInfo.getMinDiscount());
        goods.setMinSalePrice(ManipulatePrecision.getDetailOverFlow(goodsInfo.getMinSalePrice(), goodsInfo.getPrcutMode()));
        goods.setRemark(goodsInfo.getRemark());
        goods.setImageUrl(goodsInfo.getImageUrl());
        goods.setEnFname(goodsInfo.getEnFname());
        goods.setPrimeCost(goodsInfo.getPrimeCost());
        goods.setGoodsName(goodsInfo.getGoodsName());
        goods.setGoodsType(goodsInfo.getGoodsType());
        goods.setBarNo(goodsInfo.getBarNo());
        goods.setGoodsCode(goodsInfo.getGoodsCode());
        goods.setListPrice(goodsInfo.getSalePrice());
        goods.setSalePrice(ManipulatePrecision.getDetailOverFlow(goodsInfo.getSalePrice(), goodsInfo.getPrcutMode()));
        goods.setRealSalePrice(goodsInfo.getSalePrice());
        goods.setMemberPrice(goodsInfo.getMemberPrice());
        goods.setBulkPrice(goodsInfo.getBulkPrice());
        goods.setWholeSalePrice(goodsInfo.getWholeSalePrice());
        goods.setOutputTax(goodsInfo.getOutputTax());
        goods.setSkuId(goodsInfo.getSkuId());
        if (StringUtils.isNotBlank((String)goodsInfo.getSeason()) && !"0".equals(goodsInfo.getSeason())) {
            goods.setSeason(goodsInfo.getSeason());
        }
        goods.setQty(qty);
        goods.setSaleValue(ManipulatePrecision.doubleConvert(goods.getSalePrice() * goods.getQty(), 2, 1));
        goods.setSaleAmount(goods.getSaleValue() - goods.getTotalDiscountValue());
        goods.setSsgid("" + goodsInfo.getSsgid());
        goods.setControlFlag(goodsInfo.getControlFlag());
        goods.setCategoryPropertys(goodsInfo.getCategoryPropertys());
        goods.setRecycleFee(goodsInfo.getRecycleFee());
        goods.setPrtDuplFlag(goodsInfo.getPrtDuplFlag());
        goods.setSsgid("" + goodsInfo.getSsgid());
        goods.setProcessFlag(goodsInfo.getProcessFlag());
        goods.setTempCategory(goodsInfo.getCategoryCode());
        goods.setVenderCode(goodsInfo.getVenderCode());
        goods.setPrcutMode(goodsInfo.getPrcutMode());
        goods.setGoodsStatus(goodsInfo.getGoodsStatus());
        goods.setGbmanamode(goodsInfo.getGbmanamode());
        goods.setSaleSpec(goodsInfo.getSaleSpec());
        goods.setIsExcessSale(goodsInfo.getIsExcessSale());
        goods.setColourCode(goodsInfo.getColourCode());
        goods.setColourName(goodsInfo.getColourName());
        goods.setSizeCode(goodsInfo.getSizeCode());
        goods.setSizeName(goodsInfo.getSizeName());
        goods.setParentGoodsCode(goodsInfo.getParentGoodsCode());
        goods.setIsWeight(goodsInfo.getIsdetachable() ? "Y" : "N");
        goods.setOrgName(goodsInfo.getOrgName());
        goods.setBrandName(goodsInfo.getBrandName());
        goods.setCategoryName(goodsInfo.getCategoryName());
        goods.setArtNo(goodsInfo.getArtNo());
        goods.setMachineCode(goodsInfo.getMachineCode());
        goods.setOperateFlag(goodsInfo.getOperateFlag());
        goods.setJdcouponAmount(goodsInfo.getJdcouponAmount());
    }

    @Override
    public Goods transferGoods(SellDetail sellDetail, Goods good, String calcResult, List<String> noDisPopTypes, boolean needYpopzke, boolean needGrant, boolean isSpecifyBack) {
        try {
            boolean hasErpVipPop = false;
            Object preline = "";
            if (null == sellDetail || null == good) {
                return null;
            }
            good.setYhmiscanuse("");
            good.setNoDisAmountValue(0.0);
            if (good.getFlag().equals("9")) {
                if (!"Y".equals(sellDetail.getYhMiscanUse())) {
                    good.setYhmiscanuse("N");
                } else {
                    good.setGoodsName(sellDetail.getItemName());
                }
            }
            if (StringUtils.isBlank((String)good.getTempName())) {
                good.setTempName(good.getGoodsName());
            } else {
                good.setGoodsName(good.getTempName());
            }
            if (needYpopzke) {
                good.setPopDiscountValue(ManipulatePrecision.doubleConvert(sellDetail.getTotalDiscount(), 2, 1));
            }
            good.setNojf(sellDetail.getNojf());
            good.setPopFlag(sellDetail.getFlag());
            good.setBarcodeDiscount(0.0);
            good.setKlm(sellDetail.getKlm());
            if (good.getQtyrecalc() != 0 && sellDetail.getQtyrecalc() == 0 || sellDetail.getQtyrecalc() != 0) {
                good.setQty(sellDetail.getQty());
                good.setSalePrice(sellDetail.getPrice());
                good.setSaleValue(sellDetail.getListAmount());
            }
            if ("5".equals(sellDetail.getFlag())) {
                good.setSalePrice(sellDetail.getPrice());
                good.setSaleValue(sellDetail.getListAmount());
            }
            good.setQtyrecalc(sellDetail.getQtyrecalc());
            good.setQtyrecalcAmount(sellDetail.getQtyrecalcAmount());
            good.setQtyrecalcEvtid(sellDetail.getQtyrecalcEvtid());
            if (good.getPopDetailsInfo() != null) {
                good.getPopDetailsInfo().clear();
            }
            if (good.getCouponUses() != null) {
                good.getCouponUses().clear();
            }
            if (good.getCouponGains() != null) {
                good.getCouponGains().clear();
            }
            double noDisAmout = 0.0;
            good.setIsJFHG(false);
            good.setBarcodeDiscount(0.0);
            if (null != sellDetail.getSellPopDetails() && sellDetail.getSellPopDetails().size() > 0) {
                double tempDiscount = 0.0;
                double adjustDiscount = 0.0;
                double custDiscount = 0.0;
                for (int i = 0; i < sellDetail.getSellPopDetails().size(); ++i) {
                    SellPopDetail pop = sellDetail.getSellPopDetails().get(i);
                    if (null == pop || "X".equals(pop.getPopFlag())) continue;
                    if (!good.getIsJFHG() && YPopStatusType.pop_type_jfhg.equals(pop.getPopEventType())) {
                        good.setIsJFHG(true);
                    }
                    if (this.checkAddPop(pop)) continue;
                    if (!(null == pop.getPopPolicyGroup() || pop.getPopPolicyGroup().equals(YPopStatusType.pop_policy_group_grant_order) || pop.getPopPolicyGroup().equals(YPopStatusType.pop_policy_group_grant_goods) || pop.getPopPolicyGroup().equals(YPopStatusType.pop_policy_group_erpvip) || pop.getPopPolicyGroup().equals(YPopStatusType.pop_policy_group_barcode_discA) || pop.getPopPolicyGroup().equals(YPopStatusType.pop_policy_group_barcode_discB) || pop.getPopPolicyGroup().equals(YPopStatusType.pop_policy_group_aeoncoupon) || pop.getPopPolicyGroup().equals(YPopStatusType.pop_policy_group_vip_disc))) {
                        if (ManipulateStr.readIndexChar(calcResult, 0) == '1') {
                            if (null == good.getPopDetailsInfo()) {
                                good.setPopDetailsInfo(new ArrayList<PopDetail>());
                            }
                            good.getPopDetailsInfo().add(this.popdetailTransfer.transferPopDetail2(pop));
                            continue;
                        }
                        if (null == good.getPopDetailsInfo()) {
                            good.setPopDetailsInfo(new ArrayList<PopDetail>());
                        }
                        good.getPopDetailsInfo().add(this.popdetailTransfer.transferPopDetail2(pop));
                        if (!(YPopStatusType.pop_policy_group_grant_order.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_grant_goods.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_erpvip.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_barcode_discA.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_barcode_discB.equals(pop.getPopPolicyGroup()))) {
                            tempDiscount += pop.getDiscountAmount();
                        }
                        if (null != noDisPopTypes && !noDisPopTypes.isEmpty() && StringUtils.isNotBlank((String)pop.getPopPolicyType()) && noDisPopTypes.indexOf(pop.getPopPolicyType()) != -1) {
                            noDisAmout += pop.getDiscountAmount();
                        }
                        if (StringUtils.isNotBlank((String)pop.getPopPolicySymbol())) {
                            preline = (String)preline + pop.getPopPolicySymbol();
                        }
                        if (!pop.getPopPolicyGroup().equalsIgnoreCase(YPopStatusType.pop_policy_group_random) || !pop.getPopMode().equalsIgnoreCase("0")) continue;
                        good.setTempRandomDiscount(pop.getDiscountAmount());
                        continue;
                    }
                    if (!pop.getPopPolicyGroup().equals(YPopStatusType.pop_policy_group_grant_order) && !pop.getPopPolicyGroup().equals(YPopStatusType.pop_policy_group_grant_goods) && !pop.getPopPolicyGroup().equals(YPopStatusType.pop_policy_group_erpvip) && !pop.getPopPolicyGroup().equals(YPopStatusType.pop_policy_group_aeoncoupon) && !pop.getPopPolicyGroup().equals(YPopStatusType.pop_policy_group_vip_disc) && !pop.getPopPolicyGroup().equals(YPopStatusType.pop_policy_group_barcode_discB) && !pop.getPopPolicyGroup().equals(YPopStatusType.pop_policy_group_barcode_discA)) continue;
                    hasErpVipPop = true;
                    if (needGrant) {
                        if (YPopStatusType.pop_policy_group_grant_order.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_grant_goods.equals(pop.getPopPolicyGroup())) {
                            if (YPopStatusType.pop_ghcard_goods.equals(pop.getPopPolicyType())) {
                                custDiscount = ManipulatePrecision.doubleConvert(custDiscount + pop.getDiscountAmount());
                            } else {
                                adjustDiscount = ManipulatePrecision.doubleConvert(adjustDiscount + pop.getDiscountAmount());
                            }
                        }
                        if (YPopStatusType.pop_policy_group_barcode_discA.equals(pop.getPopPolicyGroup())) {
                            if (pop.getDiscountAmount() == 0.0) {
                                good.setCustomDiscountValue(0.0);
                            }
                            custDiscount = ManipulatePrecision.doubleConvert(good.getCustomDiscountValue() + pop.getDiscountAmount(), 2, 1);
                        }
                        if (YPopStatusType.pop_policy_group_barcode_discB.equals(pop.getPopPolicyGroup())) {
                            good.setBarcodeDiscount(ManipulatePrecision.doubleConvert(good.getBarcodeDiscount() + pop.getDiscountAmount(), 2, 1));
                        }
                        if (null == good.getPopDetailsInfo()) {
                            good.setPopDetailsInfo(new ArrayList<PopDetail>());
                        }
                        good.getPopDetailsInfo().add(this.popdetailTransfer.transferPopDetail2(pop));
                        if (null == pop.getPopPolicySymbol() || "".equals(pop.getPopPolicySymbol())) continue;
                        preline = (String)preline + pop.getPopPolicySymbol();
                        continue;
                    }
                    if (YPopStatusType.pop_policy_group_barcode_discA.equals(pop.getPopPolicyGroup())) {
                        good.getPopDetailsInfo().add(this.popdetailTransfer.transferPopDetail2(pop));
                        if (pop.getDiscountAmount() == 0.0) {
                            good.setCustomDiscountValue(0.0);
                        }
                        custDiscount = ManipulatePrecision.doubleConvert(good.getCustomDiscountValue() + pop.getDiscountAmount(), 2, 1);
                        continue;
                    }
                    if (!YPopStatusType.pop_policy_group_barcode_discB.equals(pop.getPopPolicyGroup())) continue;
                    good.getPopDetailsInfo().add(this.popdetailTransfer.transferPopDetail2(pop));
                    good.setBarcodeDiscount(ManipulatePrecision.doubleConvert(good.getBarcodeDiscount() + pop.getDiscountAmount(), 2, 1));
                }
                if (needGrant && isSpecifyBack) {
                    good.setAdjustDiscountValue(adjustDiscount);
                    good.setCustomDiscountValue(custDiscount);
                    good.setTempZrDiscount(adjustDiscount);
                }
                if (needYpopzke) {
                    good.setPopDiscountValue(ManipulatePrecision.doubleConvert(tempDiscount, 2, 1));
                }
            }
            good.setNoDisAmountValue(noDisAmout);
            if (!hasErpVipPop) {
                good.setCustomDiscountValue(0.0);
            }
            if (null != sellDetail.getCouponUses() && sellDetail.getCouponUses().size() > 0) {
                for (int i = 0; i < sellDetail.getCouponUses().size(); ++i) {
                    CouponUse couponuse;
                    SellCouponUse use = sellDetail.getCouponUses().get(i);
                    if (null == good.getCouponUses()) {
                        good.setCouponUses(new ArrayList<CouponUse>());
                    }
                    if (null == (couponuse = this.couponTransfer.transferCouponUse(use))) continue;
                    couponuse.setGoodsRowNo(good.getFlowId());
                    good.getCouponUses().add(couponuse);
                }
            }
            if (null != sellDetail.getCouponGains() && sellDetail.getCouponGains().size() > 0) {
                for (int i = 0; i < sellDetail.getCouponGains().size(); ++i) {
                    SellCouponGain gain = sellDetail.getCouponGains().get(i);
                    if (null == good.getCouponGains()) {
                        good.setCouponGains(new ArrayList<CouponGain>());
                    }
                    good.getCouponGains().add(this.couponTransfer.transferCouponGain(gain, good.getFlowId()));
                }
            }
            if (!isSpecifyBack && StringUtils.isNotBlank((String)preline)) {
                good.setGoodsName("(" + (String)preline + ")" + good.getGoodsName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return good;
    }

    @Override
    public Goods removeConditionPopDetails(Goods orsg) {
        return orsg;
    }

    @Override
    public Goods removeSinglePopDetails(Goods sg) {
        if (null == sg.getPopDetailsInfo() || sg.getPopDetailsInfo().size() == 0) {
            return sg;
        }
        Goods newsg = sg.deepClone();
        for (int i = 0; i < newsg.getPopDetailsInfo().size(); ++i) {
            PopDetail pop = newsg.getPopDetailsInfo().get(i);
            if (null == pop.getPopPolicyGroup()) continue;
            if (YPopStatusType.pop_policy_group_point.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_pointbase.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_grant_goods.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_grant_order.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_pointuse.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_couponuse.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_aeoncoupon.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_needCoupon.equals(pop.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_share.equals(pop.getPopPolicyGroup())) {
                newsg.getPopDetailsInfo().remove(i);
                --i;
                continue;
            }
            if (YPopStatusType.pop_type_cwmz.equals(pop.getPopPolicyType())) {
                newsg.getPopDetailsInfo().remove(i);
                --i;
                continue;
            }
            if (StringUtils.isNotBlank((String)pop.getPopEventType()) && pop.getPopEventType().indexOf("_coupon_") > 0) {
                newsg.getPopDetailsInfo().remove(i);
                --i;
                continue;
            }
            if ("NOT_EXECUTED".equals(pop.getPopEventBillType())) {
                newsg.getPopDetailsInfo().remove(i);
                --i;
                continue;
            }
            if (!"3".equals(pop.getPopMode()) || pop.getDiscountAmount() != 0.0) continue;
            newsg.getPopDetailsInfo().remove(i);
            --i;
        }
        return newsg;
    }
}

