/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.javaPos.commonkit.localize;

import com.efuture.business.bean.SellType;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.javaPos.commonkit.PosLogicCompomentImpl;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.Order;
import com.efuture.business.javaPos.struct.Payment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PosLogicCompomentImpl_ERAJAYA
extends PosLogicCompomentImpl {
    private static final Logger log = LoggerFactory.getLogger(PosLogicCompomentImpl_ERAJAYA.class);

    @Override
    public CacheModel calcPayBalance(CacheModel order) {
        this.calcBalance(order);
        Order saleOrder = order.getOrder();
        double existPay = saleOrder.getExistPay();
        double balance = this.calcOrderOughtPay(saleOrder.getRemainValue(), order.getOrder().getPrecisionMode());
        if (("E".equals(saleOrder.getPrecisionMode()) || "G".equals(saleOrder.getPrecisionMode())) && SellType.ISBACK(saleOrder.getOrderType())) {
            balance = this.calcOrderOughtPay(saleOrder.getRemainValue(), "4");
        }
        if (null != order.getPayments() && order.getPayments().size() > 0) {
            balance = saleOrder.getRemainValue();
        }
        if (ManipulatePrecision.doubleCompare(balance, 0.0, 2) == 0 && balance != saleOrder.getRemainValue()) {
            double overageValue = ManipulatePrecision.getDetailOverFlow(balance - saleOrder.getRemainValue(), "9");
            boolean isMatchOverage = false;
            for (int i = order.getPayments().size() - 1; i >= 0; --i) {
                Payment pay = order.getPayments().get(i);
                if (!"Y".equals(pay.getIsOverage())) continue;
                pay.setOverage(overageValue);
                isMatchOverage = true;
                break;
            }
            if (!isMatchOverage) {
                order.setCalcResult(-1);
                order.setErrMsg("\u8ba2\u5355\u652f\u4ed8\u884c\u4e0d\u652f\u6301\u627e\u96f6\u6216\u8005\u6ea2\u4f59.");
                return order;
            }
            this.calcBalance(order);
        }
        saleOrder.setExistPay(existPay);
        return order;
    }
}

