/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.javaPos.commonkit.localize;

import com.efuture.business.javaPos.commonkit.CountZZK;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.javaPos.commonkit.PosLogicCompomentImpl;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.CouponGain;
import com.efuture.business.javaPos.struct.CouponUse;
import com.efuture.business.javaPos.struct.Goods;
import com.efuture.business.javaPos.struct.PopDetail;
import com.efuture.business.javaPos.struct.mainDataCentre.GoodsInfo;
import com.efuture.business.util.DataExchageUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class PosLogicCompomentImpl_SJGW
extends PosLogicCompomentImpl {
    private static final Logger log = LoggerFactory.getLogger(PosLogicCompomentImpl_SJGW.class);

    @Override
    public Goods converDiscount(Goods sg, CacheModel cacheModel) {
        String precisionMode = DataExchageUtils.exchangePrecisionMode(sg.getPrcutMode());
        if (sg.getBarcodeDiscount() > 0.0) {
            if (sg.getDisMode() == 1) {
                if (ManipulatePrecision.doubleCompare(sg.getDisValue(), sg.getSalePrice(), 2) >= 0) {
                    sg.setCustomDiscountValue(sg.getSaleAmount());
                } else {
                    sg.setCustomDiscountValue(ManipulatePrecision.getDetailOverFlow(sg.getDisValue() * sg.getQty(), precisionMode));
                }
            } else if (sg.getDisMode() == 2) {
                if (ManipulatePrecision.doubleCompare(sg.getDisValue(), 100.0, 2) < 0) {
                    sg.setBarcodeDiscount(ManipulatePrecision.getDetailOverFlow(sg.getSaleAmount() - sg.getSaleAmount() * sg.getDisValue(), precisionMode));
                }
            } else if (sg.getDisMode() == 3) {
                if (ManipulatePrecision.doubleCompare(sg.getSaleValue(), 0.0, 2) == 0) {
                    sg.setSaleValue(ManipulatePrecision.getDetailOverFlow(sg.getDisValue() * sg.getQty(), sg.getPrcutMode()));
                    sg.setCustomDiscountValue(0.0);
                } else if (ManipulatePrecision.doubleCompare(sg.getSalePrice(), sg.getDisValue(), 2) > 0) {
                    sg.setBarcodeDiscount(ManipulatePrecision.getDetailOverFlow((sg.getSalePrice() - sg.getDisValue()) * sg.getQty(), precisionMode));
                }
            }
        }
        return sg;
    }

    @Override
    public Goods calcGoodsBarcodeDiscBeforeSingle(Goods goods, int disMode, double disValue, String discType) {
        if ("0".equals(goods.getDiscType())) {
            if (goods.getDisMode() == 1) {
                if (ManipulatePrecision.doubleCompare(goods.getDisValue(), goods.getSaleAmount(), 2) >= 0) {
                    goods.setBarcodeDiscount(goods.getSaleAmount());
                } else {
                    goods.setBarcodeDiscount(goods.getDisValue());
                }
            } else if (goods.getDisMode() == 2) {
                String precisionMode = DataExchageUtils.exchangePrecisionMode(goods.getPrcutMode());
                if (ManipulatePrecision.doubleCompare(goods.getDisValue(), 100.0, 2) > 0) {
                    return goods;
                }
                goods.setBarcodeDiscount(ManipulatePrecision.getDetailOverFlow(goods.getSaleAmount() - goods.getSaleAmount() * goods.getDisValue(), precisionMode));
            } else if (goods.getDisMode() == 3) {
                if (ManipulatePrecision.doubleCompare(goods.getSaleAmount(), 0.0, 2) == 0) {
                    goods.setSaleValue(ManipulatePrecision.getDetailOverFlow(goods.getDisValue(), goods.getPrcutMode()));
                } else if (ManipulatePrecision.doubleCompare(goods.getSaleAmount(), goods.getDisValue(), 2) > 0) {
                    String precisionMode = DataExchageUtils.exchangePrecisionMode(goods.getPrcutMode());
                    goods.setBarcodeDiscount(ManipulatePrecision.getDetailOverFlow(goods.getSaleAmount() - goods.getDisValue(), precisionMode));
                }
            } else if (goods.getDisMode() == 4) {
                String precisionMode = DataExchageUtils.exchangePrecisionMode(goods.getPrcutMode());
                if (ManipulatePrecision.doubleCompare(goods.getDisValue(), 100.0, 2) > 0) {
                    return goods;
                }
                goods.setBarcodeDiscount(ManipulatePrecision.getDetailOverFlow(goods.getSaleAmount() - goods.getSaleAmount() * goods.getDisZkl(), precisionMode));
            }
            goods.setAdjustDiscountValue(this.getAdjustDiscount(goods));
            goods.setTotalDiscountValue(CountZZK.getZZK(goods));
            goods.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(goods.getTotalDiscountValue() - goods.getNoDisAmountValue()));
            goods.setSaleAmount(goods.getSaleValue() - goods.getTotalDiscountValue());
            return goods;
        }
        if ("1".equals(discType)) {
            if (disMode == 1 || disMode == 2) {
                return goods;
            }
            if (disMode == 3) {
                if (ManipulatePrecision.doubleCompare(goods.getSaleAmount(), 0.0, 2) == 0) {
                    goods.setSaleValue(ManipulatePrecision.getDetailOverFlow(disValue, goods.getPrcutMode()));
                } else if (ManipulatePrecision.doubleCompare(goods.getSaleAmount(), disValue, 2) > 0) {
                    String precisionMode = DataExchageUtils.exchangePrecisionMode(goods.getPrcutMode());
                    goods.setBarcodeDiscount(ManipulatePrecision.getDetailOverFlow(goods.getSaleAmount() - disValue, precisionMode));
                }
            }
            goods.setAdjustDiscountValue(this.getAdjustDiscount(goods));
            goods.setTotalDiscountValue(CountZZK.getZZK(goods));
            goods.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(goods.getTotalDiscountValue() - goods.getNoDisAmountValue()));
            goods.setSaleAmount(goods.getSaleValue() - goods.getTotalDiscountValue());
            goods.setDisMode(disMode);
            goods.setDisValue(disValue);
            goods.setDiscType(discType);
            return goods;
        }
        return goods;
    }

    @Override
    public Goods goodsInfo2Goods(GoodsInfo goodsInfo, String yyyh, double quantity, double price, double allprice, boolean dzcm, double dzcmjgzk, double dzcmsl, double dzcmjg, String originalBarNo, double origPrice, int popMode) {
        Goods goods = new Goods();
        BeanUtils.copyProperties((Object)goodsInfo, (Object)goods);
        goods.setAssistantId("");
        if (StringUtils.isNotBlank((String)yyyh)) {
            goods.setAssistantId(yyyh);
        }
        goods.setTempZkl(100.0);
        goods.setGoodsCode(goodsInfo.getGoodsCode());
        goods.setBarNo(goodsInfo.getBarNo());
        goods.setGoodsNo(originalBarNo);
        goods.setGoodsName(goodsInfo.getGoodsName());
        goods.setGoodsType(goodsInfo.getGoodsType());
        goods.setMainBarcodeFlag(goodsInfo.getMainBarcodeFlag());
        goods.setSaleSpec(goodsInfo.getSaleSpec());
        goods.setSaleUnit(goodsInfo.getPartsUnit());
        goods.setListPrice(origPrice);
        goods.setSalePrice(ManipulatePrecision.getDetailOverFlow(origPrice, goodsInfo.getPrcutMode()));
        if (0.0 == goods.getSalePrice()) {
            goods.setSalePrice(ManipulatePrecision.getDetailOverFlow(goodsInfo.getSalePrice(), goodsInfo.getPrcutMode()));
        }
        goods.setRealSalePrice(price);
        goods.setQty(quantity);
        goods.setQuantityRecalc(quantity);
        goods.setOrgCode(goodsInfo.getOrgCode());
        goods.setCategoryCode(goodsInfo.getCategoryCode());
        goods.setIsfresh(goodsInfo.getIsfresh());
        goods.setGoodsUid(goodsInfo.getGoodsUid());
        goods.setBrandCode(goodsInfo.getBrandCode());
        goods.setBrandName(goodsInfo.getBrandName());
        goods.setSaleUnit(goodsInfo.getPartsUnit());
        if (goodsInfo.getPartsNum() > 1.0) {
            goods.setPartsNum(1.0);
        } else {
            goods.setPartsNum(goodsInfo.getPartsNum());
        }
        goods.setMemberPrice(goodsInfo.getMemberPrice());
        goods.setWholeSalePrice(goodsInfo.getWholeSalePrice());
        goods.setPcs(goodsInfo.getPcs());
        goods.setColdTransFlag(goodsInfo.getColdTransFlag());
        goods.setProcessFlag(goodsInfo.getProcessFlag());
        goods.setVenderCode(goodsInfo.getVenderCode());
        goods.setArtCode(goodsInfo.getArtCode());
        goods.setTempCategory(goodsInfo.getCategoryCode());
        goods.setIsExcessSale(goodsInfo.getIsExcessSale());
        goods.setIsWeight(goodsInfo.getIsdetachable() ? "Y" : "N");
        goods.setSkuId(goodsInfo.getSkuId());
        goods.setColourCode(goodsInfo.getColourCode());
        goods.setColourName(goodsInfo.getColourName());
        goods.setSizeCode(goodsInfo.getSizeCode());
        goods.setSizeName(goodsInfo.getSizeName());
        if (goodsInfo.getEscaleFlag() == 0) {
            goods.setEscaleFlag("N");
        } else {
            goods.setEscaleFlag("Y");
        }
        if (dzcm) {
            goods.setEscaleFlag("Y");
        }
        goods.setMinDiscount(goodsInfo.getMinDiscount());
        goods.setMinSalePrice(goodsInfo.getMinSalePrice());
        goods.setPrimeCost(goodsInfo.getPrimeCost());
        goods.setRemark(goodsInfo.getRemark());
        goods.setImageUrl(goodsInfo.getImageUrl());
        goods.setEnFname(goodsInfo.getEnSname());
        goods.setPrcutMode(goodsInfo.getPrcutMode());
        if (null == goods.getPrcutMode() || "".equals(goods.getPrcutMode())) {
            goods.setPrcutMode("0");
        }
        goods.setCouponValue(0.0);
        goods.setPopDiscountValue(0.0);
        goods.setAdjustDiscountValue(0.0);
        goods.setTotalDiscountValue(0.0);
        goods.setRealTotalDiscountValue(0.0);
        goods.setCustomDiscountValue(0.0);
        goods.setPayDiscountValue(0.0);
        goods.setDzcDiscountValue(0.0);
        goods.setTempZkDiscount(0.0);
        goods.setTempZrDiscount(0.0);
        goods.setTempZzkDiscount(0.0);
        goods.setTempZzrDiscount(0.0);
        goods.setNoDisAmountValue(0.0);
        goods.setSsgid("" + goodsInfo.getSsgid());
        if (dzcm) {
            goods.setSaleValue(ManipulatePrecision.getDetailOverFlow(allprice, goods.getPrcutMode()));
            goods.setFlag("1");
            goods.setDzcDiscountValue(dzcmjgzk);
            if (4 == popMode) {
                double salevalue = 0.0;
                salevalue = ManipulatePrecision.getDetailOverFlow(goods.getSalePrice() * goods.getQty(), goods.getPrcutMode());
                goods.setSaleValue(salevalue);
                goods.setSaleAmount(allprice);
                goods.setDzcDiscountValue(ManipulatePrecision.doubleConvert(salevalue - allprice));
                goods.setAdjustDiscountValue(goods.getDzcDiscountValue());
                goods.setTotalDiscountValue(goods.getDzcDiscountValue());
            }
            goods.setEWCCodeAmount(dzcmjg);
            goods.setEWCCodeNum(dzcmsl);
        } else {
            goods.setSaleValue(ManipulatePrecision.getDetailOverFlow(goods.getSalePrice() * goods.getQty(), goods.getPrcutMode()));
        }
        goods.setSaleAmount(ManipulatePrecision.getDetailOverFlow(goods.getSaleValue() - goods.getTotalDiscountValue(), goods.getPrcutMode()));
        goods.setPopDetailsInfo(new ArrayList<PopDetail>());
        goods.setCouponGains(new ArrayList<CouponGain>());
        goods.setCouponUses(new ArrayList<CouponUse>());
        goods.setRecycleFee(goodsInfo.getRecycleFee());
        goods.setControlFlag(goodsInfo.getControlFlag());
        goods.setLicense(goodsInfo.getLicense());
        goods.setGoodsDesc(goodsInfo.getGoodsDesc());
        goods.setStallCode(goodsInfo.getStallCode());
        if (StringUtils.isNotBlank((String)goodsInfo.getSeason()) && !"0".equals(goodsInfo.getSeason())) {
            goods.setSeason(goodsInfo.getSeason());
        }
        goods.setGoodsStatus(goodsInfo.getGoodsStatus());
        goods.setGbmanamode(goodsInfo.getGbmanamode());
        goods.setPrtDuplFlag(goodsInfo.getPrtDuplFlag());
        goods.setOutputTax(goodsInfo.getOutputTax());
        goods.setParentGoodsCode(goodsInfo.getParentGoodsCode());
        goods.setBulkPrice(goodsInfo.getBulkPrice());
        goods.setDiscountFlag(goodsInfo.getDiscountFlag());
        goods.setNoPricing(goodsInfo.getNoPricing());
        goods.setShareDiscount1(goodsInfo.getShareDiscount1());
        goods.setShareDiscount2(goodsInfo.getShareDiscount2());
        goods.setContractCode(goodsInfo.getContractCode());
        goods.setOrgName(goodsInfo.getOrgName());
        goods.setBrandName(goodsInfo.getBrandName());
        goods.setCategoryName(goodsInfo.getCategoryName());
        goods.setArtNo(goodsInfo.getArtNo());
        return goods;
    }

    @Override
    public Goods calcGoodsAmount(GoodsInfo sg, String assistantId, boolean isdzcm, double dzcmsl, double dzcmjg, String eleMode, String originalBarNo, double qty, boolean isHaveQty, int popMode) {
        double quantity = qty;
        double allprice = 0.0;
        double dzcprice = 0.0;
        double dzcmjgzk = 0.0;
        double price = 0.0;
        double origPrice = 0.0;
        if (sg.getPartsNum() > 1.0 && !isdzcm) {
            sg.setGoodsName(sg.getGoodsName() + "(" + (int)sg.getPartsNum() + "/1)");
            sg.setGoodsDisplayName(sg.getGoodsDisplayName() + "(" + (int)sg.getPartsNum() + "/1)");
            quantity = sg.getPartsNum();
        } else {
            price = sg.getSalePrice();
            origPrice = sg.getSalePrice();
        }
        if (sg.getEscaleFlag() == 1 && !isdzcm && !isHaveQty) {
            return null;
        }
        if (isdzcm) {
            if (sg.getEWCCodeNum() > 0.0 && sg.getEWCCodeAmount() <= 0.0) {
                double jg;
                if (sg.getPartsNum() <= 0.0) {
                    sg.setPartsNum(1.0);
                }
                quantity = ManipulatePrecision.doubleConvert(dzcmsl / sg.getPartsNum(), 4, 1);
                price = ManipulatePrecision.doubleConvert(sg.getSalePrice(), 2, 1);
                allprice = quantity * price;
                dzcprice = 1.0;
                allprice = ManipulatePrecision.doubleConvert(allprice, 3, 0);
                if (ManipulatePrecision.doubleCompare(allprice = ManipulatePrecision.doubleConvert(allprice, 2, 1), jg = ManipulatePrecision.getDetailOverFlow(allprice, sg.getPrcutMode()), 2) != 0) {
                    dzcmjgzk = ManipulatePrecision.sub(allprice, jg);
                }
            } else if (sg.getEWCCodeNum() <= 0.0 && sg.getEWCCodeAmount() > 0.0) {
                if (sg.getSalePrice() <= 0.0 || "1".equals(eleMode) || "2".equals(eleMode)) {
                    quantity = 1.0;
                    allprice = price = dzcmjg;
                    sg.setSalePrice(price);
                    dzcprice = 1.0;
                } else {
                    quantity = ManipulatePrecision.doubleConvert(dzcmjg / sg.getSalePrice(), 4, 1);
                    price = sg.getSalePrice();
                    allprice = dzcmjg;
                    dzcprice = 2.0;
                }
            } else if (sg.getEWCCodeNum() > 0.0 && sg.getEWCCodeAmount() > 0.0) {
                if (sg.getPartsNum() <= 0.0) {
                    sg.setPartsNum(1.0);
                }
                quantity = ManipulatePrecision.doubleConvert(dzcmsl / sg.getPartsNum(), 4, 1);
                allprice = dzcmjg;
                log.info("salePrice=" + sg.getSalePrice() + "quantity=" + quantity + "allprice=" + allprice);
                sg.setSalePrice(ManipulatePrecision.doubleConvert(dzcmjg / (dzcmsl / sg.getPartsNum()), 2, 1));
                price = sg.getSalePrice();
            }
        }
        if (!this.checkFindGoodsAllowSale(sg, quantity, isdzcm, dzcmsl, dzcmjg, isHaveQty)) {
            return null;
        }
        Goods saleGoodsDef = this.goodsInfo2Goods(sg, assistantId, quantity, price, allprice, isdzcm, dzcmjgzk, dzcmsl, dzcmjg, originalBarNo, origPrice, popMode);
        saleGoodsDef = this.calcGoodsAmount(saleGoodsDef);
        return saleGoodsDef;
    }

    @Override
    public CacheModel editGoodsQty(CacheModel cacheModel, int flow_id, String accreditNo, double qty) {
        if (qty <= 0.0) {
            return cacheModel;
        }
        if (StringUtils.isNotBlank((String)cacheModel.getOrder().getOriginTerminalNo()) && StringUtils.isNotBlank((String)cacheModel.getOrder().getOriginTerminalSno())) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("20176");
            cacheModel.setErrMsg("\u6307\u5b9a\u5c0f\u7968\u9000\u8d27\u4e0d\u5141\u8bb8\u4fee\u6539\u5546\u54c1\u6570\u91cf");
            return cacheModel;
        }
        Goods sg = cacheModel.getGoodsList().get(flow_id - 1);
        if (null == sg) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("20148");
            cacheModel.setErrMsg("\u67e5\u4e0d\u5230\u5546\u54c1\u4fe1\u606f");
            return cacheModel;
        }
        if (sg.getEscaleFlag().equals("Y") && !this.checkEscaleEditFlag(sg)) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("20140");
            cacheModel.setErrMsg("\u7535\u5b50\u79e4\u5546\u54c1\u4e0d\u5141\u8bb8\u4fee\u6539\u6570\u91cf");
            return cacheModel;
        }
        if (sg.getBarcodeDiscount() > 0.0 && sg.getEscaleFlag().equals("Y")) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("20141");
            cacheModel.setErrMsg("\u91d1\u989d\u7801\u5546\u54c1\u4e0d\u5141\u8bb8\u4fee\u6539\u6570\u91cf");
            return cacheModel;
        }
        if (sg.getFlag().equals("0")) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("20142");
            cacheModel.setErrMsg("\u8d60\u54c1\u4e0d\u5141\u8bb8\u4fee\u6539\u6570\u91cf");
            return cacheModel;
        }
        if (sg.getControlFlag()) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("20143");
            cacheModel.setErrMsg("\u7ba1\u5236\u5546\u54c1\u4e0d\u5141\u8bb8\u4fee\u6539\u6570\u91cf");
            return cacheModel;
        }
        Goods oldsg = sg.deepClone();
        double tempzr = sg.getTempZrDiscount();
        double tempzkl = sg.getTempZkl();
        double discamount = sg.getDiscAmount();
        log.info("tempzkl" + tempzkl + ",tempzr" + tempzr + ",discamount" + discamount);
        String precisionMode = DataExchageUtils.exchangePrecisionMode(sg.getPrcutMode());
        try {
            if (null == sg.getSGoodsSno() || sg.getSGoodsSno().length() <= 0) {
                double oldQty = sg.getQty();
                double newQty = qty;
                sg.setQty(newQty);
                sg.setSaleValue(ManipulatePrecision.getDetailOverFlow(newQty * sg.getSalePrice(), precisionMode));
                sg.setTempZkDiscount(0.0);
                sg.setTempZrDiscount(0.0);
                sg.setTempZzkDiscount(0.0);
                sg.setTempZzrDiscount(0.0);
                sg.setPopDiscountValue(0.0);
                sg.setDiscAmount(0.0);
                if (null != sg.getPopDetailsInfo()) {
                    sg.getPopDetailsInfo().clear();
                }
                sg.setFixedDiscountValue(ManipulatePrecision.getDetailOverFlow(ManipulatePrecision.mul(ManipulatePrecision.div(sg.getFixedDiscountValue(), oldQty), newQty), precisionMode));
                if (sg.getBarcodeDiscount() > 0.0) {
                    if (sg.getDisMode() == 1) {
                        if (ManipulatePrecision.doubleCompare(sg.getDisValue(), sg.getSalePrice(), 2) >= 0) {
                            sg.setBarcodeDiscount(sg.getSaleAmount());
                        } else {
                            sg.setBarcodeDiscount(ManipulatePrecision.getDetailOverFlow(sg.getDisValue() * sg.getQty(), precisionMode));
                        }
                    } else if (sg.getDisMode() == 2) {
                        if (ManipulatePrecision.doubleCompare(sg.getDisValue(), 100.0, 2) < 0) {
                            sg.setBarcodeDiscount(ManipulatePrecision.getDetailOverFlow(sg.getSaleValue() * sg.getDisValue(), precisionMode));
                        }
                    } else if (sg.getDisMode() == 3) {
                        if (ManipulatePrecision.doubleCompare(sg.getSaleValue(), 0.0, 2) == 0) {
                            sg.setSaleValue(ManipulatePrecision.getDetailOverFlow(sg.getDisValue() * sg.getQty(), sg.getPrcutMode()));
                            sg.setBarcodeDiscount(0.0);
                        } else if (ManipulatePrecision.doubleCompare(sg.getSalePrice(), sg.getDisValue(), 2) > 0) {
                            if (2 == cacheModel.getPopMode() || 1 == cacheModel.getPopMode()) {
                                sg.setBarcodeDiscount(ManipulatePrecision.getDetailOverFlow(sg.getSalePrice() - sg.getDisValue(), precisionMode));
                            } else {
                                sg.setBarcodeDiscount(ManipulatePrecision.getDetailOverFlow((sg.getSalePrice() - sg.getDisValue()) * sg.getQty(), precisionMode));
                            }
                        }
                    }
                }
                sg = this.converDiscount(sg, cacheModel);
                sg.setAdjustDiscountValue(ManipulatePrecision.getDetailOverFlow(this.getAdjustDiscount(sg), precisionMode));
                sg.setTotalDiscountValue(CountZZK.getNoPrcutZZK(sg));
                sg.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sg.getTotalDiscountValue() - sg.getNoDisAmountValue()));
                sg.setSaleAmount(ManipulatePrecision.getDetailOverFlow(sg.getSaleValue() - sg.getTotalDiscountValue(), sg.getPrcutMode()));
                cacheModel.getOrder().setTerminalOperatorAuthzCardNo(accreditNo);
                this.calcOrderAmount(cacheModel);
            } else {
                int num;
                List<Goods> goodslist = cacheModel.getGoodsList();
                int newnum = num = goodslist.size();
                for (int i = 0; i < num; ++i) {
                    Goods sGoods = goodslist.get(i);
                    if (null == sGoods.getSGoodsSno() || !sGoods.getSGoodsSno().equals(oldsg.getSGoodsSno())) continue;
                    double newQty = qty;
                    sGoods.setQty(newQty);
                    sGoods.setSaleValue(ManipulatePrecision.getDetailOverFlow(newQty * sGoods.getSalePrice(), precisionMode));
                    sGoods.setTempZkDiscount(0.0);
                    sGoods.setTempZzkDiscount(0.0);
                    sGoods.setTempZzrDiscount(0.0);
                    sGoods.setPopDiscountValue(0.0);
                    if (sGoods.getPopDetailsInfo() != null) {
                        sGoods.getPopDetailsInfo().clear();
                    }
                    sGoods.setAdjustDiscountValue(ManipulatePrecision.getDetailOverFlow(this.getAdjustDiscount(sGoods), precisionMode));
                    sGoods.setTotalDiscountValue(CountZZK.getNoPrcutZZK(sGoods));
                    sGoods.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sGoods.getTotalDiscountValue() - sGoods.getNoDisAmountValue()));
                    sGoods.setSaleAmount(ManipulatePrecision.getDetailOverFlow(sg.getSaleValue() - sGoods.getTotalDiscountValue(), precisionMode));
                    cacheModel.getOrder().setTerminalOperatorAuthzCardNo(accreditNo);
                    cacheModel.getGoodsList().add(sGoods);
                    ++newnum;
                    this.calcOrderAmount(cacheModel);
                }
            }
            return cacheModel;
        }
        catch (Exception e) {
            e.printStackTrace();
            cacheModel.getGoodsList().set(flow_id - 1, oldsg);
            return cacheModel;
        }
    }

    @Override
    protected boolean zeroQty() {
        return true;
    }

    @Override
    public boolean checkEscaleEditFlag(Goods sg) {
        return "3".equals(sg.getGbdzcmlx());
    }
}

