/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.javaPos.commonkit.localize;

import com.alibaba.fastjson.JSONObject;
import com.efuture.business.bean.ModeDetailsVo;
import com.efuture.business.bean.SellType;
import com.efuture.business.bean.YPopStatusType;
import com.efuture.business.javaPos.commonkit.CountZZK;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.javaPos.commonkit.PosLogicCompomentImpl;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.Goods;
import com.efuture.business.javaPos.struct.OperUser;
import com.efuture.business.javaPos.struct.PayMode;
import com.efuture.business.javaPos.struct.Payment;
import com.efuture.business.javaPos.struct.PopDetail;
import com.efuture.business.model.Syspara;
import com.efuture.business.util.DataExchageUtils;
import com.efuture.business.util.UniqueID;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PosLogicCompomentImpl_TZCS
extends PosLogicCompomentImpl {
    private static final Logger log = LoggerFactory.getLogger(PosLogicCompomentImpl_TZCS.class);

    @Override
    public Payment createChangePayment(double changeValue, Payment payment, CacheModel cacheModel) {
        PayMode payMode = cacheModel.getPayMode();
        Payment p = new Payment();
        p.setFlag("2");
        p.setPuid(String.valueOf(UniqueID.getUniqueID()));
        p.setRownoId(p.getPuid());
        p.setRowno(payment.getRowno() + 1);
        p.setRownoId("");
        p.setPayCode(payMode.getPayCode());
        if (payMode.getPayName().matches("[a-zA-Z0-9]+")) {
            p.setPayName("Change");
        } else {
            p.setPayName(payMode.getPayName() + " \u627e\u96f6");
        }
        if (0.0 == payMode.getRate()) {
            p.setRate(1.0);
        } else {
            p.setRate(payMode.getRate());
        }
        p.setChargeRate(payMode.getRate());
        p.setTerminalNo(cacheModel.getOrder().getTerminalNo());
        p.setTerminalSno(cacheModel.getOrder().getTerminalSno());
        p.setPayType(payMode.getPayType());
        p.setPrcutMode(payMode.getRoundType());
        p.setPrecision(payMode.getRoundPrecision());
        String prcutMode = DataExchageUtils.exchangePrecisionMode(p.getPrcutMode());
        p.setAmount(ManipulatePrecision.getMoneyByPrecision(changeValue, prcutMode, p.getPrecision()));
        p.setMoney(ManipulatePrecision.getMoneyByPrecision(changeValue, prcutMode, p.getPrecision()));
        p.setOverage(0.0);
        p.setRoundUpOverageValue(0.0);
        return p;
    }

    @Override
    public CacheModel editGoodsPrice(CacheModel cacheModel, int flow_id, String accreditNo, double price) {
        Goods sg = cacheModel.getGoodsList().get(flow_id - 1);
        if (null == sg) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("20148");
            cacheModel.setErrMsg("\u67e5\u4e0d\u5230\u5546\u54c1\u4fe1\u606f");
            return cacheModel;
        }
        log.info("isR10isJFHG>>>>>>>" + sg.isR10isJFHG());
        if (!SellType.ISBACK(cacheModel.getOrder().getOrderType())) {
            if (!(sg.isR10isJFHG() || null != cacheModel.getCurGrant().getPrivgj() && "Y".equals(cacheModel.getCurGrant().getPrivgj()))) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrCode("20160");
                cacheModel.setErrMsg("\u5f53\u524d\u4eba\u5458\u65e0\u6539\u4ef7\u6743\u9650");
                return cacheModel;
            }
        } else if (StringUtils.isNotBlank((String)cacheModel.getOrder().getOriginTerminalSno())) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("20150");
            cacheModel.setErrMsg("\u6307\u5b9a\u5c0f\u7968\u9000\u8d27\u4e0d\u5141\u8bb8\u6539\u4ef7");
            return cacheModel;
        }
        if (price < 0.0) {
            return cacheModel;
        }
        if (null != cacheModel.getOrder().getOriginTerminalNo() && null != cacheModel.getOrder().getOriginTerminalSno()) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("20161");
            cacheModel.setErrMsg("\u6307\u5b9a\u5c0f\u7968\u9000\u8d27\u4e0d\u5141\u8bb8\u4fee\u6539\u5546\u54c1\u4ef7\u683c");
            return cacheModel;
        }
        if (sg.getEscaleFlag().equals("Y")) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("20151");
            cacheModel.setErrMsg("\u7535\u5b50\u79e4\u5546\u54c1\u4e0d\u5141\u8bb8\u4fee\u6539\u4ef7\u683c");
            return cacheModel;
        }
        if (sg.getFlag().equals("0")) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("20152");
            cacheModel.setErrMsg("\u8d60\u54c1\u4e0d\u5141\u8bb8\u4fee\u6539\u4ef7\u683c");
            return cacheModel;
        }
        if (null != sg.getSGoodsSno() && sg.getSGoodsSno().length() > 0) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("20153");
            cacheModel.setErrMsg("\u5957\u9910\u5546\u54c1\u4e0d\u5141\u8bb8\u4fee\u6539\u4ef7\u683c");
            return cacheModel;
        }
        String obj = this.redisUtil.get("business:initialize:cacheid:" + cacheModel.getOrder().getShopCode() + cacheModel.getOrder().getTerminalNo());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj.toString(), ModeDetailsVo.class);
        List<Syspara> syspara = modeDetailsVo.getSyspara();
        String grantMode = ModeDetailsVo.getSysParaValue(syspara, "SQMS");
        if (!(sg.isR10isJFHG() || SellType.ISBACK(cacheModel.getOrder().getOrderType()) || this.checkGoodsGrantRange(sg, cacheModel.getCurGrant().getGrantgzs(), grantMode))) {
            cacheModel.setErrCode("20162");
            cacheModel.setCalcResult(-1);
            cacheModel.setErrMsg("\u5f53\u524d\u6388\u6743\u8303\u56f4\u4e0d\u5141\u8bb8\u4fee\u6539\u5546\u54c1\u4ef7\u683c");
            return cacheModel;
        }
        sg = cacheModel.getGoodsList().get(flow_id - 1);
        Goods oldsg = (Goods)sg.clone();
        String precisionMode = DataExchageUtils.exchangePrecisionMode(sg.getPrcutMode());
        try {
            double newPrice = ManipulatePrecision.getDetailOverFlow(price, sg.getPrcutMode());
            if (null != sg.getGoodsType() && !sg.getGoodsType().equals("P") && !sg.getGoodsType().equals("Z") && !sg.getGoodsType().equals("15") && newPrice <= 0.0) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrCode("20156");
                cacheModel.setErrMsg("\u8be5\u5546\u54c1\u4ef7\u683c\u5fc5\u987b\u5927\u4e8e0");
                return cacheModel;
            }
            if (newPrice < sg.getMinSalePrice()) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrCode("20157");
                cacheModel.setErrMsg(ManipulatePrecision.doubleToString(sg.getMinSalePrice()));
                return cacheModel;
            }
            if (!(sg.isR10isJFHG() || SellType.ISBACK(cacheModel.getOrder().getOrderType()) && StringUtils.isBlank((String)cacheModel.getOrder().getOriginTerminalSno()) || !(newPrice < sg.getListPrice() * cacheModel.getCurGrant().getAdjustLow()) && !(newPrice > sg.getListPrice() * cacheModel.getCurGrant().getAdjustUpper()))) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrCode("20163");
                cacheModel.setErrMsg(ManipulatePrecision.doubleToString(cacheModel.getCurGrant().getAdjustLow()) + "~" + ManipulatePrecision.doubleToString(cacheModel.getCurGrant().getAdjustUpper()));
                return cacheModel;
            }
            sg.setSalePrice(ManipulatePrecision.getDetailOverFlow(newPrice, sg.getPrcutMode()));
            if (!"Y".equals(sg.getEscaleFlag())) {
                sg.setSaleValue(ManipulatePrecision.getDetailOverFlow(sg.getQty() * sg.getSalePrice(), precisionMode));
            } else {
                sg.setQty(ManipulatePrecision.doubleConvert(sg.getEWCCodeAmount() / sg.getSalePrice(), 4, 1));
                sg.setQtyrecalc(0);
                sg.setSaleValue(sg.getEWCCodeAmount());
                sg.setPopDiscountValue(0.0);
            }
            sg.setTempZkl(100.0);
            sg.setDiscAmount(0.0);
            sg.setTempZkDiscount(0.0);
            sg.setTempZrDiscount(0.0);
            sg.setTempZzkDiscount(0.0);
            sg.setTempZzrDiscount(0.0);
            sg.setFixedDiscountValue(0.0);
            sg.setAdjustDiscountValue(this.getAdjustDiscount(sg));
            sg.setPopDiscountValue(0.0);
            sg.getPopDetailsInfo().clear();
            sg.setTotalDiscountValue(CountZZK.getZZK(sg));
            sg.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sg.getTotalDiscountValue() - sg.getNoDisAmountValue()));
            sg.setSaleAmount(sg.getSaleValue() - sg.getTotalDiscountValue());
            cacheModel.getGoodsList().set(flow_id - 1, sg);
            cacheModel.getOrder().setTerminalOperatorAuthzCardNo(accreditNo);
            this.calcOrderAmount(cacheModel);
            return cacheModel;
        }
        catch (Exception e) {
            e.printStackTrace();
            cacheModel.getGoodsList().set(flow_id - 1, oldsg);
            return cacheModel;
        }
    }

    @Override
    public CacheModel calcGoodsRebateByRate(CacheModel cacheModel, int flow_id, String accreditNo, double discountRate, boolean isCheck) {
        log.info("\u5355\u54c1\u6298\u6263discountRate={}", (Object)discountRate);
        if (null != cacheModel.getOrder().getOriginTerminalNo() && null != cacheModel.getOrder().getOriginTerminalSno()) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("20165");
            cacheModel.setErrMsg("\u6307\u5b9a\u5c0f\u7968\u9000\u8d27\u4e0d\u5141\u8bb8\u6298\u6263");
            return cacheModel;
        }
        if (ManipulatePrecision.doubleCompare(discountRate, 0.0, 2) < 0) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("20186");
            cacheModel.setErrMsg("\u6298\u6263\u7387\u8d85\u8fc7100%\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
            return cacheModel;
        }
        Goods sg = cacheModel.getGoodsList().get(flow_id - 1);
        String flag = sg.getFlag();
        if (flag.equals("0") || sg.getMinDiscount() * 100.0 >= 100.0 || StringUtils.isNotBlank((String)sg.getSGoodsSno()) || 1 == cacheModel.getOrder().getSysPara().getAdjustMode() && sg.getPopDiscountValue() > 0.0) {
            cacheModel.setErrMsg("\u8be5\u5546\u54c1\u4e0d\u5141\u8bb8\u6253\u6298");
            cacheModel.setErrCode("20181");
            cacheModel.setCalcResult(-1);
            return cacheModel;
        }
        OperUser curGrant = cacheModel.getCurGrant();
        if (!isCheck && null != cacheModel.getCurTempGrant() && StringUtils.isNotEmpty((String)cacheModel.getCurTempGrant().getGh())) {
            curGrant = cacheModel.getCurTempGrant();
        }
        String obj = this.redisUtil.get("business:initialize:cacheid:" + cacheModel.getOrder().getShopCode() + cacheModel.getOrder().getTerminalNo());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj.toString(), ModeDetailsVo.class);
        List<Syspara> syspara = modeDetailsVo.getSyspara();
        String grantMode = ModeDetailsVo.getSysParaValue(syspara, "SQMS");
        if (isCheck && !this.checkGoodsGrantRange(sg, curGrant.getGrantgzs(), grantMode)) {
            cacheModel.setErrCode("20179");
            cacheModel.setCalcResult(-1);
            cacheModel.setErrMsg("\u5f53\u524d\u6388\u6743\u8303\u56f4\u65e0\u6cd5\u5bf9\u8be5\u5546\u54c1\u8fdb\u884c\u6253\u6298");
            return cacheModel;
        }
        if (!this.checkVipzk(curGrant, sg)) {
            cacheModel.setErrCode("20180");
            cacheModel.setCalcResult(-1);
            cacheModel.setErrMsg("\u5f53\u524d\u6388\u6743\u65e0\u6cd5\u5bf9\u9ec4\u7801\u5546\u54c1\u8fdb\u884c\u6253\u6298");
            return cacheModel;
        }
        sg = cacheModel.getGoodsList().get(flow_id - 1);
        Goods oldsg = sg.deepClone();
        double tempZr = oldsg.getTempZrDiscount();
        if (ManipulatePrecision.doubleCompare(discountRate, 0.0, 2) <= 0) {
            sg.setTempZkDiscount(0.0);
            sg.setAdjustDiscountValue(this.getAdjustDiscount(sg));
            sg.setTotalDiscountValue(CountZZK.getNoPrcutZZK(sg));
            sg.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sg.getTotalDiscountValue() - sg.getNoDisAmountValue()));
            sg.setSaleAmount(sg.getSaleValue() - sg.getTotalDiscountValue());
            sg.setTempZkl(100.0);
            cacheModel.getGoodsList().set(flow_id - 1, sg);
            this.calcOrderAmount(cacheModel);
            if (cacheModel.getOrder().getTempZzk() != 0.0) {
                cacheModel = this.calcOrderRebateByRate(cacheModel, accreditNo, 0.0);
            }
            if (cacheModel.getOrder().getTempZzr() != 0.0) {
                cacheModel = this.calcOrderRebateByAmount(cacheModel, accreditNo, 0.0);
            }
            return cacheModel;
        }
        if (isCheck && curGrant.getPrivdpzkl() <= 0.0) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("20149");
            cacheModel.setErrMsg("\u5f53\u524d\u4eba\u5458\u65e0\u6253\u6298\u6743\u9650");
            return cacheModel;
        }
        String precisionMode = DataExchageUtils.exchangePrecisionMode(sg.getPrcutMode());
        try {
            sg.setTempZrDiscount(0.0);
            sg.setTempZkDiscount(0.0);
            sg.setTempZzkDiscount(0.0);
            sg.setTempZzrDiscount(0.0);
            sg.setAdjustDiscountValue(this.getAdjustDiscount(sg));
            double maxDiscount = ManipulatePrecision.getDetailOverFlow((1.0 - sg.getMinDiscount()) * (sg.getSaleValue() - CountZZK.getNoPrcutZZK(sg)), precisionMode);
            sg.setTempZkDiscount(maxDiscount);
            sg.setAdjustDiscountValue(this.getAdjustDiscount(sg));
            if (CountZZK.getNoPrcutZZK(sg) > ManipulatePrecision.getDetailOverFlow(sg.getSaleValue() * (1.0 - sg.getMinDiscount()), precisionMode)) {
                sg.setTempZkDiscount(sg.getTempZkDiscount() - CountZZK.getNoPrcutZZK(sg) + ManipulatePrecision.getDetailOverFlow(sg.getSaleValue() * (1.0 - sg.getMinDiscount()), precisionMode));
                sg.setTempZkDiscount(ManipulatePrecision.getDetailOverFlow(sg.getTempZkDiscount(), precisionMode));
            }
            if (sg.getTempZkDiscount() < 0.0) {
                sg.setTempZkDiscount(0.0);
            }
            sg.setAdjustDiscountValue(this.getAdjustDiscount(sg));
            double MaxDiscountRate = sg.getTempZkDiscount() / (sg.getSaleValue() - CountZZK.getNoPrcutZZK(sg) + sg.getTempZkDiscount());
            MaxDiscountRate = ManipulatePrecision.doubleConvert((1.0 - MaxDiscountRate) * 100.0, 2, 1);
            boolean isExceed = false;
            if (2 == cacheModel.getOrder().getSysPara().getAdjustMode()) {
                if (ManipulatePrecision.doubleCompare(sg.getMinDiscount() * 100.0, 100.0 - discountRate, 2) > 0) {
                    isExceed = true;
                    MaxDiscountRate = ManipulatePrecision.doubleConvert(sg.getMinDiscount() * 100.0);
                }
            } else if (ManipulatePrecision.doubleCompare(MaxDiscountRate, 100.0 - discountRate, 2) > 0) {
                isExceed = true;
            }
            log.info("isExceed=====>" + isExceed);
            if (isExceed) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrCode("20177");
                cacheModel.setErrMsg(String.valueOf(MaxDiscountRate));
                cacheModel.getGoodsList().set(flow_id - 1, oldsg);
                return cacheModel;
            }
            log.info("isCheck=====>" + isCheck);
            if (isCheck && ManipulatePrecision.doubleCompare(curGrant.getPrivdpzkl(), discountRate, 2) < 0) {
                cacheModel.setErrCode("20178");
                cacheModel.setCalcResult(-1);
                cacheModel.setErrMsg(String.valueOf(curGrant.getCardno()));
                cacheModel.getGoodsList().set(flow_id - 1, oldsg);
                return cacheModel;
            }
            sg.setTempZkDiscount(0.0);
            sg.setAdjustDiscountValue(this.getAdjustDiscount(sg));
            if (2 == cacheModel.getOrder().getSysPara().getAdjustMode()) {
                sg.setTempZkDiscount(ManipulatePrecision.getDetailOverFlow(discountRate / 100.0 * sg.getSaleValue() - CountZZK.getNoPrcutZZK(sg), precisionMode));
            } else {
                sg.setTempZkDiscount(ManipulatePrecision.getDetailOverFlow(discountRate / 100.0 * (sg.getSaleValue() - CountZZK.getNoPrcutZZK(sg)), precisionMode));
            }
            sg.setAdjustDiscountValue(this.getAdjustDiscount(sg));
            log.info("discountRate=\u3010{}\u3011,getNoPrcutZZK=\u3010{}\u3011.salevalue=\u3010{}\u3011,MaxDiscountRate = \u3010{}\u3011", new Object[]{discountRate, CountZZK.getNoPrcutZZK(sg), sg.getSaleValue(), MaxDiscountRate});
            double maxtempDisc = 0.0;
            maxtempDisc = 2 == cacheModel.getOrder().getSysPara().getAdjustMode() ? ManipulatePrecision.getDetailOverFlow(sg.getSaleValue() * (1.0 - sg.getMinDiscount()), precisionMode) : ManipulatePrecision.getDetailOverFlow(sg.getSaleValue() * (100.0 - MaxDiscountRate) / 100.0, precisionMode);
            log.info("maxtempDisc>>>>>" + maxtempDisc);
            log.info("MemberPrice>>>>>" + sg.getMemberPrice());
            double barcodeDiscount = ManipulatePrecision.getDetailOverFlow((sg.getListPrice() - sg.getMemberPrice()) * sg.getQty(), precisionMode);
            log.info("BarcodeDiscount>>>>>" + barcodeDiscount);
            if (null != cacheModel.getOrder().getConsumersData() && StringUtils.isNotEmpty((String)cacheModel.getOrder().getConsumersData().getConsumersCard())) {
                if (sg.getMemberPrice() > 0.0 && barcodeDiscount > 0.0 && barcodeDiscount > maxtempDisc) {
                    cacheModel.setCalcResult(-1);
                    cacheModel.setErrCode("20189");
                    cacheModel.setErrMsg("\u5f53\u524d\u4f1a\u5458\u6298\u6263\u4f4e\u4e8e\u624b\u5de5\u6298\u6263");
                    cacheModel.getGoodsList().set(flow_id - 1, oldsg);
                    return cacheModel;
                }
                log.info("\u6e05\u9664\u4f1a\u5458\u6298\u6263");
                sg.setBarcodeDiscount(0.0);
                sg.setDisMode(0);
                sg.setDiscType("");
                sg.setDisValue(0.0);
                if (null != sg.getPopDetailsInfo() && sg.getPopDetailsInfo().size() > 0) {
                    for (int i = 0; i < sg.getPopDetailsInfo().size(); ++i) {
                        PopDetail pop = sg.getPopDetailsInfo().get(i);
                        if (!YPopStatusType.pop_policy_group_barcode_discB.equals(pop.getPopPolicyGroup())) continue;
                        sg.getPopDetailsInfo().remove(i);
                        --i;
                    }
                }
                sg.setAdjustDiscountValue(this.getAdjustDiscount(sg));
                sg.setTotalDiscountValue(CountZZK.getZZK(sg));
                sg.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sg.getTotalDiscountValue() - sg.getNoDisAmountValue()));
                sg.setSaleAmount(sg.getSaleValue() - sg.getTotalDiscountValue());
            }
            if (CountZZK.getNoPrcutZZK(sg) > maxtempDisc) {
                sg.setTempZkDiscount(ManipulatePrecision.getDetailOverFlow(sg.getTempZkDiscount() - CountZZK.getNoPrcutZZK(sg) + maxtempDisc, precisionMode));
            }
            if (sg.getTempZkDiscount() < 0.0) {
                sg.setTempZkDiscount(0.0);
            }
            sg.setAdjustDiscountValue(this.getAdjustDiscount(sg));
            sg.setTotalDiscountValue(CountZZK.getNoPrcutZZK(sg));
            sg.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sg.getTotalDiscountValue() - sg.getNoDisAmountValue()));
            sg.setSaleAmount(sg.getSaleValue() - sg.getTotalDiscountValue());
            if (sg.getTempZkDiscount() > 0.0) {
                sg.setTempZkl(ManipulatePrecision.doubleConvert(discountRate, 2, 1));
            }
            if (isCheck) {
                cacheModel.getOrder().setTerminalOperatorAuthzCardNo(accreditNo);
            }
            cacheModel.getGoodsList().set(flow_id - 1, sg);
            if (tempZr > 0.0) {
                cacheModel = this.calcGoodsRebateByAmount(cacheModel, flow_id, accreditNo, tempZr);
            } else if (!"2".equals(cacheModel.getOrder().getSysPara().getOrderDiscSeq())) {
                if (cacheModel.getOrder().getTempZzk() != 0.0) {
                    cacheModel = this.calcOrderRebateByRate(cacheModel, accreditNo, 0.0);
                }
                if (cacheModel.getOrder().getTempZzr() != 0.0) {
                    cacheModel = this.calcOrderRebateByAmount(cacheModel, accreditNo, 0.0);
                }
            }
            cacheModel.setCalcResult(0);
            cacheModel.setErrMsg("");
            this.calcOrderAmount(cacheModel);
            if (isCheck && sg.getTempZkDiscount() == 0.0) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrCode("20185");
                cacheModel.setErrMsg("\u7279\u4ef7\u5546\u54c1\u4e0d\u5141\u8bb8\u6253\u6298");
                cacheModel.getGoodsList().set(flow_id - 1, oldsg);
                return cacheModel;
            }
            if (isCheck) {
                cacheModel = this.addMarketzk(cacheModel, flow_id);
            }
            return cacheModel;
        }
        catch (Exception e) {
            e.printStackTrace();
            cacheModel.getGoodsList().set(flow_id - 1, oldsg);
            return cacheModel;
        }
    }

    @Override
    public CacheModel calcGoodsRebateByAmount(CacheModel cacheModel, int flow_id, String accreditNo, double discountAmount, int mode, boolean isZero, boolean isCheck) {
        if (null != cacheModel.getOrder().getOriginTerminalNo() && null != cacheModel.getOrder().getOriginTerminalSno()) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("20165");
            cacheModel.setErrMsg("\u6307\u5b9a\u5c0f\u7968\u9000\u8d27\u4e0d\u5141\u8bb8\u6298\u6263");
            return cacheModel;
        }
        if (discountAmount < 0.0) {
            return cacheModel;
        }
        if (ManipulatePrecision.doubleCompare(discountAmount, 0.0, 2) < 0) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("20169");
            cacheModel.setErrMsg("\u6298\u8ba9\u91d1\u989d\u4e0d\u5141\u8bb8\u5c0f\u4e8e0");
            return cacheModel;
        }
        Goods sg = cacheModel.getGoodsList().get(flow_id - 1);
        String flag = sg.getFlag();
        double disAmount = 0.0;
        if (mode == 1) {
            disAmount = discountAmount;
            discountAmount = ManipulatePrecision.doubleConvert(sg.getSaleAmount() + sg.getTempZrDiscount() + sg.getTempZzrDiscount() + sg.getTempZzkDiscount() - discountAmount);
        }
        if (flag.equals("0") || sg.getMinDiscount() * 100.0 >= 100.0 || !StringUtils.isBlank((String)sg.getSGoodsSno()) || 1 == cacheModel.getOrder().getSysPara().getAdjustMode() && sg.getPopDiscountValue() > 0.0) {
            cacheModel.setErrMsg("\u8be5\u5546\u54c1\u4e0d\u5141\u8bb8\u6253\u6298");
            cacheModel.setErrCode("20181");
            cacheModel.setCalcResult(-1);
            return cacheModel;
        }
        OperUser curGrant = cacheModel.getCurGrant();
        if (!isCheck && null != cacheModel.getCurTempGrant() && StringUtils.isNotEmpty((String)cacheModel.getCurTempGrant().getGh())) {
            curGrant = cacheModel.getCurTempGrant();
        }
        String obj = this.redisUtil.get("business:initialize:cacheid:" + cacheModel.getOrder().getShopCode() + cacheModel.getOrder().getTerminalNo());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj.toString(), ModeDetailsVo.class);
        List<Syspara> syspara = modeDetailsVo.getSyspara();
        String grantMode = ModeDetailsVo.getSysParaValue(syspara, "SQMS");
        if (isCheck && !this.checkGoodsGrantRange(sg, curGrant.getGrantgzs(), grantMode)) {
            cacheModel.setErrCode("1000");
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("20182");
            cacheModel.setErrMsg("\u5f53\u524d\u6388\u6743\u65e0\u6cd5\u5bf9\u8be5\u5546\u54c1\u8fdb\u884c\u6253\u6298");
            return cacheModel;
        }
        if (!this.checkVipzk(curGrant, sg)) {
            cacheModel.setErrCode("20180");
            cacheModel.setCalcResult(-1);
            cacheModel.setErrMsg("\u5f53\u524d\u6388\u6743\u65e0\u6cd5\u5bf9\u9ec4\u7801\u5546\u54c1\u8fdb\u884c\u6253\u6298");
            return cacheModel;
        }
        sg = cacheModel.getGoodsList().get(flow_id - 1);
        Goods oldsg = (Goods)sg.clone();
        if (ManipulatePrecision.doubleCompare(discountAmount, 0.0, 2) == 0) {
            sg.setDiscAmount(0.0);
            sg.setTempZrDiscount(0.0);
            sg.setTempZkl(100.0);
            sg.setAdjustDiscountValue(this.getAdjustDiscount(sg));
            sg.setTotalDiscountValue(CountZZK.getNoPrcutZZK(sg));
            sg.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sg.getTotalDiscountValue() - sg.getNoDisAmountValue()));
            sg.setSaleAmount(sg.getSaleValue() - sg.getTotalDiscountValue());
            cacheModel.getGoodsList().set(flow_id - 1, sg);
            this.calcOrderAmount(cacheModel);
            if (cacheModel.getOrder().getTempZzk() != 0.0) {
                cacheModel = this.calcOrderRebateByRate(cacheModel, accreditNo, 0.0);
            }
            if (cacheModel.getOrder().getTempZzr() != 0.0) {
                cacheModel = this.calcOrderRebateByAmount(cacheModel, accreditNo, 0.0);
            }
            return cacheModel;
        }
        if (isCheck && curGrant.getPrivdpzkl() <= 0.0) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("20149");
            cacheModel.setErrMsg("\u5f53\u524d\u4eba\u5458\u65e0\u6253\u6298\u6743\u9650");
            return cacheModel;
        }
        String precisionMode = DataExchageUtils.exchangePrecisionMode(sg.getPrcutMode());
        try {
            double MaxDiscountRate = 1.0 - sg.getMinDiscount();
            double MaxDiscountAmount = ManipulatePrecision.getDetailOverFlow(MaxDiscountRate * sg.getSaleValue(), precisionMode);
            double tempZrAmount = MaxDiscountAmount - CountZZK.getNoPrcutZZK(sg) + sg.getTempZrDiscount() + sg.getTempZzkDiscount() + sg.getTempZzrDiscount();
            tempZrAmount = ManipulatePrecision.getDetailOverFlow(tempZrAmount, precisionMode);
            if (tempZrAmount < 0.0) {
                tempZrAmount = 0.0;
            }
            boolean isExceed = false;
            if (1 != mode && 2 == cacheModel.getOrder().getSysPara().getAdjustMode()) {
                if (discountAmount > MaxDiscountAmount) {
                    if (!isZero) {
                        isExceed = true;
                        tempZrAmount = MaxDiscountAmount;
                    }
                    discountAmount = tempZrAmount;
                }
            } else if (discountAmount > tempZrAmount) {
                if (!isZero) {
                    isExceed = true;
                }
                discountAmount = tempZrAmount;
            }
            if (isExceed) {
                cacheModel.setErrCode("20183");
                cacheModel.setErrMsg(String.valueOf(tempZrAmount));
                cacheModel.setCalcResult(-1);
                cacheModel.getGoodsList().set(flow_id - 1, oldsg);
                return cacheModel;
            }
            if (isCheck) {
                double GrantDiscountRate = ManipulatePrecision.doubleConvert(curGrant.getPrivdpzkl() / 100.0, 2, 1);
                if (MaxDiscountRate > GrantDiscountRate) {
                    MaxDiscountRate = GrantDiscountRate;
                }
                MaxDiscountAmount = ManipulatePrecision.getDetailOverFlow(MaxDiscountRate * sg.getSaleValue(), precisionMode);
                tempZrAmount = MaxDiscountAmount - CountZZK.getNoPrcutZZK(sg) + sg.getTempZrDiscount() + sg.getTempZzkDiscount() + sg.getTempZzrDiscount();
                if (discountAmount > (tempZrAmount = ManipulatePrecision.getDetailOverFlow(tempZrAmount, precisionMode))) {
                    discountAmount = tempZrAmount;
                    cacheModel.setErrCode("20184");
                    cacheModel.setErrMsg(String.valueOf(curGrant.getPrivdpzkl()));
                    cacheModel.setCalcResult(-1);
                    cacheModel.getGoodsList().set(flow_id - 1, oldsg);
                    return cacheModel;
                }
            }
            discountAmount = ManipulatePrecision.getDetailOverFlow(discountAmount, precisionMode);
            log.info("discountAmount>>>>>" + discountAmount);
            log.info("MemberPrice>>>>>" + sg.getMemberPrice());
            double barcodeDiscount = ManipulatePrecision.getDetailOverFlow((sg.getListPrice() - sg.getMemberPrice()) * sg.getQty(), precisionMode);
            log.info("BarcodeDiscount>>>>>" + barcodeDiscount);
            if (null != cacheModel.getOrder().getConsumersData() && StringUtils.isNotEmpty((String)cacheModel.getOrder().getConsumersData().getConsumersCard())) {
                if (sg.getMemberPrice() > 0.0 && barcodeDiscount > 0.0 && barcodeDiscount > discountAmount) {
                    cacheModel.setCalcResult(-1);
                    cacheModel.setErrCode("20189");
                    cacheModel.setErrMsg("\u5f53\u524d\u4f1a\u5458\u6298\u6263\u4f4e\u4e8e\u624b\u5de5\u6298\u6263");
                    cacheModel.getGoodsList().set(flow_id - 1, oldsg);
                    return cacheModel;
                }
                log.info("\u6e05\u9664\u4f1a\u5458\u6298\u6263");
                sg.setBarcodeDiscount(0.0);
                sg.setDisMode(0);
                sg.setDiscType("");
                sg.setDisValue(0.0);
                if (null != sg.getPopDetailsInfo() && sg.getPopDetailsInfo().size() > 0) {
                    for (int i = 0; i < sg.getPopDetailsInfo().size(); ++i) {
                        PopDetail pop = sg.getPopDetailsInfo().get(i);
                        if (!YPopStatusType.pop_policy_group_barcode_discB.equals(pop.getPopPolicyGroup())) continue;
                        sg.getPopDetailsInfo().remove(i);
                        --i;
                    }
                }
                sg.setAdjustDiscountValue(this.getAdjustDiscount(sg));
                sg.setTotalDiscountValue(CountZZK.getZZK(sg));
                sg.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sg.getTotalDiscountValue() - sg.getNoDisAmountValue()));
                sg.setSaleAmount(sg.getSaleValue() - sg.getTotalDiscountValue());
            }
            sg.setTempZrDiscount(discountAmount);
            sg.setAdjustDiscountValue(this.getAdjustDiscount(sg));
            sg.setDiscAmount(disAmount);
            if (CountZZK.getNoPrcutZZK(sg) > MaxDiscountAmount) {
                sg.setTempZrDiscount(sg.getTempZrDiscount() - CountZZK.getNoPrcutZZK(sg) + MaxDiscountAmount);
                sg.setTempZrDiscount(ManipulatePrecision.getDetailOverFlow(sg.getTempZrDiscount(), precisionMode));
            }
            if (sg.getTempZrDiscount() < 0.0) {
                sg.setTempZrDiscount(0.0);
            }
            sg.setAdjustDiscountValue(this.getAdjustDiscount(sg));
            sg.setTotalDiscountValue(CountZZK.getNoPrcutZZK(sg));
            sg.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sg.getTotalDiscountValue() - sg.getNoDisAmountValue()));
            sg.setSaleAmount(sg.getSaleValue() - sg.getTotalDiscountValue());
            if (isCheck) {
                cacheModel.getOrder().setTerminalOperatorAuthzCardNo(accreditNo);
            }
            cacheModel.getGoodsList().set(flow_id - 1, sg);
            if (!"2".equals(cacheModel.getOrder().getSysPara().getOrderDiscSeq())) {
                if (cacheModel.getOrder().getTempZzk() > 0.0) {
                    cacheModel = this.calcOrderRebateByRate(cacheModel, accreditNo, 0.0);
                }
                if (cacheModel.getOrder().getTempZzr() > 0.0) {
                    cacheModel = this.calcOrderRebateByAmount(cacheModel, accreditNo, 0.0);
                }
            }
            cacheModel.setCalcResult(0);
            cacheModel.setErrMsg("");
            this.calcOrderAmount(cacheModel);
            if (isCheck && sg.getTempZrDiscount() == 0.0) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrCode("20185");
                cacheModel.setErrMsg("\u7279\u4ef7\u5546\u54c1\u4e0d\u5141\u8bb8\u6253\u6298");
                cacheModel.getGoodsList().set(flow_id - 1, oldsg);
                return cacheModel;
            }
            if (isCheck) {
                cacheModel = this.addMarketzk(cacheModel, flow_id);
            }
            return cacheModel;
        }
        catch (Exception e) {
            e.printStackTrace();
            cacheModel.getGoodsList().set(flow_id - 1, oldsg);
            return cacheModel;
        }
    }
}

