/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.javaPos.struct.myshopr10;

import com.alibaba.fastjson.JSONObject;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.Payment;
import com.efuture.business.javaPos.struct.myshopr10.R10PointAccIn;
import java.io.Serializable;

public class R10PointAcc
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String vtype;
    private Long vseqno;
    private String posid;
    private String sheetno;
    private Long listno;
    private String mkt;
    private String cashierid;
    private String cardno;
    private String password;
    private String paycode;
    private Double point;
    private Double salevalue;
    private String notes;

    public R10PointAcc(CacheModel cacheModel, R10PointAccIn r10PointAccIn, String vtype) {
        this.vtype = vtype;
        this.vseqno = r10PointAccIn.getSqno();
        this.mkt = cacheModel.getOrder().getShopCode();
        this.posid = cacheModel.getOrder().getTerminalNo();
        this.sheetno = cacheModel.getOrder().getFlowNo();
        this.listno = Long.parseLong(cacheModel.getOrder().getTerminalSno());
        this.cashierid = cacheModel.getOrder().getTerminalOperator();
        this.cardno = cacheModel.getOrder().getConsumersData().getConsumersCard();
        this.password = "";
        this.paycode = r10PointAccIn.getPayCode();
        this.point = r10PointAccIn.getPoint();
        this.salevalue = ManipulatePrecision.mul(r10PointAccIn.getPoint(), r10PointAccIn.getPointRate());
        this.notes = "";
    }

    public R10PointAcc(CacheModel cacheModel, Payment payment, String vtype) {
        this.vtype = vtype;
        this.vseqno = Long.parseLong(payment.getRefCode());
        this.mkt = cacheModel.getOrder().getShopCode();
        this.posid = cacheModel.getOrder().getTerminalNo();
        this.sheetno = cacheModel.getOrder().getFlowNo();
        this.listno = Long.parseLong(cacheModel.getOrder().getTerminalSno());
        this.cashierid = cacheModel.getOrder().getTerminalOperator();
        this.cardno = cacheModel.getOrder().getConsumersData().getConsumersCard();
        this.password = "";
        this.paycode = payment.getPayCode();
        this.point = "R10POINTVIRTUE".equals(payment.getPayMemo()) ? Double.valueOf(payment.getCashCost()) : Double.valueOf(payment.getAmount());
        this.salevalue = payment.getMoney();
        this.notes = "";
    }

    public R10PointAcc(JSONObject jsonObject, String vtype) {
        this.vtype = jsonObject.getString("type");
        this.vseqno = jsonObject.getLong("seqno");
        this.mkt = jsonObject.getString("shopCode");
        this.posid = jsonObject.getString("terminalNo");
        this.sheetno = jsonObject.getString("flowNo");
        this.listno = jsonObject.getLong("terminalSno");
        this.cashierid = jsonObject.getString("terminalOperator");
        this.cardno = jsonObject.getString("consumersCard");
        this.password = "";
        this.paycode = jsonObject.getString("payCode");
        this.point = jsonObject.getDouble("point");
        this.salevalue = jsonObject.getDouble("amount");
        this.notes = "";
    }

    public R10PointAcc(CacheModel cacheModel, R10PointAccIn r10PointAccIn, Payment payment, String vtype) {
        this.vtype = vtype;
        this.vseqno = r10PointAccIn.getSqno();
        this.mkt = cacheModel.getOrder().getShopCode();
        this.posid = cacheModel.getOrder().getTerminalNo();
        this.sheetno = cacheModel.getOrder().getFlowNo();
        this.listno = Long.parseLong(cacheModel.getOrder().getTerminalSno());
        this.cashierid = cacheModel.getOrder().getTerminalOperator();
        this.cardno = cacheModel.getOrder().getConsumersData().getConsumersCard();
        this.password = "";
        this.paycode = r10PointAccIn.getPayCode();
        this.point = "R10POINTVIRTUE".equals(payment.getPayMemo()) ? Double.valueOf(payment.getCashCost()) : Double.valueOf(payment.getAmount());
        this.salevalue = ManipulatePrecision.mul(r10PointAccIn.getPoint(), payment.getRate());
        this.notes = "";
    }

    public String getVtype() {
        return this.vtype;
    }

    public Long getVseqno() {
        return this.vseqno;
    }

    public String getPosid() {
        return this.posid;
    }

    public String getSheetno() {
        return this.sheetno;
    }

    public Long getListno() {
        return this.listno;
    }

    public String getMkt() {
        return this.mkt;
    }

    public String getCashierid() {
        return this.cashierid;
    }

    public String getCardno() {
        return this.cardno;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPaycode() {
        return this.paycode;
    }

    public Double getPoint() {
        return this.point;
    }

    public Double getSalevalue() {
        return this.salevalue;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setVtype(String vtype) {
        this.vtype = vtype;
    }

    public void setVseqno(Long vseqno) {
        this.vseqno = vseqno;
    }

    public void setPosid(String posid) {
        this.posid = posid;
    }

    public void setSheetno(String sheetno) {
        this.sheetno = sheetno;
    }

    public void setListno(Long listno) {
        this.listno = listno;
    }

    public void setMkt(String mkt) {
        this.mkt = mkt;
    }

    public void setCashierid(String cashierid) {
        this.cashierid = cashierid;
    }

    public void setCardno(String cardno) {
        this.cardno = cardno;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPaycode(String paycode) {
        this.paycode = paycode;
    }

    public void setPoint(Double point) {
        this.point = point;
    }

    public void setSalevalue(Double salevalue) {
        this.salevalue = salevalue;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof R10PointAcc)) {
            return false;
        }
        R10PointAcc other = (R10PointAcc)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$vseqno = this.getVseqno();
        Long other$vseqno = other.getVseqno();
        if (this$vseqno == null ? other$vseqno != null : !((Object)this$vseqno).equals(other$vseqno)) {
            return false;
        }
        Long this$listno = this.getListno();
        Long other$listno = other.getListno();
        if (this$listno == null ? other$listno != null : !((Object)this$listno).equals(other$listno)) {
            return false;
        }
        Double this$point = this.getPoint();
        Double other$point = other.getPoint();
        if (this$point == null ? other$point != null : !((Object)this$point).equals(other$point)) {
            return false;
        }
        Double this$salevalue = this.getSalevalue();
        Double other$salevalue = other.getSalevalue();
        if (this$salevalue == null ? other$salevalue != null : !((Object)this$salevalue).equals(other$salevalue)) {
            return false;
        }
        String this$vtype = this.getVtype();
        String other$vtype = other.getVtype();
        if (this$vtype == null ? other$vtype != null : !this$vtype.equals(other$vtype)) {
            return false;
        }
        String this$posid = this.getPosid();
        String other$posid = other.getPosid();
        if (this$posid == null ? other$posid != null : !this$posid.equals(other$posid)) {
            return false;
        }
        String this$sheetno = this.getSheetno();
        String other$sheetno = other.getSheetno();
        if (this$sheetno == null ? other$sheetno != null : !this$sheetno.equals(other$sheetno)) {
            return false;
        }
        String this$mkt = this.getMkt();
        String other$mkt = other.getMkt();
        if (this$mkt == null ? other$mkt != null : !this$mkt.equals(other$mkt)) {
            return false;
        }
        String this$cashierid = this.getCashierid();
        String other$cashierid = other.getCashierid();
        if (this$cashierid == null ? other$cashierid != null : !this$cashierid.equals(other$cashierid)) {
            return false;
        }
        String this$cardno = this.getCardno();
        String other$cardno = other.getCardno();
        if (this$cardno == null ? other$cardno != null : !this$cardno.equals(other$cardno)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$paycode = this.getPaycode();
        String other$paycode = other.getPaycode();
        if (this$paycode == null ? other$paycode != null : !this$paycode.equals(other$paycode)) {
            return false;
        }
        String this$notes = this.getNotes();
        String other$notes = other.getNotes();
        return !(this$notes == null ? other$notes != null : !this$notes.equals(other$notes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof R10PointAcc;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $vseqno = this.getVseqno();
        result = result * 59 + ($vseqno == null ? 43 : ((Object)$vseqno).hashCode());
        Long $listno = this.getListno();
        result = result * 59 + ($listno == null ? 43 : ((Object)$listno).hashCode());
        Double $point = this.getPoint();
        result = result * 59 + ($point == null ? 43 : ((Object)$point).hashCode());
        Double $salevalue = this.getSalevalue();
        result = result * 59 + ($salevalue == null ? 43 : ((Object)$salevalue).hashCode());
        String $vtype = this.getVtype();
        result = result * 59 + ($vtype == null ? 43 : $vtype.hashCode());
        String $posid = this.getPosid();
        result = result * 59 + ($posid == null ? 43 : $posid.hashCode());
        String $sheetno = this.getSheetno();
        result = result * 59 + ($sheetno == null ? 43 : $sheetno.hashCode());
        String $mkt = this.getMkt();
        result = result * 59 + ($mkt == null ? 43 : $mkt.hashCode());
        String $cashierid = this.getCashierid();
        result = result * 59 + ($cashierid == null ? 43 : $cashierid.hashCode());
        String $cardno = this.getCardno();
        result = result * 59 + ($cardno == null ? 43 : $cardno.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $paycode = this.getPaycode();
        result = result * 59 + ($paycode == null ? 43 : $paycode.hashCode());
        String $notes = this.getNotes();
        result = result * 59 + ($notes == null ? 43 : $notes.hashCode());
        return result;
    }

    public String toString() {
        return "R10PointAcc(vtype=" + this.getVtype() + ", vseqno=" + this.getVseqno() + ", posid=" + this.getPosid() + ", sheetno=" + this.getSheetno() + ", listno=" + this.getListno() + ", mkt=" + this.getMkt() + ", cashierid=" + this.getCashierid() + ", cardno=" + this.getCardno() + ", password=" + this.getPassword() + ", paycode=" + this.getPaycode() + ", point=" + this.getPoint() + ", salevalue=" + this.getSalevalue() + ", notes=" + this.getNotes() + ")";
    }
}

