/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.mapperscan;

import com.efuture.business.mapperscan.MyMapperScan;
import com.efuture.business.mapperscan.MyMapperScans;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.mybatis.spring.mapper.ClassPathMapperScanner;
import org.mybatis.spring.mapper.MapperFactoryBean;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class MyMapperScannerRegistrar
implements ImportBeanDefinitionRegistrar,
ResourceLoaderAware {
    private ResourceLoader resourceLoader;

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        AnnotationAttributes mapperScanAttrs = AnnotationAttributes.fromMap((Map)importingClassMetadata.getAnnotationAttributes(MyMapperScan.class.getName()));
        if (mapperScanAttrs != null) {
            this.registerBeanDefinitions(mapperScanAttrs, registry);
        }
    }

    void registerBeanDefinitions(AnnotationAttributes annoAttrs, BeanDefinitionRegistry registry) {
        Class mapperFactoryBeanClass;
        Class generatorClass;
        Class markerInterface;
        Class annotationClass;
        ClassPathMapperScanner scanner = new ClassPathMapperScanner(registry);
        Optional.ofNullable(this.resourceLoader).ifPresent(arg_0 -> ((ClassPathMapperScanner)scanner).setResourceLoader(arg_0));
        Resource resource = this.resourceLoader.getResource("application.yml");
        YamlPropertiesFactoryBean yaml = new YamlPropertiesFactoryBean();
        yaml.setResources(new Resource[]{resource});
        String paths = yaml.getObject().getProperty("filePath");
        String localizeType = "";
        localizeType = yaml.getObject().getProperty("localize.type").contains("$") ? System.getenv(yaml.getObject().getProperty("localize.type").replace("${", "").replace("}", "")) : yaml.getObject().getProperty("localize.type");
        String[] value = annoAttrs.getStringArray("value");
        String[] valueAarry = annoAttrs.getStringArray("value");
        if (null != paths && value.length == 1 && !StringUtils.isEmpty((Object)localizeType)) {
            Properties properties = new Properties();
            BufferedInputStream b2 = null;
            try {
                b2 = new BufferedInputStream(new FileInputStream(paths + "/" + localizeType + "/application-localize.properties"));
                properties.load(b2);
                b2.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            System.out.println("application-localize.properties :" + properties.toString());
            if (value[0].contains("initialize")) {
                valueAarry = properties.getProperty("localize.mapperPath.initialize").split(",");
            } else if (value[0].contains("goods")) {
                valueAarry = properties.getProperty("localize.mapperPath.goods").split(",");
            } else if (value[0].contains("promotion")) {
                valueAarry = properties.getProperty("localize.mapperPath.promotion").split(",");
            } else if (value[0].contains("pay")) {
                valueAarry = properties.getProperty("localize.mapperPath.pay").split(",");
            } else if (value[0].contains("vip")) {
                valueAarry = properties.getProperty("localize.mapperPath.vip").split(",");
            } else if (value[0].contains("order")) {
                valueAarry = properties.getProperty("localize.mapperPath.order").split(",");
            } else if (value[0].contains("function")) {
                valueAarry = properties.getProperty("localize.mapperPath.function").split(",");
            } else if (value[0].contains("home")) {
                valueAarry = properties.getProperty("localize.mapperPath.home").split(",");
            }
        }
        if (!Annotation.class.equals((Object)(annotationClass = annoAttrs.getClass("annotationClass")))) {
            scanner.setAnnotationClass(annotationClass);
        }
        if (!Class.class.equals((Object)(markerInterface = annoAttrs.getClass("markerInterface")))) {
            scanner.setMarkerInterface(markerInterface);
        }
        if (!BeanNameGenerator.class.equals((Object)(generatorClass = annoAttrs.getClass("nameGenerator")))) {
            scanner.setBeanNameGenerator((BeanNameGenerator)BeanUtils.instantiateClass((Class)generatorClass));
        }
        if (!MapperFactoryBean.class.equals((Object)(mapperFactoryBeanClass = annoAttrs.getClass("factoryBean")))) {
            scanner.setMapperFactoryBean((MapperFactoryBean)BeanUtils.instantiateClass((Class)mapperFactoryBeanClass));
        }
        scanner.setSqlSessionTemplateBeanName(annoAttrs.getString("sqlSessionTemplateRef"));
        scanner.setSqlSessionFactoryBeanName(annoAttrs.getString("sqlSessionFactoryRef"));
        ArrayList basePackages = new ArrayList();
        basePackages.addAll(Arrays.stream(valueAarry).filter(StringUtils::hasText).collect(Collectors.toList()));
        basePackages.addAll(Arrays.stream(annoAttrs.getStringArray("basePackages")).filter(StringUtils::hasText).collect(Collectors.toList()));
        basePackages.addAll(Arrays.stream(annoAttrs.getClassArray("basePackageClasses")).map(ClassUtils::getPackageName).collect(Collectors.toList()));
        scanner.registerFilters();
        scanner.doScan(StringUtils.toStringArray(basePackages));
    }

    static class RepeatingRegistrar
    extends MyMapperScannerRegistrar {
        RepeatingRegistrar() {
        }

        @Override
        public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
            AnnotationAttributes mapperScansAttrs = AnnotationAttributes.fromMap((Map)importingClassMetadata.getAnnotationAttributes(MyMapperScans.class.getName()));
            if (mapperScansAttrs != null) {
                Arrays.stream(mapperScansAttrs.getAnnotationArray("value")).forEach(mapperScanAttrs -> this.registerBeanDefinitions((AnnotationMetadata)mapperScanAttrs, registry));
            }
        }
    }
}

