/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.soa.client;

import com.efuture.business.config.BaseUtilConfig;
import com.efuture.business.config.NaCosConfig;
import com.efuture.business.hessian.HessianProxyFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SOAClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOAClient.class);
    private static Map<String, List<String>> pkgToHosts = new HashMap<String, List<String>>();
    private static Properties naCosproperties = null;
    private static long fileLastModified = 0L;
    private static File hostFile = null;

    private static synchronized void updatePkgToHosts() {
        if (null == naCosproperties && BaseUtilConfig.isOpenNacos) {
            naCosproperties = NaCosConfig.getNaCosConfigToProperties("pos-application-soahost", NaCosConfig.group, NaCosConfig.serverAddr, NaCosConfig.userName, NaCosConfig.passWord, NaCosConfig.nameSpace);
            HashMap<Object, Object> map1 = null;
            if (!naCosproperties.isEmpty()) {
                map1 = new HashMap<Object, Object>(naCosproperties);
                for (Map.Entry entry : map1.entrySet()) {
                    ArrayList list = new ArrayList();
                    list.add(entry.getValue());
                    map1.put((String)entry.getKey(), list);
                }
                pkgToHosts = map1;
                return;
            }
        }
        if (null == hostFile && null == naCosproperties && null == (hostFile = SOAClient.getExistFile())) {
            return;
        }
        if (null == hostFile) {
            return;
        }
        if (!hostFile.exists() && null == naCosproperties) {
            hostFile = null;
        } else if (hostFile.lastModified() != fileLastModified && null == naCosproperties) {
            try {
                HashMap<String, List<String>> map = new HashMap<String, List<String>>();
                BufferedReader br = new BufferedReader(new FileReader(hostFile));
                String line = null;
                while ((line = br.readLine()) != null) {
                    String[] strs;
                    int index = line.indexOf("#");
                    if (index >= 0) {
                        line = line.substring(0, index);
                    }
                    if ((strs = line.split("=")).length < 2) continue;
                    String pkg = strs[0].trim();
                    String host = strs[1].trim();
                    if (pkg.isEmpty() || host.isEmpty()) continue;
                    if (!map.containsKey(pkg)) {
                        map.put(pkg, new ArrayList());
                    }
                    if (map.get(pkg).contains(host)) continue;
                    map.get(pkg).add(host);
                }
                br.close();
                pkgToHosts = map;
                fileLastModified = hostFile.lastModified();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static File getExistFile() {
        File file = null;
        String appPath = BaseUtilConfig.appPaths;
        String loclizeType = BaseUtilConfig.loclizeType;
        file = new File(appPath + "/" + loclizeType + "/application-soahost.yml");
        if (file != null && file.exists() && file.isFile()) {
            return file;
        }
        file = new File(appPath + "/application-soahost.yml");
        return file;
    }

    private static List<String> getHostByClass(Class<?> clazz) {
        for (Map.Entry<String, List<String>> entry : pkgToHosts.entrySet()) {
            int index = clazz.getName().lastIndexOf(".");
            String className = clazz.getName().substring(index + 1, clazz.getName().length());
            if (!className.startsWith(entry.getKey())) continue;
            return pkgToHosts.get(entry.getKey());
        }
        return null;
    }

    public static <T> T getService(Class<T> clazz, String url) {
        List<String> hostList = SOAClient.getHostByClass(clazz);
        if (hostList != null && !hostList.isEmpty()) {
            HessianProxyFactory factory = new HessianProxyFactory();
            factory.setOverloadEnabled(true);
            factory.setReadTimeout(5000L);
            factory.setConnectTimeout(5000L);
            try {
                int e = new Random().nextInt(hostList.size());
                LOGGER.debug("getService:{}", (Object)("http://" + hostList.get(e) + "/" + url));
                Object t = factory.create(clazz, "http://" + hostList.get(e) + "/" + url);
                return (T)t;
            }
            catch (MalformedURLException var6) {
                LOGGER.error("getService {} fail", (Object)clazz.getName(), (Object)var6);
                return null;
            }
        }
        throw new RuntimeException("class " + clazz.getName() + "has no soa_host configured.");
    }

    public static <T> T getService(Class<T> clazz, String url, long timeOut) {
        List<String> hostList = SOAClient.getHostByClass(clazz);
        if (hostList != null && !hostList.isEmpty()) {
            HessianProxyFactory factory = new HessianProxyFactory();
            factory.setOverloadEnabled(true);
            factory.setReadTimeout(timeOut);
            factory.setConnectTimeout(timeOut);
            try {
                int e = new Random().nextInt(hostList.size());
                LOGGER.debug("getService:{}", (Object)("http://" + hostList.get(e) + "/" + url));
                Object t = factory.create(clazz, "http://" + hostList.get(e) + "/" + url);
                return (T)t;
            }
            catch (MalformedURLException var8) {
                LOGGER.error("getService {} fail", (Object)clazz.getName(), (Object)var8);
                return null;
            }
        }
        throw new RuntimeException("class " + clazz.getName() + "has no soa_host configured.");
    }

    public static <T> T getServiceByOld(Class<T> clazz, String url) {
        HessianProxyFactory factory = new HessianProxyFactory();
        factory.setOverloadEnabled(true);
        try {
            Object e = factory.create(clazz, url);
            return (T)e;
        }
        catch (MalformedURLException var4) {
            LOGGER.error("getService {} fail", (Object)clazz.getName(), (Object)var4);
            return null;
        }
    }

    static {
        SOAClient.updatePkgToHosts();
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            SOAClient.updatePkgToHosts();
                            Thread.sleep(1000L);
                        }
                    }
                    catch (Exception var2) {
                        LOGGER.error("updatePkgToHosts fail", (Throwable)var2);
                        continue;
                    }
                    break;
                }
            }
        });
        thread.setName("SOA-updatePkgToHosts-thread");
        thread.setDaemon(true);
        thread.start();
    }
}

