/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.util;

import java.math.BigDecimal;

public class AmountUtil {
    public static final String CURRENCY_FEN_REGEX = "\\-?[0-9]+";

    public static String changeF2Y(Long amount) throws Exception {
        if (!amount.toString().matches(CURRENCY_FEN_REGEX)) {
            throw new Exception("\u91d1\u989d\u683c\u5f0f\u6709\u8bef");
        }
        boolean flag = false;
        String amString = amount.toString();
        if (amString.charAt(0) == '-') {
            flag = true;
            amString = amString.substring(1);
        }
        StringBuffer result = new StringBuffer();
        if (amString.length() == 1) {
            result.append("0.0").append(amString);
        } else if (amString.length() == 2) {
            result.append("0.").append(amString);
        } else {
            String intString = amString.substring(0, amString.length() - 2);
            for (int i = 1; i <= intString.length(); ++i) {
                if ((i - 1) % 3 == 0 && i != 1) {
                    result.append(",");
                }
                result.append(intString.substring(intString.length() - i, intString.length() - i + 1));
            }
            result.reverse().append(".").append(amString.substring(amString.length() - 2));
        }
        if (flag) {
            return "-" + result.toString();
        }
        return result.toString();
    }

    public static Double changeF2Y(String amount) throws Exception {
        if (amount.contains(".00")) {
            amount = amount.replace(".00", "");
        }
        if (!amount.matches(CURRENCY_FEN_REGEX)) {
            throw new Exception("\u91d1\u989d\u683c\u5f0f\u6709\u8bef:" + amount);
        }
        return BigDecimal.valueOf(Long.valueOf(amount)).divide(new BigDecimal(100)).doubleValue();
    }

    public static Long changeY2F(Double amount) {
        return BigDecimal.valueOf(amount).multiply(new BigDecimal(100)).longValue();
    }

    public static String changeY2F(String amount) {
        String currency = amount.replaceAll("\\$|\\\uffe5|\\,", "");
        int index = currency.indexOf(".");
        int length = currency.length();
        Long amLong = 0L;
        amLong = index == -1 ? Long.valueOf(currency + "00") : (length - index >= 3 ? Long.valueOf(currency.substring(0, index + 3).replace(".", "")) : (length - index == 2 ? Long.valueOf(currency.substring(0, index + 2).replace(".", "") + "0") : Long.valueOf(currency.substring(0, index + 1).replace(".", "") + "00")));
        return amLong.toString();
    }

    public static Long changeY2FLong(String amount) {
        String currency = amount.replaceAll("\\$|\\\uffe5|\\,", "");
        int index = currency.indexOf(".");
        int length = currency.length();
        Long amLong = 0L;
        amLong = index == -1 ? Long.valueOf(currency + "00") : (length - index >= 3 ? Long.valueOf(currency.substring(0, index + 3).replace(".", "")) : (length - index == 2 ? Long.valueOf(currency.substring(0, index + 2).replace(".", "") + "0") : Long.valueOf(currency.substring(0, index + 1).replace(".", "") + "00")));
        return amLong;
    }
}

