/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.util;

import com.efuture.business.javaPos.commonkit.Convert;
import java.util.HashMap;
import java.util.Map;

public class CastUtil {
    private static final Map<String, String> AmcErrMsgMap = new HashMap<String, String>();

    public static String castAmcErrMsg(String code) {
        if (null == AmcErrMsgMap.get(code)) {
            return "\u901a\u8a0a\u7570\u5e38";
        }
        return AmcErrMsgMap.get(code);
    }

    public static String castString(Object obj) {
        return CastUtil.castString(obj, "");
    }

    public static String castString(Object obj, String defaultValue) {
        return obj != null ? String.valueOf(obj) : defaultValue;
    }

    public static double castDouble(Object obj) {
        return CastUtil.castDouble(obj, 0.0);
    }

    public static double castDouble(Object obj, double defaultValue) {
        String strValue;
        double doubleValue = defaultValue;
        if (obj != null && null != (strValue = CastUtil.castString(obj)) && !"".equals(strValue)) {
            try {
                doubleValue = Double.parseDouble(strValue);
            }
            catch (NumberFormatException e) {
                doubleValue = defaultValue;
            }
        }
        return doubleValue;
    }

    public static long castLong(Object obj) {
        return CastUtil.castLong(obj, 0L);
    }

    public static long castLong(Object obj, long defaultValue) {
        String strValue;
        long longValue = defaultValue;
        if (obj != null && null != (strValue = CastUtil.castString(obj)) && !"".equals(strValue)) {
            try {
                longValue = Long.parseLong(strValue);
            }
            catch (NumberFormatException e) {
                longValue = defaultValue;
            }
        }
        return longValue;
    }

    public static int castInt(Object obj) {
        return CastUtil.castInt(obj, 0);
    }

    public static int castInt(Object obj, int defaultValue) {
        String strValue;
        int intValue = defaultValue;
        if (obj != null && null != (strValue = CastUtil.castString(obj)) && !"".equals(strValue)) {
            try {
                intValue = Integer.parseInt(strValue);
            }
            catch (NumberFormatException e) {
                intValue = defaultValue;
            }
        }
        return intValue;
    }

    public static boolean castBoolean(Object obj) {
        return CastUtil.castBoolean(obj, false);
    }

    public static boolean castBoolean(Object obj, boolean defaultValue) {
        boolean booleanValue = defaultValue;
        if (obj != null) {
            booleanValue = Boolean.parseBoolean(CastUtil.castString(obj));
        }
        return booleanValue;
    }

    public static String castAeonGoodsCode(String code) {
        Object realCode = code;
        if (((String)realCode).length() == 13 && ((String)realCode).startsWith("210")) {
            realCode = ((String)realCode).substring(2).replaceFirst("^0*", "");
            realCode = ((String)realCode).substring(0, ((String)realCode).length() - 1);
            return realCode;
        }
        if (CastUtil.castInt(realCode) > 999) {
            realCode = (String)realCode + CastUtil.castAeonCheckNum((String)realCode);
        } else {
            realCode = ((String)realCode).replaceFirst("^0*", "");
            realCode = Convert.increaseCharForward((String)realCode, '0', 3);
        }
        return realCode;
    }

    public static String castCNAeonGoodsCode(String code) {
        Object realCode = code;
        realCode = (String)realCode + CastUtil.castCNAeonCheckNum((String)realCode);
        return realCode;
    }

    public static String castCNAeonCheckNum(String code) {
        int num2;
        String str1 = Convert.increaseCharForward(code, '0', 7);
        int num1 = 3 * (str1.charAt(0) + str1.charAt(2) + str1.charAt(4) + str1.charAt(6) - 192);
        int checkNum = (num1 + (num2 = str1.charAt(1) + str1.charAt(3) + str1.charAt(5) - 144)) % 10;
        if (checkNum != 0) {
            checkNum = 10 - checkNum;
        }
        return "" + checkNum;
    }

    public static String castAeonCheckNum(String code) {
        String str1 = Convert.increaseCharForward(code, '0', 8);
        int num1 = 2 * (1000 * str1.charAt(1) + 100 * str1.charAt(3) + 10 * str1.charAt(5) + str1.charAt(7) - 53328);
        String str2 = Convert.increaseCharForward(String.valueOf(num1), '0', 5);
        int checkNum = (str2.charAt(0) + str2.charAt(1) + str2.charAt(2) + str2.charAt(3) + str2.charAt(4) + str1.charAt(0) + str1.charAt(2) + str1.charAt(4) + str1.charAt(6) - 432) % 10;
        if (checkNum != 0) {
            checkNum = 10 - checkNum;
        }
        return "" + checkNum;
    }

    public static boolean checkCardNo(String cardNo) {
        for (int i = 0; i < cardNo.length(); ++i) {
            char s = cardNo.charAt(i);
            if (s >= '0' && s <= '9') continue;
            return false;
        }
        return true;
    }

    static {
        AmcErrMsgMap.put("400-001", "\u7121\u6548\u7684\u6578\u64da");
        AmcErrMsgMap.put("400-002", "\u820a\u5bc6\u78bc\u932f\u8aa4");
        AmcErrMsgMap.put("400-003", "\u7a4d\u5206\u5931\u6548");
        AmcErrMsgMap.put("400-004", "\u6c92\u6709\u8db3\u5920\u7684\u7a4d\u5206");
        AmcErrMsgMap.put("400-005", "\u904e\u671f\u7684\u6703\u54e1\u7de8\u865f");
        AmcErrMsgMap.put("400-006", "\u7121\u6548\u7684\u8acb\u6c42\u6578\u64da");
        AmcErrMsgMap.put("401-001", "\u9a57\u8b49\u5931\u6557");
        AmcErrMsgMap.put("404-001", "\u7121\u6548\u7684\u6703\u54e1\u7de8\u865f");
        AmcErrMsgMap.put("500-001", "\u4f3a\u670d\u5668\u932f\u8aa4");
        AmcErrMsgMap.put("500-002", "\u670d\u52d9\u7121\u6cd5\u9023\u63a5");
    }
}

