/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.util;

import com.baomidou.mybatisplus.annotation.TableName;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassUtil {
    public static void main(String[] args) {
        Set<Class<?>> classSet = ClassUtil.getClasses("com.efuture.yunpos.basis.rocEntity");
        for (Class<?> class1 : classSet) {
            System.out.println(ClassUtil.getTableName(class1).replace("ompdb.", ""));
            System.out.println(ClassUtil.toLowerCaseFirstOne(class1.getSimpleName()));
            System.out.println(class1.getName());
            System.out.println(class1.getTypeName());
            System.out.println(class1.getCanonicalName());
        }
    }

    public static Set<String> getClassName(String packageName, boolean isRecursion) {
        String packagePath;
        Set<String> classNames = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL url = loader.getResource(packagePath = packageName.replace(".", "/"));
        if (url != null) {
            String protocol = url.getProtocol();
            if (protocol.equals("file")) {
                classNames = ClassUtil.getClassNameFromDir(url.getPath(), packageName, isRecursion);
            } else if (protocol.equals("jar")) {
                JarFile jarFile = null;
                try {
                    jarFile = ((JarURLConnection)url.openConnection()).getJarFile();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (jarFile != null) {
                    ClassUtil.getClassNameFromJar(jarFile.entries(), packageName, isRecursion);
                }
            }
        } else {
            classNames = ClassUtil.getClassNameFromJars(((URLClassLoader)loader).getURLs(), packageName, isRecursion);
        }
        return classNames;
    }

    public static <T> String getTableName(Class<T> clazz) {
        TableName tableName = clazz.getAnnotation(TableName.class);
        if (null != tableName) {
            return tableName.value();
        }
        return ClassUtil.toLowerCaseFirstOne(clazz.getSimpleName());
    }

    public static String toLowerCaseFirstOne(String s) {
        if (Character.isLowerCase(s.charAt(0))) {
            return s;
        }
        return Character.toLowerCase(s.charAt(0)) + s.substring(1);
    }

    private static Set<String> getClassNameFromDir(String filePath, String packageName, boolean isRecursion) {
        File[] files;
        HashSet<String> className = new HashSet<String>();
        File file = new File(filePath);
        for (File childFile : files = file.listFiles()) {
            if (childFile.isDirectory()) {
                if (!isRecursion) continue;
                className.addAll(ClassUtil.getClassNameFromDir(childFile.getPath(), packageName + "." + childFile.getName(), isRecursion));
                continue;
            }
            String fileName = childFile.getName();
            if (!fileName.endsWith(".class") || fileName.contains("$")) continue;
            className.add(fileName.replace(".class", ""));
        }
        return className;
    }

    private static Set<String> getClassNameFromJar(Enumeration<JarEntry> jarEntries, String packageName, boolean isRecursion) {
        HashSet<String> classNames = new HashSet<String>();
        while (jarEntries.hasMoreElements()) {
            String entryName;
            JarEntry jarEntry = jarEntries.nextElement();
            if (jarEntry.isDirectory() || !(entryName = jarEntry.getName().replace("/", ".")).endsWith(".class") || entryName.contains("$") || !entryName.startsWith(packageName)) continue;
            entryName = entryName.replace(".class", "");
            if (isRecursion) {
                classNames.add(entryName);
                continue;
            }
            if (entryName.replace(packageName + ".", "").contains(".")) continue;
            classNames.add(entryName);
        }
        return classNames;
    }

    private static Set<String> getClassNameFromJars(URL[] urls, String packageName, boolean isRecursion) {
        HashSet<String> classNames = new HashSet<String>();
        for (int i = 0; i < urls.length; ++i) {
            String classPath = urls[i].getPath();
            if (classPath.endsWith("classes/")) continue;
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(classPath.substring(classPath.indexOf("/")));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (jarFile == null) continue;
            classNames.addAll(ClassUtil.getClassNameFromJar(jarFile.entries(), packageName, isRecursion));
        }
        return classNames;
    }

    public static Set<Class<?>> getClasses(String pack) {
        LinkedHashSet classes = new LinkedHashSet();
        boolean recursive = true;
        String packageName = pack;
        String packageDirName = packageName.replace('.', '/');
        try {
            Enumeration<URL> dirs = Thread.currentThread().getContextClassLoader().getResources(packageDirName);
            while (dirs.hasMoreElements()) {
                URL url = dirs.nextElement();
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    System.err.println("file\u7c7b\u578b\u7684\u626b\u63cf");
                    String filePath = URLDecoder.decode(url.getFile(), "UTF-8");
                    ClassUtil.findAndAddClassesInPackageByFile(packageName, filePath, recursive, classes);
                    continue;
                }
                if (!"jar".equals(protocol)) continue;
                System.err.println("jar\u7c7b\u578b\u7684\u626b\u63cf");
                try {
                    JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
                    Enumeration<JarEntry> entries = jar.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        String name = entry.getName();
                        if (name.charAt(0) == '/') {
                            name = name.substring(1);
                        }
                        if (!name.startsWith(packageDirName)) continue;
                        int idx = name.lastIndexOf(47);
                        if (idx != -1) {
                            packageName = name.substring(0, idx).replace('/', '.');
                        }
                        if (idx == -1 && !recursive || !name.endsWith(".class") || entry.isDirectory()) continue;
                        String className = name.substring(packageName.length() + 1, name.length() - 6);
                        try {
                            classes.add(Class.forName(packageName + "." + className));
                        }
                        catch (ClassNotFoundException e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return classes;
    }

    public static void findAndAddClassesInPackageByFile(String packageName, String packagePath, final boolean recursive, Set<Class<?>> classes) {
        File[] dirfiles;
        File dir = new File(packagePath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        for (File file : dirfiles = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return recursive && file.isDirectory() || file.getName().endsWith(".class");
            }
        })) {
            if (file.isDirectory()) {
                ClassUtil.findAndAddClassesInPackageByFile(packageName + "." + file.getName(), file.getAbsolutePath(), recursive, classes);
                continue;
            }
            String className = file.getName().substring(0, file.getName().length() - 6);
            try {
                classes.add(Thread.currentThread().getContextClassLoader().loadClass(packageName + "." + className));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public static Map<String, Object> objectToMap(Object obj) throws IllegalAccessException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Class<?> clazz = obj.getClass();
        for (Field field : clazz.getDeclaredFields()) {
            field.setAccessible(true);
            String fieldName = field.getName();
            Object value = field.get(obj);
            map.put(fieldName, value);
        }
        return map;
    }
}

