/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.web.multipart.MultipartFile;

public class FileChangeUtils {
    public static File multiPartFileToFile(MultipartFile multipartFile) {
        File file = null;
        if (null != multipartFile) {
            try {
                String originalFilename = multipartFile.getOriginalFilename();
                String tempDir = System.getProperty("user.dir");
                file = new File(tempDir + File.separator + originalFilename);
                FileUtils.copyInputStreamToFile((InputStream)multipartFile.getInputStream(), (File)file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return file;
    }

    public static MultipartFile fileToMultipartFile(File file) {
        MockMultipartFile result = null;
        if (null != file) {
            try (FileInputStream input = new FileInputStream(file);){
                result = new MockMultipartFile(file.getName().concat("temp"), file.getName(), "text/plain", (InputStream)input);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }
}

