/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.util;

import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Map;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class Http {
    private static final Logger log = LoggerFactory.getLogger(Http.class);

    public String httpPostData(String url, String urlvalue, int timeout, boolean isPing) {
        String rev = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String time = "" + System.currentTimeMillis();
        try {
            DefaultHttpClient httpclient = new DefaultHttpClient();
            httpclient.getParams().setParameter("http.connection.timeout", (Object)timeout);
            httpclient.getParams().setParameter("http.socket.timeout", (Object)timeout);
            HttpPost httppost = new HttpPost(url);
            httppost.addHeader("Authorization", "your token");
            httppost.addHeader("User-Agent", "imgfornote");
            httppost.addHeader("Content-Type", "application/json;charset=UTF-8");
            httppost.setEntity((HttpEntity)new StringEntity(urlvalue, "UTF-8"));
            HttpResponse response = httpclient.execute((HttpUriRequest)httppost);
            int code = response.getStatusLine().getStatusCode();
            if (code == 200) {
                rev = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            }
            log.info("[" + time + "]response=====>" + rev);
            if (isPing) {
                log.info("[isPing] end");
                return "SUCC";
            }
            return rev;
        }
        catch (ClientProtocolException e) {
            log.error("[{}]ClientProtocolException:{}", (Object)time, (Object)e);
            return null;
        }
        catch (IOException e) {
            log.error("[{}]IOException:{}", (Object)time, (Object)e);
            return null;
        }
        catch (Exception e) {
            log.error("[{}]Exception:{}", (Object)time, (Object)e);
            return null;
        }
    }

    public String httpPostData(Header[] headers, String url, String urlvalue, int timeout, boolean isPing) {
        String rev = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String time = "" + System.currentTimeMillis();
        try {
            DefaultHttpClient httpclient = new DefaultHttpClient();
            httpclient.getParams().setParameter("http.connection.timeout", (Object)timeout);
            httpclient.getParams().setParameter("http.socket.timeout", (Object)timeout);
            HttpPost httppost = new HttpPost(url);
            if (null != headers) {
                httppost.setHeaders(headers);
            }
            httppost.addHeader("Accept", "application/json");
            httppost.addHeader("Content-Type", "application/json");
            HttpResponse response = httpclient.execute((HttpUriRequest)httppost);
            int code = response.getStatusLine().getStatusCode();
            if (code == 200) {
                rev = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("httpCode", (Object)code);
            jsonObject.put("response", (Object)rev);
            log.info("[" + time + "]response=====>" + rev);
            if (isPing) {
                log.info("[isPing] end");
                return "SUCC";
            }
            return rev;
        }
        catch (ClientProtocolException e) {
            log.error("[{}]ClientProtocolException:{}", (Object)time, (Object)e);
            return null;
        }
        catch (IOException e) {
            log.error("[{}]IOException:{}", (Object)time, (Object)e);
            return null;
        }
        catch (Exception e) {
            log.error("[{}]Exception:{}", (Object)time, (Object)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeGet(String url) throws Exception {
        BufferedReader in = null;
        String content = null;
        try {
            URL urlp = new URL(url);
            URI uri = new URI(urlp.getProtocol(), urlp.getHost(), urlp.getPath(), urlp.getQuery(), null);
            DefaultHttpClient client = new DefaultHttpClient();
            HttpGet request = new HttpGet();
            request.setURI(uri);
            HttpResponse response = client.execute((HttpUriRequest)request);
            in = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), "UTF-8"));
            StringBuffer sb = new StringBuffer("");
            String line = "";
            while ((line = in.readLine()) != null) {
                sb.append(line);
            }
            in.close();
            content = sb.toString();
            return content;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            return content;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeGet(Header[] headers, String url, int timeout) throws Exception {
        BufferedReader in = null;
        String content = null;
        JSONObject jsonObject = null;
        try {
            URL urlp = new URL(url);
            URI uri = new URI(urlp.getProtocol(), urlp.getHost(), urlp.getPath(), urlp.getQuery(), null);
            DefaultHttpClient client = new DefaultHttpClient();
            client.getParams().setParameter("http.connection.timeout", (Object)timeout);
            client.getParams().setParameter("http.socket.timeout", (Object)timeout);
            HttpGet request = new HttpGet();
            request.setHeaders(headers);
            request.setURI(uri);
            HttpResponse response = client.execute((HttpUriRequest)request);
            int code = response.getStatusLine().getStatusCode();
            in = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), "UTF-8"));
            StringBuffer sb = new StringBuffer("");
            String line = "";
            while ((line = in.readLine()) != null) {
                sb.append(line);
            }
            in.close();
            content = sb.toString();
            jsonObject = new JSONObject();
            jsonObject.put("httpCode", (Object)code);
            jsonObject.put("response", (Object)content);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            return jsonObject.toJSONString();
        }
    }

    public static String uploadFile(String urlStr, MultipartFile file, Map<String, String> paramMap) throws IOException {
        String suffix = Http.getSuffix(file);
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost uploadFile = new HttpPost(urlStr);
        DecimalFormat df = new DecimalFormat("#.##");
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.addTextBody("name", file.getOriginalFilename(), ContentType.create((String)"text/plain", (Charset)Consts.UTF_8));
        builder.addTextBody("size", df.format((double)file.getSize() / 1024.0), ContentType.TEXT_PLAIN);
        builder.addTextBody("suffix", suffix, ContentType.TEXT_PLAIN);
        builder.addBinaryBody("file", file.getInputStream(), ContentType.APPLICATION_OCTET_STREAM, file.getOriginalFilename());
        for (Map.Entry<String, String> entry : paramMap.entrySet()) {
            builder.addPart(entry.getKey(), (ContentBody)new StringBody(entry.getValue(), ContentType.create((String)"text/plain", (Charset)Consts.UTF_8)));
        }
        HttpEntity multipart = builder.build();
        uploadFile.setEntity(multipart);
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)uploadFile);
        HttpEntity responseEntity = response.getEntity();
        String sResponse = EntityUtils.toString((HttpEntity)responseEntity, (String)"UTF-8");
        return sResponse;
    }

    public static String getSuffix(MultipartFile file) {
        if (file == null || file.getSize() == 0L) {
            return null;
        }
        String fileName = file.getOriginalFilename();
        return fileName.substring(fileName.lastIndexOf(".") + 1);
    }
}

