/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.util;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpClientUtil.class);
    private static final String CONTENT_TYPE_TEXT_JSON = "text/json";
    private static final String APPLICATION_JSON = "application/json;charset=UTF-8";
    private static final int SOCKET_TIMEOUT = 10000;
    private static final int CONNECT_TIMEOUT = 10000;
    private static PoolingHttpClientConnectionManager cm;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String postJson(String url, String json) {
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(10000).setConnectTimeout(10000).build();
        CloseableHttpClient httpclient = HttpClients.createDefault();
        log.info("\u8bf7\u6c42url\uff1a" + url);
        HttpPost httppost = new HttpPost(url);
        httppost.setHeader("Content-Type", APPLICATION_JSON);
        try {
            StringEntity se = new StringEntity(json, "utf-8");
            se.setContentType(CONTENT_TYPE_TEXT_JSON);
            se.setContentEncoding((Header)new BasicHeader("Content-Type", APPLICATION_JSON));
            httppost.setEntity((HttpEntity)se);
            httppost.setConfig(requestConfig);
            try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httppost);){
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    String string = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                    return string;
                }
            }
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
            log.info("ClientProtocolException ", (Throwable)e);
        }
        catch (UnsupportedEncodingException e1) {
            log.info("UnsupportedEncodingException ", (Throwable)e1);
            e1.printStackTrace();
        }
        catch (IOException e) {
            log.info("IOException ", (Throwable)e);
            e.printStackTrace();
        }
        finally {
            try {
                httpclient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    private static void init() {
        if (cm == null) {
            cm = new PoolingHttpClientConnectionManager();
            cm.setMaxTotal(50);
            cm.setDefaultMaxPerRoute(5);
        }
    }

    private static CloseableHttpClient getHttpClient() {
        HttpClientUtil.init();
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();
    }

    public static String httpRequest(String type, String url, Map<String, Object> paramMap, Map<String, Object> headers) throws Exception {
        log.info("url==>{}", (Object)url);
        if (type.equalsIgnoreCase("POST")) {
            return HttpClientUtil.postHttp(url, paramMap, headers);
        }
        return HttpClientUtil.getHttp(url, paramMap, headers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String postHttp(String url, Map<String, Object> params, Map<String, Object> headers) throws IOException {
        HttpPost httpPost = new HttpPost(url);
        httpPost.setHeader("Content-Type", APPLICATION_JSON);
        for (Map.Entry<String, Object> param : headers.entrySet()) {
            httpPost.addHeader(param.getKey(), String.valueOf(param.getValue()));
        }
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(10000).setConnectTimeout(10000).build();
        StringEntity se = new StringEntity(JSONObject.toJSONString(params), "utf-8");
        se.setContentType(CONTENT_TYPE_TEXT_JSON);
        se.setContentEncoding((Header)new BasicHeader("Content-Type", APPLICATION_JSON));
        httpPost.setEntity((HttpEntity)se);
        httpPost.setConfig(requestConfig);
        CloseableHttpClient httpClient = HttpClientUtil.getHttpClient();
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);){
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                String string = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                return string;
            }
        }
        return "";
    }

    public static String getHttp(String url, Map<String, Object> params, Map<String, Object> headers) throws Exception {
        CloseableHttpClient client = HttpClientBuilder.create().build();
        URIBuilder ub = new URIBuilder();
        ub.setPath(url);
        List<NameValuePair> pairs = HttpClientUtil.covertParams2NVPS(params);
        ub.setParameters(pairs);
        HttpGet get = new HttpGet(ub.build());
        get.addHeader("Content-type", "application/json; charset=utf-8");
        get.setHeader("Accept", APPLICATION_JSON);
        for (Map.Entry<String, Object> param : headers.entrySet()) {
            get.addHeader(param.getKey(), String.valueOf(param.getValue()));
        }
        JSONObject response = null;
        HttpResponse res = client.execute((HttpUriRequest)get);
        if (res.getStatusLine().getStatusCode() == 200) {
            HttpEntity entity = res.getEntity();
            String result = EntityUtils.toString((HttpEntity)entity);
            response = JSONObject.parseObject((String)result);
        }
        log.info("response==>{}", (Object)response.toJSONString());
        return response.toJSONString();
    }

    private static List<NameValuePair> covertParams2NVPS(Map<String, Object> params) {
        ArrayList<NameValuePair> pairs = new ArrayList<NameValuePair>();
        for (Map.Entry<String, Object> param : params.entrySet()) {
            pairs.add((NameValuePair)new BasicNameValuePair(param.getKey(), String.valueOf(param.getValue())));
        }
        return pairs;
    }

    public static void main(String[] args) {
        JSONObject json = new JSONObject();
    }
}

