/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class HttpClientUtils {
    public static final String DEFAULT_ENCODING = "UTF-8";
    private static final int CONNECTION_TIMEOUT = 30000;
    private static final int RequestTimeout = 30000;
    private static final int SO_TIMEOUT = 30000;

    public static String post(String url, Map<String, String> params) throws IOException {
        HttpPost post = HttpClientUtils.postForm(url, params, DEFAULT_ENCODING);
        return HttpClientUtils.invoke((HttpUriRequest)post);
    }

    public static String post(String url, String encoding, Map<String, String> params) throws IOException {
        HttpPost post = HttpClientUtils.postForm(url, params, encoding);
        return HttpClientUtils.invoke((HttpUriRequest)post);
    }

    public static String get(String url) throws IOException {
        HttpGet get = new HttpGet(url);
        return HttpClientUtils.invoke((HttpUriRequest)get);
    }

    public static String postJson(String url, String jsonReq) throws IOException {
        return HttpClientUtils.postJson(url, DEFAULT_ENCODING, jsonReq);
    }

    public static String postJson(String url, String encoding, String jsonReq) throws IOException {
        return HttpClientUtils.postJson(url, encoding, jsonReq, 30000, 30000);
    }

    public static String postJson(String url, String encoding, String jsonReq, int ctimeOut, int stimeOut) throws IOException {
        return HttpClientUtils.postJson(url, encoding, jsonReq, ctimeOut, stimeOut, null);
    }

    public static String postJson(String url, String encoding, String jsonReq, int ctimeOut, int stimeOut, String lang) throws IOException {
        HttpPost post = new HttpPost(url);
        if (StringUtils.isNotBlank((String)lang)) {
            post.addHeader("lang", lang);
        } else {
            post.addHeader("lang", "en-US");
        }
        StringEntity s = new StringEntity(jsonReq, encoding);
        s.setContentType("application/json");
        post.setEntity((HttpEntity)s);
        post.setConfig(HttpClientUtils.getRequestConfig(ctimeOut, stimeOut));
        return HttpClientUtils.invoke((HttpUriRequest)post);
    }

    public static String postEraspaceJson(String url, String clientID, String jsonReq, int ctimeOut, int stimeOut) throws IOException {
        HttpPost post = new HttpPost(url);
        post.addHeader("lang", "en-US");
        StringEntity s = new StringEntity(jsonReq, DEFAULT_ENCODING);
        s.setContentType("application/json");
        post.addHeader("source", "eraspace");
        post.addHeader("x-eraspacegtw-apikey", clientID);
        post.setEntity((HttpEntity)s);
        post.setConfig(HttpClientUtils.getRequestConfig(ctimeOut, stimeOut));
        return HttpClientUtils.invoke((HttpUriRequest)post);
    }

    public static String postXml(String url, String xmlReq) throws IOException {
        return HttpClientUtils.postXml(url, DEFAULT_ENCODING, xmlReq);
    }

    public static String postXml(String url, String encoding, String xmlReq) throws IOException {
        HttpPost post = new HttpPost(url);
        StringEntity s = new StringEntity(xmlReq);
        s.setContentEncoding(encoding);
        s.setContentType("text/xml");
        post.setEntity((HttpEntity)s);
        return HttpClientUtils.invoke((HttpUriRequest)post);
    }

    private static String invoke(HttpUriRequest httpost) throws IOException {
        CloseableHttpClient client = HttpClients.createDefault();
        CloseableHttpResponse response = client.execute(httpost);
        String body = HttpClientUtils.paseResponse((HttpResponse)response);
        client.close();
        return body;
    }

    private static String paseResponse(HttpResponse response) throws IOException {
        HttpEntity entity = response.getEntity();
        ContentType contentType = ContentType.getOrDefault((HttpEntity)entity);
        String body = EntityUtils.toString((HttpEntity)entity, (Charset)contentType.getCharset());
        if (response.getStatusLine().getStatusCode() < 400) {
            return body;
        }
        throw new IOException("\u8bf7\u6c42\u5f02\u5e38[" + response.getStatusLine().getStatusCode() + "]:" + body);
    }

    private static HttpPost postForm(String url, Map<String, String> params, String encoding) {
        HttpPost httpost = new HttpPost(url);
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        Set<String> keySet = params.keySet();
        for (String key : keySet) {
            nvps.add(new BasicNameValuePair(key, params.get(key)));
        }
        try {
            httpost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return httpost;
    }

    private static RequestConfig getRequestConfig(int connecttimeout, int socketTimeout) {
        return RequestConfig.custom().setConnectTimeout(connecttimeout).setSocketTimeout(socketTimeout).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(String url, Map<String, String> head) {
        Object result = "";
        BufferedReader in = null;
        try {
            String urlNameString = url;
            if (urlNameString.contains(" ")) {
                urlNameString.replace(" ", "%");
            }
            URL realUrl = new URL(urlNameString);
            HttpURLConnection connection = (HttpURLConnection)realUrl.openConnection();
            connection.setRequestProperty("Content-Type", "Application/json");
            connection.setRequestProperty("Accept", "Application/json");
            connection.setRequestProperty("Source", "eraspace");
            connection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.121 Safari/537.36");
            if (null != head) {
                for (String key : head.keySet()) {
                    connection.setRequestProperty(key, head.get(key));
                }
            }
            connection.connect();
            if (connection != null) {
                String line;
                InputStream inputStream = null;
                inputStream = 200 == connection.getResponseCode() ? connection.getInputStream() : connection.getErrorStream();
                in = new BufferedReader(new InputStreamReader(inputStream));
                while ((line = in.readLine()) != null) {
                    result = (String)result + line;
                }
            }
            connection.disconnect();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return result;
    }

    public static String postJsonParams(Map<String, String> headers, String requestUrl, String params) {
        StringBuilder sb = new StringBuilder();
        try {
            URL url = new URL(requestUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setInstanceFollowRedirects(true);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Accept", "application/json");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.121 Safari/537.36");
            if (null != headers) {
                for (String key : headers.keySet()) {
                    connection.setRequestProperty(key, headers.get(key));
                }
            }
            connection.connect();
            OutputStreamWriter out = new OutputStreamWriter(connection.getOutputStream(), DEFAULT_ENCODING);
            out.append(params);
            out.flush();
            out.close();
            if (connection != null) {
                InputStream inputStream = null;
                inputStream = 200 == connection.getResponseCode() ? connection.getInputStream() : connection.getErrorStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, DEFAULT_ENCODING));
                String line = null;
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                    sb.append("\r\n");
                }
                br.close();
            }
            connection.disconnect();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        String url = "https://api-dev.eraspace.com/customers/v2/membership/customer/zidni722@gmail.com";
        HashMap<String, String> head = new HashMap<String, String>();
        head.put("Device-ID", "a727502f-b714-4c92-8fdd-bb9afce75f33");
        head.put("Authorization", "Basic Y3VzdGJhc2ljOk9MV2llWlVvQlA=");
        String s = HttpClientUtils.get(url, head);
        System.out.println(s);
    }
}

