/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.javaPos.global.GlobalInfo;
import com.efuture.business.util.AuthUtil;
import com.efuture.business.util.Http;
import com.efuture.business.util.HttpClientUtils;
import com.efuture.business.util.HttpLog;
import com.efuture.business.util.HttpsUtil;
import com.efuture.business.util.MD5;
import com.efuture.business.util.UUIDUtils;
import com.efuture.common.utils.DiscoveryRestUtils;
import com.efuture.common.utils.MD5Util;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import com.product.util.StatisticUtils;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;

@Component(value="possvHttpUtils")
@Configuration
public class HttpUtils {
    private static final Logger log = LoggerFactory.getLogger(HttpUtils.class);
    private static final String FUSE_CODE = "100";
    private static final String OFFLINE_CODE = "404";
    private static final int FUSE_RETRY_COUNT = 3;
    private int connectTimeout;
    private int readTimeout;
    private int timeoutlog;
    public static int statictimeoutlog = 0;
    private static int staitcConnectTimeout = 3000;
    private static int staticReadTimeout = 600000;
    @Resource
    ConfigurableEnvironment environment;
    private static String mediaType = "application/json; charset=UTF-8";

    public PropertiesPropertySource propertySource() {
        return (PropertiesPropertySource)this.environment.getPropertySources().get("possvHttp");
    }

    @PostConstruct
    public void initHttpConfig() {
        staticReadTimeout = this.getReadTimeout();
        staitcConnectTimeout = this.getConnectTimeout();
        statictimeoutlog = this.getTimeoutlog();
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getTimeoutlog() {
        return this.timeoutlog;
    }

    public void setTimeoutlog(int timeoutlog) {
        this.timeoutlog = timeoutlog;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public <T> ServiceResponse doPost(RestTemplate restTemplate, RemoteService remoteService, String method, ServiceSession session, String value, Class<T> targetClass, String serviceName, String methodName) {
        ServiceResponse resp;
        JSONObject jsonRequest;
        String timeZone;
        String flowNo;
        long startTime = System.currentTimeMillis();
        String traceID = flowNo = "";
        Object reqUrl = this.buildRequestUrl(remoteService, method, session, flowNo);
        if (value.contains("timeZone") && StringUtils.isNotBlank((String)(timeZone = (jsonRequest = JSONObject.parseObject((String)value)).getString("timeZone")))) {
            log.info("\u4fdd\u5b58\u8ba2\u5355\u65f6\u533a==>{}", (Object)timeZone);
            reqUrl = (String)reqUrl + "&timeZone=" + timeZone;
        }
        if (FUSE_CODE.equals((resp = HttpUtils.executePost(traceID, (String)reqUrl, session, value, remoteService)).getReturncode())) {
            resp = HttpUtils.retryPost(traceID, (String)reqUrl, session, value, 3, remoteService);
        }
        ServiceResponse originResp = HttpUtils.cloneOriginResp(resp);
        if (("0".equals(resp.getReturncode()) || "1".equals(resp.getReturncode())) && null != resp.getData() && !"".equals(resp.getData())) {
            resp = HttpUtils.convertSuccessResponseData(resp, targetClass);
        }
        ServiceResponse returnResp = HttpUtils.cloneOriginResp(resp);
        ServiceResponse logResp = ServiceResponse.buildSuccess((Object)"");
        long endTime = System.currentTimeMillis();
        HttpLog.log(serviceName, methodName, value, originResp, resp, traceID, endTime - startTime);
        return returnResp;
    }

    public <T> ServiceResponse doMlPost(RestTemplate restTemplate, RemoteService remoteService, String method, ServiceSession session, String value, Class<T> targetClass, String serviceName, String methodName, String accessToken) {
        ServiceResponse resp;
        String flowNo;
        String language = "CN";
        long startTime = System.currentTimeMillis();
        String traceID = flowNo = "";
        if ("en-US".equals(session.getLocale())) {
            language = "EN";
        }
        String reqUrl = GlobalInfo.ocmurl + method + "&language=" + language;
        if (null != accessToken) {
            long ent_id = session.getEnt_id();
            log.info("[ ent_id ]---->[{}]", (Object)("" + ent_id));
            String sign = new MD5Util().md5(value + GlobalInfo.mlsignkey);
            reqUrl = reqUrl + "&ent_id=" + ent_id + "&access_token=" + accessToken + "&sign=" + sign.toUpperCase();
        }
        if (FUSE_CODE.equals((resp = HttpUtils.executePost(traceID, reqUrl, session, value, remoteService)).getReturncode())) {
            resp = HttpUtils.retryPost(traceID, reqUrl, session, value, 3, remoteService);
        }
        ServiceResponse originResp = HttpUtils.cloneOriginResp(resp);
        if (("0".equals(resp.getReturncode()) || "1".equals(resp.getReturncode())) && null != resp.getData() && !"".equals(resp.getData())) {
            resp = HttpUtils.convertSuccessResponseData(resp, targetClass);
        }
        ServiceResponse returnResp = HttpUtils.cloneOriginResp(resp);
        ServiceResponse logResp = ServiceResponse.buildSuccess((Object)"");
        long endTime = System.currentTimeMillis();
        HttpLog.log(serviceName, methodName, value, originResp, resp, traceID, endTime - startTime);
        return returnResp;
    }

    public <T> ServiceResponse doKlxyGet(String cysource, String url, String method, ServiceSession session, String value, Class<T> targetClass, String serviceName, String methodName, String token, String rnd) {
        return this.doKlxy(cysource, url, method, session, value, targetClass, serviceName, methodName, token, rnd, "get", "");
    }

    public <T> ServiceResponse doKlxyGetById(String cysource, String url, String method, ServiceSession session, String value, Class<T> targetClass, String serviceName, String methodName, String token, String rnd, String method1) {
        return this.doKlxy(cysource, url, method, session, value, targetClass, serviceName, methodName, token, rnd, "getByID", method1);
    }

    public <T> ServiceResponse doKlxyGetById(String cysource, String url, String method, ServiceSession session, String value, Class<T> targetClass, String serviceName, String methodName, String token, String rnd) {
        return this.doKlxy(cysource, url, method, session, value, targetClass, serviceName, methodName, token, rnd, "getByID", "");
    }

    public <T> ServiceResponse doKlxyPost(String cysource, String url, String method, ServiceSession session, String value, Class<T> targetClass, String serviceName, String methodName, String token, String rnd) {
        return this.doKlxy(cysource, url, method, session, value, targetClass, serviceName, methodName, token, rnd, "post", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> ServiceResponse doKlxy(String cysource, String url, String method, ServiceSession session, String value, Class<T> targetClass, String serviceName, String methodName, String token, String rnd, String qqfs, String method1) {
        long startTime = System.currentTimeMillis();
        String flowNo = null;
        if (StringUtils.isBlank(flowNo)) {
            flowNo = UUIDUtils.buildGuid();
        }
        String traceID = flowNo;
        String[] split = cysource.split(",");
        String appkey = split[0];
        String appSecret = split[1];
        long timestamp = System.currentTimeMillis();
        Object req = "";
        String reqUrl = "";
        if ("get".equals(qqfs)) {
            j = JSONObject.parseObject((String)value);
            j.put("accessToken", (Object)token);
            j.put("appKey", (Object)appkey);
            j.put("rnd", (Object)rnd);
            j.put("timestamp", (Object)timestamp);
            req = HttpUtils.concatSignString((Map)j);
        } else if ("getByID".equals(qqfs)) {
            j = new JSONObject();
            j.put("accessToken", (Object)token);
            j.put("appKey", (Object)appkey);
            j.put("rnd", (Object)rnd);
            j.put("timestamp", (Object)timestamp);
            req = HttpUtils.concatSignString((Map)j);
        } else {
            req = "accessToken=" + token + "&appKey=" + appkey + "&body=" + value + "&rnd=" + rnd + "&timestamp=" + timestamp;
        }
        log.info("\u6392\u5e8f\u4ee5\u540e\u7684\u53c2\u6570\uff1a" + (String)req);
        String signature = MD5.sign((String)req + appSecret, "UTF-8").toUpperCase();
        reqUrl = "get".equals(qqfs) ? this.buildKlxyGetUrl(url, "", method, (String)req, signature, method1) : ("getByID".equals(qqfs) ? this.buildKlxyGetUrl(url, value, method, (String)req, signature, method1) : this.buildKlxyRequestUrl(url, method, appkey, rnd, token, timestamp, signature));
        log.info("[" + traceID + "]--\u8bf7\u6c42\u5730\u5740-->[{}]", (Object)reqUrl);
        ServiceResponse resp = new ServiceResponse();
        String respStr = "";
        CloseableHttpResponse response = null;
        try {
            log.info("\u8bf7\u6c42\u53c2\u6570:{}", JSONObject.toJSON((Object)value));
            if ("get".equals(qqfs) || "getByID".equals(qqfs)) {
                respStr = HttpClientUtils.get(reqUrl);
            } else {
                DefaultHttpClient httpclient = new DefaultHttpClient();
                HttpPost httppost = new HttpPost(reqUrl);
                httppost.addHeader("Content-Type", "application/json");
                StringEntity myEntity = new StringEntity(value, "UTF-8");
                myEntity.setContentType("application/json");
                httppost.setEntity((HttpEntity)myEntity);
                httpclient.getParams().setParameter("http.connection.timeout", (Object)15000);
                httpclient.getParams().setParameter("http.socket.timeout", (Object)15000);
                response = httpclient.execute((HttpUriRequest)httppost);
                HttpEntity resEntity = response.getEntity();
                respStr = EntityUtils.toString((HttpEntity)resEntity, (String)"UTF-8");
            }
            if ("".equals(respStr)) {
                resp.setReturncode("-1");
                resp.setData(null);
            } else {
                log.info("httpclient\u8fd4\u56de\u6570\u636e[{}]", (Object)respStr);
                resp.setData(JSON.parse((String)respStr));
                resp.setReturncode("0");
            }
        }
        catch (Exception e) {
            StackTraceElement[] trace;
            Object sOut = "";
            for (StackTraceElement s : trace = e.getStackTrace()) {
                sOut = (String)sOut + "\tat " + s + "\r\n";
            }
            log.info("\u58a8\u535a\u4e91\u821f\u4e2d\u53f0\u8bf7\u6c42\u5931\u8d25:[{}]", sOut);
            resp = ServiceResponse.buildFailure((ServiceSession)session, (String)"60003", (String)"[\u58a8\u535a\u4e91\u821f]-->\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        finally {
            if (response != null) {
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        long endTime = System.currentTimeMillis();
        ServiceResponse originResp = HttpUtils.cloneOriginResp(resp);
        if ("0".equals(resp.getReturncode()) || "1".equals(resp.getReturncode())) {
            resp = HttpUtils.convertSuccessResponseData(resp, targetClass);
        }
        HttpLog.log(serviceName, methodName, value, originResp, resp, traceID, endTime - startTime);
        return resp;
    }

    public <T> ServiceResponse doSjgwMember(String cysource, String url, String method, ServiceSession session, String value, Class<T> targetClass, String serviceName, String methodName) {
        return this.doSjgw(cysource, url, method, session, value, targetClass, serviceName, methodName, true, null);
    }

    public <T> ServiceResponse doSjgwPoint(String cysource, String url, String method, ServiceSession session, String value, Class<T> targetClass, String serviceName, String methodName, String extra) {
        return this.doSjgw(cysource, url, method, session, value, targetClass, serviceName, methodName, true, extra);
    }

    public <T> ServiceResponse doSjgw(String cysource, String url, String method, ServiceSession session, String value, Class<T> targetClass, String serviceName, String methodName) {
        return this.doSjgw(cysource, url, method, session, value, targetClass, serviceName, methodName, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> ServiceResponse doSjgw(String cysource, String url, String method, ServiceSession session, String value, Class<T> targetClass, String serviceName, String methodName, boolean isSign, String extra) {
        long startTime = System.currentTimeMillis();
        String traceID = UUIDUtils.buildGuid();
        String req = "";
        String reqUrl = "";
        log.info("\u6392\u5e8f\u4ee5\u540e\u7684\u53c2\u6570\uff1a" + req);
        reqUrl = isSign ? this.buildSjgwUrl(url, method, value) : this.buildPostUrl(url, method);
        log.info("[" + traceID + "]--\u8bf7\u6c42\u5730\u5740-->[{}]", (Object)reqUrl);
        String sign = "";
        if (!isSign) {
            sign = AuthUtil.hmac(cysource, "POST" + value, "HmacSHA256", "UTF-8");
            log.info("\u8bf7\u6c42\u7b7e\u540d" + sign);
        }
        ServiceResponse resp = new ServiceResponse();
        String respStr = "";
        CloseableHttpResponse response = null;
        try {
            log.info("\u8bf7\u6c42\u53c2\u6570:{}", JSONObject.toJSON((Object)value));
            DefaultHttpClient httpclient = new DefaultHttpClient();
            HttpPost httppost = new HttpPost(reqUrl);
            if (StringUtils.isNotBlank((String)extra)) {
                MultipartEntityBuilder builder = MultipartEntityBuilder.create();
                builder.addPart("extra", (ContentBody)new StringBody(extra, ContentType.create((String)"text/plain", (Charset)Consts.UTF_8)));
                HttpEntity reqEntity = builder.build();
                httppost.setEntity(reqEntity);
            } else {
                httppost.addHeader("Content-Type", "application/json");
                if (StringUtils.isNotBlank((String)sign)) {
                    httppost.addHeader("authorization", "Sanjiang-Finnet v0.1HMAC:sanjiang:" + sign);
                }
                StringEntity myEntity = new StringEntity(value, "UTF-8");
                myEntity.setContentType("application/json");
                httppost.setEntity((HttpEntity)myEntity);
            }
            httpclient.getParams().setParameter("http.connection.timeout", (Object)15000);
            httpclient.getParams().setParameter("http.socket.timeout", (Object)15000);
            response = httpclient.execute((HttpUriRequest)httppost);
            HttpEntity resEntity = response.getEntity();
            respStr = EntityUtils.toString((HttpEntity)resEntity, (String)"UTF-8");
            if ("".equals(respStr)) {
                resp.setReturncode("-1");
                resp.setData(null);
            } else {
                log.info("httpclient\u8fd4\u56de\u6570\u636e[{}]", (Object)respStr);
                resp.setData(JSON.parse((String)respStr));
                resp.setReturncode("0");
            }
        }
        catch (Exception e) {
            StackTraceElement[] trace;
            Object sOut = "";
            for (StackTraceElement s : trace = e.getStackTrace()) {
                sOut = (String)sOut + "\tat " + s + "\r\n";
            }
            log.info("\u4e09\u6c5f\u8d2d\u7269\u4e2d\u53f0\u8bf7\u6c42\u5931\u8d25:[{}]", sOut);
            resp = ServiceResponse.buildFailure((ServiceSession)session, (String)"60003", (String)"[\u4e09\u6c5f\u8d2d\u7269]-->\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        finally {
            if (response != null) {
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        long endTime = System.currentTimeMillis();
        ServiceResponse originResp = HttpUtils.cloneOriginResp(resp);
        if ("0".equals(resp.getReturncode()) || "1".equals(resp.getReturncode())) {
            resp = HttpUtils.convertSuccessResponseData(resp, targetClass);
        }
        HttpLog.log(serviceName, methodName, value, originResp, resp, traceID, endTime - startTime);
        return resp;
    }

    public <T> ServiceResponse doSJPost(RemoteService remoteService, String method, ServiceSession session, String value, Class<T> targetClass, String serviceName, String methodName, String accessToken) {
        ServiceResponse resp;
        String flowNo;
        String language = "CN";
        long startTime = System.currentTimeMillis();
        String traceID = flowNo = "";
        if ("en-US".equals(session.getLocale())) {
            language = "EN";
        }
        String reqUrl = GlobalInfo.ocmurl + method + "&language=" + language;
        if (null != accessToken) {
            long ent_id = session.getEnt_id();
            log.info("[ ent_id ]---->[{}]", (Object)("" + ent_id));
            String sign = new MD5Util().md5(value + GlobalInfo.mlsignkey);
            reqUrl = reqUrl + "&ent_id=" + ent_id + "&access_token=" + accessToken + "&sign=" + sign.toUpperCase();
        }
        if (FUSE_CODE.equals((resp = HttpUtils.executePost(traceID, reqUrl, session, value, remoteService)).getReturncode())) {
            resp = HttpUtils.retryPost(traceID, reqUrl, session, value, 3, remoteService);
        }
        ServiceResponse originResp = HttpUtils.cloneOriginResp(resp);
        if (("0".equals(resp.getReturncode()) || "1".equals(resp.getReturncode())) && null != resp.getData() && !"".equals(resp.getData())) {
            resp = HttpUtils.convertSuccessResponseData(resp, targetClass);
        }
        ServiceResponse returnResp = HttpUtils.cloneOriginResp(resp);
        ServiceResponse logResp = ServiceResponse.buildSuccess((Object)"");
        long endTime = System.currentTimeMillis();
        HttpLog.log(serviceName, methodName, value, originResp, resp, traceID, endTime - startTime);
        return returnResp;
    }

    public <T> ServiceResponse backPrintDoPost(RestTemplate restTemplate, String remoteUrl, RemoteService remoteService, String method, ServiceSession session, String value, Class<T> targetClass, String serviceName, String methodName) {
        String flowNo;
        long startTime = System.currentTimeMillis();
        String traceID = flowNo = "";
        Object reqUrl = "";
        reqUrl = null == remoteUrl || remoteUrl.length() == 0 ? this.buildOuterRequestUrl(remoteService, method, session) : remoteUrl + method;
        ServiceResponse resp = HttpUtils.executePost(traceID, (String)reqUrl, session, value, remoteService);
        ServiceResponse originResp = HttpUtils.cloneOriginResp(resp);
        if ("0".equals(resp.getReturncode())) {
            resp = HttpUtils.convertSuccessResponseData(resp, targetClass);
        }
        ServiceResponse returnResp = HttpUtils.cloneOriginResp(resp);
        ServiceResponse logResp = ServiceResponse.buildSuccess((Object)"");
        long endTime = System.currentTimeMillis();
        return returnResp;
    }

    public <T> ServiceResponse noFlowNoPost(RestTemplate restTemplate, RemoteService remoteService, String method, ServiceSession session, String value, Class<T> targetClass, String serviceName, String methodName) {
        long startTime = System.currentTimeMillis();
        String traceID = UUIDUtils.buildGuid();
        Object reqUrl = this.buildRequestUrl(remoteService, method, session, traceID);
        ServiceResponse resp = HttpUtils.executePost(traceID, (String)(reqUrl = (String)reqUrl + "&noFlowNo=1"), session, value, remoteService);
        if (FUSE_CODE.equals(resp.getReturncode())) {
            resp = HttpUtils.retryPost(traceID, (String)reqUrl, session, value, 3, remoteService);
        }
        ServiceResponse originResp = HttpUtils.cloneOriginResp(resp);
        if ("0".equals(resp.getReturncode()) || "1".equals(resp.getReturncode())) {
            resp = HttpUtils.convertSuccessResponseData(resp, targetClass);
        }
        long endTime = System.currentTimeMillis();
        ServiceResponse logResp = new ServiceResponse();
        return resp;
    }

    public <T> ServiceResponse eSystemPost(RestTemplate restTemplate, RemoteService remoteService, String method, ServiceSession session, String value, Class<T> targetClass, String serviceName, String methodName) {
        long startTime = System.currentTimeMillis();
        String traceID = UUIDUtils.buildGuid();
        String reqUrl = this.buildOuterRequestUrl(remoteService, method, session);
        ServiceResponse resp = HttpUtils.executeEsystemPost(restTemplate, traceID, reqUrl, session, value, remoteService);
        long endTime = System.currentTimeMillis();
        ServiceResponse originResp = HttpUtils.cloneOriginResp(resp);
        if ("0".equals(resp.getReturncode()) || "1".equals(resp.getReturncode())) {
            resp = HttpUtils.convertSuccessResponseData(resp, targetClass);
        }
        return resp;
    }

    public <T> ServiceResponse doPostWithOutRetry(RestTemplate restTemplate, RemoteService remoteService, String method, ServiceSession session, String value, Class<T> targetClass, String serviceName, String methodName) {
        String flowNo;
        long startTime = System.currentTimeMillis();
        String traceID = flowNo = "";
        String reqUrl = this.buildRequestUrl(remoteService, method, session, flowNo);
        ServiceResponse resp = HttpUtils.externalPost(restTemplate, traceID, reqUrl, session, value, remoteService);
        ServiceResponse originResp = HttpUtils.cloneOriginResp(resp);
        if ("0".equals(resp.getReturncode()) || "1".equals(resp.getReturncode())) {
            resp = HttpUtils.convertSuccessResponseData(resp, targetClass);
        }
        ServiceResponse returnResp = HttpUtils.cloneOriginResp(resp);
        long endTime = System.currentTimeMillis();
        return returnResp;
    }

    public <T> ServiceResponse flowNoEndPost(RestTemplate restTemplate, RemoteService remoteService, String method, ServiceSession session, String value, Class<T> targetClass, String serviceName, String methodName) {
        String flowNo;
        long startTime = System.currentTimeMillis();
        String traceID = flowNo = "";
        Object reqUrl = this.buildRequestUrl(remoteService, method, session, flowNo);
        ServiceResponse resp = HttpUtils.executePost(traceID, (String)(reqUrl = (String)reqUrl + "&flowEnd=1"), session, value, remoteService);
        if (FUSE_CODE.equals(resp.getReturncode())) {
            resp = HttpUtils.retryPost(traceID, (String)reqUrl, session, value, 3, remoteService);
        }
        ServiceResponse originResp = HttpUtils.cloneOriginResp(resp);
        try {
            if ("0".equals(resp.getReturncode()) || "1".equals(resp.getReturncode())) {
                resp = HttpUtils.convertSuccessResponseData(resp, targetClass);
            }
            long l = System.currentTimeMillis();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resp;
    }

    private static ServiceResponse retryPost(String traceID, String templateURL, ServiceSession session, String value, Integer retryCount, RemoteService remoteService) {
        if (null == retryCount) {
            retryCount = 1;
        }
        if (retryCount <= 0) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)OFFLINE_CODE, (String)HttpUtils.errorMessage(remoteService, session, null));
        }
        ServiceResponse resp = HttpUtils.executePost(traceID, templateURL, session, value, remoteService);
        if (FUSE_CODE.equals(resp.getReturncode())) {
            retryCount = retryCount - 1;
            return HttpUtils.retryPost(traceID, templateURL, session, value, retryCount, remoteService);
        }
        return resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ServiceResponse executePost(String traceID, String templateURL, ServiceSession session, String value, RemoteService remoteService) {
        ServiceResponse resp;
        long startTime = System.currentTimeMillis();
        try {
            StatisticUtils.onIncrementMethod((String)templateURL, (long)startTime);
            log.info("[" + traceID + "]--\u8bf7\u6c42\u5730\u5740-->[{}]", (Object)templateURL);
            Http http = new Http();
            log.info("\u5165\u53c2==>{}", (Object)value);
            String respStr = http.httpPostData(templateURL, value, 20000, false);
            long getresp = System.currentTimeMillis();
            resp = (ServiceResponse)JSON.parseObject((String)respStr, ServiceResponse.class);
            log.info("\u8fd4\u56de==>{}", (Object)JSONObject.toJSONString((Object)resp));
            long parsResp = System.currentTimeMillis();
            log.info("[" + traceID + "]--\u8bf7\u6c42\u7528\u65f6-->[{}] --\u8f6c\u6362\u7528\u65f6-->[{}] ", (Object)(getresp - startTime), (Object)(parsResp - getresp));
            if (null == resp) {
                throw new RuntimeException();
            }
        }
        catch (Exception e) {
            resp = ServiceResponse.buildFailure((ServiceSession)session, (String)"60003", (String)HttpUtils.errorMessage(remoteService, session, e));
        }
        finally {
            long endTimeMillis = System.currentTimeMillis();
            long elapsed = endTimeMillis - startTime;
            StatisticUtils.onDecrementMethod((String)templateURL, (Long)elapsed);
        }
        return resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ServiceResponse executeGet(Header[] headers, String traceID, String templateURL, ServiceSession session, String value, RemoteService remoteService) {
        ServiceResponse resp;
        long startTime = System.currentTimeMillis();
        try {
            StatisticUtils.onIncrementMethod((String)templateURL, (long)startTime);
            log.info("[" + traceID + "]--\u8bf7\u6c42\u5730\u5740-->[{}]", (Object)templateURL);
            Http http = new Http();
            log.info("\u5165\u53c2==>{}", (Object)value);
            String respStr = http.executeGet(headers, templateURL, 20000);
            JSONObject jsonObject = JSONObject.parseObject((String)respStr);
            resp = new ServiceResponse();
            if ("200".equals(jsonObject.getString("httpCode"))) {
                resp.setReturncode("0");
            } else {
                resp.setReturncode(jsonObject.getString("httpCode"));
            }
            resp.setData((Object)jsonObject.getString("response"));
            long getresp = System.currentTimeMillis();
            log.info("\u8fd4\u56de==>{}", (Object)JSONObject.toJSONString((Object)resp));
            long parsResp = System.currentTimeMillis();
            log.info("[" + traceID + "]--\u8bf7\u6c42\u7528\u65f6-->[{}] --\u8f6c\u6362\u7528\u65f6-->[{}] ", (Object)(getresp - startTime), (Object)(parsResp - getresp));
            if (null == resp) {
                throw new RuntimeException();
            }
        }
        catch (Exception e) {
            resp = ServiceResponse.buildFailure((ServiceSession)session, (String)"60003", (String)HttpUtils.errorMessage(remoteService, session, e));
        }
        finally {
            long endTimeMillis = System.currentTimeMillis();
            long elapsed = endTimeMillis - startTime;
            StatisticUtils.onDecrementMethod((String)templateURL, (Long)elapsed);
        }
        return resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ServiceResponse executePost(Map<String, String> headers, String traceID, String templateURL, ServiceSession session, String value, RemoteService remoteService) {
        ServiceResponse resp;
        long startTime = System.currentTimeMillis();
        try {
            StatisticUtils.onIncrementMethod((String)templateURL, (long)startTime);
            log.info("[" + traceID + "]--\u8bf7\u6c42\u5730\u5740-->[{}]", (Object)templateURL);
            log.info("\u5165\u53c2==>{}", (Object)value);
            String respStr = HttpClientUtils.postJsonParams(headers, templateURL, value);
            JSONObject jsonObject = JSONObject.parseObject((String)respStr);
            resp = new ServiceResponse();
            if ("200".equals(jsonObject.getString("httpCode"))) {
                resp.setReturncode("0");
            } else {
                resp.setReturncode(jsonObject.getString("httpCode"));
            }
            resp.setData((Object)jsonObject.getString("response"));
            long getresp = System.currentTimeMillis();
            log.info("\u8fd4\u56de==>{}", (Object)JSONObject.toJSONString((Object)resp));
            long parsResp = System.currentTimeMillis();
            log.info("[" + traceID + "]--\u8bf7\u6c42\u7528\u65f6-->[{}] --\u8f6c\u6362\u7528\u65f6-->[{}] ", (Object)(getresp - startTime), (Object)(parsResp - getresp));
            if (null == resp) {
                throw new RuntimeException();
            }
        }
        catch (Exception e) {
            resp = ServiceResponse.buildFailure((ServiceSession)session, (String)"60003", (String)"\u8bf7\u6c42\u5f02\u5e38");
        }
        finally {
            long endTimeMillis = System.currentTimeMillis();
            long elapsed = endTimeMillis - startTime;
            StatisticUtils.onDecrementMethod((String)templateURL, (Long)elapsed);
        }
        return resp;
    }

    public String buildRequestUrl(RemoteService service, String method, ServiceSession session, String flowNo) {
        if (method.startsWith("http")) {
            return method;
        }
        long ent_id = session.getEnt_id();
        log.info("[ ent_id ]---->[{}]", (Object)("" + ent_id));
        String url = this.getRemoteServiceUrl(service) + "?flowNo=" + flowNo + "&ent_id=" + ent_id + "&method=" + method;
        if (HttpUtils.isNeedTokenAuthc(service)) {
            String token = HttpUtils.getToken();
            url = url + "&token=" + token;
        }
        if (HttpUtils.isNeedShopCode(service)) {
            url = url + "&shop_code=" + session.getShop_code();
        }
        if (StringUtils.isNotBlank((String)session.getLocale())) {
            url = url + "&locale=" + session.getLocale();
        }
        return url;
    }

    public String buildRequestUrl(String url, String method, ServiceSession session, String flowNo) {
        if (method.startsWith("http")) {
            return method;
        }
        long ent_id = session.getEnt_id();
        log.info("[ ent_id ]---->[{}]", (Object)("" + ent_id));
        url = (String)url + "?flowNo=" + flowNo + "&ent_id=" + ent_id + "&method=" + method;
        String token = HttpUtils.getToken();
        url = (String)url + "&token=" + token;
        return url;
    }

    public String buildOuterRequestUrl(RemoteService service, String method, ServiceSession session) {
        if (method.startsWith("http")) {
            return method;
        }
        String url = this.getRemoteServiceUrl(service) + method;
        return url;
    }

    private String getRemoteServiceUrl(RemoteService service) {
        String alias = service.getAlias();
        if ("http.order.url".equals(alias)) {
            return GlobalInfo.ourl;
        }
        if ("http.promotion.event.url".equals(alias)) {
            return GlobalInfo.purl;
        }
        if ("http.promotion.coupon.url".equals(alias)) {
            return GlobalInfo.cpurl;
        }
        if ("http.inventory.url".equals(alias)) {
            return GlobalInfo.pdurl;
        }
        if ("http.ali.url".equals(alias)) {
            return GlobalInfo.aliurl;
        }
        if ("http.group.url".equals(alias)) {
            return GlobalInfo.zsGroupUrl;
        }
        if ("http.skp.url".equals(alias)) {
            return GlobalInfo.skpurl;
        }
        if ("http.ocm.url".equals(alias)) {
            return GlobalInfo.ocmurl;
        }
        if ("http.myshop.group.url".equals(alias)) {
            return GlobalInfo.myShopGroupUrl;
        }
        if ("http.myshop.backrebate.url".equals(alias)) {
            return GlobalInfo.myShopBackRebateUrl;
        }
        if ("http.promotion.activity.url".equals(alias)) {
            return GlobalInfo.bcurl;
        }
        return GlobalInfo.purl;
    }

    public String buildSkpRequestUrl(String url, String source, String dest, String method) {
        url = (String)url + "source=" + source + "&dest=" + dest + "&op=" + method;
        return url;
    }

    public String buildKlxyRequestUrl(String url, String method, String appkey, String rnd, String token, long timestamp, String sign) {
        url = (String)url + method + "?accessToken=" + token + "&rnd=" + rnd + "&appKey=" + appkey + "&timestamp=" + timestamp + "&sign=" + sign + "&signType=md5";
        return url;
    }

    public String buildKlxyGetUrl(String url, String id, String method, String value, String sign, String method1) {
        url = (String)url + method + id + method1 + "?" + value + "&sign=" + sign + "&signType=md5";
        return url;
    }

    public String buildErajayaGetUrl(String url, String method, String value) {
        url = (String)url + method;
        if (StringUtils.isNotBlank((String)value)) {
            url = (String)url + "/" + value;
        }
        return url;
    }

    public String buildSjgwUrl(String url, String method, String value) {
        url = (String)url + method;
        if (StringUtils.isNotBlank((String)value)) {
            url = (String)url + "?" + value;
        }
        return url;
    }

    public String buildPostUrl(String url, String method) {
        return url + method;
    }

    public String buildErajayaPostUrl(String url, String method) {
        return url + method;
    }

    public static String getToken() {
        return "1592161107706568120";
    }

    private static boolean isNeedTokenAuthc(RemoteService service) {
        return true;
    }

    private static boolean isNeedShopCode(RemoteService service) {
        return true;
    }

    private static boolean isNeedSign(RemoteService service) {
        return "http.ocm.url".equals(service.alias);
    }

    protected static ServiceResponse cloneOriginResp(ServiceResponse origin) {
        ServiceResponse originResp = new ServiceResponse();
        originResp.setReturncode(origin.getReturncode());
        originResp.setData(origin.getData());
        return originResp;
    }

    private static ServiceResponse executeEsystemPost(RestTemplate restTemplate, String traceID, String templateURL, ServiceSession session, String value, RemoteService remoteService) {
        ServiceResponse resp = new ServiceResponse();
        String respStr = "";
        try {
            log.info("[" + traceID + "]--\u8bf7\u6c42\u5730\u5740-->[{}]", (Object)templateURL);
            respStr = (String)DiscoveryRestUtils.onHttpPost((RestTemplate)restTemplate, (String)traceID, (int)10000, (int)10000, (String)mediaType, (String)templateURL, Collections.singletonMap("session", JSON.toJSONString((Object)session)), (String)value, String.class, HttpUtils.class);
            if ("".equals(respStr)) {
                resp.setReturncode("-1");
                resp.setData(null);
            } else {
                respStr = respStr.replace("\\", "");
                respStr = respStr.replace("\"{", "{");
                respStr = respStr.replace("}\"", "}");
                resp.setData(JSON.parse((String)respStr));
                resp.setReturncode("0");
            }
        }
        catch (Exception e) {
            log.info("\u6c38\u65faeSystem:" + e.getMessage());
            resp = ServiceResponse.buildFailure((ServiceSession)session, (String)"60003", (String)HttpUtils.errorMessage(remoteService, session, e));
        }
        return resp;
    }

    protected static <T> ServiceResponse convertSuccessResponseData(ServiceResponse resp, Class<T> targetClass) {
        Object obj = "";
        if (targetClass != null) {
            if (null != resp.getData()) {
                obj = JSON.toJSON((Object)resp.getData());
            }
            String jsonString = obj.toString();
            if (targetClass == String.class) {
                obj = jsonString;
            } else if (obj instanceof JSONObject) {
                obj = JSON.parseObject((String)jsonString, targetClass);
            } else if (obj instanceof JSONArray) {
                obj = JSON.parseArray((String)jsonString, targetClass);
            }
            resp.setData(obj);
        }
        return resp;
    }

    private static String errorMessage(RemoteService remoteService, ServiceSession session, Exception e) {
        if (null != e) {
            if ("en-US".equals(session.getLocale())) {
                log.error("network anomaly", (Throwable)e);
            } else {
                log.error("\u7f51\u7edc\u5f02\u5e38", (Throwable)e);
            }
        }
        Object error = "[possv\u670d\u52a1\u63d0\u9192\u60a8,";
        switch (remoteService.getAlias()) {
            case "http.mdm.url": {
                if ("en-US".equals(session.getLocale())) {
                    error = "master data";
                    break;
                }
                error = "\u4e3b\u6570\u636e";
                break;
            }
            case "http.promotion.event.url": {
                if ("en-US".equals(session.getLocale())) {
                    error = "Marketing Center [Promotion&Event&Voucher]";
                    break;
                }
                error = "\u8425\u9500\u4e2d\u5fc3[\u4fc3\u9500&\u6d3b\u52a8&\u5238]";
                break;
            }
            case "http.promotion.info.url": {
                if ("en-US".equals(session.getLocale())) {
                    error = "Marketing Center [Membership&Certification]";
                    break;
                }
                error = "\u8425\u9500\u4e2d\u5fc3[\u4f1a\u5458&\u8ba4\u8bc1]";
                break;
            }
            case "http.promotion.activity.url": {
                error = "\u8425\u9500\u4e2d\u5fc3[\u6d3b\u52a8&\u4e70\u5238]";
                break;
            }
            case "http.promotion.accnt.url": {
                error = "\u8425\u9500\u4e2d\u5fc3[\u5238\u6fc0\u6d3b]";
                break;
            }
            case "http.warehouse.url": {
                error = "\u5e93\u5b58\u4e2d\u5fc3";
                break;
            }
            case "http.order.url": {
                error = "\u8ba2\u5355\u4e2d\u5fc3";
                break;
            }
            case "http.contract.url": {
                error = "\u5c65\u7ea6\u4e2d\u5fc3";
                break;
            }
            case "http.posmanager.url": {
                error = "POS\u603b\u90e8";
                break;
            }
            case "http.possv.cloud.url": {
                error = "\u4e91\u7aefPOS\u4e2d\u53f0";
                break;
            }
            case "http.crm.ibm.url": {
                error = "\u6c38\u65facrm\u7cfb\u7edf";
                break;
            }
            case "http.esystem.url": {
                error = "\u6c38\u65faeSystem";
                break;
            }
            case "http.backPrint.url": {
                error = "\u540e\u53a8\u6253\u5370";
                break;
            }
            case "http.zhongbai.url": {
                error = "\u4e2d\u767e\u5238\u5e73\u53f0";
                break;
            }
            case "http.store.url": {
                error = "\u95e8\u5e97\u4f5c\u4e1a";
                break;
            }
        }
        error = "en-US".equals(session.getLocale()) ? "]-->Network error, please try again!" : (String)error + "]-->\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u91cd\u8bd5\uff01";
        log.info((String)error);
        return error;
    }

    protected String getEnvValue(String keySource) {
        String keyData = keySource.toString();
        int startPos = keyData.indexOf("${");
        if (startPos >= 0) {
            Pattern pattern = Pattern.compile("(\\$\\{[^>]*?\\})");
            StringBuffer buffer = new StringBuffer();
            Matcher matcher = pattern.matcher(keyData);
            while (matcher.find()) {
                String findKey = matcher.group();
                String dataKey = findKey.replaceAll("\\$\\{", "").replaceAll("\\}", "");
                String dataNew = this.environment.getProperty(dataKey);
                if (StringUtils.isEmpty((String)dataNew)) continue;
                matcher.appendReplacement(buffer, dataNew.toString());
            }
            matcher.appendTail(buffer);
            return buffer.toString();
        }
        return keySource;
    }

    public String getRemoteUrl(RemoteService server) throws RuntimeException {
        String response = (String)this.propertySource().getProperty(server.getAlias());
        return this.getEnvValue(response);
    }

    private static ServiceResponse externalPost(RestTemplate restTemplate, String traceID, String templateURL, ServiceSession session, String value, RemoteService remoteService) {
        ServiceResponse resp = new ServiceResponse();
        try {
            log.info("[" + traceID + "]--\u8bf7\u6c42\u5730\u5740-->[{}]", (Object)templateURL);
            String respStr = (String)DiscoveryRestUtils.onHttpPost((RestTemplate)restTemplate, (String)traceID, (int)staitcConnectTimeout, (int)staticReadTimeout, (String)mediaType, (String)templateURL, Collections.singletonMap("session", JSON.toJSONString((Object)session)), (String)value, String.class, HttpUtils.class);
            if (null == respStr) {
                resp.setReturncode("-1");
                resp.setData(null);
            } else {
                resp.setReturncode("0");
                resp.setData((Object)respStr);
            }
        }
        catch (Exception e) {
            resp = ServiceResponse.buildFailure((ServiceSession)session, (String)"60003", (String)HttpUtils.errorMessage(remoteService, session, e));
        }
        return resp;
    }

    public <T> ServiceResponse zhongbaiDataCenterPost(RestTemplate restTemplate, RemoteService remoteService, String method, ServiceSession session, String value, Class<T> targetClass, String serviceName, String methodName) {
        long startTime = System.currentTimeMillis();
        String flowNo = null;
        if (StringUtils.isBlank(flowNo)) {
            flowNo = UUIDUtils.buildGuid();
        }
        String traceID = flowNo;
        String reqUrl = this.buildOuterRequestUrl(remoteService, method, session);
        ServiceResponse resp = HttpUtils.executeZhongbaiDataCenterPost(restTemplate, traceID, reqUrl, session, value, remoteService);
        long endTime = System.currentTimeMillis();
        ServiceResponse originResp = HttpUtils.cloneOriginResp(resp);
        if ("0".equals(resp.getReturncode()) || "1".equals(resp.getReturncode())) {
            resp = HttpUtils.convertSuccessResponseData(resp, targetClass);
        }
        HttpLog.log(serviceName, methodName, value, originResp, resp, traceID, endTime - startTime);
        return resp;
    }

    private static ServiceResponse executeZhongbaiDataCenterPost(RestTemplate restTemplate, String traceID, String templateURL, ServiceSession session, String value, RemoteService remoteService) {
        ServiceResponse resp = new ServiceResponse();
        String respStr = "";
        try {
            String signValue = "";
            log.info("[" + traceID + "]--\u8bf7\u6c42\u5730\u5740-->[{}]", (Object)templateURL);
            log.info("\u8bf7\u6c42\u53c2\u6570:{}", JSONObject.toJSON((Object)value));
            DefaultHttpClient httpclient = new DefaultHttpClient();
            HttpPost httppost = new HttpPost(templateURL);
            StringEntity myEntity = new StringEntity(value);
            httppost.addHeader("Content-Type", "application/json");
            httppost.addHeader("X-Sign", signValue);
            httppost.setEntity((HttpEntity)myEntity);
            httpclient.getParams().setParameter("http.connection.timeout", (Object)15000);
            httpclient.getParams().setParameter("http.socket.timeout", (Object)15000);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httppost);
            HttpEntity resEntity = response.getEntity();
            InputStreamReader reader = new InputStreamReader(resEntity.getContent(), "UTF-8");
            char[] buff = new char[1024];
            int length = 0;
            while ((length = reader.read(buff)) != -1) {
                respStr = new String(buff, 0, length);
            }
            httpclient.getConnectionManager().shutdown();
            if ("".equals(respStr)) {
                resp.setReturncode("-1");
                resp.setData(null);
            } else {
                log.info("httpclient\u8fd4\u56de\u6570\u636e[{}]", (Object)respStr);
                resp.setData(JSON.parse((String)respStr));
                resp.setReturncode("0");
            }
        }
        catch (Exception e) {
            StackTraceElement[] trace;
            Object sOut = "";
            for (StackTraceElement s : trace = e.getStackTrace()) {
                sOut = (String)sOut + "\tat " + s + "\r\n";
            }
            log.info("\u4e2d\u767e\u4e91\u4e2d\u53f0\u8bf7\u6c42\u5931\u8d25:[{}]", sOut);
            resp = ServiceResponse.buildFailure((ServiceSession)session, (String)"60003", (String)HttpUtils.errorMessage(remoteService, session, e));
        }
        return resp;
    }

    public <T> ServiceResponse aliPost(RemoteService remoteService, String method, ServiceSession session, String value, Class<T> targetClass, String serviceName, String methodName) {
        long startTime = System.currentTimeMillis();
        String flowNo = null;
        if (StringUtils.isBlank(flowNo)) {
            flowNo = UUIDUtils.buildGuid();
        }
        String traceID = flowNo;
        String reqUrl = this.buildOuterRequestUrl(remoteService, method, session);
        ServiceResponse resp = HttpUtils.executeAliPost(traceID, reqUrl, session, value, remoteService);
        long endTime = System.currentTimeMillis();
        ServiceResponse originResp = HttpUtils.cloneOriginResp(resp);
        if ("0".equals(resp.getReturncode()) || "1".equals(resp.getReturncode())) {
            resp = HttpUtils.convertSuccessResponseData(resp, targetClass);
        }
        HttpLog.log(serviceName, methodName, value, originResp, resp, traceID, endTime - startTime);
        return resp;
    }

    private static ServiceResponse executeAliPost(String traceID, String templateURL, ServiceSession session, String value, RemoteService remoteService) {
        ServiceResponse resp = new ServiceResponse();
        String respStr = "";
        try {
            log.info("[" + traceID + "]--\u8bf7\u6c42\u5730\u5740-->[{}]", (Object)templateURL);
            log.info("\u8bf7\u6c42\u53c2\u6570:{}", JSONObject.toJSON((Object)value));
            String appId = "test2hgC1gCigShWufZTOHfwA";
            String appSecret = "ETJMZCEbiE2k47DynzjTAAxekZU";
            String timestamp = "" + System.currentTimeMillis();
            String signature = HttpUtils.getSHA1(appId, timestamp, appSecret);
            DefaultHttpClient httpclient = new DefaultHttpClient();
            HttpPost httppost = new HttpPost(templateURL);
            httppost.addHeader("Content-Type", "application/json");
            httppost.addHeader("appId", appId);
            httppost.addHeader("timestamp", timestamp);
            httppost.addHeader("signature", signature);
            StringEntity myEntity = new StringEntity(value, "UTF-8");
            myEntity.setContentType("application/json");
            httppost.setEntity((HttpEntity)myEntity);
            httpclient.getParams().setParameter("http.connection.timeout", (Object)15000);
            httpclient.getParams().setParameter("http.socket.timeout", (Object)15000);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httppost);
            HttpEntity resEntity = response.getEntity();
            InputStreamReader reader = new InputStreamReader(resEntity.getContent(), "UTF-8");
            char[] buff = new char[1024];
            int length = 0;
            while ((length = reader.read(buff)) != -1) {
                respStr = new String(buff, 0, length);
            }
            httpclient.getConnectionManager().shutdown();
            if ("".equals(respStr)) {
                resp.setReturncode("-1");
                resp.setData(null);
            } else {
                log.info("httpclient\u8fd4\u56de\u6570\u636e[{}]", (Object)respStr);
                resp.setData(JSON.parse((String)respStr));
                resp.setReturncode("0");
            }
        }
        catch (Exception e) {
            StackTraceElement[] trace;
            Object sOut = "";
            for (StackTraceElement s : trace = e.getStackTrace()) {
                sOut = (String)sOut + "\tat " + s + "\r\n";
            }
            log.info("\u963f\u91cc\u50a8\u503c\u5361\u8bf7\u6c42\u5931\u8d25:[{}]", sOut);
            resp = ServiceResponse.buildFailure((ServiceSession)session, (String)"60003", (String)HttpUtils.errorMessage(remoteService, session, e));
        }
        return resp;
    }

    public <T> ServiceResponse doPostJson(ServiceSession session, RemoteService remoteService, String value, Class<T> targetClass, String serviceName, String methodName) {
        long startTime = System.currentTimeMillis();
        String traceID = UUIDUtils.buildGuid();
        ServiceResponse resp = new ServiceResponse();
        String url = this.getRemoteServiceUrl(remoteService);
        try {
            DefaultHttpClient httpClient = new DefaultHttpClient();
            HttpPost httpPost = new HttpPost(url);
            StringEntity entity = new StringEntity(value, ContentType.APPLICATION_JSON);
            httpPost.setEntity((HttpEntity)entity);
            HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new Exception("\u8bf7\u6c42\u8fd4\u56de\u72b6\u6001\u975e200\uff1a" + response.getStatusLine().getStatusCode());
            }
            String res = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
            if (null == res || "".equals(res)) {
                resp = ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"\u8bf7\u6c42\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
            } else {
                JSONObject jsonObject = JSONObject.parseObject((String)res);
                resp = ServiceResponse.buildSuccess((Object)jsonObject);
            }
        }
        catch (Exception e) {
            resp = ServiceResponse.buildFailure((ServiceSession)session, (String)"60003", (String)"\u8bf7\u6c42\u53d1\u751f\u5f02\u5e38");
        }
        long endTime = System.currentTimeMillis();
        ServiceResponse originResp = HttpUtils.cloneOriginResp(resp);
        if ("0".equals(resp.getReturncode())) {
            resp = HttpUtils.convertSuccessResponseData(resp, targetClass);
        }
        return resp;
    }

    public <T> ServiceResponse doPostForWorklog(RestTemplate restTemplate, RemoteService remoteService, String method, ServiceSession session, String value, Class<T> targetClass, String serviceName, String methodName, String flowNo) {
        long startTime = System.currentTimeMillis();
        String traceID = flowNo;
        String reqUrl = this.buildRequestUrl(remoteService, method, session, traceID);
        ServiceResponse resp = HttpUtils.executePost(traceID, reqUrl, session, value, remoteService);
        if (FUSE_CODE.equals(resp.getReturncode())) {
            resp = HttpUtils.retryPost(traceID, reqUrl, session, value, 3, remoteService);
        }
        ServiceResponse originResp = HttpUtils.cloneOriginResp(resp);
        if ("0".equals(resp.getReturncode()) || "1".equals(resp.getReturncode())) {
            resp = HttpUtils.convertSuccessResponseData(resp, targetClass);
        }
        ServiceResponse returnResp = HttpUtils.cloneOriginResp(resp);
        ServiceResponse logResp = ServiceResponse.buildSuccess((Object)"");
        long endTime = System.currentTimeMillis();
        return returnResp;
    }

    public static String getSHA1(String appId, String timestamp, String appSecret) {
        try {
            Object[] array = new String[]{appId, timestamp, appSecret};
            StringBuffer sb = new StringBuffer();
            Arrays.sort(array);
            for (int i = 0; i < array.length; ++i) {
                sb.append((String)array[i]);
            }
            String str = sb.toString();
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(str.getBytes());
            byte[] digest = md.digest();
            StringBuffer hexstr = new StringBuffer();
            String shaHex = "";
            for (int i = 0; i < digest.length; ++i) {
                shaHex = Integer.toHexString(digest[i] & 0xFF);
                if (shaHex.length() < 2) {
                    hexstr.append(0);
                }
                hexstr.append(shaHex);
            }
            return hexstr.toString();
        }
        catch (Exception var11) {
            log.error(var11.getMessage(), (Throwable)var11);
            return null;
        }
    }

    public <T> ServiceResponse doWslfPost(RestTemplate restTemplate, ServiceSession session, RemoteService remoteService, String value, Class<T> targetClass, String serviceName, String methodName, String wsurl) throws Exception {
        String flowNo;
        long startTime = System.currentTimeMillis();
        String traceID = flowNo = "";
        String reqUrl = wsurl;
        StatisticUtils.onIncrementMethod((String)reqUrl, (long)startTime);
        log.info("[" + traceID + "]--\u8bf7\u6c42\u5730\u5740-->[{}]", (Object)reqUrl);
        HttpsUtil https = new HttpsUtil();
        String respStr = https.doPost(reqUrl, value, 30000);
        long getresp = System.currentTimeMillis();
        ServiceResponse resp = new ServiceResponse();
        resp.setData((Object)JSON.parseObject((String)respStr));
        resp.setReturncode("0");
        long parsResp = System.currentTimeMillis();
        log.info("[" + traceID + "]--\u8bf7\u6c42\u7528\u65f6-->[{}] --\u8f6c\u6362\u7528\u65f6-->[{}] ", (Object)(getresp - startTime), (Object)(parsResp - getresp));
        long endTimeMillis = System.currentTimeMillis();
        long elapsed = endTimeMillis - startTime;
        StatisticUtils.onDecrementMethod((String)reqUrl, (Long)elapsed);
        ServiceResponse originResp = HttpUtils.cloneOriginResp(resp);
        if (("0".equals(resp.getReturncode()) || "1".equals(resp.getReturncode())) && null != resp.getData() && !"".equals(resp.getData())) {
            resp = HttpUtils.convertSuccessResponseData(resp, targetClass);
        }
        ServiceResponse returnResp = HttpUtils.cloneOriginResp(resp);
        long endTime = System.currentTimeMillis();
        HttpLog.log(serviceName, methodName, value, originResp, resp, traceID, endTime - startTime);
        return returnResp;
    }

    public <T> ServiceResponse doSkpPost(RestTemplate restTemplate, ServiceSession session, RemoteService remoteService, String value, Class<T> targetClass, String serviceName, String methodName, String wsurl) throws Exception {
        String flowNo;
        long startTime = System.currentTimeMillis();
        String traceID = flowNo = "";
        String reqUrl = wsurl;
        StatisticUtils.onIncrementMethod((String)reqUrl, (long)startTime);
        log.info("[" + traceID + "]--\u8bf7\u6c42\u5730\u5740-->[{}]", (Object)reqUrl);
        HttpsUtil https = new HttpsUtil();
        String respStr = https.doPost(reqUrl, value, 30000);
        long getresp = System.currentTimeMillis();
        ServiceResponse resp = new ServiceResponse();
        resp.setData((Object)JSON.parseObject((String)respStr));
        resp.setReturncode("0");
        long parsResp = System.currentTimeMillis();
        long endTimeMillis = System.currentTimeMillis();
        long elapsed = endTimeMillis - startTime;
        if (("0".equals(resp.getReturncode()) || "1".equals(resp.getReturncode())) && null != resp.getData() && !"".equals(resp.getData())) {
            resp = HttpUtils.convertSuccessResponseData(resp, targetClass);
        }
        ServiceResponse returnResp = HttpUtils.cloneOriginResp(resp);
        long endTime = System.currentTimeMillis();
        HttpLog.log(serviceName, methodName, value, returnResp, resp, traceID, endTime - startTime);
        return returnResp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> ServiceResponse doSkpPost(String cysource, String url, String method, ServiceSession session, String value, Class<T> targetClass, String serviceName, String methodName) {
        long startTime = System.currentTimeMillis();
        String flowNo = null;
        if (StringUtils.isBlank(flowNo)) {
            flowNo = UUIDUtils.buildGuid();
        }
        String traceID = flowNo;
        String[] split = cysource.split(",");
        String source = split[0];
        String dest = split[1];
        String appkey = split[2];
        String req = appkey + value + appkey;
        String signature = MD5.sign(req, "UTF-8").toUpperCase();
        Object reqUrl = this.buildSkpRequestUrl(url, source, dest, method);
        reqUrl = (String)reqUrl + "&verifycode=" + signature;
        log.info("[" + traceID + "]--\u8bf7\u6c42\u5730\u5740-->[{}]", reqUrl);
        ServiceResponse resp = new ServiceResponse();
        String respStr = "";
        CloseableHttpResponse response = null;
        try {
            log.info("\u8bf7\u6c42\u53c2\u6570:{}", JSONObject.toJSON((Object)value));
            DefaultHttpClient httpclient = new DefaultHttpClient();
            HttpPost httppost = new HttpPost((String)reqUrl);
            httppost.addHeader("Content-Type", "application/json");
            StringEntity myEntity = new StringEntity(value, "UTF-8");
            myEntity.setContentType("application/json");
            httppost.setEntity((HttpEntity)myEntity);
            httpclient.getParams().setParameter("http.connection.timeout", (Object)15000);
            httpclient.getParams().setParameter("http.socket.timeout", (Object)15000);
            response = httpclient.execute((HttpUriRequest)httppost);
            HttpEntity resEntity = response.getEntity();
            respStr = EntityUtils.toString((HttpEntity)resEntity, (String)"UTF-8");
            if ("".equals(respStr)) {
                resp.setReturncode("-1");
                resp.setData(null);
            } else {
                log.info("httpclient\u8fd4\u56de\u6570\u636e[{}]", (Object)respStr);
                resp.setData(JSON.parse((String)respStr));
                resp.setReturncode("0");
            }
        }
        catch (Exception e) {
            StackTraceElement[] trace;
            Object sOut = "";
            for (StackTraceElement s : trace = e.getStackTrace()) {
                sOut = (String)sOut + "\tat " + s + "\r\n";
            }
            log.info("SKP\u4e2d\u53f0\u8bf7\u6c42\u5931\u8d25:[{}]", sOut);
            resp = ServiceResponse.buildFailure((ServiceSession)session, (String)"60003", (String)"[Skp]-->\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        finally {
            if (response != null) {
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        long endTime = System.currentTimeMillis();
        ServiceResponse originResp = HttpUtils.cloneOriginResp(resp);
        if ("0".equals(resp.getReturncode()) || "1".equals(resp.getReturncode())) {
            resp = HttpUtils.convertSuccessResponseData(resp, targetClass);
        }
        HttpLog.log(serviceName, methodName, value, originResp, resp, traceID, endTime - startTime);
        return resp;
    }

    public static String concatSignString(Map map) {
        Set keySet = map.keySet();
        Object[] keyArray = keySet.toArray(new String[keySet.size()]);
        Arrays.sort(keyArray);
        StringBuilder sb = new StringBuilder();
        for (Object k : keyArray) {
            if (!StringUtils.isEmpty((String)sb.toString())) {
                sb.append("&");
            }
            sb.append((String)k).append("=").append(map.get(k));
        }
        return sb.toString();
    }

    public <T> ServiceResponse doMyshopPost(RestTemplate restTemplate, RemoteService remoteService, String method, ServiceSession session, String value, Class<T> targetClass, String serviceName, String methodName, String token) {
        String reqUrl;
        ServiceResponse resp;
        String flowNo;
        String language = "CN";
        long startTime = System.currentTimeMillis();
        String traceID = flowNo = "";
        if ("en-US".equals(session.getLocale())) {
            language = "EN";
        }
        if (FUSE_CODE.equals((resp = HttpUtils.executePost(traceID, reqUrl = this.buildMyshopRequestUrl(remoteService, method, session, token, language), session, value, remoteService)).getReturncode())) {
            resp = HttpUtils.retryPost(traceID, reqUrl, session, value, 3, remoteService);
        }
        ServiceResponse originResp = HttpUtils.cloneOriginResp(resp);
        if (("0".equals(resp.getReturncode()) || "1".equals(resp.getReturncode())) && null != resp.getData() && !"".equals(resp.getData())) {
            resp = HttpUtils.convertSuccessResponseData(resp, targetClass);
        }
        ServiceResponse returnResp = HttpUtils.cloneOriginResp(resp);
        ServiceResponse logResp = ServiceResponse.buildSuccess((Object)"");
        long endTime = System.currentTimeMillis();
        HttpLog.log(serviceName, methodName, value, originResp, resp, traceID, endTime - startTime);
        return returnResp;
    }

    public String buildMyshopRequestUrl(RemoteService service, String method, ServiceSession session, String token, String language) {
        if (method.startsWith("http")) {
            return method;
        }
        long ent_id = session.getEnt_id();
        String url = this.getRemoteServiceUrl(service) + "?method=" + method + "&token=" + token + "&language=" + language;
        return url;
    }

    public String buildJayaPointRequestUrl(String url, String method) {
        return url + method;
    }

    public <T> ServiceResponse doErajayaGet(String ynsource, String url, String method, ServiceSession session, String value, Class<T> targetClass, String serviceName, String methodName, Map<String, String> head) {
        return this.doErajaya(ynsource, url, method, session, value, targetClass, serviceName, methodName, head, "get");
    }

    public <T> ServiceResponse doErajayaPost(String ynsource, String url, String method, ServiceSession session, String value, Class<T> targetClass, String serviceName, String methodName, Map<String, String> head) {
        return this.doErajaya(ynsource, url, method, session, value, targetClass, serviceName, methodName, head, "post");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> ServiceResponse doErajaya(String ynsource, String url, String method, ServiceSession session, String value, Class<T> targetClass, String serviceName, String methodName, Map<String, String> head, String qqfs) {
        long startTime = System.currentTimeMillis();
        String flowNo = null;
        if (StringUtils.isBlank(flowNo)) {
            flowNo = UUIDUtils.buildGuid();
        }
        String traceID = flowNo;
        String reqUrl = "";
        reqUrl = "get".equals(qqfs) ? this.buildErajayaGetUrl(url, method, value) : this.buildErajayaPostUrl(url, method);
        log.info("[" + traceID + "]--\u8bf7\u6c42\u5730\u5740-->[{}]", (Object)reqUrl);
        ServiceResponse resp = new ServiceResponse();
        String respStr = "";
        Object response = null;
        try {
            log.info("\u8bf7\u6c42\u53c2\u6570:{}", JSONObject.toJSON((Object)value));
            log.info("\u8bf7\u6c42\u5934:{}", JSONObject.toJSON(head));
            respStr = "get".equals(qqfs) ? HttpClientUtils.get(reqUrl, head) : HttpClientUtils.postJsonParams(head, reqUrl, value);
            if ("".equals(respStr)) {
                resp.setReturncode("-1");
                resp.setData(null);
            } else {
                log.info("httpclient\u8fd4\u56de\u6570\u636e[{}]", (Object)respStr);
                resp.setData(JSON.parse((String)respStr));
                resp.setReturncode("0");
            }
        }
        catch (Exception e) {
            StackTraceElement[] trace;
            Object sOut = "";
            for (StackTraceElement s : trace = e.getStackTrace()) {
                sOut = (String)sOut + "\tat " + s + "\r\n";
            }
            log.info("\u4e2d\u53f0\u8bf7\u6c42\u5931\u8d25:[{}]", sOut);
            resp = ServiceResponse.buildFailure((ServiceSession)session, (String)"60003", (String)"[\u5370\u5c3c\u4e2d\u53f0]-->\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        finally {
            if (response != null) {
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        long endTime = System.currentTimeMillis();
        ServiceResponse originResp = HttpUtils.cloneOriginResp(resp);
        if ("0".equals(resp.getReturncode()) || "1".equals(resp.getReturncode())) {
            resp = HttpUtils.convertSuccessResponseData(resp, targetClass);
        }
        HttpLog.log(serviceName, methodName, value, originResp, resp, traceID, endTime - startTime);
        return resp;
    }

    public <T> ServiceResponse doEraJayaPost(Map<String, String> headers, String url, RemoteService remoteService, String method, ServiceSession session, String value, Class<T> targetClass, String serviceName, String methodName, String token) {
        String reqUrl;
        ServiceResponse resp;
        String flowNo;
        String language = "CN";
        long startTime = System.currentTimeMillis();
        String traceID = flowNo = "";
        if ("en-US".equals(session.getLocale())) {
            language = "EN";
        }
        if (FUSE_CODE.equals((resp = HttpUtils.executePost(headers, traceID, reqUrl = this.buildJayaPointRequestUrl(url, method), session, value, remoteService)).getReturncode())) {
            resp = HttpUtils.retryPost(traceID, reqUrl, session, value, 3, remoteService);
        }
        ServiceResponse originResp = HttpUtils.cloneOriginResp(resp);
        if (("0".equals(resp.getReturncode()) || "1".equals(resp.getReturncode())) && null != resp.getData() && !"".equals(resp.getData())) {
            resp = HttpUtils.convertSuccessResponseData(resp, targetClass);
        }
        ServiceResponse returnResp = HttpUtils.cloneOriginResp(resp);
        ServiceResponse logResp = ServiceResponse.buildSuccess((Object)"");
        long endTime = System.currentTimeMillis();
        HttpLog.log(serviceName, methodName, value, originResp, resp, traceID, endTime - startTime);
        return returnResp;
    }

    public <T> ServiceResponse doEraJayaGet(HashMap headMap, String url, RemoteService remoteService, String method, ServiceSession session, String value, Class<T> targetClass, String serviceName, String methodName, String token) {
        String flowNo;
        String language = "CN";
        long startTime = System.currentTimeMillis();
        String traceID = flowNo = "";
        if ("en-US".equals(session.getLocale())) {
            language = "EN";
        }
        String reqUrl = this.buildJayaPointRequestUrl(url, method);
        Header[] headers = this.buildHeads(headMap);
        ServiceResponse resp = HttpUtils.executeGet(headers, traceID, reqUrl, session, value, remoteService);
        if (FUSE_CODE.equals(resp.getReturncode())) {
            resp = HttpUtils.retryPost(traceID, reqUrl, session, value, 3, remoteService);
        }
        ServiceResponse originResp = HttpUtils.cloneOriginResp(resp);
        if (("0".equals(resp.getReturncode()) || "1".equals(resp.getReturncode())) && null != resp.getData() && !"".equals(resp.getData())) {
            resp = HttpUtils.convertSuccessResponseData(resp, targetClass);
        }
        ServiceResponse returnResp = HttpUtils.cloneOriginResp(resp);
        ServiceResponse logResp = ServiceResponse.buildSuccess((Object)"");
        long endTime = System.currentTimeMillis();
        HttpLog.log(serviceName, methodName, value, originResp, resp, traceID, endTime - startTime);
        return returnResp;
    }

    private Header[] buildHeads(HashMap map) {
        Header[] headers = new Header[map.size()];
        ArrayList<BasicHeader> list = new ArrayList<BasicHeader>();
        for (Map.Entry next : map.entrySet()) {
            log.info("Httphead====>" + (String)next.getKey() + "------" + (String)next.getValue());
            list.add(new BasicHeader((String)next.getKey(), (String)next.getValue()));
        }
        for (int i = 0; i < headers.length; ++i) {
            headers[i] = (Header)list.get(i);
        }
        return headers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> ServiceResponse doUploadPost(String url, String method, ServiceSession session, String value, Class<T> targetClass, String serviceName, String methodName, MultipartFile file, Map<String, String> paramMap) {
        String flowNo;
        long startTime = System.currentTimeMillis();
        String traceID = flowNo = "";
        String reqUrl = this.buildRequestUrl(url, method, session, flowNo);
        ServiceResponse resp = new ServiceResponse();
        String respStr = "";
        try {
            StatisticUtils.onIncrementMethod((String)reqUrl, (long)startTime);
            log.info("[" + traceID + "]--\u8bf7\u6c42\u5730\u5740-->[{}]", (Object)reqUrl);
            Http http = new Http();
            log.info("\u5165\u53c2==>{}", (Object)value);
            respStr = Http.uploadFile(reqUrl, file, paramMap);
            long getresp = System.currentTimeMillis();
            if ("".equals(respStr)) {
                resp.setReturncode("-1");
                resp.setData(null);
            } else {
                resp = (ServiceResponse)JSON.parseObject((String)respStr, ServiceResponse.class);
                log.info("httpclient\u8fd4\u56de\u6570\u636e[{}]", (Object)respStr);
            }
            log.info("\u8fd4\u56de==>{}", (Object)JSONObject.toJSONString((Object)resp));
            long parsResp = System.currentTimeMillis();
            log.info("[" + traceID + "]--\u8bf7\u6c42\u7528\u65f6-->[{}] --\u8f6c\u6362\u7528\u65f6-->[{}] ", (Object)(getresp - startTime), (Object)(parsResp - getresp));
            if (null == resp) {
                throw new RuntimeException();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            resp = ServiceResponse.buildFailure((ServiceSession)session, (String)"60003", (String)"\u7f51\u7edc\u5f02\u5e38");
        }
        finally {
            long endTimeMillis = System.currentTimeMillis();
            long elapsed = endTimeMillis - startTime;
            StatisticUtils.onDecrementMethod((String)reqUrl, (Long)elapsed);
        }
        ServiceResponse originResp = HttpUtils.cloneOriginResp(resp);
        if (("0".equals(resp.getReturncode()) || "1".equals(resp.getReturncode())) && null != resp.getData() && !"".equals(resp.getData())) {
            resp = HttpUtils.convertSuccessResponseData(resp, targetClass);
        }
        ServiceResponse returnResp = HttpUtils.cloneOriginResp(resp);
        long endTime = System.currentTimeMillis();
        HttpLog.log(serviceName, methodName, value, originResp, resp, traceID, endTime - startTime);
        return returnResp;
    }

    public static enum RemoteService {
        MDM("http.mdm.url"),
        PROMOTION("http.promotion.event.url"),
        PROMOTION_INFO("http.promotion.info.url"),
        PROMOTION_ACTIVITY("http.promotion.activity.url"),
        PROMOTION_ACCNT("http.promotion.accnt.url"),
        PROMOTION_COUPON("http.promotion.coupon.url"),
        INVENTORY("http.inventory.url"),
        ORDER("http.order.url"),
        WAREHOUSE("http.warehouse.url"),
        CONTRACT("http.contract.url"),
        POSMANAGER("http.posmanager.url"),
        POSSV("http.possv.cloud.url"),
        CRM_IBM("http.crm.ibm.url"),
        ESYSTEM("http.esystem.url"),
        BACK_PRINT("http.backPrint.url"),
        ZHONGBAI_DATACENTER("http.zhongbai.url"),
        ALICZK("http.ali.url"),
        STORE("http.store.url"),
        SKP("http.skp.url"),
        GROUP("http.group.url"),
        MYSHOPGROUP("http.myshop.group.url"),
        MYSHOPBACKREBATE("http.myshop.backrebate.url"),
        OCM("http.ocm.url");

        private String alias;

        public String getAlias() {
            return this.alias;
        }

        private RemoteService(String alias) {
            this.alias = alias;
        }
    }
}

