/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.bean.ModeDetailsVo;
import com.efuture.business.javaPos.struct.PaymentMode;
import com.efuture.business.model.PayModeCache;
import com.efuture.business.model.Payindiffmode;
import com.efuture.business.model.Paymentmethod;
import com.efuture.business.util.BeanUtil;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class PayModeUtils {
    public static PaymentMode getPayMode(String payCode, JSONObject modeDetailsVo) {
        if (StringUtils.isBlank((String)payCode) || null == modeDetailsVo) {
            return null;
        }
        JSONArray payModeList = null;
        if (modeDetailsVo.containsKey((Object)"paymode")) {
            payModeList = modeDetailsVo.getJSONArray("paymode");
        }
        JSONObject pd = null;
        for (int i = 0; i < payModeList.size(); ++i) {
            JSONObject payModes = (JSONObject)payModeList.get(i);
            if (payModes.containsKey((Object)"children") && null != payModes.getJSONArray("children")) {
                JSONArray children = payModes.getJSONArray("children");
                for (int j = 0; j < children.size(); ++j) {
                    JSONObject payMode = (JSONObject)children.get(j);
                    if (!payMode.containsKey((Object)"code") || !payCode.equals(payMode.getString("code"))) continue;
                    pd = payMode;
                    break;
                }
                if (null == pd) continue;
                break;
            }
            if (!payModes.containsKey((Object)"code") || !payCode.equals(payModes.getString("code"))) continue;
            pd = payModes;
            break;
        }
        PaymentMode paymentMode = (PaymentMode)JSON.toJavaObject(pd, PaymentMode.class);
        return paymentMode;
    }

    public static Paymentmethod getPayMode(String payCode, ModeDetailsVo modeDetailsVo) {
        if (StringUtils.isBlank((String)payCode) || null == modeDetailsVo) {
            return null;
        }
        List<Payindiffmode> paymentmethodList = modeDetailsVo.getPayindiffmode();
        for (Payindiffmode paymentmethodCopy : paymentmethodList) {
            if (!payCode.equals(paymentmethodCopy.getPayCode())) continue;
            Paymentmethod paymentMode = new Paymentmethod();
            BeanUtil.copyPropertiesIgnoreNull(paymentMode, paymentmethodCopy);
            return paymentMode;
        }
        return null;
    }

    public static String toR10PayCode(String payCode, ModeDetailsVo modeDetailsVo) {
        if (StringUtils.isBlank((String)payCode) || null == modeDetailsVo) {
            return payCode;
        }
        if (null != modeDetailsVo.getPaymode()) {
            for (PayModeCache payModeCache : modeDetailsVo.getPaymode()) {
                if (!StringUtils.isNotEmpty((String)payModeCache.getPaymentModeId()) || !payCode.equals(payModeCache.getPaymentModeId())) continue;
                return payModeCache.getCode();
            }
        }
        return payCode;
    }
}

