/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.util;

import com.efuture.business.javaPos.struct.Payment;
import com.efuture.business.javaPos.struct.orderCentre.OrdersPayModel;
import com.efuture.business.util.CastUtil;
import com.efuture.business.util.UniqueID;
import java.util.ArrayList;
import java.util.List;

public class PaymentUtil {
    public static List<Payment> transferPayment(List<OrdersPayModel> saleOrderPays) {
        if (saleOrderPays == null || saleOrderPays.size() == 0) {
            return null;
        }
        ArrayList<Payment> payments = new ArrayList<Payment>();
        for (OrdersPayModel saleOrderPay : saleOrderPays) {
            Payment payment = PaymentUtil.OrdersPayToPayment(saleOrderPay);
            payment.setIsSuccess(false);
            payments.add(payment);
        }
        return payments;
    }

    public static Payment OrdersPayToPayment(OrdersPayModel saleOrderPay) {
        Payment p = new Payment();
        p.setPuid(String.valueOf(UniqueID.getUniqueID()));
        p.setRownoId(p.getPuid());
        p.setCouponEventId(saleOrderPay.getCouponEventId());
        p.setMoney(CastUtil.castDouble(saleOrderPay.getMoney()));
        p.setRate(saleOrderPay.getRate());
        p.setCouponType(saleOrderPay.getCopType());
        p.setPayName(saleOrderPay.getPayName());
        p.setMisMerchantId(saleOrderPay.getMerchantId());
        p.setPayMemo(saleOrderPay.getPayMemo());
        p.setExtMemo(saleOrderPay.getExtMemo());
        p.setOverage(CastUtil.castDouble(saleOrderPay.getOverage()));
        p.setCouponPolicyId(saleOrderPay.getCouponPolicyId());
        p.setPayType(saleOrderPay.getPayType());
        p.setCouponTraceSeqno(CastUtil.castLong(saleOrderPay.getCouponTraceSeqno()));
        p.setFlag(String.valueOf(saleOrderPay.getFlag()));
        p.setCouponGroup(saleOrderPay.getCouponGroup());
        p.setCouponBalance(CastUtil.castDouble(saleOrderPay.getCouponBalance()));
        p.setPayCode(saleOrderPay.getPayCode());
        p.setAmount(CastUtil.castDouble(saleOrderPay.getAmount()));
        p.setPayNo(saleOrderPay.getPayNo());
        p.setCouponEventScd(saleOrderPay.getCouponEventScd());
        p.setRowno(saleOrderPay.getRowNo().intValue());
        p.setBatchNo(saleOrderPay.getBatchNo());
        p.setRefCode(saleOrderPay.getRefCode());
        p.setTrace(saleOrderPay.getTrace());
        p.setConsumersId(String.valueOf(saleOrderPay.getConsumersId()));
        p.setCouponIsCash(saleOrderPay.getCouponIsClass());
        p.setDxtype(saleOrderPay.getDxtype());
        p.setCashCost(CastUtil.castDouble(saleOrderPay.getCashCost()));
        p.setMisTerminalId(saleOrderPay.getTerminalId());
        p.setBatchNo(saleOrderPay.getBatchNo());
        p.setAuthCode(saleOrderPay.getAuthCode());
        p.setCouponType(saleOrderPay.getCopType());
        p.setRoundUpOverageValue(CastUtil.castDouble(saleOrderPay.getRoundUpOverageValue()));
        p.setOverPay(0.0);
        p.setExpiryDate(saleOrderPay.getExpiryDate());
        p.setInstallmentTerms(saleOrderPay.getInstallmentTerms());
        p.setFirstInstallmentAmount(CastUtil.castDouble(saleOrderPay.getFirstInstallmentAmount()));
        p.setFirstPaymentDueDate(saleOrderPay.getFirstPaymentDueDate());
        p.setFinalPyamentDueDate(saleOrderPay.getFinalPyamentDueDate());
        p.setPosEntryMode(saleOrderPay.getPosEntryMode());
        p.setDeliveryMemoNumber(saleOrderPay.getDeliveryMemoNumber());
        p.setTrackData(saleOrderPay.getTrackData());
        p.setDescription(saleOrderPay.getDescription());
        p.setMonthlyInstallment(CastUtil.castDouble(saleOrderPay.getMonthlyInstallment()));
        p.setMerchantDiscountValue(CastUtil.castDouble(saleOrderPay.getMerchantDiscountValue()));
        p.setDiscountValue(CastUtil.castDouble(saleOrderPay.getDiscountValue()));
        p.setPayChannelDiscountValue(CastUtil.castDouble(saleOrderPay.getPayChannelDiscountValue()));
        if (null != saleOrderPay.getAppType()) {
            p.setAppType(saleOrderPay.getAppType());
        }
        return p;
    }
}

