/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.util;

import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import org.apache.tomcat.util.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSAEncoderUtil {
    private static final Logger logger = LoggerFactory.getLogger(RSAEncoderUtil.class);
    private static String KEY_ALGORTHM = "RSA";
    private static String CIPHER_ALGORITHM = "RSA/ECB/PKCS1Padding";

    public static String encodeSign(byte[] data, String privateKey) {
        byte[] keys = Base64.decodeBase64((String)privateKey);
        PKCS8EncodedKeySpec pk8 = new PKCS8EncodedKeySpec(keys);
        String result = "";
        try {
            KeyFactory keyfac = KeyFactory.getInstance("RSA");
            PrivateKey pkey = keyfac.generatePrivate(pk8);
            Signature signature = Signature.getInstance("SHA256WithRSA");
            signature.initSign(pkey);
            signature.update(data);
            result = Base64.encodeBase64String((byte[])signature.sign());
        }
        catch (Exception e) {
            logger.error("\u7b7e\u540d\u62a5\u9519", (Throwable)e);
        }
        return result;
    }

    public static boolean decodeSign(byte[] signdata, byte[] data, String publicKey) {
        byte[] keys = Base64.decodeBase64((String)publicKey);
        byte[] sign = Base64.decodeBase64((byte[])signdata);
        boolean b = false;
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keys);
        try {
            KeyFactory keyfac = KeyFactory.getInstance("RSA");
            PublicKey pubKey = keyfac.generatePublic(keySpec);
            Signature signature = Signature.getInstance("SHA256WithRSA");
            signature.initVerify(pubKey);
            signature.update(data);
            b = signature.verify(sign);
        }
        catch (Exception e) {
            logger.error("\u9a8c\u7b7e\u62a5\u9519", (Throwable)e);
        }
        return b;
    }

    public static String RSAEncode(String publicKey, byte[] plainText) throws Exception {
        byte[] keys = Base64.decodeBase64((String)publicKey);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keys);
        KeyFactory keyfac = KeyFactory.getInstance(KEY_ALGORTHM);
        PublicKey pubKey = keyfac.generatePublic(keySpec);
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        cipher.init(1, pubKey);
        return Base64.encodeBase64String((byte[])cipher.doFinal(plainText));
    }

    public static String RSADecode(String privateKey, byte[] encodedText) throws Exception {
        byte[] keys = Base64.decodeBase64((String)privateKey);
        PKCS8EncodedKeySpec pk8 = new PKCS8EncodedKeySpec(keys);
        KeyFactory keyfac = KeyFactory.getInstance(KEY_ALGORTHM);
        PrivateKey pkey = keyfac.generatePrivate(pk8);
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        cipher.init(2, pkey);
        return new String(cipher.doFinal(encodedText));
    }
}

