/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.util;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSAUtil {
    private static final Logger logger = LoggerFactory.getLogger(RSAUtil.class);
    public static final String KEY_ALGORITHM = "RSA";
    public static final String SIGNATURE_ALGORITHM = "SHA1WithRSA";
    public static final int MAX_ENCRYPT_BLOCK = 117;
    public static final int MAX_DECRYPT_BLOCK = 128;
    private static RSAPrivateKey privateKey = null;
    private static RSAPublicKey publicKey = null;

    private static void initPrivateSignCert(String RSAPrivateKeyStr) {
        if (!KEY_ALGORITHM.equals(KEY_ALGORITHM)) {
            logger.error("\u975ersa\u7b7e\u540d\u65b9\u5f0f\uff0c\u4e0d\u52a0\u8f7d\u7b7e\u540d\u8bc1\u4e66\u3002");
            return;
        }
        if (RSAPrivateKeyStr == null) {
            logger.error("[RSAConfig.getRSAPrivateKey] \u4e3a\u7a7a\u3002 \u505c\u6b62\u52a0\u8f7d\u7b7e\u540d\u5bc6\u94a5\u3002");
            return;
        }
        try {
            logger.info("\u52a0\u8f7d\u7b7e\u540d\u8bc1\u4e66==>" + RSAPrivateKeyStr);
            privateKey = RSAUtil.loadPrivateKeyByStr(RSAPrivateKeyStr);
            logger.info("InitSignCert Successful");
        }
        catch (Exception e) {
            logger.error("InitSignCert Error{}", (Throwable)e);
        }
    }

    private static void initPublicValideCert(String RSAPublicKeyStr) {
        if (!KEY_ALGORITHM.equals(KEY_ALGORITHM)) {
            logger.error("\u975ersa\u7b7e\u540d\u65b9\u5f0f\uff0c\u4e0d\u52a0\u8f7d\u9a8c\u7b7e\u8bc1\u4e66\u3002");
            return;
        }
        if (RSAPublicKeyStr == null) {
            logger.error("[RSAConfig.getRSAPublicKey] \u4e3a\u7a7a\u3002 \u505c\u6b62\u52a0\u8f7d\u9a8c\u7b7e\u516c\u94a5\u3002");
            return;
        }
        try {
            logger.info("\u52a0\u8f7d\u9a8c\u7b7e\u8bc1\u4e66==>" + RSAPublicKeyStr);
            publicKey = RSAUtil.loadPublicKeyByStr(RSAPublicKeyStr);
            logger.info("InitSignCert Successful");
        }
        catch (Exception e) {
            logger.error("InitSignCert Error{}", (Throwable)e);
        }
    }

    public static String loadKeyByFile(String path) throws Exception {
        try {
            InputStream in = ClassLoader.getSystemResourceAsStream(path);
            BufferedReader br = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            String readLine = null;
            StringBuilder sb = new StringBuilder();
            while ((readLine = br.readLine()) != null) {
                sb.append(readLine);
            }
            br.close();
            return sb.toString();
        }
        catch (IOException e) {
            throw new Exception("\u79c1\u94a5\u6570\u636e\u8bfb\u53d6\u9519\u8bef");
        }
        catch (NullPointerException e) {
            throw new Exception("\u79c1\u94a5\u8f93\u5165\u6d41\u4e3a\u7a7a");
        }
    }

    public static RSAPrivateKey loadPrivateKeyByStr(String privateKeyStr) throws Exception {
        try {
            byte[] buffer = Base64.getDecoder().decode(privateKeyStr);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(buffer);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            return (RSAPrivateKey)keyFactory.generatePrivate(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception("\u65e0\u6b64\u7b97\u6cd5");
        }
        catch (InvalidKeySpecException e) {
            throw new Exception("\u79c1\u94a5\u975e\u6cd5");
        }
        catch (NullPointerException e) {
            throw new Exception("\u79c1\u94a5\u6570\u636e\u4e3a\u7a7a");
        }
    }

    public static RSAPublicKey loadPublicKeyByStr(String publicKeyStr) throws Exception {
        try {
            byte[] buffer = Base64.getDecoder().decode(publicKeyStr);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(buffer);
            return (RSAPublicKey)keyFactory.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception("\u65e0\u6b64\u7b97\u6cd5");
        }
        catch (InvalidKeySpecException e) {
            throw new Exception("\u516c\u94a5\u975e\u6cd5");
        }
        catch (NullPointerException e) {
            throw new Exception("\u516c\u94a5\u6570\u636e\u4e3a\u7a7a");
        }
    }

    public static Map<String, String> filterBlank(Map<String, String> contentData) {
        logger.info("\u6253\u5370\u8bf7\u6c42\u62a5\u6587\u57df :");
        HashMap<String, String> submitFromData = new HashMap<String, String>();
        Set<String> keyset = contentData.keySet();
        for (String key : keyset) {
            String value = contentData.get(key);
            if (!StringUtils.isNotBlank((String)value)) continue;
            submitFromData.put(key, value.trim());
            logger.info(key + "-->" + String.valueOf(value));
        }
        return submitFromData;
    }

    public static String coverMap2String(Map<String, String> data) {
        TreeMap<String, String> tree = new TreeMap<String, String>();
        for (Map.Entry<String, String> en : data.entrySet()) {
            if ("X-Sign".equals(en.getKey().trim())) continue;
            tree.put(en.getKey(), en.getValue());
        }
        Iterator<Map.Entry<String, String>> it = tree.entrySet().iterator();
        StringBuffer sf = new StringBuffer();
        while (it.hasNext()) {
            Map.Entry<String, String> en = it.next();
            sf.append(en.getKey() + "=" + en.getValue() + "&");
        }
        return sf.substring(0, sf.length() - 1);
    }

    public static Map<String, String> coverBean2Map(Object obj) {
        if (obj == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass());
            for (PropertyDescriptor property : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                String key = property.getName();
                if (key.equals("class")) continue;
                Method getter = property.getReadMethod();
                Object value = getter.invoke(obj, new Object[0]);
                map.put(key, value.toString());
            }
        }
        catch (Exception e) {
            logger.error("transBean2Map Error {}", (Throwable)e);
        }
        return map;
    }

    private String getRequestParamString(Map<String, String> requestParam, String coder) {
        if (null == coder || "".equals(coder)) {
            coder = "UTF-8";
        }
        StringBuffer sf = new StringBuffer("");
        String reqstr = "";
        if (null != requestParam && 0 != requestParam.size()) {
            for (Map.Entry<String, String> en : requestParam.entrySet()) {
                try {
                    sf.append(en.getKey() + "=" + (null == en.getValue() || "".equals(en.getValue()) ? "" : URLEncoder.encode(en.getValue(), coder)) + "&");
                }
                catch (UnsupportedEncodingException e) {
                    logger.error("\u89e3\u6790\u53c2\u6570\u9519\u8bef" + e);
                    return "";
                }
            }
            reqstr = sf.substring(0, sf.length() - 1);
        }
        logger.info("Request Message:[" + reqstr + "]");
        return reqstr;
    }

    public static Map<String, String> convertResultStringToMap(String result) {
        Map<String, String> map = null;
        try {
            if (StringUtils.isNotBlank((String)result)) {
                if (result.startsWith("{") && result.endsWith("}")) {
                    result = result.substring(1, result.length() - 1);
                }
                map = RSAUtil.parseQString(result);
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.error("\u89e3\u6790\u5b57\u7b26\u4e32\u5931\u8d25{}", (Throwable)e);
        }
        return map;
    }

    public static Map<String, String> parseQString(String str) throws UnsupportedEncodingException {
        HashMap<String, String> map = new HashMap<String, String>();
        int len = str.length();
        StringBuilder temp = new StringBuilder();
        String key = null;
        boolean isKey = true;
        boolean isOpen = false;
        char openName = '\u0000';
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                char curChar = str.charAt(i);
                if (isKey) {
                    if (curChar == '=') {
                        key = temp.toString();
                        temp.setLength(0);
                        isKey = false;
                        continue;
                    }
                    temp.append(curChar);
                    continue;
                }
                if (isOpen) {
                    if (curChar == openName) {
                        isOpen = false;
                    }
                } else {
                    if (curChar == '{') {
                        isOpen = true;
                        openName = '}';
                    }
                    if (curChar == '[') {
                        isOpen = true;
                        openName = ']';
                    }
                }
                if (curChar == '&' && !isOpen) {
                    RSAUtil.putKeyValueToMap(temp, isKey, key, map);
                    temp.setLength(0);
                    isKey = true;
                    continue;
                }
                temp.append(curChar);
            }
            RSAUtil.putKeyValueToMap(temp, isKey, key, map);
        }
        return map;
    }

    private static void putKeyValueToMap(StringBuilder temp, boolean isKey, String key, Map<String, String> map) throws UnsupportedEncodingException {
        if (isKey) {
            key = temp.toString();
            if (key.length() == 0) {
                throw new RuntimeException("QString format illegal");
            }
            map.put(key, "");
        } else {
            if (key.length() == 0) {
                throw new RuntimeException("QString format illegal");
            }
            map.put(key, temp.toString());
        }
    }

    public static boolean getPrivateKey(String privateKeyStr) {
        if (privateKey == null) {
            RSAUtil.initPrivateSignCert(privateKeyStr);
        }
        return privateKey != null;
    }

    public static boolean getPublicKey(String publicKeyStr) {
        if (publicKey == null) {
            RSAUtil.initPublicValideCert(publicKeyStr);
        }
        return publicKey != null;
    }

    public static RSAPrivateKey getPrivateKey() {
        return privateKey;
    }

    public static RSAPublicKey getPublicKey() {
        return publicKey;
    }
}

