/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.util;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;

public class RSAUtils2 {
    public static final String CHARSET = "UTF-8";
    public static final String RSA_ALGORITHM = "RSA";
    private static final String MD5_RSA = "SHA256withRSA";
    public static final String SHA_RSA = "SHA1WithRSA";

    public static Map<String, String> createKeys(int keySize) {
        KeyPairGenerator kpg;
        try {
            kpg = KeyPairGenerator.getInstance(RSA_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("No such algorithm-->[RSA]");
        }
        kpg.initialize(keySize);
        KeyPair keyPair = kpg.generateKeyPair();
        PublicKey publicKey = keyPair.getPublic();
        String publicKeyStr = Base64.encodeBase64URLSafeString((byte[])publicKey.getEncoded());
        PrivateKey privateKey = keyPair.getPrivate();
        String privateKeyStr = Base64.encodeBase64URLSafeString((byte[])privateKey.getEncoded());
        HashMap<String, String> keyPairMap = new HashMap<String, String>();
        keyPairMap.put("publicKey", publicKeyStr);
        keyPairMap.put("privateKey", privateKeyStr);
        return keyPairMap;
    }

    public static RSAPublicKey getPublicKey(String publicKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM);
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(Base64.decodeBase64((String)publicKey));
        RSAPublicKey key = (RSAPublicKey)keyFactory.generatePublic(x509KeySpec);
        return key;
    }

    public static RSAPrivateKey getPrivateKey(String privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM);
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(Base64.decodeBase64((String)privateKey));
        RSAPrivateKey key = (RSAPrivateKey)keyFactory.generatePrivate(pkcs8KeySpec);
        return key;
    }

    public static String publicEncrypt(String data, RSAPublicKey publicKey) {
        try {
            Cipher cipher = Cipher.getInstance(RSA_ALGORITHM);
            cipher.init(1, publicKey);
            return Base64.encodeBase64URLSafeString((byte[])RSAUtils2.rsaSplitCodec(cipher, 1, data.getBytes(CHARSET), publicKey.getModulus().bitLength()));
        }
        catch (Exception e) {
            throw new RuntimeException("\u52a0\u5bc6\u5b57\u7b26\u4e32[" + data + "]\u65f6\u9047\u5230\u5f02\u5e38", e);
        }
    }

    public static String privateDecrypt(String data, RSAPrivateKey privateKey) {
        try {
            Cipher cipher = Cipher.getInstance(RSA_ALGORITHM);
            cipher.init(2, privateKey);
            return new String(RSAUtils2.rsaSplitCodec(cipher, 2, Base64.decodeBase64((String)data), privateKey.getModulus().bitLength()), CHARSET);
        }
        catch (Exception e) {
            throw new RuntimeException("\u89e3\u5bc6\u5b57\u7b26\u4e32[" + data + "]\u65f6\u9047\u5230\u5f02\u5e38", e);
        }
    }

    public static String privateEncrypt(String data, RSAPrivateKey privateKey) {
        try {
            Cipher cipher = Cipher.getInstance(RSA_ALGORITHM);
            cipher.init(1, privateKey);
            return Base64.encodeBase64URLSafeString((byte[])RSAUtils2.rsaSplitCodec(cipher, 1, data.getBytes(CHARSET), privateKey.getModulus().bitLength()));
        }
        catch (Exception e) {
            throw new RuntimeException("\u52a0\u5bc6\u5b57\u7b26\u4e32[" + data + "]\u65f6\u9047\u5230\u5f02\u5e38", e);
        }
    }

    public static String publicDecrypt(String data, RSAPublicKey publicKey) {
        try {
            Cipher cipher = Cipher.getInstance(RSA_ALGORITHM);
            cipher.init(2, publicKey);
            return new String(RSAUtils2.rsaSplitCodec(cipher, 2, Base64.decodeBase64((String)data), publicKey.getModulus().bitLength()), CHARSET);
        }
        catch (Exception e) {
            throw new RuntimeException("\u89e3\u5bc6\u5b57\u7b26\u4e32[" + data + "]\u65f6\u9047\u5230\u5f02\u5e38", e);
        }
    }

    private static byte[] rsaSplitCodec(Cipher cipher, int opmode, byte[] datas, int keySize) {
        int maxBlock = 0;
        maxBlock = opmode == 2 ? keySize / 8 : keySize / 8 - 11;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        int i = 0;
        try {
            while (datas.length > offSet) {
                byte[] buff = datas.length - offSet > maxBlock ? cipher.doFinal(datas, offSet, maxBlock) : cipher.doFinal(datas, offSet, datas.length - offSet);
                out.write(buff, 0, buff.length);
                offSet = ++i * maxBlock;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u52a0\u89e3\u5bc6\u9600\u503c\u4e3a[" + maxBlock + "]\u7684\u6570\u636e\u65f6\u53d1\u751f\u5f02\u5e38", e);
        }
        byte[] resultDatas = out.toByteArray();
        IOUtils.closeQuietly((OutputStream)out);
        return resultDatas;
    }

    public static String signForSHA(String data, PrivateKey privateKey) throws Exception {
        byte[] keyBytes = privateKey.getEncoded();
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM);
        PrivateKey key = keyFactory.generatePrivate(keySpec);
        Signature signature = Signature.getInstance(SHA_RSA);
        signature.initSign(key);
        signature.update(data.getBytes());
        return new String(Base64.encodeBase64((byte[])signature.sign()));
    }

    public static String signForMD(String data, PrivateKey privateKey) throws Exception {
        byte[] keyBytes = privateKey.getEncoded();
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM);
        PrivateKey key = keyFactory.generatePrivate(keySpec);
        Signature signature = Signature.getInstance(MD5_RSA);
        signature.initSign(key);
        signature.update(data.getBytes());
        return new String(Base64.encodeBase64((byte[])signature.sign()));
    }

    public static boolean verify(String srcData, PublicKey publicKey, String sign) throws Exception {
        byte[] keyBytes = publicKey.getEncoded();
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM);
        PublicKey key = keyFactory.generatePublic(keySpec);
        Signature signature = Signature.getInstance(MD5_RSA);
        signature.initVerify(key);
        signature.update(srcData.getBytes());
        return signature.verify(Base64.decodeBase64((byte[])sign.getBytes()));
    }

    public static void main(String[] args) throws Exception {
        String privateKey = "MIICdgIBADANBgkqhkiG9w0BAQEFAASCAmAwggJcAgEAAoGBALFiOrGAEuTnVaIO\nYLdISkxbqbv0xpjtOWsLMACbLcfDLtRcVj1hevqqTirPeXJmZtGUwVN9EyO25WHZ\n0tLLvbbltDJvHBquaI4HrE+PgEFilqkoCA5Yn/oZ7qKpZgxcY854cMX6k1RwTbEb\nvs1jCZpIfMzVkoH9bTITtv6D8IQPAgMBAAECgYA9qui8zMnEyqf6rwTwszEhWryn\nm3FvuQk9LaaCj3BbAoBFU9Sngjw+6PZD691M6EzWj+CmJdWBlRQp8JBauHo7hsqF\nyRoKXpzMlSei4IH796ZE92Wu1jTWKqKXcPDNkJhtzID2ZFLzCcMWErjXIFjBoH4y\nds7rzS0FxJsnRw3oAQJBAOpGI1GWea9aEUVpClwMeFgX/BeJfr65lBK9xdbWYPoB\ndG/OE8Bo+z6z3A+ll50jNCjZHwE/RKtzKUha7TcMmTMCQQDB1XfiMram4tsecKnI\nnHRCMzVcPWmI9bhfAKjT6CK9SHtqoIGg5FVGkNhl0YyAVAonjSyDxTAPilxfH+Oc\n1QG1AkBUbFwT7bcCMuHgcn7yNugzTslgrgLHtlae/lZKGk0uKtIL7GZ/wxUvPl+C\nH/ln/iSwx7V9nJAhfMmWsnWjjd2zAkAnEHaQx9e32pB+mgYdwCpODTP72wSh7aOy\nwddEncwiibEV1DNL0bi9+AMkwg6m7kj9n54REHSXLTNgmHSu7t7hAkEAwxnKah0d\nNyDGHkQwtOV5jCtk72UjVDJKJ36riYvhRVdvWrdnVxjYc5JriyPW/DnYZnlOsE2F\nkt3yexzHHI35UQ==";
        String str = "{\"amt\":100,\"rn\":1234,\u201dshop\u201d:\u201d969b334kthc24226babcbf564a621fea\u201d}";
        String encodedData = RSAUtils2.signForSHA(str, RSAUtils2.getPrivateKey(privateKey));
        System.out.println("\u5bc6\u6587\uff1a\r\n" + encodedData);
    }
}

