/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.util;

import com.efuture.business.config.RedisConfig;
import com.efuture.business.javaPos.global.GlobalInfo;
import com.efuture.business.util.LocalCacheUtils;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.data.redis.connection.RedisClusterConnection;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisConnectionUtils;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.CollectionUtils;

public class RedisUtil {
    private static final Logger log = LoggerFactory.getLogger(RedisUtil.class);
    @Autowired
    private LocalCacheUtils localCacheUtils;
    @Autowired
    private GlobalInfo globalInfo;
    @Value(value="${localcache.enabled}")
    private String isenabled;
    private RedisTemplate<String, Object> redisTemplate;

    public void setRedisTemplate(RedisTemplate<String, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean expire(String key, long time) {
        try {
            if (time > 0L) {
                if ("true".equals(this.isenabled)) {
                    Object object = this.localCacheUtils.getIfPresent(key);
                    this.localCacheUtils.put(key, object);
                }
                this.redisTemplate.expire((Object)key, time, TimeUnit.SECONDS);
            }
            boolean object = true;
            return object;
        }
        catch (Exception e) {
            log.debug(e.getMessage(), (Throwable)e);
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            RedisConnectionUtils.unbindConnection((RedisConnectionFactory)this.redisTemplate.getConnectionFactory());
        }
    }

    public long getExpire(String key) {
        return this.redisTemplate.getExpire((Object)key, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasKey(String key) {
        try {
            if ("true".equals(this.isenabled)) {
                Object object = this.localCacheUtils.getIfPresent(key);
                if (null == object) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            boolean object = this.redisTemplate.hasKey((Object)key);
            return object;
        }
        catch (Exception e) {
            log.debug(e.getMessage(), (Throwable)e);
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            RedisConnectionUtils.unbindConnection((RedisConnectionFactory)this.redisTemplate.getConnectionFactory());
        }
    }

    public void del(String ... key) {
        try {
            if (key != null && key.length > 0) {
                if ("true".equals(this.isenabled)) {
                    for (int i = 0; i < key.length; ++i) {
                        this.localCacheUtils.invalidate(key[i]);
                    }
                    return;
                }
                if (key.length == 1) {
                    this.redisTemplate.delete((Object)key[0]);
                } else {
                    this.redisTemplate.delete((Object)CollectionUtils.arrayToList((Object)key).toString());
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        finally {
            RedisConnectionUtils.unbindConnection((RedisConnectionFactory)this.redisTemplate.getConnectionFactory());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String key) {
        String object = "";
        try {
            if ("true".equals(this.isenabled)) {
                String string = object = (String)this.localCacheUtils.getIfPresent(key);
                return string;
            }
            if (key != null && this.isRedisAlive()) {
                String string = object = (String)this.redisTemplate.opsForValue().get((Object)key);
                return string;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        finally {
            RedisConnectionUtils.unbindConnection((RedisConnectionFactory)this.redisTemplate.getConnectionFactory());
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObj(String key) {
        Object object = "";
        try {
            if ("true".equals(this.isenabled)) {
                Object object2 = object = this.localCacheUtils.getIfPresent(key);
                return object2;
            }
            if (key != null) {
                object = this.redisTemplate.opsForValue().get((Object)key);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        finally {
            RedisConnectionUtils.unbindConnection((RedisConnectionFactory)this.redisTemplate.getConnectionFactory());
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean set(String key, Object value) {
        try {
            if ("true".equals(this.isenabled)) {
                this.localCacheUtils.put(key, value);
                boolean bl = true;
                return bl;
            }
            if (this.isRedisAlive()) {
                this.redisTemplate.opsForValue().set((Object)key, value);
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            log.debug(e.getMessage(), (Throwable)e);
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            RedisConnectionUtils.unbindConnection((RedisConnectionFactory)this.redisTemplate.getConnectionFactory());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean set(String key, Object value, long time) {
        try {
            if (time > 0L) {
                if ("true".equals(this.isenabled)) {
                    this.localCacheUtils.put(key, value);
                    boolean bl = true;
                    return bl;
                }
                if (this.isRedisAlive()) {
                    this.redisTemplate.opsForValue().set((Object)key, value, time, TimeUnit.SECONDS);
                }
            } else {
                this.set(key, value);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.debug(e.getMessage(), (Throwable)e);
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            RedisConnectionUtils.unbindConnection((RedisConnectionFactory)this.redisTemplate.getConnectionFactory());
        }
    }

    public long incr(String key, long delta) {
        if (delta < 0L) {
            throw new RuntimeException("\u9012\u589e\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        }
        return this.redisTemplate.opsForValue().increment((Object)key, delta);
    }

    public long decr(String key, long delta) {
        if (delta < 0L) {
            throw new RuntimeException("\u9012\u51cf\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        }
        return this.redisTemplate.opsForValue().increment((Object)key, -delta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object hget(String key, String item) {
        Object object = "";
        try {
            if ("true".equals(this.isenabled)) {
                object = (String)this.localCacheUtils.getIfPresent(key);
                String string = object;
                return string;
            }
            object = this.redisTemplate.opsForHash().get((Object)key, (Object)item);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            RedisConnectionUtils.unbindConnection((RedisConnectionFactory)this.redisTemplate.getConnectionFactory());
        }
        return object;
    }

    public Map<Object, Object> hmget(String key) {
        return this.redisTemplate.opsForHash().entries((Object)key);
    }

    public boolean hmset(String key, Map<String, Object> map) {
        try {
            this.redisTemplate.opsForHash().putAll((Object)key, map);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean hmset(String key, Map<String, Object> map, long time) {
        try {
            this.redisTemplate.opsForHash().putAll((Object)key, map);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean hset(String key, String item, Object value) {
        try {
            this.redisTemplate.opsForHash().put((Object)key, (Object)item, value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean hset(String key, String item, Object value, long time) {
        try {
            this.redisTemplate.opsForHash().put((Object)key, (Object)item, value);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void hdel(String key, Object ... item) {
        this.redisTemplate.opsForHash().delete((Object)key, item);
    }

    public boolean hHasKey(String key, String item) {
        return this.redisTemplate.opsForHash().hasKey((Object)key, (Object)item);
    }

    public double hincr(String key, String item, double by) {
        return this.redisTemplate.opsForHash().increment((Object)key, (Object)item, by);
    }

    public double hdecr(String key, String item, double by) {
        return this.redisTemplate.opsForHash().increment((Object)key, (Object)item, -by);
    }

    public Set<Object> sGet(String key) {
        try {
            return this.redisTemplate.opsForSet().members((Object)key);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean sHasKey(String key, Object value) {
        try {
            return this.redisTemplate.opsForSet().isMember((Object)key, value);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public long sSet(String key, Object ... values) {
        try {
            return this.redisTemplate.opsForSet().add((Object)key, values);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public long sSetAndTime(String key, long time, Object ... values) {
        try {
            Long count = this.redisTemplate.opsForSet().add((Object)key, values);
            if (time > 0L) {
                this.expire(key, time);
            }
            return count;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public long sGetSetSize(String key) {
        try {
            return this.redisTemplate.opsForSet().size((Object)key);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public long setRemove(String key, Object ... values) {
        try {
            Long count = this.redisTemplate.opsForSet().remove((Object)key, values);
            return count;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public List<Object> lGet(String key, long start, long end) {
        try {
            return this.redisTemplate.opsForList().range((Object)key, start, end);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public long lGetListSize(String key) {
        try {
            return this.redisTemplate.opsForList().size((Object)key);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public Object lGetIndex(String key, long index) {
        try {
            return this.redisTemplate.opsForList().index((Object)key, index);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean lSet(String key, Object value) {
        try {
            this.redisTemplate.opsForList().rightPush((Object)key, value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean lSet(String key, Object value, long time) {
        try {
            this.redisTemplate.opsForList().rightPush((Object)key, value);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean lSet(String key, List<Object> value) {
        try {
            this.redisTemplate.opsForList().rightPushAll((Object)key, value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean lSet(String key, List<Object> value, long time) {
        try {
            this.redisTemplate.opsForList().rightPushAll((Object)key, value);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean lUpdateIndex(String key, long index, Object value) {
        try {
            this.redisTemplate.opsForList().set((Object)key, index, value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public long lRemove(String key, long count, Object value) {
        try {
            Long remove = this.redisTemplate.opsForList().remove((Object)key, count, value);
            return remove;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long rightPush(String key, String value) {
        long remove = 0L;
        try {
            remove = this.redisTemplate.opsForList().rightPush((Object)key, (Object)value);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            e.printStackTrace();
            long l = remove;
            return l;
        }
        finally {
            RedisConnectionUtils.unbindConnection((RedisConnectionFactory)this.redisTemplate.getConnectionFactory());
        }
        return remove;
    }

    public boolean isRedisAlive() {
        try {
            if (GlobalInfo.redisIsPing) {
                String result = "";
                if ("cluster".equals(GlobalInfo.redisMode)) {
                    RedisClusterConnection connection = this.redisTemplate.getConnectionFactory().getClusterConnection();
                    result = connection.ping();
                    connection.close();
                } else {
                    RedisConnection connection = this.redisTemplate.getConnectionFactory().getConnection();
                    result = connection.ping();
                    connection.close();
                }
                if (!"PONG".equals(result)) {
                    return this.configRefresh();
                }
                return true;
            }
            return true;
        }
        catch (Exception E) {
            log.error(E.getMessage(), (Throwable)E);
            return false;
        }
    }

    public boolean configRefresh() {
        try {
            AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext(new Class[]{RedisConfig.class, GlobalInfo.class, LocalCacheUtils.class});
            context.close();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }
}

