/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.util;

import com.efuture.business.config.BaseUtilConfig;
import com.efuture.business.config.NaCosConfig;
import java.io.File;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

public class YmlFileUtil {
    private static final Logger logger = LoggerFactory.getLogger(YmlFileUtil.class);
    private static Properties nacosProperties = null;

    public static String getYmlValue(String key) {
        String basePackage = "";
        if (BaseUtilConfig.isOpenNacos) {
            nacosProperties = NaCosConfig.getNaCosConfigToProperties("pos-application-globalinfo", NaCosConfig.group, NaCosConfig.serverAddr, NaCosConfig.userName, NaCosConfig.passWord, NaCosConfig.nameSpace);
        }
        if (null == nacosProperties) {
            File file = YmlFileUtil.getExistFile("application-globalinfo.yml");
            if (file.isFile()) {
                FileSystemResource fileSystemResource = new FileSystemResource(String.valueOf(file));
                YamlPropertiesFactoryBean yaml = new YamlPropertiesFactoryBean();
                yaml.setResources(new Resource[]{fileSystemResource});
                Properties properties = yaml.getObject();
                String ymlbasePackage = properties.getProperty(key);
                if (!StringUtils.isEmpty((Object)ymlbasePackage)) {
                    basePackage = ymlbasePackage;
                }
            }
        } else {
            basePackage = (String)nacosProperties.get(key);
        }
        return basePackage;
    }

    public static long getYmllong(String key) {
        String value = YmlFileUtil.getYmlValue(key);
        if (StringUtils.isEmpty((Object)value)) {
            return 0L;
        }
        return Long.parseLong(value);
    }

    public static File getExistFile(String fileName) {
        String appPath = BaseUtilConfig.appPaths;
        File file = new File(appPath + "/" + fileName);
        if (file != null && file.exists() && file.isFile()) {
            return file;
        }
        return null;
    }
}

