/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.util.db;

import com.alibaba.druid.pool.DruidDataSource;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;
import org.springframework.jdbc.datasource.lookup.DataSourceLookup;
import org.springframework.jdbc.datasource.lookup.JndiDataSourceLookup;
import org.springframework.util.Assert;
import org.sqlite.SQLiteDataSource;

public class MultipleDataSource
extends AbstractRoutingDataSource {
    private static final Logger log = LoggerFactory.getLogger(MultipleDataSource.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(MultipleDataSource.class);
    private static final ThreadLocal<String> dataSourceKey = new InheritableThreadLocal<String>();
    private static final ThreadLocal<String> locdataSourceKey = new InheritableThreadLocal<String>();
    private Map<Object, Object> targetDataSources;
    private Object defaultTargetDataSource;
    private boolean lenientFallback = true;
    private DataSourceLookup dataSourceLookup = new JndiDataSourceLookup();
    private Map<Object, DataSource> resolvedDataSources;
    private DataSource resolvedDefaultDataSource;
    @Value(value="${localcache.enabled}")
    private Boolean localcache;

    protected Object determineCurrentLookupKey() {
        String dataSource = MultipleDataSource.getDataSource();
        return dataSource;
    }

    public static void setDataSourceKey(String dataSource) {
        dataSourceKey.set(dataSource);
    }

    public static String getDataSource() {
        return dataSourceKey.get();
    }

    public static void clearDataSource() {
        dataSourceKey.remove();
    }

    public static String getLocDataSource() {
        return locdataSourceKey.get();
    }

    public static void setLocDataSourceKey(String yyyyMMdd) {
        locdataSourceKey.set(yyyyMMdd);
    }

    public static void clearLocDataSource() {
        locdataSourceKey.remove();
    }

    public void setTargetDataSources(Map<Object, Object> targetDataSources) {
        this.targetDataSources = targetDataSources;
    }

    public void setDefaultTargetDataSource(Object defaultTargetDataSource) {
        this.defaultTargetDataSource = defaultTargetDataSource;
    }

    public void setLenientFallback(boolean lenientFallback) {
        this.lenientFallback = lenientFallback;
    }

    public void setDataSourceLookup(DataSourceLookup dataSourceLookup) {
        this.dataSourceLookup = dataSourceLookup != null ? dataSourceLookup : new JndiDataSourceLookup();
    }

    public void afterPropertiesSet() {
        if (this.targetDataSources == null) {
            throw new IllegalArgumentException("Property 'targetDataSources' is required");
        }
        this.resolvedDataSources = new HashMap<Object, DataSource>(this.targetDataSources.size());
        for (Map.Entry<Object, Object> entry : this.targetDataSources.entrySet()) {
            Object lookupKey = this.resolveSpecifiedLookupKey(entry.getKey());
            DataSource dataSource = this.resolveSpecifiedDataSource(entry.getValue());
            this.resolvedDataSources.put(lookupKey, dataSource);
        }
        if (this.defaultTargetDataSource != null) {
            this.resolvedDefaultDataSource = this.resolveSpecifiedDataSource(this.defaultTargetDataSource);
        }
    }

    protected Object resolveSpecifiedLookupKey(Object lookupKey) {
        return lookupKey;
    }

    protected DataSource resolveSpecifiedDataSource(Object dataSource) throws IllegalArgumentException {
        if (dataSource instanceof DataSource) {
            return (DataSource)dataSource;
        }
        if (dataSource instanceof String) {
            return this.dataSourceLookup.getDataSource((String)dataSource);
        }
        throw new IllegalArgumentException("Illegal data source value - only [javax.sql.DataSource] and String supported: " + dataSource);
    }

    public Connection getConnection() throws SQLException {
        return this.determineTargetDataSource().getConnection();
    }

    public Connection getConnection(String username, String password) throws SQLException {
        return this.determineTargetDataSource().getConnection(username, password);
    }

    protected DataSource determineTargetDataSource() {
        Assert.notNull(this.resolvedDataSources, (String)"DataSource router not initialized");
        String yyyyMMdd = MultipleDataSource.getLocDataSource();
        Object lookupKey = this.determineCurrentLookupKey();
        if (this.localcache.booleanValue()) {
            return this.offLineDataSource(yyyyMMdd, lookupKey);
        }
        return this.hikariOnLineDataSource(yyyyMMdd, lookupKey);
    }

    protected DataSource offLineDataSource(String yyyyMMdd, Object lookupKey) {
        SQLiteDataSource druidDataSource = (SQLiteDataSource)this.resolvedDataSources.get(lookupKey);
        SQLiteDataSource druidDataSourceNew = null;
        Object dataSource = null;
        if (druidDataSource.getUrl().contains("order.db3")) {
            log.info("druidDataSource.getRawJdbcUrl()====>" + druidDataSource.getUrl());
            String now = "";
            Object jdbcUrl = "";
            int begin = 0;
            int last = druidDataSource.getUrl().indexOf("sqlites") + 7;
            if (null == yyyyMMdd || "".equals(yyyyMMdd)) {
                SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
                now = formatter.format(new Date());
                jdbcUrl = druidDataSource.getUrl().substring(begin, last) + "/" + now + "/order.db3";
            } else {
                jdbcUrl = druidDataSource.getUrl().substring(begin, last) + "/" + yyyyMMdd + "/order.db3";
            }
            log.info("druidDataSource.getRawJdbcUrl()====>" + (String)jdbcUrl);
            if (!druidDataSource.getUrl().equals(jdbcUrl)) {
                druidDataSourceNew = new SQLiteDataSource();
                druidDataSourceNew.setUrl((String)jdbcUrl);
            }
        }
        if ((dataSource = null != druidDataSourceNew ? druidDataSourceNew : druidDataSource) == null && (this.lenientFallback || lookupKey == null)) {
            dataSource = this.resolvedDefaultDataSource;
        }
        if (dataSource == null) {
            throw new IllegalStateException("Cannot determine target DataSource for lookup key [" + lookupKey + "]");
        }
        return dataSource;
    }

    protected DataSource onLineDataSource(String yyyyMMdd, Object lookupKey) {
        DruidDataSource druidDataSource = (DruidDataSource)this.resolvedDataSources.get(lookupKey);
        DruidDataSource druidDataSourceNew = null;
        Object dataSource = null;
        if (druidDataSource.getRawJdbcUrl().contains("order.db3")) {
            log.info("druidDataSource.getRawJdbcUrl()====>" + druidDataSource.getRawJdbcUrl());
            String now = "";
            Object jdbcUrl = "";
            int begin = 0;
            int last = druidDataSource.getRawJdbcUrl().indexOf("sqlites") + 7;
            if (null == yyyyMMdd || "".equals(yyyyMMdd)) {
                SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
                now = formatter.format(new Date());
                jdbcUrl = druidDataSource.getRawJdbcUrl().substring(begin, last) + "/" + now + "/order.db3";
            } else {
                jdbcUrl = druidDataSource.getRawJdbcUrl().substring(begin, last) + "/" + yyyyMMdd + "/order.db3";
            }
            log.info("druidDataSource.getRawJdbcUrl()====>" + (String)jdbcUrl);
            if (!druidDataSource.getRawJdbcUrl().equals(jdbcUrl)) {
                druidDataSourceNew = new DruidDataSource();
                druidDataSourceNew.setUrl((String)jdbcUrl);
                druidDataSourceNew.setMaxWait(3000L);
                druidDataSourceNew.setRemoveAbandoned(true);
                druidDataSourceNew.setRemoveAbandonedTimeout(600);
                druidDataSourceNew.setLogAbandoned(true);
                druidDataSourceNew.setTimeBetweenConnectErrorMillis(60000L);
                druidDataSourceNew.setValidationQuery("select 1");
            }
        }
        if ((dataSource = null != druidDataSourceNew ? druidDataSourceNew : druidDataSource) == null && (this.lenientFallback || lookupKey == null)) {
            dataSource = this.resolvedDefaultDataSource;
        }
        if (dataSource == null) {
            throw new IllegalStateException("Cannot determine target DataSource for lookup key [" + lookupKey + "]");
        }
        return dataSource;
    }

    protected DataSource hikariOnLineDataSource(String jdbcUrl, Object lookupKey) {
        HikariDataSource hikariDataSource = (HikariDataSource)this.resolvedDataSources.get(lookupKey);
        HikariDataSource hikariDataSourceNew = null;
        Object dataSource = null;
        log.info("hikariDataSourceUrl:" + hikariDataSource.getJdbcUrl() + ",jdbcUrl:" + jdbcUrl);
        if (StringUtils.isNotBlank((String)jdbcUrl) && !hikariDataSource.getJdbcUrl().equals(jdbcUrl)) {
            hikariDataSourceNew = new HikariDataSource();
            hikariDataSourceNew.setJdbcUrl(jdbcUrl);
            hikariDataSourceNew.setUsername(hikariDataSource.getUsername());
            hikariDataSourceNew.setPassword(hikariDataSource.getPassword());
            hikariDataSourceNew.setMaximumPoolSize(100);
            hikariDataSourceNew.setMinimumIdle(5);
            hikariDataSourceNew.setAutoCommit(true);
            hikariDataSourceNew.setMaxLifetime(1800000L);
            hikariDataSourceNew.setIdleTimeout(180000L);
            hikariDataSourceNew.setConnectionTimeout(hikariDataSource.getConnectionTimeout());
            hikariDataSourceNew.setConnectionTestQuery(hikariDataSource.getConnectionTestQuery());
        }
        if (null != hikariDataSourceNew) {
            dataSource = hikariDataSourceNew;
            this.resolvedDataSources.put(lookupKey, (DataSource)dataSource);
            hikariDataSource.close();
        } else {
            dataSource = hikariDataSource;
        }
        if (dataSource == null && (this.lenientFallback || lookupKey == null)) {
            dataSource = this.resolvedDefaultDataSource;
        }
        if (dataSource == null) {
            throw new IllegalStateException("Cannot determine target DataSource for lookup key [" + lookupKey + "]");
        }
        return dataSource;
    }
}

