/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.util.excel;

import com.efuture.business.util.excel.ExcelTemplate;
import com.efuture.business.util.excel.RecordValue;
import com.efuture.business.util.excel.WorkBookService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelExporter {
    private static AtomicLong index = new AtomicLong();
    private static final String DOWNLOAD_PATH = "/data/download";
    private static final String EXCEL_TEMPLATE_PATH = "/data/download/template";

    public static String export(ExcelTemplate template, List<Map<String, Object>> dataList) throws IOException {
        Workbook workbook = ExcelExporter.createWorkBook4Map(template, dataList);
        String fileName = ExcelExporter.createFileName(template, true);
        FileOutputStream os = new FileOutputStream(fileName);
        workbook.write((OutputStream)os);
        ((OutputStream)os).close();
        return fileName;
    }

    public static void export(ExcelTemplate template, List<Map<String, Object>> dataList, HttpServletResponse response) throws IOException {
        Workbook workbook = ExcelExporter.createWorkBook4Map(template, dataList);
        String fileName = ExcelExporter.createFileName(template, false);
        response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
        response.setContentType("application/vnd.ms-excel");
        ServletOutputStream os = response.getOutputStream();
        os.flush();
        workbook.write((OutputStream)os);
        os.close();
    }

    public static void simpleExport(ExcelTemplate template, String[] headers, List<Map<String, Object>> dataList, HttpServletResponse response) throws IOException {
        Workbook workbook = ExcelExporter.createWorkBook4Map(template, headers, dataList);
        String fileName = ExcelExporter.createFileName(template, false);
        response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
        response.setContentType("application/vnd.ms-excel");
        ServletOutputStream os = response.getOutputStream();
        os.flush();
        workbook.write((OutputStream)os);
        os.close();
    }

    public static void export(ExcelTemplate template, String[] headers, List<RecordValue> dataList, HttpServletResponse response) throws IOException {
        Workbook workbook = ExcelExporter.createWorkBook4Record(template, headers, dataList);
        String fileName = ExcelExporter.createFileName(template, false);
        response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
        response.setContentType("application/vnd.ms-excel");
        ServletOutputStream os = response.getOutputStream();
        os.flush();
        workbook.write((OutputStream)os);
        os.close();
    }

    public static void export(ExcelTemplate template, String[] headers, List<RecordValue> dataList) throws IOException {
        Workbook workbook = ExcelExporter.createWorkBook4Record(template, headers, dataList);
        String fileName = ExcelExporter.createFileName(template, true);
        FileOutputStream os = new FileOutputStream(fileName);
        workbook.write((OutputStream)os);
        ((OutputStream)os).close();
    }

    private static Workbook createWorkBook4Map(ExcelTemplate template, List<Map<String, Object>> dataList) throws IOException {
        Workbook workbook = ExcelExporter.getWorkbook(template);
        Sheet sheet = ExcelExporter.getSheet(workbook);
        if (dataList.size() == 0) {
            return workbook;
        }
        WorkBookService workBookService = new WorkBookService();
        workBookService.fillData4Map(template.getHeaderStart(), sheet, dataList);
        return workbook;
    }

    private static Workbook createWorkBook4Map(ExcelTemplate template, String[] headers, List<Map<String, Object>> dataList) throws IOException {
        Workbook workbook = ExcelExporter.getWorkbook(template);
        Sheet sheet = ExcelExporter.getSheet(workbook);
        WorkBookService workBookService = new WorkBookService();
        workBookService.fillData4Map(template.getHeaderStart(), sheet, dataList);
        return workbook;
    }

    private static Workbook createWorkBook4Record(ExcelTemplate template, String[] headerNames, List<RecordValue> dataList) throws IOException {
        Workbook workbook = ExcelExporter.getWorkbook(template);
        Sheet sheet = ExcelExporter.getSheet(workbook);
        WorkBookService workBookService = new WorkBookService();
        workBookService.fillData4RecordValue(template.getHeaderStart(), sheet, headerNames, dataList);
        return workbook;
    }

    private static Workbook getWorkbook(ExcelTemplate template) throws IOException {
        if (StringUtils.isNotEmpty((CharSequence)template.getTemplateFile())) {
            FileInputStream is = new FileInputStream(EXCEL_TEMPLATE_PATH + File.separator + template.getTemplateFile());
            if (template.getTemplateFile().endsWith("xlsx")) {
                return new XSSFWorkbook((InputStream)is);
            }
            return new HSSFWorkbook((InputStream)is);
        }
        return new HSSFWorkbook();
    }

    private static Sheet getSheet(Workbook workbook) {
        if (workbook.getNumberOfSheets() == 0) {
            return workbook.createSheet("sheet1");
        }
        return workbook.getSheetAt(0);
    }

    private static String createFileName(ExcelTemplate template, boolean createLocalFile) throws UnsupportedEncodingException {
        String suffix;
        boolean isXlsx = template.isXlsx();
        String string = suffix = isXlsx ? ".xlsx" : ".xls";
        if (createLocalFile) {
            return DOWNLOAD_PATH + File.separator + template.getFileName() + "_" + String.valueOf(System.currentTimeMillis()).substring(4, 13) + index.getAndIncrement() % 100L + suffix;
        }
        return String.format("attachment;filename*=utf-8'zh_cn'%s" + suffix, URLEncoder.encode(template.getFileName(), "utf-8"));
    }
}

