/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.util.excel;

import com.efuture.business.util.excel.BeanTransfer;
import com.efuture.business.util.excel.ExcelParseException;
import com.efuture.business.util.excel.ValueHolder;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelParser<T> {
    private List<String> headerList;
    private List<T> dataList;
    private BeanTransfer<T> transfer;
    private boolean isXlsx = false;
    private static Logger log = LoggerFactory.getLogger(ExcelParser.class);
    public static BeanTransfer<ValueHolder> DEFAULT_TRANSFER = new BeanTransfer<ValueHolder>(){

        @Override
        public ValueHolder transfer(ValueHolder valueHolder) {
            return valueHolder;
        }
    };

    public ExcelParser(String path) throws ExcelParseException {
        this(path, DEFAULT_TRANSFER);
    }

    public ExcelParser(InputStream is) throws ExcelParseException {
        this(is, DEFAULT_TRANSFER);
    }

    public ExcelParser(String path, BeanTransfer<T> transfer) throws ExcelParseException {
        this(path, null, transfer);
    }

    public ExcelParser(InputStream is, BeanTransfer<T> transfer) throws ExcelParseException {
        this(is, null, transfer);
    }

    public ExcelParser(String path, String[] headerArray, BeanTransfer<T> transfer) throws ExcelParseException {
        this(path, false, 0, headerArray, transfer);
    }

    public ExcelParser(InputStream is, String[] headerArray, BeanTransfer<T> transfer) throws ExcelParseException {
        this(is, false, 0, headerArray, transfer);
    }

    public ExcelParser(String path, boolean isXlsx, String[] headerArray, BeanTransfer<T> transfer) throws ExcelParseException {
        this(path, isXlsx, 0, headerArray, transfer);
    }

    public ExcelParser(InputStream is, boolean isXlsx, String[] headerArray, BeanTransfer<T> transfer) throws ExcelParseException {
        this(is, isXlsx, 0, headerArray, transfer);
    }

    public ExcelParser(String path, boolean isXlsx, int startRow, String[] headerArray, BeanTransfer<T> transfer) throws ExcelParseException {
        this.transfer = transfer;
        try {
            FileInputStream is = new FileInputStream(path);
            this.init(startRow, is, headerArray);
            ((InputStream)is).close();
        }
        catch (FileNotFoundException e) {
            throw new ExcelParseException("\u6587\u4ef6\u8def\u5f84[" + path + "\u672a\u627e\u5230", e);
        }
        catch (IOException e) {
            throw new ExcelParseException("\u89e3\u6790\u6587\u4ef6\u5f02\u5e38", e);
        }
        this.isXlsx = isXlsx;
    }

    public ExcelParser(InputStream is, boolean isXlsx, int startRow, String[] headerArray, BeanTransfer<T> transfer) throws ExcelParseException {
        this.transfer = transfer;
        this.isXlsx = isXlsx;
        try {
            this.init(startRow, is, headerArray);
        }
        catch (IOException e) {
            throw new ExcelParseException("\u89e3\u6790\u6587\u4ef6\u5f02\u5e38", e);
        }
    }

    void init(int startRow, InputStream is, String[] headerArray) throws IOException, ExcelParseException {
        Object workbook = null;
        workbook = this.isXlsx ? new XSSFWorkbook(is) : new HSSFWorkbook(is);
        ArrayList<T> list = new ArrayList<T>();
        Sheet sheet = workbook.getSheetAt(0);
        if (sheet == null) {
            return;
        }
        boolean start = true;
        for (int rowNum = startRow; rowNum <= sheet.getLastRowNum(); ++rowNum) {
            Row row = sheet.getRow(rowNum);
            if (row == null) continue;
            if (start) {
                this.headerList = new ArrayList<String>();
                if (headerArray != null) {
                    log.info(row.getLastCellNum() + "-" + row.getFirstCellNum());
                    if (headerArray.length != row.getLastCellNum() - row.getFirstCellNum()) {
                        throw new ExcelParseException("\u5934\u90e8\u4fe1\u606f\u4e0e\u6a21\u677f\u4e0d\u5339\u914d\uff0c\u8bf7\u4e0b\u8f7d\u6807\u51c6\u6a21\u677f");
                    }
                }
                for (int cellNum = row.getFirstCellNum(); cellNum < row.getLastCellNum(); ++cellNum) {
                    Cell cell = row.getCell(cellNum);
                    String stringCellValue = StringUtils.trimToEmpty((String)cell.getStringCellValue());
                    if (headerArray != null && !headerArray[cellNum].equals(stringCellValue)) {
                        throw new ExcelParseException("\u5217\u6807\u9898[" + stringCellValue + "]\u4fe1\u606f\u4e0e\u6a21\u677f\u4e0d\u5339\u914d\uff0c\u8bf7\u4e0b\u8f7d\u6807\u51c6\u6a21\u677f");
                    }
                    this.headerList.add(stringCellValue);
                }
                start = false;
                continue;
            }
            int first = row.getFirstCellNum();
            HashMap<String, Object> record = new HashMap<String, Object>();
            int lastCellNum = 0;
            lastCellNum = headerArray != null ? first + headerArray.length : row.getLastCellNum();
            for (int cellNum = first; cellNum < lastCellNum; ++cellNum) {
                record.put(this.headerList.get(cellNum - first), this.getMergedRegionValue(sheet, row, cellNum));
            }
            boolean allEmpty = true;
            for (Object value : record.values()) {
                if (value instanceof String) {
                    String svalue = (String)value;
                    if (!StringUtils.isNotEmpty((CharSequence)svalue)) continue;
                    allEmpty = false;
                    break;
                }
                if (value == null) continue;
                allEmpty = false;
                break;
            }
            if (allEmpty) continue;
            list.add(this.transfer.transfer(new ValueHolder(record, rowNum + 1)));
        }
        this.dataList = list;
    }

    private Object getValue(Cell cell) {
        if (cell == null) {
            return null;
        }
        if (cell.getCellType() == 4) {
            return cell.getBooleanCellValue();
        }
        if (cell.getCellType() == 3) {
            return null;
        }
        if (cell.getCellType() == 0) {
            if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                return cell.getDateCellValue();
            }
            cell.setCellType(1);
            return cell.getStringCellValue();
        }
        if (cell.getCellType() == 2) {
            if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                return cell.getDateCellValue();
            }
            return cell.getCellFormula();
        }
        return StringUtils.trimToEmpty((String)cell.getStringCellValue());
    }

    public List<String> getHeaderList() {
        return this.headerList;
    }

    public boolean checkHeader(String[] headerArray) {
        if (headerArray.length != this.headerList.size()) {
            return false;
        }
        for (int i = 0; i < headerArray.length; ++i) {
            String header = headerArray[i];
            if (header.equals(this.headerList.get(i))) continue;
            return false;
        }
        return true;
    }

    public Object getMergedRegionValue(Sheet sheet, Row row, int column) {
        int sheetMergeCount = sheet.getNumMergedRegions();
        int rowNum = row.getRowNum();
        for (int i = 0; i < sheetMergeCount; ++i) {
            CellRangeAddress ca = sheet.getMergedRegion(i);
            int firstColumn = ca.getFirstColumn();
            int lastColumn = ca.getLastColumn();
            int firstRow = ca.getFirstRow();
            int lastRow = ca.getLastRow();
            if (rowNum < firstRow || rowNum > lastRow || column < firstColumn || column > lastColumn) continue;
            Row fRow = sheet.getRow(firstRow);
            Cell fCell = fRow.getCell(firstColumn);
            return this.getValue(fCell);
        }
        return this.getValue(row.getCell(column));
    }

    public List<T> getDataList() {
        return this.dataList;
    }

    public static void main(String[] args) throws IOException {
        try {
            System.out.println("  sdfsd ".trim());
            System.out.println("  sdfsd ");
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }
}

