/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.util.excel;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.time.DateFormatUtils;

public class RecordValue {
    private Map<String, Object> valueList = new HashMap<String, Object>();
    private static final String CHILD_VALUE_NAME = "_childList_";
    private int rowNum = 1;
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";

    public void put(String key, Object value) {
        if (CHILD_VALUE_NAME.equals(key)) {
            throw new RuntimeException("_childList_\u4e3a\u4fdd\u7559\u952e\u503c\uff0c\u8bf7\u4f7f\u7528\u5176\u4ed6\u5217\u540d");
        }
        this.valueList.put(key, value);
    }

    public Set<String> headerSet() {
        return this.valueList.keySet();
    }

    public void addChild(RecordValue childValue) {
        this.checkChildExist();
        List childList = (List)this.valueList.get(CHILD_VALUE_NAME);
        childList.add(childValue);
    }

    public void addChildList(List<RecordValue> childValueList) {
        this.checkChildExist();
        List childList = (List)this.valueList.get(CHILD_VALUE_NAME);
        childList.addAll(childValueList);
    }

    public String getValue(String key) {
        return RecordValue.getStringValue(this.valueList.get(key));
    }

    public List<RecordValue> getChildValueList() {
        return (List)this.valueList.get(CHILD_VALUE_NAME);
    }

    private static String getStringValue(Object content) {
        if (content == null) {
            return "";
        }
        if (content instanceof String) {
            return (String)content;
        }
        if (content instanceof Number) {
            return String.valueOf(content);
        }
        if (content instanceof Date) {
            return DateFormatUtils.format((Date)((Date)content), (String)DATE_FORMAT);
        }
        return String.valueOf(content);
    }

    private void checkChildExist() {
        if (!this.valueList.containsKey(CHILD_VALUE_NAME)) {
            this.valueList.put(CHILD_VALUE_NAME, new ArrayList());
        }
    }
}

