/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.util.excel;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;

public class ValueHolder {
    private Map<String, Object> dataMap;
    private int lineNum;
    private static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";

    public ValueHolder(Map<String, Object> dataMap, int lineNum) {
        this.dataMap = dataMap;
        this.lineNum = lineNum;
    }

    public Map<String, Object> getDataMap() {
        return this.dataMap;
    }

    public int getLineNum() {
        return this.lineNum;
    }

    public int getIntValue(String key) {
        return Integer.valueOf(this.getStringValue(key));
    }

    public Integer getIntegerValue(String key) {
        String stringValue = this.getStringValue(key);
        if (StringUtils.isEmpty((CharSequence)stringValue)) {
            return null;
        }
        return Integer.valueOf(this.getStringValue(key));
    }

    public int getIntValue(String key, int defaultValue) {
        String stringValue = this.getStringValue(key);
        if (StringUtils.isEmpty((CharSequence)stringValue)) {
            return defaultValue;
        }
        return Integer.valueOf(stringValue);
    }

    public double getDoubleValue(String key) {
        return Double.valueOf(this.getStringValue(key));
    }

    public double getDoubleValue(String key, double defaultValue) {
        String stringValue = this.getStringValue(key);
        if (StringUtils.isEmpty((CharSequence)stringValue)) {
            return defaultValue;
        }
        return Double.valueOf(this.getStringValue(key));
    }

    public BigDecimal getDecimalValue(String key) {
        return new BigDecimal(this.getStringValue(key));
    }

    public BigDecimal getDecimalValue(String key, BigDecimal defaultValue) {
        String stringValue = this.getStringValue(key);
        if (StringUtils.isEmpty((CharSequence)stringValue)) {
            return defaultValue;
        }
        return new BigDecimal(this.getStringValue(key));
    }

    public Date getDateValue(String key) {
        return this.getDateValue(key, DEFAULT_DATE_FORMAT);
    }

    public Date getDateValue(String key, String format) {
        Object value = this.dataMap.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        String result = String.valueOf(value);
        try {
            return DateUtils.parseDate((String)result, (String[])new String[]{format});
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("\u65e0\u6cd5\u89e3\u6790\u7684\u65e5\u671f:" + result);
        }
    }

    public String getStringValue(String key) {
        Object value = this.dataMap.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return StringUtils.trimToEmpty((String)((String)value));
        }
        return String.valueOf(value);
    }

    public Object getValue(String key) {
        return this.dataMap.get(key);
    }
}

